/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xevent.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.xevent.packet.MessageEvent;
import org.jxmpp.JxmppContext;

public class MessageEventProvider
extends ExtensionElementProvider<MessageEvent> {
    @Override
    public MessageEvent parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        MessageEvent messageEvent = new MessageEvent();
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (parser.getName().equals("id")) {
                    messageEvent.setStanzaId(parser.nextText());
                }
                if (parser.getName().equals("composing")) {
                    messageEvent.setComposing(true);
                }
                if (parser.getName().equals("delivered")) {
                    messageEvent.setDelivered(true);
                }
                if (parser.getName().equals("displayed")) {
                    messageEvent.setDisplayed(true);
                }
                if (!parser.getName().equals("offline")) continue;
                messageEvent.setOffline(true);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("x")) continue;
            done = true;
        }
        return messageEvent;
    }
}

