/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdata.BooleanFormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.JidMultiFormField;
import org.jivesoftware.smackx.xdata.JidSingleFormField;
import org.jivesoftware.smackx.xdata.ListMultiFormField;
import org.jivesoftware.smackx.xdata.ListSingleFormField;
import org.jivesoftware.smackx.xdata.TextMultiFormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jxmpp.util.XmppDateTime;

public abstract class FormField
implements XmlElement {
    public static final String ELEMENT = "field";
    public static final String NAMESPACE = "jabber:x:data";
    public static final QName QNAME = new QName("jabber:x:data", "field");
    public static final String FORM_TYPE = "FORM_TYPE";
    private final String fieldName;
    private final String label;
    private final Type type;
    private final List<FormFieldChildElement> formFieldChildElements;
    private final MultiMap<QName, FormFieldChildElement> formFieldChildElementsMap;
    private final String description;
    private final boolean required;
    private transient List<CharSequence> rawValueCharSequences;
    protected transient List<XmlElement> extraXmlChildElements;

    private MultiMap<QName, FormFieldChildElement> createChildElementsMap() {
        MultiMap<QName, FormFieldChildElement> formFieldChildElementsMap = new MultiMap<QName, FormFieldChildElement>(this.formFieldChildElements.size());
        for (FormFieldChildElement formFieldChildElement : this.formFieldChildElements) {
            formFieldChildElementsMap.put(formFieldChildElement.getQName(), formFieldChildElement);
        }
        return formFieldChildElementsMap.asUnmodifiableMultiMap();
    }

    protected FormField(Builder<?, ?> builder) {
        this.fieldName = builder.fieldName;
        this.label = builder.label;
        this.type = builder.type;
        this.formFieldChildElements = builder.formFieldChildElements != null ? Collections.unmodifiableList(builder.formFieldChildElements) : Collections.emptyList();
        if (this.fieldName == null && this.type != Type.fixed) {
            throw new IllegalArgumentException("The variable can only be null if the form is of type fixed");
        }
        String description = null;
        boolean requiredElementAsChild = false;
        ArrayList values = new ArrayList(this.formFieldChildElements.size());
        for (FormFieldChildElement formFieldChildElement : this.formFieldChildElements) {
            if (formFieldChildElement instanceof Description) {
                description = ((Description)formFieldChildElement).getDescription();
                continue;
            }
            if (!(formFieldChildElement instanceof Required)) continue;
            requiredElementAsChild = true;
        }
        values.trimToSize();
        this.description = description;
        this.required = requiredElementAsChild;
        this.formFieldChildElementsMap = this.createChildElementsMap();
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Type getType() {
        if (this.type == null) {
            return Type.text_single;
        }
        return this.type;
    }

    public List<? extends CharSequence> getValues() {
        return this.getRawValueCharSequences();
    }

    public abstract List<Value> getRawValues();

    public final List<CharSequence> getRawValueCharSequences() {
        if (this.rawValueCharSequences == null) {
            List<Value> rawValues = this.getRawValues();
            this.rawValueCharSequences = new ArrayList<CharSequence>(rawValues.size());
            for (Value value : rawValues) {
                this.rawValueCharSequences.add(value.value);
            }
        }
        return this.rawValueCharSequences;
    }

    public boolean hasValueSet() {
        List<? extends CharSequence> values = this.getValues();
        return !values.isEmpty();
    }

    public List<String> getValuesAsString() {
        List<? extends CharSequence> valuesAsCharSequence = this.getValues();
        ArrayList<String> res = new ArrayList<String>(valuesAsCharSequence.size());
        for (CharSequence charSequence : valuesAsCharSequence) {
            res.add(charSequence.toString());
        }
        return res;
    }

    public String getFirstValue() {
        List<? extends CharSequence> values = this.getValues();
        if (values.isEmpty()) {
            return null;
        }
        return values.get(0).toString();
    }

    public Date getFirstValueAsDate() throws ParseException {
        String valueString = this.getFirstValue();
        if (valueString == null) {
            return null;
        }
        return XmppDateTime.parseXEP0082Date(valueString);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FormFieldChildElement getFormFieldChildElement(QName qname) {
        return this.formFieldChildElementsMap.getFirst(qname);
    }

    public List<FormFieldChildElement> getFormFieldChildElements(QName qname) {
        return this.formFieldChildElementsMap.getAll(qname);
    }

    public List<FormFieldChildElement> getFormFieldChildElements() {
        return this.formFieldChildElements;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public QName getQName() {
        return QNAME;
    }

    protected void populateExtraXmlChildElements() {
        List<Value> values = this.getRawValues();
        this.extraXmlChildElements = new ArrayList<XmlElement>(values.size());
        this.extraXmlChildElements.addAll(values);
    }

    @Override
    public final XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        return this.toXML(enclosingNamespace, true);
    }

    public final XmlStringBuilder toXML(XmlEnvironment enclosingNamespace, boolean includeType) {
        XmlStringBuilder buf = new XmlStringBuilder(this, enclosingNamespace);
        buf.optAttribute("label", this.getLabel());
        buf.optAttribute("var", this.getFieldName());
        if (includeType) {
            buf.attribute("type", this.getType(), Type.text_single);
        }
        if (this.extraXmlChildElements == null) {
            this.populateExtraXmlChildElements();
        }
        if (this.formFieldChildElements.isEmpty() && (this.extraXmlChildElements == null || this.extraXmlChildElements.isEmpty())) {
            buf.closeEmptyElement();
        } else {
            buf.rightAngleBracket();
            buf.optAppend(this.extraXmlChildElements);
            buf.append(this.formFieldChildElements);
            buf.closeElement(this);
        }
        return buf;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FormField)) {
            return false;
        }
        FormField other = (FormField)obj;
        return this.toXML().toString().equals(other.toXML().toString());
    }

    public int hashCode() {
        return this.toXML().toString().hashCode();
    }

    public static BooleanFormField.Builder booleanBuilder(String fieldName) {
        return new BooleanFormField.Builder(fieldName);
    }

    public static TextSingleFormField.Builder fixedBuilder() {
        return FormField.fixedBuilder(null);
    }

    public static TextSingleFormField.Builder fixedBuilder(String fieldName) {
        return new TextSingleFormField.Builder(fieldName, Type.fixed);
    }

    public static TextSingleFormField.Builder hiddenBuilder(String fieldName) {
        return new TextSingleFormField.Builder(fieldName, Type.hidden);
    }

    public static JidMultiFormField.Builder jidMultiBuilder(String fieldName) {
        return new JidMultiFormField.Builder(fieldName);
    }

    public static JidSingleFormField.Builder jidSingleBuilder(String fieldName) {
        return new JidSingleFormField.Builder(fieldName);
    }

    public static ListMultiFormField.Builder listMultiBuilder(String fieldName) {
        return new ListMultiFormField.Builder(fieldName);
    }

    public static ListSingleFormField.Builder listSingleBuilder(String fieldName) {
        return new ListSingleFormField.Builder(fieldName);
    }

    public static TextMultiFormField.Builder textMultiBuilder(String fieldName) {
        return new TextMultiFormField.Builder(fieldName);
    }

    public static TextSingleFormField.Builder textPrivateBuilder(String fieldName) {
        return new TextSingleFormField.Builder(fieldName, Type.text_private);
    }

    public static TextSingleFormField.Builder textSingleBuilder(String fieldName) {
        return new TextSingleFormField.Builder(fieldName, Type.text_single);
    }

    public static TextSingleFormField.Builder builder(String fieldName) {
        return FormField.textSingleBuilder(fieldName);
    }

    public static TextSingleFormField buildHiddenFormType(String formType) {
        return ((TextSingleFormField.Builder)FormField.hiddenBuilder(FORM_TYPE).setValue(formType)).build();
    }

    public <F extends FormField> F ifPossibleAs(Class<F> formFieldClass) {
        if (formFieldClass.isInstance(this)) {
            return (F)((FormField)formFieldClass.cast(this));
        }
        return null;
    }

    public <F extends FormField> F ifPossibleAsOrThrow(Class<F> formFieldClass) {
        F field2 = this.ifPossibleAs(formFieldClass);
        if (field2 == null) {
            throw new IllegalArgumentException();
        }
        return field2;
    }

    public TextSingleFormField asHiddenFormTypeFieldIfPossible() {
        TextSingleFormField textSingleFormField = this.ifPossibleAs(TextSingleFormField.class);
        if (textSingleFormField == null) {
            return null;
        }
        if (this.getType() != Type.hidden) {
            return null;
        }
        if (!this.getFieldName().equals(FORM_TYPE)) {
            return null;
        }
        return textSingleFormField;
    }

    public static abstract class Builder<F extends FormField, B extends Builder<?, ?>> {
        private final String fieldName;
        private final Type type;
        private String label;
        private List<FormFieldChildElement> formFieldChildElements;
        private boolean disallowType;
        private boolean disallowFurtherFormFieldChildElements;

        protected Builder(String fieldName, Type type) {
            if (StringUtils.isNullOrEmpty((CharSequence)fieldName) && type != Type.fixed) {
                throw new IllegalArgumentException("Fields of type " + String.valueOf((Object)type) + " must have a field name set");
            }
            this.fieldName = fieldName;
            this.type = type;
        }

        protected Builder(FormField formField) {
            this.fieldName = formField.fieldName;
            this.label = formField.label;
            this.type = formField.type;
            this.formFieldChildElements = CollectionUtil.newListWith(formField.formFieldChildElements);
        }

        public B setDescription(String description) {
            Description descriptionElement = new Description(description);
            this.setOnlyElement(descriptionElement);
            return this.getThis();
        }

        public B setLabel(String label) {
            this.label = Objects.requireNonNull(label, "label must not be null");
            return this.getThis();
        }

        public B setRequired() {
            return this.setRequired(true);
        }

        public B setRequired(boolean required) {
            if (required) {
                this.setOnlyElement(Required.INSTANCE);
            }
            return this.getThis();
        }

        public B addFormFieldChildElements(Collection<? extends FormFieldChildElement> formFieldChildElements) {
            for (FormFieldChildElement formFieldChildElement : formFieldChildElements) {
                this.addFormFieldChildElement(formFieldChildElement);
            }
            return this.getThis();
        }

        public B addFormFieldChildElement(FormFieldChildElement newFormFieldChildElement) {
            if (this.disallowFurtherFormFieldChildElements) {
                throw new IllegalArgumentException();
            }
            if (newFormFieldChildElement.requiresNoTypeSet() && this.type != null) {
                throw new IllegalArgumentException("Elements of type " + String.valueOf(newFormFieldChildElement.getClass()) + " can only be added to form fields where no type is set");
            }
            this.ensureThatFormFieldChildElementsIsSet();
            if (!this.formFieldChildElements.isEmpty() && newFormFieldChildElement.isExclusiveElement()) {
                throw new IllegalArgumentException("Elements of type " + String.valueOf(newFormFieldChildElement.getClass()) + " must be the only child elements of a form field.");
            }
            this.disallowType = this.disallowType || newFormFieldChildElement.requiresNoTypeSet();
            this.disallowFurtherFormFieldChildElements = newFormFieldChildElement.isExclusiveElement();
            this.formFieldChildElements.add(newFormFieldChildElement);
            for (FormFieldChildElement formFieldChildElement : this.formFieldChildElements) {
                try {
                    formFieldChildElement.checkConsistency(this);
                }
                catch (IllegalArgumentException e) {
                    this.formFieldChildElements.remove(newFormFieldChildElement);
                    throw e;
                }
            }
            return this.getThis();
        }

        protected abstract void resetInternal();

        public B reset() {
            this.resetInternal();
            if (this.formFieldChildElements == null) {
                return this.getThis();
            }
            this.formFieldChildElements = this.formFieldChildElements.stream().filter(f -> !(f instanceof Value)).collect(Collectors.toList());
            this.disallowFurtherFormFieldChildElements = false;
            this.disallowType = false;
            return this.getThis();
        }

        public abstract F build();

        public Type getType() {
            return this.type;
        }

        private void ensureThatFormFieldChildElementsIsSet() {
            if (this.formFieldChildElements == null) {
                this.formFieldChildElements = new ArrayList<FormFieldChildElement>(4);
            }
        }

        private <E extends FormFieldChildElement> void setOnlyElement(E element) {
            Class<?> elementClass = element.getClass();
            this.ensureThatFormFieldChildElementsIsSet();
            for (int i = 0; i < this.formFieldChildElements.size(); ++i) {
                if (!this.formFieldChildElements.get(i).getClass().equals(elementClass)) continue;
                this.formFieldChildElements.set(i, element);
                return;
            }
            this.addFormFieldChildElement(element);
        }

        public abstract B getThis();
    }

    public static enum Type {
        bool,
        fixed,
        hidden,
        jid_multi,
        jid_single,
        list_multi,
        list_single,
        text_multi,
        text_private,
        text_single;


        public String toString() {
            switch (this) {
                case bool: {
                    return "boolean";
                }
            }
            return this.name().replace('_', '-');
        }

        public static Type fromString(String string2) {
            if (string2 == null) {
                return null;
            }
            switch (string2) {
                case "boolean": {
                    return bool;
                }
            }
            string2 = string2.replace('-', '_');
            return Type.valueOf(string2);
        }
    }

    public static class Description
    extends StandardFormFieldChildElement {
        public static final String ELEMENT = "desc";
        public static final QName QNAME = new QName("jabber:x:data", "desc");
        private final String description;

        public Description(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public String getNamespace() {
            return FormField.NAMESPACE;
        }

        @Override
        public QName getQName() {
            return QNAME;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder(this, xmlEnvironment);
            xml.rightAngleBracket();
            xml.escape(this.description);
            xml.closeElement(this);
            return xml;
        }
    }

    public static final class Required
    extends StandardFormFieldChildElement {
        public static final Required INSTANCE = new Required();
        public static final String ELEMENT = "required";
        public static final QName QNAME = new QName("jabber:x:data", "required");

        private Required() {
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public String getNamespace() {
            return FormField.NAMESPACE;
        }

        @Override
        public QName getQName() {
            return QNAME;
        }

        @Override
        public boolean mustBeOnlyOfHisKind() {
            return true;
        }

        @Override
        public String toXML(XmlEnvironment xmlEnvironment) {
            return "<required/>";
        }
    }

    public static class Value
    implements XmlElement {
        public static final String ELEMENT = "value";
        public static final QName QNAME = new QName("jabber:x:data", "value");
        private final CharSequence value;

        public Value(CharSequence value) {
            this.value = value;
        }

        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public String getNamespace() {
            return FormField.NAMESPACE;
        }

        @Override
        public QName getQName() {
            return QNAME;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder(this, xmlEnvironment);
            xml.rightAngleBracket();
            xml.escape(this.value);
            return xml.closeElement(this);
        }

        public boolean equals(Object other) {
            return EqualsUtil.equals(this, other, (e, o) -> e.append(this.value, o.value));
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class Option
    implements XmlElement {
        public static final String ELEMENT = "option";
        public static final QName QNAME = new QName("jabber:x:data", "option");
        private final String label;
        private final Value value;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        public Option(String value) {
            this(null, value);
        }

        public Option(String label, String value) {
            this.label = label;
            this.value = new Value(value);
        }

        public Option(String label, Value value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public Value getValue() {
            return this.value;
        }

        public String getValueString() {
            return this.value.value.toString();
        }

        public String toString() {
            return this.getLabel();
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public String getNamespace() {
            return FormField.NAMESPACE;
        }

        @Override
        public QName getQName() {
            return QNAME;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder(this);
            xml.optAttribute("label", this.getLabel());
            xml.rightAngleBracket();
            xml.element("value", this.getValueString());
            xml.closeElement(this);
            return xml;
        }

        public boolean equals(Object obj) {
            return EqualsUtil.equals(this, obj, (e, o) -> e.append(this.value, o.value).append(this.label, o.label));
        }

        public int hashCode() {
            return this.hashCodeCache.getHashCode(c -> c.append(this.value).append(this.label));
        }
    }

    private static abstract class StandardFormFieldChildElement
    implements FormFieldChildElement {
        private StandardFormFieldChildElement() {
        }
    }
}

