/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns.minidns;

import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jivesoftware.smack.util.dns.SmackDaneVerifier;
import org.minidns.dane.DaneVerifier;
import org.minidns.dane.ExpectingTrustManager;

public class MiniDnsDaneVerifier
implements SmackDaneVerifier {
    private static final DaneVerifier VERIFIER = new DaneVerifier();
    private ExpectingTrustManager expectingTrustManager;

    MiniDnsDaneVerifier() {
    }

    @Override
    public void init(SSLContext context, KeyManager[] km, X509TrustManager tm, SecureRandom random) throws KeyManagementException {
        if (this.expectingTrustManager != null) {
            throw new IllegalStateException("DaneProvider was initialized before. Use newInstance() instead.");
        }
        this.expectingTrustManager = new ExpectingTrustManager(tm);
        context.init(km, new TrustManager[]{this.expectingTrustManager}, random);
    }

    @Override
    public void finish(SSLSession sslSession) throws CertificateException {
        if (VERIFIER.verify(sslSession)) {
            return;
        }
        if (this.expectingTrustManager.hasException()) {
            throw this.expectingTrustManager.getException();
        }
    }
}

