/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.SequenceCollector;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;

public class EagerPushEvaluator
implements SequenceEvaluator {
    final PushEvaluator pusher;

    public EagerPushEvaluator(PushEvaluator select) {
        this.pusher = select;
    }

    @Override
    public Sequence evaluate(XPathContext context) throws XPathException {
        try {
            Controller controller = context.getController();
            SequenceCollector seq = controller.allocateSequenceOutputter();
            ComplexContentOutputter out = new ComplexContentOutputter(seq);
            out.open();
            TailCall tail = this.pusher.processLeavingTail(out, context);
            Expression.dispatchTailCall(tail);
            out.close();
            return seq.getSequence();
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
    }
}

