/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFText;

public class PDFString
extends PDFObject {
    private String text;
    private byte[] binary;

    public PDFString(String text) {
        this.text = text;
    }

    public PDFString(byte[] data) {
        this.binary = (byte[])data.clone();
    }

    public String getString() {
        if (this.text == null) {
            String encoding = "ISO-8859-1";
            int start = 0;
            if (this.binary.length > 2) {
                if (this.binary[0] == -1 && this.binary[1] == -2) {
                    encoding = "UTF-16LE";
                    start = 2;
                } else if (this.binary[0] == -2 && this.binary[1] == -1) {
                    encoding = "UTF-16BE";
                    start = 2;
                }
            }
            try {
                this.text = new String(this.binary, start, this.binary.length - start, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Incompatible JVM: " + e.getMessage());
            }
        }
        return this.text;
    }

    public byte[] getBinary() {
        if (this.binary == null) {
            boolean unicode16 = false;
            char[] chars = this.text.toCharArray();
            int length = chars.length;
            for (int i = 0; i < length; ++i) {
                if (chars[i] <= '\u00ff') continue;
                unicode16 = true;
                break;
            }
            try {
                if (unicode16) {
                    byte[] data = this.text.getBytes("UTF-16BE");
                    byte[] binary = new byte[data.length + 2];
                    binary[0] = -2;
                    binary[1] = -1;
                    System.arraycopy(data, 0, binary, 2, data.length);
                } else {
                    byte[] data = this.text.getBytes("ISO-8859-1");
                    byte[] binary = new byte[data.length];
                    System.arraycopy(data, 0, binary, 0, data.length);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Incompatible JVM: " + e.getMessage());
            }
        }
        if (this.binary == null) {
            return new byte[0];
        }
        return (byte[])this.binary.clone();
    }

    public int output(OutputStream stream) throws IOException {
        CountingOutputStream cout = new CountingOutputStream(stream);
        PDFDocument.flushTextBuffer((StringBuilder)new StringBuilder(PDFText.escapeText((String)this.getString())), (OutputStream)cout);
        return cout.getCount();
    }

    public static boolean isUSASCII(byte[] data) {
        int c = data.length;
        for (int i = 0; i < c; ++i) {
            if ((data[i] & 0xFF) < 128) continue;
            return false;
        }
        return true;
    }
}

