/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans.rules;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.BuiltInRuleSet;

public class DeepCopyRuleSet
implements BuiltInRuleSet {
    private static DeepCopyRuleSet THE_INSTANCE = new DeepCopyRuleSet();

    public static DeepCopyRuleSet getInstance() {
        return THE_INSTANCE;
    }

    private DeepCopyRuleSet() {
    }

    @Override
    public void process(Item item, ParameterSet parameters, ParameterSet tunnelParams, XPathContext context, Location locationId) throws XPathException {
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 9: {
                    node.copy(context.getReceiver(), 2, locationId);
                    return;
                }
                case 1: {
                    node.copy(context.getReceiver(), 2, locationId);
                    return;
                }
                case 3: {
                    context.getReceiver().characters(item.getStringValueCS(), locationId, 0);
                    return;
                }
                case 2: 
                case 7: 
                case 8: 
                case 13: {
                    node.copy(context.getReceiver(), 0, locationId);
                    return;
                }
            }
        } else {
            context.getReceiver().append(item, locationId, 0);
        }
    }

    @Override
    public int[] getActionForParentNodes(int nodeKind) {
        return new int[]{1};
    }
}

