/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.Optional;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.TupleItemType;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class MapType
extends AnyFunctionType {
    public static final MapType ANY_MAP_TYPE = new MapType(BuiltInAtomicType.ANY_ATOMIC, SequenceType.ANY_SEQUENCE);
    public static final MapType EMPTY_MAP_TYPE = new MapType(BuiltInAtomicType.ANY_ATOMIC, SequenceType.ANY_SEQUENCE, true);
    public static final SequenceType OPTIONAL_MAP_ITEM = SequenceType.makeSequenceType(ANY_MAP_TYPE, 24576);
    public static final SequenceType SINGLE_MAP_ITEM = SequenceType.makeSequenceType(ANY_MAP_TYPE, 16384);
    public static final SequenceType SEQUENCE_OF_MAPS = SequenceType.makeSequenceType(ANY_MAP_TYPE, 57344);
    private AtomicType keyType;
    private SequenceType valueType;
    private boolean mustBeEmpty;

    public MapType(AtomicType keyType, SequenceType valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.mustBeEmpty = false;
    }

    public MapType(AtomicType keyType, SequenceType valueType, boolean mustBeEmpty) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.mustBeEmpty = mustBeEmpty;
    }

    @Override
    public Genre getGenre() {
        return Genre.MAP;
    }

    public AtomicType getKeyType() {
        return this.keyType;
    }

    public SequenceType getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isMapType() {
        return true;
    }

    @Override
    public boolean isArrayType() {
        return false;
    }

    @Override
    public boolean isAtomizable(TypeHierarchy th) {
        return false;
    }

    @Override
    public boolean matches(Item item, TypeHierarchy th) {
        if (!(item instanceof MapItem)) {
            return false;
        }
        if (((MapItem)item).isEmpty()) {
            return true;
        }
        if (this.mustBeEmpty) {
            return false;
        }
        if (this == ANY_MAP_TYPE) {
            return true;
        }
        return ((MapItem)item).conforms(this.keyType, this.valueType, th);
    }

    public int getArity() {
        return 1;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 16384)};
    }

    @Override
    public SequenceType getResultType() {
        if (Cardinality.allowsZero(this.valueType.getCardinality())) {
            return this.valueType;
        }
        return SequenceType.makeSequenceType(this.valueType.getPrimaryType(), Cardinality.union(this.valueType.getCardinality(), 8192));
    }

    @Override
    public String toString() {
        if (this == ANY_MAP_TYPE) {
            return "map(*)";
        }
        if (this == EMPTY_MAP_TYPE) {
            return "map(\u00b0)";
        }
        FastStringBuffer sb = new FastStringBuffer(100);
        sb.append("map(");
        sb.append(this.keyType.toString());
        sb.append(", ");
        sb.append(this.valueType.toString());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String toExportString() {
        if (this == ANY_MAP_TYPE) {
            return "map(*)";
        }
        if (this == EMPTY_MAP_TYPE) {
            return "map(\u00b0)";
        }
        FastStringBuffer sb = new FastStringBuffer(100);
        sb.append("map(");
        sb.append(this.keyType.toExportString());
        sb.append(", ");
        sb.append(this.valueType.toExportString());
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MapType) {
            MapType f2 = (MapType)other;
            return this.keyType.equals(f2.keyType) && this.valueType.equals(f2.valueType) && this.mustBeEmpty == f2.mustBeEmpty;
        }
        return false;
    }

    public int hashCode() {
        return this.keyType.hashCode() ^ this.valueType.hashCode();
    }

    @Override
    public int relationship(FunctionItemType other, TypeHierarchy th) {
        if (other == AnyFunctionType.getInstance()) {
            return 2;
        }
        if (this.equals(other)) {
            return 0;
        }
        if (other == ANY_MAP_TYPE) {
            return 2;
        }
        if (other.isArrayType()) {
            return 4;
        }
        if (other instanceof TupleItemType) {
            return TypeHierarchy.inverseRelationship(other.relationship(this, th));
        }
        if (other instanceof MapType) {
            MapType f2 = (MapType)other;
            int keyRel = th.relationship(this.keyType, f2.keyType);
            if (keyRel == 4) {
                return 3;
            }
            int valueRel = th.sequenceTypeRelationship(this.valueType, f2.valueType);
            if (valueRel == 4) {
                return 3;
            }
            if (keyRel == valueRel) {
                return keyRel;
            }
            if (!(keyRel != 0 && keyRel != 1 || valueRel != 0 && valueRel != 1)) {
                return 1;
            }
            if (!(keyRel != 0 && keyRel != 2 || valueRel != 0 && valueRel != 2)) {
                return 2;
            }
            return 3;
        }
        int rel = 4;
        return rel;
    }

    @Override
    public Optional<String> explainMismatch(Item item, TypeHierarchy th) {
        if (item instanceof MapItem) {
            for (KeyValuePair kvp : ((MapItem)item).keyValuePairs()) {
                if (!this.keyType.matches(kvp.key, th)) {
                    String s2 = "The map contains a key (" + kvp.key + ") of type " + kvp.key.getItemType() + " that is not an instance of the required type " + this.keyType;
                    return Optional.of(s2);
                }
                try {
                    if (this.valueType.matches(kvp.value, th)) continue;
                    String s3 = "The map contains an entry with key (" + kvp.key + ") whose corresponding value (" + Err.depictSequence(kvp.value) + ") is not an instance of the required type " + this.valueType;
                    Optional<String> more = this.valueType.explainMismatch(kvp.value, th);
                    if (more.isPresent()) {
                        s3 = s3 + ". " + more.get();
                    }
                    return Optional.of(s3);
                }
                catch (XPathException xPathException) {
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public Expression makeFunctionSequenceCoercer(Expression exp, RoleDiagnostic role) throws XPathException {
        Expression result = exp;
        return result;
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType knownToBe, int targetVersion) throws XPathException {
        if (this == ANY_MAP_TYPE) {
            return "return SaxonJS.U.isMap(item)";
        }
        FastStringBuffer fsb = new FastStringBuffer(256);
        fsb.append("function k(item) {" + this.keyType.generateJavaScriptItemTypeTest(BuiltInAtomicType.ANY_ATOMIC, targetVersion) + "};");
        fsb.append("function v(item) {" + this.valueType.getPrimaryType().generateJavaScriptItemTypeTest(AnyItemType.getInstance(), targetVersion) + "};");
        int card = this.valueType.getCardinality();
        fsb.append(Cardinality.generateJavaScriptChecker(card));
        if (targetVersion == 1) {
            fsb.append("return SaxonJS.U.isMap(item) && item.conforms(k, v, c);");
        } else {
            fsb.append("return SaxonJS.U.isConstrainedMap(item, k, v, c);");
        }
        return fsb.toString();
    }
}

