/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class BlockCommentPosition {
    private BlockCommentPosition() {
    }

    public static boolean isOnType(DetailAST blockComment) {
        return BlockCommentPosition.isOnClass(blockComment) || BlockCommentPosition.isOnInterface(blockComment) || BlockCommentPosition.isOnEnum(blockComment) || BlockCommentPosition.isOnAnnotationDef(blockComment);
    }

    public static boolean isOnClass(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainToken(blockComment, 14, 69) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 14) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 14);
    }

    public static boolean isOnInterface(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainToken(blockComment, 15, 71) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 15) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 15);
    }

    public static boolean isOnEnum(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainToken(blockComment, 154, 153) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 154) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 154);
    }

    public static boolean isOnAnnotationDef(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainToken(blockComment, 157, 170) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 157) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 157);
    }

    public static boolean isOnMember(DetailAST blockComment) {
        return BlockCommentPosition.isOnMethod(blockComment) || BlockCommentPosition.isOnField(blockComment) || BlockCommentPosition.isOnConstructor(blockComment) || BlockCommentPosition.isOnEnumConstant(blockComment) || BlockCommentPosition.isOnAnnotationField(blockComment);
    }

    public static boolean isOnMethod(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainClassMember(blockComment, 9) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 9) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 9);
    }

    public static boolean isOnField(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainClassMember(blockComment, 10) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 10) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 10);
    }

    public static boolean isOnConstructor(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainToken(blockComment, 8, 58) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 8) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 8);
    }

    public static boolean isOnEnumConstant(DetailAST blockComment) {
        boolean isOnPlainConst = blockComment.getParent() != null && blockComment.getParent().getType() == 155 && BlockCommentPosition.getPrevSiblingSkipComments(blockComment).getType() == 158 && BlockCommentPosition.getPrevSiblingSkipComments(blockComment).getChildCount() == 0;
        boolean isOnConstWithAnnotation = !isOnPlainConst && blockComment.getParent() != null && blockComment.getParent().getType() == 159 && blockComment.getParent().getParent().getParent().getType() == 155;
        return isOnPlainConst || isOnConstWithAnnotation;
    }

    public static boolean isOnAnnotationField(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainClassMember(blockComment, 161) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 161) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 161);
    }

    private static boolean isOnPlainToken(DetailAST blockComment, int parentTokenType, int nextTokenType) {
        return blockComment.getParent() != null && blockComment.getParent().getType() == parentTokenType && BlockCommentPosition.getPrevSiblingSkipComments(blockComment).getChildCount() == 0 && BlockCommentPosition.getNextSiblingSkipComments(blockComment).getType() == nextTokenType;
    }

    private static boolean isOnTokenWithModifiers(DetailAST blockComment, int tokenType) {
        return blockComment.getParent() != null && blockComment.getParent().getType() == 5 && blockComment.getParent().getParent().getType() == tokenType && BlockCommentPosition.getPrevSiblingSkipComments(blockComment) == null;
    }

    private static boolean isOnTokenWithAnnotation(DetailAST blockComment, int tokenType) {
        return blockComment.getParent() != null && blockComment.getParent().getType() == 159 && BlockCommentPosition.getPrevSiblingSkipComments(blockComment.getParent()) == null && blockComment.getParent().getParent().getType() == 5 && blockComment.getParent().getParent().getParent().getType() == tokenType && BlockCommentPosition.getPrevSiblingSkipComments(blockComment) == null;
    }

    private static boolean isOnPlainClassMember(DetailAST blockComment, int memberType) {
        DetailAST parent;
        for (parent = blockComment.getParent(); parent != null && parent.getType() == 59; parent = parent.getParent()) {
        }
        return parent != null && parent.getType() == 13 && parent.getParent().getType() == memberType && parent.getPreviousSibling().getChildCount() == 0;
    }

    private static DetailAST getNextSiblingSkipComments(DetailAST node) {
        DetailAST result = node.getNextSibling();
        while (result.getType() == 144 || result.getType() == 145) {
            result = result.getNextSibling();
        }
        return result;
    }

    private static DetailAST getPrevSiblingSkipComments(DetailAST node) {
        DetailAST result;
        for (result = node.getPreviousSibling(); result != null && (result.getType() == 144 || result.getType() == 145); result = result.getPreviousSibling()) {
        }
        return result;
    }
}

