/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a1\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a1\u0010\f\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ljavax/crypto/SecretKey;", "secret", "", "label", "seed", "", "requiredLength", "PRF", "(Ljavax/crypto/SecretKey;[B[BI)[B", "Ljavax/crypto/Mac;", "mac", "secretKey", "P_hash", "([BLjavax/crypto/Mac;Ljavax/crypto/SecretKey;I)[B", "ktor-network-tls"})
public final class HashesKt {
    @NotNull
    public static final byte[] PRF(@NotNull SecretKey secret, @NotNull byte[] label, @NotNull byte[] seed, int requiredLength) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        byte[] byArray = ArraysKt.plus((byte[])label, (byte[])seed);
        Mac mac = Mac.getInstance(secret.getAlgorithm());
        Intrinsics.checkNotNullExpressionValue((Object)mac, (String)"getInstance(...)");
        return HashesKt.P_hash(byArray, mac, secret, requiredLength);
    }

    public static /* synthetic */ byte[] PRF$default(SecretKey secretKey, byte[] byArray, byte[] byArray2, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 12;
        }
        return HashesKt.PRF(secretKey, byArray, byArray2, n);
    }

    private static final byte[] P_hash(byte[] seed, Mac mac, SecretKey secretKey, int requiredLength) {
        if (!(requiredLength >= 12)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] A = seed;
        byte[] result = new byte[]{};
        while (result.length < requiredLength) {
            mac.reset();
            mac.init(secretKey);
            mac.update(A);
            A = mac.doFinal();
            mac.reset();
            mac.init(secretKey);
            mac.update(A);
            mac.update(seed);
            byte[] byArray = mac.doFinal();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            result = ArraysKt.plus((byte[])result, (byte[])byArray);
        }
        byte[] byArray = Arrays.copyOf(result, requiredLength);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    static /* synthetic */ byte[] P_hash$default(byte[] byArray, Mac mac, SecretKey secretKey, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 12;
        }
        return HashesKt.P_hash(byArray, mac, secretKey, n);
    }
}

