/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.highlight;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.DaemonTooltipsUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.LocalHistory;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.navigation.JBProtocolRevisionResolver;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.actions.QodanaRootIgnoreIntention;
import org.jetbrains.qodana.actions.QodanaSuppressableProblemGroup;
import org.jetbrains.qodana.actions.StopShowingReportAction;
import org.jetbrains.qodana.coroutines.QodanaDispatchersKt;
import org.jetbrains.qodana.extensions.QodanaHighlightInfoTypeProvider;
import org.jetbrains.qodana.extensions.QodanaHighlightingSupportInfoProvider;
import org.jetbrains.qodana.extensions.RepositoryRevisionProvider;
import org.jetbrains.qodana.highlight.HighlightedReportData;
import org.jetbrains.qodana.highlight.HighlightedReportState;
import org.jetbrains.qodana.highlight.HighlightedReportStateKt;
import org.jetbrains.qodana.highlight.ProblemWithRange;
import org.jetbrains.qodana.highlight.QodanaHighlightedReportService;
import org.jetbrains.qodana.highlight.QodanaHighlightingInfoType;
import org.jetbrains.qodana.highlight.QodanaHighlightingPassState;
import org.jetbrains.qodana.highlight.QodanaLocalDocumentData;
import org.jetbrains.qodana.highlight.QodanaRangeCalculator;
import org.jetbrains.qodana.highlight.QodanaReportHighlightingPassKt;
import org.jetbrains.qodana.highlight.QodanaRevisionData;
import org.jetbrains.qodana.highlight.QodanaRevisionDataKt;
import org.jetbrains.qodana.highlight.SarifInspectionDescriptionLinkHandler;
import org.jetbrains.qodana.highlight.SarifProblemPropertiesUpdater;
import org.jetbrains.qodana.problem.SarifProblem;
import org.jetbrains.qodana.problem.SarifProblemKt;
import org.jetbrains.qodana.problem.SarifProblemProperties;
import org.jetbrains.qodana.settings.ConfigExcludeItem;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J1\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010!\u001a\u00020\u00152\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0002J\u001e\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u000fH\u0002J\u001c\u0010'\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J&\u0010*\u001a\u0004\u0018\u00010\u00102\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u00100\u001a\u00020\u0019H\u0002J\b\u00101\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/qodana/highlight/QodanaReportHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "myFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "reportService", "Lorg/jetbrains/qodana/highlight/QodanaHighlightedReportService;", "passState", "Lorg/jetbrains/qodana/highlight/QodanaHighlightingPassState;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/qodana/highlight/QodanaHighlightedReportService;Lorg/jetbrains/qodana/highlight/QodanaHighlightingPassState;)V", "myHighlightInfos", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "enabledInspections", "", "", "doCollectInformation", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isDataCorrect", "", "data", "Lorg/jetbrains/qodana/highlight/QodanaRevisionData;", "localIdeRunTimestamp", "", "revisionIds", "(Lorg/jetbrains/qodana/highlight/QodanaRevisionData;Ljava/lang/Long;Ljava/util/Set;)Z", "putLocalRunData", "putRevisionData", "updateProblemsRanges", "highlightedReportData", "Lorg/jetbrains/qodana/highlight/HighlightedReportData;", "problemsWithRanges", "Lorg/jetbrains/qodana/highlight/ProblemWithRange;", "getPsiFileByRevision", "revisionId", "getPsiFileForLastRevision", "buildHighlightInfo", "problem", "Lorg/jetbrains/qodana/problem/SarifProblem;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "suppressToolId", "updateWasAnalyzedOnceStatus", "doApplyInformationToEditor", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaReportHighlightingPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaReportHighlightingPass.kt\norg/jetbrains/qodana/highlight/QodanaReportHighlightingPass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,266:1\n1#2:267\n1#2:291\n1#2:326\n1#2:339\n774#3:268\n865#3,2:269\n774#3:271\n865#3:272\n1755#3,3:273\n866#3:276\n1557#3:277\n1628#3,3:278\n1611#3,9:281\n1863#3:290\n1864#3:292\n1620#3:293\n1734#3,3:294\n1279#3,2:297\n1293#3,4:299\n1557#3:303\n1628#3,3:304\n1734#3,3:307\n1611#3,9:316\n1863#3:325\n1864#3:327\n1620#3:328\n1611#3,9:329\n1863#3:338\n1864#3:340\n1620#3:341\n774#3:342\n865#3,2:343\n10065#4:310\n10487#4,5:311\n*S KotlinDebug\n*F\n+ 1 QodanaReportHighlightingPass.kt\norg/jetbrains/qodana/highlight/QodanaReportHighlightingPass\n*L\n98#1:291\n230#1:326\n234#1:339\n65#1:268\n65#1:269,2\n66#1:271\n66#1:272\n67#1:273,3\n66#1:276\n74#1:277\n74#1:278,3\n98#1:281,9\n98#1:290\n98#1:292\n98#1:293\n121#1:294,3\n139#1:297,2\n139#1:299,4\n147#1:303\n147#1:304,3\n213#1:307,3\n230#1:316,9\n230#1:325\n230#1:327\n230#1:328\n234#1:329,9\n234#1:338\n234#1:340\n234#1:341\n242#1:342\n242#1:343,2\n223#1:310\n223#1:311,5\n*E\n"})
public final class QodanaReportHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final Editor editor;
    @NotNull
    private final QodanaHighlightedReportService reportService;
    @NotNull
    private final QodanaHighlightingPassState passState;
    @NotNull
    private final AtomicReference<List<HighlightInfo>> myHighlightInfos;
    @NotNull
    private final AtomicReference<Set<String>> enabledInspections;

    public QodanaReportHighlightingPass(@NotNull PsiFile myFile, @NotNull Editor editor, @NotNull QodanaHighlightedReportService reportService, @NotNull QodanaHighlightingPassState passState) {
        Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)reportService, (String)"reportService");
        Intrinsics.checkNotNullParameter((Object)passState, (String)"passState");
        super(myFile.getProject(), editor.getDocument());
        this.myFile = myFile;
        this.editor = editor;
        this.reportService = reportService;
        this.passState = passState;
        this.myHighlightInfos = new AtomicReference<List>(CollectionsKt.emptyList());
        this.enabledInspections = new AtomicReference<Set>(SetsKt.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        VirtualFile virtualFile;
        block20: {
            block19: {
                Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
                VirtualFile virtualFile2 = this.myFile.getVirtualFile();
                if (virtualFile2 == null) {
                    return;
                }
                virtualFile = virtualFile2;
                Project project = this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                object = ProjectUtil.guessProjectDir((Project)project);
                if (object == null) break block19;
                VirtualFile it = object;
                boolean bl = false;
                String string = it.getCanonicalPath();
                if (string == null) {
                    String string2 = it.getPath();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                }
                Path path = Paths.get(string, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                object = path;
                if (path != null) break block20;
            }
            return;
        }
        Object projectDir = object;
        this.myHighlightInfos.set(CollectionsKt.emptyList());
        List highlights = new ArrayList();
        HighlightedReportData highlightedReportData2 = HighlightedReportStateKt.getHighlightedReportDataIfSelected((HighlightedReportState)this.reportService.getHighlightedReportState().getValue());
        if (highlightedReportData2 == null) {
            return;
        }
        HighlightedReportData highlightedReportData3 = highlightedReportData2;
        String string = virtualFile.getCanonicalPath();
        if (string == null) {
            String string3 = virtualFile.getPath();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        }
        String virtualFilePath = string;
        Path path = Paths.get(virtualFilePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Iterable bl = HighlightedReportData.getRelevantProblemsByFilePath$default(highlightedReportData3, (Path)projectDir, path, false, 4, null);
        boolean $i$f$filter = false;
        void var10_12 = $this$filter$iv;
        Iterable<Object> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SarifProblem it = (SarifProblem)element$iv$iv;
            boolean bl2 = false;
            if (!it.getHasRange()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl3;
            block18: {
                SarifProblem problem = (SarifProblem)element$iv$iv;
                boolean bl4 = false;
                Iterable $this$any$iv = (Iterable)highlightedReportData3.getExcludedDataFlow().getValue();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConfigExcludeItem data = (ConfigExcludeItem)element$iv;
                        boolean bl5 = false;
                        if (!data.isRelatedToProblem(problem)) continue;
                        bl3 = true;
                        break block18;
                    }
                    bl3 = false;
                }
            }
            boolean bl6 = !bl3;
            if (!bl6) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relevantProblems = (List)destination$iv$iv;
        if (relevantProblems.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = relevantProblems;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            SarifProblem bl4 = (SarifProblem)item$iv$iv2;
            collection = destination$iv$iv2;
            boolean bl7 = false;
            collection.add(it.getRevisionId());
        }
        Set revisionIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        HighlightedReportData.IdeRunData ideRunData = highlightedReportData3.getIdeRunData();
        Long localIdeRunTimestamp = ideRunData != null ? ideRunData.getIdeRunTimestamp() : null;
        QodanaRevisionData data = (QodanaRevisionData)this.editor.getDocument().getUserData(QodanaRevisionDataKt.getQODANA_REVISION_DATA());
        if (!this.isDataCorrect(data, localIdeRunTimestamp, revisionIds)) {
            BuildersKt.launch$default((CoroutineScope)this.passState.getScope(), (CoroutineContext)QodanaDispatchersKt.getQodanaDispatchers().getDefault(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, localIdeRunTimestamp, (Set<String>)revisionIds, null){
                int label;
                final /* synthetic */ QodanaReportHighlightingPass this$0;
                final /* synthetic */ Long $localIdeRunTimestamp;
                final /* synthetic */ Set<String> $revisionIds;
                {
                    this.this$0 = $receiver;
                    this.$localIdeRunTimestamp = $localIdeRunTimestamp;
                    this.$revisionIds = $revisionIds;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Project project = QodanaReportHighlightingPass.access$getMyProject$p$s1464811777(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getMyProject$p$s1464811777(...)");
                            Object[] objectArray = new Object[]{QodanaReportHighlightingPass.access$getMyFile$p(this.this$0).getName()};
                            String string = QodanaBundle.message("progress.title.qodana.highlight.calc", objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            this.label = 1;
                            Object object3 = TasksKt.withBackgroundProgress((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$localIdeRunTimestamp, this.this$0, this.$revisionIds, null){
                                int label;
                                final /* synthetic */ Long $localIdeRunTimestamp;
                                final /* synthetic */ QodanaReportHighlightingPass this$0;
                                final /* synthetic */ Set<String> $revisionIds;
                                {
                                    this.$localIdeRunTimestamp = $localIdeRunTimestamp;
                                    this.this$0 = $receiver;
                                    this.$revisionIds = $revisionIds;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            if (this.$localIdeRunTimestamp != null) {
                                                QodanaReportHighlightingPass.access$putLocalRunData(this.this$0, this.$localIdeRunTimestamp);
                                            } else {
                                                QodanaReportHighlightingPass.access$putRevisionData(this.this$0, this.$revisionIds);
                                            }
                                            DaemonCodeAnalyzer.getInstance((Project)QodanaReportHighlightingPass.access$getMyProject$p$s1464811777(this.this$0)).restart(QodanaReportHighlightingPass.access$getMyFile$p(this.this$0));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        Document document = this.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        QodanaRangeCalculator rangesCalculator = new QodanaRangeCalculator(project, this.myFile, document, highlightedReportData3);
        QodanaRevisionData qodanaRevisionData = data;
        Intrinsics.checkNotNull((Object)qodanaRevisionData);
        List<ProblemWithRange> relevantProblemsWithRanges = rangesCalculator.calculateTextRanges$intellij_qodana(relevantProblems, qodanaRevisionData);
        Iterable $i$f$mapTo22 = relevantProblemsWithRanges;
        collection = highlights;
        boolean $i$f$mapNotNull = false;
        item$iv$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            HighlightInfo it$iv$iv;
            String toolId;
            TextRange range;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl8 = false;
            ProblemWithRange problemWithRange = (ProblemWithRange)element$iv$iv;
            boolean bl9 = false;
            SarifProblem problem = problemWithRange.component1();
            if (this.buildHighlightInfo(problem, range = problemWithRange.component2(), toolId = highlightedReportData3.getInspectionsInfoProvider().getSuppressIdByInspection(problem.getInspectionId())) == null) continue;
            boolean bl10 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        collection.addAll((List)destination$iv$iv3);
        if (virtualFile.isInLocalFileSystem()) {
            this.updateProblemsRanges(highlightedReportData3, relevantProblemsWithRanges);
        }
        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ QodanaReportHighlightingPass this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = QodanaReportHighlightingPass.access$getMyProject$p$s1464811777(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"access$getMyProject$p$s1464811777(...)");
                        this.label = 1;
                        v1 = QodanaHighlightingSupportInfoProvider.Companion.getEnabledInspections(v0, (Continuation<? super Set<String>>)((Continuation)this));
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        inspections = (Set)v1;
                        QodanaReportHighlightingPass.access$getEnabledInspections$p(this.this$0).set(inspections);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        this.myHighlightInfos.set(highlights);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDataCorrect(QodanaRevisionData data, Long localIdeRunTimestamp, Set<String> revisionIds) {
        QodanaRevisionData qodanaRevisionData = data;
        if (qodanaRevisionData == null) {
            return false;
        }
        if (qodanaRevisionData instanceof QodanaRevisionData.VCSInfo) {
            PsiFile it;
            if (localIdeRunTimestamp != null) return false;
            if (!Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)((QodanaRevisionData.VCSInfo)data).getRevisionPsiFiles().keySet()), revisionIds)) return false;
            Iterable $this$all$iv = CollectionsKt.filterNotNull((Iterable)CollectionsKt.toSet((Iterable)((QodanaRevisionData.VCSInfo)data).getRevisionPsiFiles().values()));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                it = (PsiFile)element$iv;
                boolean bl = false;
            } while (it.isValid());
            return false;
        }
        if (!(qodanaRevisionData instanceof QodanaRevisionData.LocalInfo)) throw new NoWhenBranchMatchedException();
        Long l = localIdeRunTimestamp;
        if (l == null) return false;
        if (((QodanaRevisionData.LocalInfo)data).getLocalDocumentData().getTimestamp() != l.longValue()) return false;
        return true;
    }

    private final void putLocalRunData(long localIdeRunTimestamp) {
        LocalHistory localHistory = LocalHistory.Companion.getInstance();
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        byte[] byArray = localHistory.getByteContent(virtualFile, new FileRevisionTimestampComparator(localIdeRunTimestamp){
            final /* synthetic */ long $localIdeRunTimestamp;
            {
                this.$localIdeRunTimestamp = $localIdeRunTimestamp;
            }

            public final boolean isSuitable(long t2) {
                return t2 <= this.$localIdeRunTimestamp;
            }
        });
        if (byArray == null) {
            byArray = new byte[]{};
        }
        byte[] revisionFileContent2 = byArray;
        String text2 = ((Object)LoadTextUtil.getTextByBinaryPresentation((byte[])revisionFileContent2, (VirtualFile)this.myFile.getVirtualFile(), (boolean)false, (boolean)false)).toString();
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text2);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        Document createdDocument = document;
        this.editor.getDocument().putUserData(QodanaRevisionDataKt.getQODANA_REVISION_DATA(), (Object)new QodanaRevisionData.LocalInfo(new QodanaLocalDocumentData(localIdeRunTimestamp, createdDocument)));
    }

    /*
     * WARNING - void declaration
     */
    private final void putRevisionData(Set<String> revisionIds) {
        Iterable $this$associateWith$iv = revisionIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string = (String)element$iv$iv;
            Object t2 = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            PsiFile psiFile2 = this.getPsiFileByRevision(this.myFile, (String)it);
            if (psiFile2 == null) {
                psiFile2 = this.getPsiFileForLastRevision(this.myFile);
            }
            PsiFile psiFile3 = psiFile2;
            map2.put(t2, psiFile3);
        }
        Map psiFiles = result$iv;
        this.editor.getDocument().putUserData(QodanaRevisionDataKt.getQODANA_REVISION_DATA(), (Object)new QodanaRevisionData.VCSInfo(psiFiles));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateProblemsRanges(HighlightedReportData highlightedReportData2, List<ProblemWithRange> problemsWithRanges) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = problemsWithRanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SarifProblemPropertiesUpdater sarifProblemPropertiesUpdater;
            ProblemWithRange problemWithRange = (ProblemWithRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SarifProblem problem = problemWithRange.component1();
            TextRange textRange = problemWithRange.component2();
            if (textRange == null) {
                sarifProblemPropertiesUpdater = new SarifProblemPropertiesUpdater(problem, (Function1<? super SarifProblemProperties, SarifProblemProperties>)((Function1)QodanaReportHighlightingPass::updateProblemsRanges$lambda$10$lambda$8));
            } else {
                int line = this.getDocument().getLineNumber(textRange.getStartOffset());
                int lineStartOffset = this.getDocument().getLineStartOffset(line);
                int column = textRange.getStartOffset() - lineStartOffset;
                sarifProblemPropertiesUpdater = new SarifProblemPropertiesUpdater(problem, (Function1<? super SarifProblemProperties, SarifProblemProperties>)((Function1)arg_0 -> QodanaReportHighlightingPass.updateProblemsRanges$lambda$10$lambda$9(line, column, arg_0)));
            }
            collection.add(sarifProblemPropertiesUpdater);
        }
        List propertiesUpdaters = (List)destination$iv$iv;
        highlightedReportData2.updateProblemsProperties(propertiesUpdaters);
    }

    private final PsiFile getPsiFileByRevision(PsiFile myFile, String revisionId) {
        PsiFile psiFile2;
        if (revisionId == null) {
            return null;
        }
        String string = myFile.getVirtualFile().getCanonicalPath();
        if (string == null) {
            return null;
        }
        String path = string;
        VirtualFile virtualFile = JBProtocolRevisionResolver.processResolvers((Project)this.myProject, (String)path, (String)revisionId);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile revisionFile = virtualFile;
        PsiFile psiFile3 = psiFile2 = (PsiFile)ActionsKt.runReadAction(() -> QodanaReportHighlightingPass.getPsiFileByRevision$lambda$11(this, revisionFile));
        return (psiFile3 != null ? !psiFile3.isValid() : false) ? null : psiFile2;
    }

    private final PsiFile getPsiFileForLastRevision(PsiFile myFile) {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        String currentRevision = RepositoryRevisionProvider.Companion.getRepositoryRevision(project, myFile.getVirtualFile());
        return this.getPsiFileByRevision(myFile, currentRevision);
    }

    private final HighlightInfo buildHighlightInfo(SarifProblem problem, TextRange textRange, String suppressToolId) {
        HighlightInfo highlight;
        if (textRange == null) {
            return null;
        }
        String description2 = SarifProblemKt.buildDescription(problem, true, true);
        String string = DaemonTooltipsUtil.getWrappedTooltipWithCustomReference((String)description2, (String)SarifInspectionDescriptionLinkHandler.Companion.getLinkReferenceToInspection(problem.getInspectionId()), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWrappedTooltipWithCustomReference(...)");
        String tooltip = string;
        PsiElement element = this.myFile.findElementAt(textRange.getStartOffset());
        HighlightInfoType infoType = QodanaHighlightInfoTypeProvider.Companion.getHighlightTypeInfo();
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)new QodanaHighlightingInfoType(problem, infoType));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newHighlightInfo(...)");
        HighlightInfo.Builder builder2 = builder;
        List ignoreActions = new ArrayList();
        if (suppressToolId != null) {
            QodanaSuppressableProblemGroup problemGroup = new QodanaSuppressableProblemGroup(suppressToolId, this.myFile.getVirtualFile());
            builder2.problemGroup((ProblemGroup)problemGroup);
            Object[] suppressActions = problemGroup.getSuppressActions(element);
            CollectionsKt.addAll((Collection)ignoreActions, (Object[])suppressActions);
        }
        ignoreActions.add(new StopShowingReportAction());
        builder2.registerFix((IntentionAction)new QodanaRootIgnoreIntention(), ignoreActions, null, null, null);
        HighlightInfo highlightInfo = highlight = builder2.range(textRange).needsUpdateOnTyping(true).description(description2).escapedToolTip(tooltip).create();
        if (!((highlightInfo != null ? highlightInfo.getInspectionToolId() : null) == null)) {
            boolean bl = false;
            String string2 = "Inspection id must not be passed via HighlightInfo, otherwise inspections pass may clean it up";
            throw new IllegalArgumentException(string2.toString());
        }
        return highlight;
    }

    private final boolean updateWasAnalyzedOnceStatus() {
        boolean bl;
        block3: {
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstance((Project)this.myProject);
            DaemonCodeAnalyzerImpl codeAnalyzer = daemonCodeAnalyzer instanceof DaemonCodeAnalyzerImpl ? (DaemonCodeAnalyzerImpl)daemonCodeAnalyzer : null;
            Iterable $this$all$iv = QodanaHighlightingSupportInfoProvider.Companion.getPrecedingPassesIds();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    DaemonCodeAnalyzerImpl daemonCodeAnalyzerImpl = codeAnalyzer;
                    if ((daemonCodeAnalyzerImpl != null && (daemonCodeAnalyzerImpl = daemonCodeAnalyzerImpl.getFileStatusMap()) != null ? daemonCodeAnalyzerImpl.getFileDirtyScope(this.getDocument(), this.getContext(), this.myFile, it) : null) == null) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        boolean firstAnalysisPassed = bl;
        return this.passState.updateWasAnalysedOnce(firstAnalysisPassed);
    }

    /*
     * WARNING - void declaration
     */
    public void doApplyInformationToEditor() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        HighlightedReportData highlightedReportData2;
        QodanaHighlightingInfoType type2;
        HighlightInfoType highlightInfoType;
        HighlightInfo qodanaHighlight;
        boolean bl;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)this.getDocument(), (Project)this.myProject, (boolean)false);
        List<HighlightInfo> qodanaHighlights = this.myHighlightInfos.get();
        RangeHighlighter[] rangeHighlighterArray = markupModel.getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object[] $this$flatMap$iv = rangeHighlighterArray;
        boolean $i$f$flatMap = false;
        Object[] objectArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv2 : $this$flatMapTo$iv$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            Intrinsics.checkNotNull(qodanaHighlights);
            Iterable list$iv$iv = QodanaReportHighlightingPassKt.getQodanaHighlightsDuplicatingIde(it, qodanaHighlights);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set qodanaHighlightersDuplicatingIde = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNull(qodanaHighlights);
        List onlyQodanaHighlights = CollectionsKt.minus((Iterable)qodanaHighlights, (Iterable)qodanaHighlightersDuplicatingIde);
        boolean analyzedOnce = this.updateWasAnalyzedOnceStatus();
        Set<String> enabledInspections = this.enabledInspections.get();
        Iterable $this$mapNotNull$iv = onlyQodanaHighlights;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            SarifProblemPropertiesUpdater sarifProblemPropertiesUpdater;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl = false;
            qodanaHighlight = (HighlightInfo)element$iv$iv;
            boolean bl3 = false;
            highlightInfoType = qodanaHighlight.type;
            if ((highlightInfoType instanceof QodanaHighlightingInfoType ? (QodanaHighlightingInfoType)highlightInfoType : null) == null) {
                sarifProblemPropertiesUpdater = null;
            } else {
                type2 = type2;
                boolean isFixed = analyzedOnce && enabledInspections.contains(type2.getSarifProblem().getInspectionId());
                sarifProblemPropertiesUpdater = new SarifProblemPropertiesUpdater(type2.getSarifProblem(), (Function1<? super SarifProblemProperties, SarifProblemProperties>)((Function1)arg_0 -> QodanaReportHighlightingPass.doApplyInformationToEditor$lambda$16$lambda$15(isFixed, arg_0)));
            }
            if (sarifProblemPropertiesUpdater == null) continue;
            SarifProblemPropertiesUpdater it$iv$iv = sarifProblemPropertiesUpdater;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = qodanaHighlightersDuplicatingIde;
        Collection collection = (List)destination$iv$iv2;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            SarifProblemPropertiesUpdater sarifProblemPropertiesUpdater;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl = false;
            qodanaHighlight = (HighlightInfo)element$iv$iv;
            boolean bl5 = false;
            highlightInfoType = qodanaHighlight.type;
            if ((highlightInfoType instanceof QodanaHighlightingInfoType ? (QodanaHighlightingInfoType)highlightInfoType : null) == null) {
                sarifProblemPropertiesUpdater = null;
            } else {
                type2 = type2;
                sarifProblemPropertiesUpdater = new SarifProblemPropertiesUpdater(type2.getSarifProblem(), (Function1<? super SarifProblemProperties, SarifProblemProperties>)((Function1)QodanaReportHighlightingPass::doApplyInformationToEditor$lambda$18$lambda$17));
            }
            if (sarifProblemPropertiesUpdater == null) continue;
            SarifProblemPropertiesUpdater it$iv$iv = sarifProblemPropertiesUpdater;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List toUpdate = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
        HighlightedReportData highlightedReportData3 = highlightedReportData2 = HighlightedReportStateKt.getHighlightedReportDataIfSelected((HighlightedReportState)this.reportService.getHighlightedReportState().getValue());
        if (highlightedReportData3 != null) {
            highlightedReportData3.updateProblemsProperties(toUpdate);
        }
        $this$mapNotNullTo$iv$iv = onlyQodanaHighlights;
        boolean $i$f$filter = false;
        void $i$f$mapNotNullTo2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            HighlightInfo it = (HighlightInfo)element$iv$iv3;
            boolean bl7 = false;
            HighlightInfoType highlightInfoType2 = it.type;
            Object object = highlightInfoType2 instanceof QodanaHighlightingInfoType ? (QodanaHighlightingInfoType)highlightInfoType2 : null;
            String inspectionId = object != null && (object = ((QodanaHighlightingInfoType)object).getSarifProblem()) != null ? ((SarifProblem)object).getInspectionId() : null;
            Intrinsics.checkNotNull(enabledInspections);
            if (!(!CollectionsKt.contains((Iterable)enabledInspections, (Object)inspectionId))) continue;
            destination$iv$iv3.add(element$iv$iv3);
        }
        List onlyQodanaNotFixedHighlights = (List)destination$iv$iv3;
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.editor.getDocument(), (int)0, (int)this.myFile.getTextLength(), (Collection)onlyQodanaNotFixedHighlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
        this.passState.setInfosFromPass(onlyQodanaHighlights);
    }

    private static final SarifProblemProperties updateProblemsRanges$lambda$10$lambda$8(SarifProblemProperties it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SarifProblemProperties.copy$default(it, false, true, false, 0, 0, 29, null);
    }

    private static final SarifProblemProperties updateProblemsRanges$lambda$10$lambda$9(int $line, int $column, SarifProblemProperties it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SarifProblemProperties.copy$default(it, false, false, false, $line, $column, 5, null);
    }

    private static final PsiFile getPsiFileByRevision$lambda$11(QodanaReportHighlightingPass this$0, VirtualFile $revisionFile) {
        return PsiManager.getInstance((Project)this$0.myProject).findFile($revisionFile);
    }

    private static final SarifProblemProperties doApplyInformationToEditor$lambda$16$lambda$15(boolean $isFixed, SarifProblemProperties it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SarifProblemProperties.copy$default(it, false, false, $isFixed, 0, 0, 27, null);
    }

    private static final SarifProblemProperties doApplyInformationToEditor$lambda$18$lambda$17(SarifProblemProperties it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SarifProblemProperties.copy$default(it, false, false, false, 0, 0, 27, null);
    }

    public static final /* synthetic */ Project access$getMyProject$p$s1464811777(QodanaReportHighlightingPass $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ PsiFile access$getMyFile$p(QodanaReportHighlightingPass $this) {
        return $this.myFile;
    }

    public static final /* synthetic */ void access$putLocalRunData(QodanaReportHighlightingPass $this, long localIdeRunTimestamp) {
        $this.putLocalRunData(localIdeRunTimestamp);
    }

    public static final /* synthetic */ void access$putRevisionData(QodanaReportHighlightingPass $this, Set revisionIds) {
        $this.putRevisionData(revisionIds);
    }

    public static final /* synthetic */ AtomicReference access$getEnabledInspections$p(QodanaReportHighlightingPass $this) {
        return $this.enabledInspections;
    }
}

