/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.scientific.action;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.images.ImagesBundle;
import org.intellij.images.scientific.ScientificUtils;
import org.intellij.images.scientific.action.GrayscaleImageAction;
import org.intellij.images.scientific.action.InvertChannelsAction;
import org.intellij.images.scientific.action.RestoreOriginalImageAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0001H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/intellij/images/scientific/action/ImageOperationsActionGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "selectedMode", "", "availableModes", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "createPopupActionGroup", "triggerModeAction", "mode", "Companion", "intellij.platform.images"})
@SourceDebugExtension(value={"SMAP\nImageOperationsActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageOperationsActionGroup.kt\norg/intellij/images/scientific/action/ImageOperationsActionGroup\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,90:1\n37#2:91\n36#2,3:92\n*S KotlinDebug\n*F\n+ 1 ImageOperationsActionGroup.kt\norg/intellij/images/scientific/action/ImageOperationsActionGroup\n*L\n53#1:91\n53#1:92,3\n*E\n"})
public final class ImageOperationsActionGroup
extends DefaultActionGroup
implements CustomComponentAction,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String selectedMode = ORIGINAL_IMAGE;
    @NotNull
    private final List<String> availableModes;
    @NotNull
    private static final String ORIGINAL_IMAGE;
    @NotNull
    private static final String INVERTED_IMAGE;
    @NotNull
    private static final String GRAYSCALE_IMAGE;

    public ImageOperationsActionGroup() {
        String[] stringArray = new String[]{ORIGINAL_IMAGE, INVERTED_IMAGE, GRAYSCALE_IMAGE};
        this.availableModes = CollectionsKt.listOf((Object[])stringArray);
        String[] $this$_init__u24lambda_u240 = stringArray = this.getTemplatePresentation();
        boolean bl = false;
        $this$_init__u24lambda_u240.setPerformGroup(true);
        this.setPopup(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        InputEvent inputEvent = e.getInputEvent();
        Object object = inputEvent != null ? inputEvent.getSource() : null;
        JComponent jComponent = object instanceof JComponent ? (JComponent)object : null;
        if (jComponent == null) {
            return;
        }
        JComponent component = jComponent;
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this.createPopupActionGroup(), e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).showUnderneathOf((Component)component);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean shouldShowTheGroup = Registry.Companion.is("ide.images.sci.mode.channels.operations");
        if (!shouldShowTheGroup) {
            e.getPresentation().setVisible(false);
            return;
        }
        VirtualFile imageFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile virtualFile = imageFile;
        e.getPresentation().setEnabledAndVisible((virtualFile != null ? (Unit)virtualFile.getUserData(ScientificUtils.INSTANCE.getSCIENTIFIC_MODE_KEY()) : null) != null);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        this.selectedMode = ORIGINAL_IMAGE;
        Collection $this$toTypedArray$iv = this.availableModes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object object = new ComboBox((ComboBoxModel)new DefaultComboBoxModel<String>(thisCollection$iv.toArray(new String[0])));
        ComboBox $this$createCustomComponent_u24lambda_u242 = object;
        boolean bl = false;
        $this$createCustomComponent_u24lambda_u242.setSelectedItem((Object)this.selectedMode);
        $this$createCustomComponent_u24lambda_u242.setOpaque(false);
        $this$createCustomComponent_u24lambda_u242.addActionListener(arg_0 -> ImageOperationsActionGroup.createCustomComponent$lambda$2$lambda$1(this, $this$createCustomComponent_u24lambda_u242, arg_0));
        ComboBox comboBox = object;
        Object $this$createCustomComponent_u24lambda_u243 = object = new JPanel(new BorderLayout());
        boolean bl2 = false;
        ((JComponent)$this$createCustomComponent_u24lambda_u243).setOpaque(false);
        ((JComponent)$this$createCustomComponent_u24lambda_u243).setBorder(null);
        ((Container)$this$createCustomComponent_u24lambda_u243).add((Component)comboBox, "Center");
        return (JComponent)object;
    }

    private final DefaultActionGroup createPopupActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new RestoreOriginalImageAction());
        actionGroup.add((AnAction)new InvertChannelsAction());
        actionGroup.add((AnAction)new GrayscaleImageAction());
        return actionGroup;
    }

    private final void triggerModeAction(String mode) {
        ActionManager actionManager = ActionManager.getInstance();
        String string = mode;
        if (Intrinsics.areEqual((Object)string, (Object)ORIGINAL_IMAGE)) {
            actionManager.tryToExecute((AnAction)new RestoreOriginalImageAction(), null, null, null, true);
        } else if (Intrinsics.areEqual((Object)string, (Object)INVERTED_IMAGE)) {
            actionManager.tryToExecute((AnAction)new InvertChannelsAction(), null, null, null, true);
        } else if (Intrinsics.areEqual((Object)string, (Object)GRAYSCALE_IMAGE)) {
            actionManager.tryToExecute((AnAction)new GrayscaleImageAction(), null, null, null, true);
        }
    }

    private static final void createCustomComponent$lambda$2$lambda$1(ImageOperationsActionGroup this$0, ComboBox $this_apply, ActionEvent it) {
        Object object = $this_apply.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        this$0.selectedMode = (String)object;
        this$0.triggerModeAction(this$0.selectedMode);
    }

    static {
        String string = ImagesBundle.message("image.color.mode.original.image", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ORIGINAL_IMAGE = string;
        String string2 = ImagesBundle.message("image.color.mode.inverted.image", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        INVERTED_IMAGE = string2;
        String string3 = ImagesBundle.message("image.color.mode.grayscale.image", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        GRAYSCALE_IMAGE = string3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/intellij/images/scientific/action/ImageOperationsActionGroup$Companion;", "", "<init>", "()V", "ORIGINAL_IMAGE", "", "INVERTED_IMAGE", "GRAYSCALE_IMAGE", "intellij.platform.images"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

