/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.dvcs.util.LocalCommitCompareInfo;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.vcs.VcsActivity;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class CompareBranchesDiffPanel
extends JPanel
implements UiDataProvider {
    public static final DataKey<CompareBranchesDiffPanel> DATA_KEY = DataKey.create((String)"com.intellij.dvcs.ui.CompareBranchesDiffPanel");
    @NlsSafe
    private final String myBranchName;
    private final Project myProject;
    @NlsSafe
    private final String myCurrentBranchName;
    private final DvcsCompareSettings myVcsSettings;
    @Nullable
    private CommitCompareInfo myCompareInfo;
    private final JEditorPane myLabel;
    private final MyChangesBrowser myChangesBrowser;

    public CompareBranchesDiffPanel(@NotNull Project project, @NotNull DvcsCompareSettings settings, @NotNull String branchName, @NotNull String currentBranchName) {
        if (project == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(1);
        }
        if (branchName == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(2);
        }
        if (currentBranchName == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myCurrentBranchName = currentBranchName;
        this.myBranchName = branchName;
        this.myVcsSettings = settings;
        this.myLabel = new JEditorPane(){

            @Override
            public void setText(@Nls String t) {
                super.setText(t);
                this.getPreferredSize();
            }
        };
        this.myLabel.setEditorKit(HTMLEditorKitBuilder.simple());
        this.myLabel.setEditable(false);
        this.myLabel.setBackground(null);
        this.myLabel.setOpaque(false);
        this.myLabel.setFocusable(false);
        this.myLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CompareBranchesDiffPanel.this.swapSides();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/ui/CompareBranchesDiffPanel$2", "hyperlinkActivated"));
            }
        });
        this.updateLabelText();
        this.myChangesBrowser = new MyChangesBrowser(project, Collections.emptyList());
        this.myChangesBrowser.getViewer().setTreeStateStrategy(ChangesTree.KEEP_NON_EMPTY);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myLabel, "North");
        this.add((Component)((Object)this.myChangesBrowser), "Center");
    }

    @RequiresEdt
    public void setCompareInfo(@NotNull CommitCompareInfo compareInfo) {
        if (compareInfo == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myCompareInfo = compareInfo;
        this.refreshView(false);
    }

    @NotNull
    public ChangesBrowserBase getChangesBrowser() {
        MyChangesBrowser myChangesBrowser = this.myChangesBrowser;
        if (myChangesBrowser == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(5);
        }
        return myChangesBrowser;
    }

    private void swapSides() {
        boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
        this.myVcsSettings.setSwapSidesInCompareBranches(!swapSides);
        this.refreshView(true);
    }

    private void refreshView(boolean onSwapSides) {
        if (this.myCompareInfo == null) {
            return;
        }
        boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
        this.updateLabelText();
        List<Change> diff = this.myCompareInfo.getTotalDiff();
        if (swapSides) {
            diff = DvcsBranchUtil.swapRevisions(diff);
        }
        if (onSwapSides) {
            this.myChangesBrowser.setChangesToDisplay(diff, new OnSwapSidesTreeStateStrategy());
        } else {
            this.myChangesBrowser.setChangesToDisplay(diff);
        }
    }

    private void updateLabelText() {
        boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
        HtmlChunk.Element branchNameText = HtmlChunk.text((String)this.myBranchName).code().bold();
        HtmlChunk.Element currentBranchNameText = HtmlChunk.text((String)this.myCurrentBranchName).code().bold();
        String diffBetween = swapSides ? DvcsBundle.message("compare.branches.diff.panel.diff.between.files.in.branch.and.current.working.tree.on.branch", branchNameText, currentBranchNameText) : DvcsBundle.message("compare.branches.diff.panel.difference.between.current.working.tree.on.branch.and.files.in.branch", currentBranchNameText, branchNameText);
        String swapBranches = DvcsBundle.message("compare.branches.diff.panel.swap.branches", new Object[0]);
        this.myLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)(diffBetween + "&emsp;" + String.valueOf(HtmlChunk.link((String)"", (String)swapBranches)))));
    }

    public void setEmptyText(@NotNull @NlsContexts.Label String text) {
        if (text == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(6);
        }
        this.myChangesBrowser.getViewer().setEmptyText(text);
    }

    public void disableControls() {
        this.myLabel.setEnabled(false);
    }

    public void enableControls() {
        this.myLabel.setEnabled(true);
    }

    @NotNull
    public JComponent getPreferredFocusComponent() {
        JComponent jComponent = this.myChangesBrowser.getPreferredFocusedComponent();
        if (jComponent == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            CompareBranchesDiffPanel.$$$reportNull$$$0(8);
        }
        sink.set(DATA_KEY, (Object)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBranchName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compareInfo";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBrowser";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCompareInfo";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }

    private static class MyChangesBrowser
    extends SimpleAsyncChangesBrowser {
        MyChangesBrowser(@NotNull Project project, @NotNull List<? extends Change> changes) {
            if (project == null) {
                MyChangesBrowser.$$$reportNull$$$0(0);
            }
            if (changes == null) {
                MyChangesBrowser.$$$reportNull$$$0(1);
            }
            super(project, false, true);
            this.setChangesToDisplay(changes);
        }

        @NotNull
        protected @Unmodifiable List<AnAction> createToolbarActions() {
            List list = ContainerUtil.append((List)super.createToolbarActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.GetVersion")});
            if (list == null) {
                MyChangesBrowser.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        protected @Unmodifiable List<AnAction> createPopupMenuActions() {
            List list = ContainerUtil.append((List)super.createPopupMenuActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.GetVersion")});
            if (list == null) {
                MyChangesBrowser.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$MyChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$MyChangesBrowser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbarActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupMenuActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class OnSwapSidesTreeStateStrategy
    implements ChangesTree.TreeStateStrategy<MyState> {
        private OnSwapSidesTreeStateStrategy() {
        }

        public MyState saveState(@NotNull ChangesTree tree) {
            if (tree == null) {
                OnSwapSidesTreeStateStrategy.$$$reportNull$$$0(0);
            }
            List changes = VcsTreeModelData.selected((JTree)tree).userObjects(Change.class);
            return new MyState(changes);
        }

        public void restoreState(@NotNull ChangesTree tree, MyState state, boolean scrollToSelection) {
            if (tree == null) {
                OnSwapSidesTreeStateStrategy.$$$reportNull$$$0(1);
            }
            if (state != null && !state.selectedChanges.isEmpty()) {
                tree.setSelectedChanges(DvcsBranchUtil.swapRevisions(state.selectedChanges));
            } else {
                tree.resetTreeState();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tree";
            objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$OnSwapSidesTreeStateStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private record MyState(@NotNull List<Change> selectedChanges) {
            @NotNull
            private final List<Change> selectedChanges;

            private MyState(@NotNull List<Change> selectedChanges) {
                if (selectedChanges == null) {
                    MyState.$$$reportNull$$$0(0);
                }
            }

            @NotNull
            public List<Change> selectedChanges() {
                List<Change> list = this.selectedChanges;
                if (list == null) {
                    MyState.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectedChanges";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$OnSwapSidesTreeStateStrategy$MyState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$OnSwapSidesTreeStateStrategy$MyState";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "selectedChanges";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }

    public static class GetVersionActionProvider
    implements AnActionExtensionProvider {
        public boolean isActive(@NotNull AnActionEvent e) {
            if (e == null) {
                GetVersionActionProvider.$$$reportNull$$$0(0);
            }
            return e.getData(DATA_KEY) != null;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                GetVersionActionProvider.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            CompareBranchesDiffPanel panel;
            if (e == null) {
                GetVersionActionProvider.$$$reportNull$$$0(2);
            }
            if ((panel = (CompareBranchesDiffPanel)e.getData(DATA_KEY)) == null) {
                return;
            }
            Presentation presentation = e.getPresentation();
            presentation.setText(DvcsBundle.messagePointer("compare.branches.diff.panel.get.from.branch.action", new Object[0]));
            presentation.setDescription(DvcsBundle.messagePointer("compare.branches.diff.panel.get.from.branch.action.description", panel.myBranchName));
            boolean isEnabled = !panel.myChangesBrowser.getSelectedChanges().isEmpty();
            boolean isVisible = panel.myCompareInfo instanceof LocalCommitCompareInfo;
            presentation.setEnabled(isEnabled && isVisible);
            presentation.setVisible(isVisible);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CompareBranchesDiffPanel panel;
            if (e == null) {
                GetVersionActionProvider.$$$reportNull$$$0(3);
            }
            if ((panel = (CompareBranchesDiffPanel)e.getData(DATA_KEY)) == null) {
                return;
            }
            Project project = panel.myProject;
            final List changes = panel.myChangesBrowser.getSelectedChanges();
            final boolean swapSides = panel.myVcsSettings.shouldSwapSidesInCompareBranches();
            final CommitCompareInfo compareInfo = panel.myCompareInfo;
            String title = DvcsBundle.message("compare.branches.diff.panel.get.from.branch.title", panel.myBranchName);
            ReplaceFileConfirmationDialog confirmationDialog = new ReplaceFileConfirmationDialog(project, title);
            if (!confirmationDialog.confirmFor(ChangesUtil.getFilesFromChanges((Collection)changes))) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            final LocalHistoryAction action = LocalHistory.getInstance().startAction(VcsBundle.message((String)"activity.name.get.from", (Object[])new Object[]{panel.myBranchName}), VcsActivity.Get);
            new Task.Modal(project, DvcsBundle.message("compare.branches.diff.panel.loading.content.from.branch.process", new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        if (compareInfo != null) {
                            ((LocalCommitCompareInfo)compareInfo).copyChangesFromBranch(changes, swapSides);
                        }
                    }
                    catch (VcsException err) {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myProject, (String)err.getMessage(), (String)DvcsBundle.message("compare.branches.diff.panel.can.not.copy.changes.error", new Object[0])));
                    }
                }

                public void onFinished() {
                    action.finish();
                    panel.refreshView(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/ui/CompareBranchesDiffPanel$GetVersionActionProvider$1", "run"));
                }
            }.queue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$GetVersionActionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$GetVersionActionProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isActive";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

