/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.cbor.internal.ByteArrayOutput;
import kotlinx.serialization.cbor.internal.CborWriter;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u0005\n\u0002\b\u0004\u001a\u001a\u0010\u0000\u001a\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u00032\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u001a\u001e\u0010\u0005\u001a\u00020\u0006*\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0016\u0010\b\u001a\u00020\u0002*\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003H\u0002\u001a\u0016\u0010\t\u001a\u00020\u0002*\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003H\u0002\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002\u001a\u001b\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\f\u0010\u0011\u001a\u00020\u000b*\u00020\fH\u0002\u001a\u001b\u0010\u0011\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0010\u001a\u001b\u0010\u0013\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0010\u001a\f\u0010\u0016\u001a\u00020\u000b*\u00020\fH\u0000\u001a\f\u0010\u0017\u001a\u00020\u000b*\u00020\fH\u0000\u001a\f\u0010\u0018\u001a\u00020\u000b*\u00020\fH\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u0014\u0010\u001c\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u001d\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0007\u001a\u00020\u001eH\u0000\u001a\u0014\u0010\u001f\u001a\u00020\u000b*\u00020\f2\u0006\u0010 \u001a\u00020!H\u0000\u001a\u0014\u0010\"\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0007\u001a\u00020#H\u0000\u001a\u001c\u0010$\u001a\u00020\u000b*\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020\u001bH\u0000\u001a\u0014\u0010&\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0007\u001a\u00020'H\u0000\u001a\u0014\u0010(\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0007\u001a\u00020)H\u0000\u001a\u0010\u0010*\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\u001eH\u0002\u001a#\u0010+\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b-\u0010.\u001a\u0017\u0010/\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b0\u00101\u001a+\u00102\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b4\u00105\u001a'\u00106\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u000207H\u0002\u00a2\u0006\u0004\b8\u00109\u001a\u0010\u0010:\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\u001eH\u0002*\u0018\b\u0002\u0010\u0000\"\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006;"}, d2={"Stack", "", "Lkotlinx/serialization/cbor/internal/CborWriter$Data;", "Lkotlinx/serialization/cbor/internal/Stack;", "initial", "push", "", "value", "pop", "peek", "startArray", "", "Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "size", "Lkotlin/ULong;", "startArray-2TYgG_w", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;J)V", "startMap", "startMap-2TYgG_w", "encodeTag", "tag", "encodeTag-2TYgG_w", "end", "encodeNull", "encodeEmptyMap", "writeByte", "byteValue", "", "encodeBoolean", "encodeNumber", "", "encodeByteString", "data", "", "encodeString", "", "encodeByteArray", "type", "encodeFloat", "", "encodeDouble", "", "composeNumber", "composePositiveInline", "mod", "composePositiveInline-z13BHRw", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;JI)V", "composePositive", "composePositive-VKZWuLQ", "(J)[B", "encodeToInline", "bytes", "encodeToInline-32etgaw", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;JII)V", "encodeToByteArray", "", "encodeToByteArray-E0BElUM", "(JIB)[B", "composeNegative", "kotlinx-serialization-cbor"})
public final class EncoderKt {
    private static final List<CborWriter.Data> Stack(CborWriter.Data initial) {
        Object[] objectArray = new CborWriter.Data[]{initial};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    private static final boolean push(List<CborWriter.Data> $this$push, CborWriter.Data value) {
        return $this$push.add(value);
    }

    private static final CborWriter.Data pop(List<CborWriter.Data> $this$pop) {
        return (CborWriter.Data)CollectionsKt.removeLast($this$pop);
    }

    private static final CborWriter.Data peek(List<CborWriter.Data> $this$peek) {
        return (CborWriter.Data)CollectionsKt.last($this$peek);
    }

    private static final void startArray(ByteArrayOutput $this$startArray) {
        $this$startArray.write(159);
    }

    private static final void startArray-2TYgG_w(ByteArrayOutput $this$startArray_u2d2TYgG_w, long size) {
        EncoderKt.composePositiveInline-z13BHRw($this$startArray_u2d2TYgG_w, size, 128);
    }

    private static final void startMap(ByteArrayOutput $this$startMap) {
        $this$startMap.write(191);
    }

    private static final void startMap-2TYgG_w(ByteArrayOutput $this$startMap_u2d2TYgG_w, long size) {
        EncoderKt.composePositiveInline-z13BHRw($this$startMap_u2d2TYgG_w, size, 160);
    }

    private static final void encodeTag-2TYgG_w(ByteArrayOutput $this$encodeTag_u2d2TYgG_w, long tag) {
        EncoderKt.composePositiveInline-z13BHRw($this$encodeTag_u2d2TYgG_w, tag, 192);
    }

    public static final void end(@NotNull ByteArrayOutput $this$end) {
        Intrinsics.checkNotNullParameter((Object)$this$end, (String)"<this>");
        $this$end.write(255);
    }

    public static final void encodeNull(@NotNull ByteArrayOutput $this$encodeNull) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeNull, (String)"<this>");
        $this$encodeNull.write(246);
    }

    public static final void encodeEmptyMap(@NotNull ByteArrayOutput $this$encodeEmptyMap) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeEmptyMap, (String)"<this>");
        $this$encodeEmptyMap.write(160);
    }

    public static final void writeByte(@NotNull ByteArrayOutput $this$writeByte, int byteValue) {
        Intrinsics.checkNotNullParameter((Object)$this$writeByte, (String)"<this>");
        $this$writeByte.write(byteValue);
    }

    public static final void encodeBoolean(@NotNull ByteArrayOutput $this$encodeBoolean, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeBoolean, (String)"<this>");
        $this$encodeBoolean.write(value ? 245 : 244);
    }

    public static final void encodeNumber(@NotNull ByteArrayOutput $this$encodeNumber, long value) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeNumber, (String)"<this>");
        ByteArrayOutput.write$default($this$encodeNumber, EncoderKt.composeNumber(value), 0, 0, 6, null);
    }

    public static final void encodeByteString(@NotNull ByteArrayOutput $this$encodeByteString, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeByteString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        EncoderKt.encodeByteArray($this$encodeByteString, data, 64);
    }

    public static final void encodeString(@NotNull ByteArrayOutput $this$encodeString, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        EncoderKt.encodeByteArray($this$encodeString, StringsKt.encodeToByteArray((String)value), 96);
    }

    public static final void encodeByteArray(@NotNull ByteArrayOutput $this$encodeByteArray, @NotNull byte[] data, int type) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        EncoderKt.composePositiveInline-z13BHRw($this$encodeByteArray, ULong.constructor-impl((long)data.length), type);
        ByteArrayOutput.write$default($this$encodeByteArray, data, 0, 0, 6, null);
    }

    public static final void encodeFloat(@NotNull ByteArrayOutput $this$encodeFloat, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeFloat, (String)"<this>");
        $this$encodeFloat.write(250);
        int bits = Float.floatToRawIntBits(value);
        for (int i = 0; i < 4; ++i) {
            $this$encodeFloat.write(bits >> 24 - 8 * i & 0xFF);
        }
    }

    public static final void encodeDouble(@NotNull ByteArrayOutput $this$encodeDouble, double value) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeDouble, (String)"<this>");
        $this$encodeDouble.write(251);
        long bits = Double.doubleToRawLongBits(value);
        for (int i = 0; i < 8; ++i) {
            $this$encodeDouble.write((int)(bits >> 56 - 8 * i & 0xFFL));
        }
    }

    private static final byte[] composeNumber(long value) {
        return value >= 0L ? EncoderKt.composePositive-VKZWuLQ(ULong.constructor-impl((long)value)) : EncoderKt.composeNegative(value);
    }

    private static final void composePositiveInline-z13BHRw(ByteArrayOutput $this$composePositiveInline_u2dz13BHRw, long value, int mod) {
        long l = value;
        boolean bl = 0 <= UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)(0L & 0xFFFFFFFFL))) ? UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)23 & 0xFFFFFFFFL))) <= 0 : false;
        if (bl) {
            EncoderKt.writeByte($this$composePositiveInline_u2dz13BHRw, (int)value | mod);
        } else {
            boolean bl2 = 0 <= UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)24 & 0xFFFFFFFFL))) ? UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)UInt.constructor-impl((int)(0xFFFFFFFF & 0xFF)) & 0xFFFFFFFFL))) <= 0 : false;
            if (bl2) {
                EncoderKt.writeByte($this$composePositiveInline_u2dz13BHRw, 0x18 | mod);
                EncoderKt.writeByte($this$composePositiveInline_u2dz13BHRw, (int)value);
            } else {
                int n = UInt.constructor-impl((int)(UInt.constructor-impl((int)(0xFFFFFFFF & 0xFF)) + 1));
                boolean bl3 = UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)UInt.constructor-impl((int)(0xFFFFFFFF & 0xFFFF)) & 0xFFFFFFFFL))) <= 0 ? 0 <= UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)n & 0xFFFFFFFFL))) : false;
                if (bl3) {
                    EncoderKt.encodeToInline-32etgaw($this$composePositiveInline_u2dz13BHRw, value, 2, 0x19 | mod);
                } else {
                    boolean bl4 = 0 <= UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)UInt.constructor-impl((int)(UInt.constructor-impl((int)(0xFFFFFFFF & 0xFFFF)) + 1)) & 0xFFFFFFFFL))) ? UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)-1 & 0xFFFFFFFFL))) <= 0 : false;
                    if (bl4) {
                        EncoderKt.encodeToInline-32etgaw($this$composePositiveInline_u2dz13BHRw, value, 4, 0x1A | mod);
                    } else {
                        EncoderKt.encodeToInline-32etgaw($this$composePositiveInline_u2dz13BHRw, value, 8, 0x1B | mod);
                    }
                }
            }
        }
    }

    private static final byte[] composePositive-VKZWuLQ(long value) {
        byte[] byArray;
        long l = value;
        boolean bl = 0 <= UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)(0L & 0xFFFFFFFFL))) ? UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)23 & 0xFFFFFFFFL))) <= 0 : false;
        if (bl) {
            byte[] byArray2 = new byte[]{(byte)value};
            byArray = byArray2;
        } else {
            boolean bl2 = 0 <= UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)24 & 0xFFFFFFFFL))) ? UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)UInt.constructor-impl((int)(0xFFFFFFFF & 0xFF)) & 0xFFFFFFFFL))) <= 0 : false;
            if (bl2) {
                byte[] byArray3 = new byte[]{24, (byte)value};
                byArray = byArray3;
            } else {
                int n = UInt.constructor-impl((int)(UInt.constructor-impl((int)(0xFFFFFFFF & 0xFF)) + 1));
                byArray = (UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)UInt.constructor-impl((int)(0xFFFFFFFF & 0xFFFF)) & 0xFFFFFFFFL))) <= 0 ? 0 <= UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)n & 0xFFFFFFFFL))) : false) ? EncoderKt.encodeToByteArray-E0BElUM(value, 2, (byte)25) : ((0 <= UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)UInt.constructor-impl((int)(UInt.constructor-impl((int)(0xFFFFFFFF & 0xFFFF)) + 1)) & 0xFFFFFFFFL))) ? UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)-1 & 0xFFFFFFFFL))) <= 0 : false) ? EncoderKt.encodeToByteArray-E0BElUM(value, 4, (byte)26) : EncoderKt.encodeToByteArray-E0BElUM(value, 8, (byte)27));
            }
        }
        return byArray;
    }

    private static final void encodeToInline-32etgaw(ByteArrayOutput $this$encodeToInline_u2d32etgaw, long value, int bytes, int tag) {
        int limit = bytes * 8 - 8;
        EncoderKt.writeByte($this$encodeToInline_u2d32etgaw, tag);
        for (int i = 0; i < bytes; ++i) {
            EncoderKt.writeByte($this$encodeToInline_u2d32etgaw, (int)ULong.constructor-impl((long)(ULong.constructor-impl((long)(value >>> limit - 8 * i)) & 0xFFL)));
        }
    }

    private static final byte[] encodeToByteArray-E0BElUM(long value, int bytes, byte tag) {
        byte[] result = new byte[bytes + 1];
        int limit = bytes * 8 - 8;
        result[0] = tag;
        for (int i = 0; i < bytes; ++i) {
            result[i + 1] = (byte)ULong.constructor-impl((long)(ULong.constructor-impl((long)(value >>> limit - 8 * i)) & 0xFFL));
        }
        return result;
    }

    private static final byte[] composeNegative(long value) {
        long aVal = value == Long.MIN_VALUE ? Long.MAX_VALUE : (long)-1 - value;
        byte[] data = EncoderKt.composePositive-VKZWuLQ(ULong.constructor-impl((long)aVal));
        data[0] = (byte)(data[0] | 0x20);
        return data;
    }

    public static final /* synthetic */ void access$encodeTag-2TYgG_w(ByteArrayOutput $receiver, long tag) {
        EncoderKt.encodeTag-2TYgG_w($receiver, tag);
    }

    public static final /* synthetic */ void access$startArray(ByteArrayOutput $receiver) {
        EncoderKt.startArray($receiver);
    }

    public static final /* synthetic */ void access$startMap(ByteArrayOutput $receiver) {
        EncoderKt.startMap($receiver);
    }

    public static final /* synthetic */ List access$Stack(CborWriter.Data initial) {
        return EncoderKt.Stack(initial);
    }

    public static final /* synthetic */ CborWriter.Data access$peek(List $receiver) {
        return EncoderKt.peek($receiver);
    }

    public static final /* synthetic */ boolean access$push(List $receiver, CborWriter.Data value) {
        return EncoderKt.push($receiver, value);
    }

    public static final /* synthetic */ CborWriter.Data access$pop(List $receiver) {
        return EncoderKt.pop($receiver);
    }

    public static final /* synthetic */ void access$startArray-2TYgG_w(ByteArrayOutput $receiver, long size) {
        EncoderKt.startArray-2TYgG_w($receiver, size);
    }

    public static final /* synthetic */ void access$startMap-2TYgG_w(ByteArrayOutput $receiver, long size) {
        EncoderKt.startMap-2TYgG_w($receiver, size);
    }
}

