/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.pyi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtilCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyiUtil {
    private PyiUtil() {
    }

    public static boolean isInsideStubAnnotation(@NotNull PsiElement element) {
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(0);
        }
        return PyiUtil.isInsideStub(element) && PsiTreeUtil.getParentOfType((PsiElement)element, PyAnnotation.class, (boolean)true, (Class[])new Class[]{ScopeOwner.class}) != null;
    }

    public static boolean isInsideStub(@NotNull PsiElement element) {
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(1);
        }
        return PyiUtilCore.isInsideStub((PsiElement)element);
    }

    @Nullable
    public static PsiElement getPythonStub(@NotNull PyElement element) {
        PyiFile pythonStubFile;
        PsiFile file;
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(2);
        }
        if (PyiUtil.pyButNotPyiFile(file = element.getContainingFile()) && (pythonStubFile = PyiUtil.getPythonStubFile((PyFile)file)) != null) {
            return PyiUtil.findSimilarElement(element, pythonStubFile);
        }
        return null;
    }

    @Nullable
    public static PsiElement getOriginalElement(@NotNull PyElement element) {
        PyClass containingClass;
        PsiFile file;
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(3);
        }
        if (!((file = element.getContainingFile()) instanceof PyiFile)) {
            return null;
        }
        PyFile originalFile = PyiUtil.getOriginalFile((PyiFile)file);
        if (originalFile == null) {
            return null;
        }
        PsiElement result2 = PyiUtil.findSimilarElement(element, originalFile);
        if (result2 instanceof PyElement && PyiUtil.isInsideStub(result2) && result2.getContainingFile() != file) {
            result2 = PyiUtil.getOriginalElement((PyElement)result2);
        }
        if (result2 != null) {
            return result2;
        }
        if (element instanceof PyFunction && (containingClass = PyUtil.turnConstructorIntoClass((PyFunction)element)) != null) {
            result2 = PyiUtil.findSimilarElement(containingClass, originalFile);
        }
        return result2;
    }

    @Nullable
    public static PyFunction getImplementation(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        PsiFile file;
        if (function == null) {
            PyiUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyiUtil.$$$reportNull$$$0(5);
        }
        if ((file = function.getContainingFile()) instanceof PyiFile) {
            return null;
        }
        return (PyFunction)ContainerUtil.getLastItem(PyiUtil.collectImplementationsOrOverloads(function, true, context));
    }

    @NotNull
    public static List<PyFunction> getOverloads(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyiUtil.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PyiUtil.$$$reportNull$$$0(7);
        }
        return PyiUtil.collectImplementationsOrOverloads(function, false, context);
    }

    public static boolean isOverload(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PyiUtil.$$$reportNull$$$0(9);
        }
        PyKnownDecoratorUtil.KnownDecorator overload = PyKnownDecoratorUtil.KnownDecorator.TYPING_OVERLOAD;
        return element instanceof PyFunction && PyKnownDecoratorUtil.getKnownDecorators((PyFunction)element, context).contains((Object)overload);
    }

    @NotNull
    public static <T extends PyElement> T getOriginalElementOrLeaveAsIs(@NotNull T element, @NotNull Class<T> cls) {
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(10);
        }
        if (cls == null) {
            PyiUtil.$$$reportNull$$$0(11);
        }
        PyElement pyElement = (PyElement)ObjectUtils.notNull((Object)((PyElement)PyUtil.as(PyiUtil.getOriginalElement(element), cls)), element);
        if (pyElement == null) {
            PyiUtil.$$$reportNull$$$0(12);
        }
        return (T)pyElement;
    }

    public static boolean isPyiFileOfPackage(@NotNull PsiElement element) {
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(13);
        }
        return element instanceof PyiFile || PyUtil.turnDirIntoInitPyi(element) instanceof PyiFile;
    }

    private static boolean pyButNotPyiFile(@Nullable PsiFile file) {
        return file instanceof PyFile && !(file instanceof PyiFile);
    }

    @Nullable
    private static PyiFile getPythonStubFile(@NotNull PyFile file) {
        QualifiedName name2;
        if (file == null) {
            PyiUtil.$$$reportNull$$$0(14);
        }
        if ((name2 = QualifiedNameFinder.findCanonicalImportPath((PsiElement)file, (PsiElement)file)) == null) {
            return null;
        }
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromFoothold((PsiElement)file);
        return PyUtil.as(PyResolveImportUtil.resolveQualifiedName(name2, context).stream().findFirst().map(PyUtil::turnDirIntoInitPyi).orElse(null), PyiFile.class);
    }

    @Nullable
    private static PyFile getOriginalFile(@NotNull PyiFile file) {
        QualifiedName name2;
        if (file == null) {
            PyiUtil.$$$reportNull$$$0(15);
        }
        if ((name2 = QualifiedNameFinder.findCanonicalImportPath((PsiElement)file, (PsiElement)file)) == null) {
            return null;
        }
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromFoothold((PsiElement)file).copyWithoutStubs();
        return PyUtil.as(PyResolveImportUtil.resolveQualifiedName(name2, context).stream().findFirst().map(PyUtil::turnDirIntoInitPy).orElse(null), PyFile.class);
    }

    @Nullable
    private static PsiElement findSimilarElement(@NotNull PyElement element, @NotNull PyFile file) {
        if (element == null) {
            PyiUtil.$$$reportNull$$$0(16);
        }
        if (file == null) {
            PyiUtil.$$$reportNull$$$0(17);
        }
        if (element instanceof PyFile) {
            return file;
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)element);
        String name2 = element.getName();
        if (owner != null && name2 != null) {
            assert (owner != element);
            PsiElement originalOwner = PyiUtil.findSimilarElement(owner, file);
            if (originalOwner instanceof PyTypedElement) {
                TypeEvalContext context = TypeEvalContext.codeInsightFallback(file.getProject());
                PyType type2 = context.getType((PyTypedElement)originalOwner);
                PsiElement result2 = PyiUtil.resolveSimilarMember(type2, name2, context);
                return result2 == element ? null : result2;
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveSimilarMember(@Nullable PyType similarOwnerType, @NotNull String name2, @NotNull TypeEvalContext context) {
        if (name2 == null) {
            PyiUtil.$$$reportNull$$$0(18);
        }
        if (context == null) {
            PyiUtil.$$$reportNull$$$0(19);
        }
        if (similarOwnerType == null) {
            return null;
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
        List<? extends RatedResolveResult> results = similarOwnerType instanceof PyClassLikeType ? ((PyClassLikeType)similarOwnerType).resolveMember(name2, null, AccessDirection.READ, resolveContext, false) : similarOwnerType.resolveMember(name2, null, AccessDirection.READ, resolveContext);
        return PyiUtil.takeTopPriorityElement(results);
    }

    @NotNull
    private static List<PyFunction> collectImplementationsOrOverloads(@NotNull PyFunction function, boolean implementations, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyiUtil.$$$reportNull$$$0(20);
        }
        if (context == null) {
            PyiUtil.$$$reportNull$$$0(21);
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner(function);
        String name2 = function.getName();
        ArrayList<PyFunction> result2 = new ArrayList<PyFunction>();
        Processor overloadsProcessor = f -> {
            if (name2 != null && name2.equals(f.getName()) && implementations ^ PyiUtil.isOverload(f, context)) {
                result2.add((PyFunction)f);
            }
            return true;
        };
        if (owner instanceof PyClass) {
            PyClass cls = (PyClass)owner;
            if (name2 != null) {
                cls.visitMethods((Processor<? super PyFunction>)overloadsProcessor, false, context);
            }
        } else if (owner instanceof PyFile) {
            PyFile file = (PyFile)owner;
            for (PyFunction f2 : file.getTopLevelFunctions()) {
                if (!overloadsProcessor.process((Object)f2)) break;
            }
        }
        ArrayList<PyFunction> arrayList = result2;
        if (arrayList == null) {
            PyiUtil.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @Nullable
    private static PsiElement takeTopPriorityElement(@Nullable List<? extends RatedResolveResult> resolveResults) {
        if (!ContainerUtil.isEmpty(resolveResults)) {
            return Collections.max(resolveResults, Comparator.comparingInt(RatedResolveResult::getRate)).getElement();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/pyi/PyiUtil";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/pyi/PyiUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalElementOrLeaveAsIs";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "collectImplementationsOrOverloads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInsideStubAnnotation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInsideStub";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPythonStub";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getImplementation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOverloads";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isOverload";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElementOrLeaveAsIs";
                break;
            }
            case 12: 
            case 22: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPyiFileOfPackage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPythonStubFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findSimilarElement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveSimilarMember";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectImplementationsOrOverloads";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 22 -> new IllegalStateException(string);
        };
    }
}

