/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.ui.VcsLogBookmark;
import com.intellij.vcs.log.ui.VcsLogBookmarksListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/log/ui/VcsLogBookmarksManagerListener;", "Lcom/intellij/ide/bookmark/BookmarksListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "updateBookmark", "", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "bookmarkAdded", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "bookmarkRemoved", "bookmarkChanged", "bookmarkTypeChanged", "intellij.platform.vcs.log.impl"})
public final class VcsLogBookmarksManagerListener
implements BookmarksListener {
    @NotNull
    private final Project project;

    public VcsLogBookmarksManagerListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void updateBookmark(Bookmark bookmark) {
        if (bookmark instanceof VcsLogBookmark) {
            ((VcsLogBookmarksListener)this.project.getMessageBus().syncPublisher(VcsLogBookmarksListener.TOPIC)).logBookmarksChanged();
        }
    }

    public void bookmarkAdded(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.updateBookmark(bookmark);
    }

    public void bookmarkRemoved(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.updateBookmark(bookmark);
    }

    public void bookmarkChanged(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.updateBookmark(bookmark);
    }

    public void bookmarkTypeChanged(@NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.updateBookmark(bookmark);
    }
}

