/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.ide.impl.TrustedProjects;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesImpl;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.impl.VcsProjectLogManager;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.column.VcsLogColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnManager;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnUtilKt;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumnKt;
import com.intellij.vcs.log.util.GraphOptionsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
@NonNls
public class VcsLogFeaturesCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("vcs.log.ui", 8);
    private static final EventId UI_INITIALIZED = GROUP.registerEvent("uiInitialized");
    private static final EventId MAIN_UI_INITIALIZED = GROUP.registerEvent("mainUiInitialized");
    private static final VarargEventId DETAILS = GROUP.registerVarargEvent("details", new EventField[]{EventFields.Enabled});
    private static final VarargEventId DIFF_PREVIEW = GROUP.registerVarargEvent("diffPreview", new EventField[]{EventFields.Enabled});
    private static final VarargEventId DIFF_PREVIEW_ON_THE_BOTTOM = GROUP.registerVarargEvent("diffPreviewOnTheBottom", new EventField[]{EventFields.Enabled});
    private static final VarargEventId PARENT_CHANGES = GROUP.registerVarargEvent("parentChanges", new EventField[]{EventFields.Enabled});
    private static final VarargEventId ONLY_AFFECTED_CHANGES = GROUP.registerVarargEvent("onlyAffectedChanges", new EventField[]{EventFields.Enabled});
    private static final VarargEventId LONG_EDGES = GROUP.registerVarargEvent("long.edges", new EventField[]{EventFields.Enabled});
    private static final EnumEventField<PermanentGraph.SortType> SORT_TYPE_FIELD = EventFields.Enum((String)"value", PermanentGraph.SortType.class);
    private static final StringEventField GRAPH_OPTIONS_TYPE_FIELD = EventFields.String((String)"value", GraphOptionsUtil.getOptionKindNames());
    private static final VarargEventId SORT = GROUP.registerVarargEvent("sort", new EventField[]{EventFields.Enabled, SORT_TYPE_FIELD});
    private static final VarargEventId GRAPH_OPTIONS_TYPE = GROUP.registerVarargEvent("graphOptionsType", new EventField[]{EventFields.Enabled, GRAPH_OPTIONS_TYPE_FIELD});
    private static final VarargEventId ROOTS = GROUP.registerVarargEvent("roots", new EventField[]{EventFields.Enabled});
    private static final VarargEventId LABELS_COMPACT = GROUP.registerVarargEvent("labels.compact", new EventField[]{EventFields.Enabled});
    private static final VarargEventId LABELS_SHOW_TAG_NAMES = GROUP.registerVarargEvent("labels.showTagNames", new EventField[]{EventFields.Enabled});
    private static final VarargEventId LABELS_ON_THE_LEFT = GROUP.registerVarargEvent("labels.onTheLeft", new EventField[]{EventFields.Enabled});
    private static final VarargEventId SHOW_COMMIT_DATE = GROUP.registerVarargEvent("showCommitDate", new EventField[]{EventFields.Enabled});
    private static final VarargEventId TEXT_FILTER_REGEX = GROUP.registerVarargEvent("textFilter.regex", new EventField[]{EventFields.Enabled});
    private static final VarargEventId TEXT_FILTER_MATCH_CASE = GROUP.registerVarargEvent("textFilter.matchCase", new EventField[]{EventFields.Enabled});
    public static final String THIRD_PARTY = "THIRD_PARTY";
    private static final StringEventField LOG_HIGHLIGHTER_ID_FIELD = EventFields.String((String)"id", List.of("MY_COMMITS", "MERGE_COMMITS", "CURRENT_BRANCH", "THIRD_PARTY"));
    private static final VarargEventId HIGHLIGHTER = GROUP.registerVarargEvent("highlighter", new EventField[]{EventFields.Enabled, LOG_HIGHLIGHTER_ID_FIELD});
    private static final StringEventField FILTER_NAME = EventFields.String((String)"name", (List)ContainerUtil.map((Collection)VcsLogFilterCollection.STANDARD_KEYS, it -> it.getName()));
    private static final VarargEventId FILTER = GROUP.registerVarargEvent("filter", new EventField[]{EventFields.Enabled, FILTER_NAME});
    private static final StringEventField COLUMN_NAME = EventFields.String((String)"name", (List)ContainerUtil.map(VcsLogDefaultColumnKt.getDefaultDynamicColumns(), it -> it.getStableName()));
    private static final VarargEventId COLUMN = GROUP.registerVarargEvent("column", new EventField[]{EventFields.Enabled, COLUMN_NAME});
    private static final VarargEventId ADDITIONAL_TOOL_WINDOW_TABS = GROUP.registerVarargEvent("additionalTabs.ToolWindow", new EventField[]{EventFields.Count});
    private static final VarargEventId ADDITIONAL_EDITOR_TABS = GROUP.registerVarargEvent("additionalTabs.Editor", new EventField[]{EventFields.Count});

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(0);
        }
        if (!TrustedProjects.isTrusted((Project)project)) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                VcsLogFeaturesCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        VcsProjectLog projectLog = (VcsProjectLog)project.getServiceIfCreated(VcsProjectLog.class);
        if (projectLog == null) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                VcsLogFeaturesCollector.$$$reportNull$$$0(2);
            }
            return set;
        }
        VcsProjectLogManager logManager2 = projectLog.getProjectLogManager();
        if (logManager2 == null) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                VcsLogFeaturesCollector.$$$reportNull$$$0(3);
            }
            return set;
        }
        VcsLogUiImpl mainUi = projectLog.getMainLogUi();
        Set<String> additionalTabIds = logManager2.getTabsManager().getTabs();
        List<? extends MainVcsLogUi> additionalToolWindowUis = VcsLogFeaturesCollector.getAdditionalLogUis(logManager2.getLogUis(VcsLogTabLocation.TOOL_WINDOW), additionalTabIds);
        List<? extends MainVcsLogUi> additionalEditorUis = VcsLogFeaturesCollector.getAdditionalLogUis(logManager2.getLogUis(VcsLogTabLocation.EDITOR), additionalTabIds);
        if (mainUi == null && additionalToolWindowUis.isEmpty() && additionalEditorUis.isEmpty()) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                VcsLogFeaturesCollector.$$$reportNull$$$0(4);
            }
            return set;
        }
        HashSet metricEvents = ContainerUtil.newHashSet((Object[])new MetricEvent[]{UI_INITIALIZED.metric()});
        VcsLogFeaturesCollector.recordApplicationProperties((VcsLogApplicationSettings)ApplicationManager.getApplication().getService(VcsLogApplicationSettings.class), metricEvents);
        if (mainUi != null) {
            metricEvents.add(MAIN_UI_INITIALIZED.metric());
            VcsLogFeaturesCollector.recordUiProperties(mainUi, metricEvents);
        }
        for (MainVcsLogUi ui : ContainerUtil.union(additionalToolWindowUis, additionalEditorUis)) {
            VcsLogFeaturesCollector.recordUiProperties(ui, metricEvents);
        }
        if (!additionalToolWindowUis.isEmpty()) {
            metricEvents.add(ADDITIONAL_TOOL_WINDOW_TABS.metric(new EventPair[]{EventFields.Count.with((Object)additionalToolWindowUis.size())}));
        }
        if (!additionalEditorUis.isEmpty()) {
            metricEvents.add(ADDITIONAL_EDITOR_TABS.metric(new EventPair[]{EventFields.Count.with((Object)additionalEditorUis.size())}));
        }
        HashSet hashSet = metricEvents;
        if (hashSet == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static void recordApplicationProperties(@NotNull VcsLogApplicationSettings properties, @NotNull Set<MetricEvent> metricEvents) {
        if (properties == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(6);
        }
        if (metricEvents == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(7);
        }
        VcsLogApplicationSettings defaultProperties = new VcsLogApplicationSettings();
        MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.SHOW_DIFF_PREVIEW), (VarargEventId)DIFF_PREVIEW);
        MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.DIFF_PREVIEW_VERTICAL_SPLIT), (VarargEventId)DIFF_PREVIEW_ON_THE_BOTTOM);
        MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS), (VarargEventId)PARENT_CHANGES);
        MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.COMPACT_REFERENCES_VIEW), (VarargEventId)LABELS_COMPACT);
        MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.SHOW_TAG_NAMES), (VarargEventId)LABELS_SHOW_TAG_NAMES);
        MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.LABELS_LEFT_ALIGNED), (VarargEventId)LABELS_ON_THE_LEFT);
        MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.PREFER_COMMIT_DATE), (VarargEventId)SHOW_COMMIT_DATE);
        VcsLogColumnManager modelIndices = VcsLogColumnManager.getInstance();
        Set currentColumns = ContainerUtil.map2Set(VcsLogColumnUtilKt.getColumnsOrder(properties), it -> modelIndices.getModelIndex((VcsLogColumn<?>)it));
        Set defaultColumns = ContainerUtil.map2Set(VcsLogColumnUtilKt.getColumnsOrder(defaultProperties), it -> modelIndices.getModelIndex((VcsLogColumn<?>)it));
        for (VcsLogDefaultColumn<?> column : VcsLogDefaultColumnKt.getDefaultDynamicColumns()) {
            String columnName = column.getStableName();
            MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)currentColumns, (Object)defaultColumns, p -> p.contains(modelIndices.getModelIndex(column)), (VarargEventId)COLUMN, new ArrayList<EventPair>(List.of(COLUMN_NAME.with((Object)columnName))));
        }
    }

    private static void recordUiProperties(@NotNull MainVcsLogUi ui, @NotNull Set<MetricEvent> metricEvents) {
        if (ui == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(8);
        }
        if (metricEvents == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(9);
        }
        MainVcsLogUiProperties properties = ui.getProperties();
        VcsLogUiProperties defaultProperties = VcsLogFeaturesCollector.createDefaultPropertiesInstance();
        MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.SHOW_DETAILS), (VarargEventId)DETAILS);
        MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES), (VarargEventId)ONLY_AFFECTED_CHANGES);
        MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.SHOW_LONG_EDGES), (VarargEventId)LONG_EDGES);
        MetricEventUtilKt.addIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, p -> GraphOptionsUtil.getKindName(p.get(MainVcsLogUiProperties.GRAPH_OPTIONS)), (VarargEventId)GRAPH_OPTIONS_TYPE, (EventField)GRAPH_OPTIONS_TYPE_FIELD);
        if (properties.get(MainVcsLogUiProperties.GRAPH_OPTIONS) instanceof PermanentGraph.Options.Base) {
            MetricEventUtilKt.addIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, p -> {
                PermanentGraph.Options options = p.get(MainVcsLogUiProperties.GRAPH_OPTIONS);
                if (options instanceof PermanentGraph.Options.Base) {
                    PermanentGraph.Options.Base baseOptions = (PermanentGraph.Options.Base)options;
                    return baseOptions.getSortType();
                }
                return null;
            }, (VarargEventId)SORT, SORT_TYPE_FIELD);
        }
        if (ui.getTable().getColorManager().hasMultiplePaths()) {
            MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.SHOW_ROOT_NAMES), (VarargEventId)ROOTS);
        }
        MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.TEXT_FILTER_REGEX), (VarargEventId)TEXT_FILTER_REGEX);
        MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE), (VarargEventId)TEXT_FILTER_MATCH_CASE);
        for (VcsLogHighlighterFactory factory : AbstractVcsLogUi.LOG_HIGHLIGHTER_FACTORY_EP.getExtensionList()) {
            if (!factory.showMenuItem()) continue;
            MetricEventUtilKt.addBoolIfDiffers(metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.VcsLogHighlighterProperty.get(factory.getId())), (VarargEventId)HIGHLIGHTER, new ArrayList<EventPair>(List.of(LOG_HIGHLIGHTER_ID_FIELD.with((Object)VcsLogFeaturesCollector.getFactoryIdSafe(factory)))));
        }
        for (VcsLogFilterCollection.FilterKey key : VcsLogFilterCollection.STANDARD_KEYS) {
            if (properties.getFilterValues(key.getName()) == null) continue;
            metricEvents.add(FILTER.metric(new EventPair[]{EventFields.Enabled.with((Object)true), FILTER_NAME.with((Object)key.getName())}));
        }
    }

    private static @Unmodifiable @NotNull List<? extends MainVcsLogUi> getAdditionalLogUis(@NotNull List<? extends VcsLogUi> uis, @NotNull Set<String> additionalTabIds) {
        if (uis == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(10);
        }
        if (additionalTabIds == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(11);
        }
        List list = ContainerUtil.filter((Collection)ContainerUtil.filterIsInstance(uis, MainVcsLogUi.class), ui -> additionalTabIds.contains(ui.getId()));
        if (list == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private static String getFactoryIdSafe(@NotNull VcsLogHighlighterFactory factory) {
        if (factory == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(13);
        }
        if (PluginInfoDetectorKt.getPluginInfo(factory.getClass()).isDevelopedByJetBrains()) {
            String string = UsageDescriptorKeyValidator.ensureProperKey((String)factory.getId());
            if (string == null) {
                VcsLogFeaturesCollector.$$$reportNull$$$0(14);
            }
            return string;
        }
        return THIRD_PARTY;
    }

    @NotNull
    private static <T> Function1<VcsLogUiProperties, T> getter(@NotNull VcsLogUiProperties.VcsLogUiProperty<? extends T> property) {
        if (property == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(15);
        }
        Function1 function1 = p -> {
            if (!p.exists(property)) {
                return null;
            }
            return p.get(property);
        };
        if (function1 == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(16);
        }
        return function1;
    }

    @NotNull
    private static VcsLogUiProperties createDefaultPropertiesInstance() {
        return new VcsLogUiPropertiesImpl<VcsLogUiPropertiesImpl.State>(new VcsLogApplicationSettings()){
            @NotNull
            private final VcsLogUiPropertiesImpl.State myState = new VcsLogUiPropertiesImpl.State();

            @Override
            @NotNull
            protected VcsLogUiPropertiesImpl.State getLogUiState() {
                VcsLogUiPropertiesImpl.State state = this.myState;
                if (state == null) {
                    1.$$$reportNull$$$0(0);
                }
                return state;
            }

            @Override
            public void addRecentlyFilteredGroup(@NotNull String filterName, @NotNull Collection<String> values) {
                if (filterName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (values == null) {
                    1.$$$reportNull$$$0(2);
                }
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public List<List<String>> getRecentlyFilteredGroups(@NotNull String filterName) {
                if (filterName == null) {
                    1.$$$reportNull$$$0(3);
                }
                throw new UnsupportedOperationException();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector$1";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filterName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "values";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLogUiState";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "addRecentlyFilteredGroup";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getRecentlyFilteredGroups";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 12, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metricEvents";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uis";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalTabIds";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalLogUis";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryIdSafe";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "recordApplicationProperties";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "recordUiProperties";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalLogUis";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryIdSafe";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 12, 14, 16 -> new IllegalStateException(string);
        };
    }
}

