/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ScriptDebuggerUrls;
import org.jetbrains.debugger.sourcemap.CaseInsensitiveUrlHashingStrategy;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceResolverKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bJ\u0015\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J \u0010\u001d\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0006J\u001d\u0010%\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b&J\u0010\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "", "rawSources", "", "", "trimFileScheme", "", "baseUrl", "Lcom/intellij/util/Url;", "baseUrlIsFile", "<init>", "(Ljava/util/List;ZLcom/intellij/util/Url;Z)V", "canonicalizedUrls", "", "getCanonicalizedUrls", "()[Lcom/intellij/util/Url;", "canonicalizedUrls$delegate", "Lkotlin/Lazy;", "canonicalizedUrlToSourceIndex", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "getCanonicalizedUrlToSourceIndex", "()Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "canonicalizedUrlToSourceIndex$delegate", "getSource", "entry", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getSourceIndex", "", "url", "findSourceIndex", "resolver", "Lorg/jetbrains/debugger/sourcemap/SourceFileResolver;", "findSourceIndex$intellij_platform_scriptDebugger_backend", "sourceUrl", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "localFileUrlOnly", "findSourceIndexByFile", "findSourceIndexByFile$intellij_platform_scriptDebugger_backend", "getUrlIfLocalFile", "Companion", "intellij.platform.scriptDebugger.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSourceResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceResolver.kt\norg/jetbrains/debugger/sourcemap/SourceResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1#2:193\n*E\n"})
public final class SourceResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> rawSources;
    @NotNull
    private final Lazy canonicalizedUrls$delegate;
    @NotNull
    private final Lazy canonicalizedUrlToSourceIndex$delegate;

    public SourceResolver(@NotNull List<String> rawSources, boolean trimFileScheme, @Nullable Url baseUrl, boolean baseUrlIsFile) {
        Intrinsics.checkNotNullParameter(rawSources, (String)"rawSources");
        this.rawSources = rawSources;
        this.canonicalizedUrls$delegate = LazyKt.lazy(() -> SourceResolver.canonicalizedUrls_delegate$lambda$0(this, baseUrl, trimFileScheme, baseUrlIsFile));
        this.canonicalizedUrlToSourceIndex$delegate = LazyKt.lazy(() -> SourceResolver.canonicalizedUrlToSourceIndex_delegate$lambda$1(this));
    }

    public /* synthetic */ SourceResolver(List list2, boolean bl, Url url, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        this(list2, bl, url, bl2);
    }

    @NotNull
    public final Url[] getCanonicalizedUrls() {
        Lazy lazy = this.canonicalizedUrls$delegate;
        return (Url[])lazy.getValue();
    }

    private final Object2IntMap<Url> getCanonicalizedUrlToSourceIndex() {
        Lazy lazy = this.canonicalizedUrlToSourceIndex$delegate;
        return (Object2IntMap)lazy.getValue();
    }

    @Nullable
    public final Url getSource(@NotNull MappingEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        int index = entry.getSource();
        return index < 0 ? null : this.getCanonicalizedUrls()[index];
    }

    public final int getSourceIndex(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getCanonicalizedUrlToSourceIndex().getInt((Object)url);
    }

    public final int findSourceIndex$intellij_platform_scriptDebugger_backend(@NotNull SourceFileResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        int resolveByCanonicalizedUrls = resolver.resolve(this.getCanonicalizedUrlToSourceIndex());
        return resolveByCanonicalizedUrls != -1 ? resolveByCanonicalizedUrls : resolver.resolve(this.rawSources);
    }

    public final int findSourceIndex(@NotNull Url sourceUrl, @Nullable VirtualFile sourceFile, boolean localFileUrlOnly) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        int index = this.getCanonicalizedUrlToSourceIndex().getInt((Object)sourceUrl);
        if (index != -1) {
            return index;
        }
        if (sourceFile != null) {
            return this.findSourceIndexByFile$intellij_platform_scriptDebugger_backend(sourceFile, localFileUrlOnly);
        }
        return -1;
    }

    public final int findSourceIndexByFile$intellij_platform_scriptDebugger_backend(@NotNull VirtualFile sourceFile, boolean localFileUrlOnly) {
        int index;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        if (!localFileUrlOnly && (index = this.getCanonicalizedUrlToSourceIndex().getInt((Object)Urls.newFromVirtualFile((VirtualFile)sourceFile).trimParameters())) != -1) {
            return index;
        }
        if (!sourceFile.isInLocalFileSystem()) {
            return -1;
        }
        index = this.getCanonicalizedUrlToSourceIndex().getInt((Object)ScriptDebuggerUrls.newLocalFileUrl(sourceFile));
        if (index != -1) {
            return index;
        }
        VirtualFile canonicalFile = sourceFile.getCanonicalFile();
        if (canonicalFile != null && !Intrinsics.areEqual((Object)canonicalFile, (Object)sourceFile)) {
            int n = this.getCanonicalizedUrls().length;
            for (int i = 0; i < n; ++i) {
                Url url = this.getCanonicalizedUrls()[i];
                if (!Urls.INSTANCE.equalsIgnoreParameters(url, canonicalFile)) continue;
                return i;
            }
        }
        return -1;
    }

    @Nullable
    public final Url getUrlIfLocalFile(@NotNull MappingEntry entry) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Url url = (Url)ArraysKt.getOrNull((Object[])this.getCanonicalizedUrls(), (int)entry.getSource());
        if (url != null) {
            Url it = url;
            boolean bl = false;
            object = it.isInLocalFileSystem() ? it : null;
        } else {
            object = null;
        }
        return object;
    }

    private static final Url[] canonicalizedUrls_delegate$lambda$0(SourceResolver this$0, Url $baseUrl, boolean $trimFileScheme, boolean $baseUrlIsFile) {
        int n = 0;
        int n2 = this$0.rawSources.size();
        Url[] urlArray = new Url[n2];
        while (n < n2) {
            int n3 = n++;
            urlArray[n3] = SourceResolverKt.canonicalizeUrl(this$0.rawSources.get(n3), $baseUrl, $trimFileScheme, $baseUrlIsFile);
        }
        return urlArray;
    }

    private static final Object2IntMap canonicalizedUrlToSourceIndex_delegate$lambda$1(SourceResolver this$0) {
        Object2IntMap map = SystemInfo.isFileSystemCaseSensitive ? (Object2IntMap)new Object2IntOpenHashMap(this$0.rawSources.size()) : (Object2IntMap)new Object2IntOpenCustomHashMap(this$0.rawSources.size(), (Hash.Strategy)CaseInsensitiveUrlHashingStrategy.INSTANCE);
        map.defaultReturnValue(-1);
        int n = ((Collection)this$0.rawSources).size();
        for (int i = 0; i < n; ++i) {
            map.put((Object)this$0.getCanonicalizedUrls()[i], i);
        }
        return map;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceResolver$Companion;", "", "<init>", "()V", "isAbsolute", "", "path", "", "intellij.platform.scriptDebugger.backend"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAbsolute(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) || SystemInfo.isWindows && path.length() > 2 && path.charAt(1) == ':';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

