/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparatorCore;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0016J\u0006\u0010\u0015\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/textmate/language/preferences/SnippetsRegistryImpl;", "Lorg/jetbrains/plugins/textmate/language/preferences/SnippetsRegistry;", "weigher", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;", "<init>", "(Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;)V", "mySnippets", "", "", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/plugins/textmate/language/preferences/TextMateSnippet;", "register", "", "snippet", "findSnippet", "", "key", "scope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "getAvailableSnippets", "scopeSelector", "clear", "intellij.textmate.core"})
@SourceDebugExtension(value={"SMAP\nSnippetsRegistryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnippetsRegistryImpl.kt\norg/jetbrains/plugins/textmate/language/preferences/SnippetsRegistryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1368#2:43\n1454#2,5:44\n*S KotlinDebug\n*F\n+ 1 SnippetsRegistryImpl.kt\norg/jetbrains/plugins/textmate/language/preferences/SnippetsRegistryImpl\n*L\n35#1:43\n35#1:44,5\n*E\n"})
public final class SnippetsRegistryImpl
implements SnippetsRegistry {
    @NotNull
    private final TextMateSelectorWeigher weigher;
    @NotNull
    private final Map<String, PersistentList<TextMateSnippet>> mySnippets;

    public SnippetsRegistryImpl(@NotNull TextMateSelectorWeigher weigher) {
        Intrinsics.checkNotNullParameter((Object)weigher, (String)"weigher");
        this.weigher = weigher;
        this.mySnippets = new ConcurrentHashMap();
    }

    public final void register(@NotNull TextMateSnippet snippet) {
        Intrinsics.checkNotNullParameter((Object)snippet, (String)"snippet");
        this.mySnippets.compute(snippet.getKey(), (arg_0, arg_1) -> SnippetsRegistryImpl.register$lambda$1((arg_0, arg_1) -> SnippetsRegistryImpl.register$lambda$0(snippet, arg_0, arg_1), arg_0, arg_1));
    }

    @Override
    @NotNull
    public Collection<TextMateSnippet> findSnippet(@NotNull String key, @Nullable TextMateScope scope) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (scope == null) {
            return CollectionsKt.emptyList();
        }
        PersistentList<TextMateSnippet> snippets = this.mySnippets.get(key);
        if (snippets == null) {
            return CollectionsKt.emptyList();
        }
        return new TextMateScopeComparatorCore(this.weigher, scope, (Function1)findSnippet.1.INSTANCE).sortAndFilter((Collection)snippets);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<TextMateSnippet> getAvailableSnippets(@Nullable TextMateScope scopeSelector) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        if (scopeSelector == null) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = this.mySnippets.values();
        TextMateScopeComparatorCore textMateScopeComparatorCore = new TextMateScopeComparatorCore(this.weigher, scopeSelector, (Function1)getAvailableSnippets.1.INSTANCE);
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PersistentList it = (PersistentList)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)it;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return textMateScopeComparatorCore.sortAndFilter((List)destination$iv$iv);
    }

    public final void clear() {
        this.mySnippets.clear();
    }

    private static final PersistentList register$lambda$0(TextMateSnippet $snippet, String k, PersistentList v) {
        PersistentList persistentList = v;
        if (persistentList == null || (persistentList = persistentList.add((Object)$snippet)) == null) {
            Object[] objectArray = new TextMateSnippet[]{$snippet};
            persistentList = ExtensionsKt.persistentListOf((Object[])objectArray);
        }
        return persistentList;
    }

    private static final PersistentList register$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (PersistentList)$tmp0.invoke(p0, p1);
    }
}

