/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparatorCore;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.TextMateAutoClosingPair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bJ\u0018\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u000f2\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001bH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0006\u0010%\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/textmate/language/preferences/PreferencesRegistryImpl;", "Lorg/jetbrains/plugins/textmate/language/preferences/PreferencesRegistry;", "weigher", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;", "<init>", "(Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;)V", "myPreferences", "", "Lorg/jetbrains/plugins/textmate/language/preferences/Preferences;", "myLeftHighlightingBraces", "", "myRightHighlightingBraces", "myLeftSmartTypingBraces", "myRightSmartTypingBraces", "addPreferences", "", "preferences", "fillHighlightingBraces", "highlightingPairs", "", "Lorg/jetbrains/plugins/textmate/language/preferences/TextMateBracePair;", "fillSmartTypingBraces", "smartTypingPairs", "Lorg/jetbrains/plugins/textmate/language/preferences/TextMateAutoClosingPair;", "isPossibleLeftHighlightingBrace", "", "firstLeftBraceChar", "", "isPossibleRightHighlightingBrace", "lastRightBraceChar", "isPossibleLeftSmartTypingBrace", "lastLeftBraceChar", "isPossibleRightSmartTypingBrace", "getPreferences", "", "scope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "clear", "intellij.textmate.core"})
public final class PreferencesRegistryImpl
implements PreferencesRegistry {
    @NotNull
    private final TextMateSelectorWeigher weigher;
    @NotNull
    private final Set<Preferences> myPreferences;
    @NotNull
    private final Set<Integer> myLeftHighlightingBraces;
    @NotNull
    private final Set<Integer> myRightHighlightingBraces;
    @NotNull
    private final Set<Integer> myLeftSmartTypingBraces;
    @NotNull
    private final Set<Integer> myRightSmartTypingBraces;

    public PreferencesRegistryImpl(@NotNull TextMateSelectorWeigher weigher) {
        Intrinsics.checkNotNullParameter((Object)weigher, (String)"weigher");
        this.weigher = weigher;
        this.myPreferences = new LinkedHashSet();
        this.myLeftHighlightingBraces = new LinkedHashSet();
        this.myRightHighlightingBraces = new LinkedHashSet();
        this.myLeftSmartTypingBraces = new LinkedHashSet();
        this.myRightSmartTypingBraces = new LinkedHashSet();
        this.fillHighlightingBraces((Collection<TextMateBracePair>)Constants.Companion.getDEFAULT_HIGHLIGHTING_BRACE_PAIRS());
        this.fillSmartTypingBraces((Collection<TextMateAutoClosingPair>)Constants.Companion.getDEFAULT_SMART_TYPING_BRACE_PAIRS());
    }

    public final synchronized void addPreferences(@NotNull Preferences preferences) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        this.fillHighlightingBraces((Collection<TextMateBracePair>)preferences.getHighlightingPairs());
        this.fillSmartTypingBraces((Collection<TextMateAutoClosingPair>)preferences.getSmartTypingPairs());
        this.myPreferences.add(preferences);
    }

    private final synchronized void fillHighlightingBraces(Collection<TextMateBracePair> highlightingPairs) {
        if (highlightingPairs != null) {
            for (TextMateBracePair pair : highlightingPairs) {
                if (!(((CharSequence)pair.getLeft()).length() == 0)) {
                    this.myLeftHighlightingBraces.add(Integer.valueOf(pair.getLeft().charAt(0)));
                }
                if (((CharSequence)pair.getRight()).length() == 0) continue;
                this.myRightHighlightingBraces.add(Integer.valueOf(pair.getRight().charAt(pair.getRight().length() - 1)));
            }
        }
    }

    private final void fillSmartTypingBraces(Collection<TextMateAutoClosingPair> smartTypingPairs) {
        if (smartTypingPairs != null) {
            for (TextMateAutoClosingPair pair : smartTypingPairs) {
                if (!(pair.getLeft().length() == 0)) {
                    this.myLeftSmartTypingBraces.add(Integer.valueOf(pair.getLeft().charAt(pair.getLeft().length() - 1)));
                }
                if (pair.getRight().length() == 0) continue;
                this.myRightSmartTypingBraces.add(Integer.valueOf(pair.getRight().charAt(pair.getRight().length() - 1)));
            }
        }
    }

    @Override
    public synchronized boolean isPossibleLeftHighlightingBrace(char firstLeftBraceChar) {
        return this.myLeftHighlightingBraces.contains(firstLeftBraceChar) || firstLeftBraceChar != ' ' && this.myLeftSmartTypingBraces.contains(firstLeftBraceChar);
    }

    @Override
    public synchronized boolean isPossibleRightHighlightingBrace(char lastRightBraceChar) {
        return this.myRightHighlightingBraces.contains(lastRightBraceChar) || lastRightBraceChar != ' ' && this.myRightSmartTypingBraces.contains(lastRightBraceChar);
    }

    @Override
    public synchronized boolean isPossibleLeftSmartTypingBrace(char lastLeftBraceChar) {
        return this.myLeftSmartTypingBraces.contains(lastLeftBraceChar);
    }

    @Override
    public synchronized boolean isPossibleRightSmartTypingBrace(char lastRightBraceChar) {
        return this.myRightSmartTypingBraces.contains(lastRightBraceChar);
    }

    @Override
    @NotNull
    public synchronized List<Preferences> getPreferences(@NotNull TextMateScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return new TextMateScopeComparatorCore(this.weigher, scope, (Function1)getPreferences.1.INSTANCE).sortAndFilter((Collection)this.myPreferences);
    }

    public final synchronized void clear() {
        this.myPreferences.clear();
        this.myLeftHighlightingBraces.clear();
        this.myRightHighlightingBraces.clear();
        this.fillHighlightingBraces((Collection<TextMateBracePair>)Constants.Companion.getDEFAULT_HIGHLIGHTING_BRACE_PAIRS());
        this.myLeftSmartTypingBraces.clear();
        this.myRightSmartTypingBraces.clear();
        this.fillSmartTypingBraces((Collection<TextMateAutoClosingPair>)Constants.Companion.getDEFAULT_SMART_TYPING_BRACE_PAIRS());
    }
}

