Changelog
=========

## [v28.9.0] - 2026-02-02
### :boom: BREAKING CHANGES
- due to [`e9ff474`](https://github.com/tobymao/sqlglot/commit/e9ff4743e63c332ae8a4a101f976d4909918992a) - Annotate MINUTE, MONTH for DuckDB *(PR [#6919](https://github.com/tobymao/sqlglot/pull/6919) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate MINUTE, MONTH for DuckDB (#6919)

- due to [`96dc339`](https://github.com/tobymao/sqlglot/commit/96dc339e0811c70dd12f92c297d2ff25456c71b7) - Annotate DAYOFWEEK, DAYOFYEAR for DuckDB *(PR [#6920](https://github.com/tobymao/sqlglot/pull/6920) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate DAYOFWEEK, DAYOFYEAR for DuckDB (#6920)

- due to [`b56f685`](https://github.com/tobymao/sqlglot/commit/b56f685193982590ea03b681cf542c0157e751d4) - Annotate DAY, HOUR, SECOND and DAYOFMONTH *(PR [#6922](https://github.com/tobymao/sqlglot/pull/6922) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate DAY, HOUR, SECOND and DAYOFMONTH (#6922)

- due to [`6e418ec`](https://github.com/tobymao/sqlglot/commit/6e418ecc95085e41a4fe4fed856bc3a08f4c46f8) - Annotate EPOCH(expr) for DuckDB *(PR [#6924](https://github.com/tobymao/sqlglot/pull/6924) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate EPOCH(expr) for DuckDB (#6924)

- due to [`abd8d1b`](https://github.com/tobymao/sqlglot/commit/abd8d1bc5d892299dbe46a8208e23a4b2c1c833b) - Transpilation of SHA1 from Snowflake to DuckDB  *(PR [#6888](https://github.com/tobymao/sqlglot/pull/6888) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Transpilation of SHA1 from Snowflake to DuckDB  (#6888)

- due to [`b2f5430`](https://github.com/tobymao/sqlglot/commit/b2f543030789ccf889fc6e065985fbeb821c26b7) - Annotate TO_DAYS(expr) for DuckDB *(PR [#6925](https://github.com/tobymao/sqlglot/pull/6925) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate TO_DAYS(expr) for DuckDB (#6925)


### :sparkles: New Features
- [`e9ff474`](https://github.com/tobymao/sqlglot/commit/e9ff4743e63c332ae8a4a101f976d4909918992a) - **optimizer**: Annotate MINUTE, MONTH for DuckDB *(PR [#6919](https://github.com/tobymao/sqlglot/pull/6919) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`96dc339`](https://github.com/tobymao/sqlglot/commit/96dc339e0811c70dd12f92c297d2ff25456c71b7) - **optimizer**: Annotate DAYOFWEEK, DAYOFYEAR for DuckDB *(PR [#6920](https://github.com/tobymao/sqlglot/pull/6920) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`b56f685`](https://github.com/tobymao/sqlglot/commit/b56f685193982590ea03b681cf542c0157e751d4) - **optimizer**: Annotate DAY, HOUR, SECOND and DAYOFMONTH *(PR [#6922](https://github.com/tobymao/sqlglot/pull/6922) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`6e418ec`](https://github.com/tobymao/sqlglot/commit/6e418ecc95085e41a4fe4fed856bc3a08f4c46f8) - **optimizer**: Annotate EPOCH(expr) for DuckDB *(PR [#6924](https://github.com/tobymao/sqlglot/pull/6924) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`abd8d1b`](https://github.com/tobymao/sqlglot/commit/abd8d1bc5d892299dbe46a8208e23a4b2c1c833b) - **snowflake**: Transpilation of SHA1 from Snowflake to DuckDB  *(PR [#6888](https://github.com/tobymao/sqlglot/pull/6888) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`b2f5430`](https://github.com/tobymao/sqlglot/commit/b2f543030789ccf889fc6e065985fbeb821c26b7) - **optimizer**: Annotate TO_DAYS(expr) for DuckDB *(PR [#6925](https://github.com/tobymao/sqlglot/pull/6925) by [@AbhishekASLK](https://github.com/AbhishekASLK))*

### :wrench: Chores
- [`dfb2d3b`](https://github.com/tobymao/sqlglot/commit/dfb2d3b17d20f69536620976676a2b7248fdb699) - generate API docs before checking out api-docs branch *(PR [#6921](https://github.com/tobymao/sqlglot/pull/6921) by [@georgesittas](https://github.com/georgesittas))*


## [v28.8.0] - 2026-02-02
### :boom: BREAKING CHANGES
- due to [`9d2a12a`](https://github.com/tobymao/sqlglot/commit/9d2a12a650afcdaffe780144af26a0f21a6ec4e6) - Annotate SIN for DuckDB *(PR [#6892](https://github.com/tobymao/sqlglot/pull/6892) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate SIN for DuckDB (#6892)

- due to [`d8e13ae`](https://github.com/tobymao/sqlglot/commit/d8e13ae8c3f14495fd7ea356bf53e338e6a5347e) - Annotate COS for DuckDB *(PR [#6893](https://github.com/tobymao/sqlglot/pull/6893) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate COS for DuckDB (#6893)

- due to [`25f718c`](https://github.com/tobymao/sqlglot/commit/25f718cea3a62034d6a5c263e80e5b0363e3f394) - Annotate STUFF for TSQL *(PR [#6890](https://github.com/tobymao/sqlglot/pull/6890) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate STUFF for TSQL (#6890)

- due to [`bec45a5`](https://github.com/tobymao/sqlglot/commit/bec45a55377e9802fe5c572371834e12d760f180) - Annotate `ISINF(expr)` for DuckDB *(PR [#6894](https://github.com/tobymao/sqlglot/pull/6894) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate `ISINF(expr)` for DuckDB (#6894)

- due to [`aab8243`](https://github.com/tobymao/sqlglot/commit/aab8243a19d776c65473e67a2dcb1fb71af19175) - Annotate ISNAN(expr) for Base *(PR [#6895](https://github.com/tobymao/sqlglot/pull/6895) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate ISNAN(expr) for Base (#6895)

- due to [`482128e`](https://github.com/tobymao/sqlglot/commit/482128e30aa0d607b7e5fcd2bde142eefcf02c4a) - Annotate TAN for DuckDB *(PR [#6896](https://github.com/tobymao/sqlglot/pull/6896) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate TAN for DuckDB (#6896)

- due to [`a6d7f6e`](https://github.com/tobymao/sqlglot/commit/a6d7f6e1ef9cd5d22598a3e21cc69162b07c28a1) - Annotate `COT` for DuckDB *(PR [#6897](https://github.com/tobymao/sqlglot/pull/6897) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate `COT` for DuckDB (#6897)

- due to [`2ec7c2b`](https://github.com/tobymao/sqlglot/commit/2ec7c2b4a58bad3e736d021e7e414d00e7c16187) - Annotate RANDOM() for DuckDB *(PR [#6898](https://github.com/tobymao/sqlglot/pull/6898) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate RANDOM() for DuckDB (#6898)

- due to [`a0b053d`](https://github.com/tobymao/sqlglot/commit/a0b053d10c5d7303f0f335be8ffe235f5a8727d9) - Annotate ATAN(expr) for DuckDB *(PR [#6900](https://github.com/tobymao/sqlglot/pull/6900) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate ATAN(expr) for DuckDB (#6900)

- due to [`f39b514`](https://github.com/tobymao/sqlglot/commit/f39b514936e6188799bf1c392937050d8aef6ac8) - Annotate ASIN(expr) for DuckDB *(PR [#6901](https://github.com/tobymao/sqlglot/pull/6901) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate ASIN(expr) for DuckDB (#6901)

- due to [`5fb98a1`](https://github.com/tobymao/sqlglot/commit/5fb98a1a0106b2e4740f8ae72fabeb424dacd07e) - Annotate ACOS(expr) for DuckDB *(PR [#6902](https://github.com/tobymao/sqlglot/pull/6902) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate ACOS(expr) for DuckDB (#6902)

- due to [`9e95d95`](https://github.com/tobymao/sqlglot/commit/9e95d95578ac8cb07076322c9f099467f17efb3f) - Annotate ASINH(expr), ACOSH(expr), ATANH(expr) for DuckDB *(PR [#6903](https://github.com/tobymao/sqlglot/pull/6903) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate ASINH(expr), ACOSH(expr), ATANH(expr) for DuckDB (#6903)

- due to [`a8fef30`](https://github.com/tobymao/sqlglot/commit/a8fef30ed6760bd095bd2c6b156ea7cd80c322d0) - Annotate DEGREES(expr) for MySQL *(PR [#6913](https://github.com/tobymao/sqlglot/pull/6913) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate DEGREES(expr) for MySQL (#6913)

- due to [`887d03a`](https://github.com/tobymao/sqlglot/commit/887d03af0fa10aef492cb54d8b48e5fc3a1ee6d1) - Annotate arc trignometric func for MySQL *(PR [#6912](https://github.com/tobymao/sqlglot/pull/6912) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate arc trignometric func for MySQL (#6912)

- due to [`dc6bc5a`](https://github.com/tobymao/sqlglot/commit/dc6bc5af83dc6c2d9dee3ae82b7792fdc285450e) - Annotate SIN, COS, TAN, COT for MySQL *(PR [#6911](https://github.com/tobymao/sqlglot/pull/6911) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate SIN, COS, TAN, COT for MySQL (#6911)

- due to [`6cae76f`](https://github.com/tobymao/sqlglot/commit/6cae76fb6de11b2b49db0bb5409495ddb676da05) - Annotate `SECOND(expr)` to `INT` *(PR [#6910](https://github.com/tobymao/sqlglot/pull/6910) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate `SECOND(expr)` to `INT` (#6910)

- due to [`bd595a6`](https://github.com/tobymao/sqlglot/commit/bd595a6afb724ed1e5ca64122bf1dd69a3adc473) - Annotate QUARTER(expr) for DuckDB *(PR [#6905](https://github.com/tobymao/sqlglot/pull/6905) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate QUARTER(expr) for DuckDB (#6905)

- due to [`8e625b5`](https://github.com/tobymao/sqlglot/commit/8e625b5fae51659c2317a9c7a732114e047da9e0) - Annotate ATAN2 for DuckDB *(PR [#6904](https://github.com/tobymao/sqlglot/pull/6904) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate ATAN2 for DuckDB (#6904)

- due to [`ea678d2`](https://github.com/tobymao/sqlglot/commit/ea678d26dee0bfb223660b587744c6635c036f2f) - support transpilation of CURRENT_TIME from snowflake to duckdb *(PR [#6909](https://github.com/tobymao/sqlglot/pull/6909) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation of CURRENT_TIME from snowflake to duckdb (#6909)

- due to [`8e4f4b3`](https://github.com/tobymao/sqlglot/commit/8e4f4b386cd5f7484bbe32c9d8921e2fef4b02c1) - Annotate QUARTER(expr) to INT instead of TINYINT *(PR [#6906](https://github.com/tobymao/sqlglot/pull/6906) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate QUARTER(expr) to INT instead of TINYINT (#6906)

- due to [`a94e45a`](https://github.com/tobymao/sqlglot/commit/a94e45a3c55f744b20c35c2a5cc61bab0a3678d7) - Annotate MONTH(expr) to INT instead of TINYINT *(PR [#6907](https://github.com/tobymao/sqlglot/pull/6907) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate MONTH(expr) to INT instead of TINYINT (#6907)

- due to [`db51b75`](https://github.com/tobymao/sqlglot/commit/db51b7517229df2c6cf446962a9732e548a168f5) - Moved `YEAR`, `QUARTER`, `WEEK` to snowflake *(PR [#6918](https://github.com/tobymao/sqlglot/pull/6918) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Moved `YEAR`, `QUARTER`, `WEEK` to snowflake (#6918)


### :sparkles: New Features
- [`9d2a12a`](https://github.com/tobymao/sqlglot/commit/9d2a12a650afcdaffe780144af26a0f21a6ec4e6) - **duckdb**: Annotate SIN for DuckDB *(PR [#6892](https://github.com/tobymao/sqlglot/pull/6892) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`d8e13ae`](https://github.com/tobymao/sqlglot/commit/d8e13ae8c3f14495fd7ea356bf53e338e6a5347e) - **optimizer**: Annotate COS for DuckDB *(PR [#6893](https://github.com/tobymao/sqlglot/pull/6893) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`25f718c`](https://github.com/tobymao/sqlglot/commit/25f718cea3a62034d6a5c263e80e5b0363e3f394) - **tsql**: Annotate STUFF for TSQL *(PR [#6890](https://github.com/tobymao/sqlglot/pull/6890) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`bec45a5`](https://github.com/tobymao/sqlglot/commit/bec45a55377e9802fe5c572371834e12d760f180) - **optimizer**: Annotate `ISINF(expr)` for DuckDB *(PR [#6894](https://github.com/tobymao/sqlglot/pull/6894) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`aab8243`](https://github.com/tobymao/sqlglot/commit/aab8243a19d776c65473e67a2dcb1fb71af19175) - **optimmizer**: Annotate ISNAN(expr) for Base *(PR [#6895](https://github.com/tobymao/sqlglot/pull/6895) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`482128e`](https://github.com/tobymao/sqlglot/commit/482128e30aa0d607b7e5fcd2bde142eefcf02c4a) - **optimizer**: Annotate TAN for DuckDB *(PR [#6896](https://github.com/tobymao/sqlglot/pull/6896) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`a6d7f6e`](https://github.com/tobymao/sqlglot/commit/a6d7f6e1ef9cd5d22598a3e21cc69162b07c28a1) - **optimizer**: Annotate `COT` for DuckDB *(PR [#6897](https://github.com/tobymao/sqlglot/pull/6897) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`2ec7c2b`](https://github.com/tobymao/sqlglot/commit/2ec7c2b4a58bad3e736d021e7e414d00e7c16187) - **optimizer**: Annotate RANDOM() for DuckDB *(PR [#6898](https://github.com/tobymao/sqlglot/pull/6898) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`a0b053d`](https://github.com/tobymao/sqlglot/commit/a0b053d10c5d7303f0f335be8ffe235f5a8727d9) - **optimizer**: Annotate ATAN(expr) for DuckDB *(PR [#6900](https://github.com/tobymao/sqlglot/pull/6900) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`f39b514`](https://github.com/tobymao/sqlglot/commit/f39b514936e6188799bf1c392937050d8aef6ac8) - **optimmizer**: Annotate ASIN(expr) for DuckDB *(PR [#6901](https://github.com/tobymao/sqlglot/pull/6901) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`5fb98a1`](https://github.com/tobymao/sqlglot/commit/5fb98a1a0106b2e4740f8ae72fabeb424dacd07e) - **optimizer**: Annotate ACOS(expr) for DuckDB *(PR [#6902](https://github.com/tobymao/sqlglot/pull/6902) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`9e95d95`](https://github.com/tobymao/sqlglot/commit/9e95d95578ac8cb07076322c9f099467f17efb3f) - **optimizer**: Annotate ASINH(expr), ACOSH(expr), ATANH(expr) for DuckDB *(PR [#6903](https://github.com/tobymao/sqlglot/pull/6903) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`a8fef30`](https://github.com/tobymao/sqlglot/commit/a8fef30ed6760bd095bd2c6b156ea7cd80c322d0) - **optimizer**: Annotate DEGREES(expr) for MySQL *(PR [#6913](https://github.com/tobymao/sqlglot/pull/6913) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`887d03a`](https://github.com/tobymao/sqlglot/commit/887d03af0fa10aef492cb54d8b48e5fc3a1ee6d1) - **optimizer**: Annotate arc trignometric func for MySQL *(PR [#6912](https://github.com/tobymao/sqlglot/pull/6912) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`dc6bc5a`](https://github.com/tobymao/sqlglot/commit/dc6bc5af83dc6c2d9dee3ae82b7792fdc285450e) - **optimizer**: Annotate SIN, COS, TAN, COT for MySQL *(PR [#6911](https://github.com/tobymao/sqlglot/pull/6911) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`6cae76f`](https://github.com/tobymao/sqlglot/commit/6cae76fb6de11b2b49db0bb5409495ddb676da05) - **mysql**: Annotate `SECOND(expr)` to `INT` *(PR [#6910](https://github.com/tobymao/sqlglot/pull/6910) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`bd595a6`](https://github.com/tobymao/sqlglot/commit/bd595a6afb724ed1e5ca64122bf1dd69a3adc473) - **optimizer**: Annotate QUARTER(expr) for DuckDB *(PR [#6905](https://github.com/tobymao/sqlglot/pull/6905) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`8e625b5`](https://github.com/tobymao/sqlglot/commit/8e625b5fae51659c2317a9c7a732114e047da9e0) - **optimizer**: Annotate ATAN2 for DuckDB *(PR [#6904](https://github.com/tobymao/sqlglot/pull/6904) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`ea678d2`](https://github.com/tobymao/sqlglot/commit/ea678d26dee0bfb223660b587744c6635c036f2f) - **snowflake**: support transpilation of CURRENT_TIME from snowflake to duckdb *(PR [#6909](https://github.com/tobymao/sqlglot/pull/6909) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`db51b75`](https://github.com/tobymao/sqlglot/commit/db51b7517229df2c6cf446962a9732e548a168f5) - **optimizer**: Moved `YEAR`, `QUARTER`, `WEEK` to snowflake *(PR [#6918](https://github.com/tobymao/sqlglot/pull/6918) by [@AbhishekASLK](https://github.com/AbhishekASLK))*

### :bug: Bug Fixes
- [`8e4f4b3`](https://github.com/tobymao/sqlglot/commit/8e4f4b386cd5f7484bbe32c9d8921e2fef4b02c1) - **optimizer**: Annotate QUARTER(expr) to INT instead of TINYINT *(PR [#6906](https://github.com/tobymao/sqlglot/pull/6906) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`a94e45a`](https://github.com/tobymao/sqlglot/commit/a94e45a3c55f744b20c35c2a5cc61bab0a3678d7) - **mysql**: Annotate MONTH(expr) to INT instead of TINYINT *(PR [#6907](https://github.com/tobymao/sqlglot/pull/6907) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`1fd5914`](https://github.com/tobymao/sqlglot/commit/1fd591403ad306912ac448a761540662c7a7f487) - **parser**: Literal number strings *(PR [#6916](https://github.com/tobymao/sqlglot/pull/6916) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6908](https://github.com/tobymao/sqlglot/issues/6908) opened by [@Matt711](https://github.com/Matt711)*
- [`0a065be`](https://github.com/tobymao/sqlglot/commit/0a065be1e00739f47f52166b7cbc890f1a4aea41) - **postgres**: Allow reserved tokens too in EXCLUDE WITH constraint *(PR [#6917](https://github.com/tobymao/sqlglot/pull/6917) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6914](https://github.com/tobymao/sqlglot/issues/6914) opened by [@Badg](https://github.com/Badg)*

### :wrench: Chores
- [`a65c870`](https://github.com/tobymao/sqlglot/commit/a65c8701a30652bfadd4d39cf729a9e13c1fa769) - add CLAUDE.md to document guidelines for SQLGlot coding *(PR [#6899](https://github.com/tobymao/sqlglot/pull/6899) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*


## [v28.7.0] - 2026-01-30
### :boom: BREAKING CHANGES
- due to [`ed4ba08`](https://github.com/tobymao/sqlglot/commit/ed4ba08940212f7ed9b67ea01b51f8df38fe85d2) - add support for Bitwise NOT *(PR [#6740](https://github.com/tobymao/sqlglot/pull/6740) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  add support for Bitwise NOT (#6740)

- due to [`894c581`](https://github.com/tobymao/sqlglot/commit/894c5817fea304b16589710f266b3176f768aab6) - annotate cot for spark and dbx *(PR [#6739](https://github.com/tobymao/sqlglot/pull/6739) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  annotate cot for spark and dbx (#6739)

- due to [`cc18c55`](https://github.com/tobymao/sqlglot/commit/cc18c55c0acf0546607187e8910cdd2a9559f15f) - add COSH function annotation for Hive and related dialects *(PR [#6738](https://github.com/tobymao/sqlglot/pull/6738) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  add COSH function annotation for Hive and related dialects (#6738)

- due to [`03dd8bd`](https://github.com/tobymao/sqlglot/commit/03dd8bd6ec9bdf1a8dfe77130bb1eb968d3cf3d8) - add SINH function annotation for Hive and related dialects *(PR [#6736](https://github.com/tobymao/sqlglot/pull/6736) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  add SINH function annotation for Hive and related dialects (#6736)

- due to [`1c9cf7b`](https://github.com/tobymao/sqlglot/commit/1c9cf7bfed3f819957110964f5c44794a3e9a8bb) - annotate snowflake ARRAY_COMPACT *(PR [#6735](https://github.com/tobymao/sqlglot/pull/6735) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate snowflake ARRAY_COMPACT (#6735)

- due to [`9b1a634`](https://github.com/tobymao/sqlglot/commit/9b1a6343e2ed862241d5e1a7aee8e766e74c83eb) - cast APPROX_QUANTILE results to DOUBLE to respect Snowflake's typing during transpilation *(PR [#6734](https://github.com/tobymao/sqlglot/pull/6734) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  cast APPROX_QUANTILE results to DOUBLE to respect Snowflake's typing during transpilation (#6734)

- due to [`f644541`](https://github.com/tobymao/sqlglot/commit/f644541b2b27896f370e253ac4b5751ac5892f28) - add TO_BINARY function annotation for Spark and DBX dialect *(PR [#6743](https://github.com/tobymao/sqlglot/pull/6743) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  add TO_BINARY function annotation for Spark and DBX dialect (#6743)

- due to [`aeaa43d`](https://github.com/tobymao/sqlglot/commit/aeaa43d16fb3fc01f3d4297badf3953c6d18ae9c) - Preserve key name in STRUCT for all identifiers *(PR [#6744](https://github.com/tobymao/sqlglot/pull/6744) by [@VaggelisD](https://github.com/VaggelisD))*:

  Preserve key name in STRUCT for all identifiers (#6744)

- due to [`27a7b68`](https://github.com/tobymao/sqlglot/commit/27a7b6838d7a06d3ba335a937f7b158415c28b40) - add annotation for ACOS function *(PR [#6747](https://github.com/tobymao/sqlglot/pull/6747) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  add annotation for ACOS function (#6747)

- due to [`7b5279c`](https://github.com/tobymao/sqlglot/commit/7b5279ccda0bd8947b9b244c221f03883e8865cf) - Fix optimizer for generate series *(PR [#6679](https://github.com/tobymao/sqlglot/pull/6679) by [@chrisqu777](https://github.com/chrisqu777))*:

  Fix optimizer for generate series (#6679)

- due to [`a5ccfbb`](https://github.com/tobymao/sqlglot/commit/a5ccfbb1dd2fe7a1738e36fbc15dafdd00d25036) - add SHA function annotations for Hive *(PR [#6750](https://github.com/tobymao/sqlglot/pull/6750) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  add SHA function annotations for Hive (#6750)

- due to [`2191273`](https://github.com/tobymao/sqlglot/commit/219127309652ecd5a32940b09a29e10a00171866) - Transpilation support for Snowflake's BITMAP_CONSTRUCT_AGG function to DuckDB *(PR [#6745](https://github.com/tobymao/sqlglot/pull/6745) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Transpilation support for Snowflake's BITMAP_CONSTRUCT_AGG function to DuckDB (#6745)

- due to [`ee0b213`](https://github.com/tobymao/sqlglot/commit/ee0b21355106861c74c3f67de5c1e6b0bb2a7f15) - Annotate RANDN function for Spark and DBX *(PR [#6751](https://github.com/tobymao/sqlglot/pull/6751) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate RANDN function for Spark and DBX (#6751)

- due to [`e643817`](https://github.com/tobymao/sqlglot/commit/e6438170298e8dd90ccc3debe5065af7e0bcaa5e) - Annotate `SPACE` function to Hive *(PR [#6752](https://github.com/tobymao/sqlglot/pull/6752) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate `SPACE` function to Hive (#6752)

- due to [`48336d0`](https://github.com/tobymao/sqlglot/commit/48336d00d2ad15ba1056868aab99d7e8f9ddb496) - Exclude table-valued functions from unnest_subqueries *(PR [#6755](https://github.com/tobymao/sqlglot/pull/6755) by [@VaggelisD](https://github.com/VaggelisD))*:

  Exclude table-valued functions from unnest_subqueries (#6755)

- due to [`6befad0`](https://github.com/tobymao/sqlglot/commit/6befad02d724a46feda8145d4ce092a534c18d99) - Annotate `BIT_LENGTH` for Spark and DBX *(PR [#6754](https://github.com/tobymao/sqlglot/pull/6754) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate `BIT_LENGTH` for Spark and DBX (#6754)

- due to [`076058d`](https://github.com/tobymao/sqlglot/commit/076058d9d808cda6b6ca08138afa7f26ee9f6a7c) - Annotate `SHA1` and `SHA256` function for DuckDB *(PR [#6753](https://github.com/tobymao/sqlglot/pull/6753) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate `SHA1` and `SHA256` function for DuckDB (#6753)

- due to [`ff1b5da`](https://github.com/tobymao/sqlglot/commit/ff1b5da9a0f69b664064155bc51ff41d1c928204) - Annotate KURTOSIS function *(PR [#6757](https://github.com/tobymao/sqlglot/pull/6757) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate KURTOSIS function (#6757)

- due to [`af008bd`](https://github.com/tobymao/sqlglot/commit/af008bd51482c69b2c0c9ef01008ec0e657d6c9b) - Annotate SIN, COS, TAN for Hive and inherited dialects *(PR [#6759](https://github.com/tobymao/sqlglot/pull/6759) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate SIN, COS, TAN for Hive and inherited dialects (#6759)

- due to [`700fbe9`](https://github.com/tobymao/sqlglot/commit/700fbe9b648339342ef60e1ed2ec729de24b6229) - Annotate CORR for Hive and inherited dialects *(PR [#6769](https://github.com/tobymao/sqlglot/pull/6769) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate CORR for Hive and inherited dialects (#6769)

- due to [`b87be58`](https://github.com/tobymao/sqlglot/commit/b87be5878524bf82df804926a59c2ffd94fa5adc) - Annotate `SEC` for Spark and DBX *(PR [#6768](https://github.com/tobymao/sqlglot/pull/6768) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate `SEC` for Spark and DBX (#6768)

- due to [`5a594ed`](https://github.com/tobymao/sqlglot/commit/5a594edd0bc079ef8e2e27ee07033b1bb5bcbd3e) - Annotate ATANH for Spark and DBX *(PR [#6767](https://github.com/tobymao/sqlglot/pull/6767) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate ATANH for Spark and DBX (#6767)

- due to [`1f9672f`](https://github.com/tobymao/sqlglot/commit/1f9672f390d05754260797beed0a5b1e0ea76358) - Annotate `ATAN` for Hive and inherited dialects *(PR [#6766](https://github.com/tobymao/sqlglot/pull/6766) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate `ATAN` for Hive and inherited dialects (#6766)

- due to [`38d6816`](https://github.com/tobymao/sqlglot/commit/38d6816e39c07c50f6e5c0b9f4763091b54f9e19) - Support type inference for BQ SAFE functions *(PR [#6765](https://github.com/tobymao/sqlglot/pull/6765) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  Support type inference for BQ SAFE functions (#6765)

- due to [`c89a127`](https://github.com/tobymao/sqlglot/commit/c89a127008f581a2ca49132a171e2b51d6e1e7b2) - Implements transpilation for IS_NULL_VALUE *(PR [#6756](https://github.com/tobymao/sqlglot/pull/6756) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  Implements transpilation for IS_NULL_VALUE (#6756)

- due to [`428d676`](https://github.com/tobymao/sqlglot/commit/428d6766bc752ed2beb363936584766964da6bcc) - avoid redundant cast when transpiling trunc from snowflake *(PR [#6771](https://github.com/tobymao/sqlglot/pull/6771) by [@georgesittas](https://github.com/georgesittas))*:

  avoid redundant cast when transpiling trunc from snowflake (#6771)

- due to [`8163ffa`](https://github.com/tobymao/sqlglot/commit/8163ffa2438e98567be67610ea33918489d36d18) - Implements transpilation for Snowflake's EQUAL_NULL *(PR [#6763](https://github.com/tobymao/sqlglot/pull/6763) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  Implements transpilation for Snowflake's EQUAL_NULL (#6763)

- due to [`4c01cbe`](https://github.com/tobymao/sqlglot/commit/4c01cbe8ff020d7d52e399de56874a99797e2484) - Annotate CBRT for Hive and inherited dialects *(PR [#6772](https://github.com/tobymao/sqlglot/pull/6772) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate CBRT for Hive and inherited dialects (#6772)

- due to [`237aec0`](https://github.com/tobymao/sqlglot/commit/237aec0c53c8417e628d4b4ecd7ad4436843b55d) - Annotate CURRENT_CATALOG() for Hive, Spark, and DBX *(PR [#6773](https://github.com/tobymao/sqlglot/pull/6773) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate CURRENT_CATALOG() for Hive, Spark, and DBX (#6773)

- due to [`82d533e`](https://github.com/tobymao/sqlglot/commit/82d533ea5bde8637c71520334174a6fa04ad021d) - Annotate CURRENT_DATABASE() for Hive, Spark and DBX *(PR [#6774](https://github.com/tobymao/sqlglot/pull/6774) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate CURRENT_DATABASE() for Hive, Spark and DBX (#6774)

- due to [`69c874f`](https://github.com/tobymao/sqlglot/commit/69c874f317621c572c9b5f91e563f50afaa38bba) - properly support safe functions *(PR [#6775](https://github.com/tobymao/sqlglot/pull/6775) by [@georgesittas](https://github.com/georgesittas))*:

  properly support safe functions (#6775)

- due to [`b5674f6`](https://github.com/tobymao/sqlglot/commit/b5674f6371aeac02716085095d9edb22e559aaa8) - robust correlated subqueries annotation *(PR [#6764](https://github.com/tobymao/sqlglot/pull/6764) by [@geooo109](https://github.com/geooo109))*:

  robust correlated subqueries annotation (#6764)

- due to [`8634a8a`](https://github.com/tobymao/sqlglot/commit/8634a8a737d5ee6c40b4d33545e9f928e1e07df4) - Added Snowflake to DuckDB transpilation for EXTRACT *(PR [#6706](https://github.com/tobymao/sqlglot/pull/6706) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Added Snowflake to DuckDB transpilation for EXTRACT (#6706)

- due to [`8cda928`](https://github.com/tobymao/sqlglot/commit/8cda928b3807685f6de5e89eac12522433cfddd6) - ARRAY_APPEND null propagation *(PR [#6762](https://github.com/tobymao/sqlglot/pull/6762) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  ARRAY_APPEND null propagation (#6762)

- due to [`2ab4376`](https://github.com/tobymao/sqlglot/commit/2ab43769092840da802ece227d4c13cc95a2108a) - Annotate CURRENT_USER() for Hive, Spark and DBX *(PR [#6790](https://github.com/tobymao/sqlglot/pull/6790) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate CURRENT_USER() for Hive, Spark and DBX (#6790)

- due to [`ee08d77`](https://github.com/tobymao/sqlglot/commit/ee08d777eb79e8632d3a23e40095fd1f760a77a6) - resolve parsing issue in substr with FROM/FOR syntax *(PR [#6791](https://github.com/tobymao/sqlglot/pull/6791) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  resolve parsing issue in substr with FROM/FOR syntax (#6791)

- due to [`fca6a94`](https://github.com/tobymao/sqlglot/commit/fca6a947c27959d4b8f6f3453a941d31ceccf5a4) - Annotate CURRENT_SCHEMA() for Hive, Spark and DBX *(PR [#6792](https://github.com/tobymao/sqlglot/pull/6792) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate CURRENT_SCHEMA() for Hive, Spark and DBX (#6792)

- due to [`d6ecc73`](https://github.com/tobymao/sqlglot/commit/d6ecc7367783d81aab7b6341cd3400ff0edf4794) - add support for grouping_id() *(PR [#6793](https://github.com/tobymao/sqlglot/pull/6793) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  add support for grouping_id() (#6793)

- due to [`7f4a150`](https://github.com/tobymao/sqlglot/commit/7f4a1502dd6e039677979b67958e618a15867ed5) - parse and annotate bq NET.REG_DOMAIN *(PR [#6777](https://github.com/tobymao/sqlglot/pull/6777) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate bq NET.REG_DOMAIN (#6777)

- due to [`ce0bbcf`](https://github.com/tobymao/sqlglot/commit/ce0bbcf0d6d85c59827438bd711e9aa59ac1d9ef) - Annotate MONTHNAME for Spark and DBX *(PR [#6794](https://github.com/tobymao/sqlglot/pull/6794) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate MONTHNAME for Spark and DBX (#6794)

- due to [`bc0a43c`](https://github.com/tobymao/sqlglot/commit/bc0a43cc83e21763d12ca671b03392ce555ce14b) - Annotate MONTH for Hive, Spark and DBX *(PR [#6795](https://github.com/tobymao/sqlglot/pull/6795) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate MONTH for Hive, Spark and DBX (#6795)

- due to [`86ca0b6`](https://github.com/tobymao/sqlglot/commit/86ca0b6bf757e77ded99ffaaed641f8a092d6354) - Annotate MONTHS_BETWEEN for Hive, Spark and DBX *(PR [#6796](https://github.com/tobymao/sqlglot/pull/6796) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate MONTHS_BETWEEN for Hive, Spark and DBX (#6796)

- due to [`590bcf1`](https://github.com/tobymao/sqlglot/commit/590bcf1de5e6ad15188224f5e2c1dce0398a9ecd) - Annotate DATE_FROM_UNIX_DATE for Spark and DBX *(PR [#6797](https://github.com/tobymao/sqlglot/pull/6797) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate DATE_FROM_UNIX_DATE for Spark and DBX (#6797)

- due to [`7e3df62`](https://github.com/tobymao/sqlglot/commit/7e3df62f3e480f9e42c055a00b1113f219348561) - parse DISTINCT as separate arg from quantile for PERCENTILE func *(PR [#6799](https://github.com/tobymao/sqlglot/pull/6799) by [@geooo109](https://github.com/geooo109))*:

  parse DISTINCT as separate arg from quantile for PERCENTILE func (#6799)

- due to [`a2c4b08`](https://github.com/tobymao/sqlglot/commit/a2c4b08468729cbb1bd39545630a8feca9643b10) - Annotate UNHEX for Hive, Spark and DBX *(PR [#6800](https://github.com/tobymao/sqlglot/pull/6800) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate UNHEX for Hive, Spark and DBX (#6800)

- due to [`3ab49b6`](https://github.com/tobymao/sqlglot/commit/3ab49b64d97b4212696e207e38ecd647421ada2b) - Annotate ASIN for Hive, Spark and DBX *(PR [#6807](https://github.com/tobymao/sqlglot/pull/6807) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate ASIN for Hive, Spark and DBX (#6807)

- due to [`d86e28a`](https://github.com/tobymao/sqlglot/commit/d86e28a05ea068f4a254883714f352ebee89ea55) - Annotate ASINH for Spark and DBX *(PR [#6808](https://github.com/tobymao/sqlglot/pull/6808) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate ASINH for Spark and DBX (#6808)

- due to [`8fe8d64`](https://github.com/tobymao/sqlglot/commit/8fe8d64373ec3cad3b4e519c728e1674daa64dac) - ARRAY_PREPEND null propagation *(PR [#6809](https://github.com/tobymao/sqlglot/pull/6809) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  ARRAY_PREPEND null propagation (#6809)

- due to [`99b2b6a`](https://github.com/tobymao/sqlglot/commit/99b2b6ae0c6746ae8456968c98d96a31ac51d26a) - robust parsing of ALL/DISTINCT for PERCENTILE_APPROX func *(PR [#6812](https://github.com/tobymao/sqlglot/pull/6812) by [@geooo109](https://github.com/geooo109))*:

  robust parsing of ALL/DISTINCT for PERCENTILE_APPROX func (#6812)

- due to [`e6eff62`](https://github.com/tobymao/sqlglot/commit/e6eff62309b51192e732e0ae18eaa5cda5a7257a) - Annotate `GET_BIT` for DuckDB *(PR [#6816](https://github.com/tobymao/sqlglot/pull/6816) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate `GET_BIT` for DuckDB (#6816)

- due to [`70c2097`](https://github.com/tobymao/sqlglot/commit/70c2097ba2a26e5bad04347c8cc974b5056f2c19) - Annotate DAYNAME for Base Dialect *(PR [#6817](https://github.com/tobymao/sqlglot/pull/6817) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate DAYNAME for Base Dialect (#6817)

- due to [`2d5c3aa`](https://github.com/tobymao/sqlglot/commit/2d5c3aabdec756c3fe43392cb26181856acea7d6) - Annotate `CBRT` for Base Dialect *(PR [#6819](https://github.com/tobymao/sqlglot/pull/6819) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate `CBRT` for Base Dialect (#6819)

- due to [`0a478ad`](https://github.com/tobymao/sqlglot/commit/0a478adf096f4890f03991e2bd33257d0c2d3ad4) - introduce `BYTE_STRING_ESCAPES` concept for postgres/duckdb e-strings *(PR [#6818](https://github.com/tobymao/sqlglot/pull/6818) by [@georgesittas](https://github.com/georgesittas))*:

  introduce `BYTE_STRING_ESCAPES` concept for postgres/duckdb e-strings (#6818)

- due to [`5673b09`](https://github.com/tobymao/sqlglot/commit/5673b09dd899289f866df3c30bc9b435ba30d34f) - support transpilation of try_to_date from snowflake to duckdb *(PR [#6806](https://github.com/tobymao/sqlglot/pull/6806) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation of try_to_date from snowflake to duckdb (#6806)

- due to [`c229079`](https://github.com/tobymao/sqlglot/commit/c229079299f3d79fdc8f5bbd9506f6594bbdbe12) - support transpilation try_to_double snowflake to duck db *(PR [#6821](https://github.com/tobymao/sqlglot/pull/6821) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation try_to_double snowflake to duck db (#6821)

- due to [`dcf2cb9`](https://github.com/tobymao/sqlglot/commit/dcf2cb98ecef098368d1c4aa6d12164c341ea227) - annotate fields of  UNNEST(STRUCT) with ALIAS for bq *(PR [#6830](https://github.com/tobymao/sqlglot/pull/6830) by [@geooo109](https://github.com/geooo109))*:

  annotate fields of  UNNEST(STRUCT) with ALIAS for bq (#6830)

- due to [`378349d`](https://github.com/tobymao/sqlglot/commit/378349ddbe738438e5ad565f6f7d243ee779815a) - Annotate SOUNDEX for Hive, Spark and DBX *(PR [#6832](https://github.com/tobymao/sqlglot/pull/6832) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate SOUNDEX for Hive, Spark and DBX (#6832)

- due to [`3972a6c`](https://github.com/tobymao/sqlglot/commit/3972a6cc9c6a0b7fcb13948cbc56d5e48502552b) - Transpile BASE64_ENCODE from Snowflake to DuckDB *(PR [#6826](https://github.com/tobymao/sqlglot/pull/6826) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Transpile BASE64_ENCODE from Snowflake to DuckDB (#6826)

- due to [`a9daff7`](https://github.com/tobymao/sqlglot/commit/a9daff7028112aba5a4023c11d9dd96a4dba3d92) - Transpilation of Snowflake SEQ1/2/4/8 and GENERATOR to DuckDB *(PR [#6810](https://github.com/tobymao/sqlglot/pull/6810) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Transpilation of Snowflake SEQ1/2/4/8 and GENERATOR to DuckDB (#6810)

- due to [`317d496`](https://github.com/tobymao/sqlglot/commit/317d4968938b8df301d4e55cfdd96af1a304f88d) - Annotate SESSION_USER() for Spark and DBX *(PR [#6834](https://github.com/tobymao/sqlglot/pull/6834) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate SESSION_USER() for Spark and DBX (#6834)

- due to [`98cc685`](https://github.com/tobymao/sqlglot/commit/98cc685253e8011b9d4e2e78137a8b505192724f) - Annotate FACTORIAL(expr) for Hive, Spark and DBX *(PR [#6835](https://github.com/tobymao/sqlglot/pull/6835) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate FACTORIAL(expr) for Hive, Spark and DBX (#6835)

- due to [`f8024e0`](https://github.com/tobymao/sqlglot/commit/f8024e0ae3fe66076e78295868934203b03a7d49) - Annotate QUARTER for Hive, Spark and DBX *(PR [#6840](https://github.com/tobymao/sqlglot/pull/6840) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate QUARTER for Hive, Spark and DBX (#6840)

- due to [`b3b36ba`](https://github.com/tobymao/sqlglot/commit/b3b36baf86f705901cf1b3509203203772907879) - robust representation of negative numbers *(PR [#6833](https://github.com/tobymao/sqlglot/pull/6833) by [@geooo109](https://github.com/geooo109))*:

  robust representation of negative numbers (#6833)

- due to [`6ebe5cc`](https://github.com/tobymao/sqlglot/commit/6ebe5cc397c598e865c360f89097271c11173af1) - ARRAY_CAT null propagation  *(PR [#6829](https://github.com/tobymao/sqlglot/pull/6829) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  ARRAY_CAT null propagation  (#6829)

- due to [`36211c2`](https://github.com/tobymao/sqlglot/commit/36211c223f062519a1b561dfb23df56fb11a39fc) - transpile BASE64_DECODE_STRING/BINARY to DuckDB *(PR [#6837](https://github.com/tobymao/sqlglot/pull/6837) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  transpile BASE64_DECODE_STRING/BINARY to DuckDB (#6837)

- due to [`541abfe`](https://github.com/tobymao/sqlglot/commit/541abfe0afc8f3e080746bfa87fea99abf07fb1c) - annotate type for bq DATE_ADD *(PR [#6842](https://github.com/tobymao/sqlglot/pull/6842) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq DATE_ADD (#6842)

- due to [`8797e12`](https://github.com/tobymao/sqlglot/commit/8797e124900a31a4701ba425ae56773acf503471) - add support for transpiling ARRAY_COMPACT *(PR [#6839](https://github.com/tobymao/sqlglot/pull/6839) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  add support for transpiling ARRAY_COMPACT (#6839)

- due to [`89f583a`](https://github.com/tobymao/sqlglot/commit/89f583a35f36ff9a1caab760273576e05b926572) - Annotate SECOND for Hive, Spark and DBX *(PR [#6853](https://github.com/tobymao/sqlglot/pull/6853) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate SECOND for Hive, Spark and DBX (#6853)

- due to [`3852e1d`](https://github.com/tobymao/sqlglot/commit/3852e1d6e9bab29b4a9678d06e0583d38232165f) - Annotate ARRAY_SIZE(array) correctly for Spark and DBX *(PR [#6852](https://github.com/tobymao/sqlglot/pull/6852) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate ARRAY_SIZE(array) correctly for Spark and DBX (#6852)

- due to [`4a7e5a1`](https://github.com/tobymao/sqlglot/commit/4a7e5a1050b3704295dab11aaec22b238be1659d) - Transpilation for Snowflake EDITDISTANCE to Duckdb *(PR [#6846](https://github.com/tobymao/sqlglot/pull/6846) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Transpilation for Snowflake EDITDISTANCE to Duckdb (#6846)

- due to [`6f3b76b`](https://github.com/tobymao/sqlglot/commit/6f3b76b94ea1fe76ef85291634cde53cc2408d02) - Annotate SIN, COS, TAN, COT for T-SQL *(PR [#6851](https://github.com/tobymao/sqlglot/pull/6851) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate SIN, COS, TAN, COT for T-SQL (#6851)

- due to [`f1c4fa0`](https://github.com/tobymao/sqlglot/commit/f1c4fa0c62dc33d850eac4db190320a651717f77) - input rounding issue when transpiling boolean logic functions to DuckDB *(PR [#6849](https://github.com/tobymao/sqlglot/pull/6849) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  input rounding issue when transpiling boolean logic functions to DuckDB (#6849)

- due to [`eb9887f`](https://github.com/tobymao/sqlglot/commit/eb9887f4fcc7e8c9d48cee7bd78b4804fb215ae4) - support ATN2 function AST *(PR [#6862](https://github.com/tobymao/sqlglot/pull/6862) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  support ATN2 function AST (#6862)

- due to [`5922ba6`](https://github.com/tobymao/sqlglot/commit/5922ba69be7cc82f45439c818f2a1f2901fe6310) - Annotate inverse trigonometric functions for `TSQL` *(PR [#6865](https://github.com/tobymao/sqlglot/pull/6865) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate inverse trigonometric functions for `TSQL` (#6865)

- due to [`fc55b98`](https://github.com/tobymao/sqlglot/commit/fc55b9889bcb1e0dad404dc15d357d8c755d85e6) - Transpilation of MINHASH functions from Snowflake to DuckDB *(PR [#6859](https://github.com/tobymao/sqlglot/pull/6859) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Transpilation of MINHASH functions from Snowflake to DuckDB (#6859)

- due to [`3728646`](https://github.com/tobymao/sqlglot/commit/372864672b1f576d7e80d5b4df368742a79f8222) - Annotate `CURRENT_TIMEZONE()` for TSQL *(PR [#6871](https://github.com/tobymao/sqlglot/pull/6871) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate `CURRENT_TIMEZONE()` for TSQL (#6871)

- due to [`c6bfe61`](https://github.com/tobymao/sqlglot/commit/c6bfe61c59f06c6ce7cdb93a65082cd0a81018ef) - improve some starrocks properties generation *(PR [#6827](https://github.com/tobymao/sqlglot/pull/6827) by [@jaogoy](https://github.com/jaogoy))*:

  improve some starrocks properties generation (#6827)

- due to [`2103d1c`](https://github.com/tobymao/sqlglot/commit/2103d1c08dc36a7a6eb050149d730dcf2ea77dba) - Annotate MD5 for Hive, Spark and DBX *(PR [#6878](https://github.com/tobymao/sqlglot/pull/6878) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate MD5 for Hive, Spark and DBX (#6878)

- due to [`6f49775`](https://github.com/tobymao/sqlglot/commit/6f49775edbae748fc3692e20562e5dad9d77b631) - Transpilation of ARRAY_CONSTRUCT_COMPACT to duckdb *(PR [#6875](https://github.com/tobymao/sqlglot/pull/6875) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  Transpilation of ARRAY_CONSTRUCT_COMPACT to duckdb (#6875)

- due to [`37dc9c7`](https://github.com/tobymao/sqlglot/commit/37dc9c7b08169149af7fa7baa5cbf567a2688008) - support transpilation of ARRAY_INSERT *(PR [#6863](https://github.com/tobymao/sqlglot/pull/6863) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  support transpilation of ARRAY_INSERT (#6863)

- due to [`3a769d4`](https://github.com/tobymao/sqlglot/commit/3a769d404ba35f4a9b26766e0b614d0e24763efc) - Added transpilation of Snowflake ARRAYS_ZIP to DuckDB *(PR [#6874](https://github.com/tobymao/sqlglot/pull/6874) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Added transpilation of Snowflake ARRAYS_ZIP to DuckDB (#6874)

- due to [`9c39f08`](https://github.com/tobymao/sqlglot/commit/9c39f085924a9a59cd4a32322f3e45c710467563) - Annotate DAYOFWEEK for MySQL *(PR [#6885](https://github.com/tobymao/sqlglot/pull/6885) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate DAYOFWEEK for MySQL (#6885)

- due to [`9a0aaab`](https://github.com/tobymao/sqlglot/commit/9a0aaab6277590966ce4258444649f573d88bd9e) - Annotate SOUNDEX(expr) for TSQL *(PR [#6887](https://github.com/tobymao/sqlglot/pull/6887) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate SOUNDEX(expr) for TSQL (#6887)

- due to [`3e94c60`](https://github.com/tobymao/sqlglot/commit/3e94c603923ce27666ce23b0f5c985c93031b13e) - support transpilation of ARRAY_REMOVE *(PR [#6886](https://github.com/tobymao/sqlglot/pull/6886) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  support transpilation of ARRAY_REMOVE (#6886)

- due to [`bce1b1f`](https://github.com/tobymao/sqlglot/commit/bce1b1f9a75db83b71eebc097065e8c8d5ee6051) - Transpilation support for Snowflake MAP_CAT to DuckDB *(PR [#6881](https://github.com/tobymao/sqlglot/pull/6881) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Transpilation support for Snowflake MAP_CAT to DuckDB (#6881)

- due to [`b49a656`](https://github.com/tobymao/sqlglot/commit/b49a65696637937530eb0efe9b0de46c41a3436f) - Annotate FACTORIAL(expr) for DuckDB *(PR [#6891](https://github.com/tobymao/sqlglot/pull/6891) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate FACTORIAL(expr) for DuckDB (#6891)

- due to [`6ce073b`](https://github.com/tobymao/sqlglot/commit/6ce073bec5864c562854cd5a9848dba56c79bdcc) - transpilation support for IS_ARRAY *(PR [#6877](https://github.com/tobymao/sqlglot/pull/6877) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  transpilation support for IS_ARRAY (#6877)

- due to [`5f67a14`](https://github.com/tobymao/sqlglot/commit/5f67a149635cd000249eb1fc26b18493f29c4974) - bump sqlglotrs to 0.12.0 *(commit by [@georgesittas](https://github.com/georgesittas))*:

  bump sqlglotrs to 0.12.0


### :sparkles: New Features
- [`ed4ba08`](https://github.com/tobymao/sqlglot/commit/ed4ba08940212f7ed9b67ea01b51f8df38fe85d2) - **postgres**: add support for Bitwise NOT *(PR [#6740](https://github.com/tobymao/sqlglot/pull/6740) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
  - :arrow_lower_right: *addresses issue [#6730](https://github.com/tobymao/sqlglot/issues/6730) opened by [@Xynonners](https://github.com/Xynonners)*
- [`894c581`](https://github.com/tobymao/sqlglot/commit/894c5817fea304b16589710f266b3176f768aab6) - **optimizer**: annotate cot for spark and dbx *(PR [#6739](https://github.com/tobymao/sqlglot/pull/6739) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`cc18c55`](https://github.com/tobymao/sqlglot/commit/cc18c55c0acf0546607187e8910cdd2a9559f15f) - **optimizer**: add COSH function annotation for Hive and related dialects *(PR [#6738](https://github.com/tobymao/sqlglot/pull/6738) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`03dd8bd`](https://github.com/tobymao/sqlglot/commit/03dd8bd6ec9bdf1a8dfe77130bb1eb968d3cf3d8) - **optimizer**: add SINH function annotation for Hive and related dialects *(PR [#6736](https://github.com/tobymao/sqlglot/pull/6736) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`9b1a634`](https://github.com/tobymao/sqlglot/commit/9b1a6343e2ed862241d5e1a7aee8e766e74c83eb) - **duckdb**: cast APPROX_QUANTILE results to DOUBLE to respect Snowflake's typing during transpilation *(PR [#6734](https://github.com/tobymao/sqlglot/pull/6734) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`f644541`](https://github.com/tobymao/sqlglot/commit/f644541b2b27896f370e253ac4b5751ac5892f28) - **optimizer**: add TO_BINARY function annotation for Spark and DBX dialect *(PR [#6743](https://github.com/tobymao/sqlglot/pull/6743) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`5a50d05`](https://github.com/tobymao/sqlglot/commit/5a50d05b363802e785c8f9d3b8d73a68c8b046b0) - **duckdb**: Add transpilation support for NEXT_DAY function *(PR [#6728](https://github.com/tobymao/sqlglot/pull/6728) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`27a7b68`](https://github.com/tobymao/sqlglot/commit/27a7b6838d7a06d3ba335a937f7b158415c28b40) - **optimizer**: add annotation for ACOS function *(PR [#6747](https://github.com/tobymao/sqlglot/pull/6747) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`c1995b2`](https://github.com/tobymao/sqlglot/commit/c1995b20b22bae4d1633050cdbc19be3f960b223) - **spark**: add ACOSH function annotation *(PR [#6748](https://github.com/tobymao/sqlglot/pull/6748) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`a5ccfbb`](https://github.com/tobymao/sqlglot/commit/a5ccfbb1dd2fe7a1738e36fbc15dafdd00d25036) - **optimizer**: add SHA function annotations for Hive *(PR [#6750](https://github.com/tobymao/sqlglot/pull/6750) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`2191273`](https://github.com/tobymao/sqlglot/commit/219127309652ecd5a32940b09a29e10a00171866) - **snowflake**: Transpilation support for Snowflake's BITMAP_CONSTRUCT_AGG function to DuckDB *(PR [#6745](https://github.com/tobymao/sqlglot/pull/6745) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`ee0b213`](https://github.com/tobymao/sqlglot/commit/ee0b21355106861c74c3f67de5c1e6b0bb2a7f15) - **optimizer**: Annotate RANDN function for Spark and DBX *(PR [#6751](https://github.com/tobymao/sqlglot/pull/6751) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`e643817`](https://github.com/tobymao/sqlglot/commit/e6438170298e8dd90ccc3debe5065af7e0bcaa5e) - **optimizer**: Annotate `SPACE` function to Hive *(PR [#6752](https://github.com/tobymao/sqlglot/pull/6752) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`6befad0`](https://github.com/tobymao/sqlglot/commit/6befad02d724a46feda8145d4ce092a534c18d99) - **optimizer**: Annotate `BIT_LENGTH` for Spark and DBX *(PR [#6754](https://github.com/tobymao/sqlglot/pull/6754) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`076058d`](https://github.com/tobymao/sqlglot/commit/076058d9d808cda6b6ca08138afa7f26ee9f6a7c) - **optimizer**: Annotate `SHA1` and `SHA256` function for DuckDB *(PR [#6753](https://github.com/tobymao/sqlglot/pull/6753) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`ff1b5da`](https://github.com/tobymao/sqlglot/commit/ff1b5da9a0f69b664064155bc51ff41d1c928204) - **optimizer**: Annotate KURTOSIS function *(PR [#6757](https://github.com/tobymao/sqlglot/pull/6757) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`af008bd`](https://github.com/tobymao/sqlglot/commit/af008bd51482c69b2c0c9ef01008ec0e657d6c9b) - **optimizer**: Annotate SIN, COS, TAN for Hive and inherited dialects *(PR [#6759](https://github.com/tobymao/sqlglot/pull/6759) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`b87be58`](https://github.com/tobymao/sqlglot/commit/b87be5878524bf82df804926a59c2ffd94fa5adc) - **optimizer**: Annotate `SEC` for Spark and DBX *(PR [#6768](https://github.com/tobymao/sqlglot/pull/6768) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`5a594ed`](https://github.com/tobymao/sqlglot/commit/5a594edd0bc079ef8e2e27ee07033b1bb5bcbd3e) - **optimizer**: Annotate ATANH for Spark and DBX *(PR [#6767](https://github.com/tobymao/sqlglot/pull/6767) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`1f9672f`](https://github.com/tobymao/sqlglot/commit/1f9672f390d05754260797beed0a5b1e0ea76358) - **optimizer**: Annotate `ATAN` for Hive and inherited dialects *(PR [#6766](https://github.com/tobymao/sqlglot/pull/6766) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`38d6816`](https://github.com/tobymao/sqlglot/commit/38d6816e39c07c50f6e5c0b9f4763091b54f9e19) - **bigquery**: Support type inference for BQ SAFE functions *(PR [#6765](https://github.com/tobymao/sqlglot/pull/6765) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`c89a127`](https://github.com/tobymao/sqlglot/commit/c89a127008f581a2ca49132a171e2b51d6e1e7b2) - **snowflake**: Implements transpilation for IS_NULL_VALUE *(PR [#6756](https://github.com/tobymao/sqlglot/pull/6756) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`428d676`](https://github.com/tobymao/sqlglot/commit/428d6766bc752ed2beb363936584766964da6bcc) - **duckdb**: avoid redundant cast when transpiling trunc from snowflake *(PR [#6771](https://github.com/tobymao/sqlglot/pull/6771) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#6770](https://github.com/tobymao/sqlglot/issues/6770) opened by [@baruchoxman](https://github.com/baruchoxman)*
- [`8163ffa`](https://github.com/tobymao/sqlglot/commit/8163ffa2438e98567be67610ea33918489d36d18) - **snowflake**: Implements transpilation for Snowflake's EQUAL_NULL *(PR [#6763](https://github.com/tobymao/sqlglot/pull/6763) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`4245205`](https://github.com/tobymao/sqlglot/commit/42452050bfdeb77fe197ffddbec901f9a3ea2d8a) - **duckdb**: Add transpilation support for TIME_FROM_PARTS function for overflow case *(PR [#6761](https://github.com/tobymao/sqlglot/pull/6761) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`4c01cbe`](https://github.com/tobymao/sqlglot/commit/4c01cbe8ff020d7d52e399de56874a99797e2484) - **optimizer**: Annotate CBRT for Hive and inherited dialects *(PR [#6772](https://github.com/tobymao/sqlglot/pull/6772) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`237aec0`](https://github.com/tobymao/sqlglot/commit/237aec0c53c8417e628d4b4ecd7ad4436843b55d) - **optimizer**: Annotate CURRENT_CATALOG() for Hive, Spark, and DBX *(PR [#6773](https://github.com/tobymao/sqlglot/pull/6773) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`82d533e`](https://github.com/tobymao/sqlglot/commit/82d533ea5bde8637c71520334174a6fa04ad021d) - **optimizer**: Annotate CURRENT_DATABASE() for Hive, Spark and DBX *(PR [#6774](https://github.com/tobymao/sqlglot/pull/6774) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`b5674f6`](https://github.com/tobymao/sqlglot/commit/b5674f6371aeac02716085095d9edb22e559aaa8) - **optimizer**: robust correlated subqueries annotation *(PR [#6764](https://github.com/tobymao/sqlglot/pull/6764) by [@geooo109](https://github.com/geooo109))*
- [`8634a8a`](https://github.com/tobymao/sqlglot/commit/8634a8a737d5ee6c40b4d33545e9f928e1e07df4) - **snowflake**: Added Snowflake to DuckDB transpilation for EXTRACT *(PR [#6706](https://github.com/tobymao/sqlglot/pull/6706) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`8cda928`](https://github.com/tobymao/sqlglot/commit/8cda928b3807685f6de5e89eac12522433cfddd6) - **databricks,duckdb,postgres,spark,snowflake**: ARRAY_APPEND null propagation *(PR [#6762](https://github.com/tobymao/sqlglot/pull/6762) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`2ab4376`](https://github.com/tobymao/sqlglot/commit/2ab43769092840da802ece227d4c13cc95a2108a) - **optimizer**: Annotate CURRENT_USER() for Hive, Spark and DBX *(PR [#6790](https://github.com/tobymao/sqlglot/pull/6790) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`fca6a94`](https://github.com/tobymao/sqlglot/commit/fca6a947c27959d4b8f6f3453a941d31ceccf5a4) - **optimizer**: Annotate CURRENT_SCHEMA() for Hive, Spark and DBX *(PR [#6792](https://github.com/tobymao/sqlglot/pull/6792) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`7f4a150`](https://github.com/tobymao/sqlglot/commit/7f4a1502dd6e039677979b67958e618a15867ed5) - **optimizer**: parse and annotate bq NET.REG_DOMAIN *(PR [#6777](https://github.com/tobymao/sqlglot/pull/6777) by [@geooo109](https://github.com/geooo109))*
- [`ce0bbcf`](https://github.com/tobymao/sqlglot/commit/ce0bbcf0d6d85c59827438bd711e9aa59ac1d9ef) - **optimizer**: Annotate MONTHNAME for Spark and DBX *(PR [#6794](https://github.com/tobymao/sqlglot/pull/6794) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`bc0a43c`](https://github.com/tobymao/sqlglot/commit/bc0a43cc83e21763d12ca671b03392ce555ce14b) - **optimizer**: Annotate MONTH for Hive, Spark and DBX *(PR [#6795](https://github.com/tobymao/sqlglot/pull/6795) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`86ca0b6`](https://github.com/tobymao/sqlglot/commit/86ca0b6bf757e77ded99ffaaed641f8a092d6354) - **optimizer**: Annotate MONTHS_BETWEEN for Hive, Spark and DBX *(PR [#6796](https://github.com/tobymao/sqlglot/pull/6796) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`590bcf1`](https://github.com/tobymao/sqlglot/commit/590bcf1de5e6ad15188224f5e2c1dce0398a9ecd) - **optimizer**: Annotate DATE_FROM_UNIX_DATE for Spark and DBX *(PR [#6797](https://github.com/tobymao/sqlglot/pull/6797) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`a2c4b08`](https://github.com/tobymao/sqlglot/commit/a2c4b08468729cbb1bd39545630a8feca9643b10) - **optimizer**: Annotate UNHEX for Hive, Spark and DBX *(PR [#6800](https://github.com/tobymao/sqlglot/pull/6800) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`39db28e`](https://github.com/tobymao/sqlglot/commit/39db28e28290acfd2e3f416a8e057670194e9e20) - **duckdb**: Add transpilation support for TIMESTAMP_FROM_PARTS function *(PR [#6801](https://github.com/tobymao/sqlglot/pull/6801) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`3ab49b6`](https://github.com/tobymao/sqlglot/commit/3ab49b64d97b4212696e207e38ecd647421ada2b) - **optimizer**: Annotate ASIN for Hive, Spark and DBX *(PR [#6807](https://github.com/tobymao/sqlglot/pull/6807) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`d86e28a`](https://github.com/tobymao/sqlglot/commit/d86e28a05ea068f4a254883714f352ebee89ea55) - **optimizer**: Annotate ASINH for Spark and DBX *(PR [#6808](https://github.com/tobymao/sqlglot/pull/6808) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`8fe8d64`](https://github.com/tobymao/sqlglot/commit/8fe8d64373ec3cad3b4e519c728e1674daa64dac) - **databricks,duckdb,postgres,spark,snowflake**: ARRAY_PREPEND null propagation *(PR [#6809](https://github.com/tobymao/sqlglot/pull/6809) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`1c31ae3`](https://github.com/tobymao/sqlglot/commit/1c31ae3883c8755fc6046b661bcf87c1aa76cd5c) - **duckdb**: Add transpilation support for TIME_SLICE function *(PR [#6805](https://github.com/tobymao/sqlglot/pull/6805) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`88412cb`](https://github.com/tobymao/sqlglot/commit/88412cb431c9cc64953274fd78df80c3aa70f081) - **starrocks**: add support for ROLLUP index property *(PR [#6814](https://github.com/tobymao/sqlglot/pull/6814) by [@petrikoro](https://github.com/petrikoro))*
- [`e6eff62`](https://github.com/tobymao/sqlglot/commit/e6eff62309b51192e732e0ae18eaa5cda5a7257a) - **optimizer**: Annotate `GET_BIT` for DuckDB *(PR [#6816](https://github.com/tobymao/sqlglot/pull/6816) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`70c2097`](https://github.com/tobymao/sqlglot/commit/70c2097ba2a26e5bad04347c8cc974b5056f2c19) - **optimizer**: Annotate DAYNAME for Base Dialect *(PR [#6817](https://github.com/tobymao/sqlglot/pull/6817) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`2d5c3aa`](https://github.com/tobymao/sqlglot/commit/2d5c3aabdec756c3fe43392cb26181856acea7d6) - **optimizer**: Annotate `CBRT` for Base Dialect *(PR [#6819](https://github.com/tobymao/sqlglot/pull/6819) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`5673b09`](https://github.com/tobymao/sqlglot/commit/5673b09dd899289f866df3c30bc9b435ba30d34f) - **snowflake**: support transpilation of try_to_date from snowflake to duckdb *(PR [#6806](https://github.com/tobymao/sqlglot/pull/6806) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`c229079`](https://github.com/tobymao/sqlglot/commit/c229079299f3d79fdc8f5bbd9506f6594bbdbe12) - **snowflake**: support transpilation try_to_double snowflake to duck db *(PR [#6821](https://github.com/tobymao/sqlglot/pull/6821) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`378349d`](https://github.com/tobymao/sqlglot/commit/378349ddbe738438e5ad565f6f7d243ee779815a) - **optimizer**: Annotate SOUNDEX for Hive, Spark and DBX *(PR [#6832](https://github.com/tobymao/sqlglot/pull/6832) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`3972a6c`](https://github.com/tobymao/sqlglot/commit/3972a6cc9c6a0b7fcb13948cbc56d5e48502552b) - **snowflake**: Transpile BASE64_ENCODE from Snowflake to DuckDB *(PR [#6826](https://github.com/tobymao/sqlglot/pull/6826) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`a9daff7`](https://github.com/tobymao/sqlglot/commit/a9daff7028112aba5a4023c11d9dd96a4dba3d92) - **snowflake**: Transpilation of Snowflake SEQ1/2/4/8 and GENERATOR to DuckDB *(PR [#6810](https://github.com/tobymao/sqlglot/pull/6810) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`317d496`](https://github.com/tobymao/sqlglot/commit/317d4968938b8df301d4e55cfdd96af1a304f88d) - **optimizer**: Annotate SESSION_USER() for Spark and DBX *(PR [#6834](https://github.com/tobymao/sqlglot/pull/6834) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`98cc685`](https://github.com/tobymao/sqlglot/commit/98cc685253e8011b9d4e2e78137a8b505192724f) - **optimizer**: Annotate FACTORIAL(expr) for Hive, Spark and DBX *(PR [#6835](https://github.com/tobymao/sqlglot/pull/6835) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`db057bb`](https://github.com/tobymao/sqlglot/commit/db057bb088183ff09da72f0fbe13515f057d4e3b) - **postgres**: support `VARIADIC` *(PR [#6841](https://github.com/tobymao/sqlglot/pull/6841) by [@syubogdanov](https://github.com/syubogdanov))*
- [`7dade98`](https://github.com/tobymao/sqlglot/commit/7dade9843e9a7cc5887a83f51b4d7ff1650de6de) - **duckdb**: Add transpilation support for REVERSE function *(PR [#6838](https://github.com/tobymao/sqlglot/pull/6838) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`36211c2`](https://github.com/tobymao/sqlglot/commit/36211c223f062519a1b561dfb23df56fb11a39fc) - **snowflake**: transpile BASE64_DECODE_STRING/BINARY to DuckDB *(PR [#6837](https://github.com/tobymao/sqlglot/pull/6837) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`541abfe`](https://github.com/tobymao/sqlglot/commit/541abfe0afc8f3e080746bfa87fea99abf07fb1c) - **optimizer**: annotate type for bq DATE_ADD *(PR [#6842](https://github.com/tobymao/sqlglot/pull/6842) by [@geooo109](https://github.com/geooo109))*
- [`8797e12`](https://github.com/tobymao/sqlglot/commit/8797e124900a31a4701ba425ae56773acf503471) - **duckdb**: add support for transpiling ARRAY_COMPACT *(PR [#6839](https://github.com/tobymao/sqlglot/pull/6839) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`89f583a`](https://github.com/tobymao/sqlglot/commit/89f583a35f36ff9a1caab760273576e05b926572) - **optimizer**: Annotate SECOND for Hive, Spark and DBX *(PR [#6853](https://github.com/tobymao/sqlglot/pull/6853) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`4a7e5a1`](https://github.com/tobymao/sqlglot/commit/4a7e5a1050b3704295dab11aaec22b238be1659d) - **snowflake**: Transpilation for Snowflake EDITDISTANCE to Duckdb *(PR [#6846](https://github.com/tobymao/sqlglot/pull/6846) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`6f3b76b`](https://github.com/tobymao/sqlglot/commit/6f3b76b94ea1fe76ef85291634cde53cc2408d02) - **optimizer**: Annotate SIN, COS, TAN, COT for T-SQL *(PR [#6851](https://github.com/tobymao/sqlglot/pull/6851) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`2a455ca`](https://github.com/tobymao/sqlglot/commit/2a455caf6426f4d4ba2e6801e131804b7eba8a01) - **duckdb**: Add transpilation support for FLATTEN (ARRAY_FLATTEN) *(PR [#6848](https://github.com/tobymao/sqlglot/pull/6848) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`e1b6529`](https://github.com/tobymao/sqlglot/commit/e1b6529c0d413f515c3a8d0902ea6a2995e7d92d) - **snowflake**: support directed joins closes [#6850](https://github.com/tobymao/sqlglot/pull/6850) *(PR [#6856](https://github.com/tobymao/sqlglot/pull/6856) by [@georgesittas](https://github.com/georgesittas))*
- [`c94284f`](https://github.com/tobymao/sqlglot/commit/c94284f19961645212c9b38169bc2341988debf5) - **optimizer**: UDF annotation *(PR [#6843](https://github.com/tobymao/sqlglot/pull/6843) by [@georgesittas](https://github.com/georgesittas))*
- [`394bba4`](https://github.com/tobymao/sqlglot/commit/394bba402f99ffacee999f236602b27470e8c95d) - **starrocks**: add full support for partitions *(PR [#6804](https://github.com/tobymao/sqlglot/pull/6804) by [@petrikoro](https://github.com/petrikoro))*
  - :arrow_lower_right: *addresses issue [#6803](https://github.com/tobymao/sqlglot/issues/6803) opened by [@petrikoro](https://github.com/petrikoro)*
- [`eb9887f`](https://github.com/tobymao/sqlglot/commit/eb9887f4fcc7e8c9d48cee7bd78b4804fb215ae4) - **tsql**: support ATN2 function AST *(PR [#6862](https://github.com/tobymao/sqlglot/pull/6862) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`5922ba6`](https://github.com/tobymao/sqlglot/commit/5922ba69be7cc82f45439c818f2a1f2901fe6310) - **tsql**: Annotate inverse trigonometric functions for `TSQL` *(PR [#6865](https://github.com/tobymao/sqlglot/pull/6865) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`f0618b9`](https://github.com/tobymao/sqlglot/commit/f0618b97ae09e51e81e1d7c23a34afdc497f5419) - **spark**: support AS JSON suffix in describe statement closes [#6866](https://github.com/tobymao/sqlglot/pull/6866) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`bf90b5d`](https://github.com/tobymao/sqlglot/commit/bf90b5dd5b4b48359cfa18b992bbb7a307169cb4) - **duckdb**: Add transpilation support for SPACE function *(PR [#6867](https://github.com/tobymao/sqlglot/pull/6867) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`fc55b98`](https://github.com/tobymao/sqlglot/commit/fc55b9889bcb1e0dad404dc15d357d8c755d85e6) - **snowflake**: Transpilation of MINHASH functions from Snowflake to DuckDB *(PR [#6859](https://github.com/tobymao/sqlglot/pull/6859) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`3728646`](https://github.com/tobymao/sqlglot/commit/372864672b1f576d7e80d5b4df368742a79f8222) - **tsql**: Annotate `CURRENT_TIMEZONE()` for TSQL *(PR [#6871](https://github.com/tobymao/sqlglot/pull/6871) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`c6bfe61`](https://github.com/tobymao/sqlglot/commit/c6bfe61c59f06c6ce7cdb93a65082cd0a81018ef) - **starrocks**: improve some starrocks properties generation *(PR [#6827](https://github.com/tobymao/sqlglot/pull/6827) by [@jaogoy](https://github.com/jaogoy))*
- [`2103d1c`](https://github.com/tobymao/sqlglot/commit/2103d1c08dc36a7a6eb050149d730dcf2ea77dba) - **optimizer**: Annotate MD5 for Hive, Spark and DBX *(PR [#6878](https://github.com/tobymao/sqlglot/pull/6878) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`6f49775`](https://github.com/tobymao/sqlglot/commit/6f49775edbae748fc3692e20562e5dad9d77b631) - **duckdb**: Transpilation of ARRAY_CONSTRUCT_COMPACT to duckdb *(PR [#6875](https://github.com/tobymao/sqlglot/pull/6875) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`37dc9c7`](https://github.com/tobymao/sqlglot/commit/37dc9c7b08169149af7fa7baa5cbf567a2688008) - **duckdb**: support transpilation of ARRAY_INSERT *(PR [#6863](https://github.com/tobymao/sqlglot/pull/6863) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`3a769d4`](https://github.com/tobymao/sqlglot/commit/3a769d404ba35f4a9b26766e0b614d0e24763efc) - **snowflake**: Added transpilation of Snowflake ARRAYS_ZIP to DuckDB *(PR [#6874](https://github.com/tobymao/sqlglot/pull/6874) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`9a0aaab`](https://github.com/tobymao/sqlglot/commit/9a0aaab6277590966ce4258444649f573d88bd9e) - **optimizer**: Annotate SOUNDEX(expr) for TSQL *(PR [#6887](https://github.com/tobymao/sqlglot/pull/6887) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`3e94c60`](https://github.com/tobymao/sqlglot/commit/3e94c603923ce27666ce23b0f5c985c93031b13e) - **duckdb**: support transpilation of ARRAY_REMOVE *(PR [#6886](https://github.com/tobymao/sqlglot/pull/6886) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`bce1b1f`](https://github.com/tobymao/sqlglot/commit/bce1b1f9a75db83b71eebc097065e8c8d5ee6051) - **snowflake**: Transpilation support for Snowflake MAP_CAT to DuckDB *(PR [#6881](https://github.com/tobymao/sqlglot/pull/6881) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`ad2e9d3`](https://github.com/tobymao/sqlglot/commit/ad2e9d31f00d370d93ae925134e89d15cfd701a1) - **postgres**: support function parameter mode (IN, OUT, INOUT, VARIADIC) *(PR [#6876](https://github.com/tobymao/sqlglot/pull/6876) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
  - :arrow_lower_right: *addresses issue [#6860](https://github.com/tobymao/sqlglot/issues/6860) opened by [@Badg](https://github.com/Badg)*
- [`b49a656`](https://github.com/tobymao/sqlglot/commit/b49a65696637937530eb0efe9b0de46c41a3436f) - **optimizer**: Annotate FACTORIAL(expr) for DuckDB *(PR [#6891](https://github.com/tobymao/sqlglot/pull/6891) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`6ce073b`](https://github.com/tobymao/sqlglot/commit/6ce073bec5864c562854cd5a9848dba56c79bdcc) - **snowflake**: transpilation support for IS_ARRAY *(PR [#6877](https://github.com/tobymao/sqlglot/pull/6877) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*

### :bug: Bug Fixes
- [`aeaa43d`](https://github.com/tobymao/sqlglot/commit/aeaa43d16fb3fc01f3d4297badf3953c6d18ae9c) - **duckdb**: Preserve key name in STRUCT for all identifiers *(PR [#6744](https://github.com/tobymao/sqlglot/pull/6744) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6729](https://github.com/tobymao/sqlglot/issues/6729) opened by [@nikchha](https://github.com/nikchha)*
- [`7b5279c`](https://github.com/tobymao/sqlglot/commit/7b5279ccda0bd8947b9b244c221f03883e8865cf) - **optimizer**: Fix optimizer for generate series *(PR [#6679](https://github.com/tobymao/sqlglot/pull/6679) by [@chrisqu777](https://github.com/chrisqu777))*
  - :arrow_lower_right: *fixes issue [#6657](https://github.com/tobymao/sqlglot/issues/6657) opened by [@metahexane](https://github.com/metahexane)*
- [`48336d0`](https://github.com/tobymao/sqlglot/commit/48336d00d2ad15ba1056868aab99d7e8f9ddb496) - **optimizer**: Exclude table-valued functions from unnest_subqueries *(PR [#6755](https://github.com/tobymao/sqlglot/pull/6755) by [@VaggelisD](https://github.com/VaggelisD))*
- [`700fbe9`](https://github.com/tobymao/sqlglot/commit/700fbe9b648339342ef60e1ed2ec729de24b6229) - **optimizer**: Annotate CORR for Hive and inherited dialects *(PR [#6769](https://github.com/tobymao/sqlglot/pull/6769) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`69c874f`](https://github.com/tobymao/sqlglot/commit/69c874f317621c572c9b5f91e563f50afaa38bba) - **bigquery**: properly support safe functions *(PR [#6775](https://github.com/tobymao/sqlglot/pull/6775) by [@georgesittas](https://github.com/georgesittas))*
- [`ee08d77`](https://github.com/tobymao/sqlglot/commit/ee08d777eb79e8632d3a23e40095fd1f760a77a6) - **parser**: resolve parsing issue in substr with FROM/FOR syntax *(PR [#6791](https://github.com/tobymao/sqlglot/pull/6791) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
  - :arrow_lower_right: *fixes issue [#6787](https://github.com/tobymao/sqlglot/issues/6787) opened by [@AbhishekASLK](https://github.com/AbhishekASLK)*
- [`d6ecc73`](https://github.com/tobymao/sqlglot/commit/d6ecc7367783d81aab7b6341cd3400ff0edf4794) - **parser**: add support for grouping_id() *(PR [#6793](https://github.com/tobymao/sqlglot/pull/6793) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
  - :arrow_lower_right: *fixes issue [#6784](https://github.com/tobymao/sqlglot/issues/6784) opened by [@AbhishekASLK](https://github.com/AbhishekASLK)*
- [`7e3df62`](https://github.com/tobymao/sqlglot/commit/7e3df62f3e480f9e42c055a00b1113f219348561) - **hive, spark, databriicks**: parse DISTINCT as separate arg from quantile for PERCENTILE func *(PR [#6799](https://github.com/tobymao/sqlglot/pull/6799) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6786](https://github.com/tobymao/sqlglot/issues/6786) opened by [@AbhishekASLK](https://github.com/AbhishekASLK)*
- [`c2069b7`](https://github.com/tobymao/sqlglot/commit/c2069b77d7316877e69051b62802d02d862780ba) - **starrocks**: omit TABLE keyword for INSERT OVERWRITE fixes [#6803](https://github.com/tobymao/sqlglot/pull/6803) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`99b2b6a`](https://github.com/tobymao/sqlglot/commit/99b2b6ae0c6746ae8456968c98d96a31ac51d26a) - **hive, spark2, spark, databricks**: robust parsing of ALL/DISTINCT for PERCENTILE_APPROX func *(PR [#6812](https://github.com/tobymao/sqlglot/pull/6812) by [@geooo109](https://github.com/geooo109))*
- [`ba1d99f`](https://github.com/tobymao/sqlglot/commit/ba1d99fc5da8b075c24554d57ed8b8092d56d58a) - **starrocks**: rewrite BETWEEN as comparison operators for DELETE *(PR [#6815](https://github.com/tobymao/sqlglot/pull/6815) by [@petrikoro](https://github.com/petrikoro))*
- [`7e46829`](https://github.com/tobymao/sqlglot/commit/7e468291eaac59cd4a150772b5e0cc56f0c0bcf8) - quote integration tests GHA heredoc delimiter *(PR [#6820](https://github.com/tobymao/sqlglot/pull/6820) by [@treysp](https://github.com/treysp))*
- [`0a478ad`](https://github.com/tobymao/sqlglot/commit/0a478adf096f4890f03991e2bd33257d0c2d3ad4) - introduce `BYTE_STRING_ESCAPES` concept for postgres/duckdb e-strings *(PR [#6818](https://github.com/tobymao/sqlglot/pull/6818) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6813](https://github.com/tobymao/sqlglot/issues/6813) opened by [@trouver](https://github.com/trouver)*
- [`d8f266b`](https://github.com/tobymao/sqlglot/commit/d8f266b45f98c1eafbf09f4090a13357aef3efa0) - **merge_subqueries**: Do not replace literals in GROUP BY *(PR [#6828](https://github.com/tobymao/sqlglot/pull/6828) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6823](https://github.com/tobymao/sqlglot/issues/6823) opened by [@karta0807913](https://github.com/karta0807913)*
- [`dcf2cb9`](https://github.com/tobymao/sqlglot/commit/dcf2cb98ecef098368d1c4aa6d12164c341ea227) - **optimizer**: annotate fields of  UNNEST(STRUCT) with ALIAS for bq *(PR [#6830](https://github.com/tobymao/sqlglot/pull/6830) by [@geooo109](https://github.com/geooo109))*
- [`f8024e0`](https://github.com/tobymao/sqlglot/commit/f8024e0ae3fe66076e78295868934203b03a7d49) - **optimizer**: Annotate QUARTER for Hive, Spark and DBX *(PR [#6840](https://github.com/tobymao/sqlglot/pull/6840) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`b3b36ba`](https://github.com/tobymao/sqlglot/commit/b3b36baf86f705901cf1b3509203203772907879) - **parser**: robust representation of negative numbers *(PR [#6833](https://github.com/tobymao/sqlglot/pull/6833) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6831](https://github.com/tobymao/sqlglot/issues/6831) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`6ebe5cc`](https://github.com/tobymao/sqlglot/commit/6ebe5cc397c598e865c360f89097271c11173af1) - **duckdb,postgres,redshift,snowflake**: ARRAY_CAT null propagation  *(PR [#6829](https://github.com/tobymao/sqlglot/pull/6829) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`5a1028a`](https://github.com/tobymao/sqlglot/commit/5a1028ad937782ff54bcd6e7ee8029d24abb7eff) - **snowflake**: match_condition edge case when offset/limit are present *(PR [#6847](https://github.com/tobymao/sqlglot/pull/6847) by [@georgesittas](https://github.com/georgesittas))*
- [`3852e1d`](https://github.com/tobymao/sqlglot/commit/3852e1d6e9bab29b4a9678d06e0583d38232165f) - **optimizer**: Annotate ARRAY_SIZE(array) correctly for Spark and DBX *(PR [#6852](https://github.com/tobymao/sqlglot/pull/6852) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`7abc6b5`](https://github.com/tobymao/sqlglot/commit/7abc6b5645ee3f0324e77f8c853d55893083ab7c) - Fix LATERAL VIEW POSEXPLODE transpilation *(PR [#6844](https://github.com/tobymao/sqlglot/pull/6844) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6836](https://github.com/tobymao/sqlglot/issues/6836) opened by [@nickhand](https://github.com/nickhand)*
- [`f1c4fa0`](https://github.com/tobymao/sqlglot/commit/f1c4fa0c62dc33d850eac4db190320a651717f77) - **snowflake**: input rounding issue when transpiling boolean logic functions to DuckDB *(PR [#6849](https://github.com/tobymao/sqlglot/pull/6849) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`ddec250`](https://github.com/tobymao/sqlglot/commit/ddec2500e994dc4b7cc4a80b501dc9bc1f2fb4d1) - **presto**: don't overwrite_types when annotating types in struct_sql() *(PR [#6870](https://github.com/tobymao/sqlglot/pull/6870) by [@NickCrews](https://github.com/NickCrews))*
- [`acec48e`](https://github.com/tobymao/sqlglot/commit/acec48e0e10a2298f8e4d981feed883905150b76) - allow check to appear as an identifier in a ddl column def fixes [#6872](https://github.com/tobymao/sqlglot/pull/6872) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`0e48e25`](https://github.com/tobymao/sqlglot/commit/0e48e255b28352ebed06253b25ef049215330624) - **optimizer**: qualify columns with circular dependency *(PR [#6873](https://github.com/tobymao/sqlglot/pull/6873) by [@geooo109](https://github.com/geooo109))*
- [`9c39f08`](https://github.com/tobymao/sqlglot/commit/9c39f085924a9a59cd4a32322f3e45c710467563) - **optimizer**: Annotate DAYOFWEEK for MySQL *(PR [#6885](https://github.com/tobymao/sqlglot/pull/6885) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`8ae8ef7`](https://github.com/tobymao/sqlglot/commit/8ae8ef74f2402d0c5c6f2c3bb704f9ea2311b720) - **postgres**: missing ON TRUE required when transpiling APPLY  *(PR [#6884](https://github.com/tobymao/sqlglot/pull/6884) by [@c3us-dev](https://github.com/c3us-dev))*
  - :arrow_lower_right: *fixes issue [#6883](https://github.com/tobymao/sqlglot/issues/6883) opened by [@c3us-dev](https://github.com/c3us-dev)*

### :wrench: Chores
- [`167b670`](https://github.com/tobymao/sqlglot/commit/167b6708ba7bb37bb826cb1a4ceec39f0719e773) - AB-sort typing dicts *(commit by [@VaggelisD](https://github.com/VaggelisD))*
- [`1c9cf7b`](https://github.com/tobymao/sqlglot/commit/1c9cf7bfed3f819957110964f5c44794a3e9a8bb) - **optimizer**: annotate snowflake ARRAY_COMPACT *(PR [#6735](https://github.com/tobymao/sqlglot/pull/6735) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`aefd6c5`](https://github.com/tobymao/sqlglot/commit/aefd6c508664c39d7f8ab7e79f34151a285e1b04) - Add Spark & DBX tests for ARRAY_COMPACT for PR6735 *(commit by [@VaggelisD](https://github.com/VaggelisD))*
- [`e56ff6b`](https://github.com/tobymao/sqlglot/commit/e56ff6bb52997e2c9cc12bd4985dd977d44c7507) - Rename TokenType.TILDA to TokenType.TILDE *(PR [#6742](https://github.com/tobymao/sqlglot/pull/6742) by [@VaggelisD](https://github.com/VaggelisD))*
- [`931fbce`](https://github.com/tobymao/sqlglot/commit/931fbce6543e84fb938cff91215cfefaab048f3d) - add YDB plugin to dialects list *(PR [#6741](https://github.com/tobymao/sqlglot/pull/6741) by [@vgvoleg](https://github.com/vgvoleg))*
- [`3b5fb43`](https://github.com/tobymao/sqlglot/commit/3b5fb43885277d1ffda9926e5a9b58312d8840de) - Refactor PR 6679 *(PR [#6749](https://github.com/tobymao/sqlglot/pull/6749) by [@VaggelisD](https://github.com/VaggelisD))*
- [`8c6d01e`](https://github.com/tobymao/sqlglot/commit/8c6d01e8eb409e750070055f65ac52e0ec921103) - refactor LENGTH type annotation *(PR [#6758](https://github.com/tobymao/sqlglot/pull/6758) by [@geooo109](https://github.com/geooo109))*
- [`33d9e63`](https://github.com/tobymao/sqlglot/commit/33d9e63af776b6b51816774f712402f6cde6498c) - clean up redundant annotators *(PR [#6776](https://github.com/tobymao/sqlglot/pull/6776) by [@georgesittas](https://github.com/georgesittas))*
- [`8fa7198`](https://github.com/tobymao/sqlglot/commit/8fa71980c2282d346cbedef1a8c330b7e5722379) - annotation tests for HEX func *(commit by [@geooo109](https://github.com/geooo109))*
- [`d3a0ffa`](https://github.com/tobymao/sqlglot/commit/d3a0ffa1e49cb69403cef331e1d5704cef5d63f8) - refactor boolean function generators for duckdb *(PR [#6857](https://github.com/tobymao/sqlglot/pull/6857) by [@georgesittas](https://github.com/georgesittas))*
- [`6fc77ce`](https://github.com/tobymao/sqlglot/commit/6fc77ce335f0f2d5099285bf17ae81576aac89fb) - refactor mysql, doris, starrocks partition by syntax *(PR [#6858](https://github.com/tobymao/sqlglot/pull/6858) by [@geooo109](https://github.com/geooo109))*
- [`16959de`](https://github.com/tobymao/sqlglot/commit/16959de3118302fef2ad228dc233da46fce73dca) - fix style for starrocks *(commit by [@geooo109](https://github.com/geooo109))*
- [`fa3c944`](https://github.com/tobymao/sqlglot/commit/fa3c9448d2fb132dd837b0dd5d6d4eb02297ba1a) - refactor starrocks *(PR [#6880](https://github.com/tobymao/sqlglot/pull/6880) by [@geooo109](https://github.com/geooo109))*
- [`1438115`](https://github.com/tobymao/sqlglot/commit/14381150e5b28a0134899d36935b8c99aca9058c) - clean up sf IS_ARRAY tests *(commit by [@geooo109](https://github.com/geooo109))*
- [`5f67a14`](https://github.com/tobymao/sqlglot/commit/5f67a149635cd000249eb1fc26b18493f29c4974) - bump sqlglotrs to 0.12.0 *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v28.6.0] - 2026-01-13
### :boom: BREAKING CHANGES
- due to [`06ce65a`](https://github.com/tobymao/sqlglot/commit/06ce65ab4235d180d30c59a74756bdd8026fddc7) - support transpilation of bitwise agg functions *(PR [#6580](https://github.com/tobymao/sqlglot/pull/6580) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  support transpilation of bitwise agg functions (#6580)

- due to [`1497ee6`](https://github.com/tobymao/sqlglot/commit/1497ee6197dd1bd15926ab40bb09f03f72a4da34) - corrected handling of ToChar for Postgres *(commit by [@dhawkins1234](https://github.com/dhawkins1234))*:

  corrected handling of ToChar for Postgres

- due to [`c52705d`](https://github.com/tobymao/sqlglot/commit/c52705dec16390e0651d8a68c3500d8fa11dff12) - annotate EXISTS, ALL, ANY as BOOLEAN *(PR [#6590](https://github.com/tobymao/sqlglot/pull/6590) by [@doripo](https://github.com/doripo))*:

  annotate EXISTS, ALL, ANY as BOOLEAN (#6590)

- due to [`8ef9d7b`](https://github.com/tobymao/sqlglot/commit/8ef9d7b2183589217df10004798fd751d4d618d0) - support transpilation of GREATEST, GREATEST_IGNORE_NULLS, LEAST, LEAST_IGNORE_NULLS from snowflake to duckdb *(PR [#6579](https://github.com/tobymao/sqlglot/pull/6579) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation of GREATEST, GREATEST_IGNORE_NULLS, LEAST, LEAST_IGNORE_NULLS from snowflake to duckdb (#6579)

- due to [`b93291b`](https://github.com/tobymao/sqlglot/commit/b93291bee7ada32b4d686db919d8d3d683d95425) - support transpilation of TRY_TO_BOOLEAN from Snowflake to DuckDB *(PR [#6594](https://github.com/tobymao/sqlglot/pull/6594) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation of TRY_TO_BOOLEAN from Snowflake to DuckDB (#6594)

- due to [`00e596d`](https://github.com/tobymao/sqlglot/commit/00e596d1a7a6b806cd1c632afd6b09f4f5270086) - support transpilation of BOOLXOR_AGG, BOOLAND_AGG, and BOOLOR_AGG from Snowflake to DuckDB *(PR [#6592](https://github.com/tobymao/sqlglot/pull/6592) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  support transpilation of BOOLXOR_AGG, BOOLAND_AGG, and BOOLOR_AGG from Snowflake to DuckDB (#6592)

- due to [`0ba33ad`](https://github.com/tobymao/sqlglot/commit/0ba33ad69abcb718f761090cdd867e45d9481b80) - Add transpilation support for DAYNAME and MONTHNAME functions. *(PR [#6603](https://github.com/tobymao/sqlglot/pull/6603) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Add transpilation support for DAYNAME and MONTHNAME functions. (#6603)

- due to [`62c0ef0`](https://github.com/tobymao/sqlglot/commit/62c0ef0ad4579a55d65498eddd4e649ae464b559) - Fix BQ's exp.Date transpilation *(PR [#6595](https://github.com/tobymao/sqlglot/pull/6595) by [@VaggelisD](https://github.com/VaggelisD))*:

  Fix BQ's exp.Date transpilation (#6595)

- due to [`77ff9d0`](https://github.com/tobymao/sqlglot/commit/77ff9d0c5cec8fdba7e64fe02c0db0a63a64f1e0) - annotate types for MAP_* functions *(PR [#6605](https://github.com/tobymao/sqlglot/pull/6605) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  annotate types for MAP_* functions (#6605)

- due to [`e7c1574`](https://github.com/tobymao/sqlglot/commit/e7c1574f89314a304933a2b3b391528d530ea596) - Add transpilation support for DATE_DIFF function *(PR [#6609](https://github.com/tobymao/sqlglot/pull/6609) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Add transpilation support for DATE_DIFF function (#6609)

- due to [`d8f0bbd`](https://github.com/tobymao/sqlglot/commit/d8f0bbdbd208acc0eccb7e9be331d2661169ad97) - conditionally consume +/- in scientific literal notation *(PR [#6610](https://github.com/tobymao/sqlglot/pull/6610) by [@georgesittas](https://github.com/georgesittas))*:

  conditionally consume +/- in scientific literal notation (#6610)

- due to [`13014e0`](https://github.com/tobymao/sqlglot/commit/13014e0f01d10f0a078ef8aed4569d3aa8bd741b) - move postgres range parsers to global level *(PR [#6591](https://github.com/tobymao/sqlglot/pull/6591) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  move postgres range parsers to global level (#6591)

- due to [`d26ff44`](https://github.com/tobymao/sqlglot/commit/d26ff4444fba6697f25efa3dea5ab751fe560f6b) - support adjacent ranges operator *(PR [#6611](https://github.com/tobymao/sqlglot/pull/6611) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  support adjacent ranges operator (#6611)

- due to [`1f3436b`](https://github.com/tobymao/sqlglot/commit/1f3436bfe7ddbbf212d61616153f150d32824450) - bq robust literal/non-literal type annotation *(PR [#6600](https://github.com/tobymao/sqlglot/pull/6600) by [@geooo109](https://github.com/geooo109))*:

  bq robust literal/non-literal type annotation (#6600)

- due to [`8f38887`](https://github.com/tobymao/sqlglot/commit/8f3888746a1f36446544483e920e1287ebf76b4f) - annotate snowflake array construct *(commit by [@georgesittas](https://github.com/georgesittas))*:

  annotate snowflake array construct

- due to [`870dba4`](https://github.com/tobymao/sqlglot/commit/870dba41cc88dc9e4802f3695f3f715e0c35e0ed) - support transpilation of LAST_DAY from Snowflake to Duckdb *(PR [#6614](https://github.com/tobymao/sqlglot/pull/6614) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation of LAST_DAY from Snowflake to Duckdb (#6614)

- due to [`870d600`](https://github.com/tobymao/sqlglot/commit/870d600a93108b1a1d68936244564548dec5f683) - support: postgres point *(PR [#6615](https://github.com/tobymao/sqlglot/pull/6615) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  support: postgres point (#6615)

- due to [`302fda0`](https://github.com/tobymao/sqlglot/commit/302fda0151094bc074b98847390cd554414258bb) - support and, or *(PR [#6625](https://github.com/tobymao/sqlglot/pull/6625) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  support and, or (#6625)

- due to [`fc5800d`](https://github.com/tobymao/sqlglot/commit/fc5800d1359f9b0933622cb355fdb7a34f2f486a) - support Snowflake to DuckDB transpilation of ZIPF  *(PR [#6618](https://github.com/tobymao/sqlglot/pull/6618) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  support Snowflake to DuckDB transpilation of ZIPF  (#6618)

- due to [`dea22ca`](https://github.com/tobymao/sqlglot/commit/dea22ca07076c1ef6a08f06f9fdc6070ca0fecb8) - support `RECORD` type *(PR [#6635](https://github.com/tobymao/sqlglot/pull/6635) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  support `RECORD` type (#6635)

- due to [`77783da`](https://github.com/tobymao/sqlglot/commit/77783da1329ad5d681a7d37928e4dbedd68ab365) - support: var-args in `xor` *(PR [#6634](https://github.com/tobymao/sqlglot/pull/6634) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  support: var-args in `xor` (#6634)

- due to [`b75a3e3`](https://github.com/tobymao/sqlglot/commit/b75a3e3b5d948f55df5b0096d116edf3b898e5e1) - handle BINARY keyword *(PR [#6636](https://github.com/tobymao/sqlglot/pull/6636) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  handle BINARY keyword (#6636)

- due to [`e7b5d6f`](https://github.com/tobymao/sqlglot/commit/e7b5d6f1b8031fbf25e1fd7c3b42309c4aae8810) - support transpilation of TRY_TO_BINARY from Snowflake to DuckDB *(PR [#6629](https://github.com/tobymao/sqlglot/pull/6629) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation of TRY_TO_BINARY from Snowflake to DuckDB (#6629)

- due to [`2bf9405`](https://github.com/tobymao/sqlglot/commit/2bf9405adf9c9c72c77f7aa8ab792779a3b9c5f3) - USING keyword in chr *(PR [#6637](https://github.com/tobymao/sqlglot/pull/6637) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  USING keyword in chr (#6637)

- due to [`235fc14`](https://github.com/tobymao/sqlglot/commit/235fc14f40c422e6339da0a6b17252ab9eb18ec2) - support charset *(PR [#6633](https://github.com/tobymao/sqlglot/pull/6633) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  support charset (#6633)

- due to [`d46969d`](https://github.com/tobymao/sqlglot/commit/d46969db50ff52b8657d5b33f0a106b69dbd1e2a) - annotate snowflake ARRAY_APPEND and ARRAY_PREPEND *(PR [#6645](https://github.com/tobymao/sqlglot/pull/6645) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate snowflake ARRAY_APPEND and ARRAY_PREPEND (#6645)

- due to [`9c54329`](https://github.com/tobymao/sqlglot/commit/9c543291a0e28ad044523747d19262243fed1f5d) - Type annotation for Snowflake ENCRYPT and DECRYPT functions *(PR [#6643](https://github.com/tobymao/sqlglot/pull/6643) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Type annotation for Snowflake ENCRYPT and DECRYPT functions (#6643)

- due to [`7870bd0`](https://github.com/tobymao/sqlglot/commit/7870bd0dc7503d0a1863d7623be7fc12bb9412e4) - type annotation for COVAR_POP and COVAR_SAMP *(PR [#6656](https://github.com/tobymao/sqlglot/pull/6656) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  type annotation for COVAR_POP and COVAR_SAMP (#6656)

- due to [`2fa29b1`](https://github.com/tobymao/sqlglot/commit/2fa29b1e0feb6d8f9290c105e5fa0f349a011e22) - Type annotation for ARRAY_REMOVE function *(PR [#6653](https://github.com/tobymao/sqlglot/pull/6653) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  Type annotation for ARRAY_REMOVE function (#6653)

- due to [`3d59af5`](https://github.com/tobymao/sqlglot/commit/3d59af557caf5c0fd109ae687b8408264543f9ea) - Added UNIFORM transpilation for Snowflake to DuckDB *(PR [#6640](https://github.com/tobymao/sqlglot/pull/6640) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Added UNIFORM transpilation for Snowflake to DuckDB (#6640)

- due to [`5552f12`](https://github.com/tobymao/sqlglot/commit/5552f121f9c9a8103fc3ccf58fd5eed076fe0575) - annotation support for LOCALTIME function *(PR [#6651](https://github.com/tobymao/sqlglot/pull/6651) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  annotation support for LOCALTIME function (#6651)

- due to [`a669651`](https://github.com/tobymao/sqlglot/commit/a6696518efefabaf815d7c61f1ae923c39ce6107) - Type annotation for Snowflake LOCALTIMESTAMP *(PR [#6652](https://github.com/tobymao/sqlglot/pull/6652) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Type annotation for Snowflake LOCALTIMESTAMP (#6652)

- due to [`40ccce4`](https://github.com/tobymao/sqlglot/commit/40ccce492746cc969467c234b9c7d345454da683) - Transpile Snowflake NORMAL to DuckDB using Box-Muller transform *(PR [#6654](https://github.com/tobymao/sqlglot/pull/6654) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Transpile Snowflake NORMAL to DuckDB using Box-Muller transform (#6654)

- due to [`d6bf569`](https://github.com/tobymao/sqlglot/commit/d6bf569ef2442d5055ab788a2078adf485cc1120) - updates for Snowflake to DuckDB transpilation of TO_TIMESTAMP functions *(PR [#6622](https://github.com/tobymao/sqlglot/pull/6622) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  updates for Snowflake to DuckDB transpilation of TO_TIMESTAMP functions (#6622)

- due to [`13251fd`](https://github.com/tobymao/sqlglot/commit/13251fd7f03d31af69b86a4ef5bb6e940cc9318b) - annotation support for ELT function *(PR [#6659](https://github.com/tobymao/sqlglot/pull/6659) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  annotation support for ELT function (#6659)

- due to [`b287e4e`](https://github.com/tobymao/sqlglot/commit/b287e4ef9e05c0ba1fadc3638977e994eb911834) - Support transpilation for BITMAP_BUCKET_NUMBER *(PR [#6668](https://github.com/tobymao/sqlglot/pull/6668) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  Support transpilation for BITMAP_BUCKET_NUMBER (#6668)

- due to [`d5b84cb`](https://github.com/tobymao/sqlglot/commit/d5b84cbbd1406ebd9f5e2373e12b0d15dcb85d7f) - ignore comments in the semantic differ *(PR [#6675](https://github.com/tobymao/sqlglot/pull/6675) by [@georgesittas](https://github.com/georgesittas))*:

  ignore comments in the semantic differ (#6675)

- due to [`399c80f`](https://github.com/tobymao/sqlglot/commit/399c80f2e66a1acdcd7d567e44c297db7071dc8f) - rename args for CovarSamp/Pop, stop inheriting from Binary *(commit by [@georgesittas](https://github.com/georgesittas))*:

  rename args for CovarSamp/Pop, stop inheriting from Binary

- due to [`c9a70c0`](https://github.com/tobymao/sqlglot/commit/c9a70c004e0ec563e8a712668a30da9856cb0516) - update transpilation of DATE_TRUNC to duckdb *(PR [#6644](https://github.com/tobymao/sqlglot/pull/6644) by [@toriwei](https://github.com/toriwei))*:

  update transpilation of DATE_TRUNC to duckdb (#6644)

- due to [`460b3a2`](https://github.com/tobymao/sqlglot/commit/460b3a2ae62d8294c57068453b5a11e4a7e12a91) - Allow varlen args in exp.MD5Digest *(PR [#6685](https://github.com/tobymao/sqlglot/pull/6685) by [@VaggelisD](https://github.com/VaggelisD))*:

  Allow varlen args in exp.MD5Digest (#6685)

- due to [`dcdee68`](https://github.com/tobymao/sqlglot/commit/dcdee68cb1a77286232865de9df8d8a01898fcc7) - Allow non aggregation functions in PIVOT *(PR [#6687](https://github.com/tobymao/sqlglot/pull/6687) by [@VaggelisD](https://github.com/VaggelisD))*:

  Allow non aggregation functions in PIVOT (#6687)

- due to [`a4be3fa`](https://github.com/tobymao/sqlglot/commit/a4be3faf63c981a2b10b1f8c709581acf59277ce) - support SYSTIMESTAMP as NO_PAREN_FUNCTION *(PR [#6677](https://github.com/tobymao/sqlglot/pull/6677) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  support SYSTIMESTAMP as NO_PAREN_FUNCTION (#6677)

- due to [`243448c`](https://github.com/tobymao/sqlglot/commit/243448ca5ccc6a26d680661dcb7d921a055dbfa9) - Transpile date extraction from Snowflake to DuckDB (YEAR*, WEEK*, DAY*, etc) *(PR [#6666](https://github.com/tobymao/sqlglot/pull/6666) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Transpile date extraction from Snowflake to DuckDB (YEAR*, WEEK*, DAY*, etc) (#6666)

- due to [`29cff1f`](https://github.com/tobymao/sqlglot/commit/29cff1fbe0011476b22e1b1442af857499f871a6) - bq robust literal/non-literal binary annotation *(PR [#6688](https://github.com/tobymao/sqlglot/pull/6688) by [@geooo109](https://github.com/geooo109))*:

  bq robust literal/non-literal binary annotation (#6688)

- due to [`65acd6c`](https://github.com/tobymao/sqlglot/commit/65acd6c00f023c3279947b23e04139bc9554db85) - transpile snowflake SYSDATE *(PR [#6693](https://github.com/tobymao/sqlglot/pull/6693) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  transpile snowflake SYSDATE (#6693)

- due to [`36ff96c`](https://github.com/tobymao/sqlglot/commit/36ff96c727e40dbe467d6338128f87a74b99a980) - support transpilation of BITSHIFTLEFT and BITSHIFTRIGHT *(PR [#6586](https://github.com/tobymao/sqlglot/pull/6586) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  support transpilation of BITSHIFTLEFT and BITSHIFTRIGHT (#6586)

- due to [`fb8f57a`](https://github.com/tobymao/sqlglot/commit/fb8f57ac54a4e0213941f3bd057ccb03c4e125b7) - Fix UPDATE statement for multi tables *(PR [#6700](https://github.com/tobymao/sqlglot/pull/6700) by [@VaggelisD](https://github.com/VaggelisD))*:

  Fix UPDATE statement for multi tables (#6700)

- due to [`21f9d3c`](https://github.com/tobymao/sqlglot/commit/21f9d3ca7c6fa0d38f0f63000f904589b91c7d0a) - Normalize struct field names when annotating types *(PR [#6674](https://github.com/tobymao/sqlglot/pull/6674) by [@vchan](https://github.com/vchan))*:

  Normalize struct field names when annotating types (#6674)

- due to [`7362c23`](https://github.com/tobymao/sqlglot/commit/7362c2357eba540a12eea079e9f4212f3545c8d1) - interval expressions *(PR [#6648](https://github.com/tobymao/sqlglot/pull/6648) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  interval expressions (#6648)

- due to [`a503a7a`](https://github.com/tobymao/sqlglot/commit/a503a7adbfe3352924e94a21303a2ac23903833c) - annotate Encode for hive dialect hierarchy *(commit by [@georgesittas](https://github.com/georgesittas))*:

  annotate Encode for hive dialect hierarchy

- due to [`c447df7`](https://github.com/tobymao/sqlglot/commit/c447df71a645f55e4798887bde4d42285f5dea4a) - annotate the LOCALTIMESTAMP *(PR [#6709](https://github.com/tobymao/sqlglot/pull/6709) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  annotate the LOCALTIMESTAMP (#6709)

- due to [`e91a14b`](https://github.com/tobymao/sqlglot/commit/e91a14b5b325d3d71fbdbe701e531588723bcd2e) - annotate the CURRENT_TIMEZONE *(PR [#6708](https://github.com/tobymao/sqlglot/pull/6708) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  annotate the CURRENT_TIMEZONE (#6708)

- due to [`b53c8d4`](https://github.com/tobymao/sqlglot/commit/b53c8d47481d735c74ae8704a90594f33263eee8) - annotate the UNIX_TIMESTAMP *(PR [#6717](https://github.com/tobymao/sqlglot/pull/6717) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  annotate the UNIX_TIMESTAMP (#6717)

- due to [`cfb06ab`](https://github.com/tobymao/sqlglot/commit/cfb06ab58c606715e688d39e704b1587fcd256e8) - add support for transpiling ARRAY_AGG with ORDER BY *(PR [#6691](https://github.com/tobymao/sqlglot/pull/6691) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  add support for transpiling ARRAY_AGG with ORDER BY (#6691)

- due to [`2965077`](https://github.com/tobymao/sqlglot/commit/296507773fc4476862cc1ee374f88c7d73cb147f) - add support for JSON_KEYS func *(PR [#6718](https://github.com/tobymao/sqlglot/pull/6718) by [@geooo109](https://github.com/geooo109))*:

  add support for JSON_KEYS func (#6718)

- due to [`bbaba5f`](https://github.com/tobymao/sqlglot/commit/bbaba5fd7d0111947035534168593a5a3ee6839a) - annotate type for snowflake ARRAY_CAT *(PR [#6721](https://github.com/tobymao/sqlglot/pull/6721) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for snowflake ARRAY_CAT (#6721)

- due to [`0a1c7ab`](https://github.com/tobymao/sqlglot/commit/0a1c7abddc0cbd2f853a431848c1ae45e6876ba2) - support transpilation of GETBIT from snowflake to duckdb *(PR [#6692](https://github.com/tobymao/sqlglot/pull/6692) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation of GETBIT from snowflake to duckdb (#6692)

- due to [`cb320c4`](https://github.com/tobymao/sqlglot/commit/cb320c41361f0bb7ad71522366ff4cb8691607bf) - bq annotate type for raw strings *(PR [#6723](https://github.com/tobymao/sqlglot/pull/6723) by [@geooo109](https://github.com/geooo109))*:

  bq annotate type for raw strings (#6723)

- due to [`09fa467`](https://github.com/tobymao/sqlglot/commit/09fa467461656d5c4d4e57c7044c46ff4fcf3f7f) - Annotate ATAN2 for Spark & DBX *(PR [#6725](https://github.com/tobymao/sqlglot/pull/6725) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate ATAN2 for Spark & DBX (#6725)

- due to [`b59b3bf`](https://github.com/tobymao/sqlglot/commit/b59b3bfd06c18120db2938748c561495dd885ab4) - Annotate TANH for Spark & DBX  *(PR [#6726](https://github.com/tobymao/sqlglot/pull/6726) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  Annotate TANH for Spark & DBX  (#6726)

- due to [`917071b`](https://github.com/tobymao/sqlglot/commit/917071b42b91f5111d88d599a1caed83e6d7661c) - Support transpilation of TO_TIME and TRY_TO_TIME from snowflake to duckdb *(PR [#6690](https://github.com/tobymao/sqlglot/pull/6690) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Support transpilation of TO_TIME and TRY_TO_TIME from snowflake to duckdb (#6690)

- due to [`e50a97e`](https://github.com/tobymao/sqlglot/commit/e50a97ed05d50be9fbea7720511a760c11f4a86e) - Type annotate for Snowflake Kurtosis *(PR [#6720](https://github.com/tobymao/sqlglot/pull/6720) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Type annotate for Snowflake Kurtosis (#6720)

- due to [`33b8a5d`](https://github.com/tobymao/sqlglot/commit/33b8a5d25bf49791fb95ec20132ab6ff0bb885e0) - bump sqlglotrs to 0.11.0 *(commit by [@georgesittas](https://github.com/georgesittas))*:

  bump sqlglotrs to 0.11.0


### :sparkles: New Features
- [`06ce65a`](https://github.com/tobymao/sqlglot/commit/06ce65ab4235d180d30c59a74756bdd8026fddc7) - **snowflake**: support transpilation of bitwise agg functions *(PR [#6580](https://github.com/tobymao/sqlglot/pull/6580) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`82abf40`](https://github.com/tobymao/sqlglot/commit/82abf4085dd93d23b1612304704fcb89b2cb09e2) - **duckdb**: Add tranwspilation support for CEIL function *(PR [#6589](https://github.com/tobymao/sqlglot/pull/6589) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`9f9994d`](https://github.com/tobymao/sqlglot/commit/9f9994df1582a1b3e16dcf27c618dadfdffd8745) - **duckdb**: Add transpilation support for float/decimal numbers and preserve end-of-month logic & type *(PR [#6576](https://github.com/tobymao/sqlglot/pull/6576) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`8ef9d7b`](https://github.com/tobymao/sqlglot/commit/8ef9d7b2183589217df10004798fd751d4d618d0) - **snowflake**: support transpilation of GREATEST, GREATEST_IGNORE_NULLS, LEAST, LEAST_IGNORE_NULLS from snowflake to duckdb *(PR [#6579](https://github.com/tobymao/sqlglot/pull/6579) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`b93291b`](https://github.com/tobymao/sqlglot/commit/b93291bee7ada32b4d686db919d8d3d683d95425) - **snowflake**: support transpilation of TRY_TO_BOOLEAN from Snowflake to DuckDB *(PR [#6594](https://github.com/tobymao/sqlglot/pull/6594) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`00e596d`](https://github.com/tobymao/sqlglot/commit/00e596d1a7a6b806cd1c632afd6b09f4f5270086) - **snowflake**: support transpilation of BOOLXOR_AGG, BOOLAND_AGG, and BOOLOR_AGG from Snowflake to DuckDB *(PR [#6592](https://github.com/tobymao/sqlglot/pull/6592) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`0ba33ad`](https://github.com/tobymao/sqlglot/commit/0ba33ad69abcb718f761090cdd867e45d9481b80) - **duckdb**: Add transpilation support for DAYNAME and MONTHNAME functions. *(PR [#6603](https://github.com/tobymao/sqlglot/pull/6603) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`77ff9d0`](https://github.com/tobymao/sqlglot/commit/77ff9d0c5cec8fdba7e64fe02c0db0a63a64f1e0) - **snowflake**: annotate types for MAP_* functions *(PR [#6605](https://github.com/tobymao/sqlglot/pull/6605) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`e7c1574`](https://github.com/tobymao/sqlglot/commit/e7c1574f89314a304933a2b3b391528d530ea596) - **duckdb**: Add transpilation support for DATE_DIFF function *(PR [#6609](https://github.com/tobymao/sqlglot/pull/6609) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`d26ff44`](https://github.com/tobymao/sqlglot/commit/d26ff4444fba6697f25efa3dea5ab751fe560f6b) - **postgres**: support adjacent ranges operator *(PR [#6611](https://github.com/tobymao/sqlglot/pull/6611) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`8f38887`](https://github.com/tobymao/sqlglot/commit/8f3888746a1f36446544483e920e1287ebf76b4f) - **optimizer**: annotate snowflake array construct *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`870dba4`](https://github.com/tobymao/sqlglot/commit/870dba41cc88dc9e4802f3695f3f715e0c35e0ed) - **snowflake**: support transpilation of LAST_DAY from Snowflake to Duckdb *(PR [#6614](https://github.com/tobymao/sqlglot/pull/6614) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`fc5800d`](https://github.com/tobymao/sqlglot/commit/fc5800d1359f9b0933622cb355fdb7a34f2f486a) - **snowflake**: support Snowflake to DuckDB transpilation of ZIPF  *(PR [#6618](https://github.com/tobymao/sqlglot/pull/6618) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`4aea018`](https://github.com/tobymao/sqlglot/commit/4aea018c2d4b701ac1b895445ef390307666693f) - **duckdb**: Add transpilation support for nanoseconds used in date/time functions. *(PR [#6617](https://github.com/tobymao/sqlglot/pull/6617) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`dea22ca`](https://github.com/tobymao/sqlglot/commit/dea22ca07076c1ef6a08f06f9fdc6070ca0fecb8) - **singlestore**: support `RECORD` type *(PR [#6635](https://github.com/tobymao/sqlglot/pull/6635) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`77783da`](https://github.com/tobymao/sqlglot/commit/77783da1329ad5d681a7d37928e4dbedd68ab365) - **clickhouse**: support: var-args in `xor` *(PR [#6634](https://github.com/tobymao/sqlglot/pull/6634) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`b75a3e3`](https://github.com/tobymao/sqlglot/commit/b75a3e3b5d948f55df5b0096d116edf3b898e5e1) - **mysql**: handle BINARY keyword *(PR [#6636](https://github.com/tobymao/sqlglot/pull/6636) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`c17878a`](https://github.com/tobymao/sqlglot/commit/c17878a35c761824b58b0e0743585e3a5717d1b4) - add ability to create dialect plugins *(PR [#6627](https://github.com/tobymao/sqlglot/pull/6627) by [@vgvoleg](https://github.com/vgvoleg))*
  - :arrow_lower_right: *addresses issue [#6626](https://github.com/tobymao/sqlglot/issues/6626) opened by [@vgvoleg](https://github.com/vgvoleg)*
- [`e7b5d6f`](https://github.com/tobymao/sqlglot/commit/e7b5d6f1b8031fbf25e1fd7c3b42309c4aae8810) - **snowflake**: support transpilation of TRY_TO_BINARY from Snowflake to DuckDB *(PR [#6629](https://github.com/tobymao/sqlglot/pull/6629) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`9c54329`](https://github.com/tobymao/sqlglot/commit/9c543291a0e28ad044523747d19262243fed1f5d) - **snowflake**: Type annotation for Snowflake ENCRYPT and DECRYPT functions *(PR [#6643](https://github.com/tobymao/sqlglot/pull/6643) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`7870bd0`](https://github.com/tobymao/sqlglot/commit/7870bd0dc7503d0a1863d7623be7fc12bb9412e4) - **snowflake**: type annotation for COVAR_POP and COVAR_SAMP *(PR [#6656](https://github.com/tobymao/sqlglot/pull/6656) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`2fa29b1`](https://github.com/tobymao/sqlglot/commit/2fa29b1e0feb6d8f9290c105e5fa0f349a011e22) - **snowflake**: Type annotation for ARRAY_REMOVE function *(PR [#6653](https://github.com/tobymao/sqlglot/pull/6653) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`3d59af5`](https://github.com/tobymao/sqlglot/commit/3d59af557caf5c0fd109ae687b8408264543f9ea) - **snowflake**: Added UNIFORM transpilation for Snowflake to DuckDB *(PR [#6640](https://github.com/tobymao/sqlglot/pull/6640) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`5552f12`](https://github.com/tobymao/sqlglot/commit/5552f121f9c9a8103fc3ccf58fd5eed076fe0575) - annotation support for LOCALTIME function *(PR [#6651](https://github.com/tobymao/sqlglot/pull/6651) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`a669651`](https://github.com/tobymao/sqlglot/commit/a6696518efefabaf815d7c61f1ae923c39ce6107) - **snowflake**: Type annotation for Snowflake LOCALTIMESTAMP *(PR [#6652](https://github.com/tobymao/sqlglot/pull/6652) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`40ccce4`](https://github.com/tobymao/sqlglot/commit/40ccce492746cc969467c234b9c7d345454da683) - **duckdb**: Transpile Snowflake NORMAL to DuckDB using Box-Muller transform *(PR [#6654](https://github.com/tobymao/sqlglot/pull/6654) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`d6bf569`](https://github.com/tobymao/sqlglot/commit/d6bf569ef2442d5055ab788a2078adf485cc1120) - **snowflake**: updates for Snowflake to DuckDB transpilation of TO_TIMESTAMP functions *(PR [#6622](https://github.com/tobymao/sqlglot/pull/6622) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`51af50e`](https://github.com/tobymao/sqlglot/commit/51af50e937dafb80d42cd639b7fb8e139d811ea0) - **snowflake**: support out of range values for DATE_FROM_PARTS when transpiling to DuckDB *(PR [#6671](https://github.com/tobymao/sqlglot/pull/6671) by [@toriwei](https://github.com/toriwei))*
- [`13251fd`](https://github.com/tobymao/sqlglot/commit/13251fd7f03d31af69b86a4ef5bb6e940cc9318b) - **mysql**: annotation support for ELT function *(PR [#6659](https://github.com/tobymao/sqlglot/pull/6659) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`b287e4e`](https://github.com/tobymao/sqlglot/commit/b287e4ef9e05c0ba1fadc3638977e994eb911834) - **snowflake**: Support transpilation for BITMAP_BUCKET_NUMBER *(PR [#6668](https://github.com/tobymao/sqlglot/pull/6668) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`d5b84cb`](https://github.com/tobymao/sqlglot/commit/d5b84cbbd1406ebd9f5e2373e12b0d15dcb85d7f) - **diff**: ignore comments in the semantic differ *(PR [#6675](https://github.com/tobymao/sqlglot/pull/6675) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#6673](https://github.com/tobymao/sqlglot/issues/6673) opened by [@GaryLiuGTA](https://github.com/GaryLiuGTA)*
- [`26c16f2`](https://github.com/tobymao/sqlglot/commit/26c16f2f4bb9aaa91253a06c337b8320dc4609c9) - **snowflake**: transpile CORR with NaN-->NULL *(PR [#6619](https://github.com/tobymao/sqlglot/pull/6619) by [@treysp](https://github.com/treysp))*
- [`c9a70c0`](https://github.com/tobymao/sqlglot/commit/c9a70c004e0ec563e8a712668a30da9856cb0516) - **snowflake**: update transpilation of DATE_TRUNC to duckdb *(PR [#6644](https://github.com/tobymao/sqlglot/pull/6644) by [@toriwei](https://github.com/toriwei))*
- [`a4be3fa`](https://github.com/tobymao/sqlglot/commit/a4be3faf63c981a2b10b1f8c709581acf59277ce) - **oracle,exasol**: support SYSTIMESTAMP as NO_PAREN_FUNCTION *(PR [#6677](https://github.com/tobymao/sqlglot/pull/6677) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
  - :arrow_lower_right: *addresses issue [#6686](https://github.com/tobymao/sqlglot/issues/6686) opened by [@Hfuegl](https://github.com/Hfuegl)*
- [`243448c`](https://github.com/tobymao/sqlglot/commit/243448ca5ccc6a26d680661dcb7d921a055dbfa9) - **duckdb**: Transpile date extraction from Snowflake to DuckDB (YEAR*, WEEK*, DAY*, etc) *(PR [#6666](https://github.com/tobymao/sqlglot/pull/6666) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`efa77df`](https://github.com/tobymao/sqlglot/commit/efa77df3734f2e8534ca911d39c9a5c6103a82fa) - **mysql**: translate UPDATE … FROM … syntax to UPDATE … JOIN … when generating MySQL *(PR [#6655](https://github.com/tobymao/sqlglot/pull/6655) by [@brdbry](https://github.com/brdbry))*
- [`65acd6c`](https://github.com/tobymao/sqlglot/commit/65acd6c00f023c3279947b23e04139bc9554db85) - **duckdb**: transpile snowflake SYSDATE *(PR [#6693](https://github.com/tobymao/sqlglot/pull/6693) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`36ff96c`](https://github.com/tobymao/sqlglot/commit/36ff96c727e40dbe467d6338128f87a74b99a980) - **snowflake**: support transpilation of BITSHIFTLEFT and BITSHIFTRIGHT *(PR [#6586](https://github.com/tobymao/sqlglot/pull/6586) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`142acd2`](https://github.com/tobymao/sqlglot/commit/142acd21ae9e1b3b1495707b2b6811db830fa61f) - pretty formatting for nested data types *(PR [#6707](https://github.com/tobymao/sqlglot/pull/6707) by [@treysp](https://github.com/treysp))*
- [`a503a7a`](https://github.com/tobymao/sqlglot/commit/a503a7adbfe3352924e94a21303a2ac23903833c) - **optimizer**: annotate Encode for hive dialect hierarchy *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`c447df7`](https://github.com/tobymao/sqlglot/commit/c447df71a645f55e4798887bde4d42285f5dea4a) - **spark,databricks**: annotate the LOCALTIMESTAMP *(PR [#6709](https://github.com/tobymao/sqlglot/pull/6709) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`e91a14b`](https://github.com/tobymao/sqlglot/commit/e91a14b5b325d3d71fbdbe701e531588723bcd2e) - **spark,databricks**: annotate the CURRENT_TIMEZONE *(PR [#6708](https://github.com/tobymao/sqlglot/pull/6708) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`b53c8d4`](https://github.com/tobymao/sqlglot/commit/b53c8d47481d735c74ae8704a90594f33263eee8) - **hive,spark,databricks**: annotate the UNIX_TIMESTAMP *(PR [#6717](https://github.com/tobymao/sqlglot/pull/6717) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`cfb06ab`](https://github.com/tobymao/sqlglot/commit/cfb06ab58c606715e688d39e704b1587fcd256e8) - **duckdb**: add support for transpiling ARRAY_AGG with ORDER BY *(PR [#6691](https://github.com/tobymao/sqlglot/pull/6691) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`2965077`](https://github.com/tobymao/sqlglot/commit/296507773fc4476862cc1ee374f88c7d73cb147f) - **parser**: add support for JSON_KEYS func *(PR [#6718](https://github.com/tobymao/sqlglot/pull/6718) by [@geooo109](https://github.com/geooo109))*
- [`52de0a5`](https://github.com/tobymao/sqlglot/commit/52de0a5c9ebc14c738041e47a385981f072291a9) - **duckdb**: Add transpilation support for float/decimal numbers for TIME functions *(PR [#6719](https://github.com/tobymao/sqlglot/pull/6719) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`bbeb881`](https://github.com/tobymao/sqlglot/commit/bbeb881016e4b84dc5cb6a29846224784591abba) - **oracle**: Added support for IN/OUT keywords in stored procedure parameters *(PR [#6710](https://github.com/tobymao/sqlglot/pull/6710) by [@rsanchez-xtillion](https://github.com/rsanchez-xtillion))*
- [`0a1c7ab`](https://github.com/tobymao/sqlglot/commit/0a1c7abddc0cbd2f853a431848c1ae45e6876ba2) - **snowflake**: support transpilation of GETBIT from snowflake to duckdb *(PR [#6692](https://github.com/tobymao/sqlglot/pull/6692) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`cb320c4`](https://github.com/tobymao/sqlglot/commit/cb320c41361f0bb7ad71522366ff4cb8691607bf) - **optimizer**: bq annotate type for raw strings *(PR [#6723](https://github.com/tobymao/sqlglot/pull/6723) by [@geooo109](https://github.com/geooo109))*
- [`09fa467`](https://github.com/tobymao/sqlglot/commit/09fa467461656d5c4d4e57c7044c46ff4fcf3f7f) - **optimizer**: Annotate ATAN2 for Spark & DBX *(PR [#6725](https://github.com/tobymao/sqlglot/pull/6725) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`b59b3bf`](https://github.com/tobymao/sqlglot/commit/b59b3bfd06c18120db2938748c561495dd885ab4) - **optimizer**: Annotate TANH for Spark & DBX  *(PR [#6726](https://github.com/tobymao/sqlglot/pull/6726) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`917071b`](https://github.com/tobymao/sqlglot/commit/917071b42b91f5111d88d599a1caed83e6d7661c) - **snowflake**: Support transpilation of TO_TIME and TRY_TO_TIME from snowflake to duckdb *(PR [#6690](https://github.com/tobymao/sqlglot/pull/6690) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`e50a97e`](https://github.com/tobymao/sqlglot/commit/e50a97ed05d50be9fbea7720511a760c11f4a86e) - **snowflake**: Type annotate for Snowflake Kurtosis *(PR [#6720](https://github.com/tobymao/sqlglot/pull/6720) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`197943f`](https://github.com/tobymao/sqlglot/commit/197943fb56e997cbb7e77a8b2d9f0c2453d052c7) - **postgres**: support index predicate in conflict `INSERT` clause closes [#6727](https://github.com/tobymao/sqlglot/pull/6727) *(commit by [@georgesittas](https://github.com/georgesittas))*

### :bug: Bug Fixes
- [`8f16463`](https://github.com/tobymao/sqlglot/commit/8f16463ebdbb7f51ab778cf34ab89709e018691f) - **presto**: Add support for WEEK function *(PR [#6593](https://github.com/tobymao/sqlglot/pull/6593) by [@chrisqu777](https://github.com/chrisqu777))*
- [`1497ee6`](https://github.com/tobymao/sqlglot/commit/1497ee6197dd1bd15926ab40bb09f03f72a4da34) - **postgres**: corrected handling of ToChar for Postgres *(commit by [@dhawkins1234](https://github.com/dhawkins1234))*
- [`c52705d`](https://github.com/tobymao/sqlglot/commit/c52705dec16390e0651d8a68c3500d8fa11dff12) - **optimizer**: annotate EXISTS, ALL, ANY as BOOLEAN *(PR [#6590](https://github.com/tobymao/sqlglot/pull/6590) by [@doripo](https://github.com/doripo))*
- [`eab6f72`](https://github.com/tobymao/sqlglot/commit/eab6f72a2829def3fd6958f47353ba60ed0e0334) - **parser**: only parse CREATE TABLE pk key ordering in tsql *(PR [#6604](https://github.com/tobymao/sqlglot/pull/6604) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6596](https://github.com/tobymao/sqlglot/issues/6596) opened by [@osmith42](https://github.com/osmith42)*
- [`62c0ef0`](https://github.com/tobymao/sqlglot/commit/62c0ef0ad4579a55d65498eddd4e649ae464b559) - **duckdb**: Fix BQ's exp.Date transpilation *(PR [#6595](https://github.com/tobymao/sqlglot/pull/6595) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6581](https://github.com/tobymao/sqlglot/issues/6581) opened by [@nikchha](https://github.com/nikchha)*
- [`d8f0bbd`](https://github.com/tobymao/sqlglot/commit/d8f0bbdbd208acc0eccb7e9be331d2661169ad97) - **tokenizer**: conditionally consume +/- in scientific literal notation *(PR [#6610](https://github.com/tobymao/sqlglot/pull/6610) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6608](https://github.com/tobymao/sqlglot/issues/6608) opened by [@pjpjean](https://github.com/pjpjean)*
- [`c0b3e5c`](https://github.com/tobymao/sqlglot/commit/c0b3e5c06c7d0ec3335146eab1a86f202298c94a) - **spark**: make_interval week *(PR [#6612](https://github.com/tobymao/sqlglot/pull/6612) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`13014e0`](https://github.com/tobymao/sqlglot/commit/13014e0f01d10f0a078ef8aed4569d3aa8bd741b) - **postgres**: move postgres range parsers to global level *(PR [#6591](https://github.com/tobymao/sqlglot/pull/6591) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`1f3436b`](https://github.com/tobymao/sqlglot/commit/1f3436bfe7ddbbf212d61616153f150d32824450) - **optimizer**: bq robust literal/non-literal type annotation *(PR [#6600](https://github.com/tobymao/sqlglot/pull/6600) by [@geooo109](https://github.com/geooo109))*
- [`870d600`](https://github.com/tobymao/sqlglot/commit/870d600a93108b1a1d68936244564548dec5f683) - **postgres**: support: postgres point *(PR [#6615](https://github.com/tobymao/sqlglot/pull/6615) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`b8b22fa`](https://github.com/tobymao/sqlglot/commit/b8b22fae5cf17ebfe119f815c4cc0ef2dc8132bc) - **trino**: mark as supporting `...EXCEPT ALL` *(PR [#6616](https://github.com/tobymao/sqlglot/pull/6616) by [@NickCrews](https://github.com/NickCrews))*
- [`9382ebd`](https://github.com/tobymao/sqlglot/commit/9382ebdd79c89e9c92ae98a29147c1523cec415f) - **postgres**: Fix exp.WidthBucket required args *(PR [#6621](https://github.com/tobymao/sqlglot/pull/6621) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6620](https://github.com/tobymao/sqlglot/issues/6620) opened by [@codetalker-ai](https://github.com/codetalker-ai)*
- [`302fda0`](https://github.com/tobymao/sqlglot/commit/302fda0151094bc074b98847390cd554414258bb) - **clickhouse**: support and, or *(PR [#6625](https://github.com/tobymao/sqlglot/pull/6625) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`00c80b1`](https://github.com/tobymao/sqlglot/commit/00c80b12936811dde7e661720c1bd17c6ba9271a) - Parse joins with derived tables in UPDATE *(PR [#6632](https://github.com/tobymao/sqlglot/pull/6632) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6628](https://github.com/tobymao/sqlglot/issues/6628) opened by [@marktdodds](https://github.com/marktdodds)*
- [`2bf9405`](https://github.com/tobymao/sqlglot/commit/2bf9405adf9c9c72c77f7aa8ab792779a3b9c5f3) - **oracle**: USING keyword in chr *(PR [#6637](https://github.com/tobymao/sqlglot/pull/6637) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`235fc14`](https://github.com/tobymao/sqlglot/commit/235fc14f40c422e6339da0a6b17252ab9eb18ec2) - **mysql,singlestore**: support charset *(PR [#6633](https://github.com/tobymao/sqlglot/pull/6633) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`b0afbac`](https://github.com/tobymao/sqlglot/commit/b0afbaca100e73d094f247371fff13b5a4b5290a) - **exasol**: fix TO_CHAR parsing leaking canonical datetime format tokens *(PR [#6650](https://github.com/tobymao/sqlglot/pull/6650) by [@nnamdi16](https://github.com/nnamdi16))*
- [`6ecbb01`](https://github.com/tobymao/sqlglot/commit/6ecbb01a37708347cc6595ed8f17eb1a623d37eb) - **druid**: array expression should use square brackets *(PR [#6664](https://github.com/tobymao/sqlglot/pull/6664) by [@its-felix](https://github.com/its-felix))*
- [`af50c1c`](https://github.com/tobymao/sqlglot/commit/af50c1ce464d42d4df1fac8876ae25aea556912a) - **duckdb**: Fix NOT precedence for JSON extractions *(PR [#6670](https://github.com/tobymao/sqlglot/pull/6670) by [@kyle-cheung](https://github.com/kyle-cheung))*
- [`460b3a2`](https://github.com/tobymao/sqlglot/commit/460b3a2ae62d8294c57068453b5a11e4a7e12a91) - **exasol**: Allow varlen args in exp.MD5Digest *(PR [#6685](https://github.com/tobymao/sqlglot/pull/6685) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6683](https://github.com/tobymao/sqlglot/issues/6683) opened by [@Hfuegl](https://github.com/Hfuegl)*
- [`dcdee68`](https://github.com/tobymao/sqlglot/commit/dcdee68cb1a77286232865de9df8d8a01898fcc7) - **spark**: Allow non aggregation functions in PIVOT *(PR [#6687](https://github.com/tobymao/sqlglot/pull/6687) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6684](https://github.com/tobymao/sqlglot/issues/6684) opened by [@gauravdawar-e6](https://github.com/gauravdawar-e6)*
- [`29cff1f`](https://github.com/tobymao/sqlglot/commit/29cff1fbe0011476b22e1b1442af857499f871a6) - **optimizer**: bq robust literal/non-literal binary annotation *(PR [#6688](https://github.com/tobymao/sqlglot/pull/6688) by [@geooo109](https://github.com/geooo109))*
- [`f866c83`](https://github.com/tobymao/sqlglot/commit/f866c835b84e9503b2f335a0da4b89e3426aa9e7) - **oracle**: properly parse xmlelement *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`91b3678`](https://github.com/tobymao/sqlglot/commit/91b3678c4e2380b3b344cc37643d12528c3e142b) - **resolver**: correctly resolve unnest alias shadowing for BigQuery *(PR [#6665](https://github.com/tobymao/sqlglot/pull/6665) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`2a3f1fe`](https://github.com/tobymao/sqlglot/commit/2a3f1fe854746141299303fdae36ce33688722e1) - **spark, databricks**: parse LTRIM/RTRIM *(PR [#6699](https://github.com/tobymao/sqlglot/pull/6699) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6696](https://github.com/tobymao/sqlglot/issues/6696) opened by [@avinmathew](https://github.com/avinmathew)*
- [`fb8f57a`](https://github.com/tobymao/sqlglot/commit/fb8f57ac54a4e0213941f3bd057ccb03c4e125b7) - **doris, starrocks**: Fix UPDATE statement for multi tables *(PR [#6700](https://github.com/tobymao/sqlglot/pull/6700) by [@VaggelisD](https://github.com/VaggelisD))*
- [`21f9d3c`](https://github.com/tobymao/sqlglot/commit/21f9d3ca7c6fa0d38f0f63000f904589b91c7d0a) - **optimizer**: Normalize struct field names when annotating types *(PR [#6674](https://github.com/tobymao/sqlglot/pull/6674) by [@vchan](https://github.com/vchan))*
- [`7362c23`](https://github.com/tobymao/sqlglot/commit/7362c2357eba540a12eea079e9f4212f3545c8d1) - **oracle**: interval expressions *(PR [#6648](https://github.com/tobymao/sqlglot/pull/6648) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`a84dbc2`](https://github.com/tobymao/sqlglot/commit/a84dbc2de051539ac4dfe10e0fa991c988840874) - **parser**: prevent INTERVAL from consuming GENERATED as interval unit *(PR [#6714](https://github.com/tobymao/sqlglot/pull/6714) by [@harshsinh](https://github.com/harshsinh))*
  - :arrow_lower_right: *fixes issue [#6713](https://github.com/tobymao/sqlglot/issues/6713) opened by [@harshsinh](https://github.com/harshsinh)*

### :recycle: Refactors
- [`399c80f`](https://github.com/tobymao/sqlglot/commit/399c80f2e66a1acdcd7d567e44c297db7071dc8f) - rename args for CovarSamp/Pop, stop inheriting from Binary *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`14b03ae`](https://github.com/tobymao/sqlglot/commit/14b03ae492c9cac67ae1e78b67a83427e4fe6681) - flip Getbit lsb flag to msb since more dialects match lsb *(commit by [@georgesittas](https://github.com/georgesittas))*

### :wrench: Chores
- [`e0193ea`](https://github.com/tobymao/sqlglot/commit/e0193eaeea0036bbe835c49a64a4120365525b89) - Fix make style of 6593 *(PR [#6597](https://github.com/tobymao/sqlglot/pull/6597) by [@VaggelisD](https://github.com/VaggelisD))*
- [`0534db1`](https://github.com/tobymao/sqlglot/commit/0534db11022c9cbaf91015b38039da48945aac2a) - Fix integration test failing with empty PR description *(PR [#6598](https://github.com/tobymao/sqlglot/pull/6598) by [@VaggelisD](https://github.com/VaggelisD))*
- [`c523e2a`](https://github.com/tobymao/sqlglot/commit/c523e2a4ee3b347eacf6f4f9a3629b649e902f47) - Follow up of 6551 *(PR [#6599](https://github.com/tobymao/sqlglot/pull/6599) by [@VaggelisD](https://github.com/VaggelisD))*
- [`26c3c1f`](https://github.com/tobymao/sqlglot/commit/26c3c1fcea5f105432430de3d1e2b00627191706) - Fix integration test condition for skipping fork PRs *(PR [#6606](https://github.com/tobymao/sqlglot/pull/6606) by [@VaggelisD](https://github.com/VaggelisD))*
- [`d0965ba`](https://github.com/tobymao/sqlglot/commit/d0965baa8224f72f01a04f2d9b72399f04b6103e) - Add test for PR 6616 *(commit by [@VaggelisD](https://github.com/VaggelisD))*
- [`020fb05`](https://github.com/tobymao/sqlglot/commit/020fb05971f95ba3962d051c1ef795147ee9e19d) - refactor duckdb `ZIPF` transpilation logic *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`a4e1dec`](https://github.com/tobymao/sqlglot/commit/a4e1dec87fc854ee15789672189753cf2e4450e1) - Refactor PR 6617 *(PR [#6630](https://github.com/tobymao/sqlglot/pull/6630) by [@VaggelisD](https://github.com/VaggelisD))*
- [`7f2a74c`](https://github.com/tobymao/sqlglot/commit/7f2a74c1025ab2c9627889db174a7f6404c2d585) - refactor `RANDSTR` duckdb transpilation logic *(PR [#6631](https://github.com/tobymao/sqlglot/pull/6631) by [@georgesittas](https://github.com/georgesittas))*
- [`9a41cfc`](https://github.com/tobymao/sqlglot/commit/9a41cfcc1b57488373d7a63d17b6a0d91f90c9e8) - Refactor PR 6637 *(commit by [@VaggelisD](https://github.com/VaggelisD))*
- [`2f8ffcf`](https://github.com/tobymao/sqlglot/commit/2f8ffcfac03a09460a4603d66ee7b13affbc5ebf) - **snowflake**: Adding type annotation tests for Snowflake's STDDEV / STDDEV_SAMP, STDDEV_POP  *(PR [#6641](https://github.com/tobymao/sqlglot/pull/6641) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`d46969d`](https://github.com/tobymao/sqlglot/commit/d46969db50ff52b8657d5b33f0a106b69dbd1e2a) - **optimizer**: annotate snowflake ARRAY_APPEND and ARRAY_PREPEND *(PR [#6645](https://github.com/tobymao/sqlglot/pull/6645) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`4deaabc`](https://github.com/tobymao/sqlglot/commit/4deaabcedb823ff29174674fa3d398cb7966e219) - array_append/array_prepend tests clean up *(commit by [@geooo109](https://github.com/geooo109))*
- [`b3ea996`](https://github.com/tobymao/sqlglot/commit/b3ea99607b4947905bfb55994309c0ee3e646c62) - array_append/array_prepend databricks tests *(commit by [@geooo109](https://github.com/geooo109))*
- [`7f6b9f2`](https://github.com/tobymao/sqlglot/commit/7f6b9f2eda20509b442d28f7fc470e7a0aee63b7) - snowflake remove aead arg gen for DECRYPT *(commit by [@geooo109](https://github.com/geooo109))*
- [`1fdcd63`](https://github.com/tobymao/sqlglot/commit/1fdcd6389587da95dbda34227ec688181055dcf9) - Fix onboarding md paragraph *(commit by [@VaggelisD](https://github.com/VaggelisD))*
- [`5d76a45`](https://github.com/tobymao/sqlglot/commit/5d76a45ff71feb19eee4b294f2c128e30976cb5b) - Follow up 6677 *(commit by [@VaggelisD](https://github.com/VaggelisD))*
- [`8d49255`](https://github.com/tobymao/sqlglot/commit/8d492558ff18b6af53a1aaea47cc0a863fbfe482) - Remove incorrect test of PR6655 *(commit by [@VaggelisD](https://github.com/VaggelisD))*
- [`94e6fe0`](https://github.com/tobymao/sqlglot/commit/94e6fe03752500ddeace317081dc758d36c78c1f) - Follow up of 6693 *(PR [#6698](https://github.com/tobymao/sqlglot/pull/6698) by [@VaggelisD](https://github.com/VaggelisD))*
- [`dd4d55a`](https://github.com/tobymao/sqlglot/commit/dd4d55af58a7602a1924f6b1f9a93f58636f172c) - _annotate_by_args UNKNOWN *(PR [#6703](https://github.com/tobymao/sqlglot/pull/6703) by [@geooo109](https://github.com/geooo109))*
- [`2ecfc27`](https://github.com/tobymao/sqlglot/commit/2ecfc27daf3570bca442797e0b4f4dc4e5363dd6) - Follow up 6648 *(PR [#6716](https://github.com/tobymao/sqlglot/pull/6716) by [@VaggelisD](https://github.com/VaggelisD))*
- [`bbaba5f`](https://github.com/tobymao/sqlglot/commit/bbaba5fd7d0111947035534168593a5a3ee6839a) - **optimizer**: annotate type for snowflake ARRAY_CAT *(PR [#6721](https://github.com/tobymao/sqlglot/pull/6721) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`4968ccd`](https://github.com/tobymao/sqlglot/commit/4968ccd1d74d58dace3793d4dbf7a0bff22d3300) - add deployment instructions in README *(PR [#6722](https://github.com/tobymao/sqlglot/pull/6722) by [@georgesittas](https://github.com/georgesittas))*
- [`2893ac3`](https://github.com/tobymao/sqlglot/commit/2893ac399d24846482b45fd79e99b90f5ef2cca6) - **optimizer**: Remove duplicate INITCAP annotation from Snowflake *(commit by [@VaggelisD](https://github.com/VaggelisD))*
- [`33b8a5d`](https://github.com/tobymao/sqlglot/commit/33b8a5d25bf49791fb95ec20132ab6ff0bb885e0) - bump sqlglotrs to 0.11.0 *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v28.5.0] - 2025-12-17
### :boom: BREAKING CHANGES
- due to [`4dfc810`](https://github.com/tobymao/sqlglot/commit/4dfc810f45d5a617ada2ba4ed57002549c8d1853) - support transpilation of BOOLNOT from snowflake to duckdb *(PR [#6577](https://github.com/tobymao/sqlglot/pull/6577) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation of BOOLNOT from snowflake to duckdb (#6577)

- due to [`b857185`](https://github.com/tobymao/sqlglot/commit/b8571850ca55802671484d118560a7b90e893c39) - remove Sysdate in favor of CurrentTimestamp with sysdate arg *(PR [#6584](https://github.com/tobymao/sqlglot/pull/6584) by [@georgesittas](https://github.com/georgesittas))*:

  remove Sysdate in favor of CurrentTimestamp with sysdate arg (#6584)

- due to [`bf217d6`](https://github.com/tobymao/sqlglot/commit/bf217d69f92efcbce5b69d637976e915ca63998d) - make `JSONArrayAgg` an `AggFunc` *(PR [#6585](https://github.com/tobymao/sqlglot/pull/6585) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  make `JSONArrayAgg` an `AggFunc` (#6585)

- due to [`604efe5`](https://github.com/tobymao/sqlglot/commit/604efe5cf5812d0b1dd9d625ed278907d0d7fb8f) - Type annotation fixes for TO_TIMESTAMP* *(PR [#6557](https://github.com/tobymao/sqlglot/pull/6557) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Type annotation fixes for TO_TIMESTAMP* (#6557)


### :sparkles: New Features
- [`4dfc810`](https://github.com/tobymao/sqlglot/commit/4dfc810f45d5a617ada2ba4ed57002549c8d1853) - **snowflake**: support transpilation of BOOLNOT from snowflake to duckdb *(PR [#6577](https://github.com/tobymao/sqlglot/pull/6577) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`7077981`](https://github.com/tobymao/sqlglot/commit/707798166c1b45e633bd0e8d02d1c0146598b03a) - **snowflake**: Transpilation of Snowflake MONTHS_BETWEEN to DuckDB *(PR [#6561](https://github.com/tobymao/sqlglot/pull/6561) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`604efe5`](https://github.com/tobymao/sqlglot/commit/604efe5cf5812d0b1dd9d625ed278907d0d7fb8f) - **snowflake**: Type annotation fixes for TO_TIMESTAMP* *(PR [#6557](https://github.com/tobymao/sqlglot/pull/6557) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`3567880`](https://github.com/tobymao/sqlglot/commit/35678808dafb37c5d37c806682e6af9b6351bced) - add tokens to functions *(commit by [@tobymao](https://github.com/tobymao))*

### :bug: Bug Fixes
- [`b857185`](https://github.com/tobymao/sqlglot/commit/b8571850ca55802671484d118560a7b90e893c39) - **snowflake**: remove Sysdate in favor of CurrentTimestamp with sysdate arg *(PR [#6584](https://github.com/tobymao/sqlglot/pull/6584) by [@georgesittas](https://github.com/georgesittas))*
- [`bf217d6`](https://github.com/tobymao/sqlglot/commit/bf217d69f92efcbce5b69d637976e915ca63998d) - make `JSONArrayAgg` an `AggFunc` *(PR [#6585](https://github.com/tobymao/sqlglot/pull/6585) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`48f5e99`](https://github.com/tobymao/sqlglot/commit/48f5e999d3d3f6ad51c30e7a33a3a574d0e50d2b) - **duckdb**: preserve l/r-trim syntax *(PR [#6588](https://github.com/tobymao/sqlglot/pull/6588) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6587](https://github.com/tobymao/sqlglot/issues/6587) opened by [@baruchoxman](https://github.com/baruchoxman)*

### :wrench: Chores
- [`ea0263a`](https://github.com/tobymao/sqlglot/commit/ea0263aa555591b03b06a4b6dee093fe42b545f9) - Skip integration tests GA for external contributors & fix `git diff` *(PR [#6582](https://github.com/tobymao/sqlglot/pull/6582) by [@VaggelisD](https://github.com/VaggelisD))*


## [v28.4.1] - 2025-12-16
### :boom: BREAKING CHANGES
- due to [`cfc9346`](https://github.com/tobymao/sqlglot/commit/cfc9346ba0477523d3de8f923d83fd09814b22ac) - bump sqlglotrs to 0.10.0 *(commit by [@tobymao](https://github.com/tobymao))*:

  bump sqlglotrs to 0.10.0


### :wrench: Chores
- [`cfc9346`](https://github.com/tobymao/sqlglot/commit/cfc9346ba0477523d3de8f923d83fd09814b22ac) - bump sqlglotrs to 0.10.0 *(commit by [@tobymao](https://github.com/tobymao))*


## [v28.4.0] - 2025-12-16
### :boom: BREAKING CHANGES
- due to [`938f4b6`](https://github.com/tobymao/sqlglot/commit/938f4b6ebc1c0d26bd3c1400883978c79a435189) - annotate type for LAST_DAY *(PR [#5528](https://github.com/tobymao/sqlglot/pull/5528) by [@geooo109](https://github.com/geooo109))*:

  annotate type for LAST_DAY (#5528)

- due to [`7d12dac`](https://github.com/tobymao/sqlglot/commit/7d12dac613ba5119334408f2c52cb270067156d9) - annotate type for bigquery GENERATE_TIMESTAMP_ARRAY *(PR [#5529](https://github.com/tobymao/sqlglot/pull/5529) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery GENERATE_TIMESTAMP_ARRAY (#5529)

- due to [`d50ebe2`](https://github.com/tobymao/sqlglot/commit/d50ebe286dd8e2836b9eb2a3406f15976db3aa05) - annotate type for bigquery TIME_TRUNC *(PR [#5530](https://github.com/tobymao/sqlglot/pull/5530) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery TIME_TRUNC (#5530)

- due to [`29748be`](https://github.com/tobymao/sqlglot/commit/29748be7dfc10edc9f29665c98327883dd25c13d) - annotate type for bigquery TIME *(PR [#5531](https://github.com/tobymao/sqlglot/pull/5531) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery TIME (#5531)

- due to [`7003b3f`](https://github.com/tobymao/sqlglot/commit/7003b3fa39cd455e3643066364696708d1ac4f38) - parse and annotate type for bigquery DATE_FROM_UNIX_DATE *(PR [#5532](https://github.com/tobymao/sqlglot/pull/5532) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery DATE_FROM_UNIX_DATE (#5532)

- due to [`a276ca6`](https://github.com/tobymao/sqlglot/commit/a276ca6fd5f9d47fa8c90fcfa19f9864e7a28f8f) - parse and annotate type for bigquery JUSTIFY funcs *(PR [#5534](https://github.com/tobymao/sqlglot/pull/5534) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery JUSTIFY funcs (#5534)

- due to [`374178e`](https://github.com/tobymao/sqlglot/commit/374178e22fe8d2d2275b65fe08e27ef66c611220) - parse and annotate type for bigquery UNIX_MICROS and UNIX_MILLIS *(PR [#5535](https://github.com/tobymao/sqlglot/pull/5535) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery UNIX_MICROS and UNIX_MILLIS (#5535)

- due to [`1d8d1ab`](https://github.com/tobymao/sqlglot/commit/1d8d1abe459053a135a46525d0a13bb861220927) - annotate type for bigquery DATE_TRUNC *(PR [#5540](https://github.com/tobymao/sqlglot/pull/5540) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery DATE_TRUNC (#5540)

- due to [`306ba65`](https://github.com/tobymao/sqlglot/commit/306ba6531839ea2823f5165de7bde01d17560845) - annotate type for bigquery TIMESTAMP_TRUNC *(PR [#5541](https://github.com/tobymao/sqlglot/pull/5541) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery TIMESTAMP_TRUNC (#5541)

- due to [`d799c5a`](https://github.com/tobymao/sqlglot/commit/d799c5af23010a67c29edb6d45a40fb24903e1a3) - preserve projection names when merging subqueries *(commit by [@snovik75](https://github.com/snovik75))*:

  preserve projection names when merging subqueries

- due to [`8130bd4`](https://github.com/tobymao/sqlglot/commit/8130bd40815803a6781ee8f20fccd30987516192) - WEEKDAY of WEEK as VAR *(PR [#5552](https://github.com/tobymao/sqlglot/pull/5552) by [@geooo109](https://github.com/geooo109))*:

  WEEKDAY of WEEK as VAR (#5552)

- due to [`f3ffe19`](https://github.com/tobymao/sqlglot/commit/f3ffe19ec01533c5f27b9d3a7b6704b83c005118) - annotate type for bigquery format_time *(PR [#5559](https://github.com/tobymao/sqlglot/pull/5559) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery format_time (#5559)

- due to [`6872b43`](https://github.com/tobymao/sqlglot/commit/6872b43ba17a39137172fd2fa9f0d059ce595ef9) - use dialect in DataType.build fixes [#5560](https://github.com/tobymao/sqlglot/pull/5560) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  use dialect in DataType.build fixes #5560

- due to [`3ab3690`](https://github.com/tobymao/sqlglot/commit/3ab369096313b418699b7942b1c513c0c66a5331) - parse and annotate type for bigquery PARSE_DATETIME *(PR [#5558](https://github.com/tobymao/sqlglot/pull/5558) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery PARSE_DATETIME (#5558)

- due to [`e5da951`](https://github.com/tobymao/sqlglot/commit/e5da951542eb55691bc43fbbfbec4a30100de038) - parse and annotate type for bigquery PARSE_TIME *(PR [#5561](https://github.com/tobymao/sqlglot/pull/5561) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery PARSE_TIME (#5561)

- due to [`798e213`](https://github.com/tobymao/sqlglot/commit/798e213fd10c3b61afbd8cef621546de65fa6f26) - improve transpilability of ANY_VALUE closes [#5563](https://github.com/tobymao/sqlglot/pull/5563) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  improve transpilability of ANY_VALUE closes #5563

- due to [`8c0cb76`](https://github.com/tobymao/sqlglot/commit/8c0cb764fd825062fb7334032b8eeffbc39627d5) - more robust CREATE SEQUENCE *(PR [#5566](https://github.com/tobymao/sqlglot/pull/5566) by [@geooo109](https://github.com/geooo109))*:

  more robust CREATE SEQUENCE (#5566)

- due to [`c7041c7`](https://github.com/tobymao/sqlglot/commit/c7041c71250b17192c2f25fb8f33407324d332c2) - parse and annotate type for bigquery BYTE_LENGHT *(PR [#5568](https://github.com/tobymao/sqlglot/pull/5568) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery BYTE_LENGHT (#5568)

- due to [`a6c61c3`](https://github.com/tobymao/sqlglot/commit/a6c61c34f1e168c97dd5c2b8ec071372ba593992) - parse and annotate type for bigquery CODE_POINTS_TO_STRING *(PR [#5569](https://github.com/tobymao/sqlglot/pull/5569) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery CODE_POINTS_TO_STRING (#5569)

- due to [`51e0335`](https://github.com/tobymao/sqlglot/commit/51e0335377fe2bc2e2a94a623475791e9dd19fb9) - parse and annotate type for bigquery REVERSE *(PR [#5571](https://github.com/tobymao/sqlglot/pull/5571) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery REVERSE (#5571)

- due to [`2a33339`](https://github.com/tobymao/sqlglot/commit/2a333395cde71936df911488afcff92cae735e11) - annotate type for bigquery REPLACE *(PR [#5572](https://github.com/tobymao/sqlglot/pull/5572) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery REPLACE (#5572)

- due to [`1e6f813`](https://github.com/tobymao/sqlglot/commit/1e6f81343de641e588f1a05ce7dc01bed72bd849) - annotate type for bigquery REGEXP_EXTRACT_ALL *(PR [#5573](https://github.com/tobymao/sqlglot/pull/5573) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery REGEXP_EXTRACT_ALL (#5573)

- due to [`d0d62ed`](https://github.com/tobymao/sqlglot/commit/d0d62ede6320b3fd0eee04b7073f5708676dc58c) - support `TO_CHAR` with numeric inputs *(PR [#5570](https://github.com/tobymao/sqlglot/pull/5570) by [@jasonthomassql](https://github.com/jasonthomassql))*:

  support `TO_CHAR` with numeric inputs (#5570)

- due to [`7928985`](https://github.com/tobymao/sqlglot/commit/7928985a655c3d0244bc9175a37f502b19a5c5f0) - allow dashes in JSONPath keys *(PR [#5574](https://github.com/tobymao/sqlglot/pull/5574) by [@georgesittas](https://github.com/georgesittas))*:

  allow dashes in JSONPath keys (#5574)

- due to [`eb09e6e`](https://github.com/tobymao/sqlglot/commit/eb09e6e32491a05846488de7b72b1dca0e0a2669) - parse and annotate type for bigquery TRANSLATE *(PR [#5575](https://github.com/tobymao/sqlglot/pull/5575) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery TRANSLATE (#5575)

- due to [`f9a522b`](https://github.com/tobymao/sqlglot/commit/f9a522b26cd5d643b8b18fa64d70f2a3f0ff2d2c) - parse and annotate type for bigquery SOUNDEX *(PR [#5576](https://github.com/tobymao/sqlglot/pull/5576) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery SOUNDEX (#5576)

- due to [`51da41b`](https://github.com/tobymao/sqlglot/commit/51da41b90ce421b154e45add28353ac044640a1c) - annotate type for bigquery MD5 *(PR [#5577](https://github.com/tobymao/sqlglot/pull/5577) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery MD5 (#5577)

- due to [`bcf302f`](https://github.com/tobymao/sqlglot/commit/bcf302ff6ad2d0adfc29f708a8b53b5c0e547619) - annotate type for bigquery MIN/MAX BY *(PR [#5579](https://github.com/tobymao/sqlglot/pull/5579) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery MIN/MAX BY (#5579)

- due to [`c501d9e`](https://github.com/tobymao/sqlglot/commit/c501d9e6f58e4880e4d23f21f53f72dcb5fdaa8c) - parse and annotate type for bigquery GROUPING *(PR [#5581](https://github.com/tobymao/sqlglot/pull/5581) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery GROUPING (#5581)

- due to [`7b180bd`](https://github.com/tobymao/sqlglot/commit/7b180bdc3da9e39946c22970bd2523f7d8beaf29) - raise if query modifier is specified multiple times *(PR [#5608](https://github.com/tobymao/sqlglot/pull/5608) by [@georgesittas](https://github.com/georgesittas))*:

  raise if query modifier is specified multiple times (#5608)

- due to [`36602a2`](https://github.com/tobymao/sqlglot/commit/36602a2ecc9ffca98e89044d23e40f33c6ed71e4) - parse LIST_FILTER into ArrayFilter closes [#5633](https://github.com/tobymao/sqlglot/pull/5633) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  parse LIST_FILTER into ArrayFilter closes #5633

- due to [`0188d21`](https://github.com/tobymao/sqlglot/commit/0188d21d443c991a528eb9d220459890b7dca477) - parse LIST_TRANSFORM into Transform closes [#5634](https://github.com/tobymao/sqlglot/pull/5634) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  parse LIST_TRANSFORM into Transform closes #5634

- due to [`3ab1d44`](https://github.com/tobymao/sqlglot/commit/3ab1d4487279cab3be2d3764e51516c6db21629d) - Wrap CONCAT items with COALESCE less aggressively *(PR [#5641](https://github.com/tobymao/sqlglot/pull/5641) by [@VaggelisD](https://github.com/VaggelisD))*:

  Wrap CONCAT items with COALESCE less aggressively (#5641)

- due to [`af0b299`](https://github.com/tobymao/sqlglot/commit/af0b299561914953b30ab36004e53dcb92d39e1c) - Qualify columns generated by exp.Aliases *(PR [#5647](https://github.com/tobymao/sqlglot/pull/5647) by [@VaggelisD](https://github.com/VaggelisD))*:

  Qualify columns generated by exp.Aliases (#5647)

- due to [`53aa8fe`](https://github.com/tobymao/sqlglot/commit/53aa8fe7f188012f765066f32c4179035fff036d) - support alter table with check closes [#5649](https://github.com/tobymao/sqlglot/pull/5649) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  support alter table with check closes #5649

- due to [`1a60a5a`](https://github.com/tobymao/sqlglot/commit/1a60a5a845c7431d7d3d7ccb71119699316f4b41) - Added parsing/generation of JSON_ARRAY_CONTAINS function *(PR [#5661](https://github.com/tobymao/sqlglot/pull/5661) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*:

  Added parsing/generation of JSON_ARRAY_CONTAINS function (#5661)

- due to [`e0db0a9`](https://github.com/tobymao/sqlglot/commit/e0db0a95d3cb7614242dbd1b439d408e7e7bd475) - add parse and annotate type for bigquery FARM_FINGERPRINT *(PR [#5667](https://github.com/tobymao/sqlglot/pull/5667) by [@geooo109](https://github.com/geooo109))*:

  add parse and annotate type for bigquery FARM_FINGERPRINT (#5667)

- due to [`56588c7`](https://github.com/tobymao/sqlglot/commit/56588c7e22b4db4f0e44696a460483ca1e549163) - Add support for vector_search function. Move predict to BigQuery dialect. *(PR [#5660](https://github.com/tobymao/sqlglot/pull/5660) by [@rloredo](https://github.com/rloredo))*:

  Add support for vector_search function. Move predict to BigQuery dialect. (#5660)

- due to [`a688a0f`](https://github.com/tobymao/sqlglot/commit/a688a0f0d70f87139e531d1419b338b695bec384) - parse and annotate type for bigquery APPROX_TOP_COUNT *(PR [#5670](https://github.com/tobymao/sqlglot/pull/5670) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery APPROX_TOP_COUNT (#5670)

- due to [`3c93fcc`](https://github.com/tobymao/sqlglot/commit/3c93fcce96ec82e78753f6c9dd5fb0e730a82058) - parse and annotate type for bigquery APPROX_TOP_SUM *(PR [#5675](https://github.com/tobymao/sqlglot/pull/5675) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery APPROX_TOP_SUM (#5675)

- due to [`741d45a`](https://github.com/tobymao/sqlglot/commit/741d45a0ca7c1bad67da4393cd10cc9cfa49ea68) - parse and annotate type for bigquery FROM/TO_BASE32 *(PR [#5676](https://github.com/tobymao/sqlglot/pull/5676) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery FROM/TO_BASE32 (#5676)

- due to [`9ae045c`](https://github.com/tobymao/sqlglot/commit/9ae045c0405e43b148e3b9261825288ebf09100c) - parse and annotate type for bigquery FROM_HEX *(PR [#5679](https://github.com/tobymao/sqlglot/pull/5679) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery FROM_HEX (#5679)

- due to [`5a22a25`](https://github.com/tobymao/sqlglot/commit/5a22a254143978989027f6e7f6163019a34f112a) - annotate type for bigquery TO_HEX *(PR [#5680](https://github.com/tobymao/sqlglot/pull/5680) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery TO_HEX (#5680)

- due to [`5c1eb2d`](https://github.com/tobymao/sqlglot/commit/5c1eb2df5dd3dcc6ed2c8204cec56b5c3d276f87) - parse and annotate type for bq PARSE_BIG/NUMERIC *(PR [#5690](https://github.com/tobymao/sqlglot/pull/5690) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq PARSE_BIG/NUMERIC (#5690)

- due to [`311373d`](https://github.com/tobymao/sqlglot/commit/311373d22134de906d1c1cef019541e85e2f7c9f) - parse and annotate type for bq CODE_POINTS_TO_BYTES *(PR [#5686](https://github.com/tobymao/sqlglot/pull/5686) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq CODE_POINTS_TO_BYTES (#5686)

- due to [`79d9de1`](https://github.com/tobymao/sqlglot/commit/79d9de1745598f8f3ae2c82c1389dd455c946a09) - parse and annotate type for bq TO_CODE_POINTS *(PR [#5685](https://github.com/tobymao/sqlglot/pull/5685) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq TO_CODE_POINTS (#5685)

- due to [`5df3ea9`](https://github.com/tobymao/sqlglot/commit/5df3ea92f59125955124ea1883b777b489db3042) - parse and annotate type for bq SAFE_CONVERT_BYTES_TO_STRING *(PR [#5681](https://github.com/tobymao/sqlglot/pull/5681) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq SAFE_CONVERT_BYTES_TO_STRING (#5681)

- due to [`c832746`](https://github.com/tobymao/sqlglot/commit/c832746018fbc2c531d5b2a7c7f8cd5d78e511ff) - parse and annotate type for bigquery APPROX_QUANTILES *(PR [#5678](https://github.com/tobymao/sqlglot/pull/5678) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery APPROX_QUANTILES (#5678)

- due to [`99e169e`](https://github.com/tobymao/sqlglot/commit/99e169ea13d5be3712a47f6b55b98a4764a3c24d) - parse and annotate type for bq BOOL *(PR [#5697](https://github.com/tobymao/sqlglot/pull/5697) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq BOOL (#5697)

- due to [`3f31770`](https://github.com/tobymao/sqlglot/commit/3f31770c793f464fcac1ce2b8dfa03d4b7f0231c) - parse and annotate type for bq FLOAT64 *(PR [#5700](https://github.com/tobymao/sqlglot/pull/5700) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq FLOAT64 (#5700)

- due to [`de2fe15`](https://github.com/tobymao/sqlglot/commit/de2fe1503b5bb003431d1f0c7b9ae87932a6cc1c) - annotate type for bq CONTAINS_SUBSTR *(PR [#5705](https://github.com/tobymao/sqlglot/pull/5705) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq CONTAINS_SUBSTR (#5705)

- due to [`770888f`](https://github.com/tobymao/sqlglot/commit/770888f4e9a9061329e3c416f968f7dd9639fb81) - annotate type for bq NORMALIZE *(PR [#5711](https://github.com/tobymao/sqlglot/pull/5711) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq NORMALIZE (#5711)

- due to [`506033f`](https://github.com/tobymao/sqlglot/commit/506033f299f7a4c28f6efd8bf715be5dcf73e929) - parse and annotate type for bq NORMALIZE_AND_CASEFOLD *(PR [#5712](https://github.com/tobymao/sqlglot/pull/5712) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq NORMALIZE_AND_CASEFOLD (#5712)

- due to [`848aea1`](https://github.com/tobymao/sqlglot/commit/848aea1dbaaeb580b633796dcca06c28314b9c3e) - parse and annotate type for bq OCTET_LENGTH *(PR [#5713](https://github.com/tobymao/sqlglot/pull/5713) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq OCTET_LENGTH (#5713)

- due to [`727bf83`](https://github.com/tobymao/sqlglot/commit/727bf8378f232188d35834d980b035552999ea3b) - add support for REVOKE DDL *(PR [#5703](https://github.com/tobymao/sqlglot/pull/5703) by [@newtonapple](https://github.com/newtonapple))*:

  add support for REVOKE DDL (#5703)

- due to [`baffd2c`](https://github.com/tobymao/sqlglot/commit/baffd2c0be9657683781f3f8831c47e32dbf68bb) - parse and annotate type for bq REGEXP_INSTR *(PR [#5710](https://github.com/tobymao/sqlglot/pull/5710) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq REGEXP_INSTR (#5710)

- due to [`b79eb19`](https://github.com/tobymao/sqlglot/commit/b79eb198cc21203efa82128b357d435338e9133d) - annotate type for bq ROW_NUMBER *(PR [#5716](https://github.com/tobymao/sqlglot/pull/5716) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq ROW_NUMBER (#5716)

- due to [`f709bef`](https://github.com/tobymao/sqlglot/commit/f709bef3af7cd0daa25fe3d58b1753c3e65720ef) - annotate type for bq FIRST_VALUE *(PR [#5718](https://github.com/tobymao/sqlglot/pull/5718) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq FIRST_VALUE (#5718)

- due to [`15a9061`](https://github.com/tobymao/sqlglot/commit/15a906170e5d5cdaa207ec7607edfdd7d4a8b774) - annotate type for bq PERCENTILE_DISC *(PR [#5722](https://github.com/tobymao/sqlglot/pull/5722) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq PERCENTILE_DISC (#5722)

- due to [`7d49609`](https://github.com/tobymao/sqlglot/commit/7d4960963f0ef70b96f5b969bb008d2742e833ea) - annotate type for bq NTH_VALUE *(PR [#5720](https://github.com/tobymao/sqlglot/pull/5720) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq NTH_VALUE (#5720)

- due to [`d41acf1`](https://github.com/tobymao/sqlglot/commit/d41acf11221bee30a5ae089cbac9b158ed3dd515) - annotate type for bq LEAD *(PR [#5719](https://github.com/tobymao/sqlglot/pull/5719) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq LEAD (#5719)

- due to [`ff12130`](https://github.com/tobymao/sqlglot/commit/ff12130c23a215917f20fda7d50322f1cb7de599) - annotate type for bq PERNCENTILE_CONT *(PR [#5729](https://github.com/tobymao/sqlglot/pull/5729) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq PERNCENTILE_CONT (#5729)

- due to [`fdb8a0a`](https://github.com/tobymao/sqlglot/commit/fdb8a0a6d0d74194255f313bd934db7fc1ce0d3f) - parse and annotate type for bq FORMAT *(PR [#5715](https://github.com/tobymao/sqlglot/pull/5715) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq FORMAT (#5715)

- due to [`012bdd3`](https://github.com/tobymao/sqlglot/commit/012bdd3c8aeff180f85354ffd403fc1aa5815dcf) - parse and annotate type for bq CUME_DIST *(PR [#5735](https://github.com/tobymao/sqlglot/pull/5735) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq CUME_DIST (#5735)

- due to [`b99eaeb`](https://github.com/tobymao/sqlglot/commit/b99eaeb0c6eb3dc613e76d205e02632bd6af353b) - parse and annotate type for bq DENSE_RANK *(PR [#5736](https://github.com/tobymao/sqlglot/pull/5736) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq DENSE_RANK (#5736)

- due to [`bb95c73`](https://github.com/tobymao/sqlglot/commit/bb95c7312c942ef987955f01e060604d60e32e83) - parse and annotate type for bq RANK *(PR [#5738](https://github.com/tobymao/sqlglot/pull/5738) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq RANK (#5738)

- due to [`8713c08`](https://github.com/tobymao/sqlglot/commit/8713c082b0aa8454a5773fc2a85e08a132dc6ce3) - parse and annotate type for bq PERCENT_RANK *(PR [#5739](https://github.com/tobymao/sqlglot/pull/5739) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq PERCENT_RANK (#5739)

- due to [`9ce4e31`](https://github.com/tobymao/sqlglot/commit/9ce4e31aecbde6ea1f227a7166c0f3dc9e302a66) - annotate type for bq JSON_OBJECT *(PR [#5740](https://github.com/tobymao/sqlglot/pull/5740) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq JSON_OBJECT (#5740)

- due to [`d35ec6e`](https://github.com/tobymao/sqlglot/commit/d35ec6e37e21cf3cec848ed55bd73128c4633cd2) - annotate type for bq JSON_QUERY/JSON_QUERY_ARRAY *(PR [#5741](https://github.com/tobymao/sqlglot/pull/5741) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq JSON_QUERY/JSON_QUERY_ARRAY (#5741)

- due to [`4753642`](https://github.com/tobymao/sqlglot/commit/4753642cfcfb1f192ec4d21a492737b27affef09) - annotate type for bq JSON_EXTRACT_SCALAR *(commit by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq JSON_EXTRACT_SCALAR

- due to [`113a530`](https://github.com/tobymao/sqlglot/commit/113a5308d050fd5ceacab4c6188e5eea5dd740b1) - parse and annotate type for bq JSON_ARRAY_APPEND *(PR [#5747](https://github.com/tobymao/sqlglot/pull/5747) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_ARRAY_APPEND (#5747)

- due to [`268e2c6`](https://github.com/tobymao/sqlglot/commit/268e2c694d1eb99f1fe64477bc38ed4946bf1c32) - parse and annotate type for bq JSON_ARRAY_INSERT *(PR [#5748](https://github.com/tobymao/sqlglot/pull/5748) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_ARRAY_INSERT (#5748)

- due to [`455ec1f`](https://github.com/tobymao/sqlglot/commit/455ec1f4f8aecb5435fa4cb2912bfc21db8dd44d) - parse and annotate type for bq JSON_KEYS *(PR [#5749](https://github.com/tobymao/sqlglot/pull/5749) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_KEYS (#5749)

- due to [`59895fa`](https://github.com/tobymao/sqlglot/commit/59895faa23ebe1b27938c37a7b39df87de609844) - parse and annotate type for bq JSON_REMOVE *(PR [#5750](https://github.com/tobymao/sqlglot/pull/5750) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_REMOVE (#5750)

- due to [`06d7df7`](https://github.com/tobymao/sqlglot/commit/06d7df7a05f2824cabf48e8d1e8a4ebca8fda496) - parse and annotate type for bq JSON_SET *(PR [#5751](https://github.com/tobymao/sqlglot/pull/5751) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_SET (#5751)

- due to [`e72b341`](https://github.com/tobymao/sqlglot/commit/e72b3419c8a367caa0e5e80030979cd94e87a40d) - parse and annotate type for bq JSON_STRIP_NULLS *(PR [#5753](https://github.com/tobymao/sqlglot/pull/5753) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_STRIP_NULLS (#5753)

- due to [`5de61a7`](https://github.com/tobymao/sqlglot/commit/5de61a7ab850d4e68fde4d76ee396d30d7bdef33) - parse and annotate type for bq JSON_EXTRACT_STRING_ARRAY *(PR [#5758](https://github.com/tobymao/sqlglot/pull/5758) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_EXTRACT_STRING_ARRAY (#5758)

- due to [`36c9393`](https://github.com/tobymao/sqlglot/commit/36c93939575a19bd611269719c39d3d216be8cde) - parse and annotate type for bq JSON LAX funcs *(PR [#5760](https://github.com/tobymao/sqlglot/pull/5760) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON LAX funcs (#5760)

- due to [`88862b5`](https://github.com/tobymao/sqlglot/commit/88862b56bc29c8a600b4d0e4693d5846d3a577ff) - annotate type for bq TO_JSON_STRING *(PR [#5762](https://github.com/tobymao/sqlglot/pull/5762) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq TO_JSON_STRING (#5762)

- due to [`1c551d5`](https://github.com/tobymao/sqlglot/commit/1c551d5ed3315e314013c1f063deabd9d8613e5d) - parse and annotate type for bq TO_JSON *(PR [#5768](https://github.com/tobymao/sqlglot/pull/5768) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq TO_JSON (#5768)

- due to [`1707f2d`](https://github.com/tobymao/sqlglot/commit/1707f2d7f9d3b58e8c216db638f8e572f9fe6f13) - annotate type for ABS *(PR [#5770](https://github.com/tobymao/sqlglot/pull/5770) by [@geooo109](https://github.com/geooo109))*:

  annotate type for ABS (#5770)

- due to [`69acc51`](https://github.com/tobymao/sqlglot/commit/69acc5142b2d4f0b30832c350aa49f16d1adabef) - annotate type for bq IS_INF, IS_NAN *(PR [#5771](https://github.com/tobymao/sqlglot/pull/5771) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq IS_INF, IS_NAN (#5771)

- due to [`0da2076`](https://github.com/tobymao/sqlglot/commit/0da207652331920416b29e2cc67bdc3c3f964466) - annotate type for bq CBRT *(PR [#5772](https://github.com/tobymao/sqlglot/pull/5772) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq CBRT (#5772)

- due to [`a4968cb`](https://github.com/tobymao/sqlglot/commit/a4968cb5693670c1a2e9cd2c86404dd90fd76160) - annotate type for bq RAND *(PR [#5774](https://github.com/tobymao/sqlglot/pull/5774) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq RAND (#5774)

- due to [`3e63350`](https://github.com/tobymao/sqlglot/commit/3e63350bd1d58b510cecd1a573d27be3fd2565ce) - parse and annotate type for bq ACOS *(PR [#5776](https://github.com/tobymao/sqlglot/pull/5776) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq ACOS (#5776)

- due to [`2be9d01`](https://github.com/tobymao/sqlglot/commit/2be9d01830c778186dc274c94c6db0dd6c4116d1) - parse and annotate type for bq ACOSH *(PR [#5779](https://github.com/tobymao/sqlglot/pull/5779) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq ACOSH (#5779)

- due to [`b77d3da`](https://github.com/tobymao/sqlglot/commit/b77d3da8f2548858d2b9d8590fcde83e1ec62b8a) - remove `"EXCLUDE" -> TokenType.EXCEPT` in DuckDB, Snowflake *(PR [#5766](https://github.com/tobymao/sqlglot/pull/5766) by [@treysp](https://github.com/treysp))*:

  remove `"EXCLUDE" -> TokenType.EXCEPT` in DuckDB, Snowflake (#5766)

- due to [`7da2f31`](https://github.com/tobymao/sqlglot/commit/7da2f31d6613f16585e98c3fa1f592c617ae40c9) - parse and annotate type for bq ASIN/H *(PR [#5783](https://github.com/tobymao/sqlglot/pull/5783) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq ASIN/H (#5783)

- due to [`341ea83`](https://github.com/tobymao/sqlglot/commit/341ea83a07c707fdbf565b8d9ef4b9b6341ed1d5) - parse and annotate type for bq ATAN/H/2 *(PR [#5784](https://github.com/tobymao/sqlglot/pull/5784) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq ATAN/H/2 (#5784)

- due to [`aa360cb`](https://github.com/tobymao/sqlglot/commit/aa360cb0e204aa056557ff8b15aa2d4f678430e6) - use regexp_like as it exists *(PR [#5781](https://github.com/tobymao/sqlglot/pull/5781) by [@jasonthomassql](https://github.com/jasonthomassql))*:

  use regexp_like as it exists (#5781)

- due to [`c2a1ad4`](https://github.com/tobymao/sqlglot/commit/c2a1ad4050771401a5b26bcadd90060e4527fbff) - parse and annotate type for bq COT/H *(PR [#5786](https://github.com/tobymao/sqlglot/pull/5786) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq COT/H (#5786)

- due to [`316ae91`](https://github.com/tobymao/sqlglot/commit/316ae913d8b1a63f3071ebb1b826328108d74cef) - Added handling of UTC_DATE and exp.CurrentDate *(PR [#5785](https://github.com/tobymao/sqlglot/pull/5785) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*:

  Added handling of UTC_DATE and exp.CurrentDate (#5785)

- due to [`2c6d237`](https://github.com/tobymao/sqlglot/commit/2c6d23742ea9fcc2b9c784315d3d5364e360fea5) - parse and annotate type for bq CSC/H *(PR [#5787](https://github.com/tobymao/sqlglot/pull/5787) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq CSC/H (#5787)

- due to [`8a35076`](https://github.com/tobymao/sqlglot/commit/8a350763c2337f6910a5f0e19af387ba488fcb70) - parse and annotate type for bq SEC/H *(PR [#5788](https://github.com/tobymao/sqlglot/pull/5788) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq SEC/H (#5788)

- due to [`79901cb`](https://github.com/tobymao/sqlglot/commit/79901cb506737ae1932fa44a705858d2597ee587) - parse and annotate type for bq SIN\H *(PR [#5790](https://github.com/tobymao/sqlglot/pull/5790) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq SIN\H (#5790)

- due to [`74fb547`](https://github.com/tobymao/sqlglot/commit/74fb5476def1b389da425885db56bd6592fd7f78) - parse and annotate type for bq RANGE_BUCKET *(PR [#5793](https://github.com/tobymao/sqlglot/pull/5793) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq RANGE_BUCKET (#5793)

- due to [`eca65e8`](https://github.com/tobymao/sqlglot/commit/eca65e8b79f65850b014a4cb7913ba4a5861dbe9) - parse and annotate type for bq COSINE/EUCLIDEAN_DISTANCE *(PR [#5792](https://github.com/tobymao/sqlglot/pull/5792) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq COSINE/EUCLIDEAN_DISTANCE (#5792)

- due to [`a180d3f`](https://github.com/tobymao/sqlglot/commit/a180d3f2f9f3938611027269028c03274aa1889c) - parse and annotate type for bq SAFE math funcs *(PR [#5797](https://github.com/tobymao/sqlglot/pull/5797) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq SAFE math funcs (#5797)

- due to [`fc7ad7a`](https://github.com/tobymao/sqlglot/commit/fc7ad7a4d953424b56542eacfe1835f5789921c7) - parse ALTER SESSION  *(PR [#5734](https://github.com/tobymao/sqlglot/pull/5734) by [@tekumara](https://github.com/tekumara))*:

  parse ALTER SESSION  (#5734)

- due to [`8ec1a6c`](https://github.com/tobymao/sqlglot/commit/8ec1a6cf5a8edc2d834c713ce0fd8d87237f11ed) - annotate type for bq STRING_AGG *(PR [#5798](https://github.com/tobymao/sqlglot/pull/5798) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq STRING_AGG (#5798)

- due to [`dd97bfa`](https://github.com/tobymao/sqlglot/commit/dd97bfa1dc2f86b727c55b06b3c54b18c02e360d) - annotate type for bq DATETIME_TRUNC *(PR [#5799](https://github.com/tobymao/sqlglot/pull/5799) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq DATETIME_TRUNC (#5799)

- due to [`d3e9dda`](https://github.com/tobymao/sqlglot/commit/d3e9dda183695dd1e4a9832a6671bccc6db561a0) - annotate type for bq GENERATE_UUID *(commit by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq GENERATE_UUID

- due to [`3726b33`](https://github.com/tobymao/sqlglot/commit/3726b33bb6b4ab286617f510e96e1fbd27c429f3) - support nulls_first arg for array_sort *(PR [#5802](https://github.com/tobymao/sqlglot/pull/5802) by [@treysp](https://github.com/treysp))*:

  support nulls_first arg for array_sort (#5802)

- due to [`cf1d1e3`](https://github.com/tobymao/sqlglot/commit/cf1d1e3e0ef9e6cd1b1c6128c63ddf06c30f1339) - annotate type for snowflake's REVERSE function *(PR [#5803](https://github.com/tobymao/sqlglot/pull/5803) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for snowflake's REVERSE function (#5803)

- due to [`ad0b407`](https://github.com/tobymao/sqlglot/commit/ad0b407098e1611d4fc0e1f0916511337b9aefdb) - Mark 'BEGIN' as TokenType.BEGIN for transactions *(PR [#5826](https://github.com/tobymao/sqlglot/pull/5826) by [@VaggelisD](https://github.com/VaggelisD))*:

  Mark 'BEGIN' as TokenType.BEGIN for transactions (#5826)

- due to [`0198282`](https://github.com/tobymao/sqlglot/commit/0198282a82bbf3e81476e164718d63fd1210acdc) - : Update tests for concat string function *(PR [#5809](https://github.com/tobymao/sqlglot/pull/5809) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  : Update tests for concat string function (#5809)

- due to [`db2c430`](https://github.com/tobymao/sqlglot/commit/db2c4303237a1244070c359245c398a724df6de2) - annoate the "contains" function *(PR [#5829](https://github.com/tobymao/sqlglot/pull/5829) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  annoate the "contains" function (#5829)

- due to [`9c8a600`](https://github.com/tobymao/sqlglot/commit/9c8a6001f41816035f391d046eb9692d6f13cefc) - correct parsing of TO_VARCHAR *(PR [#5840](https://github.com/tobymao/sqlglot/pull/5840) by [@geooo109](https://github.com/geooo109))*:

  correct parsing of TO_VARCHAR (#5840)

- due to [`1e9aef1`](https://github.com/tobymao/sqlglot/commit/1e9aef1bb20f4dc5e9c03d59cb3165c235c11ce1) - convert NULL annotations to UNKNOWN *(PR [#5842](https://github.com/tobymao/sqlglot/pull/5842) by [@georgesittas](https://github.com/georgesittas))*:

  convert NULL annotations to UNKNOWN (#5842)

- due to [`44c9e70`](https://github.com/tobymao/sqlglot/commit/44c9e70bd8c9421035eb0e87e4286061ec5d2fa8) - add tests for snowflake STARTSWITH function *(PR [#5847](https://github.com/tobymao/sqlglot/pull/5847) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  add tests for snowflake STARTSWITH function (#5847)

- due to [`0779c2d`](https://github.com/tobymao/sqlglot/commit/0779c2d4e8ce0228592de6882763940783fa5e87) - support BIT_X aggregates again for duckdb, postgres *(PR [#5851](https://github.com/tobymao/sqlglot/pull/5851) by [@georgesittas](https://github.com/georgesittas))*:

  support BIT_X aggregates again for duckdb, postgres (#5851)

- due to [`c50d6e3`](https://github.com/tobymao/sqlglot/commit/c50d6e3c7b96f00d27c34a02c8e0dced21e6c373) - annotate type for snowflake LEFT, RIGHT and SUBSTRING functions *(PR [#5849](https://github.com/tobymao/sqlglot/pull/5849) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  annotate type for snowflake LEFT, RIGHT and SUBSTRING functions (#5849)

- due to [`e441e16`](https://github.com/tobymao/sqlglot/commit/e441e16991626c2da2d38bc9c3a2b408e3f773bd) - make dump/pickling non-recursive to avoid hitting stack limits *(PR [#5850](https://github.com/tobymao/sqlglot/pull/5850) by [@tobymao](https://github.com/tobymao))*:

  make dump/pickling non-recursive to avoid hitting stack limits (#5850)

- due to [`b128339`](https://github.com/tobymao/sqlglot/commit/b12833977e2a395712481cf11e293fdbd70fd4ce) - annotate and add tests for snowflake LENGTH and LOWER functions *(PR [#5856](https://github.com/tobymao/sqlglot/pull/5856) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  annotate and add tests for snowflake LENGTH and LOWER functions (#5856)

- due to [`134957a`](https://github.com/tobymao/sqlglot/commit/134957af11c55a4ab16f58d0725d6bb8ab23eb28) - annotate types for Snowflake TRIM function *(PR [#5811](https://github.com/tobymao/sqlglot/pull/5811) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake TRIM function (#5811)

- due to [`d3cd6bf`](https://github.com/tobymao/sqlglot/commit/d3cd6bf6e5fbaa490868ee3cd2cc99dd5e40a396) - Annotate and add tests for snowflake REPLACE and SPACE functions *(PR [#5871](https://github.com/tobymao/sqlglot/pull/5871) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate and add tests for snowflake REPLACE and SPACE functions (#5871)

- due to [`96ae7a3`](https://github.com/tobymao/sqlglot/commit/96ae7a3bcbf9de1932150baa0bd704d4ce05c9f7) - Annotate and add tests for snowflake REPEAT and SPLIT functions *(PR [#5875](https://github.com/tobymao/sqlglot/pull/5875) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate and add tests for snowflake REPEAT and SPLIT functions (#5875)

- due to [`f2d3bf7`](https://github.com/tobymao/sqlglot/commit/f2d3bf74e804e5a5e2ac6ca94210ba04df07e7f3) - annotate types for Snowflake UUID_STRING function *(PR [#5881](https://github.com/tobymao/sqlglot/pull/5881) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake UUID_STRING function (#5881)

- due to [`ec80ff3`](https://github.com/tobymao/sqlglot/commit/ec80ff34957c3e3f80c44175383b06cf72988a68) - make dump a list instead of a nested dict to avoid all recursion errors *(PR [#5885](https://github.com/tobymao/sqlglot/pull/5885) by [@tobymao](https://github.com/tobymao))*:

  make dump a list instead of a nested dict to avoid all recursion errors (#5885)

- due to [`2fdaccd`](https://github.com/tobymao/sqlglot/commit/2fdaccd1a9045bda3d529025a4706c397b8a836f) - annotate types for Snowflake SHA1, SHA2 functions *(PR [#5884](https://github.com/tobymao/sqlglot/pull/5884) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake SHA1, SHA2 functions (#5884)

- due to [`faba309`](https://github.com/tobymao/sqlglot/commit/faba30905390e5efaf0ba9a05aab9ac2724b1b85) - annotate types for Snowflake AI_AGG function *(PR [#5894](https://github.com/tobymao/sqlglot/pull/5894) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake AI_AGG function (#5894)

- due to [`304bec5`](https://github.com/tobymao/sqlglot/commit/304bec5f7342501ad28ea4cd0a4b9aa092f2192f) - Annotate snowflake MD5 functions *(PR [#5883](https://github.com/tobymao/sqlglot/pull/5883) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate snowflake MD5 functions (#5883)

- due to [`c0180ec`](https://github.com/tobymao/sqlglot/commit/c0180ec163a43836fed754efcb6f26ad37cdae50) - annotate types for Snowflake AI_SUMMARIZE_AGG function *(PR [#5902](https://github.com/tobymao/sqlglot/pull/5902) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake AI_SUMMARIZE_AGG function (#5902)

- due to [`f5409df`](https://github.com/tobymao/sqlglot/commit/f5409df64ed6069880669878db687e4b98c3e280) - use column name in struct type annotation *(PR [#5903](https://github.com/tobymao/sqlglot/pull/5903) by [@georgesittas](https://github.com/georgesittas))*:

  use column name in struct type annotation (#5903)

- due to [`5a973e9`](https://github.com/tobymao/sqlglot/commit/5a973e9a88fa7f522a9bf91dc60fb0f6effef53d) - annotate types for Snowflake AI_CLASSIFY function *(PR [#5909](https://github.com/tobymao/sqlglot/pull/5909) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake AI_CLASSIFY function (#5909)

- due to [`2d0d908`](https://github.com/tobymao/sqlglot/commit/2d0d908b5bbc32ff3bc92eb1ae9fc6e5ac3409bc) - produce TableAlias instead of Alias for USING in merge builder *(PR [#5911](https://github.com/tobymao/sqlglot/pull/5911) by [@georgesittas](https://github.com/georgesittas))*:

  produce TableAlias instead of Alias for USING in merge builder (#5911)

- due to [`f4ad258`](https://github.com/tobymao/sqlglot/commit/f4ad25882951de4e4442dfd5189a56d5a1c5e630) - Annotate types for Snowflake BASE64_DECODE_BINARY function *(PR [#5917](https://github.com/tobymao/sqlglot/pull/5917) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate types for Snowflake BASE64_DECODE_BINARY function (#5917)

- due to [`6d0e3f8`](https://github.com/tobymao/sqlglot/commit/6d0e3f8dcae7ed1a7659ece69b1f94cec5e7300e) - Add parser support to ilike like function versions. *(PR [#5915](https://github.com/tobymao/sqlglot/pull/5915) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Add parser support to ilike like function versions. (#5915)

- due to [`22c7ed7`](https://github.com/tobymao/sqlglot/commit/22c7ed7734b41ca544bb67bcc1ca4151f6d5f05f) - parse tuple *(PR [#5920](https://github.com/tobymao/sqlglot/pull/5920) by [@geooo109](https://github.com/geooo109))*:

  parse tuple (#5920)

- due to [`fc5624e`](https://github.com/tobymao/sqlglot/commit/fc5624eca43d2855ac350c92d85b184a6893d5ca) - annotate types for Snowflake ASCII function *(PR [#5926](https://github.com/tobymao/sqlglot/pull/5926) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake ASCII function (#5926)

- due to [`4e81690`](https://github.com/tobymao/sqlglot/commit/4e8169045edcaa28ae43abeb07370df63846fbfd) - annotate type for Snowflake COLLATE function *(PR [#5931](https://github.com/tobymao/sqlglot/pull/5931) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake COLLATE function (#5931)

- due to [`f07d35d`](https://github.com/tobymao/sqlglot/commit/f07d35d29104c6203efaab738118d1903614b83c) - annotate type for Snowflake CHR function *(PR [#5929](https://github.com/tobymao/sqlglot/pull/5929) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake CHR function (#5929)

- due to [`f8c0ee4`](https://github.com/tobymao/sqlglot/commit/f8c0ee4d3c1a4d4a92b897d1cc85f9904c8e566b) - Add function and annotate snowflake hex decode string and binary functions *(PR [#5928](https://github.com/tobymao/sqlglot/pull/5928) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Add function and annotate snowflake hex decode string and binary functions (#5928)

- due to [`66f9501`](https://github.com/tobymao/sqlglot/commit/66f9501d76d087798bad93e578273ab2a45e2575) - annotate types for Snowflake BIT_LENGTH function *(PR [#5927](https://github.com/tobymao/sqlglot/pull/5927) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake BIT_LENGTH function (#5927)

- due to [`7878437`](https://github.com/tobymao/sqlglot/commit/78784370712df65a2e1e79a1c2b441131ed7222a) - annotate snowflake's `BASE64_DECODE_STRING`, `BASE64_ENCODE` *(PR [#5922](https://github.com/tobymao/sqlglot/pull/5922) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  annotate snowflake's `BASE64_DECODE_STRING`, `BASE64_ENCODE` (#5922)

- due to [`9bcad04`](https://github.com/tobymao/sqlglot/commit/9bcad040bd51dd03821c68eea1a73534fc7a81b7) - Annotate type for HEX ENCODE function. *(PR [#5936](https://github.com/tobymao/sqlglot/pull/5936) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for HEX ENCODE function. (#5936)

- due to [`590928f`](https://github.com/tobymao/sqlglot/commit/590928f4637306e8cf3f1302d5dd5d5dbc76e7e0) - annotate type for Snowflake INITCAP function *(PR [#5941](https://github.com/tobymao/sqlglot/pull/5941) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake INITCAP function (#5941)

- due to [`ac04de1`](https://github.com/tobymao/sqlglot/commit/ac04de1944c7a976406581b489b3cf9b11dafb77) - annotate type for Snowflake EDITDISTANCE function *(PR [#5940](https://github.com/tobymao/sqlglot/pull/5940) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake EDITDISTANCE function (#5940)

- due to [`9e28af8`](https://github.com/tobymao/sqlglot/commit/9e28af8a52ced951ecf7f4e85a6305e20a13de1f) - Annotate type for snowflake COMPRESS function *(PR [#5938](https://github.com/tobymao/sqlglot/pull/5938) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake COMPRESS function (#5938)

- due to [`7f13eaf`](https://github.com/tobymao/sqlglot/commit/7f13eaf7769a3381a56c9209af590835be2f95cd) - Annotate type for snowflake DECOMPRESS_BINARY function *(PR [#5945](https://github.com/tobymao/sqlglot/pull/5945) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake DECOMPRESS_BINARY function (#5945)

- due to [`be12b29`](https://github.com/tobymao/sqlglot/commit/be12b29b5a7bd6d6e09dbd8c17086bd77c19abc0) - Annotate type for snowflake DECOMPRESS_STRING function *(PR [#5947](https://github.com/tobymao/sqlglot/pull/5947) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake DECOMPRESS_STRING function (#5947)

- due to [`1573fef`](https://github.com/tobymao/sqlglot/commit/1573fefac27b5b1215e3d458f8ccf1b9dadbb772) - annotate types for Snowflake JAROWINKLER_SIMILARITY function *(PR [#5950](https://github.com/tobymao/sqlglot/pull/5950) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake JAROWINKLER_SIMILARITY function (#5950)

- due to [`883c6ab`](https://github.com/tobymao/sqlglot/commit/883c6abe589865f478d95604e8d670e57afd04af) - annotate type for Snowflake COLLATION function *(PR [#5939](https://github.com/tobymao/sqlglot/pull/5939) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake COLLATION function (#5939)

- due to [`68473ac`](https://github.com/tobymao/sqlglot/commit/68473ac3ec8dc76512dc76819892a1b0324c7ddc) - Annotate type for snowflake PARSE_URL function *(PR [#5962](https://github.com/tobymao/sqlglot/pull/5962) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake PARSE_URL function (#5962)

- due to [`b015a9d`](https://github.com/tobymao/sqlglot/commit/b015a9d944d0a87069a7750ad74953c399d7da34) - annotate type for Snowflake REGEXP_INSTR function *(commit by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake REGEXP_INSTR function

- due to [`1f29ba7`](https://github.com/tobymao/sqlglot/commit/1f29ba710f4213beb1a2f993244d7d824f3536ce) - annotate type for Snowflake PARSE_IP function *(PR [#5961](https://github.com/tobymao/sqlglot/pull/5961) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake PARSE_IP function (#5961)

- due to [`bf45d5d`](https://github.com/tobymao/sqlglot/commit/bf45d5d3cb0c0f380824019eb32ec29049268a61) - annotate types for Snowflake RTRIMMED_LENGTH function *(PR [#5968](https://github.com/tobymao/sqlglot/pull/5968) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake RTRIMMED_LENGTH function (#5968)

- due to [`13caa69`](https://github.com/tobymao/sqlglot/commit/13caa6991f003ad7abb590073451e591b6fd888c) - Annotate type for snowflake POSITION function *(PR [#5964](https://github.com/tobymao/sqlglot/pull/5964) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake POSITION function (#5964)

- due to [`13a30df`](https://github.com/tobymao/sqlglot/commit/13a30dfa37096df5bfc2c31538325c40a49f7917) - Annotate type for snowflake TRY_BASE64_DECODE_BINARY function *(PR [#5972](https://github.com/tobymao/sqlglot/pull/5972) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TRY_BASE64_DECODE_BINARY function (#5972)

- due to [`1f5fdd7`](https://github.com/tobymao/sqlglot/commit/1f5fdd799c047de167a4572f7ac26b7ad92167f2) - Annotate type for snowflake TRY_BASE64_DECODE_STRING function *(PR [#5974](https://github.com/tobymao/sqlglot/pull/5974) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TRY_BASE64_DECODE_STRING function (#5974)

- due to [`324e82f`](https://github.com/tobymao/sqlglot/commit/324e82fe1fb11722f91341010602a743b151e055) - Annotate type for snowflake TRY_HEX_DECODE_BINARY function *(PR [#5975](https://github.com/tobymao/sqlglot/pull/5975) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TRY_HEX_DECODE_BINARY function (#5975)

- due to [`6caf99d`](https://github.com/tobymao/sqlglot/commit/6caf99d556a3357ffaa6c294a9babcd30dd5fac5) - Annotate type for snowflake TRY_HEX_DECODE_STRING function *(PR [#5976](https://github.com/tobymao/sqlglot/pull/5976) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TRY_HEX_DECODE_STRING function (#5976)

- due to [`73186a8`](https://github.com/tobymao/sqlglot/commit/73186a812ce422c108ee81b3de11da6ee9a9e902) - annotate type for Snowflake REGEXP_COUNT function *(PR [#5963](https://github.com/tobymao/sqlglot/pull/5963) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake REGEXP_COUNT function (#5963)

- due to [`c3bdb3c`](https://github.com/tobymao/sqlglot/commit/c3bdb3cd1af1809ed82be0ae40744d9fffc8ce18) - array start index is 1, support array_flatten, fixes [#5983](https://github.com/tobymao/sqlglot/pull/5983) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  array start index is 1, support array_flatten, fixes #5983

- due to [`244fb48`](https://github.com/tobymao/sqlglot/commit/244fb48fc9c4776f427c08b825d139b1c172fd26) - annotate type for Snowflake SPLIT_PART function *(PR [#5988](https://github.com/tobymao/sqlglot/pull/5988) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake SPLIT_PART function (#5988)

- due to [`0d772e0`](https://github.com/tobymao/sqlglot/commit/0d772e0b9d687b24d49203c05d7a90cc1dce02d5) - add ast node for `DIRECTORY` source *(PR [#5990](https://github.com/tobymao/sqlglot/pull/5990) by [@georgesittas](https://github.com/georgesittas))*:

  add ast node for `DIRECTORY` source (#5990)

- due to [`3c7b5c0`](https://github.com/tobymao/sqlglot/commit/3c7b5c0e2dc071b7b9f6da308ba58a3a43da93dc) - Annotate type for snowflake SOUNDEX_P123 function *(PR [#5987](https://github.com/tobymao/sqlglot/pull/5987) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake SOUNDEX_P123 function (#5987)

- due to [`f25e42e`](https://github.com/tobymao/sqlglot/commit/f25e42e3f5b3b7b671bd724ba7b09a9b07d13995) - annotate type for Snowflake REGEXP_INSTR function *(PR [#5978](https://github.com/tobymao/sqlglot/pull/5978) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake REGEXP_INSTR function (#5978)

- due to [`13cb26e`](https://github.com/tobymao/sqlglot/commit/13cb26e2f29373538d60a8124ddebf95fd22a8d8) - annotate type for Snowflake REGEXP_SUBSTR_ALL function *(PR [#5979](https://github.com/tobymao/sqlglot/pull/5979) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake REGEXP_SUBSTR_ALL function (#5979)

- due to [`4ce683e`](https://github.com/tobymao/sqlglot/commit/4ce683eb8ac5716a334cbd7625438b9f89623c7a) - Annotate type for snowflake UNICODE function *(PR [#5993](https://github.com/tobymao/sqlglot/pull/5993) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake UNICODE function (#5993)

- due to [`c7657fb`](https://github.com/tobymao/sqlglot/commit/c7657fbd27a4350c424ef65947471ab9ec086831) - remove `unalias_group_by` transformation since it is unsafe *(PR [#5997](https://github.com/tobymao/sqlglot/pull/5997) by [@georgesittas](https://github.com/georgesittas))*:

  remove `unalias_group_by` transformation since it is unsafe (#5997)

- due to [`587196c`](https://github.com/tobymao/sqlglot/commit/587196c9c2d122f73f9deb7e87c2831f27f6ed02) - Annotate type for snowflake STRTOK_TO_ARRAY function *(PR [#5994](https://github.com/tobymao/sqlglot/pull/5994) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake STRTOK_TO_ARRAY function (#5994)

- due to [`bced710`](https://github.com/tobymao/sqlglot/commit/bced71084ffb3a8f7a11db843777f05b68f367da) - Annotate type for snowflake STRTOK function. *(PR [#5991](https://github.com/tobymao/sqlglot/pull/5991) by [@georgesittas](https://github.com/georgesittas))*:

  Annotate type for snowflake STRTOK function. (#5991)

- due to [`be1cdc8`](https://github.com/tobymao/sqlglot/commit/be1cdc81b511d462b710b50941d5c2770d901e91) - Fix roundtrip of ~ operator *(PR [#6017](https://github.com/tobymao/sqlglot/pull/6017) by [@VaggelisD](https://github.com/VaggelisD))*:

  Fix roundtrip of ~ operator (#6017)

- due to [`74a13f2`](https://github.com/tobymao/sqlglot/commit/74a13f2a548b9cd41061e835cb3cd9dd2a5a9fb3) - Annotate type for snowflake DIV0 and DIVNULL functions *(PR [#6008](https://github.com/tobymao/sqlglot/pull/6008) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake DIV0 and DIVNULL functions (#6008)

- due to [`fec2b31`](https://github.com/tobymao/sqlglot/commit/fec2b31956f2debdad7c53744a577894cd8d747c) - Annotate type for snowflake SEARCH function *(PR [#5985](https://github.com/tobymao/sqlglot/pull/5985) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake SEARCH function (#5985)

- due to [`27a76cd`](https://github.com/tobymao/sqlglot/commit/27a76cdfe4212f16f945521eb3997580eacf1d61) - Annotate type for snowflake COT, SIN and TAN functions *(PR [#6022](https://github.com/tobymao/sqlglot/pull/6022) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake COT, SIN and TAN functions (#6022)

- due to [`0911276`](https://github.com/tobymao/sqlglot/commit/091127663ab4cb94b02be5aa40c6a46dd7f89243) - annotate type for Snowflake EXP function *(PR [#6007](https://github.com/tobymao/sqlglot/pull/6007) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake EXP function (#6007)

- due to [`a96d50e`](https://github.com/tobymao/sqlglot/commit/a96d50e14bed5e87ff2dce9c545e0c48897b64d6) - annotate type for Snowflake COSH function *(PR [#6006](https://github.com/tobymao/sqlglot/pull/6006) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake COSH function (#6006)

- due to [`4df58e0`](https://github.com/tobymao/sqlglot/commit/4df58e0f0b8985590fb29a8ab6ba0ced987ac5b9) - annotate type for Snowflake DEGREES function *(PR [#6027](https://github.com/tobymao/sqlglot/pull/6027) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake DEGREES function (#6027)

- due to [`db71a20`](https://github.com/tobymao/sqlglot/commit/db71a2023aaeca2ffda782ae7b91fdee356c402e) - annotate type for Snowflake COS function *(PR [#6028](https://github.com/tobymao/sqlglot/pull/6028) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake COS function (#6028)

- due to [`5dd2ed3`](https://github.com/tobymao/sqlglot/commit/5dd2ed3c69cf9e8c3e327297e0cc932f0954e108) - bump sqlglotrs to 0.7.0 *(commit by [@georgesittas](https://github.com/georgesittas))*:

  bump sqlglotrs to 0.7.0

- due to [`6beb917`](https://github.com/tobymao/sqlglot/commit/6beb9172dffd0aaea46b75477485060737e774b9) - Annotate type for snowflake ROUND function *(PR [#6032](https://github.com/tobymao/sqlglot/pull/6032) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake ROUND function (#6032)

- due to [`0939d69`](https://github.com/tobymao/sqlglot/commit/0939d69223a860581b1c30cc2f762294946b93f3) - move odbc date literal handling in t-sql closes [#6037](https://github.com/tobymao/sqlglot/pull/6037) *(PR [#6044](https://github.com/tobymao/sqlglot/pull/6044) by [@georgesittas](https://github.com/georgesittas))*:

  move odbc date literal handling in t-sql closes #6037 (#6044)

- due to [`56c8b3b`](https://github.com/tobymao/sqlglot/commit/56c8b3bbff7451b9049e1a168716bb41222a86ed) - Support CHANGE COLUMN statements in Hive and CHANGE/ALTER COLUMN statements in Spark *(PR [#6004](https://github.com/tobymao/sqlglot/pull/6004) by [@tsamaras](https://github.com/tsamaras))*:

  Support CHANGE COLUMN statements in Hive and CHANGE/ALTER COLUMN statements in Spark (#6004)

- due to [`7ac01c2`](https://github.com/tobymao/sqlglot/commit/7ac01c2ae9bc4375efb63c60e3221e85088fdd1f) - bump sqlglotrs to 0.7.1 *(commit by [@georgesittas](https://github.com/georgesittas))*:

  bump sqlglotrs to 0.7.1

- due to [`6f31b86`](https://github.com/tobymao/sqlglot/commit/6f31b86599258afe156aa3d9ccc42389cac37021) - Annotate type for snowflake FLOOR function *(PR [#6030](https://github.com/tobymao/sqlglot/pull/6030) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake FLOOR function (#6030)

- due to [`cecab2f`](https://github.com/tobymao/sqlglot/commit/cecab2fd66d578ddc765b5fd0e7b155971280a0c) - annotate type for Snowflake ATANH function *(PR [#6054](https://github.com/tobymao/sqlglot/pull/6054) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake ATANH function (#6054)

- due to [`08339a9`](https://github.com/tobymao/sqlglot/commit/08339a902138211f67cfb009d2576b22ea8d8e42) - annotate type for Snowflake FACTORIAL function *(PR [#6053](https://github.com/tobymao/sqlglot/pull/6053) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake FACTORIAL function (#6053)

- due to [`9060f60`](https://github.com/tobymao/sqlglot/commit/9060f603818db863b7570a2c3c50c3eb88155e76) - Annotate type for snowflake ATAN2 function. *(PR [#6060](https://github.com/tobymao/sqlglot/pull/6060) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake ATAN2 function. (#6060)

- due to [`b3eb2e4`](https://github.com/tobymao/sqlglot/commit/b3eb2e4ca6177ee61b27675e8ec8b4815587df31) - annotate type for Snowflake SINH function *(PR [#6052](https://github.com/tobymao/sqlglot/pull/6052) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake SINH function (#6052)

- due to [`157d2fa`](https://github.com/tobymao/sqlglot/commit/157d2fa06ab110ebc760aa7567d7fda801a5ced9) - annotate type for Snowflake CEIL function *(PR [#6051](https://github.com/tobymao/sqlglot/pull/6051) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake CEIL function (#6051)

- due to [`e7833de`](https://github.com/tobymao/sqlglot/commit/e7833de9744a4aa69d244285e7f6f7281af178ba) - support DELETE with USING and multiple VALUES *(PR [#6072](https://github.com/tobymao/sqlglot/pull/6072) by [@geooo109](https://github.com/geooo109))*:

  support DELETE with USING and multiple VALUES (#6072)

- due to [`354140d`](https://github.com/tobymao/sqlglot/commit/354140d0a279f317439bdb247e1ab9578f9a035d) - Annotate type for snowflake TANH and ATAN functions *(PR [#6069](https://github.com/tobymao/sqlglot/pull/6069) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TANH and ATAN functions (#6069)

- due to [`c67276d`](https://github.com/tobymao/sqlglot/commit/c67276d5be970252e14d1817d8498fc9985222d9) - Annotate type for snowflake RADIANS function. *(PR [#6064](https://github.com/tobymao/sqlglot/pull/6064) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake RADIANS function. (#6064)

- due to [`2238ac2`](https://github.com/tobymao/sqlglot/commit/2238ac27478bd272ba39928bbec1075c4191ee1b) - transpile timestamp literals in datediff fixes [#6083](https://github.com/tobymao/sqlglot/pull/6083) *(PR [#6086](https://github.com/tobymao/sqlglot/pull/6086) by [@georgesittas](https://github.com/georgesittas))*:

  transpile timestamp literals in datediff fixes #6083 (#6086)

- due to [`c49ba0e`](https://github.com/tobymao/sqlglot/commit/c49ba0eee21f7776703d2a26c6641b4a32a1cff7) - Annotate type for snowflake WIDTH_BUCKET function *(PR [#6078](https://github.com/tobymao/sqlglot/pull/6078) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake WIDTH_BUCKET function (#6078)

- due to [`fbc1f13`](https://github.com/tobymao/sqlglot/commit/fbc1f1335eecaaaab4fc93ddbb74611a4df0aea7) - annotate type for Snowflake CONVERT_TIMEZONE function *(PR [#6076](https://github.com/tobymao/sqlglot/pull/6076) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake CONVERT_TIMEZONE function (#6076)

- due to [`70e977c`](https://github.com/tobymao/sqlglot/commit/70e977c5edfb495529d38a9096cb40762a9b5d7b) - annotate type for Snowflake DATE_TRUNC function *(PR [#6080](https://github.com/tobymao/sqlglot/pull/6080) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake DATE_TRUNC function (#6080)

- due to [`e9cf146`](https://github.com/tobymao/sqlglot/commit/e9cf146a4a6cd78f6a59c195e7ec12240b836e5e) - annotate type for Snowflake DATE_PART function *(PR [#6079](https://github.com/tobymao/sqlglot/pull/6079) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake DATE_PART function (#6079)

- due to [`5109890`](https://github.com/tobymao/sqlglot/commit/510989043d18baa17502a971262462814a2eb5be) - VALUES with ORDER BY/LIMIT/OFFSET *(PR [#6094](https://github.com/tobymao/sqlglot/pull/6094) by [@geooo109](https://github.com/geooo109))*:

  VALUES with ORDER BY/LIMIT/OFFSET (#6094)

- due to [`6fe5824`](https://github.com/tobymao/sqlglot/commit/6fe58247888c326093618657fb027e482d82d107) - Annotate type for hour, minute, second functions *(PR [#6100](https://github.com/tobymao/sqlglot/pull/6100) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for hour, minute, second functions (#6100)

- due to [`a4d07a0`](https://github.com/tobymao/sqlglot/commit/a4d07a07eefbdaf88d30df2310a9533afdc75a82) - Annotate type for snowflake EXTRACT function *(PR [#6099](https://github.com/tobymao/sqlglot/pull/6099) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake EXTRACT function (#6099)

- due to [`483770b`](https://github.com/tobymao/sqlglot/commit/483770b816fab14b7eb7222974ed2c99045302a7) - Annotate type for snowflake TIME_SLICE function *(PR [#6098](https://github.com/tobymao/sqlglot/pull/6098) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TIME_SLICE function (#6098)

- due to [`06f40f9`](https://github.com/tobymao/sqlglot/commit/06f40f900ce693ba4203514e422cba8cda0dbb07) - don't simplify x XOR x due to NULL semantics *(PR [#6115](https://github.com/tobymao/sqlglot/pull/6115) by [@geooo109](https://github.com/geooo109))*:

  don't simplify x XOR x due to NULL semantics (#6115)

- due to [`c286cee`](https://github.com/tobymao/sqlglot/commit/c286cee54ab93e1fd0b3be658f7e767e3e00afe9) - Annotate type for snowflake MONTHNAME function *(PR [#6116](https://github.com/tobymao/sqlglot/pull/6116) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake MONTHNAME function (#6116)

- due to [`1a34788`](https://github.com/tobymao/sqlglot/commit/1a34788025bdd8a018c4bb9214f72152e68bdd14) - Annotate type for snowflake PREVIOUS_DAY function *(PR [#6117](https://github.com/tobymao/sqlglot/pull/6117) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake PREVIOUS_DAY function (#6117)

- due to [`533faf8`](https://github.com/tobymao/sqlglot/commit/533faf87b6df351070b565dd1fe9ce4e13b6c46e) - transpile duckdb `READ_PARQUET` to `parquet.<path>` closes [#6122](https://github.com/tobymao/sqlglot/pull/6122) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  transpile duckdb `READ_PARQUET` to `parquet.<path>` closes #6122

- due to [`cd4e557`](https://github.com/tobymao/sqlglot/commit/cd4e557658b1384f36c9a1ef9da5a09b893229b1) - Annotate type for snowflake RANDOM function *(PR [#6124](https://github.com/tobymao/sqlglot/pull/6124) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  Annotate type for snowflake RANDOM function (#6124)

- due to [`fe63d84`](https://github.com/tobymao/sqlglot/commit/fe63d84f1bd365b22221f348d79c0546aa3118b0) - annotate type for Snowflake MONTHS_BETWEEN function *(PR [#6120](https://github.com/tobymao/sqlglot/pull/6120) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for Snowflake MONTHS_BETWEEN function (#6120)

- due to [`598d09b`](https://github.com/tobymao/sqlglot/commit/598d09b036d938c90a44955d67175ea868090ba2) - annotate type for Snowflake DATEADD function *(PR [#6089](https://github.com/tobymao/sqlglot/pull/6089) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake DATEADD function (#6089)

- due to [`b98bcee`](https://github.com/tobymao/sqlglot/commit/b98bcee148ba426816e166dbfa9ba8e0979aae21) - Annotate type for snowflake next_day function *(PR [#6125](https://github.com/tobymao/sqlglot/pull/6125) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  Annotate type for snowflake next_day function (#6125)

- due to [`e2129c6`](https://github.com/tobymao/sqlglot/commit/e2129c6766ca1f10ff6663bec98be984abb33c91) - Do not consider BIT_COUNT an aggregate function *(PR [#6135](https://github.com/tobymao/sqlglot/pull/6135) by [@VaggelisD](https://github.com/VaggelisD))*:

  Do not consider BIT_COUNT an aggregate function (#6135)

- due to [`d136414`](https://github.com/tobymao/sqlglot/commit/d136414e520270ac9ab2fd8e9df4691d269b3af0) - avoid simplifying AND with NULL *(PR [#6148](https://github.com/tobymao/sqlglot/pull/6148) by [@geooo109](https://github.com/geooo109))*:

  avoid simplifying AND with NULL (#6148)

- due to [`3a334f3`](https://github.com/tobymao/sqlglot/commit/3a334f376b9766b6b99fdf195ae763bb44976ec4) - annotate type for boolnot snowflake function *(PR [#6141](https://github.com/tobymao/sqlglot/pull/6141) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate type for boolnot snowflake function (#6141)

- due to [`99949cc`](https://github.com/tobymao/sqlglot/commit/99949ccd3ff81b524edeae437d874b86250dbb5b) - avoid needlessly copying in lineage *(PR [#6150](https://github.com/tobymao/sqlglot/pull/6150) by [@georgesittas](https://github.com/georgesittas))*:

  avoid needlessly copying in lineage (#6150)

- due to [`4e36f9d`](https://github.com/tobymao/sqlglot/commit/4e36f9dd6a854b378c9bbf6b2e9811045affc63d) - Annotate type for snowflake TIMEADD function *(PR [#6134](https://github.com/tobymao/sqlglot/pull/6134) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TIMEADD function (#6134)

- due to [`5242cdd`](https://github.com/tobymao/sqlglot/commit/5242cddf487e367e7f543ca19d9bccae858f36ac) - annotate type for bq LENGTH *(commit by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq LENGTH

- due to [`0fc6dbf`](https://github.com/tobymao/sqlglot/commit/0fc6dbf2e7b611fa0977e3c3e61be1cc84bcf4a9) - add GREATEST_IGNORE_NULLS function support *(PR [#6161](https://github.com/tobymao/sqlglot/pull/6161) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add GREATEST_IGNORE_NULLS function support (#6161)

- due to [`d382a31`](https://github.com/tobymao/sqlglot/commit/d382a3106d5ce2e9b75527aacd4a37d1f8e16d18) - simplify double negation only if the inner expr is BOOLEAN *(PR [#6151](https://github.com/tobymao/sqlglot/pull/6151) by [@geooo109](https://github.com/geooo109))*:

  simplify double negation only if the inner expr is BOOLEAN (#6151)

- due to [`bcf6c89`](https://github.com/tobymao/sqlglot/commit/bcf6c89a47abd3c2c4383d1c908f892b6619b6fa) - add type annotation tests for snowflake BOOLAND *(PR [#6153](https://github.com/tobymao/sqlglot/pull/6153) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  add type annotation tests for snowflake BOOLAND (#6153)

- due to [`52d1eec`](https://github.com/tobymao/sqlglot/commit/52d1eecaad505703e8b22dcfe8954652f57985b6) - Annotate type for snowflake TIMESTAMP_FROM_PARTS function *(PR [#6139](https://github.com/tobymao/sqlglot/pull/6139) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TIMESTAMP_FROM_PARTS function (#6139)

- due to [`8651fe6`](https://github.com/tobymao/sqlglot/commit/8651fe6526dea865c0d54d6d53086359a7835d32) - annotate types for BOOLOR *(PR [#6159](https://github.com/tobymao/sqlglot/pull/6159) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for BOOLOR (#6159)

- due to [`812ba9a`](https://github.com/tobymao/sqlglot/commit/812ba9abad8247df81c8f8b514336c8766292112) - Annotate type for snowflake date parts functions *(PR [#6158](https://github.com/tobymao/sqlglot/pull/6158) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  Annotate type for snowflake date parts functions (#6158)

- due to [`9f8c123`](https://github.com/tobymao/sqlglot/commit/9f8c123ae44249e274334d0aa551ac33814f2b32) - make qualify table callback more generic *(PR [#6171](https://github.com/tobymao/sqlglot/pull/6171) by [@tobymao](https://github.com/tobymao))*:

  make qualify table callback more generic (#6171)

- due to [`74b4e7c`](https://github.com/tobymao/sqlglot/commit/74b4e7c311e9d4ff39ce2e4d91940eced96aa32f) - fix type annotation for Snowflake BOOLOR and BOOLAND *(PR [#6169](https://github.com/tobymao/sqlglot/pull/6169) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  fix type annotation for Snowflake BOOLOR and BOOLAND (#6169)

- due to [`ef87520`](https://github.com/tobymao/sqlglot/commit/ef875204596b8529f3358025c7a61d757a999bdc) - Transpile `REGEXP_REPLACE` with 'g' option *(PR [#6174](https://github.com/tobymao/sqlglot/pull/6174) by [@VaggelisD](https://github.com/VaggelisD))*:

  Transpile `REGEXP_REPLACE` with 'g' option (#6174)

- due to [`93071e2`](https://github.com/tobymao/sqlglot/commit/93071e255406f62ea83dd89a3be4871b7edfb3fe) - Fix simplify_parens from removing negated *(PR [#6194](https://github.com/tobymao/sqlglot/pull/6194) by [@VaggelisD](https://github.com/VaggelisD))*:

  Fix simplify_parens from removing negated (#6194)

- due to [`e90168a`](https://github.com/tobymao/sqlglot/commit/e90168a6829b85534edcecec7d0df2a8b1b56fc4) - annotate type for Snowflake's `IS_NULL_VALUE` function *(PR [#6186](https://github.com/tobymao/sqlglot/pull/6186) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotate type for Snowflake's `IS_NULL_VALUE` function (#6186)

- due to [`c93b535`](https://github.com/tobymao/sqlglot/commit/c93b5354827282c806899c36b11e7a7598e96e38) - annotate type for LEAST_IGNORE_NULLS *(PR [#6196](https://github.com/tobymao/sqlglot/pull/6196) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotate type for LEAST_IGNORE_NULLS (#6196)

- due to [`f60c71f`](https://github.com/tobymao/sqlglot/commit/f60c71fb03db91bfe90430d032ac16f4945d5dff) - annotate types for REGR_VALX *(PR [#6198](https://github.com/tobymao/sqlglot/pull/6198) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for REGR_VALX (#6198)

- due to [`b82c571`](https://github.com/tobymao/sqlglot/commit/b82c57131707297abe174539023b9cb62b7cd6c7) - annotate types for REGR_VALY *(PR [#6206](https://github.com/tobymao/sqlglot/pull/6206) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for REGR_VALY (#6206)

- due to [`39d8e19`](https://github.com/tobymao/sqlglot/commit/39d8e19419c2adbb80465be414d1cc3bbc6d007b) - include VARIABLE kind in SET transpilation to DuckDB *(PR [#6201](https://github.com/tobymao/sqlglot/pull/6201) by [@toriwei](https://github.com/toriwei))*:

  include VARIABLE kind in SET transpilation to DuckDB (#6201)

- due to [`e7ddad1`](https://github.com/tobymao/sqlglot/commit/e7ddad10b5edf9b801d2151e3e5fca448754df0d) - ensure `NULL` coerces into any type *(PR [#6211](https://github.com/tobymao/sqlglot/pull/6211) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  ensure `NULL` coerces into any type (#6211)

- due to [`0037266`](https://github.com/tobymao/sqlglot/commit/00372664bf6acf2b0fff9ad4b206b597ef5378f7) - annotate types for GETBIT *(PR [#6219](https://github.com/tobymao/sqlglot/pull/6219) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for GETBIT (#6219)

- due to [`a5458ce`](https://github.com/tobymao/sqlglot/commit/a5458ceca3bc239fb611791e38020632dd0824c8) - add type annotation for DECODE function support *(PR [#6199](https://github.com/tobymao/sqlglot/pull/6199) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add type annotation for DECODE function support (#6199)

- due to [`417f1e8`](https://github.com/tobymao/sqlglot/commit/417f1e8ee50fb8f4377fad261660ffbd7444a429) - annotate types for BITNOT *(PR [#6234](https://github.com/tobymao/sqlglot/pull/6234) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for BITNOT (#6234)

- due to [`fe8ab40`](https://github.com/tobymao/sqlglot/commit/fe8ab40e8e0559201e0b1896a6f1a8fb6b5b932d) - 1st-class parsing support for BITAND, BIT_AND, BIT_NOT *(PR [#6243](https://github.com/tobymao/sqlglot/pull/6243) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  1st-class parsing support for BITAND, BIT_AND, BIT_NOT (#6243)

- due to [`5ae3c47`](https://github.com/tobymao/sqlglot/commit/5ae3c47b1c6993b87341472c08714f4a0f738168) - add type annotation for GROUPING() function *(PR [#6244](https://github.com/tobymao/sqlglot/pull/6244) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add type annotation for GROUPING() function (#6244)

- due to [`4133265`](https://github.com/tobymao/sqlglot/commit/413326514507ef06537dcc3d4b80a3fcbcd26f66) - parse `has` function into an `ArrayContains` expression *(PR [#6245](https://github.com/tobymao/sqlglot/pull/6245) by [@joeyutong](https://github.com/joeyutong))*:

  parse `has` function into an `ArrayContains` expression (#6245)

- due to [`cdd45b9`](https://github.com/tobymao/sqlglot/commit/cdd45b949fd1eefb147053424279b56b8effcbcf) - annotate types for GROUPING_ID function. *(PR [#6249](https://github.com/tobymao/sqlglot/pull/6249) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotate types for GROUPING_ID function. (#6249)

- due to [`080ff3b`](https://github.com/tobymao/sqlglot/commit/080ff3bd93b36291d5bb0092d722f8307f0ae082) - annotate types for BITAND_AGG *(PR [#6248](https://github.com/tobymao/sqlglot/pull/6248) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for BITAND_AGG (#6248)

- due to [`87a818a`](https://github.com/tobymao/sqlglot/commit/87a818a899f61a675c22c697f468b3f6f7e2787f) - annotate types for BITOR_AGG  *(PR [#6251](https://github.com/tobymao/sqlglot/pull/6251) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for BITOR_AGG  (#6251)

- due to [`4c4189b`](https://github.com/tobymao/sqlglot/commit/4c4189b4083d272a6e678d83b5c567a2e9c0d672) - Transpile CONCAT function to double pipe operators when source … *(PR [#6241](https://github.com/tobymao/sqlglot/pull/6241) by [@vchan](https://github.com/vchan))*:

  Transpile CONCAT function to double pipe operators when source … (#6241)

- due to [`a1b884d`](https://github.com/tobymao/sqlglot/commit/a1b884dc9ddfd2185de48cc9451a39f152879d39) - annotate types for BITXOR_AGG *(PR [#6253](https://github.com/tobymao/sqlglot/pull/6253) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for BITXOR_AGG (#6253)

- due to [`fc78d20`](https://github.com/tobymao/sqlglot/commit/fc78d2016d8f7d20c094df791f746de323cd3639) - Unwrap subqueries without modifiers *(PR [#6247](https://github.com/tobymao/sqlglot/pull/6247) by [@VaggelisD](https://github.com/VaggelisD))*:

  Unwrap subqueries without modifiers (#6247)

- due to [`ad2ad23`](https://github.com/tobymao/sqlglot/commit/ad2ad234b5a508040dce4f3920439be052742573) - add missing return type mapping for MAX_BY and MAX_BY function *(PR [#6250](https://github.com/tobymao/sqlglot/pull/6250) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add missing return type mapping for MAX_BY and MAX_BY function (#6250)

- due to [`39c1d81`](https://github.com/tobymao/sqlglot/commit/39c1d81174f2390b6b0c9dd14c0e550ad452a1df) - annotate types for BOOLXOR_AGG *(PR [#6261](https://github.com/tobymao/sqlglot/pull/6261) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for BOOLXOR_AGG (#6261)

- due to [`71590d2`](https://github.com/tobymao/sqlglot/commit/71590d22cdb05594e2173a1500f763dc1a32a81d) - add type annotation for SKEW function. *(PR [#6262](https://github.com/tobymao/sqlglot/pull/6262) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add type annotation for SKEW function. (#6262)

- due to [`5fd366d`](https://github.com/tobymao/sqlglot/commit/5fd366d9e6f7b3f1eb7a9cf41975cf13ce890ffe) - annotate types for OBJECT_AGG *(PR [#6265](https://github.com/tobymao/sqlglot/pull/6265) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for OBJECT_AGG (#6265)

- due to [`00abc39`](https://github.com/tobymao/sqlglot/commit/00abc393c9042e839457c5a6582e95cdb74356f3) - handle casting for bytestrings  *(PR [#6252](https://github.com/tobymao/sqlglot/pull/6252) by [@toriwei](https://github.com/toriwei))*:

  handle casting for bytestrings  (#6252)

- due to [`3dae0fb`](https://github.com/tobymao/sqlglot/commit/3dae0fbb528762e5d5fd446350d42e9c841e2959) - Support position and occurrence args for REGEXP_EXTRACT *(PR [#6266](https://github.com/tobymao/sqlglot/pull/6266) by [@vchan](https://github.com/vchan))*:

  Support position and occurrence args for REGEXP_EXTRACT (#6266)

- due to [`ddea61d`](https://github.com/tobymao/sqlglot/commit/ddea61d83f6699c97cc7b25aabe01a138138bdb1) - simplify connector complements only for non-null operands *(PR [#6214](https://github.com/tobymao/sqlglot/pull/6214) by [@geooo109](https://github.com/geooo109))*:

  simplify connector complements only for non-null operands (#6214)

- due to [`771732d`](https://github.com/tobymao/sqlglot/commit/771732d81459cc576f11eccc49794f33e62d14af) - annotate types for REGR_AVGY *(PR [#6271](https://github.com/tobymao/sqlglot/pull/6271) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for REGR_AVGY (#6271)

- due to [`8470be0`](https://github.com/tobymao/sqlglot/commit/8470be00731a4d79518a533a5f7ba884fa2f047e) - add type annotation for BITMAP_COUNT function. *(PR [#6274](https://github.com/tobymao/sqlglot/pull/6274) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add type annotation for BITMAP_COUNT function. (#6274)

- due to [`98f25f9`](https://github.com/tobymao/sqlglot/commit/98f25f92cc1175ac7b2118a5a342db82adade13a) - support splitBy function *(PR [#6278](https://github.com/tobymao/sqlglot/pull/6278) by [@joeyutong](https://github.com/joeyutong))*:

  support splitBy function (#6278)

- due to [`fabbf05`](https://github.com/tobymao/sqlglot/commit/fabbf057aba88f30205767d8c339727de45991c8) - Add support for shorthand struct array literals in duckDB. *(PR [#6233](https://github.com/tobymao/sqlglot/pull/6233) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Add support for shorthand struct array literals in duckDB. (#6233)

- due to [`c02b64c`](https://github.com/tobymao/sqlglot/commit/c02b64c3524dd074c2108baaca668ab2607ac843) - Handle pseudocolumns differently than columns *(PR [#6273](https://github.com/tobymao/sqlglot/pull/6273) by [@VaggelisD](https://github.com/VaggelisD))*:

  Handle pseudocolumns differently than columns (#6273)

- due to [`05c5181`](https://github.com/tobymao/sqlglot/commit/05c5181b36a7ada32b96fc91bdfbf73b38a1a408) - refactor `Connector` simplification to factor in types *(PR [#6152](https://github.com/tobymao/sqlglot/pull/6152) by [@geooo109](https://github.com/geooo109))*:

  refactor `Connector` simplification to factor in types (#6152)

- due to [`9c1a222`](https://github.com/tobymao/sqlglot/commit/9c1a2221b0327ba6848542c7b906e92f25a05bea) - add type annotation for BITMAP_CONSTRUCT_AGG function. *(PR [#6285](https://github.com/tobymao/sqlglot/pull/6285) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add type annotation for BITMAP_CONSTRUCT_AGG function. (#6285)

- due to [`cb0bcff`](https://github.com/tobymao/sqlglot/commit/cb0bcff310e9acdf806fc98e99cb9938b747c771) - cast UUID() output to varchar when source dialect UUID() returns string *(PR [#6284](https://github.com/tobymao/sqlglot/pull/6284) by [@toriwei](https://github.com/toriwei))*:

  cast UUID() output to varchar when source dialect UUID() returns string (#6284)

- due to [`358105d`](https://github.com/tobymao/sqlglot/commit/358105d1296c7425e071ccf3189a31a02c00c923) - type annotation for BITMAP_BIT_POSITION function *(PR [#6301](https://github.com/tobymao/sqlglot/pull/6301) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  type annotation for BITMAP_BIT_POSITION function (#6301)

- due to [`4ee7a50`](https://github.com/tobymao/sqlglot/commit/4ee7a500cc460b6f6a1ed103a12dca72e6d01c18) - type inference for BITMAP_OR_AGG *(PR [#6297](https://github.com/tobymao/sqlglot/pull/6297) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  type inference for BITMAP_OR_AGG (#6297)

- due to [`fcd537d`](https://github.com/tobymao/sqlglot/commit/fcd537de2c993ad0bd18acd84dbae354165f7d3f) - conflict resolution. type annotation for BITMAP_BUCKET_NUMBER function. Tests added all dialects that support BITMAP_BUCKET_NUMBER *(PR [#6299](https://github.com/tobymao/sqlglot/pull/6299) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  conflict resolution. type annotation for BITMAP_BUCKET_NUMBER function. Tests added all dialects that support BITMAP_BUCKET_NUMBER (#6299)

- due to [`3dffd59`](https://github.com/tobymao/sqlglot/commit/3dffd598496a9f2d94caec9d7f3dcb9791c94019) - annotate types for PERCENTILE_DISC and WithinGroup *(PR [#6300](https://github.com/tobymao/sqlglot/pull/6300) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for PERCENTILE_DISC and WithinGroup (#6300)

- due to [`f9287f7`](https://github.com/tobymao/sqlglot/commit/f9287f7d596a6d8a1e1cd2c48978a4dec77a96cb) - robust deduplication of connectors *(PR [#6296](https://github.com/tobymao/sqlglot/pull/6296) by [@geooo109](https://github.com/geooo109))*:

  robust deduplication of connectors (#6296)

- due to [`ea0ea79`](https://github.com/tobymao/sqlglot/commit/ea0ea79c1c611b62c79f82f744fe0c98803598a3) - Parse `LIKE` functions *(PR [#6314](https://github.com/tobymao/sqlglot/pull/6314) by [@VaggelisD](https://github.com/VaggelisD))*:

  Parse `LIKE` functions (#6314)

- due to [`e903883`](https://github.com/tobymao/sqlglot/commit/e90388328fcf5b8061c99e325b87d5beb0046ffc) - type annotation for APPROX_TOP_K_ACCUMULATE functio… *(PR [#6309](https://github.com/tobymao/sqlglot/pull/6309) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  type annotation for APPROX_TOP_K_ACCUMULATE functio… (#6309)

- due to [`d3fefad`](https://github.com/tobymao/sqlglot/commit/d3fefad80d25ff5a6dd02426667ff0ea8478a1b2) - support `DATEDIFF_BIG` *(PR [#6323](https://github.com/tobymao/sqlglot/pull/6323) by [@lBilali](https://github.com/lBilali))*:

  support `DATEDIFF_BIG` (#6323)

- due to [`21d1468`](https://github.com/tobymao/sqlglot/commit/21d1468377b9c8ad48c6cca1ae3b3744a807c29e) - annotate type for APPROX_TOP_K *(PR [#6286](https://github.com/tobymao/sqlglot/pull/6286) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for APPROX_TOP_K (#6286)

- due to [`85ddcc5`](https://github.com/tobymao/sqlglot/commit/85ddcc5eca22ac726582de454f2f12b9d4877634) - Do not normalize JSON fields in dot notation *(PR [#6320](https://github.com/tobymao/sqlglot/pull/6320) by [@VaggelisD](https://github.com/VaggelisD))*:

  Do not normalize JSON fields in dot notation (#6320)

- due to [`933e981`](https://github.com/tobymao/sqlglot/commit/933e98102fb39d24ae0350da13337d981287130a) - more robust NULL reduction *(PR [#6327](https://github.com/tobymao/sqlglot/pull/6327) by [@geooo109](https://github.com/geooo109))*:

  more robust NULL reduction (#6327)

- due to [`e4d1a4f`](https://github.com/tobymao/sqlglot/commit/e4d1a4fcd6741d679c5444bf023077d2aaa8f980) - map date/timestamp `TRUNC` to `DATE_TRUNC` *(PR [#6328](https://github.com/tobymao/sqlglot/pull/6328) by [@nnamdi16](https://github.com/nnamdi16))*:

  map date/timestamp `TRUNC` to `DATE_TRUNC` (#6328)

- due to [`e1b6558`](https://github.com/tobymao/sqlglot/commit/e1b6558cb1a860bbd695f25b66e52064b57c0a84) - handle all datepart alternatives *(PR [#6324](https://github.com/tobymao/sqlglot/pull/6324) by [@lBilali](https://github.com/lBilali))*:

  handle all datepart alternatives (#6324)

- due to [`06daa47`](https://github.com/tobymao/sqlglot/commit/06daa47dedebac672548e1db230b89f5c9eae84e) - update annotated type of ARRAY_AGG to untyped array *(PR [#6347](https://github.com/tobymao/sqlglot/pull/6347) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  update annotated type of ARRAY_AGG to untyped array (#6347)

- due to [`7484c06`](https://github.com/tobymao/sqlglot/commit/7484c06be4534cd22dee14da542d5e29ff2c13a2) - Support rounding mode argument for ROUND function *(PR [#6350](https://github.com/tobymao/sqlglot/pull/6350) by [@vchan](https://github.com/vchan))*:

  Support rounding mode argument for ROUND function (#6350)

- due to [`c495a40`](https://github.com/tobymao/sqlglot/commit/c495a40ee4c1a69b14892e8455ae1bd2ceb5ea4f) - annotate type for MINHASH *(PR [#6355](https://github.com/tobymao/sqlglot/pull/6355) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for MINHASH (#6355)

- due to [`b1f9a97`](https://github.com/tobymao/sqlglot/commit/b1f9a976be3c0bcd895bef5bcdb95a013eeb28b7) - annotate type for APPROXIMATE_SIMILARITY *(PR [#6360](https://github.com/tobymao/sqlglot/pull/6360) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for APPROXIMATE_SIMILARITY (#6360)

- due to [`3aafca7`](https://github.com/tobymao/sqlglot/commit/3aafca74546b932cea93ed830c021f347ae03ded) - annotate type for MINHASH_COMBINE *(PR [#6362](https://github.com/tobymao/sqlglot/pull/6362) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for MINHASH_COMBINE (#6362)

- due to [`df13a65`](https://github.com/tobymao/sqlglot/commit/df13a655646bd2ef5d8b4613670bb5fe48845b73) - unnest deep stuff *(PR [#6366](https://github.com/tobymao/sqlglot/pull/6366) by [@tobymao](https://github.com/tobymao))*:

  unnest deep stuff (#6366)

- due to [`d4c2256`](https://github.com/tobymao/sqlglot/commit/d4c2256fb493ed2f16c29694ae5c31517123d419) - at time zone precedence *(PR [#6383](https://github.com/tobymao/sqlglot/pull/6383) by [@geooo109](https://github.com/geooo109))*:

  at time zone precedence (#6383)

- due to [`4fb4d08`](https://github.com/tobymao/sqlglot/commit/4fb4d08ef8896bda434d4f89c21c669c6146fd02) - properly support table alias in the `INSERT` DML *(PR [#6374](https://github.com/tobymao/sqlglot/pull/6374) by [@snovik75](https://github.com/snovik75))*:

  properly support table alias in the `INSERT` DML (#6374)

- due to [`bf07abd`](https://github.com/tobymao/sqlglot/commit/bf07abd4ee9eb0f5510cb7d1f232bdcaea88941e) - annotation support for  APPROX_TOP_K_COMBINE  *(PR [#6378](https://github.com/tobymao/sqlglot/pull/6378) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for  APPROX_TOP_K_COMBINE  (#6378)

- due to [`50348ac`](https://github.com/tobymao/sqlglot/commit/50348ac31f784aa97bd09d5d6c6613fbd68402ee) - support order by clause for mysql delete statement *(PR [#6381](https://github.com/tobymao/sqlglot/pull/6381) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  support order by clause for mysql delete statement (#6381)

- due to [`21d3859`](https://github.com/tobymao/sqlglot/commit/21d38590fec6cb55a1a03aeb2621bd9fca677496) - Disable STRING_AGG sep canonicalization *(PR [#6395](https://github.com/tobymao/sqlglot/pull/6395) by [@VaggelisD](https://github.com/VaggelisD))*:

  Disable STRING_AGG sep canonicalization (#6395)

- due to [`95727f6`](https://github.com/tobymao/sqlglot/commit/95727f60d601796b34c850dee9366d79f6e4a24b) - canonicalize table aliases *(PR [#6369](https://github.com/tobymao/sqlglot/pull/6369) by [@georgesittas](https://github.com/georgesittas))*:

  canonicalize table aliases (#6369)

- due to [`c7cb098`](https://github.com/tobymao/sqlglot/commit/c7cb0983a0fa463c43d2c4ee925816e9a1628c79) - Fix underscore separator with scientific notation *(PR [#6401](https://github.com/tobymao/sqlglot/pull/6401) by [@VaggelisD](https://github.com/VaggelisD))*:

  Fix underscore separator with scientific notation (#6401)

- due to [`bb4eda1`](https://github.com/tobymao/sqlglot/commit/bb4eda1beb68b92de9ab014a63c67797a07df2fa) - support transpiling SHA1 from BigQuery to DuckDB *(PR [#6404](https://github.com/tobymao/sqlglot/pull/6404) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpiling SHA1 from BigQuery to DuckDB (#6404)

- due to [`d038ad7`](https://github.com/tobymao/sqlglot/commit/d038ad7f036a140f3eae4bdde15824437d4e44ee) - support named primary keys for mysql *(PR [#6389](https://github.com/tobymao/sqlglot/pull/6389) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  support named primary keys for mysql (#6389)

- due to [`05e83b5`](https://github.com/tobymao/sqlglot/commit/05e83b56f1bf9323cfa819a7f1beb542524c1219) - support transpilation of LEAST from BigQuery to DuckDB *(PR [#6415](https://github.com/tobymao/sqlglot/pull/6415) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation of LEAST from BigQuery to DuckDB (#6415)

- due to [`4f3bb0d`](https://github.com/tobymao/sqlglot/commit/4f3bb0d6714bf89ff72e13e1398d8f01cefafb00) - Correct transpilation of BigQuery's JSON_EXTRACT_SCALAR… *(PR [#6414](https://github.com/tobymao/sqlglot/pull/6414) by [@vchan](https://github.com/vchan))*:

  Correct transpilation of BigQuery's JSON_EXTRACT_SCALAR… (#6414)

- due to [`8c314a8`](https://github.com/tobymao/sqlglot/commit/8c314a8b457a5c3ed470ac8fcff022fec881c248) - support cte pivot for duckdb *(PR [#6413](https://github.com/tobymao/sqlglot/pull/6413) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  support cte pivot for duckdb (#6413)

- due to [`c6b0a63`](https://github.com/tobymao/sqlglot/commit/c6b0a6342a21d79635a26d40001c916d05d47cf7) - change version to be a tuple so that it can be pickled, also simpler *(commit by [@tobymao](https://github.com/tobymao))*:

  change version to be a tuple so that it can be pickled, also simpler

- due to [`07d9958`](https://github.com/tobymao/sqlglot/commit/07d99583b4aebdc682bb7604ccdf45bddb89f9c3) - replace direct comparison with dialect properties *(PR [#6398](https://github.com/tobymao/sqlglot/pull/6398) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  replace direct comparison with dialect properties (#6398)

- due to [`38472ce`](https://github.com/tobymao/sqlglot/commit/38472ce14bce731ba4c309d515223ae99e2575ac) - transpile bigquery's %x format literal *(PR [#6375](https://github.com/tobymao/sqlglot/pull/6375) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  transpile bigquery's %x format literal (#6375)

- due to [`92ee124`](https://github.com/tobymao/sqlglot/commit/92ee1241ea3088d4e63c094404252339c54ad0c1) - postgres qualify GENERATE_SERIES and table projection *(PR [#6373](https://github.com/tobymao/sqlglot/pull/6373) by [@geooo109](https://github.com/geooo109))*:

  postgres qualify GENERATE_SERIES and table projection (#6373)

- due to [`0b9d8ac`](https://github.com/tobymao/sqlglot/commit/0b9d8acbe75457424436e8c0acc047ab66e9fdc0) - Annotate type for snowflake MAX function *(PR [#6422](https://github.com/tobymao/sqlglot/pull/6422) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for snowflake MAX function (#6422)

- due to [`68e9414`](https://github.com/tobymao/sqlglot/commit/68e9414725a60b2842d870fa222d8466057a94f6) - Annotate type for snowflake MIN function *(PR [#6427](https://github.com/tobymao/sqlglot/pull/6427) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  Annotate type for snowflake MIN function (#6427)

- due to [`1318de7`](https://github.com/tobymao/sqlglot/commit/1318de77a8aa514ec7eb9f9b8c03228e3f8eb008) - Annotate type for snowflake NORMAL *(PR [#6434](https://github.com/tobymao/sqlglot/pull/6434) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for snowflake NORMAL (#6434)

- due to [`ffbb5c7`](https://github.com/tobymao/sqlglot/commit/ffbb5c7e40aa064ffcd4827e96ea66cfd045118e) - annotate type for HASH_AGG in Snowflake *(PR [#6438](https://github.com/tobymao/sqlglot/pull/6438) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate type for HASH_AGG in Snowflake (#6438)

- due to [`161255f`](https://github.com/tobymao/sqlglot/commit/161255f6c90b9c3ed2074e734f6d074db1d7a6dd) - Add support for `LOCALTIME` function *(PR [#6443](https://github.com/tobymao/sqlglot/pull/6443) by [@VaggelisD](https://github.com/VaggelisD))*:

  Add support for `LOCALTIME` function (#6443)

- due to [`ca329f0`](https://github.com/tobymao/sqlglot/commit/ca329f037a230c315437d830638b514190764c5a) - support transpilation of SHA256 from bigquery to duckdb *(PR [#6421](https://github.com/tobymao/sqlglot/pull/6421) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation of SHA256 from bigquery to duckdb (#6421)

- due to [`e18ae24`](https://github.com/tobymao/sqlglot/commit/e18ae248423dbbca78a24a60ea0193da2ee7f68c) - Annotate type for snowflake REGR_SLOPE function *(PR [#6425](https://github.com/tobymao/sqlglot/pull/6425) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for snowflake REGR_SLOPE function (#6425)

- due to [`1d847f0`](https://github.com/tobymao/sqlglot/commit/1d847f0a1f88fce5df340ab646a72c8abbc12a86) - parse & annotate `CHECK_JSON`, `CHECK_XML` *(PR [#6439](https://github.com/tobymao/sqlglot/pull/6439) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  parse & annotate `CHECK_JSON`, `CHECK_XML` (#6439)

- due to [`cb3080d`](https://github.com/tobymao/sqlglot/commit/cb3080d4bed18b1bfbbd08380ed60deeefd15530) - annotation support for APPROX_TOP_K_ESTIMATE . Return type ARRAY *(PR [#6445](https://github.com/tobymao/sqlglot/pull/6445) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for APPROX_TOP_K_ESTIMATE . Return type ARRAY (#6445)

- due to [`313afe5`](https://github.com/tobymao/sqlglot/commit/313afe540aa2cdc4cc179c4852c6ef37362bcb3e) - annotate type for snowflake func ARRAY_UNION_AGG *(PR [#6446](https://github.com/tobymao/sqlglot/pull/6446) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for snowflake func ARRAY_UNION_AGG (#6446)

- due to [`cd9f037`](https://github.com/tobymao/sqlglot/commit/cd9f037882eef253e86fdb1d51521e0acd7db3f9) - store pk name if provided *(PR [#6424](https://github.com/tobymao/sqlglot/pull/6424) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  store pk name if provided (#6424)

- due to [`65194e4`](https://github.com/tobymao/sqlglot/commit/65194e465489151aa51859a6e3f5672f7d4c5f3b) - Annotate type for snowflake RANDSTR function *(PR [#6436](https://github.com/tobymao/sqlglot/pull/6436) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for snowflake RANDSTR function (#6436)

- due to [`a56262e`](https://github.com/tobymao/sqlglot/commit/a56262e6b4276baae144855478807c173db77ab9) - Annotate type for snowflake MEDIAN *(PR [#6426](https://github.com/tobymao/sqlglot/pull/6426) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  Annotate type for snowflake MEDIAN (#6426)

- due to [`2c56567`](https://github.com/tobymao/sqlglot/commit/2c56567755c8a6571d8b7d410c9de943e54df58b) - Annotate type for snowflake SEARCH_IP  *(PR [#6440](https://github.com/tobymao/sqlglot/pull/6440) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for snowflake SEARCH_IP  (#6440)

- due to [`ac86568`](https://github.com/tobymao/sqlglot/commit/ac86568a939f692b99813da100297b61fb54e044) - Added decfloat type *(PR [#6444](https://github.com/tobymao/sqlglot/pull/6444) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Added decfloat type (#6444)

- due to [`b321ca6`](https://github.com/tobymao/sqlglot/commit/b321ca6191fefc88da1a6de83a465886b5754b7a) - bump sqlglotrs to 0.8.0 *(commit by [@georgesittas](https://github.com/georgesittas))*:

  bump sqlglotrs to 0.8.0

- due to [`ebe718a`](https://github.com/tobymao/sqlglot/commit/ebe718a72d5b5871a8d6e67754ff50e873d55b41) - Add support for format elements used in date/time functions like FORMAT_DATETIME *(PR [#6428](https://github.com/tobymao/sqlglot/pull/6428) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Add support for format elements used in date/time functions like FORMAT_DATETIME (#6428)

- due to [`c111f64`](https://github.com/tobymao/sqlglot/commit/c111f643d61064280024b4cc5c0fc250581fbe55) - annotation support for APPROX_PERCENTILE_ACCUMULATE *(PR [#6455](https://github.com/tobymao/sqlglot/pull/6455) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for APPROX_PERCENTILE_ACCUMULATE (#6455)

- due to [`f305305`](https://github.com/tobymao/sqlglot/commit/f305305e5cf3ef45afba822542aebeb944c00e0b) - Annotate types for BigQuery's AVG function *(PR [#6459](https://github.com/tobymao/sqlglot/pull/6459) by [@vchan](https://github.com/vchan))*:

  Annotate types for BigQuery's AVG function (#6459)

- due to [`910349f`](https://github.com/tobymao/sqlglot/commit/910349f3c30af59ce1820e48cae0cbb77539877d) - Annotate types for BigQuery's SAFE_DIVIDE function *(PR [#6464](https://github.com/tobymao/sqlglot/pull/6464) by [@vchan](https://github.com/vchan))*:

  Annotate types for BigQuery's SAFE_DIVIDE function (#6464)

- due to [`5e75621`](https://github.com/tobymao/sqlglot/commit/5e75621e90defd50076383485f6a4689a8c551ac) - annotate type for snowflake func ARRAY_UNIQUE_AGG *(PR [#6465](https://github.com/tobymao/sqlglot/pull/6465) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for snowflake func ARRAY_UNIQUE_AGG (#6465)

- due to [`94d46b8`](https://github.com/tobymao/sqlglot/commit/94d46b8eafd5abe252407d2bbe306ca579a29b20) - annotation support for APPROX_PERCENTILE_ESTIMATE. Return type DOUBLE *(PR [#6461](https://github.com/tobymao/sqlglot/pull/6461) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for APPROX_PERCENTILE_ESTIMATE. Return type DOUBLE (#6461)

- due to [`2ac30b0`](https://github.com/tobymao/sqlglot/commit/2ac30b08bd663bbaf00ae075c4db0c3d27ab6640) - annotation support for APPROX_PERCENTILE_COMBINE *(PR [#6460](https://github.com/tobymao/sqlglot/pull/6460) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for APPROX_PERCENTILE_COMBINE (#6460)

- due to [`d44bda3`](https://github.com/tobymao/sqlglot/commit/d44bda376c06956947a09a9f279cce886a63b981) - Annotate type for ZIPF *(PR [#6453](https://github.com/tobymao/sqlglot/pull/6453) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for ZIPF (#6453)

- due to [`34dbd47`](https://github.com/tobymao/sqlglot/commit/34dbd478957c1796998d0b263f63c8ce1db7a320) - Annotate type for XMLGET *(PR [#6457](https://github.com/tobymao/sqlglot/pull/6457) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for XMLGET (#6457)

- due to [`0d211f2`](https://github.com/tobymao/sqlglot/commit/0d211f2b36167cfb7856b8ec25f597f70317a9c7) - annotate type for MODE function snowflake *(PR [#6447](https://github.com/tobymao/sqlglot/pull/6447) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate type for MODE function snowflake (#6447)

- due to [`cc4c8ab`](https://github.com/tobymao/sqlglot/commit/cc4c8ab43ab71790bc2bb9f8f3c06e34f89f999f) - annotate type for PERCENTILE_CONT in Snowflake *(PR [#6470](https://github.com/tobymao/sqlglot/pull/6470) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate type for PERCENTILE_CONT in Snowflake (#6470)

- due to [`7dbc242`](https://github.com/tobymao/sqlglot/commit/7dbc242a637a8890511cc14f22bce4d425f1f55d) - annotation support for CURRENT REGION. Return type VARCHAR *(PR [#6473](https://github.com/tobymao/sqlglot/pull/6473) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT REGION. Return type VARCHAR (#6473)

- due to [`43a6a5c`](https://github.com/tobymao/sqlglot/commit/43a6a5c601421e15a7f94dd489cb4fbcf9d2c8c3) - annotation support for CURRENT_ORGANIZATION_NAME. Return type VARCHAR *(PR [#6475](https://github.com/tobymao/sqlglot/pull/6475) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_ORGANIZATION_NAME. Return type VARCHAR (#6475)

- due to [`f1f7c6a`](https://github.com/tobymao/sqlglot/commit/f1f7c6ae6b6aa3f6f2251d0f81ee667440ca53d1) - annotation support for CURRENT_ORGANIZATION_USER. *(PR [#6476](https://github.com/tobymao/sqlglot/pull/6476) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_ORGANIZATION_USER. (#6476)

- due to [`88dfd26`](https://github.com/tobymao/sqlglot/commit/88dfd26b832d13e517fe7c18d2c086885bf4954d) - annotate type for snowflake func TO_BINARY *(PR [#6474](https://github.com/tobymao/sqlglot/pull/6474) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for snowflake func TO_BINARY (#6474)

- due to [`d268203`](https://github.com/tobymao/sqlglot/commit/d268203e1dbae4e3aff863108f6d09a6f8274db5) - annotation support for CURRENT_ROLE_TYPE *(PR [#6479](https://github.com/tobymao/sqlglot/pull/6479) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_ROLE_TYPE (#6479)

- due to [`fd4431b`](https://github.com/tobymao/sqlglot/commit/fd4431bf9550c03aa761c642a68a21a146fd8548) - annotate type for VECTOR_L1_DISTANCE, VECTOR_L2_DISTANCE, VECTOR_COSINE_SIMILARITY functions *(PR [#6468](https://github.com/tobymao/sqlglot/pull/6468) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  annotate type for VECTOR_L1_DISTANCE, VECTOR_L2_DISTANCE, VECTOR_COSINE_SIMILARITY functions (#6468)

- due to [`e6adba7`](https://github.com/tobymao/sqlglot/commit/e6adba76cc2f27633a9d38bfaea3356e71d00a4c) - Add support for coercing STRING literals to temporal types *(PR [#6482](https://github.com/tobymao/sqlglot/pull/6482) by [@vchan](https://github.com/vchan))*:

  Add support for coercing STRING literals to temporal types (#6482)

- due to [`68a5e61`](https://github.com/tobymao/sqlglot/commit/68a5e615b24e518cb90c9b80cf25355fcabdb468) - annotate type for REGR_* functions *(PR [#6452](https://github.com/tobymao/sqlglot/pull/6452) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  annotate type for REGR_* functions (#6452)

- due to [`f7458a4`](https://github.com/tobymao/sqlglot/commit/f7458a40d3b09a2e212f6705ac4a77c99714508e) - annotate type for snowflake func TO_BOOLEAN *(PR [#6481](https://github.com/tobymao/sqlglot/pull/6481) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for snowflake func TO_BOOLEAN (#6481)

- due to [`1531a67`](https://github.com/tobymao/sqlglot/commit/1531a67ac7806f3b4582f6cf1ea02342a517de74) - annotate type for VECTOR_INNER_PRODUCT *(PR [#6486](https://github.com/tobymao/sqlglot/pull/6486) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  annotate type for VECTOR_INNER_PRODUCT (#6486)

- due to [`df4c1d3`](https://github.com/tobymao/sqlglot/commit/df4c1d37ff77151a74b5de3d119c7e03f5db85f4) - REGEXP_EXTRACT position arg overflow *(PR [#6458](https://github.com/tobymao/sqlglot/pull/6458) by [@treysp](https://github.com/treysp))*:

  REGEXP_EXTRACT position arg overflow (#6458)

- due to [`f6b2b3b`](https://github.com/tobymao/sqlglot/commit/f6b2b3bc6e1c95340149be65d80ef7e177b28d82) - support padside argument for BIT[OR|AND|XOR] *(PR [#6487](https://github.com/tobymao/sqlglot/pull/6487) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support padside argument for BIT[OR|AND|XOR] (#6487)

- due to [`5a49c3f`](https://github.com/tobymao/sqlglot/commit/5a49c3f7a7619ad9e711ff2cd9e85b8606969b36) - support ORDER / LIMIT expressions for BigQuery ARRAY_AGG / STRING_AGG functions *(PR [#6463](https://github.com/tobymao/sqlglot/pull/6463) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  support ORDER / LIMIT expressions for BigQuery ARRAY_AGG / STRING_AGG functions (#6463)

- due to [`ef130f1`](https://github.com/tobymao/sqlglot/commit/ef130f1b944b4be835d4a6831fec9a333a825a34) - Annotated type for ARRAY_CONSTRUCT_COMPACT [#6496](https://github.com/tobymao/sqlglot/pull/6496) *(commit by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotated type for ARRAY_CONSTRUCT_COMPACT #6496

- due to [`1b6076b`](https://github.com/tobymao/sqlglot/commit/1b6076bd5a64b044f52f5366244ba0746aca75e1) - wrap connectives generated due to transpiling LIKE ANY closes [#6493](https://github.com/tobymao/sqlglot/pull/6493) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  wrap connectives generated due to transpiling LIKE ANY closes #6493

- due to [`36ad534`](https://github.com/tobymao/sqlglot/commit/36ad534b14eabe9ee197017f5087e8e5190f8526) - qualified select list with "LOCAL" *(PR [#6450](https://github.com/tobymao/sqlglot/pull/6450) by [@nnamdi16](https://github.com/nnamdi16))*:

  qualified select list with "LOCAL" (#6450)

- due to [`36cf0bf`](https://github.com/tobymao/sqlglot/commit/36cf0bf6671f622344afee52d7aafe30f19ecf9a) - annotation support for CURRENT_ROLE. *(PR [#6478](https://github.com/tobymao/sqlglot/pull/6478) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_ROLE. (#6478)

- due to [`cbba04c`](https://github.com/tobymao/sqlglot/commit/cbba04cb292fe8b3fd38c87d9ccb624cdcb52843) - support comma-separated syntax for OVERLAY function *(PR [#6497](https://github.com/tobymao/sqlglot/pull/6497) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  support comma-separated syntax for OVERLAY function (#6497)

- due to [`dc8f26a`](https://github.com/tobymao/sqlglot/commit/dc8f26a3a5e023a0e54caa345b129fb1b4fe805f) - bq annotate type for NULL *(PR [#6491](https://github.com/tobymao/sqlglot/pull/6491) by [@geooo109](https://github.com/geooo109))*:

  bq annotate type for NULL (#6491)

- due to [`52aceaa`](https://github.com/tobymao/sqlglot/commit/52aceaaa887dddb35f8ede5c2d9577fdeee35c48) - annotate `HavingMax` by `this` *(PR [#6499](https://github.com/tobymao/sqlglot/pull/6499) by [@georgesittas](https://github.com/georgesittas))*:

  annotate `HavingMax` by `this` (#6499)

- due to [`c97a81d`](https://github.com/tobymao/sqlglot/commit/c97a81d68a1584fad48475725665a7678fcad9d1) - annotate TO_HEX(MD5(...)) in BigQuery *(PR [#6500](https://github.com/tobymao/sqlglot/pull/6500) by [@georgesittas](https://github.com/georgesittas))*:

  annotate TO_HEX(MD5(...)) in BigQuery (#6500)

- due to [`a5797a1`](https://github.com/tobymao/sqlglot/commit/a5797a1c867c4ade71ae4ddf93232576993cf5bc) - handle named arguments and non-integer scale input for ROUND *(PR [#6495](https://github.com/tobymao/sqlglot/pull/6495) by [@toriwei](https://github.com/toriwei))*:

  handle named arguments and non-integer scale input for ROUND (#6495)

- due to [`3224235`](https://github.com/tobymao/sqlglot/commit/3224235c1b7a80511af11f7dbffe608a747a3df0) - make CTE builder produce AST consistent with parser closes [#6503](https://github.com/tobymao/sqlglot/pull/6503) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  make CTE builder produce AST consistent with parser closes #6503

- due to [`8b5298a`](https://github.com/tobymao/sqlglot/commit/8b5298a6578af80fd9676eb222422862d5468859) - Transpile BQ's WEEK based `DATE_DIFF` *(PR [#6507](https://github.com/tobymao/sqlglot/pull/6507) by [@VaggelisD](https://github.com/VaggelisD))*:

  Transpile BQ's WEEK based `DATE_DIFF` (#6507)

- due to [`9454a18`](https://github.com/tobymao/sqlglot/commit/9454a18cca41a510e61522f6b785d646980e2100) - uppercase join method, side, kind for consistency fixes [#6510](https://github.com/tobymao/sqlglot/pull/6510) *(PR [#6511](https://github.com/tobymao/sqlglot/pull/6511) by [@georgesittas](https://github.com/georgesittas))*:

  uppercase join method, side, kind for consistency fixes #6510 (#6511)

- due to [`41b776b`](https://github.com/tobymao/sqlglot/commit/41b776bdc6936f18accd9f7308b55acd383bb596) - added support for current_catalog *(PR [#6492](https://github.com/tobymao/sqlglot/pull/6492) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  added support for current_catalog (#6492)

- due to [`dd19bea`](https://github.com/tobymao/sqlglot/commit/dd19beae95f077cfd8b6e315eca7ff212817b250) - annotation support for CURRENT_ACCOUNT *(PR [#6512](https://github.com/tobymao/sqlglot/pull/6512) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_ACCOUNT (#6512)

- due to [`2e8105e`](https://github.com/tobymao/sqlglot/commit/2e8105eebaec25fc8f94f1e68951198660f404e1) - Annotate type for VAR_POP, VAR_SAMP, DuckDB consistency fix for VAR_SAMP *(PR [#6488](https://github.com/tobymao/sqlglot/pull/6488) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for VAR_POP, VAR_SAMP, DuckDB consistency fix for VAR_SAMP (#6488)

- due to [`cfb02c1`](https://github.com/tobymao/sqlglot/commit/cfb02c1aa676e801b2d13a84467b4904cd834ffe) - annotation support for CURRENT_ACCOUNT_NAME *(PR [#6513](https://github.com/tobymao/sqlglot/pull/6513) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_ACCOUNT_NAME (#6513)

- due to [`1004e31`](https://github.com/tobymao/sqlglot/commit/1004e31cce62cce2e2afb7eab85ed8bdecaede3b) - annotation support for CURRENT_AVAILABLE_ROLES *(PR [#6514](https://github.com/tobymao/sqlglot/pull/6514) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_AVAILABLE_ROLES (#6514)

- due to [`ff201fe`](https://github.com/tobymao/sqlglot/commit/ff201febd27937a97674dd091928456dde733254) - annotation support for CURRENT_CLIENT *(PR [#6515](https://github.com/tobymao/sqlglot/pull/6515) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_CLIENT (#6515)

- due to [`d777a9c`](https://github.com/tobymao/sqlglot/commit/d777a9c0feef15ac036f7b413112de4d7cc8bea4) - annotation support for CURRENT_IP_ADDRESS *(PR [#6518](https://github.com/tobymao/sqlglot/pull/6518) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_IP_ADDRESS (#6518)

- due to [`c296061`](https://github.com/tobymao/sqlglot/commit/c2960615a3bd279b7c5f775d5b93ae12aa27a3b8) - Transpilation of TO_BINARY from snowflake to duckdb *(PR [#6504](https://github.com/tobymao/sqlglot/pull/6504) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  Transpilation of TO_BINARY from snowflake to duckdb (#6504)

- due to [`7a70164`](https://github.com/tobymao/sqlglot/commit/7a70164d8cf361cf4c0a7d5789bb51676f772959) - transpile Snowflake's `RANDSTR` function *(PR [#6502](https://github.com/tobymao/sqlglot/pull/6502) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  transpile Snowflake's `RANDSTR` function (#6502)

- due to [`a26d419`](https://github.com/tobymao/sqlglot/commit/a26d4191e5468e39eafdf7a981e7b890d438b2c9) - annotation support for CURRENT_DATABASE *(PR [#6516](https://github.com/tobymao/sqlglot/pull/6516) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_DATABASE (#6516)

- due to [`0acdf7f`](https://github.com/tobymao/sqlglot/commit/0acdf7fc783f2722536ec24dcf8600957febf7ca) - annotation support for CURRENT_SCHEMAS *(PR [#6519](https://github.com/tobymao/sqlglot/pull/6519) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_SCHEMAS (#6519)

- due to [`43cce89`](https://github.com/tobymao/sqlglot/commit/43cce895da80d21abc89d40de5d7fddd68871bf0) - annotation support for CURRENT_SECONDARY_ROLES *(PR [#6520](https://github.com/tobymao/sqlglot/pull/6520) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_SECONDARY_ROLES (#6520)

- due to [`c21b4b1`](https://github.com/tobymao/sqlglot/commit/c21b4b1134b368ee5144339b59e70ddcc54f3dbc) - annotation support for CURRENT_SESSION *(PR [#6521](https://github.com/tobymao/sqlglot/pull/6521) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_SESSION (#6521)

- due to [`57a83c0`](https://github.com/tobymao/sqlglot/commit/57a83c018dace690f7bb363c25ee6bde33c3d60f) - annotation support for CURRENT_STATEMENT *(PR [#6522](https://github.com/tobymao/sqlglot/pull/6522) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_STATEMENT (#6522)

- due to [`4b240e4`](https://github.com/tobymao/sqlglot/commit/4b240e40a8809a6eea2a279370a884f4a7b03dfa) - annotation support for CURRENT_VERSION *(PR [#6524](https://github.com/tobymao/sqlglot/pull/6524) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_VERSION (#6524)

- due to [`c1a831f`](https://github.com/tobymao/sqlglot/commit/c1a831f5bf662ab8d8e07dc2bb949f2adcbe7d7c) - annotation support for CURRENT_TRANSACTION *(PR [#6523](https://github.com/tobymao/sqlglot/pull/6523) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_TRANSACTION (#6523)

- due to [`2e162b0`](https://github.com/tobymao/sqlglot/commit/2e162b0d34066e7aa7edac3156739bcd31a634fc) - annotation support for CURRENT_WAREHOUSE *(PR [#6525](https://github.com/tobymao/sqlglot/pull/6525) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_WAREHOUSE (#6525)

- due to [`9d06859`](https://github.com/tobymao/sqlglot/commit/9d0685923209c04747fa6fa2b35ee2e516453abc) - annotate bigquery ARRAY when arg contains set operations *(PR [#6517](https://github.com/tobymao/sqlglot/pull/6517) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate bigquery ARRAY when arg contains set operations (#6517)

- due to [`2fd14ed`](https://github.com/tobymao/sqlglot/commit/2fd14ed32b3793444405005fb98342222b4d7956) - query schema directly when type annotation fails for processing UNNEST source *(PR [#6451](https://github.com/tobymao/sqlglot/pull/6451) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  query schema directly when type annotation fails for processing UNNEST source (#6451)

- due to [`41a9e88`](https://github.com/tobymao/sqlglot/commit/41a9e88bb9800205df0b3e10a1976699dc4fe4f9) - Add support to transpile binary args for bitwise operators *(PR [#6508](https://github.com/tobymao/sqlglot/pull/6508) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Add support to transpile binary args for bitwise operators (#6508)

- due to [`06c7ffb`](https://github.com/tobymao/sqlglot/commit/06c7ffbe14985a4da35a97d47322021e79525adf) - cleanup bitwise operator fixes *(commit by [@georgesittas](https://github.com/georgesittas))*:

  cleanup bitwise operator fixes

- due to [`62b348c`](https://github.com/tobymao/sqlglot/commit/62b348ce46d014895bd17d89ccb0b3e186e46d15) - add support for noop string escapes *(PR [#6526](https://github.com/tobymao/sqlglot/pull/6526) by [@nian0114](https://github.com/nian0114))*:

  add support for noop string escapes (#6526)

- due to [`1876c5a`](https://github.com/tobymao/sqlglot/commit/1876c5a86c3b737b7360c4fef25c44dc010b66db) - consolidate can_quote logic and fix an issue with identify=False *(PR [#6534](https://github.com/tobymao/sqlglot/pull/6534) by [@tobymao](https://github.com/tobymao))*:

  consolidate can_quote logic and fix an issue with identify=False (#6534)

- due to [`edb8964`](https://github.com/tobymao/sqlglot/commit/edb8964ed064a687e52323143d52281eaa391c9a) - bump sqlglotrs to 0.9.0 *(commit by [@georgesittas](https://github.com/georgesittas))*:

  bump sqlglotrs to 0.9.0

- due to [`2555856`](https://github.com/tobymao/sqlglot/commit/2555856cac7434ef91cc1584d52610178e45c4b9) - annotate scalar subqueries *(PR [#6536](https://github.com/tobymao/sqlglot/pull/6536) by [@georgesittas](https://github.com/georgesittas))*:

  annotate scalar subqueries (#6536)

- due to [`71e7630`](https://github.com/tobymao/sqlglot/commit/71e763096462aa888a353ac1ad3675a9e5b4841a) - normalize FLOAT to DOUBLE *(PR [#6501](https://github.com/tobymao/sqlglot/pull/6501) by [@toriwei](https://github.com/toriwei))*:

  normalize FLOAT to DOUBLE (#6501)

- due to [`9badf6a`](https://github.com/tobymao/sqlglot/commit/9badf6a6b1972fc37164b29aa416bb897d7ec6a6) - Annotate type for TRY_* functions *(PR [#6509](https://github.com/tobymao/sqlglot/pull/6509) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for TRY_* functions (#6509)

- due to [`aad1332`](https://github.com/tobymao/sqlglot/commit/aad1332fee7c82c29dae3caed9a6a1c882c1d4a0) - support transpilation of BITMAP_BIT_POSITION from snowflake to duckdb *(PR [#6541](https://github.com/tobymao/sqlglot/pull/6541) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  support transpilation of BITMAP_BIT_POSITION from snowflake to duckdb (#6541)

- due to [`f21cf76`](https://github.com/tobymao/sqlglot/commit/f21cf763575b67084ea81a377c5bdb3e86041e4c) - bq annotate SAFE_DIVIDE with both args as INT64 *(PR [#6543](https://github.com/tobymao/sqlglot/pull/6543) by [@geooo109](https://github.com/geooo109))*:

  bq annotate SAFE_DIVIDE with both args as INT64 (#6543)

- due to [`4a57302`](https://github.com/tobymao/sqlglot/commit/4a5730242787920d0a2412aef495eb2eeaaa2119) - ensure structs are annotated as unknown if any argument is unknown *(PR [#6544](https://github.com/tobymao/sqlglot/pull/6544) by [@georgesittas](https://github.com/georgesittas))*:

  ensure structs are annotated as unknown if any argument is unknown (#6544)

- due to [`8a12611`](https://github.com/tobymao/sqlglot/commit/8a12611e9499497d0c8b1e1e418986b2d91a6505) - New type + type annotation for TO_FILE  *(PR [#6548](https://github.com/tobymao/sqlglot/pull/6548) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  New type + type annotation for TO_FILE  (#6548)

- due to [`63a2e49`](https://github.com/tobymao/sqlglot/commit/63a2e49485f237e1c7e16358c412acb5df50e22c) - stop treating `None` args as leaves to be diffed *(PR [#6556](https://github.com/tobymao/sqlglot/pull/6556) by [@georgesittas](https://github.com/georgesittas))*:

  stop treating `None` args as leaves to be diffed (#6556)

- due to [`906c933`](https://github.com/tobymao/sqlglot/commit/906c933235c82598b0d08f8c66dd3db0b8f409a5) - overlap operator *(PR [#6545](https://github.com/tobymao/sqlglot/pull/6545) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  overlap operator (#6545)

- due to [`370b1f6`](https://github.com/tobymao/sqlglot/commit/370b1f621844d3ac8831c998ea2046f1e1b91b65) - add support for session_user *(PR [#6555](https://github.com/tobymao/sqlglot/pull/6555) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  add support for session_user (#6555)

- due to [`dbbace0`](https://github.com/tobymao/sqlglot/commit/dbbace01cd5f1fc44f5ad278def25f547686f9c5) - remove transpilation support of APPROX_TOP_K to duckdb *(PR [#6560](https://github.com/tobymao/sqlglot/pull/6560) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  remove transpilation support of APPROX_TOP_K to duckdb (#6560)

- due to [`2bc2506`](https://github.com/tobymao/sqlglot/commit/2bc2506e0e0b26e82661a08217855d693f30dc25) - support SAFE.TIMESTAMP annotation *(PR [#6550](https://github.com/tobymao/sqlglot/pull/6550) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  support SAFE.TIMESTAMP annotation (#6550)

- due to [`a51cc7b`](https://github.com/tobymao/sqlglot/commit/a51cc7b6e02c5b37bf43b82a0d76b83d41248ac9) - elt function in mysql *(PR [#6568](https://github.com/tobymao/sqlglot/pull/6568) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  elt function in mysql (#6568)

- due to [`14dc1e5`](https://github.com/tobymao/sqlglot/commit/14dc1e5bc74b3b8907ba02bf89ad1763940c9ea2) - make `DATE_PART` roundtrip *(PR [#6573](https://github.com/tobymao/sqlglot/pull/6573) by [@georgesittas](https://github.com/georgesittas))*:

  make `DATE_PART` roundtrip (#6573)

- due to [`4339b26`](https://github.com/tobymao/sqlglot/commit/4339b26db546862b10a0e8d746506b406ecfa306) - expose struct fields using UNNEST without aliases *(PR [#6566](https://github.com/tobymao/sqlglot/pull/6566) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  expose struct fields using UNNEST without aliases (#6566)

- due to [`8a44ad5`](https://github.com/tobymao/sqlglot/commit/8a44ad560cb65a34a722b257a82e69a41e7e45e0) - Mark _DBT_MAX_PARTITION as pseudocolumn *(PR [#6572](https://github.com/tobymao/sqlglot/pull/6572) by [@VaggelisD](https://github.com/VaggelisD))*:

  Mark _DBT_MAX_PARTITION as pseudocolumn (#6572)

- due to [`7bfffe5`](https://github.com/tobymao/sqlglot/commit/7bfffe5d894c60bd0139d57c53bb1816c2739d74) - support transpilation of TO_BOOLEAN from snowflake to duckdb *(PR [#6564](https://github.com/tobymao/sqlglot/pull/6564) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation of TO_BOOLEAN from snowflake to duckdb (#6564)


### :sparkles: New Features
- [`1fb90db`](https://github.com/tobymao/sqlglot/commit/1fb90db52b59e6e3a40597c6f611d0476b72025b) - **teradata**: Add support for Teradata set query band expression *(PR [#5519](https://github.com/tobymao/sqlglot/pull/5519) by [@treff7es](https://github.com/treff7es))*
- [`a49baaf`](https://github.com/tobymao/sqlglot/commit/a49baaf717cb41abb25ca51ae5adddc8473baa8b) - **doris**: Override table_sql to avoid AS keyword in UPDATE and DELETE statements *(PR [#5517](https://github.com/tobymao/sqlglot/pull/5517) by [@peterylh](https://github.com/peterylh))*
- [`75fd6d2`](https://github.com/tobymao/sqlglot/commit/75fd6d21fb7bc8399432e73d10b4837ae62d2ab5) - **exasol**: Add support for date difference functions in Exasol dialect *(PR [#5510](https://github.com/tobymao/sqlglot/pull/5510) by [@nnamdi16](https://github.com/nnamdi16))*
- [`2a91bb4`](https://github.com/tobymao/sqlglot/commit/2a91bb4f17c7569a5b409cc07e970e5d68235149) - **teradata**: Add support for Teradata locking select *(PR [#5524](https://github.com/tobymao/sqlglot/pull/5524) by [@treff7es](https://github.com/treff7es))*
- [`938f4b6`](https://github.com/tobymao/sqlglot/commit/938f4b6ebc1c0d26bd3c1400883978c79a435189) - **optimizer**: annotate type for LAST_DAY *(PR [#5528](https://github.com/tobymao/sqlglot/pull/5528) by [@geooo109](https://github.com/geooo109))*
- [`7d12dac`](https://github.com/tobymao/sqlglot/commit/7d12dac613ba5119334408f2c52cb270067156d9) - **optimizer**: annotate type for bigquery GENERATE_TIMESTAMP_ARRAY *(PR [#5529](https://github.com/tobymao/sqlglot/pull/5529) by [@geooo109](https://github.com/geooo109))*
- [`d50ebe2`](https://github.com/tobymao/sqlglot/commit/d50ebe286dd8e2836b9eb2a3406f15976db3aa05) - **optimizer**: annotate type for bigquery TIME_TRUNC *(PR [#5530](https://github.com/tobymao/sqlglot/pull/5530) by [@geooo109](https://github.com/geooo109))*
- [`29748be`](https://github.com/tobymao/sqlglot/commit/29748be7dfc10edc9f29665c98327883dd25c13d) - **optimizer**: annotate type for bigquery TIME *(PR [#5531](https://github.com/tobymao/sqlglot/pull/5531) by [@geooo109](https://github.com/geooo109))*
- [`7003b3f`](https://github.com/tobymao/sqlglot/commit/7003b3fa39cd455e3643066364696708d1ac4f38) - **optimizer**: parse and annotate type for bigquery DATE_FROM_UNIX_DATE *(PR [#5532](https://github.com/tobymao/sqlglot/pull/5532) by [@geooo109](https://github.com/geooo109))*
- [`a276ca6`](https://github.com/tobymao/sqlglot/commit/a276ca6fd5f9d47fa8c90fcfa19f9864e7a28f8f) - **optimizer**: parse and annotate type for bigquery JUSTIFY funcs *(PR [#5534](https://github.com/tobymao/sqlglot/pull/5534) by [@geooo109](https://github.com/geooo109))*
- [`374178e`](https://github.com/tobymao/sqlglot/commit/374178e22fe8d2d2275b65fe08e27ef66c611220) - **optimizer**: parse and annotate type for bigquery UNIX_MICROS and UNIX_MILLIS *(PR [#5535](https://github.com/tobymao/sqlglot/pull/5535) by [@geooo109](https://github.com/geooo109))*
- [`1d8d1ab`](https://github.com/tobymao/sqlglot/commit/1d8d1abe459053a135a46525d0a13bb861220927) - **optimizer**: annotate type for bigquery DATE_TRUNC *(PR [#5540](https://github.com/tobymao/sqlglot/pull/5540) by [@geooo109](https://github.com/geooo109))*
- [`306ba65`](https://github.com/tobymao/sqlglot/commit/306ba6531839ea2823f5165de7bde01d17560845) - **optimizer**: annotate type for bigquery TIMESTAMP_TRUNC *(PR [#5541](https://github.com/tobymao/sqlglot/pull/5541) by [@geooo109](https://github.com/geooo109))*
- [`6a68cca`](https://github.com/tobymao/sqlglot/commit/6a68cca97ad4bdd75c544ada0a5af0fa92ec4664) - **dremio**: support lowercase `TIME_MAPPING` formats *(PR [#5556](https://github.com/tobymao/sqlglot/pull/5556) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`f3ffe19`](https://github.com/tobymao/sqlglot/commit/f3ffe19ec01533c5f27b9d3a7b6704b83c005118) - **optimizer**: annotate type for bigquery format_time *(PR [#5559](https://github.com/tobymao/sqlglot/pull/5559) by [@geooo109](https://github.com/geooo109))*
- [`3ab3690`](https://github.com/tobymao/sqlglot/commit/3ab369096313b418699b7942b1c513c0c66a5331) - **optimizer**: parse and annotate type for bigquery PARSE_DATETIME *(PR [#5558](https://github.com/tobymao/sqlglot/pull/5558) by [@geooo109](https://github.com/geooo109))*
- [`e5da951`](https://github.com/tobymao/sqlglot/commit/e5da951542eb55691bc43fbbfbec4a30100de038) - **optimizer**: parse and annotate type for bigquery PARSE_TIME *(PR [#5561](https://github.com/tobymao/sqlglot/pull/5561) by [@geooo109](https://github.com/geooo109))*
- [`902a0cd`](https://github.com/tobymao/sqlglot/commit/902a0cdfe46f693aa55612d45a2de2def21f0b8c) - **singlestore**: Added parsing/generation of UNIXTIME functions *(PR [#5562](https://github.com/tobymao/sqlglot/pull/5562) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`798e213`](https://github.com/tobymao/sqlglot/commit/798e213fd10c3b61afbd8cef621546de65fa6f26) - **duckdb**: improve transpilability of ANY_VALUE closes [#5563](https://github.com/tobymao/sqlglot/pull/5563) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`c7041c7`](https://github.com/tobymao/sqlglot/commit/c7041c71250b17192c2f25fb8f33407324d332c2) - **optimizer**: parse and annotate type for bigquery BYTE_LENGHT *(PR [#5568](https://github.com/tobymao/sqlglot/pull/5568) by [@geooo109](https://github.com/geooo109))*
- [`a6c61c3`](https://github.com/tobymao/sqlglot/commit/a6c61c34f1e168c97dd5c2b8ec071372ba593992) - **optimizer**: parse and annotate type for bigquery CODE_POINTS_TO_STRING *(PR [#5569](https://github.com/tobymao/sqlglot/pull/5569) by [@geooo109](https://github.com/geooo109))*
- [`2a33339`](https://github.com/tobymao/sqlglot/commit/2a333395cde71936df911488afcff92cae735e11) - **optimizer**: annotate type for bigquery REPLACE *(PR [#5572](https://github.com/tobymao/sqlglot/pull/5572) by [@geooo109](https://github.com/geooo109))*
- [`1e6f813`](https://github.com/tobymao/sqlglot/commit/1e6f81343de641e588f1a05ce7dc01bed72bd849) - **optimizer**: annotate type for bigquery REGEXP_EXTRACT_ALL *(PR [#5573](https://github.com/tobymao/sqlglot/pull/5573) by [@geooo109](https://github.com/geooo109))*
- [`eb09e6e`](https://github.com/tobymao/sqlglot/commit/eb09e6e32491a05846488de7b72b1dca0e0a2669) - **optimizer**: parse and annotate type for bigquery TRANSLATE *(PR [#5575](https://github.com/tobymao/sqlglot/pull/5575) by [@geooo109](https://github.com/geooo109))*
- [`f9a522b`](https://github.com/tobymao/sqlglot/commit/f9a522b26cd5d643b8b18fa64d70f2a3f0ff2d2c) - **optimizer**: parse and annotate type for bigquery SOUNDEX *(PR [#5576](https://github.com/tobymao/sqlglot/pull/5576) by [@geooo109](https://github.com/geooo109))*
- [`51da41b`](https://github.com/tobymao/sqlglot/commit/51da41b90ce421b154e45add28353ac044640a1c) - **optimizer**: annotate type for bigquery MD5 *(PR [#5577](https://github.com/tobymao/sqlglot/pull/5577) by [@geooo109](https://github.com/geooo109))*
- [`bcf302f`](https://github.com/tobymao/sqlglot/commit/bcf302ff6ad2d0adfc29f708a8b53b5c0e547619) - **optimizer**: annotate type for bigquery MIN/MAX BY *(PR [#5579](https://github.com/tobymao/sqlglot/pull/5579) by [@geooo109](https://github.com/geooo109))*
- [`c501d9e`](https://github.com/tobymao/sqlglot/commit/c501d9e6f58e4880e4d23f21f53f72dcb5fdaa8c) - **optimizer**: parse and annotate type for bigquery GROUPING *(PR [#5581](https://github.com/tobymao/sqlglot/pull/5581) by [@geooo109](https://github.com/geooo109))*
- [`8612825`](https://github.com/tobymao/sqlglot/commit/86128253f911b733d45b073356e3b8ddf261c22b) - **spark**: generate date/time ops as interval binary ops *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`8fda774`](https://github.com/tobymao/sqlglot/commit/8fda774b7a9b0c66948349dfe030d3c122ff6eee) - **singlestore**: Added parsing and generation of JSON_EXTRACT *(PR [#5555](https://github.com/tobymao/sqlglot/pull/5555) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`82cc954`](https://github.com/tobymao/sqlglot/commit/82cc9549a875211a400e5c4e818b05ca48a0a9f4) - **exasol**: map div function to IntDiv in exasol dialect *(PR [#5593](https://github.com/tobymao/sqlglot/pull/5593) by [@nnamdi16](https://github.com/nnamdi16))*
- [`eb0fe68`](https://github.com/tobymao/sqlglot/commit/eb0fe68d6b5977053c871badf2f5c1895b3e1c66) - **trino**: add JSON_VALUE function support with RETURNING clause *(PR [#5590](https://github.com/tobymao/sqlglot/pull/5590) by [@rev-rwasilewski](https://github.com/rev-rwasilewski))*
- [`9e95c11`](https://github.com/tobymao/sqlglot/commit/9e95c115ea0304d9ccb4cb0be8389f5ff5f2a952) - **exasol**: mapped weekofyear to week in Exasol dialect *(PR [#5594](https://github.com/tobymao/sqlglot/pull/5594) by [@nnamdi16](https://github.com/nnamdi16))*
- [`8f013c3`](https://github.com/tobymao/sqlglot/commit/8f013c37a412ca5978889c1e47b0c6f7add0715d) - **singlestore**: Fixed parsing of DATE function *(PR [#5601](https://github.com/tobymao/sqlglot/pull/5601) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`a4a299a`](https://github.com/tobymao/sqlglot/commit/a4a299acbaf4461f0c2b470bc4e9e9590515eda7) - transpile `TO_CHAR` from Dremio to Databricks *(PR [#5598](https://github.com/tobymao/sqlglot/pull/5598) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`093f35c`](https://github.com/tobymao/sqlglot/commit/093f35c201c3c22c3a14c6f8de26c06246bdf19c) - **dremio**: handle `DATE_FORMAT`, `TO_DATE`, and `TO_TIMESTAMP` *(PR [#5597](https://github.com/tobymao/sqlglot/pull/5597) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`02e60e7`](https://github.com/tobymao/sqlglot/commit/02e60e73fc0c2dae815aa225be247a17ccdf4b82) - **singlestore**: desugarize DAYNAME into DATE_FORMAT *(PR [#5610](https://github.com/tobymao/sqlglot/pull/5610) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`7b180bd`](https://github.com/tobymao/sqlglot/commit/7b180bdc3da9e39946c22970bd2523f7d8beaf29) - **parser**: raise if query modifier is specified multiple times *(PR [#5608](https://github.com/tobymao/sqlglot/pull/5608) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#5604](https://github.com/tobymao/sqlglot/issues/5604) opened by [@bricct](https://github.com/bricct)*
- [`442eafc`](https://github.com/tobymao/sqlglot/commit/442eafcb00a2650930bd6023aa9a5febfebbe796) - **singlestore**: Added parsing of HOUR function *(PR [#5612](https://github.com/tobymao/sqlglot/pull/5612) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`5320359`](https://github.com/tobymao/sqlglot/commit/532035978605efd1d43de75aafca750e2894c0b9) - **singlestore**: Added parsing of MICROSECOND function *(PR [#5619](https://github.com/tobymao/sqlglot/pull/5619) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`db1db97`](https://github.com/tobymao/sqlglot/commit/db1db9732352187629df853ad937ebaf4abfe487) - **doris**: update exp.UniqueKeyProperty SQL generation logic *(PR [#5613](https://github.com/tobymao/sqlglot/pull/5613) by [@xinge-ji](https://github.com/xinge-ji))*
- [`54623a6`](https://github.com/tobymao/sqlglot/commit/54623a6b85432272703f12a197b05ced78529f90) - **singlestore**: Added parsing of MINUTE function *(PR [#5620](https://github.com/tobymao/sqlglot/pull/5620) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`565c9f8`](https://github.com/tobymao/sqlglot/commit/565c9f8c55cfbef5d3a9e1470551f1dc4416825e) - **singlestore**: Added generation of DAYOFWEEK_ISO function *(PR [#5627](https://github.com/tobymao/sqlglot/pull/5627) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`8db916e`](https://github.com/tobymao/sqlglot/commit/8db916e2f2ce241bdff130d626f98df182b48f3e) - **singlestore**: Added parsing of WEEKDAY function *(PR [#5624](https://github.com/tobymao/sqlglot/pull/5624) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`aa6274a`](https://github.com/tobymao/sqlglot/commit/aa6274a0ea647df1251563945635260a6ddd4972) - **singlestore**: Fixed generation of DAY_OF_MONTH function *(PR [#5629](https://github.com/tobymao/sqlglot/pull/5629) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`dee44b8`](https://github.com/tobymao/sqlglot/commit/dee44b8c1d70ca6079867896fb68cad256909dad) - **singlestore**: Added parsing of MONTHNAME function *(PR [#5623](https://github.com/tobymao/sqlglot/pull/5623) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`deebf0c`](https://github.com/tobymao/sqlglot/commit/deebf0c3cc379e28c4ab66b6bb7a9c84c14e88c6) - **singlestore**: Added parsing of SECOND function *(PR [#5621](https://github.com/tobymao/sqlglot/pull/5621) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`12a60b9`](https://github.com/tobymao/sqlglot/commit/12a60b99b6b2b0673b57218c691794deb67aa3a5) - **singlestore**: Removed redundant deletions from TRANSFORMS *(PR [#5632](https://github.com/tobymao/sqlglot/pull/5632) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`36602a2`](https://github.com/tobymao/sqlglot/commit/36602a2ecc9ffca98e89044d23e40f33c6ed71e4) - **duckdb**: parse LIST_FILTER into ArrayFilter closes [#5633](https://github.com/tobymao/sqlglot/pull/5633) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`0188d21`](https://github.com/tobymao/sqlglot/commit/0188d21d443c991a528eb9d220459890b7dca477) - **duckdb**: parse LIST_TRANSFORM into Transform closes [#5634](https://github.com/tobymao/sqlglot/pull/5634) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`b117d59`](https://github.com/tobymao/sqlglot/commit/b117d59f3c43f6f44cd0ccdf22717f7bcd990889) - **dremio**: add dremio date_add and date_sub parsing *(PR [#5617](https://github.com/tobymao/sqlglot/pull/5617) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`999b9e7`](https://github.com/tobymao/sqlglot/commit/999b9e793c0819a4d2af6400fc924946d26b3e6f) - **singlestore**: Changed generation of exp.TsOrDsToDate to handle case when format is not provided *(PR [#5639](https://github.com/tobymao/sqlglot/pull/5639) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`b556e97`](https://github.com/tobymao/sqlglot/commit/b556e97f8cfbde21c0a921ac1c01c9e4f2ec2535) - **singlestore**: Marked exp.All as unsupported *(PR [#5640](https://github.com/tobymao/sqlglot/pull/5640) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`c076694`](https://github.com/tobymao/sqlglot/commit/c0766946e6799fb61c38e855fd18812d08a5c251) - **clickhouse**: support custom partition key expressions *(PR [#5645](https://github.com/tobymao/sqlglot/pull/5645) by [@GaliFFun](https://github.com/GaliFFun))*
- [`cab62b0`](https://github.com/tobymao/sqlglot/commit/cab62b06ce926e3116a6a45a9c57e4901cd8a281) - **doris**: add support for BUILD and REFRESH properties in materialized view *(PR [#5614](https://github.com/tobymao/sqlglot/pull/5614) by [@xinge-ji](https://github.com/xinge-ji))*
- [`af0b299`](https://github.com/tobymao/sqlglot/commit/af0b299561914953b30ab36004e53dcb92d39e1c) - **optimizer**: Qualify columns generated by exp.Aliases *(PR [#5647](https://github.com/tobymao/sqlglot/pull/5647) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5638](https://github.com/tobymao/sqlglot/issues/5638) opened by [@catlynkong](https://github.com/catlynkong)*
- [`981e0e7`](https://github.com/tobymao/sqlglot/commit/981e0e70a304665e746158c859bcc81f99384685) - **doris**: add support for PARTITION BY LIST *(PR [#5615](https://github.com/tobymao/sqlglot/pull/5615) by [@xinge-ji](https://github.com/xinge-ji))*
- [`53aa8fe`](https://github.com/tobymao/sqlglot/commit/53aa8fe7f188012f765066f32c4179035fff036d) - **tsql**: support alter table with check closes [#5649](https://github.com/tobymao/sqlglot/pull/5649) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`23cac6c`](https://github.com/tobymao/sqlglot/commit/23cac6c58099a9ac818ac5d3970a427ca3579cca) - **exasol**: Add support for GROUP_CONCAT and LISTAGG functions *(PR [#5646](https://github.com/tobymao/sqlglot/pull/5646) by [@nnamdi16](https://github.com/nnamdi16))*
- [`d087ac8`](https://github.com/tobymao/sqlglot/commit/d087ac89376df5ab16de99c8b67f99060f0a6170) - **bigquery**: Add support for ml.generate_embedding function *(PR [#5652](https://github.com/tobymao/sqlglot/pull/5652) by [@rloredo](https://github.com/rloredo))*
- [`e71bcb5`](https://github.com/tobymao/sqlglot/commit/e71bcb51181de63c8ad13004216506529fcf9644) - **dremio**: support array_generate_range *(PR [#5653](https://github.com/tobymao/sqlglot/pull/5653) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`edbd04b`](https://github.com/tobymao/sqlglot/commit/edbd04b6a91b1a6f76e4fa938098ba5ed581ba72) - **singlestore**: Fixed generation of exp.RegexpLike *(PR [#5663](https://github.com/tobymao/sqlglot/pull/5663) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`4992edb`](https://github.com/tobymao/sqlglot/commit/4992edbb79f4922917cc5ce5aa687e6f7da7798c) - **singlestore**: Fixed exp.Xor generation *(PR [#5662](https://github.com/tobymao/sqlglot/pull/5662) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`20de3d3`](https://github.com/tobymao/sqlglot/commit/20de3d37cdae0705c67f80fbacbe024a62f34657) - **singlestore**: Fixed parsing/generation of exp.Hll *(PR [#5664](https://github.com/tobymao/sqlglot/pull/5664) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`1a60a5a`](https://github.com/tobymao/sqlglot/commit/1a60a5a845c7431d7d3d7ccb71119699316f4b41) - **singlestore**: Added parsing/generation of JSON_ARRAY_CONTAINS function *(PR [#5661](https://github.com/tobymao/sqlglot/pull/5661) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`f662dc0`](https://github.com/tobymao/sqlglot/commit/f662dc0b47fd14d00899c14a899756a5ba1fe9da) - **singlestore**: Fixed generation of exp.ApproxDistinct *(PR [#5666](https://github.com/tobymao/sqlglot/pull/5666) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e0db0a9`](https://github.com/tobymao/sqlglot/commit/e0db0a95d3cb7614242dbd1b439d408e7e7bd475) - **optimizer**: add parse and annotate type for bigquery FARM_FINGERPRINT *(PR [#5667](https://github.com/tobymao/sqlglot/pull/5667) by [@geooo109](https://github.com/geooo109))*
- [`dcd4ef7`](https://github.com/tobymao/sqlglot/commit/dcd4ef769727ed1227911f2d9a85244d61173003) - **singlestore**: Fixed exp.CountIf generation *(PR [#5668](https://github.com/tobymao/sqlglot/pull/5668) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e431e85`](https://github.com/tobymao/sqlglot/commit/e431e851c2c5d20f049adbc38e370a64d39c346f) - **singlestore**: Fixed generation of exp.LogicalOr *(PR [#5669](https://github.com/tobymao/sqlglot/pull/5669) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`56588c7`](https://github.com/tobymao/sqlglot/commit/56588c7e22b4db4f0e44696a460483ca1e549163) - **bigquery**: Add support for vector_search function. Move predict to BigQuery dialect. *(PR [#5660](https://github.com/tobymao/sqlglot/pull/5660) by [@rloredo](https://github.com/rloredo))*
- [`f0d2cc2`](https://github.com/tobymao/sqlglot/commit/f0d2cc2b0f72340172ecd154f632aa6a24c15512) - **singlestore**: Fixed generation of exp.LogicalAnd *(PR [#5671](https://github.com/tobymao/sqlglot/pull/5671) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`a688a0f`](https://github.com/tobymao/sqlglot/commit/a688a0f0d70f87139e531d1419b338b695bec384) - **optimizer**: parse and annotate type for bigquery APPROX_TOP_COUNT *(PR [#5670](https://github.com/tobymao/sqlglot/pull/5670) by [@geooo109](https://github.com/geooo109))*
- [`fa8d571`](https://github.com/tobymao/sqlglot/commit/fa8d57132b1d21d92eb5de3ba88b41f880e14889) - **singlestore**: Fixed generation/parsing of exp.ApproxQuantile *(PR [#5672](https://github.com/tobymao/sqlglot/pull/5672) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`9955ebe`](https://github.com/tobymao/sqlglot/commit/9955ebe90d3421815738ecb643806add755c5df3) - **singlestore**: Fixed parsing/generation of exp.Variance *(PR [#5673](https://github.com/tobymao/sqlglot/pull/5673) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`3c93fcc`](https://github.com/tobymao/sqlglot/commit/3c93fcce96ec82e78753f6c9dd5fb0e730a82058) - **optimizer**: parse and annotate type for bigquery APPROX_TOP_SUM *(PR [#5675](https://github.com/tobymao/sqlglot/pull/5675) by [@geooo109](https://github.com/geooo109))*
- [`60cbb9d`](https://github.com/tobymao/sqlglot/commit/60cbb9d0e3c9b5a36c1368c9b5bb05def8ce8658) - **dremio**: add CURRENT_DATE_UTC *(PR [#5674](https://github.com/tobymao/sqlglot/pull/5674) by [@jasonthomassql](https://github.com/jasonthomassql))*
  - :arrow_lower_right: *addresses issue [#5655](https://github.com/tobymao/sqlglot/issues/5655) opened by [@jasonthomassql](https://github.com/jasonthomassql)*
- [`741d45a`](https://github.com/tobymao/sqlglot/commit/741d45a0ca7c1bad67da4393cd10cc9cfa49ea68) - **optimizer**: parse and annotate type for bigquery FROM/TO_BASE32 *(PR [#5676](https://github.com/tobymao/sqlglot/pull/5676) by [@geooo109](https://github.com/geooo109))*
- [`9ae045c`](https://github.com/tobymao/sqlglot/commit/9ae045c0405e43b148e3b9261825288ebf09100c) - **optimizer**: parse and annotate type for bigquery FROM_HEX *(PR [#5679](https://github.com/tobymao/sqlglot/pull/5679) by [@geooo109](https://github.com/geooo109))*
- [`5a22a25`](https://github.com/tobymao/sqlglot/commit/5a22a254143978989027f6e7f6163019a34f112a) - **optimizer**: annotate type for bigquery TO_HEX *(PR [#5680](https://github.com/tobymao/sqlglot/pull/5680) by [@geooo109](https://github.com/geooo109))*
- [`d920ac3`](https://github.com/tobymao/sqlglot/commit/d920ac3886ce006d76616bc31884ee2f5c4162bc) - **singlestore**: Fixed parsing/generation of exp.RegexpExtractAll *(PR [#5692](https://github.com/tobymao/sqlglot/pull/5692) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`260c72b`](https://github.com/tobymao/sqlglot/commit/260c72befc0510ebe1d007284c0eef9343de20d7) - **singlestore**: Fixed parsing/generation of exp.Contains *(PR [#5684](https://github.com/tobymao/sqlglot/pull/5684) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`081dc67`](https://github.com/tobymao/sqlglot/commit/081dc673b89d3d8d0709b29e359142297ff64536) - **singlestore**: Fixed generaion/parsing of exp.VariancePop *(PR [#5682](https://github.com/tobymao/sqlglot/pull/5682) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`eb538bf`](https://github.com/tobymao/sqlglot/commit/eb538bf225645d0a54d614733e447c13cf91a37a) - **singlestore**: Fixed generation of exp.Chr *(PR [#5683](https://github.com/tobymao/sqlglot/pull/5683) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`32d9dd1`](https://github.com/tobymao/sqlglot/commit/32d9dd1309ce0876114f57993596c4456aa1d50f) - **singlestore**: Fixed exp.MD5Digest generation *(PR [#5688](https://github.com/tobymao/sqlglot/pull/5688) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`5c1eb2d`](https://github.com/tobymao/sqlglot/commit/5c1eb2df5dd3dcc6ed2c8204cec56b5c3d276f87) - **optimizer**: parse and annotate type for bq PARSE_BIG/NUMERIC *(PR [#5690](https://github.com/tobymao/sqlglot/pull/5690) by [@geooo109](https://github.com/geooo109))*
- [`6f88500`](https://github.com/tobymao/sqlglot/commit/6f885007a075339cf20034459571a6ae821c61c0) - **singlestore**: Fixed exp.IsAscii generation *(PR [#5687](https://github.com/tobymao/sqlglot/pull/5687) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`311373d`](https://github.com/tobymao/sqlglot/commit/311373d22134de906d1c1cef019541e85e2f7c9f) - **optimizer**: parse and annotate type for bq CODE_POINTS_TO_BYTES *(PR [#5686](https://github.com/tobymao/sqlglot/pull/5686) by [@geooo109](https://github.com/geooo109))*
- [`79d9de1`](https://github.com/tobymao/sqlglot/commit/79d9de1745598f8f3ae2c82c1389dd455c946a09) - **optimizer**: parse and annotate type for bq TO_CODE_POINTS *(PR [#5685](https://github.com/tobymao/sqlglot/pull/5685) by [@geooo109](https://github.com/geooo109))*
- [`5df3ea9`](https://github.com/tobymao/sqlglot/commit/5df3ea92f59125955124ea1883b777b489db3042) - **optimizer**: parse and annotate type for bq SAFE_CONVERT_BYTES_TO_STRING *(PR [#5681](https://github.com/tobymao/sqlglot/pull/5681) by [@geooo109](https://github.com/geooo109))*
- [`c832746`](https://github.com/tobymao/sqlglot/commit/c832746018fbc2c531d5b2a7c7f8cd5d78e511ff) - **optimizer**: parse and annotate type for bigquery APPROX_QUANTILES *(PR [#5678](https://github.com/tobymao/sqlglot/pull/5678) by [@geooo109](https://github.com/geooo109))*
- [`8fa5ae8`](https://github.com/tobymao/sqlglot/commit/8fa5ae8a61c698abaea265b4950390ea3ddfa7e9) - **singlestore**: Fixed generation/parsing of exp.RegexpExtract *(PR [#5691](https://github.com/tobymao/sqlglot/pull/5691) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`d6d409a`](https://github.com/tobymao/sqlglot/commit/d6d409a548042063f80d02dfaf5b61a0096d1d50) - **singlestore**: Fixed generaion of exp.Repeat *(PR [#5693](https://github.com/tobymao/sqlglot/pull/5693) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`b7db08b`](https://github.com/tobymao/sqlglot/commit/b7db08b96c7d7d02ec54f26b8749b3d57f021d8b) - **singlestore**: Fixed generation of exp.StartsWith *(PR [#5694](https://github.com/tobymao/sqlglot/pull/5694) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`87b04ef`](https://github.com/tobymao/sqlglot/commit/87b04ef0fc2df5064be9e6b75b264cff0639face) - **singlestore**: Fixed generation of exp.FromBase *(PR [#5695](https://github.com/tobymao/sqlglot/pull/5695) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`9c1d0fd`](https://github.com/tobymao/sqlglot/commit/9c1d0fdac9acd3fb3109ca3d3cae9c9ffaed1a7d) - **duckdb**: transpile array unique aggregation closes [#5689](https://github.com/tobymao/sqlglot/pull/5689) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`99e169e`](https://github.com/tobymao/sqlglot/commit/99e169ea13d5be3712a47f6b55b98a4764a3c24d) - **optimizer**: parse and annotate type for bq BOOL *(PR [#5697](https://github.com/tobymao/sqlglot/pull/5697) by [@geooo109](https://github.com/geooo109))*
- [`3f31770`](https://github.com/tobymao/sqlglot/commit/3f31770c793f464fcac1ce2b8dfa03d4b7f0231c) - **optimizer**: parse and annotate type for bq FLOAT64 *(PR [#5700](https://github.com/tobymao/sqlglot/pull/5700) by [@geooo109](https://github.com/geooo109))*
- [`f6f8f56`](https://github.com/tobymao/sqlglot/commit/f6f8f56a59d550dfc7dfcab0c3b9a6885c7e758a) - **singlestore**: Fixed parsing/generation of exp.JSONFormat *(PR [#5706](https://github.com/tobymao/sqlglot/pull/5706) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`de2fe15`](https://github.com/tobymao/sqlglot/commit/de2fe1503b5bb003431d1f0c7b9ae87932a6cc1c) - **optimizer**: annotate type for bq CONTAINS_SUBSTR *(PR [#5705](https://github.com/tobymao/sqlglot/pull/5705) by [@geooo109](https://github.com/geooo109))*
- [`a78146e`](https://github.com/tobymao/sqlglot/commit/a78146e37bfc972050b4467c39769407061e9bc3) - **singlestore**: Fixed parsing/generation of exp.DateBin *(PR [#5709](https://github.com/tobymao/sqlglot/pull/5709) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`ab0c985`](https://github.com/tobymao/sqlglot/commit/ab0c985424ae9d9340eafd15ecdc9b31bdd8837c) - **singlestore**: Marked exp.Reduce finish argument as unsupported *(PR [#5707](https://github.com/tobymao/sqlglot/pull/5707) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`770888f`](https://github.com/tobymao/sqlglot/commit/770888f4e9a9061329e3c416f968f7dd9639fb81) - **optimizer**: annotate type for bq NORMALIZE *(PR [#5711](https://github.com/tobymao/sqlglot/pull/5711) by [@geooo109](https://github.com/geooo109))*
- [`506033f`](https://github.com/tobymao/sqlglot/commit/506033f299f7a4c28f6efd8bf715be5dcf73e929) - **optimizer**: parse and annotate type for bq NORMALIZE_AND_CASEFOLD *(PR [#5712](https://github.com/tobymao/sqlglot/pull/5712) by [@geooo109](https://github.com/geooo109))*
- [`848aea1`](https://github.com/tobymao/sqlglot/commit/848aea1dbaaeb580b633796dcca06c28314b9c3e) - **optimizer**: parse and annotate type for bq OCTET_LENGTH *(PR [#5713](https://github.com/tobymao/sqlglot/pull/5713) by [@geooo109](https://github.com/geooo109))*
- [`727bf83`](https://github.com/tobymao/sqlglot/commit/727bf8378f232188d35834d980b035552999ea3b) - add support for REVOKE DDL *(PR [#5703](https://github.com/tobymao/sqlglot/pull/5703) by [@newtonapple](https://github.com/newtonapple))*
- [`baffd2c`](https://github.com/tobymao/sqlglot/commit/baffd2c0be9657683781f3f8831c47e32dbf68bb) - **optimizer**: parse and annotate type for bq REGEXP_INSTR *(PR [#5710](https://github.com/tobymao/sqlglot/pull/5710) by [@geooo109](https://github.com/geooo109))*
- [`b79eb19`](https://github.com/tobymao/sqlglot/commit/b79eb198cc21203efa82128b357d435338e9133d) - **optimizer**: annotate type for bq ROW_NUMBER *(PR [#5716](https://github.com/tobymao/sqlglot/pull/5716) by [@geooo109](https://github.com/geooo109))*
- [`f709bef`](https://github.com/tobymao/sqlglot/commit/f709bef3af7cd0daa25fe3d58b1753c3e65720ef) - **optimizer**: annotate type for bq FIRST_VALUE *(PR [#5718](https://github.com/tobymao/sqlglot/pull/5718) by [@geooo109](https://github.com/geooo109))*
- [`b9ae9e5`](https://github.com/tobymao/sqlglot/commit/b9ae9e534dee1e32fccbf22cab9bc17fbd920629) - **singlestore**: Implemeted generation of exp.TsOrDiToDi *(PR [#5724](https://github.com/tobymao/sqlglot/pull/5724) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`9b14fff`](https://github.com/tobymao/sqlglot/commit/9b14fffd2c9404f76a3faced2ec9d6eaac8feb01) - **singlestore**: Implemented generation of exp.DateToDi *(PR [#5717](https://github.com/tobymao/sqlglot/pull/5717) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`07d8c23`](https://github.com/tobymao/sqlglot/commit/07d8c2347baba6523310c4d31cddfb0e5c0eddc1) - **singlestore**: Implemented generation of exp.DiToDate *(PR [#5721](https://github.com/tobymao/sqlglot/pull/5721) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`ad34a85`](https://github.com/tobymao/sqlglot/commit/ad34a855a433bc0f51a707cbcb66f8dce667a562) - **singlestore**: Implemented generation of exp.FromTimeZone *(PR [#5723](https://github.com/tobymao/sqlglot/pull/5723) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`29d5e4f`](https://github.com/tobymao/sqlglot/commit/29d5e4f62a799f35c0904a23cedacc6efa95a63b) - **singlestore**: Implemented generation of exp.DatetimeAdd *(PR [#5728](https://github.com/tobymao/sqlglot/pull/5728) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`15a9061`](https://github.com/tobymao/sqlglot/commit/15a906170e5d5cdaa207ec7607edfdd7d4a8b774) - **optimizer**: annotate type for bq PERCENTILE_DISC *(PR [#5722](https://github.com/tobymao/sqlglot/pull/5722) by [@geooo109](https://github.com/geooo109))*
- [`7d49609`](https://github.com/tobymao/sqlglot/commit/7d4960963f0ef70b96f5b969bb008d2742e833ea) - **optimizer**: annotate type for bq NTH_VALUE *(PR [#5720](https://github.com/tobymao/sqlglot/pull/5720) by [@geooo109](https://github.com/geooo109))*
- [`d41acf1`](https://github.com/tobymao/sqlglot/commit/d41acf11221bee30a5ae089cbac9b158ed3dd515) - **optimizer**: annotate type for bq LEAD *(PR [#5719](https://github.com/tobymao/sqlglot/pull/5719) by [@geooo109](https://github.com/geooo109))*
- [`113809a`](https://github.com/tobymao/sqlglot/commit/113809a07efee0f12758bd2571c8515885568466) - **singlestore**: Implemented exp.TimeStrToDate generation *(PR [#5725](https://github.com/tobymao/sqlglot/pull/5725) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`cf63d0d`](https://github.com/tobymao/sqlglot/commit/cf63d0df4c2f58b2cf0c87e2a3a6f63f836a50a1) - **dremio**: add regexp_like and alias regexp_matches *(PR [#5731](https://github.com/tobymao/sqlglot/pull/5731) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`e42160f`](https://github.com/tobymao/sqlglot/commit/e42160f27fa68828898969073f2f4a0014f5e3e9) - **dremio**: support alias repeatstr *(PR [#5730](https://github.com/tobymao/sqlglot/pull/5730) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`ff12130`](https://github.com/tobymao/sqlglot/commit/ff12130c23a215917f20fda7d50322f1cb7de599) - **optimizer**: annotate type for bq PERNCENTILE_CONT *(PR [#5729](https://github.com/tobymao/sqlglot/pull/5729) by [@geooo109](https://github.com/geooo109))*
- [`fdb8a0a`](https://github.com/tobymao/sqlglot/commit/fdb8a0a6d0d74194255f313bd934db7fc1ce0d3f) - **optimizer**: parse and annotate type for bq FORMAT *(PR [#5715](https://github.com/tobymao/sqlglot/pull/5715) by [@geooo109](https://github.com/geooo109))*
- [`e272292`](https://github.com/tobymao/sqlglot/commit/e272292197f2bb81ccfad1de06a95f321f0b565f) - **singlestore**: Implemented generation of exp.Time *(PR [#5727](https://github.com/tobymao/sqlglot/pull/5727) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`012bdd3`](https://github.com/tobymao/sqlglot/commit/012bdd3c8aeff180f85354ffd403fc1aa5815dcf) - **optimizer**: parse and annotate type for bq CUME_DIST *(PR [#5735](https://github.com/tobymao/sqlglot/pull/5735) by [@geooo109](https://github.com/geooo109))*
- [`b99eaeb`](https://github.com/tobymao/sqlglot/commit/b99eaeb0c6eb3dc613e76d205e02632bd6af353b) - **optimizer**: parse and annotate type for bq DENSE_RANK *(PR [#5736](https://github.com/tobymao/sqlglot/pull/5736) by [@geooo109](https://github.com/geooo109))*
- [`8cf6ef9`](https://github.com/tobymao/sqlglot/commit/8cf6ef92a0f43943efb0fe380f41dc09f43aca85) - **optimizer**: parse and annotate_type for bq NTILE *(PR [#5737](https://github.com/tobymao/sqlglot/pull/5737) by [@geooo109](https://github.com/geooo109))*
- [`bb95c73`](https://github.com/tobymao/sqlglot/commit/bb95c7312c942ef987955f01e060604d60e32e83) - **optimizer**: parse and annotate type for bq RANK *(PR [#5738](https://github.com/tobymao/sqlglot/pull/5738) by [@geooo109](https://github.com/geooo109))*
- [`8713c08`](https://github.com/tobymao/sqlglot/commit/8713c082b0aa8454a5773fc2a85e08a132dc6ce3) - **optimizer**: parse and annotate type for bq PERCENT_RANK *(PR [#5739](https://github.com/tobymao/sqlglot/pull/5739) by [@geooo109](https://github.com/geooo109))*
- [`9ce4e31`](https://github.com/tobymao/sqlglot/commit/9ce4e31aecbde6ea1f227a7166c0f3dc9e302a66) - **optimizer**: annotate type for bq JSON_OBJECT *(PR [#5740](https://github.com/tobymao/sqlglot/pull/5740) by [@geooo109](https://github.com/geooo109))*
- [`d35ec6e`](https://github.com/tobymao/sqlglot/commit/d35ec6e37e21cf3cec848ed55bd73128c4633cd2) - **optimizer**: annotate type for bq JSON_QUERY/JSON_QUERY_ARRAY *(PR [#5741](https://github.com/tobymao/sqlglot/pull/5741) by [@geooo109](https://github.com/geooo109))*
- [`4753642`](https://github.com/tobymao/sqlglot/commit/4753642cfcfb1f192ec4d21a492737b27affef09) - **optimizer**: annotate type for bq JSON_EXTRACT_SCALAR *(commit by [@geooo109](https://github.com/geooo109))*
- [`6249dbe`](https://github.com/tobymao/sqlglot/commit/6249dbe4173ad5278adf84452dcf7253a2395b91) - **singlestore**: Added generation of exp.DatetimeDiff *(PR [#5743](https://github.com/tobymao/sqlglot/pull/5743) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`113a530`](https://github.com/tobymao/sqlglot/commit/113a5308d050fd5ceacab4c6188e5eea5dd740b1) - **optimizer**: parse and annotate type for bq JSON_ARRAY_APPEND *(PR [#5747](https://github.com/tobymao/sqlglot/pull/5747) by [@geooo109](https://github.com/geooo109))*
- [`8603705`](https://github.com/tobymao/sqlglot/commit/8603705a8e5513699adc2499389c67412eee70cb) - **singlestore**: feat(singlestore): Implemented generation of exp.DatetimeSub *(PR [#5744](https://github.com/tobymao/sqlglot/pull/5744) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`7d71c0b`](https://github.com/tobymao/sqlglot/commit/7d71c0bb576f9de3447b4780ab64a3f4d92c6432) - **singlestore**: Fixed generation of exp.DatetimeTrunc and exp.DateTrunc *(PR [#5745](https://github.com/tobymao/sqlglot/pull/5745) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`268e2c6`](https://github.com/tobymao/sqlglot/commit/268e2c694d1eb99f1fe64477bc38ed4946bf1c32) - **optimizer**: parse and annotate type for bq JSON_ARRAY_INSERT *(PR [#5748](https://github.com/tobymao/sqlglot/pull/5748) by [@geooo109](https://github.com/geooo109))*
- [`455ec1f`](https://github.com/tobymao/sqlglot/commit/455ec1f4f8aecb5435fa4cb2912bfc21db8dd44d) - **optimizer**: parse and annotate type for bq JSON_KEYS *(PR [#5749](https://github.com/tobymao/sqlglot/pull/5749) by [@geooo109](https://github.com/geooo109))*
- [`59895fa`](https://github.com/tobymao/sqlglot/commit/59895faa23ebe1b27938c37a7b39df87de609844) - **optimizer**: parse and annotate type for bq JSON_REMOVE *(PR [#5750](https://github.com/tobymao/sqlglot/pull/5750) by [@geooo109](https://github.com/geooo109))*
- [`06d7df7`](https://github.com/tobymao/sqlglot/commit/06d7df7a05f2824cabf48e8d1e8a4ebca8fda496) - **optimizer**: parse and annotate type for bq JSON_SET *(PR [#5751](https://github.com/tobymao/sqlglot/pull/5751) by [@geooo109](https://github.com/geooo109))*
- [`7f5079a`](https://github.com/tobymao/sqlglot/commit/7f5079a1b71c4dd28e98b77b5b749e074fce862c) - **singlestore**: Improved geneation of exp.DataType *(PR [#5746](https://github.com/tobymao/sqlglot/pull/5746) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`ad9405c`](https://github.com/tobymao/sqlglot/commit/ad9405cd43108ff80d16711f8b33ff57430ed686) - **singlestore**: fixed generation of exp.TimestampTrunc *(PR [#5754](https://github.com/tobymao/sqlglot/pull/5754) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`a1852f9`](https://github.com/tobymao/sqlglot/commit/a1852f93fdfe926072c12954c95796d038e15140) - **dremio**: parse date_part *(PR [#5756](https://github.com/tobymao/sqlglot/pull/5756) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`0db1df6`](https://github.com/tobymao/sqlglot/commit/0db1df617ec4f05b1ee6cf1d606272f6e799a9b9) - **singlestore**: Fixed generation of exp.DateDiff *(PR [#5752](https://github.com/tobymao/sqlglot/pull/5752) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e72b341`](https://github.com/tobymao/sqlglot/commit/e72b3419c8a367caa0e5e80030979cd94e87a40d) - **optimizer**: parse and annotate type for bq JSON_STRIP_NULLS *(PR [#5753](https://github.com/tobymao/sqlglot/pull/5753) by [@geooo109](https://github.com/geooo109))*
- [`5de61a7`](https://github.com/tobymao/sqlglot/commit/5de61a7ab850d4e68fde4d76ee396d30d7bdef33) - **optimizer**: parse and annotate type for bq JSON_EXTRACT_STRING_ARRAY *(PR [#5758](https://github.com/tobymao/sqlglot/pull/5758) by [@geooo109](https://github.com/geooo109))*
- [`36c9393`](https://github.com/tobymao/sqlglot/commit/36c93939575a19bd611269719c39d3d216be8cde) - **optimizer**: parse and annotate type for bq JSON LAX funcs *(PR [#5760](https://github.com/tobymao/sqlglot/pull/5760) by [@geooo109](https://github.com/geooo109))*
- [`c443d5c`](https://github.com/tobymao/sqlglot/commit/c443d5caf2d9695856103eebfff21cb215777112) - **dremio**: parse datetype *(PR [#5759](https://github.com/tobymao/sqlglot/pull/5759) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`5172a99`](https://github.com/tobymao/sqlglot/commit/5172a99fc4d5e21a1dbe4509d6d7ab1ccfe8bff7) - **singlestore**: Fixed parsing of columns with table name *(PR [#5767](https://github.com/tobymao/sqlglot/pull/5767) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`88862b5`](https://github.com/tobymao/sqlglot/commit/88862b56bc29c8a600b4d0e4693d5846d3a577ff) - **optimizer**: annotate type for bq TO_JSON_STRING *(PR [#5762](https://github.com/tobymao/sqlglot/pull/5762) by [@geooo109](https://github.com/geooo109))*
- [`1c551d5`](https://github.com/tobymao/sqlglot/commit/1c551d5ed3315e314013c1f063deabd9d8613e5d) - **optimizer**: parse and annotate type for bq TO_JSON *(PR [#5768](https://github.com/tobymao/sqlglot/pull/5768) by [@geooo109](https://github.com/geooo109))*
- [`a024d48`](https://github.com/tobymao/sqlglot/commit/a024d48fedd049796329050a1f51822dd1388695) - **singlestore**: Added generation of exp.TsOrDsDiff *(PR [#5769](https://github.com/tobymao/sqlglot/pull/5769) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`1707f2d`](https://github.com/tobymao/sqlglot/commit/1707f2d7f9d3b58e8c216db638f8e572f9fe6f13) - **optimizer**: annotate type for ABS *(PR [#5770](https://github.com/tobymao/sqlglot/pull/5770) by [@geooo109](https://github.com/geooo109))*
- [`69acc51`](https://github.com/tobymao/sqlglot/commit/69acc5142b2d4f0b30832c350aa49f16d1adabef) - **optimizer**: annotate type for bq IS_INF, IS_NAN *(PR [#5771](https://github.com/tobymao/sqlglot/pull/5771) by [@geooo109](https://github.com/geooo109))*
- [`0da2076`](https://github.com/tobymao/sqlglot/commit/0da207652331920416b29e2cc67bdc3c3f964466) - **optimizer**: annotate type for bq CBRT *(PR [#5772](https://github.com/tobymao/sqlglot/pull/5772) by [@geooo109](https://github.com/geooo109))*
- [`a4968cb`](https://github.com/tobymao/sqlglot/commit/a4968cb5693670c1a2e9cd2c86404dd90fd76160) - **optimizer**: annotate type for bq RAND *(PR [#5774](https://github.com/tobymao/sqlglot/pull/5774) by [@geooo109](https://github.com/geooo109))*
- [`dd7781a`](https://github.com/tobymao/sqlglot/commit/dd7781a15b842a5826714958ed7af9024903cd1e) - **singlestore**: Fixed generation of exp.Collate *(PR [#5775](https://github.com/tobymao/sqlglot/pull/5775) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`fb684cb`](https://github.com/tobymao/sqlglot/commit/fb684cbdb6178ddc441f598cc1a6e914291cd00e) - **singelstore**: Fixed generation of exp.RegexpILike *(PR [#5777](https://github.com/tobymao/sqlglot/pull/5777) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`3e63350`](https://github.com/tobymao/sqlglot/commit/3e63350bd1d58b510cecd1a573d27be3fd2565ce) - **optimizer**: parse and annotate type for bq ACOS *(PR [#5776](https://github.com/tobymao/sqlglot/pull/5776) by [@geooo109](https://github.com/geooo109))*
- [`8705a78`](https://github.com/tobymao/sqlglot/commit/8705a787df034b4cecb4ba95e9599772c5561ba9) - **singlestore**: Fixed generation of exp.CastToStrType *(PR [#5778](https://github.com/tobymao/sqlglot/pull/5778) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e3c35ad`](https://github.com/tobymao/sqlglot/commit/e3c35ade797f46549cc803e1acd8816041713a10) - **singlestore**: Fixed generation of exp.UnicodeString *(PR [#5773](https://github.com/tobymao/sqlglot/pull/5773) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`2be9d01`](https://github.com/tobymao/sqlglot/commit/2be9d01830c778186dc274c94c6db0dd6c4116d1) - **optimizer**: parse and annotate type for bq ACOSH *(PR [#5779](https://github.com/tobymao/sqlglot/pull/5779) by [@geooo109](https://github.com/geooo109))*
- [`7da2f31`](https://github.com/tobymao/sqlglot/commit/7da2f31d6613f16585e98c3fa1f592c617ae40c9) - **optimizer**: parse and annotate type for bq ASIN/H *(PR [#5783](https://github.com/tobymao/sqlglot/pull/5783) by [@geooo109](https://github.com/geooo109))*
- [`341ea83`](https://github.com/tobymao/sqlglot/commit/341ea83a07c707fdbf565b8d9ef4b9b6341ed1d5) - **optimizer**: parse and annotate type for bq ATAN/H/2 *(PR [#5784](https://github.com/tobymao/sqlglot/pull/5784) by [@geooo109](https://github.com/geooo109))*
- [`be54a45`](https://github.com/tobymao/sqlglot/commit/be54a458413ce3be6c321e5f4feb3e5df5ee6d08) - **singlestore**: Implemented generation of exp.Cbrt *(PR [#5782](https://github.com/tobymao/sqlglot/pull/5782) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`aa360cb`](https://github.com/tobymao/sqlglot/commit/aa360cb0e204aa056557ff8b15aa2d4f678430e6) - **databricks**: use regexp_like as it exists *(PR [#5781](https://github.com/tobymao/sqlglot/pull/5781) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`c2a1ad4`](https://github.com/tobymao/sqlglot/commit/c2a1ad4050771401a5b26bcadd90060e4527fbff) - **optimizer**: parse and annotate type for bq COT/H *(PR [#5786](https://github.com/tobymao/sqlglot/pull/5786) by [@geooo109](https://github.com/geooo109))*
- [`316ae91`](https://github.com/tobymao/sqlglot/commit/316ae913d8b1a63f3071ebb1b826328108d74cef) - **singlestore**: Added handling of UTC_DATE and exp.CurrentDate *(PR [#5785](https://github.com/tobymao/sqlglot/pull/5785) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`2c6d237`](https://github.com/tobymao/sqlglot/commit/2c6d23742ea9fcc2b9c784315d3d5364e360fea5) - **optimizer**: parse and annotate type for bq CSC/H *(PR [#5787](https://github.com/tobymao/sqlglot/pull/5787) by [@geooo109](https://github.com/geooo109))*
- [`8a35076`](https://github.com/tobymao/sqlglot/commit/8a350763c2337f6910a5f0e19af387ba488fcb70) - **optimizer**: parse and annotate type for bq SEC/H *(PR [#5788](https://github.com/tobymao/sqlglot/pull/5788) by [@geooo109](https://github.com/geooo109))*
- [`566bfb2`](https://github.com/tobymao/sqlglot/commit/566bfb2a64a64b74da63b3a89d68caf702ab6522) - **singlestore**: Added support of UTC_TIME and CURRENT_TIME *(PR [#5789](https://github.com/tobymao/sqlglot/pull/5789) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`79901cb`](https://github.com/tobymao/sqlglot/commit/79901cb506737ae1932fa44a705858d2597ee587) - **optimizer**: parse and annotate type for bq SIN\H *(PR [#5790](https://github.com/tobymao/sqlglot/pull/5790) by [@geooo109](https://github.com/geooo109))*
- [`74fb547`](https://github.com/tobymao/sqlglot/commit/74fb5476def1b389da425885db56bd6592fd7f78) - **optimizer**: parse and annotate type for bq RANGE_BUCKET *(PR [#5793](https://github.com/tobymao/sqlglot/pull/5793) by [@geooo109](https://github.com/geooo109))*
- [`eca65e8`](https://github.com/tobymao/sqlglot/commit/eca65e8b79f65850b014a4cb7913ba4a5861dbe9) - **optimizer**: parse and annotate type for bq COSINE/EUCLIDEAN_DISTANCE *(PR [#5792](https://github.com/tobymao/sqlglot/pull/5792) by [@geooo109](https://github.com/geooo109))*
- [`a180d3f`](https://github.com/tobymao/sqlglot/commit/a180d3f2f9f3938611027269028c03274aa1889c) - **optimizer**: parse and annotate type for bq SAFE math funcs *(PR [#5797](https://github.com/tobymao/sqlglot/pull/5797) by [@geooo109](https://github.com/geooo109))*
- [`fc7ad7a`](https://github.com/tobymao/sqlglot/commit/fc7ad7a4d953424b56542eacfe1835f5789921c7) - **snowflake**: parse ALTER SESSION  *(PR [#5734](https://github.com/tobymao/sqlglot/pull/5734) by [@tekumara](https://github.com/tekumara))*
- [`8ec1a6c`](https://github.com/tobymao/sqlglot/commit/8ec1a6cf5a8edc2d834c713ce0fd8d87237f11ed) - **optimizer**: annotate type for bq STRING_AGG *(PR [#5798](https://github.com/tobymao/sqlglot/pull/5798) by [@geooo109](https://github.com/geooo109))*
- [`dd97bfa`](https://github.com/tobymao/sqlglot/commit/dd97bfa1dc2f86b727c55b06b3c54b18c02e360d) - **optimizer**: annotate type for bq DATETIME_TRUNC *(PR [#5799](https://github.com/tobymao/sqlglot/pull/5799) by [@geooo109](https://github.com/geooo109))*
- [`d3e9dda`](https://github.com/tobymao/sqlglot/commit/d3e9dda183695dd1e4a9832a6671bccc6db561a0) - **optimizer**: annotate type for bq GENERATE_UUID *(commit by [@geooo109](https://github.com/geooo109))*
- [`cf1d1e3`](https://github.com/tobymao/sqlglot/commit/cf1d1e3e0ef9e6cd1b1c6128c63ddf06c30f1339) - **optimizer**: annotate type for snowflake's REVERSE function *(PR [#5803](https://github.com/tobymao/sqlglot/pull/5803) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`1d07c52`](https://github.com/tobymao/sqlglot/commit/1d07c52badb2e392e6895cbb275d2224789366c9) - **SingleStore**: Implemented generation of CURRENT_DATETIME *(PR [#5816](https://github.com/tobymao/sqlglot/pull/5816) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`cad4fd0`](https://github.com/tobymao/sqlglot/commit/cad4fd0c5b0ec90e693fa6883af0ab287b921019) - **singlestore**: Added handling of exp.JSONObject *(PR [#5817](https://github.com/tobymao/sqlglot/pull/5817) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e3cb076`](https://github.com/tobymao/sqlglot/commit/e3cb0766bd5c3ccb31ea52cfc76201f548798dc1) - **singlestore**: Implemented generation of exp.StandardHash *(PR [#5823](https://github.com/tobymao/sqlglot/pull/5823) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`0198282`](https://github.com/tobymao/sqlglot/commit/0198282a82bbf3e81476e164718d63fd1210acdc) - **optimizer**: : Update tests for concat string function *(PR [#5809](https://github.com/tobymao/sqlglot/pull/5809) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`4e8a436`](https://github.com/tobymao/sqlglot/commit/4e8a436c16f487a72bd1ac2432bcb1c46599d901) - **singlestore**: Added generation of exp.JSONExists *(PR [#5820](https://github.com/tobymao/sqlglot/pull/5820) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`82bea49`](https://github.com/tobymao/sqlglot/commit/82bea49978ae459492b5127a2a52049826e2fd06) - **singlestore**: Refactored parsing of JSON_BUILD_OBJECT *(PR [#5828](https://github.com/tobymao/sqlglot/pull/5828) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`f7d38c3`](https://github.com/tobymao/sqlglot/commit/f7d38c3a10c505346f04e39a2712d60b4c96370f) - **singlestore**: Implemented generation of exp.Stuff *(PR [#5825](https://github.com/tobymao/sqlglot/pull/5825) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`030a5b5`](https://github.com/tobymao/sqlglot/commit/030a5b5ea03ecee869b07cfd27f4ea044732822e) - **singlestore**: Added generation of exp.JSONBExists *(PR [#5821](https://github.com/tobymao/sqlglot/pull/5821) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e58fef1`](https://github.com/tobymao/sqlglot/commit/e58fef1d6dc654a3b36461bcbea21c99cdc96477) - **singlestore**: Implemented parsing and generation of exp.MatchAgainst *(PR [#5822](https://github.com/tobymao/sqlglot/pull/5822) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e94f530`](https://github.com/tobymao/sqlglot/commit/e94f530af0e0cdad995b4c8dc5ed86953490d37f) - **singlestore**: Added handling of exp.JSONArray *(PR [#5818](https://github.com/tobymao/sqlglot/pull/5818) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`1c42ef4`](https://github.com/tobymao/sqlglot/commit/1c42ef4374aeab8a1ee9848892d7f8c4511c7f04) - **singlestore**: Fixed parsing/generation of exp.JSONArrayAgg *(PR [#5819](https://github.com/tobymao/sqlglot/pull/5819) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`67219f0`](https://github.com/tobymao/sqlglot/commit/67219f0606231514f430e146e2fdb99e796f718b) - **singlestore**: Added support of UTC_TIMESTAMP and CURRENT_TIMESTAMP *(PR [#5808](https://github.com/tobymao/sqlglot/pull/5808) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`db2c430`](https://github.com/tobymao/sqlglot/commit/db2c4303237a1244070c359245c398a724df6de2) - **optimizer**: annoate the "contains" function *(PR [#5829](https://github.com/tobymao/sqlglot/pull/5829) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`a398fb4`](https://github.com/tobymao/sqlglot/commit/a398fb4df28c868f4cfc34530044b9d7b78e2e90) - **singlestore**: Splitted truncation of multiple tables into several queries *(PR [#5839](https://github.com/tobymao/sqlglot/pull/5839) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`cd27c96`](https://github.com/tobymao/sqlglot/commit/cd27c96fe85aba5f54116f38649edd8db064a5e6) - **snowflake**: transpile `TO_HEX` from bigquery *(PR [#5838](https://github.com/tobymao/sqlglot/pull/5838) by [@YuvalOmerRep](https://github.com/YuvalOmerRep))*
- [`d2e4ab7`](https://github.com/tobymao/sqlglot/commit/d2e4ab7df41ae3601e9b66e1338db3d851729339) - **snowflake**: add tests for endswith function *(PR [#5846](https://github.com/tobymao/sqlglot/pull/5846) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`c50d6e3`](https://github.com/tobymao/sqlglot/commit/c50d6e3c7b96f00d27c34a02c8e0dced21e6c373) - **optimizer**: annotate type for snowflake LEFT, RIGHT and SUBSTRING functions *(PR [#5849](https://github.com/tobymao/sqlglot/pull/5849) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`ca6c8f7`](https://github.com/tobymao/sqlglot/commit/ca6c8f753ba8458544439e20671f0981c98d168d) - **singlestore**: Improved parsting/generation of exp.Show *(PR [#5853](https://github.com/tobymao/sqlglot/pull/5853) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`722eceb`](https://github.com/tobymao/sqlglot/commit/722ecebfa43aa5948031edd1828b6482a241d9ef) - **snowflake**: MD5Digest transpiling to MD5_BINARY *(PR [#5855](https://github.com/tobymao/sqlglot/pull/5855) by [@YuvalOmerRep](https://github.com/YuvalOmerRep))*
- [`b128339`](https://github.com/tobymao/sqlglot/commit/b12833977e2a395712481cf11e293fdbd70fd4ce) - **optimizer**: annotate and add tests for snowflake LENGTH and LOWER functions *(PR [#5856](https://github.com/tobymao/sqlglot/pull/5856) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`134957a`](https://github.com/tobymao/sqlglot/commit/134957af11c55a4ab16f58d0725d6bb8ab23eb28) - **optimizer**: annotate types for Snowflake TRIM function *(PR [#5811](https://github.com/tobymao/sqlglot/pull/5811) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`0475dae`](https://github.com/tobymao/sqlglot/commit/0475dae21231b85407bf778fd9f1abaecdeb68de) - **singlestore**: Marked several exp.Describe args as unsupported *(PR [#5861](https://github.com/tobymao/sqlglot/pull/5861) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`7a07b41`](https://github.com/tobymao/sqlglot/commit/7a07b41b2357149adc6afb50bb98e37e6a3175f1) - **optimizer**: Add tests for snowflake LTRIM and RTRIM functions *(PR [#5857](https://github.com/tobymao/sqlglot/pull/5857) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`fb90666`](https://github.com/tobymao/sqlglot/commit/fb90666ff3e710d70815a68defde3dc85aeef7b3) - **singlestore**: Added collate handling to exp.AlterColumn *(PR [#5864](https://github.com/tobymao/sqlglot/pull/5864) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`2f27692`](https://github.com/tobymao/sqlglot/commit/2f276929d6b6f788eb5b3ee0b1a8a8c108833474) - **snowflake**: JSONFormat transpiling to TO_JSON  *(PR [#5860](https://github.com/tobymao/sqlglot/pull/5860) by [@YuvalOmerRep](https://github.com/YuvalOmerRep))*
- [`487c811`](https://github.com/tobymao/sqlglot/commit/487c8119cbfaf2783f5f17ec90c8e69e4432a4fa) - **singlestore**: Fixed parsing/generation of exp.RenameColumn *(PR [#5865](https://github.com/tobymao/sqlglot/pull/5865) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`76cf4d8`](https://github.com/tobymao/sqlglot/commit/76cf4d892a6d011a2e0020fb1ea82518d4f49e71) - **bigquery**: add support for ML.TRANSLATE func *(PR [#5859](https://github.com/tobymao/sqlglot/pull/5859) by [@geooo109](https://github.com/geooo109))*
- [`a899eb1`](https://github.com/tobymao/sqlglot/commit/a899eb188d5e354d3ed56d1e7c32861eecf3e906) - **singlestore**: Fixed parsing and generation of VECTOR type *(PR [#5854](https://github.com/tobymao/sqlglot/pull/5854) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`0acf076`](https://github.com/tobymao/sqlglot/commit/0acf0769773061fca3ec03125a5d43a4aa9c8e4b) - **postgres**: Support `?|` JSONB operator *(PR [#5866](https://github.com/tobymao/sqlglot/pull/5866) by [@VaggelisD](https://github.com/VaggelisD))*
- [`bd4b278`](https://github.com/tobymao/sqlglot/commit/bd4b2780c32ee52d25b6539d7b4479b6a7f80d18) - **optimizer**: annotate types for Snowflake UPPER function *(PR [#5812](https://github.com/tobymao/sqlglot/pull/5812) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`edab189`](https://github.com/tobymao/sqlglot/commit/edab1890e2c790b737be4995a31667448eff148e) - **postgres**: Support ?& JSONB operator *(PR [#5867](https://github.com/tobymao/sqlglot/pull/5867) by [@VaggelisD](https://github.com/VaggelisD))*
- [`960ec06`](https://github.com/tobymao/sqlglot/commit/960ec069eb275b7b8cc6705dbbb1143159f06237) - **postgres**: Support #- JSONB operator *(PR [#5868](https://github.com/tobymao/sqlglot/pull/5868) by [@VaggelisD](https://github.com/VaggelisD))*
- [`d3cd6bf`](https://github.com/tobymao/sqlglot/commit/d3cd6bf6e5fbaa490868ee3cd2cc99dd5e40a396) - **optimizer**: Annotate and add tests for snowflake REPLACE and SPACE functions *(PR [#5871](https://github.com/tobymao/sqlglot/pull/5871) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`ba22531`](https://github.com/tobymao/sqlglot/commit/ba2253113ea5a7c76c8df7ec9b6faf37da698fa4) - **bigquery**: Add support for ML.FORECAST(...) *(PR [#5873](https://github.com/tobymao/sqlglot/pull/5873) by [@VaggelisD](https://github.com/VaggelisD))*
- [`cd818ba`](https://github.com/tobymao/sqlglot/commit/cd818bad51e93ec349b97675e4c1f5bd7c4c1522) - **singlestore**: Fixed generation/parsing of computed collumns *(PR [#5878](https://github.com/tobymao/sqlglot/pull/5878) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`5d1f241`](https://github.com/tobymao/sqlglot/commit/5d1f241209197419111e9eda37fb6f2a5ec2bc4b) - **tsql**: support JSON_ARRAYAGG *(PR [#5879](https://github.com/tobymao/sqlglot/pull/5879) by [@geooo109](https://github.com/geooo109))*
- [`96ae7a3`](https://github.com/tobymao/sqlglot/commit/96ae7a3bcbf9de1932150baa0bd704d4ce05c9f7) - **optimizer**: Annotate and add tests for snowflake REPEAT and SPLIT functions *(PR [#5875](https://github.com/tobymao/sqlglot/pull/5875) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`0fe6a25`](https://github.com/tobymao/sqlglot/commit/0fe6a25e366dcbc5a4a0878b285d147a6aa00412) - **postgres**: support JSON_AGG *(PR [#5880](https://github.com/tobymao/sqlglot/pull/5880) by [@geooo109](https://github.com/geooo109))*
- [`854eeeb`](https://github.com/tobymao/sqlglot/commit/854eeeb5b25954cc26b91135d58eb8370271f1de) - **optimizer**: annotate types for Snowflake REGEXP_LIKE, REGEXP_REPLACE, REGEXP_SUBSTR functions *(PR [#5876](https://github.com/tobymao/sqlglot/pull/5876) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`f2d3bf7`](https://github.com/tobymao/sqlglot/commit/f2d3bf74e804e5a5e2ac6ca94210ba04df07e7f3) - **optimizer**: annotate types for Snowflake UUID_STRING function *(PR [#5881](https://github.com/tobymao/sqlglot/pull/5881) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`5b9463a`](https://github.com/tobymao/sqlglot/commit/5b9463ad11a49c821585985c35394ebb30e827dd) - **mysql**: add support for binary `MOD` operator fixes [#5887](https://github.com/tobymao/sqlglot/pull/5887) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`d24eabc`](https://github.com/tobymao/sqlglot/commit/d24eabcbe30dc0f7c2dbae346e429efef58b5680) - **bigquery**: Add support for ML.GENERATE_TEXT_EMBEDDING(...) *(PR [#5891](https://github.com/tobymao/sqlglot/pull/5891) by [@VaggelisD](https://github.com/VaggelisD))*
- [`950a3fa`](https://github.com/tobymao/sqlglot/commit/950a3fa6d6307f7713f40117655da2f9710ebfa9) - **mysql**: SOUNDS LIKE, SUBSTR *(PR [#5886](https://github.com/tobymao/sqlglot/pull/5886) by [@vuvova](https://github.com/vuvova))*
- [`688afc5`](https://github.com/tobymao/sqlglot/commit/688afc55ab08588636eba92893c603ca68e43e6e) - **singlestore**: Fixed generation of exp.National *(PR [#5890](https://github.com/tobymao/sqlglot/pull/5890) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`c77147e`](https://github.com/tobymao/sqlglot/commit/c77147ebaafa6942f80af75dd6c2d7a62a7e6fe2) - **parser**: Extend support for `IS UNKOWN` across all dialects *(PR [#5888](https://github.com/tobymao/sqlglot/pull/5888) by [@VaggelisD](https://github.com/VaggelisD))*
- [`ec80ff3`](https://github.com/tobymao/sqlglot/commit/ec80ff34957c3e3f80c44175383b06cf72988a68) - make dump a list instead of a nested dict to avoid all recursion errors *(PR [#5885](https://github.com/tobymao/sqlglot/pull/5885) by [@tobymao](https://github.com/tobymao))*
- [`2fdaccd`](https://github.com/tobymao/sqlglot/commit/2fdaccd1a9045bda3d529025a4706c397b8a836f) - **optimizer**: annotate types for Snowflake SHA1, SHA2 functions *(PR [#5884](https://github.com/tobymao/sqlglot/pull/5884) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`faba309`](https://github.com/tobymao/sqlglot/commit/faba30905390e5efaf0ba9a05aab9ac2724b1b85) - **optimizer**: annotate types for Snowflake AI_AGG function *(PR [#5894](https://github.com/tobymao/sqlglot/pull/5894) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`dd27844`](https://github.com/tobymao/sqlglot/commit/dd2784435c7bdd2ceaaaaa359fcd112ad1f8190c) - **snowflake**: transpile `BYTE_LENGTH` *(PR [#5899](https://github.com/tobymao/sqlglot/pull/5899) by [@ozadari](https://github.com/ozadari))*
- [`304bec5`](https://github.com/tobymao/sqlglot/commit/304bec5f7342501ad28ea4cd0a4b9aa092f2192f) - **optimizer**: Annotate snowflake MD5 functions *(PR [#5883](https://github.com/tobymao/sqlglot/pull/5883) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`ec3006d`](https://github.com/tobymao/sqlglot/commit/ec3006d815951fdc1a80d6722ce6f1176417d595) - **optimizer**: Add tests for snowflake NOT ILIKE and NOT LIKE *(PR [#5901](https://github.com/tobymao/sqlglot/pull/5901) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`c0180ec`](https://github.com/tobymao/sqlglot/commit/c0180ec163a43836fed754efcb6f26ad37cdae50) - **optimizer**: annotate types for Snowflake AI_SUMMARIZE_AGG function *(PR [#5902](https://github.com/tobymao/sqlglot/pull/5902) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`1ee026d`](https://github.com/tobymao/sqlglot/commit/1ee026d22d4f6c3613c1809a6738cdea846c48a9) - **postgres**: support `SUBSTRING(value FOR length FROM start)` variant *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`d5cf114`](https://github.com/tobymao/sqlglot/commit/d5cf1149932850a91cb5f1ebecda2652616729ef) - **duckdb**: support INSTALL *(PR [#5904](https://github.com/tobymao/sqlglot/pull/5904) by [@geooo109](https://github.com/geooo109))*
- [`73e05bb`](https://github.com/tobymao/sqlglot/commit/73e05bb15bb86e4a07cc09bf02028a6cf7fa1e6f) - **snowflake**: properly generate `BITNOT` *(PR [#5906](https://github.com/tobymao/sqlglot/pull/5906) by [@YuvalOmerRep](https://github.com/YuvalOmerRep))*
- [`16f317c`](https://github.com/tobymao/sqlglot/commit/16f317c04f7c0a398c38b461e05f4d4c30baf98b) - **snowflake**: add support for `<model>!<attribute>` syntax *(PR [#5907](https://github.com/tobymao/sqlglot/pull/5907) by [@georgesittas](https://github.com/georgesittas))*
- [`5a973e9`](https://github.com/tobymao/sqlglot/commit/5a973e9a88fa7f522a9bf91dc60fb0f6effef53d) - **optimizer**: annotate types for Snowflake AI_CLASSIFY function *(PR [#5909](https://github.com/tobymao/sqlglot/pull/5909) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`f4ad258`](https://github.com/tobymao/sqlglot/commit/f4ad25882951de4e4442dfd5189a56d5a1c5e630) - **optimizer**: Annotate types for Snowflake BASE64_DECODE_BINARY function *(PR [#5917](https://github.com/tobymao/sqlglot/pull/5917) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`6d0e3f8`](https://github.com/tobymao/sqlglot/commit/6d0e3f8dcae7ed1a7659ece69b1f94cec5e7300e) - **optimizer**: Add parser support to ilike like function versions. *(PR [#5915](https://github.com/tobymao/sqlglot/pull/5915) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`fc5624e`](https://github.com/tobymao/sqlglot/commit/fc5624eca43d2855ac350c92d85b184a6893d5ca) - **optimizer**: annotate types for Snowflake ASCII function *(PR [#5926](https://github.com/tobymao/sqlglot/pull/5926) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`4e81690`](https://github.com/tobymao/sqlglot/commit/4e8169045edcaa28ae43abeb07370df63846fbfd) - **optimizer**: annotate type for Snowflake COLLATE function *(PR [#5931](https://github.com/tobymao/sqlglot/pull/5931) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`f07d35d`](https://github.com/tobymao/sqlglot/commit/f07d35d29104c6203efaab738118d1903614b83c) - **optimizer**: annotate type for Snowflake CHR function *(PR [#5929](https://github.com/tobymao/sqlglot/pull/5929) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`f8c0ee4`](https://github.com/tobymao/sqlglot/commit/f8c0ee4d3c1a4d4a92b897d1cc85f9904c8e566b) - **optimizer**: Add function and annotate snowflake hex decode string and binary functions *(PR [#5928](https://github.com/tobymao/sqlglot/pull/5928) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`66f9501`](https://github.com/tobymao/sqlglot/commit/66f9501d76d087798bad93e578273ab2a45e2575) - **optimizer**: annotate types for Snowflake BIT_LENGTH function *(PR [#5927](https://github.com/tobymao/sqlglot/pull/5927) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`f4c810e`](https://github.com/tobymao/sqlglot/commit/f4c810e043d9379e94efb185e368e27ad9c15715) - transpile Trino `FORMAT` to DuckDB and Snowflake, closes [#5933](https://github.com/tobymao/sqlglot/pull/5933) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`7878437`](https://github.com/tobymao/sqlglot/commit/78784370712df65a2e1e79a1c2b441131ed7222a) - **optimizer**: annotate snowflake's `BASE64_DECODE_STRING`, `BASE64_ENCODE` *(PR [#5922](https://github.com/tobymao/sqlglot/pull/5922) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`9bcad04`](https://github.com/tobymao/sqlglot/commit/9bcad040bd51dd03821c68eea1a73534fc7a81b7) - **optimizer**: Annotate type for HEX ENCODE function. *(PR [#5936](https://github.com/tobymao/sqlglot/pull/5936) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`590928f`](https://github.com/tobymao/sqlglot/commit/590928f4637306e8cf3f1302d5dd5d5dbc76e7e0) - **optimizer**: annotate type for Snowflake INITCAP function *(PR [#5941](https://github.com/tobymao/sqlglot/pull/5941) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`ac04de1`](https://github.com/tobymao/sqlglot/commit/ac04de1944c7a976406581b489b3cf9b11dafb77) - **optimizer**: annotate type for Snowflake EDITDISTANCE function *(PR [#5940](https://github.com/tobymao/sqlglot/pull/5940) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`a385990`](https://github.com/tobymao/sqlglot/commit/a38599080932a8b54a169df8b7a69650cb47b6bc) - **parser**: support wrapped aggregate functions *(PR [#5943](https://github.com/tobymao/sqlglot/pull/5943) by [@geooo109](https://github.com/geooo109))*
- [`9e28af8`](https://github.com/tobymao/sqlglot/commit/9e28af8a52ced951ecf7f4e85a6305e20a13de1f) - **optimizer**: Annotate type for snowflake COMPRESS function *(PR [#5938](https://github.com/tobymao/sqlglot/pull/5938) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`7f13eaf`](https://github.com/tobymao/sqlglot/commit/7f13eaf7769a3381a56c9209af590835be2f95cd) - **optimizer**: Annotate type for snowflake DECOMPRESS_BINARY function *(PR [#5945](https://github.com/tobymao/sqlglot/pull/5945) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`be12b29`](https://github.com/tobymao/sqlglot/commit/be12b29b5a7bd6d6e09dbd8c17086bd77c19abc0) - **optimizer**: Annotate type for snowflake DECOMPRESS_STRING function *(PR [#5947](https://github.com/tobymao/sqlglot/pull/5947) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`a55fce5`](https://github.com/tobymao/sqlglot/commit/a55fce5310a50af132c5d06bb299fe3f025442c4) - **optimizer**: Annotate type for snowflake LPAD function *(PR [#5948](https://github.com/tobymao/sqlglot/pull/5948) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`05e07aa`](https://github.com/tobymao/sqlglot/commit/05e07aa740d7977a6b42ec15ae4fa9c2168a15f5) - **optimizer**: annotate type for Snowflake INSERT function *(PR [#5942](https://github.com/tobymao/sqlglot/pull/5942) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`6268e10`](https://github.com/tobymao/sqlglot/commit/6268e107a947badaa00508544f5389412806ecd0) - **solr**: initial dialect implementation *(PR [#5946](https://github.com/tobymao/sqlglot/pull/5946) by [@aadel](https://github.com/aadel))*
- [`1573fef`](https://github.com/tobymao/sqlglot/commit/1573fefac27b5b1215e3d458f8ccf1b9dadbb772) - **optimizer**: annotate types for Snowflake JAROWINKLER_SIMILARITY function *(PR [#5950](https://github.com/tobymao/sqlglot/pull/5950) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`883c6ab`](https://github.com/tobymao/sqlglot/commit/883c6abe589865f478d95604e8d670e57afd04af) - **optimizer**: annotate type for Snowflake COLLATION function *(PR [#5939](https://github.com/tobymao/sqlglot/pull/5939) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`627c18d`](https://github.com/tobymao/sqlglot/commit/627c18d7da6bf644bc14c0f17963dea0be20604a) - **mysql**: add valid INTERVAL units *(PR [#5951](https://github.com/tobymao/sqlglot/pull/5951) by [@geooo109](https://github.com/geooo109))*
- [`88e4e4c`](https://github.com/tobymao/sqlglot/commit/88e4e4c55f3a113127eb3c82c0be46c29bcf15ab) - **optimizer**: Annotate type for OCTET_LENGTH function *(PR [#5960](https://github.com/tobymao/sqlglot/pull/5960) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`68473ac`](https://github.com/tobymao/sqlglot/commit/68473ac3ec8dc76512dc76819892a1b0324c7ddc) - **optimizer**: Annotate type for snowflake PARSE_URL function *(PR [#5962](https://github.com/tobymao/sqlglot/pull/5962) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`b015a9d`](https://github.com/tobymao/sqlglot/commit/b015a9d944d0a87069a7750ad74953c399d7da34) - **optimizer**: annotate type for Snowflake REGEXP_INSTR function *(commit by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`1f29ba7`](https://github.com/tobymao/sqlglot/commit/1f29ba710f4213beb1a2f993244d7d824f3536ce) - **optimizer**: annotate type for Snowflake PARSE_IP function *(PR [#5961](https://github.com/tobymao/sqlglot/pull/5961) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`bf45d5d`](https://github.com/tobymao/sqlglot/commit/bf45d5d3cb0c0f380824019eb32ec29049268a61) - **optimizer**: annotate types for Snowflake RTRIMMED_LENGTH function *(PR [#5968](https://github.com/tobymao/sqlglot/pull/5968) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`13caa69`](https://github.com/tobymao/sqlglot/commit/13caa6991f003ad7abb590073451e591b6fd888c) - **optimizer**: Annotate type for snowflake POSITION function *(PR [#5964](https://github.com/tobymao/sqlglot/pull/5964) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`1471306`](https://github.com/tobymao/sqlglot/commit/1471306ed317830c294e3654075f55424d14bf5a) - support parse into grant principal and privilege *(PR [#5971](https://github.com/tobymao/sqlglot/pull/5971) by [@eakmanrq](https://github.com/eakmanrq))*
- [`13a30df`](https://github.com/tobymao/sqlglot/commit/13a30dfa37096df5bfc2c31538325c40a49f7917) - **optimizer**: Annotate type for snowflake TRY_BASE64_DECODE_BINARY function *(PR [#5972](https://github.com/tobymao/sqlglot/pull/5972) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`1f5fdd7`](https://github.com/tobymao/sqlglot/commit/1f5fdd799c047de167a4572f7ac26b7ad92167f2) - **optimizer**: Annotate type for snowflake TRY_BASE64_DECODE_STRING function *(PR [#5974](https://github.com/tobymao/sqlglot/pull/5974) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`324e82f`](https://github.com/tobymao/sqlglot/commit/324e82fe1fb11722f91341010602a743b151e055) - **optimizer**: Annotate type for snowflake TRY_HEX_DECODE_BINARY function *(PR [#5975](https://github.com/tobymao/sqlglot/pull/5975) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`6caf99d`](https://github.com/tobymao/sqlglot/commit/6caf99d556a3357ffaa6c294a9babcd30dd5fac5) - **optimizer**: Annotate type for snowflake TRY_HEX_DECODE_STRING function *(PR [#5976](https://github.com/tobymao/sqlglot/pull/5976) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`73186a8`](https://github.com/tobymao/sqlglot/commit/73186a812ce422c108ee81b3de11da6ee9a9e902) - **optimizer**: annotate type for Snowflake REGEXP_COUNT function *(PR [#5963](https://github.com/tobymao/sqlglot/pull/5963) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`6124de7`](https://github.com/tobymao/sqlglot/commit/6124de76fa6d6725e844cd37e09ebfe99469b0ec) - **optimizer**: Annotate type for snowflake SOUNDEX function *(PR [#5986](https://github.com/tobymao/sqlglot/pull/5986) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`244fb48`](https://github.com/tobymao/sqlglot/commit/244fb48fc9c4776f427c08b825d139b1c172fd26) - **optimizer**: annotate type for Snowflake SPLIT_PART function *(PR [#5988](https://github.com/tobymao/sqlglot/pull/5988) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`0d772e0`](https://github.com/tobymao/sqlglot/commit/0d772e0b9d687b24d49203c05d7a90cc1dce02d5) - **snowflake**: add ast node for `DIRECTORY` source *(PR [#5990](https://github.com/tobymao/sqlglot/pull/5990) by [@georgesittas](https://github.com/georgesittas))*
- [`3c7b5c0`](https://github.com/tobymao/sqlglot/commit/3c7b5c0e2dc071b7b9f6da308ba58a3a43da93dc) - **optimizer**: Annotate type for snowflake SOUNDEX_P123 function *(PR [#5987](https://github.com/tobymao/sqlglot/pull/5987) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`475c09b`](https://github.com/tobymao/sqlglot/commit/475c09bd27179db4d186638645698dd4ad6553cd) - **optimizer**: Annotate type for snowflake TRANSLATE function *(PR [#5992](https://github.com/tobymao/sqlglot/pull/5992) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`f25e42e`](https://github.com/tobymao/sqlglot/commit/f25e42e3f5b3b7b671bd724ba7b09a9b07d13995) - **optimizer**: annotate type for Snowflake REGEXP_INSTR function *(PR [#5978](https://github.com/tobymao/sqlglot/pull/5978) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`13cb26e`](https://github.com/tobymao/sqlglot/commit/13cb26e2f29373538d60a8124ddebf95fd22a8d8) - **optimizer**: annotate type for Snowflake REGEXP_SUBSTR_ALL function *(PR [#5979](https://github.com/tobymao/sqlglot/pull/5979) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`4ce683e`](https://github.com/tobymao/sqlglot/commit/4ce683eb8ac5716a334cbd7625438b9f89623c7a) - **optimizer**: Annotate type for snowflake UNICODE function *(PR [#5993](https://github.com/tobymao/sqlglot/pull/5993) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`587196c`](https://github.com/tobymao/sqlglot/commit/587196c9c2d122f73f9deb7e87c2831f27f6ed02) - **optimizer**: Annotate type for snowflake STRTOK_TO_ARRAY function *(PR [#5994](https://github.com/tobymao/sqlglot/pull/5994) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`bced710`](https://github.com/tobymao/sqlglot/commit/bced71084ffb3a8f7a11db843777f05b68f367da) - **optimizer**: Annotate type for snowflake STRTOK function. *(PR [#5991](https://github.com/tobymao/sqlglot/pull/5991) by [@georgesittas](https://github.com/georgesittas))*
- [`74a13f2`](https://github.com/tobymao/sqlglot/commit/74a13f2a548b9cd41061e835cb3cd9dd2a5a9fb3) - **optimizer**: Annotate type for snowflake DIV0 and DIVNULL functions *(PR [#6008](https://github.com/tobymao/sqlglot/pull/6008) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`fec2b31`](https://github.com/tobymao/sqlglot/commit/fec2b31956f2debdad7c53744a577894cd8d747c) - **optimizer**: Annotate type for snowflake SEARCH function *(PR [#5985](https://github.com/tobymao/sqlglot/pull/5985) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`27a76cd`](https://github.com/tobymao/sqlglot/commit/27a76cdfe4212f16f945521eb3997580eacf1d61) - **optimizer**: Annotate type for snowflake COT, SIN and TAN functions *(PR [#6022](https://github.com/tobymao/sqlglot/pull/6022) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`8b48f7b`](https://github.com/tobymao/sqlglot/commit/8b48f7b985342cfcc45bc2b94540a1a2bf5995c4) - **optimizer**: Annotate type for snowflake SIGN and ABS functions *(PR [#6025](https://github.com/tobymao/sqlglot/pull/6025) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`0911276`](https://github.com/tobymao/sqlglot/commit/091127663ab4cb94b02be5aa40c6a46dd7f89243) - **optimizer**: annotate type for Snowflake EXP function *(PR [#6007](https://github.com/tobymao/sqlglot/pull/6007) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`a96d50e`](https://github.com/tobymao/sqlglot/commit/a96d50e14bed5e87ff2dce9c545e0c48897b64d6) - **optimizer**: annotate type for Snowflake COSH function *(PR [#6006](https://github.com/tobymao/sqlglot/pull/6006) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`4df58e0`](https://github.com/tobymao/sqlglot/commit/4df58e0f0b8985590fb29a8ab6ba0ced987ac5b9) - **optimizer**: annotate type for Snowflake DEGREES function *(PR [#6027](https://github.com/tobymao/sqlglot/pull/6027) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`db71a20`](https://github.com/tobymao/sqlglot/commit/db71a2023aaeca2ffda782ae7b91fdee356c402e) - **optimizer**: annotate type for Snowflake COS function *(PR [#6028](https://github.com/tobymao/sqlglot/pull/6028) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`6beb917`](https://github.com/tobymao/sqlglot/commit/6beb9172dffd0aaea46b75477485060737e774b9) - **optimizer**: Annotate type for snowflake ROUND function *(PR [#6032](https://github.com/tobymao/sqlglot/pull/6032) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`8e03ad9`](https://github.com/tobymao/sqlglot/commit/8e03ad9dd087ebc72bf58cb6383607c0ce2e8f8f) - **optimizer**: Annotate type for snowflake MOD function *(PR [#6031](https://github.com/tobymao/sqlglot/pull/6031) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`15b3fac`](https://github.com/tobymao/sqlglot/commit/15b3fac3dd5efd4c347ac40055f07a9be5906802) - **mysql**: support `FOR ORDINALITY` clause in `COLUMN` expression *(PR [#6046](https://github.com/tobymao/sqlglot/pull/6046) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#6039](https://github.com/tobymao/sqlglot/issues/6039) opened by [@jdddog](https://github.com/jdddog)*
- [`56c8b3b`](https://github.com/tobymao/sqlglot/commit/56c8b3bbff7451b9049e1a168716bb41222a86ed) - **hive,spark**: Support CHANGE COLUMN statements in Hive and CHANGE/ALTER COLUMN statements in Spark *(PR [#6004](https://github.com/tobymao/sqlglot/pull/6004) by [@tsamaras](https://github.com/tsamaras))*
- [`6f31b86`](https://github.com/tobymao/sqlglot/commit/6f31b86599258afe156aa3d9ccc42389cac37021) - **optimizer**: Annotate type for snowflake FLOOR function *(PR [#6030](https://github.com/tobymao/sqlglot/pull/6030) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`b7463d5`](https://github.com/tobymao/sqlglot/commit/b7463d5b0a1e286498d7ccfd9a07ef7edfa80bb2) - **optimizer**: Annotate type for snowflake ASIN function. *(PR [#6049](https://github.com/tobymao/sqlglot/pull/6049) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`fe959a5`](https://github.com/tobymao/sqlglot/commit/fe959a5598508526ed5910a4c62372116b5d3c30) - **optimizer**: Annotate type for snowflake CBRT function *(PR [#6050](https://github.com/tobymao/sqlglot/pull/6050) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`cecab2f`](https://github.com/tobymao/sqlglot/commit/cecab2fd66d578ddc765b5fd0e7b155971280a0c) - **optimizer**: annotate type for Snowflake ATANH function *(PR [#6054](https://github.com/tobymao/sqlglot/pull/6054) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`08339a9`](https://github.com/tobymao/sqlglot/commit/08339a902138211f67cfb009d2576b22ea8d8e42) - **optimizer**: annotate type for Snowflake FACTORIAL function *(PR [#6053](https://github.com/tobymao/sqlglot/pull/6053) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`9060f60`](https://github.com/tobymao/sqlglot/commit/9060f603818db863b7570a2c3c50c3eb88155e76) - **optimizer**: Annotate type for snowflake ATAN2 function. *(PR [#6060](https://github.com/tobymao/sqlglot/pull/6060) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`b3eb2e4`](https://github.com/tobymao/sqlglot/commit/b3eb2e4ca6177ee61b27675e8ec8b4815587df31) - **optimizer**: annotate type for Snowflake SINH function *(PR [#6052](https://github.com/tobymao/sqlglot/pull/6052) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`440b960`](https://github.com/tobymao/sqlglot/commit/440b960529801674fa23708212485fda95749699) - **duckdb**: support `USING KEY (...)` in recursive DuckDB CTEs *(PR [#6068](https://github.com/tobymao/sqlglot/pull/6068) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#6066](https://github.com/tobymao/sqlglot/issues/6066) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`157d2fa`](https://github.com/tobymao/sqlglot/commit/157d2fa06ab110ebc760aa7567d7fda801a5ced9) - **optimizer**: annotate type for Snowflake CEIL function *(PR [#6051](https://github.com/tobymao/sqlglot/pull/6051) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`eb6d6e7`](https://github.com/tobymao/sqlglot/commit/eb6d6e7ccde37456ab56ad976e7d95cea23c14e3) - **duckdb**: support `DEFAULT VALUES` clause in `INSERT` DML *(PR [#6067](https://github.com/tobymao/sqlglot/pull/6067) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#6065](https://github.com/tobymao/sqlglot/issues/6065) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`354140d`](https://github.com/tobymao/sqlglot/commit/354140d0a279f317439bdb247e1ab9578f9a035d) - **optimizer**: Annotate type for snowflake TANH and ATAN functions *(PR [#6069](https://github.com/tobymao/sqlglot/pull/6069) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`c94e3e0`](https://github.com/tobymao/sqlglot/commit/c94e3e0e4e20bd76d4cf630123d2c05a0e3044c3) - add ColumnDef expression parser *(PR [#6075](https://github.com/tobymao/sqlglot/pull/6075) by [@geooo109](https://github.com/geooo109))*
- [`c67276d`](https://github.com/tobymao/sqlglot/commit/c67276d5be970252e14d1817d8498fc9985222d9) - **optimizer**: Annotate type for snowflake RADIANS function. *(PR [#6064](https://github.com/tobymao/sqlglot/pull/6064) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`c49ba0e`](https://github.com/tobymao/sqlglot/commit/c49ba0eee21f7776703d2a26c6641b4a32a1cff7) - **optimizer**: Annotate type for snowflake WIDTH_BUCKET function *(PR [#6078](https://github.com/tobymao/sqlglot/pull/6078) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`fbc1f13`](https://github.com/tobymao/sqlglot/commit/fbc1f1335eecaaaab4fc93ddbb74611a4df0aea7) - **optimizer**: annotate type for Snowflake CONVERT_TIMEZONE function *(PR [#6076](https://github.com/tobymao/sqlglot/pull/6076) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`70e977c`](https://github.com/tobymao/sqlglot/commit/70e977c5edfb495529d38a9096cb40762a9b5d7b) - **optimizer**: annotate type for Snowflake DATE_TRUNC function *(PR [#6080](https://github.com/tobymao/sqlglot/pull/6080) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`e9cf146`](https://github.com/tobymao/sqlglot/commit/e9cf146a4a6cd78f6a59c195e7ec12240b836e5e) - **optimizer**: annotate type for Snowflake DATE_PART function *(PR [#6079](https://github.com/tobymao/sqlglot/pull/6079) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`cdf3b1b`](https://github.com/tobymao/sqlglot/commit/cdf3b1b34dc044064d0a5ba7ff22723b8ae33e5d) - **optimizer**: Annotate type for snowflake add_months function *(PR [#6097](https://github.com/tobymao/sqlglot/pull/6097) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`6fe5824`](https://github.com/tobymao/sqlglot/commit/6fe58247888c326093618657fb027e482d82d107) - **optimizer**: Annotate type for hour, minute, second functions *(PR [#6100](https://github.com/tobymao/sqlglot/pull/6100) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`483770b`](https://github.com/tobymao/sqlglot/commit/483770b816fab14b7eb7222974ed2c99045302a7) - **optimizer**: Annotate type for snowflake TIME_SLICE function *(PR [#6098](https://github.com/tobymao/sqlglot/pull/6098) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`071a995`](https://github.com/tobymao/sqlglot/commit/071a9954aad220c1e13ba7a6714a083058a8e03f) - **tsql**: add support for iso_week on DATEPART *(PR [#6111](https://github.com/tobymao/sqlglot/pull/6111) by [@lBilali](https://github.com/lBilali))*
  - :arrow_lower_right: *addresses issue [#6110](https://github.com/tobymao/sqlglot/issues/6110) opened by [@lBilali](https://github.com/lBilali)*
- [`c286cee`](https://github.com/tobymao/sqlglot/commit/c286cee54ab93e1fd0b3be658f7e767e3e00afe9) - **optimizer**: Annotate type for snowflake MONTHNAME function *(PR [#6116](https://github.com/tobymao/sqlglot/pull/6116) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`1a34788`](https://github.com/tobymao/sqlglot/commit/1a34788025bdd8a018c4bb9214f72152e68bdd14) - **optimizer**: Annotate type for snowflake PREVIOUS_DAY function *(PR [#6117](https://github.com/tobymao/sqlglot/pull/6117) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`533faf8`](https://github.com/tobymao/sqlglot/commit/533faf87b6df351070b565dd1fe9ce4e13b6c46e) - **spark**: transpile duckdb `READ_PARQUET` to `parquet.<path>` closes [#6122](https://github.com/tobymao/sqlglot/pull/6122) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`cd4e557`](https://github.com/tobymao/sqlglot/commit/cd4e557658b1384f36c9a1ef9da5a09b893229b1) - **optimizer**: Annotate type for snowflake RANDOM function *(PR [#6124](https://github.com/tobymao/sqlglot/pull/6124) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`fe63d84`](https://github.com/tobymao/sqlglot/commit/fe63d84f1bd365b22221f348d79c0546aa3118b0) - **optimizer**: annotate type for Snowflake MONTHS_BETWEEN function *(PR [#6120](https://github.com/tobymao/sqlglot/pull/6120) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`7cb7598`](https://github.com/tobymao/sqlglot/commit/7cb7598e13260aa45c851dc620b4994ddfa089fe) - **optimizer**: Annotate type for snowflake TIME_FROM_PARTS function *(PR [#6119](https://github.com/tobymao/sqlglot/pull/6119) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`598d09b`](https://github.com/tobymao/sqlglot/commit/598d09b036d938c90a44955d67175ea868090ba2) - **optimizer**: annotate type for Snowflake DATEADD function *(PR [#6089](https://github.com/tobymao/sqlglot/pull/6089) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`b98bcee`](https://github.com/tobymao/sqlglot/commit/b98bcee148ba426816e166dbfa9ba8e0979aae21) - **optimizer**: Annotate type for snowflake next_day function *(PR [#6125](https://github.com/tobymao/sqlglot/pull/6125) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`fe1927f`](https://github.com/tobymao/sqlglot/commit/fe1927f28600e2d8863a4e7f06e6a21bf6ff7f9c) - **duckdb**: Transpile unix_micros to epoch_us *(PR [#6127](https://github.com/tobymao/sqlglot/pull/6127) by [@vchan](https://github.com/vchan))*
- [`a531f10`](https://github.com/tobymao/sqlglot/commit/a531f107235c29ac6a7e627a323f00b8ecf7023d) - **duckdb**: transpile TimeSub *(PR [#6142](https://github.com/tobymao/sqlglot/pull/6142) by [@toriwei](https://github.com/toriwei))*
- [`b1a9dff`](https://github.com/tobymao/sqlglot/commit/b1a9dfff52a0ffbb0b7c8bfedb0a90e245b97851) - make qualify faster by owly resetting scope when needed *(PR [#6081](https://github.com/tobymao/sqlglot/pull/6081) by [@tobymao](https://github.com/tobymao))*
- [`3a334f3`](https://github.com/tobymao/sqlglot/commit/3a334f376b9766b6b99fdf195ae763bb44976ec4) - **optimizer**: annotate type for boolnot snowflake function *(PR [#6141](https://github.com/tobymao/sqlglot/pull/6141) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`4e36f9d`](https://github.com/tobymao/sqlglot/commit/4e36f9dd6a854b378c9bbf6b2e9811045affc63d) - **optimizer**: Annotate type for snowflake TIMEADD function *(PR [#6134](https://github.com/tobymao/sqlglot/pull/6134) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`5242cdd`](https://github.com/tobymao/sqlglot/commit/5242cddf487e367e7f543ca19d9bccae858f36ac) - **optimizer**: annotate type for bq LENGTH *(commit by [@geooo109](https://github.com/geooo109))*
- [`0fc6dbf`](https://github.com/tobymao/sqlglot/commit/0fc6dbf2e7b611fa0977e3c3e61be1cc84bcf4a9) - **snowflake**: add GREATEST_IGNORE_NULLS function support *(PR [#6161](https://github.com/tobymao/sqlglot/pull/6161) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`54ecadc`](https://github.com/tobymao/sqlglot/commit/54ecadc57b8f1e87fd2a2ba35a5366d75231ea85) - **duckdb**: support `KV_METADATA` in `COPY` statement closes [#6165](https://github.com/tobymao/sqlglot/pull/6165) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`e241964`](https://github.com/tobymao/sqlglot/commit/e2419642a4966a4da194147aa488793eae152af4) - **duckdb**: support `USING` condition for `MERGE` closes [#6162](https://github.com/tobymao/sqlglot/pull/6162) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`bcf6c89`](https://github.com/tobymao/sqlglot/commit/bcf6c89a47abd3c2c4383d1c908f892b6619b6fa) - **optimizer**: add type annotation tests for snowflake BOOLAND *(PR [#6153](https://github.com/tobymao/sqlglot/pull/6153) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`52d1eec`](https://github.com/tobymao/sqlglot/commit/52d1eecaad505703e8b22dcfe8954652f57985b6) - **optimizer**: Annotate type for snowflake TIMESTAMP_FROM_PARTS function *(PR [#6139](https://github.com/tobymao/sqlglot/pull/6139) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`8651fe6`](https://github.com/tobymao/sqlglot/commit/8651fe6526dea865c0d54d6d53086359a7835d32) - **optimizer**: annotate types for BOOLOR *(PR [#6159](https://github.com/tobymao/sqlglot/pull/6159) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`812ba9a`](https://github.com/tobymao/sqlglot/commit/812ba9abad8247df81c8f8b514336c8766292112) - **optimizer**: Annotate type for snowflake date parts functions *(PR [#6158](https://github.com/tobymao/sqlglot/pull/6158) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`9f8c123`](https://github.com/tobymao/sqlglot/commit/9f8c123ae44249e274334d0aa551ac33814f2b32) - make qualify table callback more generic *(PR [#6171](https://github.com/tobymao/sqlglot/pull/6171) by [@tobymao](https://github.com/tobymao))*
- [`74b4e7c`](https://github.com/tobymao/sqlglot/commit/74b4e7c311e9d4ff39ce2e4d91940eced96aa32f) - **optimizer**: fix type annotation for Snowflake BOOLOR and BOOLAND *(PR [#6169](https://github.com/tobymao/sqlglot/pull/6169) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`e90168a`](https://github.com/tobymao/sqlglot/commit/e90168a6829b85534edcecec7d0df2a8b1b56fc4) - **optimizer**: annotate type for Snowflake's `IS_NULL_VALUE` function *(PR [#6186](https://github.com/tobymao/sqlglot/pull/6186) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`cea2595`](https://github.com/tobymao/sqlglot/commit/cea25952c98e70f2a4c35e675fe7ee4df0af02cd) - **duckdb**: Transpile DATE function from BQ->DuckDB *(PR [#6178](https://github.com/tobymao/sqlglot/pull/6178) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`00aaa47`](https://github.com/tobymao/sqlglot/commit/00aaa47feff1cf9e69320074c35d9adfc8538026) - **duckDB**: Transpile BigQuery's CURRENT_DATE (Conversion) function to DuckDB *(PR [#6189](https://github.com/tobymao/sqlglot/pull/6189) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`c93b535`](https://github.com/tobymao/sqlglot/commit/c93b5354827282c806899c36b11e7a7598e96e38) - **snowflake**: annotate type for LEAST_IGNORE_NULLS *(PR [#6196](https://github.com/tobymao/sqlglot/pull/6196) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`d2162fb`](https://github.com/tobymao/sqlglot/commit/d2162fbece0747b8ee42fa1f78e26baa0c944d41) - check same ref on Expression.__eq__ *(PR [#6200](https://github.com/tobymao/sqlglot/pull/6200) by [@georgesittas](https://github.com/georgesittas))*
- [`f60c71f`](https://github.com/tobymao/sqlglot/commit/f60c71fb03db91bfe90430d032ac16f4945d5dff) - **optimizer**: annotate types for REGR_VALX *(PR [#6198](https://github.com/tobymao/sqlglot/pull/6198) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`42e0ae4`](https://github.com/tobymao/sqlglot/commit/42e0ae43b3531bf6c593bcac2ece2ab1d969e5e1) - **duckdb**: transpile BigQuery function TIMESTAMP_SUB to DuckDB *(PR [#6202](https://github.com/tobymao/sqlglot/pull/6202) by [@toriwei](https://github.com/toriwei))*
- [`b82c571`](https://github.com/tobymao/sqlglot/commit/b82c57131707297abe174539023b9cb62b7cd6c7) - **snowflake**: annotate types for REGR_VALY *(PR [#6206](https://github.com/tobymao/sqlglot/pull/6206) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`39d8e19`](https://github.com/tobymao/sqlglot/commit/39d8e19419c2adbb80465be414d1cc3bbc6d007b) - **snowflake**: include VARIABLE kind in SET transpilation to DuckDB *(PR [#6201](https://github.com/tobymao/sqlglot/pull/6201) by [@toriwei](https://github.com/toriwei))*
  - :arrow_lower_right: *addresses issue [#6177](https://github.com/tobymao/sqlglot/issues/6177) opened by [@baruchoxman](https://github.com/baruchoxman)*
- [`0037266`](https://github.com/tobymao/sqlglot/commit/00372664bf6acf2b0fff9ad4b206b597ef5378f7) - **snowflake**: annotate types for GETBIT *(PR [#6219](https://github.com/tobymao/sqlglot/pull/6219) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`a5458ce`](https://github.com/tobymao/sqlglot/commit/a5458ceca3bc239fb611791e38020632dd0824c8) - **snowflake**: add type annotation for DECODE function support *(PR [#6199](https://github.com/tobymao/sqlglot/pull/6199) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`a9d0f63`](https://github.com/tobymao/sqlglot/commit/a9d0f6333c38ffb0b5afc3c213ac7bf008d98ad6) - **DuckDB**: Transpile unix_millis to epoch_ms *(PR [#6224](https://github.com/tobymao/sqlglot/pull/6224) by [@vchan](https://github.com/vchan))*
- [`238f705`](https://github.com/tobymao/sqlglot/commit/238f705940751f09464ee0f8260186f3f8124374) - **DuckDB**: Transpile unix_seconds to epoch *(PR [#6225](https://github.com/tobymao/sqlglot/pull/6225) by [@vchan](https://github.com/vchan))*
- [`c8b0129`](https://github.com/tobymao/sqlglot/commit/c8b0129380df389be6ff22cafb4251181e919d23) - **exasol**: support bracket-delimited identifiers *(PR [#6231](https://github.com/tobymao/sqlglot/pull/6231) by [@JoepvandenHoven-Bluemine](https://github.com/JoepvandenHoven-Bluemine))*
- [`417f1e8`](https://github.com/tobymao/sqlglot/commit/417f1e8ee50fb8f4377fad261660ffbd7444a429) - **snowflake**: annotate types for BITNOT *(PR [#6234](https://github.com/tobymao/sqlglot/pull/6234) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`fe8ab40`](https://github.com/tobymao/sqlglot/commit/fe8ab40e8e0559201e0b1896a6f1a8fb6b5b932d) - **snowflake**: 1st-class parsing support for BITAND, BIT_AND, BIT_NOT *(PR [#6243](https://github.com/tobymao/sqlglot/pull/6243) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`5ae3c47`](https://github.com/tobymao/sqlglot/commit/5ae3c47b1c6993b87341472c08714f4a0f738168) - **snowflake**: add type annotation for GROUPING() function *(PR [#6244](https://github.com/tobymao/sqlglot/pull/6244) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`4133265`](https://github.com/tobymao/sqlglot/commit/413326514507ef06537dcc3d4b80a3fcbcd26f66) - **clickhouse**: parse `has` function into an `ArrayContains` expression *(PR [#6245](https://github.com/tobymao/sqlglot/pull/6245) by [@joeyutong](https://github.com/joeyutong))*
- [`b722aa2`](https://github.com/tobymao/sqlglot/commit/b722aa2d4b65c698921066426838f080a31bdc35) - **duckdb**: cast LOWER() result to BLOB if input is bytes *(PR [#6218](https://github.com/tobymao/sqlglot/pull/6218) by [@toriwei](https://github.com/toriwei))*
- [`cdd45b9`](https://github.com/tobymao/sqlglot/commit/cdd45b949fd1eefb147053424279b56b8effcbcf) - **optimizer**: annotate types for GROUPING_ID function. *(PR [#6249](https://github.com/tobymao/sqlglot/pull/6249) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`080ff3b`](https://github.com/tobymao/sqlglot/commit/080ff3bd93b36291d5bb0092d722f8307f0ae082) - **snowflake**: annotate types for BITAND_AGG *(PR [#6248](https://github.com/tobymao/sqlglot/pull/6248) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`87a818a`](https://github.com/tobymao/sqlglot/commit/87a818a899f61a675c22c697f468b3f6f7e2787f) - **snowflake**: annotate types for BITOR_AGG  *(PR [#6251](https://github.com/tobymao/sqlglot/pull/6251) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`a1b884d`](https://github.com/tobymao/sqlglot/commit/a1b884dc9ddfd2185de48cc9451a39f152879d39) - **snowflake**: annotate types for BITXOR_AGG *(PR [#6253](https://github.com/tobymao/sqlglot/pull/6253) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`71d93b1`](https://github.com/tobymao/sqlglot/commit/71d93b181d2aa3a77a022820446d6fec0133291f) - **duckdb**: implement casting to blob for UPPER() and move to helper method *(PR [#6254](https://github.com/tobymao/sqlglot/pull/6254) by [@toriwei](https://github.com/toriwei))*
- [`ad2ad23`](https://github.com/tobymao/sqlglot/commit/ad2ad234b5a508040dce4f3920439be052742573) - **snowflake**: add missing return type mapping for MAX_BY and MAX_BY function *(PR [#6250](https://github.com/tobymao/sqlglot/pull/6250) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`39c1d81`](https://github.com/tobymao/sqlglot/commit/39c1d81174f2390b6b0c9dd14c0e550ad452a1df) - **snowflake**: annotate types for BOOLXOR_AGG *(PR [#6261](https://github.com/tobymao/sqlglot/pull/6261) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`71590d2`](https://github.com/tobymao/sqlglot/commit/71590d22cdb05594e2173a1500f763dc1a32a81d) - **snowflake**: add type annotation for SKEW function. *(PR [#6262](https://github.com/tobymao/sqlglot/pull/6262) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`5fd366d`](https://github.com/tobymao/sqlglot/commit/5fd366d9e6f7b3f1eb7a9cf41975cf13ce890ffe) - **snowflake**: annotate types for OBJECT_AGG *(PR [#6265](https://github.com/tobymao/sqlglot/pull/6265) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`3dae0fb`](https://github.com/tobymao/sqlglot/commit/3dae0fbb528762e5d5fd446350d42e9c841e2959) - **duckdb**: Support position and occurrence args for REGEXP_EXTRACT *(PR [#6266](https://github.com/tobymao/sqlglot/pull/6266) by [@vchan](https://github.com/vchan))*
- [`dba0414`](https://github.com/tobymao/sqlglot/commit/dba04145c4bcda8c55890b4d7173dd6c0a64c37e) - **clickhouse**: Parse toStartOfxxx into exp.TimestampTrunc *(PR [#6268](https://github.com/tobymao/sqlglot/pull/6268) by [@joeyutong](https://github.com/joeyutong))*
- [`d959ad0`](https://github.com/tobymao/sqlglot/commit/d959ad02140d692483a63b67d69d2a5d49954ea3) - transpile DuckDB exclusive end RANGE to SEQUENCE *(PR [#6270](https://github.com/tobymao/sqlglot/pull/6270) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#6267](https://github.com/tobymao/sqlglot/issues/6267) opened by [@joeyutong](https://github.com/joeyutong)*
- [`771732d`](https://github.com/tobymao/sqlglot/commit/771732d81459cc576f11eccc49794f33e62d14af) - **snowflake**: annotate types for REGR_AVGY *(PR [#6271](https://github.com/tobymao/sqlglot/pull/6271) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`8470be0`](https://github.com/tobymao/sqlglot/commit/8470be00731a4d79518a533a5f7ba884fa2f047e) - **snowflake**: add type annotation for BITMAP_COUNT function. *(PR [#6274](https://github.com/tobymao/sqlglot/pull/6274) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`98f25f9`](https://github.com/tobymao/sqlglot/commit/98f25f92cc1175ac7b2118a5a342db82adade13a) - **clickhouse**: support splitBy function *(PR [#6278](https://github.com/tobymao/sqlglot/pull/6278) by [@joeyutong](https://github.com/joeyutong))*
- [`fabbf05`](https://github.com/tobymao/sqlglot/commit/fabbf057aba88f30205767d8c339727de45991c8) - **duckDB**: Add support for shorthand struct array literals in duckDB. *(PR [#6233](https://github.com/tobymao/sqlglot/pull/6233) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`a909fde`](https://github.com/tobymao/sqlglot/commit/a909fde068919823dc4cccc2655af48e4290137a) - **duckdb**: Add support for CREATE MACRO *(PR [#6292](https://github.com/tobymao/sqlglot/pull/6292) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#6290](https://github.com/tobymao/sqlglot/issues/6290) opened by [@francescomucio](https://github.com/francescomucio)*
- [`11989be`](https://github.com/tobymao/sqlglot/commit/11989be34153ccdedeab3ab18ccf735f86e8b822) - add more expressions with positional meta *(PR [#6289](https://github.com/tobymao/sqlglot/pull/6289) by [@tobymao](https://github.com/tobymao))*
- [`87651a6`](https://github.com/tobymao/sqlglot/commit/87651a671db2fe6162f06e2dcdef0b98e229bea5) - semantic facts closes [#6287](https://github.com/tobymao/sqlglot/pull/6287) *(PR [#6288](https://github.com/tobymao/sqlglot/pull/6288) by [@tobymao](https://github.com/tobymao))*
- [`9c1a222`](https://github.com/tobymao/sqlglot/commit/9c1a2221b0327ba6848542c7b906e92f25a05bea) - **snowflake**: add type annotation for BITMAP_CONSTRUCT_AGG function. *(PR [#6285](https://github.com/tobymao/sqlglot/pull/6285) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`358105d`](https://github.com/tobymao/sqlglot/commit/358105d1296c7425e071ccf3189a31a02c00c923) - **snowflake**: type annotation for BITMAP_BIT_POSITION function *(PR [#6301](https://github.com/tobymao/sqlglot/pull/6301) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`4ee7a50`](https://github.com/tobymao/sqlglot/commit/4ee7a500cc460b6f6a1ed103a12dca72e6d01c18) - **snowflake**: type inference for BITMAP_OR_AGG *(PR [#6297](https://github.com/tobymao/sqlglot/pull/6297) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`fcd537d`](https://github.com/tobymao/sqlglot/commit/fcd537de2c993ad0bd18acd84dbae354165f7d3f) - **snowflake**: conflict resolution. type annotation for BITMAP_BUCKET_NUMBER function. Tests added all dialects that support BITMAP_BUCKET_NUMBER *(PR [#6299](https://github.com/tobymao/sqlglot/pull/6299) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`3dffd59`](https://github.com/tobymao/sqlglot/commit/3dffd598496a9f2d94caec9d7f3dcb9791c94019) - **snowflake**: annotate types for PERCENTILE_DISC and WithinGroup *(PR [#6300](https://github.com/tobymao/sqlglot/pull/6300) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`6ce3cd7`](https://github.com/tobymao/sqlglot/commit/6ce3cd7de958d9f3773579ab22ae6cbbcb56ceb0) - **sqlite**: support binary `MATCH` operator closes [#6305](https://github.com/tobymao/sqlglot/pull/6305) *(PR [#6306](https://github.com/tobymao/sqlglot/pull/6306) by [@georgesittas](https://github.com/georgesittas))*
- [`e903883`](https://github.com/tobymao/sqlglot/commit/e90388328fcf5b8061c99e325b87d5beb0046ffc) - **snowflake**: type annotation for APPROX_TOP_K_ACCUMULATE functio… *(PR [#6309](https://github.com/tobymao/sqlglot/pull/6309) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`afc0242`](https://github.com/tobymao/sqlglot/commit/afc0242c564f8de53e11865c2fba43fb36df0694) - **duckDB**: Cast inputs (BLOB → VARCHAR) for duckDB STARTS_WITH *(PR [#6240](https://github.com/tobymao/sqlglot/pull/6240) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`d170bbd`](https://github.com/tobymao/sqlglot/commit/d170bbde800a0308aaf8c81e59152c65be312155) - **duckdb**: transpile bigquery's `BYTES` variant of `REPLACE` *(PR [#6312](https://github.com/tobymao/sqlglot/pull/6312) by [@toriwei](https://github.com/toriwei))*
- [`d3fefad`](https://github.com/tobymao/sqlglot/commit/d3fefad80d25ff5a6dd02426667ff0ea8478a1b2) - **tsql**: support `DATEDIFF_BIG` *(PR [#6323](https://github.com/tobymao/sqlglot/pull/6323) by [@lBilali](https://github.com/lBilali))*
- [`21d1468`](https://github.com/tobymao/sqlglot/commit/21d1468377b9c8ad48c6cca1ae3b3744a807c29e) - **optimizer**: annotate type for APPROX_TOP_K *(PR [#6286](https://github.com/tobymao/sqlglot/pull/6286) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`93b4039`](https://github.com/tobymao/sqlglot/commit/93b4039f957f3eefbaaed2cb147bfa8c8c2a304e) - **duckdb**: preserve time zone and timestamp in DATE_TRUNC() *(PR [#6318](https://github.com/tobymao/sqlglot/pull/6318) by [@toriwei](https://github.com/toriwei))*
- [`b71990f`](https://github.com/tobymao/sqlglot/commit/b71990f528d55c845f5771bfc4c5f6098eb97ad7) - **duckdb**: Add transpilation support for ANY_VALUE function with HAVING MAX and MIN clauses *(PR [#6325](https://github.com/tobymao/sqlglot/pull/6325) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`64c0d55`](https://github.com/tobymao/sqlglot/commit/64c0d554207ad40bcd6a93c20d15020752a5929d) - **sqlite**: support indexed table clause closes [#6331](https://github.com/tobymao/sqlglot/pull/6331) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`6725217`](https://github.com/tobymao/sqlglot/commit/6725217d4058b5202006576bdf6ff4ec7230a9b9) - **sqlite**: support `NOT NULL` operator closes [#6334](https://github.com/tobymao/sqlglot/pull/6334) closes [#6335](https://github.com/tobymao/sqlglot/pull/6335) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`ca81217`](https://github.com/tobymao/sqlglot/commit/ca812171ab800e3faa73ea1874dd6814c8d6f701) - **duckdb**: Transpile INITCAP with custom delimiters *(PR [#6302](https://github.com/tobymao/sqlglot/pull/6302) by [@treysp](https://github.com/treysp))*
- [`7484c06`](https://github.com/tobymao/sqlglot/commit/7484c06be4534cd22dee14da542d5e29ff2c13a2) - **DuckDB**: Support rounding mode argument for ROUND function *(PR [#6350](https://github.com/tobymao/sqlglot/pull/6350) by [@vchan](https://github.com/vchan))*
- [`79e314d`](https://github.com/tobymao/sqlglot/commit/79e314df76161319ba8495b95f54603cfef0c08a) - **duckdb**: handle casting BLOB input for TRIM() *(PR [#6353](https://github.com/tobymao/sqlglot/pull/6353) by [@toriwei](https://github.com/toriwei))*
- [`c495a40`](https://github.com/tobymao/sqlglot/commit/c495a40ee4c1a69b14892e8455ae1bd2ceb5ea4f) - **optimizer**: annotate type for MINHASH *(PR [#6355](https://github.com/tobymao/sqlglot/pull/6355) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`f16f8a0`](https://github.com/tobymao/sqlglot/commit/f16f8a08072556fd617b5125300262d9bb8c1e48) - improve validate qualify column message closes [#6348](https://github.com/tobymao/sqlglot/pull/6348) *(PR [#6356](https://github.com/tobymao/sqlglot/pull/6356) by [@tobymao](https://github.com/tobymao))*
- [`17abe23`](https://github.com/tobymao/sqlglot/commit/17abe231bc4d59912952f266ad4df86ece22c8d2) - make simplify more efficient in number of iterations *(PR [#6351](https://github.com/tobymao/sqlglot/pull/6351) by [@tobymao](https://github.com/tobymao))*
- [`b1f9a97`](https://github.com/tobymao/sqlglot/commit/b1f9a976be3c0bcd895bef5bcdb95a013eeb28b7) - **optimizer**: annotate type for APPROXIMATE_SIMILARITY *(PR [#6360](https://github.com/tobymao/sqlglot/pull/6360) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`3aafca7`](https://github.com/tobymao/sqlglot/commit/3aafca74546b932cea93ed830c021f347ae03ded) - **optimizer**: annotate type for MINHASH_COMBINE *(PR [#6362](https://github.com/tobymao/sqlglot/pull/6362) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`09a4bd8`](https://github.com/tobymao/sqlglot/commit/09a4bd8870a075e641c6e3e4cee74d73a39e760a) - Trigger integration tests *(PR [#6339](https://github.com/tobymao/sqlglot/pull/6339) by [@erindru](https://github.com/erindru))*
- [`7769129`](https://github.com/tobymao/sqlglot/commit/7769129eba7ae5f3594e0061bdb1079fedc5aafd) - bignum and time_ns to duckdb closes [#6379](https://github.com/tobymao/sqlglot/pull/6379) *(commit by [@tobymao](https://github.com/tobymao))*
- [`90a3fa9`](https://github.com/tobymao/sqlglot/commit/90a3fa9f6ddf0aa32b41118c59d4facd9fdb3398) - mark IgnoreNulls and RespectNulls as unsupported on postgres and mysql *(PR [#6377](https://github.com/tobymao/sqlglot/pull/6377) by [@NickCrews](https://github.com/NickCrews))*
  - :arrow_lower_right: *addresses issue [#6376](https://github.com/tobymao/sqlglot/issues/6376) opened by [@NickCrews](https://github.com/NickCrews)*
- [`5bb1170`](https://github.com/tobymao/sqlglot/commit/5bb117082caeee719442d783ce6742d027b1492e) - transpile bigquery `greatest` null handling to duckdb *(PR [#6361](https://github.com/tobymao/sqlglot/pull/6361) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`bf07abd`](https://github.com/tobymao/sqlglot/commit/bf07abd4ee9eb0f5510cb7d1f232bdcaea88941e) - **snowflake**: annotation support for  APPROX_TOP_K_COMBINE  *(PR [#6378](https://github.com/tobymao/sqlglot/pull/6378) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`01890eb`](https://github.com/tobymao/sqlglot/commit/01890eb16d6624de4f26b7d8eadf850df6f2a042) - **trino**: support refresh materialized view statement closes [#6387](https://github.com/tobymao/sqlglot/pull/6387) *(PR [#6388](https://github.com/tobymao/sqlglot/pull/6388) by [@georgesittas](https://github.com/georgesittas))*
- [`e4ea6cc`](https://github.com/tobymao/sqlglot/commit/e4ea6ccf08c0ff4063424bf538bc3b22f4b4cfaf) - transpile BQ APPROX_QUANTILES to DuckDB *(PR [#6349](https://github.com/tobymao/sqlglot/pull/6349) by [@treysp](https://github.com/treysp))*
- [`95727f6`](https://github.com/tobymao/sqlglot/commit/95727f60d601796b34c850dee9366d79f6e4a24b) - **optimizer**: canonicalize table aliases *(PR [#6369](https://github.com/tobymao/sqlglot/pull/6369) by [@georgesittas](https://github.com/georgesittas))*
- [`3b6855b`](https://github.com/tobymao/sqlglot/commit/3b6855b9787111f27225108241fbe4f389443e29) - **mysql**: support ZEROFILL column attribute *(PR [#6400](https://github.com/tobymao/sqlglot/pull/6400) by [@nian0114](https://github.com/nian0114))*
  - :arrow_lower_right: *addresses issue [#6399](https://github.com/tobymao/sqlglot/issues/6399) opened by [@nian0114](https://github.com/nian0114)*
- [`bb4eda1`](https://github.com/tobymao/sqlglot/commit/bb4eda1beb68b92de9ab014a63c67797a07df2fa) - **duckdb**: support transpiling SHA1 from BigQuery to DuckDB *(PR [#6404](https://github.com/tobymao/sqlglot/pull/6404) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`05e83b5`](https://github.com/tobymao/sqlglot/commit/05e83b56f1bf9323cfa819a7f1beb542524c1219) - **duckdb**: support transpilation of LEAST from BigQuery to DuckDB *(PR [#6415](https://github.com/tobymao/sqlglot/pull/6415) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`38472ce`](https://github.com/tobymao/sqlglot/commit/38472ce14bce731ba4c309d515223ae99e2575ac) - **duckdb**: transpile bigquery's %x format literal *(PR [#6375](https://github.com/tobymao/sqlglot/pull/6375) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`a6e1581`](https://github.com/tobymao/sqlglot/commit/a6e15811cf5643bcc18e1e227fea20922b05c54a) - **DuckDB**: Cast BIGNUMERIC and BIGDECIMAL types to DECIMAL(38, 5) *(PR [#6419](https://github.com/tobymao/sqlglot/pull/6419) by [@vchan](https://github.com/vchan))*
- [`0b9d8ac`](https://github.com/tobymao/sqlglot/commit/0b9d8acbe75457424436e8c0acc047ab66e9fdc0) - **snowflake**: Annotate type for snowflake MAX function *(PR [#6422](https://github.com/tobymao/sqlglot/pull/6422) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`68e9414`](https://github.com/tobymao/sqlglot/commit/68e9414725a60b2842d870fa222d8466057a94f6) - **snowflake**: Annotate type for snowflake MIN function *(PR [#6427](https://github.com/tobymao/sqlglot/pull/6427) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`1318de7`](https://github.com/tobymao/sqlglot/commit/1318de77a8aa514ec7eb9f9b8c03228e3f8eb008) - **snowflake**: Annotate type for snowflake NORMAL *(PR [#6434](https://github.com/tobymao/sqlglot/pull/6434) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`ffbb5c7`](https://github.com/tobymao/sqlglot/commit/ffbb5c7e40aa064ffcd4827e96ea66cfd045118e) - **snowflake**: annotate type for HASH_AGG in Snowflake *(PR [#6438](https://github.com/tobymao/sqlglot/pull/6438) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`161255f`](https://github.com/tobymao/sqlglot/commit/161255f6c90b9c3ed2074e734f6d074db1d7a6dd) - Add support for `LOCALTIME` function *(PR [#6443](https://github.com/tobymao/sqlglot/pull/6443) by [@VaggelisD](https://github.com/VaggelisD))*
- [`ca329f0`](https://github.com/tobymao/sqlglot/commit/ca329f037a230c315437d830638b514190764c5a) - **duckdb**: support transpilation of SHA256 from bigquery to duckdb *(PR [#6421](https://github.com/tobymao/sqlglot/pull/6421) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`e18ae24`](https://github.com/tobymao/sqlglot/commit/e18ae248423dbbca78a24a60ea0193da2ee7f68c) - **snowflake**: Annotate type for snowflake REGR_SLOPE function *(PR [#6425](https://github.com/tobymao/sqlglot/pull/6425) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`1d847f0`](https://github.com/tobymao/sqlglot/commit/1d847f0a1f88fce5df340ab646a72c8abbc12a86) - **snowflake**: parse & annotate `CHECK_JSON`, `CHECK_XML` *(PR [#6439](https://github.com/tobymao/sqlglot/pull/6439) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`6843812`](https://github.com/tobymao/sqlglot/commit/68438129ceeea70f801e0ae728c51c19291fc7d8) - add correlation id to remote workflow trigger *(PR [#6441](https://github.com/tobymao/sqlglot/pull/6441) by [@erindru](https://github.com/erindru))*
- [`cb3080d`](https://github.com/tobymao/sqlglot/commit/cb3080d4bed18b1bfbbd08380ed60deeefd15530) - **snowflake**: annotation support for APPROX_TOP_K_ESTIMATE . Return type ARRAY *(PR [#6445](https://github.com/tobymao/sqlglot/pull/6445) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`cd9f037`](https://github.com/tobymao/sqlglot/commit/cd9f037882eef253e86fdb1d51521e0acd7db3f9) - **optimizer**: store pk name if provided *(PR [#6424](https://github.com/tobymao/sqlglot/pull/6424) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`65194e4`](https://github.com/tobymao/sqlglot/commit/65194e465489151aa51859a6e3f5672f7d4c5f3b) - **snowflake**: Annotate type for snowflake RANDSTR function *(PR [#6436](https://github.com/tobymao/sqlglot/pull/6436) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`351d783`](https://github.com/tobymao/sqlglot/commit/351d7834915e02a9f4949f9925437e2731f3a8b4) - add support for LOCALTIMESTAMP *(PR [#6448](https://github.com/tobymao/sqlglot/pull/6448) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`a56262e`](https://github.com/tobymao/sqlglot/commit/a56262e6b4276baae144855478807c173db77ab9) - **snowflake**: Annotate type for snowflake MEDIAN *(PR [#6426](https://github.com/tobymao/sqlglot/pull/6426) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`2c56567`](https://github.com/tobymao/sqlglot/commit/2c56567755c8a6571d8b7d410c9de943e54df58b) - **snowflake**: Annotate type for snowflake SEARCH_IP  *(PR [#6440](https://github.com/tobymao/sqlglot/pull/6440) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`ac86568`](https://github.com/tobymao/sqlglot/commit/ac86568a939f692b99813da100297b61fb54e044) - **snowflake**: Added decfloat type *(PR [#6444](https://github.com/tobymao/sqlglot/pull/6444) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`ebe718a`](https://github.com/tobymao/sqlglot/commit/ebe718a72d5b5871a8d6e67754ff50e873d55b41) - **duckdb**: Add support for format elements used in date/time functions like FORMAT_DATETIME *(PR [#6428](https://github.com/tobymao/sqlglot/pull/6428) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`c111f64`](https://github.com/tobymao/sqlglot/commit/c111f643d61064280024b4cc5c0fc250581fbe55) - **snowflake**: annotation support for APPROX_PERCENTILE_ACCUMULATE *(PR [#6455](https://github.com/tobymao/sqlglot/pull/6455) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`a7d211e`](https://github.com/tobymao/sqlglot/commit/a7d211e6fdce968c64b050c77e026cc23fdc07e5) - **duckdb**: transpile DECFLOAT type to DECIMAL(38, 5) *(PR [#6462](https://github.com/tobymao/sqlglot/pull/6462) by [@toriwei](https://github.com/toriwei))*
- [`94d46b8`](https://github.com/tobymao/sqlglot/commit/94d46b8eafd5abe252407d2bbe306ca579a29b20) - **snowflake**: annotation support for APPROX_PERCENTILE_ESTIMATE. Return type DOUBLE *(PR [#6461](https://github.com/tobymao/sqlglot/pull/6461) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`2ac30b0`](https://github.com/tobymao/sqlglot/commit/2ac30b08bd663bbaf00ae075c4db0c3d27ab6640) - **snowflake**: annotation support for APPROX_PERCENTILE_COMBINE *(PR [#6460](https://github.com/tobymao/sqlglot/pull/6460) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`d44bda3`](https://github.com/tobymao/sqlglot/commit/d44bda376c06956947a09a9f279cce886a63b981) - **optimizer**: Annotate type for ZIPF *(PR [#6453](https://github.com/tobymao/sqlglot/pull/6453) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`34dbd47`](https://github.com/tobymao/sqlglot/commit/34dbd478957c1796998d0b263f63c8ce1db7a320) - **optimizer**: Annotate type for XMLGET *(PR [#6457](https://github.com/tobymao/sqlglot/pull/6457) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`ff3f0f9`](https://github.com/tobymao/sqlglot/commit/ff3f0f998674f5b2741c3f6cadbe24fa8fb607ad) - **databricks**: add support for ?:: operator *(PR [#6469](https://github.com/tobymao/sqlglot/pull/6469) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`0d211f2`](https://github.com/tobymao/sqlglot/commit/0d211f2b36167cfb7856b8ec25f597f70317a9c7) - **snowflake**: annotate type for MODE function snowflake *(PR [#6447](https://github.com/tobymao/sqlglot/pull/6447) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`cc4c8ab`](https://github.com/tobymao/sqlglot/commit/cc4c8ab43ab71790bc2bb9f8f3c06e34f89f999f) - **snowflake**: annotate type for PERCENTILE_CONT in Snowflake *(PR [#6470](https://github.com/tobymao/sqlglot/pull/6470) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`7dbc242`](https://github.com/tobymao/sqlglot/commit/7dbc242a637a8890511cc14f22bce4d425f1f55d) - **snowflake**: annotation support for CURRENT REGION. Return type VARCHAR *(PR [#6473](https://github.com/tobymao/sqlglot/pull/6473) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`43a6a5c`](https://github.com/tobymao/sqlglot/commit/43a6a5c601421e15a7f94dd489cb4fbcf9d2c8c3) - **snowflake**: annotation support for CURRENT_ORGANIZATION_NAME. Return type VARCHAR *(PR [#6475](https://github.com/tobymao/sqlglot/pull/6475) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`f1f7c6a`](https://github.com/tobymao/sqlglot/commit/f1f7c6ae6b6aa3f6f2251d0f81ee667440ca53d1) - **snowflake**: annotation support for CURRENT_ORGANIZATION_USER. *(PR [#6476](https://github.com/tobymao/sqlglot/pull/6476) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`d268203`](https://github.com/tobymao/sqlglot/commit/d268203e1dbae4e3aff863108f6d09a6f8274db5) - **snowflake**: annotation support for CURRENT_ROLE_TYPE *(PR [#6479](https://github.com/tobymao/sqlglot/pull/6479) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`fd4431b`](https://github.com/tobymao/sqlglot/commit/fd4431bf9550c03aa761c642a68a21a146fd8548) - **snowflake**: annotate type for VECTOR_L1_DISTANCE, VECTOR_L2_DISTANCE, VECTOR_COSINE_SIMILARITY functions *(PR [#6468](https://github.com/tobymao/sqlglot/pull/6468) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`e6adba7`](https://github.com/tobymao/sqlglot/commit/e6adba76cc2f27633a9d38bfaea3356e71d00a4c) - **BigQuery**: Add support for coercing STRING literals to temporal types *(PR [#6482](https://github.com/tobymao/sqlglot/pull/6482) by [@vchan](https://github.com/vchan))*
- [`68a5e61`](https://github.com/tobymao/sqlglot/commit/68a5e615b24e518cb90c9b80cf25355fcabdb468) - **snowflake**: annotate type for REGR_* functions *(PR [#6452](https://github.com/tobymao/sqlglot/pull/6452) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`f7458a4`](https://github.com/tobymao/sqlglot/commit/f7458a40d3b09a2e212f6705ac4a77c99714508e) - **optimizer**: annotate type for snowflake func TO_BOOLEAN *(PR [#6481](https://github.com/tobymao/sqlglot/pull/6481) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`1531a67`](https://github.com/tobymao/sqlglot/commit/1531a67ac7806f3b4582f6cf1ea02342a517de74) - **snowflake**: annotate type for VECTOR_INNER_PRODUCT *(PR [#6486](https://github.com/tobymao/sqlglot/pull/6486) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`f6b2b3b`](https://github.com/tobymao/sqlglot/commit/f6b2b3bc6e1c95340149be65d80ef7e177b28d82) - **snowflake**: support padside argument for BIT[OR|AND|XOR] *(PR [#6487](https://github.com/tobymao/sqlglot/pull/6487) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`e891397`](https://github.com/tobymao/sqlglot/commit/e89139714aefd8a6481a90d9753c81910c9f88e9) - **BigQuery**: Add support for the NET.HOST function *(PR [#6480](https://github.com/tobymao/sqlglot/pull/6480) by [@vchan](https://github.com/vchan))*
- [`2cc67cd`](https://github.com/tobymao/sqlglot/commit/2cc67cd7386914043a9cb4eb322fb1fa9af15c8b) - **singlestore**: support dcolonqmark *(PR [#6485](https://github.com/tobymao/sqlglot/pull/6485) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`7d485c7`](https://github.com/tobymao/sqlglot/commit/7d485c7cffe7b6d0113cfcfcf0736de0383bd380) - **duckdb**: Add transpilation support for the negative integer args for BITNOT *(PR [#6490](https://github.com/tobymao/sqlglot/pull/6490) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`ef130f1`](https://github.com/tobymao/sqlglot/commit/ef130f1b944b4be835d4a6831fec9a333a825a34) - **snowflake**: Annotated type for ARRAY_CONSTRUCT_COMPACT [#6496](https://github.com/tobymao/sqlglot/pull/6496) *(commit by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`36cf0bf`](https://github.com/tobymao/sqlglot/commit/36cf0bf6671f622344afee52d7aafe30f19ecf9a) - **snowflake**: annotation support for CURRENT_ROLE. *(PR [#6478](https://github.com/tobymao/sqlglot/pull/6478) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`cbba04c`](https://github.com/tobymao/sqlglot/commit/cbba04cb292fe8b3fd38c87d9ccb624cdcb52843) - **databricks**: support comma-separated syntax for OVERLAY function *(PR [#6497](https://github.com/tobymao/sqlglot/pull/6497) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`dc8f26a`](https://github.com/tobymao/sqlglot/commit/dc8f26a3a5e023a0e54caa345b129fb1b4fe805f) - **optimizer**: bq annotate type for NULL *(PR [#6491](https://github.com/tobymao/sqlglot/pull/6491) by [@geooo109](https://github.com/geooo109))*
- [`c97a81d`](https://github.com/tobymao/sqlglot/commit/c97a81d68a1584fad48475725665a7678fcad9d1) - **optimizer**: annotate TO_HEX(MD5(...)) in BigQuery *(PR [#6500](https://github.com/tobymao/sqlglot/pull/6500) by [@georgesittas](https://github.com/georgesittas))*
- [`a5797a1`](https://github.com/tobymao/sqlglot/commit/a5797a1c867c4ade71ae4ddf93232576993cf5bc) - **duckdb**: handle named arguments and non-integer scale input for ROUND *(PR [#6495](https://github.com/tobymao/sqlglot/pull/6495) by [@toriwei](https://github.com/toriwei))*
- [`8b5298a`](https://github.com/tobymao/sqlglot/commit/8b5298a6578af80fd9676eb222422862d5468859) - **duckdb**: Transpile BQ's WEEK based `DATE_DIFF` *(PR [#6507](https://github.com/tobymao/sqlglot/pull/6507) by [@VaggelisD](https://github.com/VaggelisD))*
- [`2c013a5`](https://github.com/tobymao/sqlglot/commit/2c013a5cc8e37cde8a8f9443e0397191ce82f0f5) - **exasol**: qualify bare stars to facilitate transpilation *(PR [#6431](https://github.com/tobymao/sqlglot/pull/6431) by [@nnamdi16](https://github.com/nnamdi16))*
- [`41b776b`](https://github.com/tobymao/sqlglot/commit/41b776bdc6936f18accd9f7308b55acd383bb596) - **postgres,trino,duckdb**: added support for current_catalog *(PR [#6492](https://github.com/tobymao/sqlglot/pull/6492) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`dd19bea`](https://github.com/tobymao/sqlglot/commit/dd19beae95f077cfd8b6e315eca7ff212817b250) - **snowflake**: annotation support for CURRENT_ACCOUNT *(PR [#6512](https://github.com/tobymao/sqlglot/pull/6512) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`2e8105e`](https://github.com/tobymao/sqlglot/commit/2e8105eebaec25fc8f94f1e68951198660f404e1) - **snowflake**: Annotate type for VAR_POP, VAR_SAMP, DuckDB consistency fix for VAR_SAMP *(PR [#6488](https://github.com/tobymao/sqlglot/pull/6488) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`cfb02c1`](https://github.com/tobymao/sqlglot/commit/cfb02c1aa676e801b2d13a84467b4904cd834ffe) - **snowflake**: annotation support for CURRENT_ACCOUNT_NAME *(PR [#6513](https://github.com/tobymao/sqlglot/pull/6513) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`1004e31`](https://github.com/tobymao/sqlglot/commit/1004e31cce62cce2e2afb7eab85ed8bdecaede3b) - **snowflake**: annotation support for CURRENT_AVAILABLE_ROLES *(PR [#6514](https://github.com/tobymao/sqlglot/pull/6514) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`ff201fe`](https://github.com/tobymao/sqlglot/commit/ff201febd27937a97674dd091928456dde733254) - **snowflake**: annotation support for CURRENT_CLIENT *(PR [#6515](https://github.com/tobymao/sqlglot/pull/6515) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`d777a9c`](https://github.com/tobymao/sqlglot/commit/d777a9c0feef15ac036f7b413112de4d7cc8bea4) - **snowflake**: annotation support for CURRENT_IP_ADDRESS *(PR [#6518](https://github.com/tobymao/sqlglot/pull/6518) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`c296061`](https://github.com/tobymao/sqlglot/commit/c2960615a3bd279b7c5f775d5b93ae12aa27a3b8) - **snowflake**: Transpilation of TO_BINARY from snowflake to duckdb *(PR [#6504](https://github.com/tobymao/sqlglot/pull/6504) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`7a70164`](https://github.com/tobymao/sqlglot/commit/7a70164d8cf361cf4c0a7d5789bb51676f772959) - **duckdb**: transpile Snowflake's `RANDSTR` function *(PR [#6502](https://github.com/tobymao/sqlglot/pull/6502) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`a26d419`](https://github.com/tobymao/sqlglot/commit/a26d4191e5468e39eafdf7a981e7b890d438b2c9) - **snowflake**: annotation support for CURRENT_DATABASE *(PR [#6516](https://github.com/tobymao/sqlglot/pull/6516) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`0acdf7f`](https://github.com/tobymao/sqlglot/commit/0acdf7fc783f2722536ec24dcf8600957febf7ca) - **snowflake**: annotation support for CURRENT_SCHEMAS *(PR [#6519](https://github.com/tobymao/sqlglot/pull/6519) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`43cce89`](https://github.com/tobymao/sqlglot/commit/43cce895da80d21abc89d40de5d7fddd68871bf0) - **snowflake**: annotation support for CURRENT_SECONDARY_ROLES *(PR [#6520](https://github.com/tobymao/sqlglot/pull/6520) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`c21b4b1`](https://github.com/tobymao/sqlglot/commit/c21b4b1134b368ee5144339b59e70ddcc54f3dbc) - **snowflake**: annotation support for CURRENT_SESSION *(PR [#6521](https://github.com/tobymao/sqlglot/pull/6521) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`57a83c0`](https://github.com/tobymao/sqlglot/commit/57a83c018dace690f7bb363c25ee6bde33c3d60f) - **snowflake**: annotation support for CURRENT_STATEMENT *(PR [#6522](https://github.com/tobymao/sqlglot/pull/6522) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`4b240e4`](https://github.com/tobymao/sqlglot/commit/4b240e40a8809a6eea2a279370a884f4a7b03dfa) - **snowflake**: annotation support for CURRENT_VERSION *(PR [#6524](https://github.com/tobymao/sqlglot/pull/6524) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`c1a831f`](https://github.com/tobymao/sqlglot/commit/c1a831f5bf662ab8d8e07dc2bb949f2adcbe7d7c) - **snowflake**: annotation support for CURRENT_TRANSACTION *(PR [#6523](https://github.com/tobymao/sqlglot/pull/6523) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`2e162b0`](https://github.com/tobymao/sqlglot/commit/2e162b0d34066e7aa7edac3156739bcd31a634fc) - **snowflake**: annotation support for CURRENT_WAREHOUSE *(PR [#6525](https://github.com/tobymao/sqlglot/pull/6525) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`18e9814`](https://github.com/tobymao/sqlglot/commit/18e98145906eaa5b769af49cf46b58a1d9448aee) - **snowflake**: support DAYOFWEEK_ISO date part *(PR [#6531](https://github.com/tobymao/sqlglot/pull/6531) by [@toriwei](https://github.com/toriwei))*
- [`ee5e7b9`](https://github.com/tobymao/sqlglot/commit/ee5e7b931ca745a000dc8a720b56aee7b44186b2) - Automatically trigger integration tests scoped to modified dialects *(PR [#6505](https://github.com/tobymao/sqlglot/pull/6505) by [@erindru](https://github.com/erindru))*
- [`e60634f`](https://github.com/tobymao/sqlglot/commit/e60634f0e1c396b54ad357132606286bd21d3e36) - **clickhouse**: Add support for quantilesExactExclusive agg func *(PR [#6535](https://github.com/tobymao/sqlglot/pull/6535) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#6533](https://github.com/tobymao/sqlglot/issues/6533) opened by [@vargasj-ms](https://github.com/vargasj-ms)*
- [`41a9e88`](https://github.com/tobymao/sqlglot/commit/41a9e88bb9800205df0b3e10a1976699dc4fe4f9) - **duckdb**: Add support to transpile binary args for bitwise operators *(PR [#6508](https://github.com/tobymao/sqlglot/pull/6508) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`2555856`](https://github.com/tobymao/sqlglot/commit/2555856cac7434ef91cc1584d52610178e45c4b9) - **optimizer**: annotate scalar subqueries *(PR [#6536](https://github.com/tobymao/sqlglot/pull/6536) by [@georgesittas](https://github.com/georgesittas))*
- [`71e7630`](https://github.com/tobymao/sqlglot/commit/71e763096462aa888a353ac1ad3675a9e5b4841a) - **snowflake**: normalize FLOAT to DOUBLE *(PR [#6501](https://github.com/tobymao/sqlglot/pull/6501) by [@toriwei](https://github.com/toriwei))*
- [`9badf6a`](https://github.com/tobymao/sqlglot/commit/9badf6a6b1972fc37164b29aa416bb897d7ec6a6) - **snowflake**: Annotate type for TRY_* functions *(PR [#6509](https://github.com/tobymao/sqlglot/pull/6509) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`aad1332`](https://github.com/tobymao/sqlglot/commit/aad1332fee7c82c29dae3caed9a6a1c882c1d4a0) - **duckdb**: support transpilation of BITMAP_BIT_POSITION from snowflake to duckdb *(PR [#6541](https://github.com/tobymao/sqlglot/pull/6541) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`980f538`](https://github.com/tobymao/sqlglot/commit/980f53852444ec38c45483cbbf63a286244262a6) - **databricks, snowflake**: support UNIFORM function *(PR [#6547](https://github.com/tobymao/sqlglot/pull/6547) by [@toriwei](https://github.com/toriwei))*
- [`8a12611`](https://github.com/tobymao/sqlglot/commit/8a12611e9499497d0c8b1e1e418986b2d91a6505) - **snowflake**: New type + type annotation for TO_FILE  *(PR [#6548](https://github.com/tobymao/sqlglot/pull/6548) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`906c933`](https://github.com/tobymao/sqlglot/commit/906c933235c82598b0d08f8c66dd3db0b8f409a5) - **postgres**: overlap operator *(PR [#6545](https://github.com/tobymao/sqlglot/pull/6545) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`6fa5e9c`](https://github.com/tobymao/sqlglot/commit/6fa5e9ce017185d721fab23d271f2fcb6098190e) - **snowflake**: transpile FLOOR with scale arg to DuckDB *(PR [#6549](https://github.com/tobymao/sqlglot/pull/6549) by [@treysp](https://github.com/treysp))*
- [`487b1db`](https://github.com/tobymao/sqlglot/commit/487b1dbff86f05acbd3caa769cd330a8a373480b) - make parser more conservative as assignments are relatively rare *(commit by [@tobymao](https://github.com/tobymao))*
- [`370b1f6`](https://github.com/tobymao/sqlglot/commit/370b1f621844d3ac8831c998ea2046f1e1b91b65) - **postgres,tsql,duckdb**: add support for session_user *(PR [#6555](https://github.com/tobymao/sqlglot/pull/6555) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`8d83ee2`](https://github.com/tobymao/sqlglot/commit/8d83ee207070cc17ce0e433d636464255e09748f) - **duckdb**: Transpiled REGR_VALX and VALY *(PR [#6538](https://github.com/tobymao/sqlglot/pull/6538) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`ad546b3`](https://github.com/tobymao/sqlglot/commit/ad546b30d40abe0da97b38bd300452e0354231e3) - **databricks**: add support for getdate(), now(), and current_timezone() *(PR [#6567](https://github.com/tobymao/sqlglot/pull/6567) by [@toriwei](https://github.com/toriwei))*
- [`dbbace0`](https://github.com/tobymao/sqlglot/commit/dbbace01cd5f1fc44f5ad278def25f547686f9c5) - **snowflake**: remove transpilation support of APPROX_TOP_K to duckdb *(PR [#6560](https://github.com/tobymao/sqlglot/pull/6560) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`2bc2506`](https://github.com/tobymao/sqlglot/commit/2bc2506e0e0b26e82661a08217855d693f30dc25) - **bigquery**: support SAFE.TIMESTAMP annotation *(PR [#6550](https://github.com/tobymao/sqlglot/pull/6550) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`a51cc7b`](https://github.com/tobymao/sqlglot/commit/a51cc7b6e02c5b37bf43b82a0d76b83d41248ac9) - **mysql**: elt function in mysql *(PR [#6568](https://github.com/tobymao/sqlglot/pull/6568) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`4339b26`](https://github.com/tobymao/sqlglot/commit/4339b26db546862b10a0e8d746506b406ecfa306) - **optimizer**: expose struct fields using UNNEST without aliases *(PR [#6566](https://github.com/tobymao/sqlglot/pull/6566) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`7bfffe5`](https://github.com/tobymao/sqlglot/commit/7bfffe5d894c60bd0139d57c53bb1816c2739d74) - **snowflake**: support transpilation of TO_BOOLEAN from snowflake to duckdb *(PR [#6564](https://github.com/tobymao/sqlglot/pull/6564) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`d1cd9d6`](https://github.com/tobymao/sqlglot/commit/d1cd9d65be7779ea442260a92978d569f3d6ccd8) - **databricks**: support CURDATE *(PR [#6578](https://github.com/tobymao/sqlglot/pull/6578) by [@toriwei](https://github.com/toriwei))*
- [`c906a96`](https://github.com/tobymao/sqlglot/commit/c906a96b33d28dfc1191840817dbf2bab0731d17) - **snowflake**: support GETDATE, SYSDATE, SYSTIMESTAMP *(PR [#6575](https://github.com/tobymao/sqlglot/pull/6575) by [@toriwei](https://github.com/toriwei))*

### :bug: Bug Fixes
- [`9020684`](https://github.com/tobymao/sqlglot/commit/9020684a7e984a10fa4775339596ac5a0d6a6d93) - nested natural join performance closes [#5514](https://github.com/tobymao/sqlglot/pull/5514) *(PR [#5515](https://github.com/tobymao/sqlglot/pull/5515) by [@tobymao](https://github.com/tobymao))*
- [`394870a`](https://github.com/tobymao/sqlglot/commit/394870a7ee9bb3bc814b7c3847193687f06b432b) - **duckdb**: transpile ADD_MONTHS *(PR [#5523](https://github.com/tobymao/sqlglot/pull/5523) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5505](https://github.com/tobymao/sqlglot/issues/5505) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`249692c`](https://github.com/tobymao/sqlglot/commit/249692c67450a1fe3775e1f35b6f62fdb0a62e1a) - **duckdb**: put guard in AddMonths generator before annotating it *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`d799c5a`](https://github.com/tobymao/sqlglot/commit/d799c5af23010a67c29edb6d45a40fb24903e1a3) - **optimizer**: preserve projection names when merging subqueries *(commit by [@snovik75](https://github.com/snovik75))*
- [`8130bd4`](https://github.com/tobymao/sqlglot/commit/8130bd40815803a6781ee8f20fccd30987516192) - **parser**: WEEKDAY of WEEK as VAR *(PR [#5552](https://github.com/tobymao/sqlglot/pull/5552) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5547](https://github.com/tobymao/sqlglot/issues/5547) opened by [@rloredo](https://github.com/rloredo)*
- [`4e1373f`](https://github.com/tobymao/sqlglot/commit/4e1373f301cbea3cb5762fc1430b65deae3f9d04) - **doris**: Rename Table *(PR [#5549](https://github.com/tobymao/sqlglot/pull/5549) by [@xinge-ji](https://github.com/xinge-ji))*
- [`16f544d`](https://github.com/tobymao/sqlglot/commit/16f544dc25d5d61277d32f02e4be18c10d16cf9f) - **doris**: fix DATE_TRUNC and partition by *(PR [#5553](https://github.com/tobymao/sqlglot/pull/5553) by [@xinge-ji](https://github.com/xinge-ji))*
- [`6295414`](https://github.com/tobymao/sqlglot/commit/6295414fb41401f92993e661b880a0727e74c087) - convert unit to Var instead of choosing default in `unit_to_var` *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`6872b43`](https://github.com/tobymao/sqlglot/commit/6872b43ba17a39137172fd2fa9f0d059ce595ef9) - **parser**: use dialect in DataType.build fixes [#5560](https://github.com/tobymao/sqlglot/pull/5560) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`6f354d9`](https://github.com/tobymao/sqlglot/commit/6f354d958fb9ca9242b7fc1d2da86af74d57fedc) - **clickhouse**: add ROWS keyword in OFFSET followed by FETCH fixes [#5564](https://github.com/tobymao/sqlglot/pull/5564) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`8c0cb76`](https://github.com/tobymao/sqlglot/commit/8c0cb764fd825062fb7334032b8eeffbc39627d5) - **parser**: more robust CREATE SEQUENCE *(PR [#5566](https://github.com/tobymao/sqlglot/pull/5566) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5537](https://github.com/tobymao/sqlglot/issues/5537) opened by [@tekumara](https://github.com/tekumara)*
- [`7e9df88`](https://github.com/tobymao/sqlglot/commit/7e9df880bc118d0dbb2dbd6344f805f79af2fe5e) - **doris**: CURRENT_DATE *(PR [#5567](https://github.com/tobymao/sqlglot/pull/5567) by [@xinge-ji](https://github.com/xinge-ji))*
- [`51e0335`](https://github.com/tobymao/sqlglot/commit/51e0335377fe2bc2e2a94a623475791e9dd19fb9) - **optimizer**: parse and annotate type for bigquery REVERSE *(PR [#5571](https://github.com/tobymao/sqlglot/pull/5571) by [@geooo109](https://github.com/geooo109))*
- [`d0d62ed`](https://github.com/tobymao/sqlglot/commit/d0d62ede6320b3fd0eee04b7073f5708676dc58c) - **dremio**: support `TO_CHAR` with numeric inputs *(PR [#5570](https://github.com/tobymao/sqlglot/pull/5570) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`7928985`](https://github.com/tobymao/sqlglot/commit/7928985a655c3d0244bc9175a37f502b19a5c5f0) - **bigquery**: allow dashes in JSONPath keys *(PR [#5574](https://github.com/tobymao/sqlglot/pull/5574) by [@georgesittas](https://github.com/georgesittas))*
- [`866042d`](https://github.com/tobymao/sqlglot/commit/866042d0268da0cebce042c0868878c0fb39c3d1) - Remove TokenType.APPLY from table alias tokens *(PR [#5592](https://github.com/tobymao/sqlglot/pull/5592) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5591](https://github.com/tobymao/sqlglot/issues/5591) opened by [@saadbelgi](https://github.com/saadbelgi)*
- [`b485f66`](https://github.com/tobymao/sqlglot/commit/b485f6666fa8625b7da45ef832b5d666fbb707ea) - **dremio**: improve `TO_CHAR` transpilability *(PR [#5580](https://github.com/tobymao/sqlglot/pull/5580) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`81874e9`](https://github.com/tobymao/sqlglot/commit/81874e9c3aafcc2cf8fb443f65146c5b3598b9b3) - handle unknown types in `unit_to_str` *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`f1269f5`](https://github.com/tobymao/sqlglot/commit/f1269f5ecfccfee4cdeeda5bfd10eb1c47994fad) - **tsql**: do not attach limit modifier to set operation *(PR [#5609](https://github.com/tobymao/sqlglot/pull/5609) by [@georgesittas](https://github.com/georgesittas))*
- [`a6edf8e`](https://github.com/tobymao/sqlglot/commit/a6edf8ee3273a7736ed801ef8dea302613b119da) - **tsql**: Remove ORDER from set op modifiers too *(PR [#5626](https://github.com/tobymao/sqlglot/pull/5626) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5618](https://github.com/tobymao/sqlglot/issues/5618) opened by [@MQMMMQM](https://github.com/MQMMMQM)*
- [`ce5840e`](https://github.com/tobymao/sqlglot/commit/ce5840ed615e162a93cd911ab6207160878fcc64) - **exasol**: update several dialect properties to correctly reflect semantics *(PR [#5642](https://github.com/tobymao/sqlglot/pull/5642) by [@nnamdi16](https://github.com/nnamdi16))*
- [`3ab1d44`](https://github.com/tobymao/sqlglot/commit/3ab1d4487279cab3be2d3764e51516c6db21629d) - **generator**: Wrap CONCAT items with COALESCE less aggressively *(PR [#5641](https://github.com/tobymao/sqlglot/pull/5641) by [@VaggelisD](https://github.com/VaggelisD))*
- [`045d2f0`](https://github.com/tobymao/sqlglot/commit/045d2f02649b0e6dc178c079e4e0db201ed9bf08) - **duckdb**: Transpile Spark's FIRST(col, TRUE) *(PR [#5644](https://github.com/tobymao/sqlglot/pull/5644) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5643](https://github.com/tobymao/sqlglot/issues/5643) opened by [@michal-clutch](https://github.com/michal-clutch)*
- [`0427c7b`](https://github.com/tobymao/sqlglot/commit/0427c7b7aa9f8161324085a98c5f531fa35c8b0c) - **optimizer**: qualify columns for AggFunc with DISTINCT *(PR [#5708](https://github.com/tobymao/sqlglot/pull/5708) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5698](https://github.com/tobymao/sqlglot/issues/5698) opened by [@georgesittas](https://github.com/georgesittas)*
- [`ec93497`](https://github.com/tobymao/sqlglot/commit/ec93497bac82090b88c6e749ec2adc99bbc23a61) - **bigquery**: support commands inside for loops *(PR [#5732](https://github.com/tobymao/sqlglot/pull/5732) by [@treysp](https://github.com/treysp))*
- [`85845bb`](https://github.com/tobymao/sqlglot/commit/85845bb941ac9a4ee090a89cd3d3dab4ab5835a7) - **snowflake**: allow exclude as id var *(PR [#5764](https://github.com/tobymao/sqlglot/pull/5764) by [@treysp](https://github.com/treysp))*
- [`db2d9cc`](https://github.com/tobymao/sqlglot/commit/db2d9cca9718fb196066dbf60840124917d1f8ac) - **tokenizer**: handle empty hex strings *(PR [#5763](https://github.com/tobymao/sqlglot/pull/5763) by [@paulolieuthier](https://github.com/paulolieuthier))*
  - :arrow_lower_right: *fixes issue [#5761](https://github.com/tobymao/sqlglot/issues/5761) opened by [@paulolieuthier](https://github.com/paulolieuthier)*
- [`982257b`](https://github.com/tobymao/sqlglot/commit/982257b40973cdfc20a8d6dd9a1674cda7eb75c4) - **bigquery**: Crash when ARRAY_CONCAT is called with no expressions *(PR [#5755](https://github.com/tobymao/sqlglot/pull/5755) by [@ozadari](https://github.com/ozadari))*
- [`24ca504`](https://github.com/tobymao/sqlglot/commit/24ca504360779c8a20a58accf506eb9600ac9bf8) - **bigquery**: Crash when ARRAY_CONCAT is called with no expressions *(PR [#5755](https://github.com/tobymao/sqlglot/pull/5755) by [@ozadari](https://github.com/ozadari))*
- [`d8f6a37`](https://github.com/tobymao/sqlglot/commit/d8f6a376ba1fcca48e4a65923dd7a319ce6cfb91) - **optimizer**: allow aliased negative integer literal as group by column *(PR [#5791](https://github.com/tobymao/sqlglot/pull/5791) by [@treysp](https://github.com/treysp))*
- [`1259576`](https://github.com/tobymao/sqlglot/commit/1259576283f1d45abb70ec40c60e500214a27b6f) - **hive**: DATE_SUB to DATE_ADD use parens if needed *(PR [#5796](https://github.com/tobymao/sqlglot/pull/5796) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5794](https://github.com/tobymao/sqlglot/issues/5794) opened by [@mingelchan](https://github.com/mingelchan)*
- [`b0516b4`](https://github.com/tobymao/sqlglot/commit/b0516b4bc9cf2bba2cb57e6bb79ff09b5e2244e3) - **optimizer**: Do not qualify columns if a projection coflicts with a source *(PR [#5780](https://github.com/tobymao/sqlglot/pull/5780) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5262](https://github.com/TobikoData/sqlmesh/issues/5262) opened by [@mChlopek](https://github.com/mChlopek)*
- [`8af0d40`](https://github.com/tobymao/sqlglot/commit/8af0d40055450f71b7e36e576f4a9a1104bc02b2) - **parser**: address edge case where `values` is used as an identifier *(PR [#5801](https://github.com/tobymao/sqlglot/pull/5801) by [@georgesittas](https://github.com/georgesittas))*
- [`3726b33`](https://github.com/tobymao/sqlglot/commit/3726b33bb6b4ab286617f510e96e1fbd27c429f3) - **snowflake**: support nulls_first arg for array_sort *(PR [#5802](https://github.com/tobymao/sqlglot/pull/5802) by [@treysp](https://github.com/treysp))*
- [`3408de0`](https://github.com/tobymao/sqlglot/commit/3408de09e50d2510c1a6f511dc2dec357059044f) - parsing quoted built-in data types *(PR [#5810](https://github.com/tobymao/sqlglot/pull/5810) by [@treysp](https://github.com/treysp))*
- [`ad0b407`](https://github.com/tobymao/sqlglot/commit/ad0b407098e1611d4fc0e1f0916511337b9aefdb) - **postgres**: Mark 'BEGIN' as TokenType.BEGIN for transactions *(PR [#5826](https://github.com/tobymao/sqlglot/pull/5826) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5815](https://github.com/tobymao/sqlglot/issues/5815) opened by [@karakanb](https://github.com/karakanb)*
- [`e1a1b5b`](https://github.com/tobymao/sqlglot/commit/e1a1b5befefb0ca30ac1310cecb82a44f6089034) - **snowflake**: transpile BigQuery's `&` to `BITAND` *(PR [#5827](https://github.com/tobymao/sqlglot/pull/5827) by [@YuvalOmerRep](https://github.com/YuvalOmerRep))*
- [`32d0278`](https://github.com/tobymao/sqlglot/commit/32d027827eaa7aa0cd9faf2ac1f84739f914050f) - parse and generation of BITWISE AGG funcs across dialects *(PR [#5831](https://github.com/tobymao/sqlglot/pull/5831) by [@geooo109](https://github.com/geooo109))*
- [`5f39a83`](https://github.com/tobymao/sqlglot/commit/5f39a83f1ff957aca57eb4745f83c296436acaac) - **bigquery**: properly generate `LIMIT` for `STRING_AGG` *(PR [#5830](https://github.com/tobymao/sqlglot/pull/5830) by [@georgesittas](https://github.com/georgesittas))*
- [`f3d55c0`](https://github.com/tobymao/sqlglot/commit/f3d55c05c8411c9871f8ca4d23f726f976c9236b) - remove always token *(PR [#5832](https://github.com/tobymao/sqlglot/pull/5832) by [@tobymao](https://github.com/tobymao))*
- [`1724775`](https://github.com/tobymao/sqlglot/commit/1724775429f66c2768864c8f96ace861eaa435fd) - suppert types() with no args *(PR [#5833](https://github.com/tobymao/sqlglot/pull/5833) by [@tobymao](https://github.com/tobymao))*
- [`31c82c6`](https://github.com/tobymao/sqlglot/commit/31c82c6d6cd402e59cb59a94daafd22410eae0f6) - support `case.*` *(PR [#5835](https://github.com/tobymao/sqlglot/pull/5835) by [@georgesittas](https://github.com/georgesittas))*
- [`c00f73b`](https://github.com/tobymao/sqlglot/commit/c00f73bac2530a62c25093c60bf02d0a4231bb0b) - window spec no and only exclude *(PR [#5834](https://github.com/tobymao/sqlglot/pull/5834) by [@tobymao](https://github.com/tobymao))*
- [`5e7979f`](https://github.com/tobymao/sqlglot/commit/5e7979f3cf5f7996e198ddd81069d49a4a3b9391) - select session *(PR [#5836](https://github.com/tobymao/sqlglot/pull/5836) by [@tobymao](https://github.com/tobymao))*
- [`9c8a600`](https://github.com/tobymao/sqlglot/commit/9c8a6001f41816035f391d046eb9692d6f13cefc) - **snowflake**: correct parsing of TO_VARCHAR *(PR [#5840](https://github.com/tobymao/sqlglot/pull/5840) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5837](https://github.com/tobymao/sqlglot/issues/5837) opened by [@ultrabear](https://github.com/ultrabear)*
- [`f3d07fd`](https://github.com/tobymao/sqlglot/commit/f3d07fd8a106b034f64bb100291671c0fe39a106) - **snowflake**: Enable parsing of COPY INTO without files list *(PR [#5841](https://github.com/tobymao/sqlglot/pull/5841) by [@whummer](https://github.com/whummer))*
- [`0ffb1fa`](https://github.com/tobymao/sqlglot/commit/0ffb1faac3b32aad845306eed0e000ff0d055554) - **duckdb**: transpile joins without ON/USING to CROSS JOIN *(PR [#5804](https://github.com/tobymao/sqlglot/pull/5804) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5795](https://github.com/tobymao/sqlglot/issues/5795) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`1e9aef1`](https://github.com/tobymao/sqlglot/commit/1e9aef1bb20f4dc5e9c03d59cb3165c235c11ce1) - **optimizer**: convert NULL annotations to UNKNOWN *(PR [#5842](https://github.com/tobymao/sqlglot/pull/5842) by [@georgesittas](https://github.com/georgesittas))*
- [`bbcf0d4`](https://github.com/tobymao/sqlglot/commit/bbcf0d4404ea014f08319c44313719b4377adcdb) - **duckdb**: support trailing commas before `FOR` in pivot, fixes [#5843](https://github.com/tobymao/sqlglot/pull/5843) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`ad8a408`](https://github.com/tobymao/sqlglot/commit/ad8a408a4e3e26e32472fc55c67b44687992ae47) - **parser**: more robust nested pipe syntax *(PR [#5845](https://github.com/tobymao/sqlglot/pull/5845) by [@geooo109](https://github.com/geooo109))*
- [`44c9e70`](https://github.com/tobymao/sqlglot/commit/44c9e70bd8c9421035eb0e87e4286061ec5d2fa8) - **optimizer**: add tests for snowflake STARTSWITH function *(PR [#5847](https://github.com/tobymao/sqlglot/pull/5847) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`0779c2d`](https://github.com/tobymao/sqlglot/commit/0779c2d4e8ce0228592de6882763940783fa5e87) - support BIT_X aggregates again for duckdb, postgres *(PR [#5851](https://github.com/tobymao/sqlglot/pull/5851) by [@georgesittas](https://github.com/georgesittas))*
- [`d131aab`](https://github.com/tobymao/sqlglot/commit/d131aab6815bf77d444a763d9bb4028d8f0e742d) - **redshift**: convert FETCH clauses to LIMIT for Redshift dialect *(PR [#5848](https://github.com/tobymao/sqlglot/pull/5848) by [@tomasmontielp](https://github.com/tomasmontielp))*
- [`b22c4ec`](https://github.com/tobymao/sqlglot/commit/b22c4ecf4c032d89ca737f01d614102aa9c2b1ed) - **fabric**: UUID to UNIQUEIDENTIFIER *(PR [#5863](https://github.com/tobymao/sqlglot/pull/5863) by [@fresioAS](https://github.com/fresioAS))*
- [`03d4f49`](https://github.com/tobymao/sqlglot/commit/03d4f49d92cd034d37074359b8c2cf96c5c3f5cf) - **clickhouse**: arrays are 1-indexed *(PR [#5862](https://github.com/tobymao/sqlglot/pull/5862) by [@joeyutong](https://github.com/joeyutong))*
- [`1d9e357`](https://github.com/tobymao/sqlglot/commit/1d9e357fb7549635ca25c6c42299880d7864e074) - **optimizer**: expand columns on the LHS of recursive CTEs *(PR [#5872](https://github.com/tobymao/sqlglot/pull/5872) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5814](https://github.com/tobymao/sqlglot/issues/5814) opened by [@suresh-summation](https://github.com/suresh-summation)*
- [`7fcc52a`](https://github.com/tobymao/sqlglot/commit/7fcc52a22241c480c22b3e6f843e7a210c75a0ec) - **parser**: Require an explicit alias in EXCLUDE/RENAME/REPLACE star ops *(PR [#5892](https://github.com/tobymao/sqlglot/pull/5892) by [@VaggelisD](https://github.com/VaggelisD))*
- [`5fdcc65`](https://github.com/tobymao/sqlglot/commit/5fdcc651277ba4e86e11d0c5952a56e40299a998) - **snowflake**: parse OCTET_LENGTH *(PR [#5900](https://github.com/tobymao/sqlglot/pull/5900) by [@geooo109](https://github.com/geooo109))*
- [`f5409df`](https://github.com/tobymao/sqlglot/commit/f5409df64ed6069880669878db687e4b98c3e280) - **optimizer**: use column name in struct type annotation *(PR [#5903](https://github.com/tobymao/sqlglot/pull/5903) by [@georgesittas](https://github.com/georgesittas))*
- [`74886d8`](https://github.com/tobymao/sqlglot/commit/74886d82f70c9317af51c77b322e67a6aa260a5e) - **snowflake**: transpile BQ UNNEST with alias *(PR [#5897](https://github.com/tobymao/sqlglot/pull/5897) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5895](https://github.com/tobymao/sqlglot/issues/5895) opened by [@YuvalOmerRep](https://github.com/YuvalOmerRep)*
- [`bd3e965`](https://github.com/tobymao/sqlglot/commit/bd3e9655aa72ffef8a9e0221205fa2c3915ef58b) - allow `lock` to be used as an identifier *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`2d0d908`](https://github.com/tobymao/sqlglot/commit/2d0d908b5bbc32ff3bc92eb1ae9fc6e5ac3409bc) - produce TableAlias instead of Alias for USING in merge builder *(PR [#5911](https://github.com/tobymao/sqlglot/pull/5911) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5910](https://github.com/tobymao/sqlglot/issues/5910) opened by [@deepyaman](https://github.com/deepyaman)*
- [`0e256b3`](https://github.com/tobymao/sqlglot/commit/0e256b3f864bc2d026817bd08e89ee89f44ad256) - edge case with parsing `interval` as identifier *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`d127051`](https://github.com/tobymao/sqlglot/commit/d1270517c3e124ca59caf29e4506eb3848f7452e) - precedence issue with column operator parsing *(PR [#5914](https://github.com/tobymao/sqlglot/pull/5914) by [@georgesittas](https://github.com/georgesittas))*
- [`6807a32`](https://github.com/tobymao/sqlglot/commit/6807a32cccf984dc13a30b815750b2c41374b845) - escape byte string delimiters *(PR [#5916](https://github.com/tobymao/sqlglot/pull/5916) by [@georgesittas](https://github.com/georgesittas))*
- [`22c7ed7`](https://github.com/tobymao/sqlglot/commit/22c7ed7734b41ca544bb67bcc1ca4151f6d5f05f) - **clickhouse**: parse tuple *(PR [#5920](https://github.com/tobymao/sqlglot/pull/5920) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5913](https://github.com/tobymao/sqlglot/issues/5913) opened by [@tiagoskaneta](https://github.com/tiagoskaneta)*
- [`223160b`](https://github.com/tobymao/sqlglot/commit/223160bd7914d51e9ec1abb8d0f1053e13a65c98) - **parser**: NULLABLE as an identifier *(PR [#5921](https://github.com/tobymao/sqlglot/pull/5921) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5919](https://github.com/tobymao/sqlglot/issues/5919) opened by [@baruchoxman](https://github.com/baruchoxman)*
- [`42cfc79`](https://github.com/tobymao/sqlglot/commit/42cfc79ce120dee83084e2bb6b8bbd19f45bf06f) - **snowflake**: parse DAYOFWEEKISO *(PR [#5925](https://github.com/tobymao/sqlglot/pull/5925) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5924](https://github.com/tobymao/sqlglot/issues/5924) opened by [@baruchoxman](https://github.com/baruchoxman)*
- [`0be2cb4`](https://github.com/tobymao/sqlglot/commit/0be2cb448ee1a5ac020ac47e9944875c30e42632) - **postgres**: support `DISTINCT` qualifier in `JSON_AGG` fixes [#5935](https://github.com/tobymao/sqlglot/pull/5935) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`e34b2e1`](https://github.com/tobymao/sqlglot/commit/e34b2e14d1f87d095955765173a5e17fc9985220) - allow grouping set parser to consume more syntax fixes [#5937](https://github.com/tobymao/sqlglot/pull/5937) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`3846d4d`](https://github.com/tobymao/sqlglot/commit/3846d4dcdf8cbf8e90b2661083a567ab0547ad3c) - **solr**: properly support OR alternative operator *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`df428d5`](https://github.com/tobymao/sqlglot/commit/df428d516113a47ae50d04cd50a250830589c072) - **parser**: interval identifier followed by END *(PR [#5944](https://github.com/tobymao/sqlglot/pull/5944) by [@geooo109](https://github.com/geooo109))*
- [`e178d16`](https://github.com/tobymao/sqlglot/commit/e178d1674a71e6f35a6acfa8f4a317f0fe2e4516) - **duckdb**: UNNEST as table *(PR [#5953](https://github.com/tobymao/sqlglot/pull/5953) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5952](https://github.com/tobymao/sqlglot/issues/5952) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`24feb8e`](https://github.com/tobymao/sqlglot/commit/24feb8ee0bc43f3f14fd768c9a0d986355becea2) - **parser**: parse `UPDATE` clauses in any order *(PR [#5958](https://github.com/tobymao/sqlglot/pull/5958) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5956](https://github.com/tobymao/sqlglot/issues/5956) opened by [@sfc-gh-clathrope](https://github.com/sfc-gh-clathrope)*
- [`980f99a`](https://github.com/tobymao/sqlglot/commit/980f99a4cc0613012a189ee5636af37ec736040c) - **snowflake**: properly generate inferred `STRUCT` data types *(PR [#5954](https://github.com/tobymao/sqlglot/pull/5954) by [@georgesittas](https://github.com/georgesittas))*
- [`5432976`](https://github.com/tobymao/sqlglot/commit/543297680755344185e0f306843bc4909f4f75ed) - **bigquery**: allow GRANT as an id var *(PR [#5965](https://github.com/tobymao/sqlglot/pull/5965) by [@treysp](https://github.com/treysp))*
- [`7a3744f`](https://github.com/tobymao/sqlglot/commit/7a3744f203b93211e5dd97e6730b6bf59d6d96e0) - **sqlite**: support `RANGE CURRENT ROW` in window spec *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`c3bdb3c`](https://github.com/tobymao/sqlglot/commit/c3bdb3cd1af1809ed82be0ae40744d9fffc8ce18) - **starrocks**: array start index is 1, support array_flatten, fixes [#5983](https://github.com/tobymao/sqlglot/pull/5983) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`51b1bb1`](https://github.com/tobymao/sqlglot/commit/51b1bb178fa952edc13b2cbc6f624d30b0bde798) - move `WATERMARK` logic to risingwave fixes [#5989](https://github.com/tobymao/sqlglot/pull/5989) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`033ddf0`](https://github.com/tobymao/sqlglot/commit/033ddf04da895f1f5d38aff5361b2ae0793fefea) - **optimizer**: convert INNER JOINs to LEFT JOINs when merging LEFT JOIN subqueries *(PR [#5980](https://github.com/tobymao/sqlglot/pull/5980) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5969](https://github.com/tobymao/sqlglot/issues/5969) opened by [@karta0807913](https://github.com/karta0807913)*
- [`c7657fb`](https://github.com/tobymao/sqlglot/commit/c7657fbd27a4350c424ef65947471ab9ec086831) - remove `unalias_group_by` transformation since it is unsafe *(PR [#5997](https://github.com/tobymao/sqlglot/pull/5997) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5995](https://github.com/tobymao/sqlglot/issues/5995) opened by [@capricornsky0119](https://github.com/capricornsky0119)*
- [`b6f9694`](https://github.com/tobymao/sqlglot/commit/b6f9694c535cdd1403a63036cc246fda4e6d4d22) - **optimizer**: avoid merging subquery with JOIN when outer query uses JOIN *(PR [#5999](https://github.com/tobymao/sqlglot/pull/5999) by [@geooo109](https://github.com/geooo109))*
- [`23fd7b9`](https://github.com/tobymao/sqlglot/commit/23fd7b9116541b96e5d89389e862c6004e92d109) - respect multi-part Column units instead of converting to Var *(PR [#6005](https://github.com/tobymao/sqlglot/pull/6005) by [@georgesittas](https://github.com/georgesittas))*
- [`be1cdc8`](https://github.com/tobymao/sqlglot/commit/be1cdc81b511d462b710b50941d5c2770d901e91) - **duckdb**: Fix roundtrip of ~ operator *(PR [#6017](https://github.com/tobymao/sqlglot/pull/6017) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6016](https://github.com/tobymao/sqlglot/issues/6016) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`27c278f`](https://github.com/tobymao/sqlglot/commit/27c278f562f5ce98a1a4d31f8e66f148a1f42236) - **parser**: Allow LIMIT with % percentage *(PR [#6019](https://github.com/tobymao/sqlglot/pull/6019) by [@VaggelisD](https://github.com/VaggelisD))*
- [`39bf3f8`](https://github.com/tobymao/sqlglot/commit/39bf3f893389663796cdd799ef0f1e684f315a01) - **parser**: Allow CUBE & ROLLUP inside GROUPING SETS *(PR [#6018](https://github.com/tobymao/sqlglot/pull/6018) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6015](https://github.com/tobymao/sqlglot/issues/6015) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`ba7ad34`](https://github.com/tobymao/sqlglot/commit/ba7ad341d5ee1298b8fe54be11ca6252c1a44c99) - **duckdb**: Parse ROW type as STRUCT *(PR [#6020](https://github.com/tobymao/sqlglot/pull/6020) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6012](https://github.com/tobymao/sqlglot/issues/6012) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`718d6bb`](https://github.com/tobymao/sqlglot/commit/718d6bbf7f40e5b3e99563e2f1ac9eadeff57c3d) - handle unicode heredoc tags & Rust grapheme clusters properly *(PR [#6024](https://github.com/tobymao/sqlglot/pull/6024) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6010](https://github.com/tobymao/sqlglot/issues/6010) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`c8cfb9d`](https://github.com/tobymao/sqlglot/commit/c8cfb9db2e789be2dc7f8a154082a9210b736502) - **snowflake**: transpile ARRAY_CONTAINS with VARIANT CAST *(PR [#6029](https://github.com/tobymao/sqlglot/pull/6029) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6026](https://github.com/tobymao/sqlglot/issues/6026) opened by [@Birkman](https://github.com/Birkman)*
- [`6a6ca92`](https://github.com/tobymao/sqlglot/commit/6a6ca927c4e6e06f5cb38ad1153a8b556999ef90) - **parser**: Allow nested GROUPING SETS *(PR [#6041](https://github.com/tobymao/sqlglot/pull/6041) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6038](https://github.com/tobymao/sqlglot/issues/6038) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`41baeaa`](https://github.com/tobymao/sqlglot/commit/41baeaa1530c5419c945409133e3b7caa5250ec7) - **optimizer**: more robust CROSS JOIN substitution and JOIN reordering *(PR [#6021](https://github.com/tobymao/sqlglot/pull/6021) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6009](https://github.com/tobymao/sqlglot/issues/6009) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`e2f299f`](https://github.com/tobymao/sqlglot/commit/e2f299f5ad18d75a394e55bd1ee59ed243d77e54) - allow subqueries to have modifiers closes [#6014](https://github.com/tobymao/sqlglot/pull/6014) *(PR [#6034](https://github.com/tobymao/sqlglot/pull/6034) by [@tobymao](https://github.com/tobymao))*
- [`0d65266`](https://github.com/tobymao/sqlglot/commit/0d6526693f8e7dda9b7c180d31c364bde91afc72) - parse lambda for arg_min/max arguments closes [#6036](https://github.com/tobymao/sqlglot/pull/6036) *(PR [#6042](https://github.com/tobymao/sqlglot/pull/6042) by [@georgesittas](https://github.com/georgesittas))*
- [`0939d69`](https://github.com/tobymao/sqlglot/commit/0939d69223a860581b1c30cc2f762294946b93f3) - move odbc date literal handling in t-sql closes [#6037](https://github.com/tobymao/sqlglot/pull/6037) *(PR [#6044](https://github.com/tobymao/sqlglot/pull/6044) by [@georgesittas](https://github.com/georgesittas))*
- [`65848e5`](https://github.com/tobymao/sqlglot/commit/65848e5a3e4c1cb26e6ca4deb7819a282838c3c2) - **tsql**: UPDATE with OPTIONS *(PR [#6043](https://github.com/tobymao/sqlglot/pull/6043) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6033](https://github.com/tobymao/sqlglot/issues/6033) opened by [@ligfx](https://github.com/ligfx)*
- [`3bb6bb3`](https://github.com/tobymao/sqlglot/commit/3bb6bb3e5193ed53c803c3786a1791f15cd2f89a) - **parser**: support :: cast operator after IS NULL/IS NOT NULL *(PR [#6056](https://github.com/tobymao/sqlglot/pull/6056) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6055](https://github.com/tobymao/sqlglot/issues/6055) opened by [@vchan](https://github.com/vchan)*
- [`2c7cc29`](https://github.com/tobymao/sqlglot/commit/2c7cc29a329dcbaaa90a6f857d2383d2967ea6cc) - **duckdb**: Transform exp.HexString to BLOB in hex notation *(PR [#6045](https://github.com/tobymao/sqlglot/pull/6045) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6035](https://github.com/tobymao/sqlglot/issues/6035) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`e7833de`](https://github.com/tobymao/sqlglot/commit/e7833de9744a4aa69d244285e7f6f7281af178ba) - **parser**: support DELETE with USING and multiple VALUES *(PR [#6072](https://github.com/tobymao/sqlglot/pull/6072) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6070](https://github.com/tobymao/sqlglot/issues/6070) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`2238ac2`](https://github.com/tobymao/sqlglot/commit/2238ac27478bd272ba39928bbec1075c4191ee1b) - **duckdb**: transpile timestamp literals in datediff fixes [#6083](https://github.com/tobymao/sqlglot/pull/6083) *(PR [#6086](https://github.com/tobymao/sqlglot/pull/6086) by [@georgesittas](https://github.com/georgesittas))*
- [`bef541c`](https://github.com/tobymao/sqlglot/commit/bef541cec36f8c4295f815c3f5cd22491738901b) - **parser**: query mods and set ops in FROM-first syntax *(PR [#6092](https://github.com/tobymao/sqlglot/pull/6092) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6088](https://github.com/tobymao/sqlglot/issues/6088) opened by [@denis-komarov](https://github.com/denis-komarov)*
  - :arrow_lower_right: *fixes issue [#6091](https://github.com/tobymao/sqlglot/issues/6091) opened by [@denis-komarov](https://github.com/denis-komarov)*
  - :arrow_lower_right: *fixes issue [#6093](https://github.com/tobymao/sqlglot/issues/6093) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`5109890`](https://github.com/tobymao/sqlglot/commit/510989043d18baa17502a971262462814a2eb5be) - **parser**: VALUES with ORDER BY/LIMIT/OFFSET *(PR [#6094](https://github.com/tobymao/sqlglot/pull/6094) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6087](https://github.com/tobymao/sqlglot/issues/6087) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`4b062c8`](https://github.com/tobymao/sqlglot/commit/4b062c850bd9867be0d622f3f526762fa2b72302) - consume more syntax for cubes/rollups fixes [#6101](https://github.com/tobymao/sqlglot/pull/6101) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`f00866a`](https://github.com/tobymao/sqlglot/commit/f00866aeb8b7f51e27173c688225fe16d777eb1a) - **duckdb**: 1 arg FORMAT func *(PR [#6109](https://github.com/tobymao/sqlglot/pull/6109) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6108](https://github.com/tobymao/sqlglot/issues/6108) opened by [@erindru](https://github.com/erindru)*
- [`77dfd5a`](https://github.com/tobymao/sqlglot/commit/77dfd5a41bb9ce5450e0f6b7a78c953c8ade14d5) - lineage does not modify sql input if expression *(PR [#6113](https://github.com/tobymao/sqlglot/pull/6113) by [@snovik75](https://github.com/snovik75))*
  - :arrow_lower_right: *fixes issue [#6112](https://github.com/tobymao/sqlglot/issues/6112) opened by [@snovik75](https://github.com/snovik75)*
- [`06f40f9`](https://github.com/tobymao/sqlglot/commit/06f40f900ce693ba4203514e422cba8cda0dbb07) - **optimizer**: don't simplify x XOR x due to NULL semantics *(PR [#6115](https://github.com/tobymao/sqlglot/pull/6115) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6104](https://github.com/tobymao/sqlglot/issues/6104) opened by [@dllggyx](https://github.com/dllggyx)*
- [`03e2dff`](https://github.com/tobymao/sqlglot/commit/03e2dff9b074dc228cf3854ff1f4357e091aa9b3) - allow parsing `analyze` as an identifier fixes [#6123](https://github.com/tobymao/sqlglot/pull/6123) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`8744431`](https://github.com/tobymao/sqlglot/commit/874443148c8ec2a773dfaca5da10d3587a49de3e) - transpile bigquery DATETIME_DIFF to duckdb *(PR [#6126](https://github.com/tobymao/sqlglot/pull/6126) by [@toriwei](https://github.com/toriwei))*
  - :arrow_lower_right: *fixes issue [#6107](https://github.com/tobymao/sqlglot/issues/6107) opened by [@izeigerman](https://github.com/izeigerman)*
- [`b94e81b`](https://github.com/tobymao/sqlglot/commit/b94e81b42b89c75625b2da779c0f53777d9b6b48) - **optimizer**: avoid removing string literals from WHERE clause *(PR [#6131](https://github.com/tobymao/sqlglot/pull/6131) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6128](https://github.com/tobymao/sqlglot/issues/6128) opened by [@dllggyx](https://github.com/dllggyx)*
- [`e2129c6`](https://github.com/tobymao/sqlglot/commit/e2129c6766ca1f10ff6663bec98be984abb33c91) - **optimizer**: Do not consider BIT_COUNT an aggregate function *(PR [#6135](https://github.com/tobymao/sqlglot/pull/6135) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6130](https://github.com/tobymao/sqlglot/issues/6130) opened by [@dllggyx](https://github.com/dllggyx)*
- [`03bfeed`](https://github.com/tobymao/sqlglot/commit/03bfeed56c5c2f143ce2e1be38d519f902d19961) - **starrocks**: disable IS TRUE/FALSE syntax support *(PR [#6145](https://github.com/tobymao/sqlglot/pull/6145) by [@petrikoro](https://github.com/petrikoro))*
  - :arrow_lower_right: *fixes issue [#6144](https://github.com/tobymao/sqlglot/issues/6144) opened by [@petrikoro](https://github.com/petrikoro)*
- [`d136414`](https://github.com/tobymao/sqlglot/commit/d136414e520270ac9ab2fd8e9df4691d269b3af0) - **optimizer**: avoid simplifying AND with NULL *(PR [#6148](https://github.com/tobymao/sqlglot/pull/6148) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6136](https://github.com/tobymao/sqlglot/issues/6136) opened by [@dllggyx](https://github.com/dllggyx)*
- [`1fd9991`](https://github.com/tobymao/sqlglot/commit/1fd99911a60f0543fbc79221a8c6a6f232ed0a2a) - **clickhouse**: NOT + IN precedence *(PR [#6149](https://github.com/tobymao/sqlglot/pull/6149) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6143](https://github.com/tobymao/sqlglot/issues/6143) opened by [@mlipiev](https://github.com/mlipiev)*
- [`3acf796`](https://github.com/tobymao/sqlglot/commit/3acf7965105a098fea6336df0c304d94acbd05ec) - **duckdb**: Allow ESCAPE NULL *(PR [#6164](https://github.com/tobymao/sqlglot/pull/6164) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6160](https://github.com/tobymao/sqlglot/issues/6160) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`f7f1fca`](https://github.com/tobymao/sqlglot/commit/f7f1fca39a75df16ebb93f038e6277a25b8be6b9) - **duckdb**: Support positional index in list comprehension *(PR [#6163](https://github.com/tobymao/sqlglot/pull/6163) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6156](https://github.com/tobymao/sqlglot/issues/6156) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`d382a31`](https://github.com/tobymao/sqlglot/commit/d382a3106d5ce2e9b75527aacd4a37d1f8e16d18) - **optimizer**: simplify double negation only if the inner expr is BOOLEAN *(PR [#6151](https://github.com/tobymao/sqlglot/pull/6151) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6129](https://github.com/tobymao/sqlglot/issues/6129) opened by [@dllggyx](https://github.com/dllggyx)*
- [`dfe6b3c`](https://github.com/tobymao/sqlglot/commit/dfe6b3c8e6db40e22e626e2d56e9a7008dd75c32) - **optimizer**: Disambiguate JOIN ON columns during qualify *(PR [#6155](https://github.com/tobymao/sqlglot/pull/6155) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6132](https://github.com/tobymao/sqlglot/issues/6132) opened by [@Fosly](https://github.com/Fosly)*
- [`f267ece`](https://github.com/tobymao/sqlglot/commit/f267ecea92b0751f6b35a4ad0c70fe6754e49038) - normalize before qualifying tables *(PR [#6176](https://github.com/tobymao/sqlglot/pull/6176) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6167](https://github.com/tobymao/sqlglot/issues/6167) opened by [@schelip](https://github.com/schelip)*
- [`ef87520`](https://github.com/tobymao/sqlglot/commit/ef875204596b8529f3358025c7a61d757a999bdc) - **postgres, duckdb**: Transpile `REGEXP_REPLACE` with 'g' option *(PR [#6174](https://github.com/tobymao/sqlglot/pull/6174) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6170](https://github.com/tobymao/sqlglot/issues/6170) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`51a8d70`](https://github.com/tobymao/sqlglot/commit/51a8d700a9602278d1e98425af0fa87d02c739fe) - **parser**: allow LIMIT % OFFSET *(PR [#6184](https://github.com/tobymao/sqlglot/pull/6184) by [@toriwei](https://github.com/toriwei))*
  - :arrow_lower_right: *fixes issue [#6166](https://github.com/tobymao/sqlglot/issues/6166) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`8bf0a9f`](https://github.com/tobymao/sqlglot/commit/8bf0a9fe8e167984dc2e7b43d52d3850e063da3f) - **duckdb**: Cast literal arg to timestamp for epoch_us function *(PR [#6190](https://github.com/tobymao/sqlglot/pull/6190) by [@vchan](https://github.com/vchan))*
- [`93071e2`](https://github.com/tobymao/sqlglot/commit/93071e255406f62ea83dd89a3be4871b7edfb3fe) - **optimizer**: Fix simplify_parens from removing negated *(PR [#6194](https://github.com/tobymao/sqlglot/pull/6194) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6179](https://github.com/tobymao/sqlglot/issues/6179) opened by [@dllggyx](https://github.com/dllggyx)*
- [`2ac3a03`](https://github.com/tobymao/sqlglot/commit/2ac3a03409d9239d0cf7fb265843d7837a0a3fcd) - **lineage**: correct star detection and add join star tests *(PR [#6185](https://github.com/tobymao/sqlglot/pull/6185) by [@lancewl](https://github.com/lancewl))*
- [`c9ae2eb`](https://github.com/tobymao/sqlglot/commit/c9ae2ebdb86abdb767f2fcb00da0b6277b4aea45) - **duckdb**: transpile BigQuery TIMESTAMP_ADD to duckdb *(PR [#6188](https://github.com/tobymao/sqlglot/pull/6188) by [@toriwei](https://github.com/toriwei))*
- [`ba0e17a`](https://github.com/tobymao/sqlglot/commit/ba0e17a25af417e24162bfab49c3074454a5c1a8) - **snowflake**: Transpile `ARRAY_CONCAT_AGG` to `ARRAY_FLATTEN(ARRAY_AGG(...))` *(PR [#6192](https://github.com/tobymao/sqlglot/pull/6192) by [@ozadari](https://github.com/ozadari))*
- [`730e4cc`](https://github.com/tobymao/sqlglot/commit/730e4cc5b77bff9135667193cc0a65c24cdfb6b5) - **trino**: Allow 2nd arg for FIRST/LAST functions *(PR [#6205](https://github.com/tobymao/sqlglot/pull/6205) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6204](https://github.com/tobymao/sqlglot/issues/6204) opened by [@Harmuth94](https://github.com/Harmuth94)*
- [`e7ddad1`](https://github.com/tobymao/sqlglot/commit/e7ddad10b5edf9b801d2151e3e5fca448754df0d) - **optimizer**: ensure `NULL` coerces into any type *(PR [#6211](https://github.com/tobymao/sqlglot/pull/6211) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`4c4189b`](https://github.com/tobymao/sqlglot/commit/4c4189b4083d272a6e678d83b5c567a2e9c0d672) - Transpile CONCAT function to double pipe operators when source … *(PR [#6241](https://github.com/tobymao/sqlglot/pull/6241) by [@vchan](https://github.com/vchan))*
- [`fc78d20`](https://github.com/tobymao/sqlglot/commit/fc78d2016d8f7d20c094df791f746de323cd3639) - **parser**: Unwrap subqueries without modifiers *(PR [#6247](https://github.com/tobymao/sqlglot/pull/6247) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6237](https://github.com/tobymao/sqlglot/issues/6237) opened by [@preet-sheth](https://github.com/preet-sheth)*
- [`7ad4c17`](https://github.com/tobymao/sqlglot/commit/7ad4c177fbf8dda78aa8de1ca112f606b2fd5456) - **databricks**: Support table names in FROM STREAM *(PR [#6259](https://github.com/tobymao/sqlglot/pull/6259) by [@roveo](https://github.com/roveo))*
- [`00abc39`](https://github.com/tobymao/sqlglot/commit/00abc393c9042e839457c5a6582e95cdb74356f3) - **generator**: handle casting for bytestrings  *(PR [#6252](https://github.com/tobymao/sqlglot/pull/6252) by [@toriwei](https://github.com/toriwei))*
- [`bcf2eac`](https://github.com/tobymao/sqlglot/commit/bcf2eace0baf1d85047841f36cb5c0082c61b29c) - **duckdb**: map int8 to bigint instead of tinyint fixes [#6269](https://github.com/tobymao/sqlglot/pull/6269) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`ddea61d`](https://github.com/tobymao/sqlglot/commit/ddea61d83f6699c97cc7b25aabe01a138138bdb1) - **optimizer**: simplify connector complements only for non-null operands *(PR [#6214](https://github.com/tobymao/sqlglot/pull/6214) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6213](https://github.com/tobymao/sqlglot/issues/6213) opened by [@geooo109](https://github.com/geooo109)*
- [`e17320e`](https://github.com/tobymao/sqlglot/commit/e17320ee3bdd0ef541d616c447b4973d12780dae) - Handle edge cases in  for DuckDB RANGE to Spark SEQUENCE transpilation *(PR [#6276](https://github.com/tobymao/sqlglot/pull/6276) by [@joeyutong](https://github.com/joeyutong))*
- [`33b6218`](https://github.com/tobymao/sqlglot/commit/33b62183a15cdedf0b1ebd96fcb856afbe8879a0) - sqlsecurityproperty parseerror *(PR [#6280](https://github.com/tobymao/sqlglot/pull/6280) by [@ds-cbo](https://github.com/ds-cbo))*
  - :arrow_lower_right: *fixes issue [#6279](https://github.com/tobymao/sqlglot/issues/6279) opened by [@ds-cbo](https://github.com/ds-cbo)*
- [`c02b64c`](https://github.com/tobymao/sqlglot/commit/c02b64c3524dd074c2108baaca668ab2607ac843) - **optimizer**: Handle pseudocolumns differently than columns *(PR [#6273](https://github.com/tobymao/sqlglot/pull/6273) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6256](https://github.com/tobymao/sqlglot/issues/6256) opened by [@azilya](https://github.com/azilya)*
- [`05c5181`](https://github.com/tobymao/sqlglot/commit/05c5181b36a7ada32b96fc91bdfbf73b38a1a408) - **optimizer**: refactor `Connector` simplification to factor in types *(PR [#6152](https://github.com/tobymao/sqlglot/pull/6152) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6137](https://github.com/tobymao/sqlglot/issues/6137) opened by [@dllggyx](https://github.com/dllggyx)*
- [`cb0bcff`](https://github.com/tobymao/sqlglot/commit/cb0bcff310e9acdf806fc98e99cb9938b747c771) - **duckdb**: cast UUID() output to varchar when source dialect UUID() returns string *(PR [#6284](https://github.com/tobymao/sqlglot/pull/6284) by [@toriwei](https://github.com/toriwei))*
- [`f9287f7`](https://github.com/tobymao/sqlglot/commit/f9287f7d596a6d8a1e1cd2c48978a4dec77a96cb) - **optimizer**: robust deduplication of connectors *(PR [#6296](https://github.com/tobymao/sqlglot/pull/6296) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6182](https://github.com/tobymao/sqlglot/issues/6182) opened by [@dllggyx](https://github.com/dllggyx)*
- [`ea0ea79`](https://github.com/tobymao/sqlglot/commit/ea0ea79c1c611b62c79f82f744fe0c98803598a3) - **clickhouse**: Parse `LIKE` functions *(PR [#6314](https://github.com/tobymao/sqlglot/pull/6314) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6313](https://github.com/tobymao/sqlglot/issues/6313) opened by [@CainYang](https://github.com/CainYang)*
- [`bbd4c90`](https://github.com/tobymao/sqlglot/commit/bbd4c901a9550beb363758e6be1e1877d4e56f2c) - **sqlite**: support IS with identifier as RHS *(PR [#6316](https://github.com/tobymao/sqlglot/pull/6316) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6315](https://github.com/tobymao/sqlglot/issues/6315) opened by [@VLDB2026](https://github.com/VLDB2026)*
- [`65d213a`](https://github.com/tobymao/sqlglot/commit/65d213a7662962d4226368590508fbf61675c055) - **dialect**: fix typo from millenium to millennium [#6321](https://github.com/tobymao/sqlglot/pull/6321) *(commit by [@lBilali](https://github.com/lBilali))*
- [`c9d1615`](https://github.com/tobymao/sqlglot/commit/c9d16150a408a41daf704d2d0b0ebfce57425b81) - **tsql**: map iso_week with the correct python directive from strftime *(PR [#6322](https://github.com/tobymao/sqlglot/pull/6322) by [@lBilali](https://github.com/lBilali))*
- [`85ddcc5`](https://github.com/tobymao/sqlglot/commit/85ddcc5eca22ac726582de454f2f12b9d4877634) - **bigquery**: Do not normalize JSON fields in dot notation *(PR [#6320](https://github.com/tobymao/sqlglot/pull/6320) by [@VaggelisD](https://github.com/VaggelisD))*
- [`933e981`](https://github.com/tobymao/sqlglot/commit/933e98102fb39d24ae0350da13337d981287130a) - **optimizer**: more robust NULL reduction *(PR [#6327](https://github.com/tobymao/sqlglot/pull/6327) by [@geooo109](https://github.com/geooo109))*
- [`e1c6d57`](https://github.com/tobymao/sqlglot/commit/e1c6d5716f80eb24b6d0a9c93e187a8c9f05e555) - **parser**: improve between .. preceding .. following parser fixes [#6332](https://github.com/tobymao/sqlglot/pull/6332) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`65706e8`](https://github.com/tobymao/sqlglot/commit/65706e8c7edeb7de674d427718eac181df206dc9) - avoid full traversal for pushdown_cte_alias_columns *(commit by [@tobymao](https://github.com/tobymao))*
- [`c81258e`](https://github.com/tobymao/sqlglot/commit/c81258e9c26f637f6f8520051c159685c8b1cb7e) - **parser**: allow using OVER token as unquoted identifier *(PR [#6338](https://github.com/tobymao/sqlglot/pull/6338) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6337](https://github.com/tobymao/sqlglot/issues/6337) opened by [@VLDB2026](https://github.com/VLDB2026)*
- [`73abfac`](https://github.com/tobymao/sqlglot/commit/73abfac4cec27350754c942be71175fa7bdfd1d0) - **redshift**: do not inherit postgres `ROUND` generator closes [#6340](https://github.com/tobymao/sqlglot/pull/6340) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`0f79f2a`](https://github.com/tobymao/sqlglot/commit/0f79f2a55c4ba14d4a5fcfd01a0a727271992b8c) - **snowflake**: MAX_BY and MIN_BY with count should return plain `ARRAY` *(PR [#6343](https://github.com/tobymao/sqlglot/pull/6343) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`e1b6558`](https://github.com/tobymao/sqlglot/commit/e1b6558cb1a860bbd695f25b66e52064b57c0a84) - **tsql**: handle all datepart alternatives *(PR [#6324](https://github.com/tobymao/sqlglot/pull/6324) by [@lBilali](https://github.com/lBilali))*
- [`06daa47`](https://github.com/tobymao/sqlglot/commit/06daa47dedebac672548e1db230b89f5c9eae84e) - **optimizer**: update annotated type of ARRAY_AGG to untyped array *(PR [#6347](https://github.com/tobymao/sqlglot/pull/6347) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`826db4d`](https://github.com/tobymao/sqlglot/commit/826db4d3c413941e3b0b31e1f907fabd017bd461) - **redshift**: properly parse default IAM_ROLE and AVRO/JSON formats in COPY *(PR [#6346](https://github.com/tobymao/sqlglot/pull/6346) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6345](https://github.com/tobymao/sqlglot/issues/6345) opened by [@zachary-povey](https://github.com/zachary-povey)*
- [`c367bac`](https://github.com/tobymao/sqlglot/commit/c367bac878a3c17773009b54b9836e7b9a5b84fe) - **duckdb**: Support update without set in DuckDB merge when matched *(PR [#6357](https://github.com/tobymao/sqlglot/pull/6357) by [@themisvaltinos](https://github.com/themisvaltinos))*
- [`df13a65`](https://github.com/tobymao/sqlglot/commit/df13a655646bd2ef5d8b4613670bb5fe48845b73) - unnest deep stuff *(PR [#6366](https://github.com/tobymao/sqlglot/pull/6366) by [@tobymao](https://github.com/tobymao))*
- [`20e33fd`](https://github.com/tobymao/sqlglot/commit/20e33fd0d1bc1899727d023411e604f1ea9347b8) - **duckdb**: regexp_extract_all closes [#6380](https://github.com/tobymao/sqlglot/pull/6380) *(commit by [@tobymao](https://github.com/tobymao))*
- [`d4c2256`](https://github.com/tobymao/sqlglot/commit/d4c2256fb493ed2f16c29694ae5c31517123d419) - **parser**: at time zone precedence *(PR [#6383](https://github.com/tobymao/sqlglot/pull/6383) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6359](https://github.com/tobymao/sqlglot/issues/6359) opened by [@parth-wisdom](https://github.com/parth-wisdom)*
- [`4fb4d08`](https://github.com/tobymao/sqlglot/commit/4fb4d08ef8896bda434d4f89c21c669c6146fd02) - **oracle**: properly support table alias in the `INSERT` DML *(PR [#6374](https://github.com/tobymao/sqlglot/pull/6374) by [@snovik75](https://github.com/snovik75))*
  - :arrow_lower_right: *fixes issue [#6371](https://github.com/tobymao/sqlglot/issues/6371) opened by [@snovik75](https://github.com/snovik75)*
- [`2169f5b`](https://github.com/tobymao/sqlglot/commit/2169f5b8f30b6c8be1635bb5648a1abf636e49a6) - **parser**: support SET with := *(PR [#6385](https://github.com/tobymao/sqlglot/pull/6385) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6384](https://github.com/tobymao/sqlglot/issues/6384) opened by [@AndyVW77](https://github.com/AndyVW77)*
- [`50348ac`](https://github.com/tobymao/sqlglot/commit/50348ac31f784aa97bd09d5d6c6613fbd68402ee) - **mysql**: support order by clause for mysql delete statement *(PR [#6381](https://github.com/tobymao/sqlglot/pull/6381) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
  - :arrow_lower_right: *fixes issue [#6372](https://github.com/tobymao/sqlglot/issues/6372) opened by [@AhlamHani](https://github.com/AhlamHani)*
- [`21d3859`](https://github.com/tobymao/sqlglot/commit/21d38590fec6cb55a1a03aeb2621bd9fca677496) - **bigquery**: Disable STRING_AGG sep canonicalization *(PR [#6395](https://github.com/tobymao/sqlglot/pull/6395) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6392](https://github.com/tobymao/sqlglot/issues/6392) opened by [@erindru](https://github.com/erindru)*
- [`67f499d`](https://github.com/tobymao/sqlglot/commit/67f499dd497efdf4f3fc49dd75e49a77e036ee63) - **duckdb**: Make exp.DateFromParts more lenient *(PR [#6397](https://github.com/tobymao/sqlglot/pull/6397) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6394](https://github.com/tobymao/sqlglot/issues/6394) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`39f8c37`](https://github.com/tobymao/sqlglot/commit/39f8c37aca755d97e1e41f232042d1c649e58908) - **parser**: support FROM-syntax with joins *(PR [#6402](https://github.com/tobymao/sqlglot/pull/6402) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6396](https://github.com/tobymao/sqlglot/issues/6396) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`9ddae4d`](https://github.com/tobymao/sqlglot/commit/9ddae4d56d1e3a15fc3b4b76ce3b3040683c220f) - **duckdb**: support IN with no paren *(PR [#6409](https://github.com/tobymao/sqlglot/pull/6409) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6407](https://github.com/tobymao/sqlglot/issues/6407) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`c7cb098`](https://github.com/tobymao/sqlglot/commit/c7cb0983a0fa463c43d2c4ee925816e9a1628c79) - **tokenizer**: Fix underscore separator with scientific notation *(PR [#6401](https://github.com/tobymao/sqlglot/pull/6401) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6393](https://github.com/tobymao/sqlglot/issues/6393) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`f5635d2`](https://github.com/tobymao/sqlglot/commit/f5635d2cc2a5612d6403bbf508b545f2a4e8f773) - **duckdb**: splice with col named after type closes [#6411](https://github.com/tobymao/sqlglot/pull/6411) *(commit by [@tobymao](https://github.com/tobymao))*
- [`097d865`](https://github.com/tobymao/sqlglot/commit/097d865554d9ba2e226962fa71778ae0a6c596cb) - **duckdb**: pivot using cast closes [#6410](https://github.com/tobymao/sqlglot/pull/6410) *(commit by [@tobymao](https://github.com/tobymao))*
- [`d038ad7`](https://github.com/tobymao/sqlglot/commit/d038ad7f036a140f3eae4bdde15824437d4e44ee) - **mysql**: support named primary keys for mysql *(PR [#6389](https://github.com/tobymao/sqlglot/pull/6389) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
  - :arrow_lower_right: *fixes issue [#6382](https://github.com/tobymao/sqlglot/issues/6382) opened by [@AndyVW77](https://github.com/AndyVW77)*
- [`4f3bb0d`](https://github.com/tobymao/sqlglot/commit/4f3bb0d6714bf89ff72e13e1398d8f01cefafb00) - **DuckDB**: Correct transpilation of BigQuery's JSON_EXTRACT_SCALAR… *(PR [#6414](https://github.com/tobymao/sqlglot/pull/6414) by [@vchan](https://github.com/vchan))*
- [`e2f306f`](https://github.com/tobymao/sqlglot/commit/e2f306f1893a3f565cbbf7857ffd9795850aba7b) - interval column ops closes [#6416](https://github.com/tobymao/sqlglot/pull/6416) *(commit by [@tobymao](https://github.com/tobymao))*
- [`8c314a8`](https://github.com/tobymao/sqlglot/commit/8c314a8b457a5c3ed470ac8fcff022fec881c248) - **duckdb**: support cte pivot for duckdb *(PR [#6413](https://github.com/tobymao/sqlglot/pull/6413) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
  - :arrow_lower_right: *fixes issue [#6405](https://github.com/tobymao/sqlglot/issues/6405) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`92ee124`](https://github.com/tobymao/sqlglot/commit/92ee1241ea3088d4e63c094404252339c54ad0c1) - **optimizer**: postgres qualify GENERATE_SERIES and table projection *(PR [#6373](https://github.com/tobymao/sqlglot/pull/6373) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6358](https://github.com/tobymao/sqlglot/issues/6358) opened by [@metahexane](https://github.com/metahexane)*
- [`7021d54`](https://github.com/tobymao/sqlglot/commit/7021d54ecf0ceab3c3606642cbfca8e080cc8613) - **tsql**: CEILING generation *(PR [#6477](https://github.com/tobymao/sqlglot/pull/6477) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6472](https://github.com/tobymao/sqlglot/issues/6472) opened by [@ricky-ho](https://github.com/ricky-ho)*
- [`df4c1d3`](https://github.com/tobymao/sqlglot/commit/df4c1d37ff77151a74b5de3d119c7e03f5db85f4) - REGEXP_EXTRACT position arg overflow *(PR [#6458](https://github.com/tobymao/sqlglot/pull/6458) by [@treysp](https://github.com/treysp))*
  - :arrow_lower_right: *fixes issue [#6442](https://github.com/tobymao/sqlglot/issues/6442) opened by [@erindru](https://github.com/erindru)*
- [`5a49c3f`](https://github.com/tobymao/sqlglot/commit/5a49c3f7a7619ad9e711ff2cd9e85b8606969b36) - **optimizer**: support ORDER / LIMIT expressions for BigQuery ARRAY_AGG / STRING_AGG functions *(PR [#6463](https://github.com/tobymao/sqlglot/pull/6463) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`1b6076b`](https://github.com/tobymao/sqlglot/commit/1b6076bd5a64b044f52f5366244ba0746aca75e1) - wrap connectives generated due to transpiling LIKE ANY closes [#6493](https://github.com/tobymao/sqlglot/pull/6493) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`36ad534`](https://github.com/tobymao/sqlglot/commit/36ad534b14eabe9ee197017f5087e8e5190f8526) - **exasol**: qualified select list with "LOCAL" *(PR [#6450](https://github.com/tobymao/sqlglot/pull/6450) by [@nnamdi16](https://github.com/nnamdi16))*
- [`52aceaa`](https://github.com/tobymao/sqlglot/commit/52aceaaa887dddb35f8ede5c2d9577fdeee35c48) - **optimizer**: annotate `HavingMax` by `this` *(PR [#6499](https://github.com/tobymao/sqlglot/pull/6499) by [@georgesittas](https://github.com/georgesittas))*
- [`ce5487e`](https://github.com/tobymao/sqlglot/commit/ce5487ef2ec0a3de8fa79b9febf41236c05c04cc) - sources doesn't store columns, clean up this old code *(commit by [@tobymao](https://github.com/tobymao))*
- [`3224235`](https://github.com/tobymao/sqlglot/commit/3224235c1b7a80511af11f7dbffe608a747a3df0) - make CTE builder produce AST consistent with parser closes [#6503](https://github.com/tobymao/sqlglot/pull/6503) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`9454a18`](https://github.com/tobymao/sqlglot/commit/9454a18cca41a510e61522f6b785d646980e2100) - uppercase join method, side, kind for consistency fixes [#6510](https://github.com/tobymao/sqlglot/pull/6510) *(PR [#6511](https://github.com/tobymao/sqlglot/pull/6511) by [@georgesittas](https://github.com/georgesittas))*
- [`a6ec4b6`](https://github.com/tobymao/sqlglot/commit/a6ec4b688891691b26ab874a3401e370c0b8d574) - reorder join mark check in eliminate_join_marks *(PR [#6528](https://github.com/tobymao/sqlglot/pull/6528) by [@snovik75](https://github.com/snovik75))*
  - :arrow_lower_right: *fixes issue [#6527](https://github.com/tobymao/sqlglot/issues/6527) opened by [@snovik75](https://github.com/snovik75)*
- [`9d06859`](https://github.com/tobymao/sqlglot/commit/9d0685923209c04747fa6fa2b35ee2e516453abc) - **optimizer**: annotate bigquery ARRAY when arg contains set operations *(PR [#6517](https://github.com/tobymao/sqlglot/pull/6517) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`241073d`](https://github.com/tobymao/sqlglot/commit/241073d886e0b4ad7b2252a8c8c394e717ef700a) - on_qualify type *(commit by [@tobymao](https://github.com/tobymao))*
- [`2fd14ed`](https://github.com/tobymao/sqlglot/commit/2fd14ed32b3793444405005fb98342222b4d7956) - **optimizer**: query schema directly when type annotation fails for processing UNNEST source *(PR [#6451](https://github.com/tobymao/sqlglot/pull/6451) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`62b348c`](https://github.com/tobymao/sqlglot/commit/62b348ce46d014895bd17d89ccb0b3e186e46d15) - **tokenizer**: add support for noop string escapes *(PR [#6526](https://github.com/tobymao/sqlglot/pull/6526) by [@nian0114](https://github.com/nian0114))*
- [`724e4b3`](https://github.com/tobymao/sqlglot/commit/724e4b3657018430e23976cf6a69989298521180) - **snowflake**: don't simplify match_condition closes [#6537](https://github.com/tobymao/sqlglot/pull/6537) *(commit by [@tobymao](https://github.com/tobymao))*
- [`12a6f7d`](https://github.com/tobymao/sqlglot/commit/12a6f7dc1b8604a2c9f4937654bd8bc458336110) - Only trigger integration tests on PR events *(PR [#6539](https://github.com/tobymao/sqlglot/pull/6539) by [@erindru](https://github.com/erindru))*
- [`f21cf76`](https://github.com/tobymao/sqlglot/commit/f21cf763575b67084ea81a377c5bdb3e86041e4c) - **optimizer**: bq annotate SAFE_DIVIDE with both args as INT64 *(PR [#6543](https://github.com/tobymao/sqlglot/pull/6543) by [@geooo109](https://github.com/geooo109))*
- [`4a57302`](https://github.com/tobymao/sqlglot/commit/4a5730242787920d0a2412aef495eb2eeaaa2119) - **optimizer**: ensure structs are annotated as unknown if any argument is unknown *(PR [#6544](https://github.com/tobymao/sqlglot/pull/6544) by [@georgesittas](https://github.com/georgesittas))*
- [`63a2e49`](https://github.com/tobymao/sqlglot/commit/63a2e49485f237e1c7e16358c412acb5df50e22c) - **diff**: stop treating `None` args as leaves to be diffed *(PR [#6556](https://github.com/tobymao/sqlglot/pull/6556) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6554](https://github.com/tobymao/sqlglot/issues/6554) opened by [@GaryLiuGTA](https://github.com/GaryLiuGTA)*
- [`c118af2`](https://github.com/tobymao/sqlglot/commit/c118af2f78af3e557f569c31b1561802338a48c4) - **lineage**: Fix GraphHTML edge 'from' key *(PR [#6571](https://github.com/tobymao/sqlglot/pull/6571) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6570](https://github.com/tobymao/sqlglot/issues/6570) opened by [@PhilHenson82](https://github.com/PhilHenson82)*
- [`baeb656`](https://github.com/tobymao/sqlglot/commit/baeb656ee2ae354f91f36ebcaee60848e09f43b4) - **optimizer**: fallback scenario in get_table of resolver raises with wrong message *(PR [#6563](https://github.com/tobymao/sqlglot/pull/6563) by [@snovik75](https://github.com/snovik75))*
  - :arrow_lower_right: *fixes issue [#6562](https://github.com/tobymao/sqlglot/issues/6562) opened by [@snovik75](https://github.com/snovik75)*
- [`14dc1e5`](https://github.com/tobymao/sqlglot/commit/14dc1e5bc74b3b8907ba02bf89ad1763940c9ea2) - **snowflake**: make `DATE_PART` roundtrip *(PR [#6573](https://github.com/tobymao/sqlglot/pull/6573) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6565](https://github.com/tobymao/sqlglot/issues/6565) opened by [@erindru](https://github.com/erindru)*
- [`8a44ad5`](https://github.com/tobymao/sqlglot/commit/8a44ad560cb65a34a722b257a82e69a41e7e45e0) - **bigquery**: Mark _DBT_MAX_PARTITION as pseudocolumn *(PR [#6572](https://github.com/tobymao/sqlglot/pull/6572) by [@VaggelisD](https://github.com/VaggelisD))*

### :recycle: Refactors
- [`e441e16`](https://github.com/tobymao/sqlglot/commit/e441e16991626c2da2d38bc9c3a2b408e3f773bd) - make dump/pickling non-recursive to avoid hitting stack limits *(PR [#5850](https://github.com/tobymao/sqlglot/pull/5850) by [@tobymao](https://github.com/tobymao))*
- [`095b2ac`](https://github.com/tobymao/sqlglot/commit/095b2ac3af230eff86d9bc1b0fd3a0a2095f151c) - clean up duckdb INSTALL tests *(commit by [@geooo109](https://github.com/geooo109))*
- [`d425ba2`](https://github.com/tobymao/sqlglot/commit/d425ba26b96b368801f8f486fa375cd75105993d) - make hash and eq non recursive *(PR [#5966](https://github.com/tobymao/sqlglot/pull/5966) by [@tobymao](https://github.com/tobymao))*
- [`8f00c80`](https://github.com/tobymao/sqlglot/commit/8f00c804a67209a5eca1fcb28aeb95941c58e583) - _parse_in expr len check *(commit by [@geooo109](https://github.com/geooo109))*
- [`2c9d15c`](https://github.com/tobymao/sqlglot/commit/2c9d15c92da25c8456b2463c69aa56c8ec47c453) - replace direct arg manipulation *(PR [#6073](https://github.com/tobymao/sqlglot/pull/6073) by [@geooo109](https://github.com/geooo109))*
- [`58dbce3`](https://github.com/tobymao/sqlglot/commit/58dbce30da5ab94af82247ab8a7eb85200d9b8af) - bq static type annotators *(PR [#6103](https://github.com/tobymao/sqlglot/pull/6103) by [@geooo109](https://github.com/geooo109))*
- [`c970235`](https://github.com/tobymao/sqlglot/commit/c97023549623fe5974d6bff57e64339eff74187e) - clean up MONTHNAME test *(commit by [@geooo109](https://github.com/geooo109))*
- [`6d775fd`](https://github.com/tobymao/sqlglot/commit/6d775fdb6091cb866c27c0f1141514b23d689284) - snowflake GREATEST type checks *(commit by [@geooo109](https://github.com/geooo109))*
- [`e797fb1`](https://github.com/tobymao/sqlglot/commit/e797fb105f7fa4e7bd42698eda71037cae9fd155) - update `LIKE` operator when using functional syntax with spark dialect *(PR [#6173](https://github.com/tobymao/sqlglot/pull/6173) by [@themattmorris](https://github.com/themattmorris))*
  - :arrow_lower_right: *addresses issue [#6172](https://github.com/tobymao/sqlglot/issues/6172) opened by [@themattmorris](https://github.com/themattmorris)*
- [`9c98fc2`](https://github.com/tobymao/sqlglot/commit/9c98fc2b39fef2bd052b60ba4e15a4b93fd66c00) - **optimizer**: avoid extra copy in simplify *(commit by [@geooo109](https://github.com/geooo109))*
- [`43985fb`](https://github.com/tobymao/sqlglot/commit/43985fbcb9edea088119951c5c245a9606cf92ae) - **snowflake**: remove redundant tests for ANY_VALUE *(commit by [@geooo109](https://github.com/geooo109))*
- [`bf7b032`](https://github.com/tobymao/sqlglot/commit/bf7b032baae0c0fd112054a7bed6fa2f56f32890) - clean up struct name inheritance *(PR [#6295](https://github.com/tobymao/sqlglot/pull/6295) by [@georgesittas](https://github.com/georgesittas))*
- [`49e0f43`](https://github.com/tobymao/sqlglot/commit/49e0f43ba19739575987f2e9c52c2061a6f59717) - extra test for spark approx_top_k_accumulate *(commit by [@geooo109](https://github.com/geooo109))*
- [`e4d1a4f`](https://github.com/tobymao/sqlglot/commit/e4d1a4fcd6741d679c5444bf023077d2aaa8f980) - **exasol**: map date/timestamp `TRUNC` to `DATE_TRUNC` *(PR [#6328](https://github.com/tobymao/sqlglot/pull/6328) by [@nnamdi16](https://github.com/nnamdi16))*
- [`c6b0a63`](https://github.com/tobymao/sqlglot/commit/c6b0a6342a21d79635a26d40001c916d05d47cf7) - change version to be a tuple so that it can be pickled, also simpler *(commit by [@tobymao](https://github.com/tobymao))*
- [`625654a`](https://github.com/tobymao/sqlglot/commit/625654a9623cc5407bfde922c29f32a8ee905a3b) - move resolver to own file *(commit by [@tobymao](https://github.com/tobymao))*
- [`2d380e7`](https://github.com/tobymao/sqlglot/commit/2d380e72c9e3b842a8fe57c191f494c8872c00ee) - add test to make sure callback doesn't trigger ctes *(commit by [@tobymao](https://github.com/tobymao))*
- [`1876c5a`](https://github.com/tobymao/sqlglot/commit/1876c5a86c3b737b7360c4fef25c44dc010b66db) - consolidate can_quote logic and fix an issue with identify=False *(PR [#6534](https://github.com/tobymao/sqlglot/pull/6534) by [@tobymao](https://github.com/tobymao))*

### :wrench: Chores
- [`720f634`](https://github.com/tobymao/sqlglot/commit/720f6343f6144e8986ec6b7e50419c3d7a331f0a) - Fix style on main, refactor exasol tests *(PR [#5527](https://github.com/tobymao/sqlglot/pull/5527) by [@VaggelisD](https://github.com/VaggelisD))*
- [`5653501`](https://github.com/tobymao/sqlglot/commit/5653501606f041282b6315c3efa33b9a3baf8d98) - Refactor PR 5517 *(PR [#5526](https://github.com/tobymao/sqlglot/pull/5526) by [@VaggelisD](https://github.com/VaggelisD))*
- [`d15dfe3`](https://github.com/tobymao/sqlglot/commit/d15dfe3f0f4444e4999ad65051b2474e62f422b3) - build type using dialect for bigquery *(PR [#5539](https://github.com/tobymao/sqlglot/pull/5539) by [@geooo109](https://github.com/geooo109))*
- [`173e442`](https://github.com/tobymao/sqlglot/commit/173e4425b692728abffa8542324690823f984303) - refactor JSON_VALUE handling for MySQL and Trino *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`4c04c0c`](https://github.com/tobymao/sqlglot/commit/4c04c0ce859ab8314ed36fb8779f14c0fc2f1094) - use a valid SPDX identifier as license classifier *(PR [#5606](https://github.com/tobymao/sqlglot/pull/5606) by [@ecederstrand](https://github.com/ecederstrand))*
- [`249f638`](https://github.com/tobymao/sqlglot/commit/249f638877ddd2a1732d1e6bc859793f3bc0622d) - add table to document dialect support level *(PR [#5628](https://github.com/tobymao/sqlglot/pull/5628) by [@georgesittas](https://github.com/georgesittas))*
- [`3357125`](https://github.com/tobymao/sqlglot/commit/33571250d172d64a3e0450738b3ad330e5c0a795) - **doris**: refactor unique key prop generation *(PR [#5625](https://github.com/tobymao/sqlglot/pull/5625) by [@georgesittas](https://github.com/georgesittas))*
- [`545f1ac`](https://github.com/tobymao/sqlglot/commit/545f1acd76bdc4e537209266984137f6c69ce622) - Clean up of PR5614 *(PR [#5648](https://github.com/tobymao/sqlglot/pull/5648) by [@VaggelisD](https://github.com/VaggelisD))*
- [`41521e3`](https://github.com/tobymao/sqlglot/commit/41521e31b465acd51ab02b1ac4e5512b98175b7e) - bump sqlglotrs to 0.6.2 *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`b77d3da`](https://github.com/tobymao/sqlglot/commit/b77d3da8f2548858d2b9d8590fcde83e1ec62b8a) - remove `"EXCLUDE" -> TokenType.EXCEPT` in DuckDB, Snowflake *(PR [#5766](https://github.com/tobymao/sqlglot/pull/5766) by [@treysp](https://github.com/treysp))*
- [`005564a`](https://github.com/tobymao/sqlglot/commit/005564ab28cb14be469f09e89b01275d6e25874e) - **snowflake**: refactor logic related to ALTER SESSION *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`164fec1`](https://github.com/tobymao/sqlglot/commit/164fec1b36e3c7df41e2e5a5ad6b226fc5f76305) - **optimizer**: test type annotation for snowflake CHARINDEX function *(PR [#5805](https://github.com/tobymao/sqlglot/pull/5805) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`b244f30`](https://github.com/tobymao/sqlglot/commit/b244f30524846bd08d03a73410ae9b4674254ecd) - move `exp.Contains` to `BOOLEAN` entry in `TYPE_TO_EXPRESSIONS` *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`e8974e7`](https://github.com/tobymao/sqlglot/commit/e8974e70d9956ce7a5cb119ba465660f5f172a17) - **optimizer**: Add tests for snowflake likeall, likeany and ilikeany functions *(PR [#5908](https://github.com/tobymao/sqlglot/pull/5908) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`837890c`](https://github.com/tobymao/sqlglot/commit/837890c7e8bcc3695541bbe32fd8088eee70fea3) - handle badly formed binary expressions gracefully in type inference *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`c18aaf8`](https://github.com/tobymao/sqlglot/commit/c18aaf80fd7375e89dfc8863da619d84f3257353) - cleanup *(commit by [@tobymao](https://github.com/tobymao))*
- [`1514bc6`](https://github.com/tobymao/sqlglot/commit/1514bc640ec129a96aedd9e89bfd5d61e832d6b1) - **optimizer**: add type inference tests for Snowflake RPAD function *(PR [#5967](https://github.com/tobymao/sqlglot/pull/5967) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`050b89d`](https://github.com/tobymao/sqlglot/commit/050b89deb9be842f2ddd07c78ea201ec4eae4779) - **optimizer**: Annotate type for snowflake regexp function *(PR [#5970](https://github.com/tobymao/sqlglot/pull/5970) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`345c6a1`](https://github.com/tobymao/sqlglot/commit/345c6a153481a22d6df1b12ef1863e2133688fdf) - add uv support to Makefile *(PR [#5973](https://github.com/tobymao/sqlglot/pull/5973) by [@eakmanrq](https://github.com/eakmanrq))*
- [`1b1c6f8`](https://github.com/tobymao/sqlglot/commit/1b1c6f8d418371d49f0d3511baf3c5e35dd3ef42) - coerce type for EXTRACT canonicalization *(PR [#5998](https://github.com/tobymao/sqlglot/pull/5998) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *addresses issue [#5996](https://github.com/tobymao/sqlglot/issues/5996) opened by [@snovik75](https://github.com/snovik75)*
- [`f00ae73`](https://github.com/tobymao/sqlglot/commit/f00ae735c8f185b4c6c132373c9fa9bbe58e37b7) - **optimizer**: Annotate type for sqrt function *(PR [#6003](https://github.com/tobymao/sqlglot/pull/6003) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`ac97f14`](https://github.com/tobymao/sqlglot/commit/ac97f14ee1a576a276018f6c9ae1237ecf9ceda7) - simplify `SEARCH` Snowflake instantiation *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`5dd2ed3`](https://github.com/tobymao/sqlglot/commit/5dd2ed3c69cf9e8c3e327297e0cc932f0954e108) - bump sqlglotrs to 0.7.0 *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`7ac01c2`](https://github.com/tobymao/sqlglot/commit/7ac01c2ae9bc4375efb63c60e3221e85088fdd1f) - bump sqlglotrs to 0.7.1 *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`9ab3a96`](https://github.com/tobymao/sqlglot/commit/9ab3a96a853639224c80a9daff4674187a1a84ef) - bump sqlglotrs to 0.7.2 *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`15030a3`](https://github.com/tobymao/sqlglot/commit/15030a3996d005d79f27408a68d17f94c98aec68) - **optimizer**: Add tests for snowflake LN and LOG functions *(PR [#6048](https://github.com/tobymao/sqlglot/pull/6048) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`2ae8dbd`](https://github.com/tobymao/sqlglot/commit/2ae8dbd4d1b43bb27647144c32b2a781ff3edbeb) - push docs to `api-docs` branch instead of main *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`75b8d16`](https://github.com/tobymao/sqlglot/commit/75b8d16e41b677ea7e150c89d713795073aae6e3) - remove docs from main branch *(PR [#6057](https://github.com/tobymao/sqlglot/pull/6057) by [@georgesittas](https://github.com/georgesittas))*
- [`cfa2493`](https://github.com/tobymao/sqlglot/commit/cfa249328eef31ab0e0688dcc03521da3343ce47) - **optimizer**: Annotate type for snowflake SQUARE function *(PR [#6059](https://github.com/tobymao/sqlglot/pull/6059) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`e26c394`](https://github.com/tobymao/sqlglot/commit/e26c3949beb7f73020fcd099237dbe31a4db8d84) - **optimizer**: Annotate type for snowflake POW function *(PR [#6058](https://github.com/tobymao/sqlglot/pull/6058) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`7d303ad`](https://github.com/tobymao/sqlglot/commit/7d303adc5efe9d51eb62aeab80bfa4f844e1911d) - include Python 3.14 in the testing matrix *(PR [#6074](https://github.com/tobymao/sqlglot/pull/6074) by [@georgesittas](https://github.com/georgesittas))*
- [`dab2a3f`](https://github.com/tobymao/sqlglot/commit/dab2a3fbdb8a523f05319eb34a1fd34534272206) - bump sqlglotrs version to 0.7.3 *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`d36ba87`](https://github.com/tobymao/sqlglot/commit/d36ba8774a2a4b53c122e3b78086ce0f09e77244) - **optimizer**: add tests for Snowflake DATE_FROM_PARTS function *(PR [#6077](https://github.com/tobymao/sqlglot/pull/6077) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`2bc05cf`](https://github.com/tobymao/sqlglot/commit/2bc05cf3bd53b874a1505c747e38f8a6a1dbf8c7) - **optimizer**: add tests for Snowflake DATEDIFF function *(PR [#6090](https://github.com/tobymao/sqlglot/pull/6090) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`a4d07a0`](https://github.com/tobymao/sqlglot/commit/a4d07a07eefbdaf88d30df2310a9533afdc75a82) - **optimizer**: Annotate type for snowflake EXTRACT function *(PR [#6099](https://github.com/tobymao/sqlglot/pull/6099) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`ab1da2e`](https://github.com/tobymao/sqlglot/commit/ab1da2e54a83e29d708047d4b3f8abcc1094229d) - **optimizer**: add type annotation tests for snowflake LAST_DAY function *(PR [#6105](https://github.com/tobymao/sqlglot/pull/6105) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`4e24c0a`](https://github.com/tobymao/sqlglot/commit/4e24c0ad92e7071a1f1537886173e29999b46f72) - **optimizer**: add type annotation tests for snowflake TIMESTAMPDIFF function *(PR [#6138](https://github.com/tobymao/sqlglot/pull/6138) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`ae8571f`](https://github.com/tobymao/sqlglot/commit/ae8571fdec71587188e45fe087e1967f5ba641bc) - **optimizer**: add type annotation tests for snowflake TIMEDIFF *(PR [#6140](https://github.com/tobymao/sqlglot/pull/6140) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`3059320`](https://github.com/tobymao/sqlglot/commit/30593202b30001933f05747937975013754b75fa) - copy by default in `lineage` *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`99949cc`](https://github.com/tobymao/sqlglot/commit/99949ccd3ff81b524edeae437d874b86250dbb5b) - avoid needlessly copying in lineage *(PR [#6150](https://github.com/tobymao/sqlglot/pull/6150) by [@georgesittas](https://github.com/georgesittas))*
- [`e7756d8`](https://github.com/tobymao/sqlglot/commit/e7756d8e9f347bfba3f861463890bf57e532cc54) - **optimizer**: add annotation tests for snowflake's BOOLXOR *(PR [#6154](https://github.com/tobymao/sqlglot/pull/6154) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`72e43e3`](https://github.com/tobymao/sqlglot/commit/72e43e3ea08f9dce5a32654060a56f2ee31bea8f) - **optimizer**: add type annotation tests for snowflake's TIMESTAMPADD function *(PR [#6146](https://github.com/tobymao/sqlglot/pull/6146) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`aca106c`](https://github.com/tobymao/sqlglot/commit/aca106c660b8aaf229065ec5c5a4a80d10e8daf6) - **optimizer**: add type annotation tests for snowflake GREATEST *(PR [#6157](https://github.com/tobymao/sqlglot/pull/6157) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`f763604`](https://github.com/tobymao/sqlglot/commit/f7636041d7b796545ed923ffd4803521f05fa7ea) - add `IS [NOT]` tests *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`1ab5854`](https://github.com/tobymao/sqlglot/commit/1ab5854216da591e6036ac103239ac0280e09c3d) - **optimizer**: add snowflake test for [NOT] IN *(PR [#6180](https://github.com/tobymao/sqlglot/pull/6180) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`64939ce`](https://github.com/tobymao/sqlglot/commit/64939ce9926f4740387a151311e918e807bfa681) - **optimizer**: add annotation tests for ZEROIFNULL *(PR [#6187](https://github.com/tobymao/sqlglot/pull/6187) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`4b6bcdd`](https://github.com/tobymao/sqlglot/commit/4b6bcdd4dc297bd42ad000ffda98d14110565dc9) - **optimizer**: Add tests for snowflake's `NULLIFZERO` *(PR [#6197](https://github.com/tobymao/sqlglot/pull/6197) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`ef68075`](https://github.com/tobymao/sqlglot/commit/ef680756c33da180ed2f21fb6113a0123db341c9) - **optimizer**: add annotation tests for NVL2 *(PR [#6208](https://github.com/tobymao/sqlglot/pull/6208) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`7f550f2`](https://github.com/tobymao/sqlglot/commit/7f550f22da40d8c1cfc8afb183d6e4dbd50241ea) - **optimizer**: add annotation tests for NVL *(PR [#6207](https://github.com/tobymao/sqlglot/pull/6207) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`d7be4a5`](https://github.com/tobymao/sqlglot/commit/d7be4a5da3dca6bcc44230b2a176c8b17b81c46e) - **optimizer**: add annotation test for COALESCE *(PR [#6210](https://github.com/tobymao/sqlglot/pull/6210) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`8aa7356`](https://github.com/tobymao/sqlglot/commit/8aa7356ab8adee26193086754ca1a1805957d944) - **optimizer**: add annotation tests for IFF *(PR [#6215](https://github.com/tobymao/sqlglot/pull/6215) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`160a1b9`](https://github.com/tobymao/sqlglot/commit/160a1b90f4ce39a2fce6f7f0e9e854d974fed053) - **optimizer**: mixed type annotation test for sf IFNULL *(commit by [@geooo109](https://github.com/geooo109))*
- [`893ad2a`](https://github.com/tobymao/sqlglot/commit/893ad2a5b1a28339ccc65c85ac813506e6ad56f1) - **optimizer**: add annotation tests for NULLIF *(PR [#6221](https://github.com/tobymao/sqlglot/pull/6221) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`78d7733`](https://github.com/tobymao/sqlglot/commit/78d77335819d1796fa3989ef072d3f8fd4b83559) - remove redundant or term for unknown in annotate_types *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`b202f3a`](https://github.com/tobymao/sqlglot/commit/b202f3ad64e88a47e52c45e32c9e4faae6c8ac45) - **optimizer**: add test for BITXOR *(PR [#6223](https://github.com/tobymao/sqlglot/pull/6223) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`b20f2e8`](https://github.com/tobymao/sqlglot/commit/b20f2e88d86038f1a98f4b97b5a2ae0b86652e33) - **optimizer**: add test for BITSHIFTLEFT *(PR [#6227](https://github.com/tobymao/sqlglot/pull/6227) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`7f93e85`](https://github.com/tobymao/sqlglot/commit/7f93e8551b00cc32014236a07c8794bd7a3a2b91) - **optimizer**: add annotation tests for BITSHIFTRIGHT *(PR [#6228](https://github.com/tobymao/sqlglot/pull/6228) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`fcf017c`](https://github.com/tobymao/sqlglot/commit/fcf017cfb95923fea8ae5669340713a326f4f306) - rename `EXPRESSION_SPEC` to `EXPRESSION_METADATA` *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`55bc9e4`](https://github.com/tobymao/sqlglot/commit/55bc9e4019f8ef8d7e571256d7b0e07b30d9240c) - remove predicate/connector/not from typing metadata *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`349ab29`](https://github.com/tobymao/sqlglot/commit/349ab29aa84fb087388b6a1494fea70273a4a560) - **optimizer**: add annotation test for BOOLAND_OR *(PR [#6260](https://github.com/tobymao/sqlglot/pull/6260) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`75ec424`](https://github.com/tobymao/sqlglot/commit/75ec424667b95462bb1750a251a5096da0d5161b) - **optimizer**: add annotation test for BOOLAND_AGG *(PR [#6257](https://github.com/tobymao/sqlglot/pull/6257) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`bb574aa`](https://github.com/tobymao/sqlglot/commit/bb574aa0cf0a8c0b92f9af7ef3dfddb7de725a8b) - **optimizer**: add annotation test for ARRAY_AGG *(PR [#6264](https://github.com/tobymao/sqlglot/pull/6264) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`a95c5cc`](https://github.com/tobymao/sqlglot/commit/a95c5ccf411dc4d28ef9c19fb03bd8a3615d7c4b) - **optimizer**: add nonnull clickhouse column test case *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`6d6c689`](https://github.com/tobymao/sqlglot/commit/6d6c68915ca699da7cb707675aece963df97f80b) - **optimizer**: add annotation tests for ANY_VALUE *(PR [#6275](https://github.com/tobymao/sqlglot/pull/6275) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`2459f88`](https://github.com/tobymao/sqlglot/commit/2459f8832ae398aa1381025724a4286f7f5e3e9d) - Follow up of 6280 *(PR [#6281](https://github.com/tobymao/sqlglot/pull/6281) by [@VaggelisD](https://github.com/VaggelisD))*
- [`a7d33d0`](https://github.com/tobymao/sqlglot/commit/a7d33d0e190fc5c9f23a1ab43082ac017d20fd18) - **optimizer**: add annotation tests for APPROX_PERCENTILE *(PR [#6283](https://github.com/tobymao/sqlglot/pull/6283) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`1b2d139`](https://github.com/tobymao/sqlglot/commit/1b2d139d3338c7053dee333914323236a2d15d97) - **optimizer**: add type annotation tests with window for sf APPROX_PERCENTILE *(commit by [@geooo109](https://github.com/geooo109))*
- [`d059648`](https://github.com/tobymao/sqlglot/commit/d05964851c99553ba06e318bbbda39f9851120db) - **optimizer**: add annotation tests for APPROX_COUNT_DISTINCT *(PR [#6282](https://github.com/tobymao/sqlglot/pull/6282) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`6bd59ac`](https://github.com/tobymao/sqlglot/commit/6bd59acf2288da5bfe6151c5adf6f2a63792dc1e) - Follow up of PR 6288 *(PR [#6293](https://github.com/tobymao/sqlglot/pull/6293) by [@VaggelisD](https://github.com/VaggelisD))*
- [`546fd2a`](https://github.com/tobymao/sqlglot/commit/546fd2a2588f7b385bdbb9e39490bd6a422283ca) - Remove dead line in qualify_columns *(PR [#6304](https://github.com/tobymao/sqlglot/pull/6304) by [@VaggelisD](https://github.com/VaggelisD))*
- [`ac7ac19`](https://github.com/tobymao/sqlglot/commit/ac7ac198a3b915e63ba8a055e9a0193c3dd3e26a) - **exasol**: Implement ODBC date time literals in Exasol Sqlglot *(PR [#6311](https://github.com/tobymao/sqlglot/pull/6311) by [@nnamdi16](https://github.com/nnamdi16))*
- [`8d1d25c`](https://github.com/tobymao/sqlglot/commit/8d1d25c6de7ad03c50e3efe892d16d16329d8ee9) - **exasol**: Implement local qualifier for-aliases, in GROUP BY, WHERE AND HAVING clause in exasol dialect *(PR [#6277](https://github.com/tobymao/sqlglot/pull/6277) by [@nnamdi16](https://github.com/nnamdi16))*
- [`509b0aa`](https://github.com/tobymao/sqlglot/commit/509b0aaada0e27542864771ba14777d398b6cee0) - **exasol**: Implement day_of_week function *(PR [#6319](https://github.com/tobymao/sqlglot/pull/6319) by [@nnamdi16](https://github.com/nnamdi16))*
- [`487d218`](https://github.com/tobymao/sqlglot/commit/487d218a6fcad4e28c65c6df55435ba218826186) - iterative annotate types *(PR [#6342](https://github.com/tobymao/sqlglot/pull/6342) by [@geooo109](https://github.com/geooo109))*
- [`8201062`](https://github.com/tobymao/sqlglot/commit/8201062ac41b85e5a89aa8e1c5973852f105c66e) - clean up derived table traversal in table qualification *(PR [#6363](https://github.com/tobymao/sqlglot/pull/6363) by [@georgesittas](https://github.com/georgesittas))*
- [`6b7084d`](https://github.com/tobymao/sqlglot/commit/6b7084d0c9f4735432afc12509c77c286cc50513) - **optimizer**: refactor costly scope walking loop in qualify tables *(PR [#6364](https://github.com/tobymao/sqlglot/pull/6364) by [@georgesittas](https://github.com/georgesittas))*
- [`0319241`](https://github.com/tobymao/sqlglot/commit/0319241162bbe6d278a626100eac73999b250968) - **mysql,postgres**: tests for unsupported IGNORE/RESPECT NULLS *(PR [#6386](https://github.com/tobymao/sqlglot/pull/6386) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *addresses issue [#6376](https://github.com/tobymao/sqlglot/issues/6376) opened by [@NickCrews](https://github.com/NickCrews)*
- [`11354cc`](https://github.com/tobymao/sqlglot/commit/11354cc85d116cd24c28114a437111965ba828a9) - Make integration test workflow more robust *(PR [#6403](https://github.com/tobymao/sqlglot/pull/6403) by [@erindru](https://github.com/erindru))*
- [`f758cea`](https://github.com/tobymao/sqlglot/commit/f758cea0e9fca5850895a730c554c17b488d29ca) - **exasol**: transformed rank function, ignoring parameters *(PR [#6408](https://github.com/tobymao/sqlglot/pull/6408) by [@nnamdi16](https://github.com/nnamdi16))*
- [`07d9958`](https://github.com/tobymao/sqlglot/commit/07d99583b4aebdc682bb7604ccdf45bddb89f9c3) - **optimizer**: replace direct comparison with dialect properties *(PR [#6398](https://github.com/tobymao/sqlglot/pull/6398) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`137549e`](https://github.com/tobymao/sqlglot/commit/137549e5e803416d46e13e9a8123cef9b53d349a) - **exasol**: transform substring_index using substr and instr *(PR [#6406](https://github.com/tobymao/sqlglot/pull/6406) by [@nnamdi16](https://github.com/nnamdi16))*
- [`78f1824`](https://github.com/tobymao/sqlglot/commit/78f1824c790f523845cbda488ecf4c43a92ac0f0) - **exasol**: transform substring_index using substr and instr *(PR [#6406](https://github.com/tobymao/sqlglot/pull/6406) by [@nnamdi16](https://github.com/nnamdi16))*
- [`39cc555`](https://github.com/tobymao/sqlglot/commit/39cc55586ed76a4a583e6db22a9ee51e09bff92e) - **snowflake**: annotate type for COUNT *(PR [#6437](https://github.com/tobymao/sqlglot/pull/6437) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`61f39ba`](https://github.com/tobymao/sqlglot/commit/61f39bab9a0668c338e8c1b5e0fa953f22c0a886) - **optimizer**: improve error message for ambiguous columns *(PR [#6423](https://github.com/tobymao/sqlglot/pull/6423) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`313afe5`](https://github.com/tobymao/sqlglot/commit/313afe540aa2cdc4cc179c4852c6ef37362bcb3e) - **optimizer**: annotate type for snowflake func ARRAY_UNION_AGG *(PR [#6446](https://github.com/tobymao/sqlglot/pull/6446) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`b321ca6`](https://github.com/tobymao/sqlglot/commit/b321ca6191fefc88da1a6de83a465886b5754b7a) - bump sqlglotrs to 0.8.0 *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`4a061e2`](https://github.com/tobymao/sqlglot/commit/4a061e26b638c9acb0c8a77d9347914b35082bb3) - **optimizer**: Include BIGDECIMAL in numeric precedence *(PR [#6456](https://github.com/tobymao/sqlglot/pull/6456) by [@vchan](https://github.com/vchan))*
- [`f305305`](https://github.com/tobymao/sqlglot/commit/f305305e5cf3ef45afba822542aebeb944c00e0b) - **optimizer**: Annotate types for BigQuery's AVG function *(PR [#6459](https://github.com/tobymao/sqlglot/pull/6459) by [@vchan](https://github.com/vchan))*
- [`910349f`](https://github.com/tobymao/sqlglot/commit/910349f3c30af59ce1820e48cae0cbb77539877d) - **optimizer**: Annotate types for BigQuery's SAFE_DIVIDE function *(PR [#6464](https://github.com/tobymao/sqlglot/pull/6464) by [@vchan](https://github.com/vchan))*
- [`5e75621`](https://github.com/tobymao/sqlglot/commit/5e75621e90defd50076383485f6a4689a8c551ac) - **optimizer**: annotate type for snowflake func ARRAY_UNIQUE_AGG *(PR [#6465](https://github.com/tobymao/sqlglot/pull/6465) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`4d77500`](https://github.com/tobymao/sqlglot/commit/4d775007d2ceb997ff33721def768493c95f98a5) - **optimizer**: add tests for snowflake CAST function *(PR [#6471](https://github.com/tobymao/sqlglot/pull/6471) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`88dfd26`](https://github.com/tobymao/sqlglot/commit/88dfd26b832d13e517fe7c18d2c086885bf4954d) - **optimizer**: annotate type for snowflake func TO_BINARY *(PR [#6474](https://github.com/tobymao/sqlglot/pull/6474) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`483318b`](https://github.com/tobymao/sqlglot/commit/483318bc25e4ee4fa2731be1a0aea02858872ab5) - clean up TO_BINARY tests *(commit by [@geooo109](https://github.com/geooo109))*
- [`bff7084`](https://github.com/tobymao/sqlglot/commit/bff70841d0bfbede6ea0fae2e7b37d68735a53d8) - remove duckdb TO_BINARY 2 arg test *(commit by [@geooo109](https://github.com/geooo109))*
- [`80591f9`](https://github.com/tobymao/sqlglot/commit/80591f9513dff9160884e4bbbd48d9c26cf8f253) - starrocks TO_BINARY tests *(commit by [@geooo109](https://github.com/geooo109))*
- [`01e5a05`](https://github.com/tobymao/sqlglot/commit/01e5a050c76f728ef542f0127209e2cd1c5f5558) - **exasol**: implementing the last day function in exasol sql dialect *(PR [#6483](https://github.com/tobymao/sqlglot/pull/6483) by [@nnamdi16](https://github.com/nnamdi16))*
- [`aacc981`](https://github.com/tobymao/sqlglot/commit/aacc98105fb381c17a80ee011f107157279312d7) - **duckdb**: tests for MAX_BY and MIN_BY *(PR [#6489](https://github.com/tobymao/sqlglot/pull/6489) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`06c7ffb`](https://github.com/tobymao/sqlglot/commit/06c7ffbe14985a4da35a97d47322021e79525adf) - cleanup bitwise operator fixes *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`edb8964`](https://github.com/tobymao/sqlglot/commit/edb8964ed064a687e52323143d52281eaa391c9a) - bump sqlglotrs to 0.9.0 *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`0211328`](https://github.com/tobymao/sqlglot/commit/021132821fb33620643295533ce1517a172e7dc6) - add test-fast and test-fast-rs Makefile targets *(PR [#6546](https://github.com/tobymao/sqlglot/pull/6546) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`60b00bc`](https://github.com/tobymao/sqlglot/commit/60b00bc4d462c5ac03410a804305ad57ed6fbfbb) - Refactor PR 6555 *(PR [#6569](https://github.com/tobymao/sqlglot/pull/6569) by [@VaggelisD](https://github.com/VaggelisD))*


## [v28.3.0] - 2025-12-11
### :boom: BREAKING CHANGES
- due to [`62b348c`](https://github.com/tobymao/sqlglot/commit/62b348ce46d014895bd17d89ccb0b3e186e46d15) - add support for noop string escapes *(PR [#6526](https://github.com/tobymao/sqlglot/pull/6526) by [@nian0114](https://github.com/nian0114))*:

  add support for noop string escapes (#6526)

- due to [`1876c5a`](https://github.com/tobymao/sqlglot/commit/1876c5a86c3b737b7360c4fef25c44dc010b66db) - consolidate can_quote logic and fix an issue with identify=False *(PR [#6534](https://github.com/tobymao/sqlglot/pull/6534) by [@tobymao](https://github.com/tobymao))*:

  consolidate can_quote logic and fix an issue with identify=False (#6534)

- due to [`edb8964`](https://github.com/tobymao/sqlglot/commit/edb8964ed064a687e52323143d52281eaa391c9a) - bump sqlglotrs to 0.9.0 *(commit by [@georgesittas](https://github.com/georgesittas))*:

  bump sqlglotrs to 0.9.0


### :bug: Bug Fixes
- [`62b348c`](https://github.com/tobymao/sqlglot/commit/62b348ce46d014895bd17d89ccb0b3e186e46d15) - **tokenizer**: add support for noop string escapes *(PR [#6526](https://github.com/tobymao/sqlglot/pull/6526) by [@nian0114](https://github.com/nian0114))*

### :recycle: Refactors
- [`1876c5a`](https://github.com/tobymao/sqlglot/commit/1876c5a86c3b737b7360c4fef25c44dc010b66db) - consolidate can_quote logic and fix an issue with identify=False *(PR [#6534](https://github.com/tobymao/sqlglot/pull/6534) by [@tobymao](https://github.com/tobymao))*

### :wrench: Chores
- [`edb8964`](https://github.com/tobymao/sqlglot/commit/edb8964ed064a687e52323143d52281eaa391c9a) - bump sqlglotrs to 0.9.0 *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v28.2.0] - 2025-12-11
### :boom: BREAKING CHANGES
- due to [`ebe718a`](https://github.com/tobymao/sqlglot/commit/ebe718a72d5b5871a8d6e67754ff50e873d55b41) - Add support for format elements used in date/time functions like FORMAT_DATETIME *(PR [#6428](https://github.com/tobymao/sqlglot/pull/6428) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Add support for format elements used in date/time functions like FORMAT_DATETIME (#6428)

- due to [`c111f64`](https://github.com/tobymao/sqlglot/commit/c111f643d61064280024b4cc5c0fc250581fbe55) - annotation support for APPROX_PERCENTILE_ACCUMULATE *(PR [#6455](https://github.com/tobymao/sqlglot/pull/6455) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for APPROX_PERCENTILE_ACCUMULATE (#6455)

- due to [`f305305`](https://github.com/tobymao/sqlglot/commit/f305305e5cf3ef45afba822542aebeb944c00e0b) - Annotate types for BigQuery's AVG function *(PR [#6459](https://github.com/tobymao/sqlglot/pull/6459) by [@vchan](https://github.com/vchan))*:

  Annotate types for BigQuery's AVG function (#6459)

- due to [`910349f`](https://github.com/tobymao/sqlglot/commit/910349f3c30af59ce1820e48cae0cbb77539877d) - Annotate types for BigQuery's SAFE_DIVIDE function *(PR [#6464](https://github.com/tobymao/sqlglot/pull/6464) by [@vchan](https://github.com/vchan))*:

  Annotate types for BigQuery's SAFE_DIVIDE function (#6464)

- due to [`5e75621`](https://github.com/tobymao/sqlglot/commit/5e75621e90defd50076383485f6a4689a8c551ac) - annotate type for snowflake func ARRAY_UNIQUE_AGG *(PR [#6465](https://github.com/tobymao/sqlglot/pull/6465) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for snowflake func ARRAY_UNIQUE_AGG (#6465)

- due to [`94d46b8`](https://github.com/tobymao/sqlglot/commit/94d46b8eafd5abe252407d2bbe306ca579a29b20) - annotation support for APPROX_PERCENTILE_ESTIMATE. Return type DOUBLE *(PR [#6461](https://github.com/tobymao/sqlglot/pull/6461) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for APPROX_PERCENTILE_ESTIMATE. Return type DOUBLE (#6461)

- due to [`2ac30b0`](https://github.com/tobymao/sqlglot/commit/2ac30b08bd663bbaf00ae075c4db0c3d27ab6640) - annotation support for APPROX_PERCENTILE_COMBINE *(PR [#6460](https://github.com/tobymao/sqlglot/pull/6460) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for APPROX_PERCENTILE_COMBINE (#6460)

- due to [`d44bda3`](https://github.com/tobymao/sqlglot/commit/d44bda376c06956947a09a9f279cce886a63b981) - Annotate type for ZIPF *(PR [#6453](https://github.com/tobymao/sqlglot/pull/6453) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for ZIPF (#6453)

- due to [`34dbd47`](https://github.com/tobymao/sqlglot/commit/34dbd478957c1796998d0b263f63c8ce1db7a320) - Annotate type for XMLGET *(PR [#6457](https://github.com/tobymao/sqlglot/pull/6457) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for XMLGET (#6457)

- due to [`0d211f2`](https://github.com/tobymao/sqlglot/commit/0d211f2b36167cfb7856b8ec25f597f70317a9c7) - annotate type for MODE function snowflake *(PR [#6447](https://github.com/tobymao/sqlglot/pull/6447) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate type for MODE function snowflake (#6447)

- due to [`cc4c8ab`](https://github.com/tobymao/sqlglot/commit/cc4c8ab43ab71790bc2bb9f8f3c06e34f89f999f) - annotate type for PERCENTILE_CONT in Snowflake *(PR [#6470](https://github.com/tobymao/sqlglot/pull/6470) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate type for PERCENTILE_CONT in Snowflake (#6470)

- due to [`7dbc242`](https://github.com/tobymao/sqlglot/commit/7dbc242a637a8890511cc14f22bce4d425f1f55d) - annotation support for CURRENT REGION. Return type VARCHAR *(PR [#6473](https://github.com/tobymao/sqlglot/pull/6473) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT REGION. Return type VARCHAR (#6473)

- due to [`43a6a5c`](https://github.com/tobymao/sqlglot/commit/43a6a5c601421e15a7f94dd489cb4fbcf9d2c8c3) - annotation support for CURRENT_ORGANIZATION_NAME. Return type VARCHAR *(PR [#6475](https://github.com/tobymao/sqlglot/pull/6475) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_ORGANIZATION_NAME. Return type VARCHAR (#6475)

- due to [`f1f7c6a`](https://github.com/tobymao/sqlglot/commit/f1f7c6ae6b6aa3f6f2251d0f81ee667440ca53d1) - annotation support for CURRENT_ORGANIZATION_USER. *(PR [#6476](https://github.com/tobymao/sqlglot/pull/6476) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_ORGANIZATION_USER. (#6476)

- due to [`88dfd26`](https://github.com/tobymao/sqlglot/commit/88dfd26b832d13e517fe7c18d2c086885bf4954d) - annotate type for snowflake func TO_BINARY *(PR [#6474](https://github.com/tobymao/sqlglot/pull/6474) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for snowflake func TO_BINARY (#6474)

- due to [`d268203`](https://github.com/tobymao/sqlglot/commit/d268203e1dbae4e3aff863108f6d09a6f8274db5) - annotation support for CURRENT_ROLE_TYPE *(PR [#6479](https://github.com/tobymao/sqlglot/pull/6479) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_ROLE_TYPE (#6479)

- due to [`fd4431b`](https://github.com/tobymao/sqlglot/commit/fd4431bf9550c03aa761c642a68a21a146fd8548) - annotate type for VECTOR_L1_DISTANCE, VECTOR_L2_DISTANCE, VECTOR_COSINE_SIMILARITY functions *(PR [#6468](https://github.com/tobymao/sqlglot/pull/6468) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  annotate type for VECTOR_L1_DISTANCE, VECTOR_L2_DISTANCE, VECTOR_COSINE_SIMILARITY functions (#6468)

- due to [`e6adba7`](https://github.com/tobymao/sqlglot/commit/e6adba76cc2f27633a9d38bfaea3356e71d00a4c) - Add support for coercing STRING literals to temporal types *(PR [#6482](https://github.com/tobymao/sqlglot/pull/6482) by [@vchan](https://github.com/vchan))*:

  Add support for coercing STRING literals to temporal types (#6482)

- due to [`68a5e61`](https://github.com/tobymao/sqlglot/commit/68a5e615b24e518cb90c9b80cf25355fcabdb468) - annotate type for REGR_* functions *(PR [#6452](https://github.com/tobymao/sqlglot/pull/6452) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  annotate type for REGR_* functions (#6452)

- due to [`f7458a4`](https://github.com/tobymao/sqlglot/commit/f7458a40d3b09a2e212f6705ac4a77c99714508e) - annotate type for snowflake func TO_BOOLEAN *(PR [#6481](https://github.com/tobymao/sqlglot/pull/6481) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for snowflake func TO_BOOLEAN (#6481)

- due to [`1531a67`](https://github.com/tobymao/sqlglot/commit/1531a67ac7806f3b4582f6cf1ea02342a517de74) - annotate type for VECTOR_INNER_PRODUCT *(PR [#6486](https://github.com/tobymao/sqlglot/pull/6486) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  annotate type for VECTOR_INNER_PRODUCT (#6486)

- due to [`df4c1d3`](https://github.com/tobymao/sqlglot/commit/df4c1d37ff77151a74b5de3d119c7e03f5db85f4) - REGEXP_EXTRACT position arg overflow *(PR [#6458](https://github.com/tobymao/sqlglot/pull/6458) by [@treysp](https://github.com/treysp))*:

  REGEXP_EXTRACT position arg overflow (#6458)

- due to [`f6b2b3b`](https://github.com/tobymao/sqlglot/commit/f6b2b3bc6e1c95340149be65d80ef7e177b28d82) - support padside argument for BIT[OR|AND|XOR] *(PR [#6487](https://github.com/tobymao/sqlglot/pull/6487) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support padside argument for BIT[OR|AND|XOR] (#6487)

- due to [`5a49c3f`](https://github.com/tobymao/sqlglot/commit/5a49c3f7a7619ad9e711ff2cd9e85b8606969b36) - support ORDER / LIMIT expressions for BigQuery ARRAY_AGG / STRING_AGG functions *(PR [#6463](https://github.com/tobymao/sqlglot/pull/6463) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  support ORDER / LIMIT expressions for BigQuery ARRAY_AGG / STRING_AGG functions (#6463)

- due to [`ef130f1`](https://github.com/tobymao/sqlglot/commit/ef130f1b944b4be835d4a6831fec9a333a825a34) - Annotated type for ARRAY_CONSTRUCT_COMPACT [#6496](https://github.com/tobymao/sqlglot/pull/6496) *(commit by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotated type for ARRAY_CONSTRUCT_COMPACT #6496

- due to [`1b6076b`](https://github.com/tobymao/sqlglot/commit/1b6076bd5a64b044f52f5366244ba0746aca75e1) - wrap connectives generated due to transpiling LIKE ANY closes [#6493](https://github.com/tobymao/sqlglot/pull/6493) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  wrap connectives generated due to transpiling LIKE ANY closes #6493

- due to [`36ad534`](https://github.com/tobymao/sqlglot/commit/36ad534b14eabe9ee197017f5087e8e5190f8526) - qualified select list with "LOCAL" *(PR [#6450](https://github.com/tobymao/sqlglot/pull/6450) by [@nnamdi16](https://github.com/nnamdi16))*:

  qualified select list with "LOCAL" (#6450)

- due to [`36cf0bf`](https://github.com/tobymao/sqlglot/commit/36cf0bf6671f622344afee52d7aafe30f19ecf9a) - annotation support for CURRENT_ROLE. *(PR [#6478](https://github.com/tobymao/sqlglot/pull/6478) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_ROLE. (#6478)

- due to [`cbba04c`](https://github.com/tobymao/sqlglot/commit/cbba04cb292fe8b3fd38c87d9ccb624cdcb52843) - support comma-separated syntax for OVERLAY function *(PR [#6497](https://github.com/tobymao/sqlglot/pull/6497) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  support comma-separated syntax for OVERLAY function (#6497)

- due to [`dc8f26a`](https://github.com/tobymao/sqlglot/commit/dc8f26a3a5e023a0e54caa345b129fb1b4fe805f) - bq annotate type for NULL *(PR [#6491](https://github.com/tobymao/sqlglot/pull/6491) by [@geooo109](https://github.com/geooo109))*:

  bq annotate type for NULL (#6491)

- due to [`52aceaa`](https://github.com/tobymao/sqlglot/commit/52aceaaa887dddb35f8ede5c2d9577fdeee35c48) - annotate `HavingMax` by `this` *(PR [#6499](https://github.com/tobymao/sqlglot/pull/6499) by [@georgesittas](https://github.com/georgesittas))*:

  annotate `HavingMax` by `this` (#6499)

- due to [`c97a81d`](https://github.com/tobymao/sqlglot/commit/c97a81d68a1584fad48475725665a7678fcad9d1) - annotate TO_HEX(MD5(...)) in BigQuery *(PR [#6500](https://github.com/tobymao/sqlglot/pull/6500) by [@georgesittas](https://github.com/georgesittas))*:

  annotate TO_HEX(MD5(...)) in BigQuery (#6500)

- due to [`a5797a1`](https://github.com/tobymao/sqlglot/commit/a5797a1c867c4ade71ae4ddf93232576993cf5bc) - handle named arguments and non-integer scale input for ROUND *(PR [#6495](https://github.com/tobymao/sqlglot/pull/6495) by [@toriwei](https://github.com/toriwei))*:

  handle named arguments and non-integer scale input for ROUND (#6495)

- due to [`3224235`](https://github.com/tobymao/sqlglot/commit/3224235c1b7a80511af11f7dbffe608a747a3df0) - make CTE builder produce AST consistent with parser closes [#6503](https://github.com/tobymao/sqlglot/pull/6503) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  make CTE builder produce AST consistent with parser closes #6503

- due to [`8b5298a`](https://github.com/tobymao/sqlglot/commit/8b5298a6578af80fd9676eb222422862d5468859) - Transpile BQ's WEEK based `DATE_DIFF` *(PR [#6507](https://github.com/tobymao/sqlglot/pull/6507) by [@VaggelisD](https://github.com/VaggelisD))*:

  Transpile BQ's WEEK based `DATE_DIFF` (#6507)

- due to [`9454a18`](https://github.com/tobymao/sqlglot/commit/9454a18cca41a510e61522f6b785d646980e2100) - uppercase join method, side, kind for consistency fixes [#6510](https://github.com/tobymao/sqlglot/pull/6510) *(PR [#6511](https://github.com/tobymao/sqlglot/pull/6511) by [@georgesittas](https://github.com/georgesittas))*:

  uppercase join method, side, kind for consistency fixes #6510 (#6511)

- due to [`41b776b`](https://github.com/tobymao/sqlglot/commit/41b776bdc6936f18accd9f7308b55acd383bb596) - added support for current_catalog *(PR [#6492](https://github.com/tobymao/sqlglot/pull/6492) by [@AbhishekASLK](https://github.com/AbhishekASLK))*:

  added support for current_catalog (#6492)

- due to [`dd19bea`](https://github.com/tobymao/sqlglot/commit/dd19beae95f077cfd8b6e315eca7ff212817b250) - annotation support for CURRENT_ACCOUNT *(PR [#6512](https://github.com/tobymao/sqlglot/pull/6512) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_ACCOUNT (#6512)

- due to [`2e8105e`](https://github.com/tobymao/sqlglot/commit/2e8105eebaec25fc8f94f1e68951198660f404e1) - Annotate type for VAR_POP, VAR_SAMP, DuckDB consistency fix for VAR_SAMP *(PR [#6488](https://github.com/tobymao/sqlglot/pull/6488) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for VAR_POP, VAR_SAMP, DuckDB consistency fix for VAR_SAMP (#6488)

- due to [`cfb02c1`](https://github.com/tobymao/sqlglot/commit/cfb02c1aa676e801b2d13a84467b4904cd834ffe) - annotation support for CURRENT_ACCOUNT_NAME *(PR [#6513](https://github.com/tobymao/sqlglot/pull/6513) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_ACCOUNT_NAME (#6513)

- due to [`1004e31`](https://github.com/tobymao/sqlglot/commit/1004e31cce62cce2e2afb7eab85ed8bdecaede3b) - annotation support for CURRENT_AVAILABLE_ROLES *(PR [#6514](https://github.com/tobymao/sqlglot/pull/6514) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_AVAILABLE_ROLES (#6514)

- due to [`ff201fe`](https://github.com/tobymao/sqlglot/commit/ff201febd27937a97674dd091928456dde733254) - annotation support for CURRENT_CLIENT *(PR [#6515](https://github.com/tobymao/sqlglot/pull/6515) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_CLIENT (#6515)

- due to [`d777a9c`](https://github.com/tobymao/sqlglot/commit/d777a9c0feef15ac036f7b413112de4d7cc8bea4) - annotation support for CURRENT_IP_ADDRESS *(PR [#6518](https://github.com/tobymao/sqlglot/pull/6518) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_IP_ADDRESS (#6518)

- due to [`c296061`](https://github.com/tobymao/sqlglot/commit/c2960615a3bd279b7c5f775d5b93ae12aa27a3b8) - Transpilation of TO_BINARY from snowflake to duckdb *(PR [#6504](https://github.com/tobymao/sqlglot/pull/6504) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  Transpilation of TO_BINARY from snowflake to duckdb (#6504)

- due to [`7a70164`](https://github.com/tobymao/sqlglot/commit/7a70164d8cf361cf4c0a7d5789bb51676f772959) - transpile Snowflake's `RANDSTR` function *(PR [#6502](https://github.com/tobymao/sqlglot/pull/6502) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  transpile Snowflake's `RANDSTR` function (#6502)

- due to [`a26d419`](https://github.com/tobymao/sqlglot/commit/a26d4191e5468e39eafdf7a981e7b890d438b2c9) - annotation support for CURRENT_DATABASE *(PR [#6516](https://github.com/tobymao/sqlglot/pull/6516) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_DATABASE (#6516)

- due to [`0acdf7f`](https://github.com/tobymao/sqlglot/commit/0acdf7fc783f2722536ec24dcf8600957febf7ca) - annotation support for CURRENT_SCHEMAS *(PR [#6519](https://github.com/tobymao/sqlglot/pull/6519) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_SCHEMAS (#6519)

- due to [`43cce89`](https://github.com/tobymao/sqlglot/commit/43cce895da80d21abc89d40de5d7fddd68871bf0) - annotation support for CURRENT_SECONDARY_ROLES *(PR [#6520](https://github.com/tobymao/sqlglot/pull/6520) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_SECONDARY_ROLES (#6520)

- due to [`c21b4b1`](https://github.com/tobymao/sqlglot/commit/c21b4b1134b368ee5144339b59e70ddcc54f3dbc) - annotation support for CURRENT_SESSION *(PR [#6521](https://github.com/tobymao/sqlglot/pull/6521) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_SESSION (#6521)

- due to [`57a83c0`](https://github.com/tobymao/sqlglot/commit/57a83c018dace690f7bb363c25ee6bde33c3d60f) - annotation support for CURRENT_STATEMENT *(PR [#6522](https://github.com/tobymao/sqlglot/pull/6522) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_STATEMENT (#6522)

- due to [`4b240e4`](https://github.com/tobymao/sqlglot/commit/4b240e40a8809a6eea2a279370a884f4a7b03dfa) - annotation support for CURRENT_VERSION *(PR [#6524](https://github.com/tobymao/sqlglot/pull/6524) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_VERSION (#6524)

- due to [`c1a831f`](https://github.com/tobymao/sqlglot/commit/c1a831f5bf662ab8d8e07dc2bb949f2adcbe7d7c) - annotation support for CURRENT_TRANSACTION *(PR [#6523](https://github.com/tobymao/sqlglot/pull/6523) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_TRANSACTION (#6523)

- due to [`2e162b0`](https://github.com/tobymao/sqlglot/commit/2e162b0d34066e7aa7edac3156739bcd31a634fc) - annotation support for CURRENT_WAREHOUSE *(PR [#6525](https://github.com/tobymao/sqlglot/pull/6525) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for CURRENT_WAREHOUSE (#6525)

- due to [`9d06859`](https://github.com/tobymao/sqlglot/commit/9d0685923209c04747fa6fa2b35ee2e516453abc) - annotate bigquery ARRAY when arg contains set operations *(PR [#6517](https://github.com/tobymao/sqlglot/pull/6517) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate bigquery ARRAY when arg contains set operations (#6517)

- due to [`2fd14ed`](https://github.com/tobymao/sqlglot/commit/2fd14ed32b3793444405005fb98342222b4d7956) - query schema directly when type annotation fails for processing UNNEST source *(PR [#6451](https://github.com/tobymao/sqlglot/pull/6451) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  query schema directly when type annotation fails for processing UNNEST source (#6451)

- due to [`41a9e88`](https://github.com/tobymao/sqlglot/commit/41a9e88bb9800205df0b3e10a1976699dc4fe4f9) - Add support to transpile binary args for bitwise operators *(PR [#6508](https://github.com/tobymao/sqlglot/pull/6508) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Add support to transpile binary args for bitwise operators (#6508)

- due to [`06c7ffb`](https://github.com/tobymao/sqlglot/commit/06c7ffbe14985a4da35a97d47322021e79525adf) - cleanup bitwise operator fixes *(commit by [@georgesittas](https://github.com/georgesittas))*:

  cleanup bitwise operator fixes


### :sparkles: New Features
- [`ebe718a`](https://github.com/tobymao/sqlglot/commit/ebe718a72d5b5871a8d6e67754ff50e873d55b41) - **duckdb**: Add support for format elements used in date/time functions like FORMAT_DATETIME *(PR [#6428](https://github.com/tobymao/sqlglot/pull/6428) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`c111f64`](https://github.com/tobymao/sqlglot/commit/c111f643d61064280024b4cc5c0fc250581fbe55) - **snowflake**: annotation support for APPROX_PERCENTILE_ACCUMULATE *(PR [#6455](https://github.com/tobymao/sqlglot/pull/6455) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`a7d211e`](https://github.com/tobymao/sqlglot/commit/a7d211e6fdce968c64b050c77e026cc23fdc07e5) - **duckdb**: transpile DECFLOAT type to DECIMAL(38, 5) *(PR [#6462](https://github.com/tobymao/sqlglot/pull/6462) by [@toriwei](https://github.com/toriwei))*
- [`94d46b8`](https://github.com/tobymao/sqlglot/commit/94d46b8eafd5abe252407d2bbe306ca579a29b20) - **snowflake**: annotation support for APPROX_PERCENTILE_ESTIMATE. Return type DOUBLE *(PR [#6461](https://github.com/tobymao/sqlglot/pull/6461) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`2ac30b0`](https://github.com/tobymao/sqlglot/commit/2ac30b08bd663bbaf00ae075c4db0c3d27ab6640) - **snowflake**: annotation support for APPROX_PERCENTILE_COMBINE *(PR [#6460](https://github.com/tobymao/sqlglot/pull/6460) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`d44bda3`](https://github.com/tobymao/sqlglot/commit/d44bda376c06956947a09a9f279cce886a63b981) - **optimizer**: Annotate type for ZIPF *(PR [#6453](https://github.com/tobymao/sqlglot/pull/6453) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`34dbd47`](https://github.com/tobymao/sqlglot/commit/34dbd478957c1796998d0b263f63c8ce1db7a320) - **optimizer**: Annotate type for XMLGET *(PR [#6457](https://github.com/tobymao/sqlglot/pull/6457) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`ff3f0f9`](https://github.com/tobymao/sqlglot/commit/ff3f0f998674f5b2741c3f6cadbe24fa8fb607ad) - **databricks**: add support for ?:: operator *(PR [#6469](https://github.com/tobymao/sqlglot/pull/6469) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`0d211f2`](https://github.com/tobymao/sqlglot/commit/0d211f2b36167cfb7856b8ec25f597f70317a9c7) - **snowflake**: annotate type for MODE function snowflake *(PR [#6447](https://github.com/tobymao/sqlglot/pull/6447) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`cc4c8ab`](https://github.com/tobymao/sqlglot/commit/cc4c8ab43ab71790bc2bb9f8f3c06e34f89f999f) - **snowflake**: annotate type for PERCENTILE_CONT in Snowflake *(PR [#6470](https://github.com/tobymao/sqlglot/pull/6470) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`7dbc242`](https://github.com/tobymao/sqlglot/commit/7dbc242a637a8890511cc14f22bce4d425f1f55d) - **snowflake**: annotation support for CURRENT REGION. Return type VARCHAR *(PR [#6473](https://github.com/tobymao/sqlglot/pull/6473) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`43a6a5c`](https://github.com/tobymao/sqlglot/commit/43a6a5c601421e15a7f94dd489cb4fbcf9d2c8c3) - **snowflake**: annotation support for CURRENT_ORGANIZATION_NAME. Return type VARCHAR *(PR [#6475](https://github.com/tobymao/sqlglot/pull/6475) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`f1f7c6a`](https://github.com/tobymao/sqlglot/commit/f1f7c6ae6b6aa3f6f2251d0f81ee667440ca53d1) - **snowflake**: annotation support for CURRENT_ORGANIZATION_USER. *(PR [#6476](https://github.com/tobymao/sqlglot/pull/6476) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`d268203`](https://github.com/tobymao/sqlglot/commit/d268203e1dbae4e3aff863108f6d09a6f8274db5) - **snowflake**: annotation support for CURRENT_ROLE_TYPE *(PR [#6479](https://github.com/tobymao/sqlglot/pull/6479) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`fd4431b`](https://github.com/tobymao/sqlglot/commit/fd4431bf9550c03aa761c642a68a21a146fd8548) - **snowflake**: annotate type for VECTOR_L1_DISTANCE, VECTOR_L2_DISTANCE, VECTOR_COSINE_SIMILARITY functions *(PR [#6468](https://github.com/tobymao/sqlglot/pull/6468) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`e6adba7`](https://github.com/tobymao/sqlglot/commit/e6adba76cc2f27633a9d38bfaea3356e71d00a4c) - **BigQuery**: Add support for coercing STRING literals to temporal types *(PR [#6482](https://github.com/tobymao/sqlglot/pull/6482) by [@vchan](https://github.com/vchan))*
- [`68a5e61`](https://github.com/tobymao/sqlglot/commit/68a5e615b24e518cb90c9b80cf25355fcabdb468) - **snowflake**: annotate type for REGR_* functions *(PR [#6452](https://github.com/tobymao/sqlglot/pull/6452) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`f7458a4`](https://github.com/tobymao/sqlglot/commit/f7458a40d3b09a2e212f6705ac4a77c99714508e) - **optimizer**: annotate type for snowflake func TO_BOOLEAN *(PR [#6481](https://github.com/tobymao/sqlglot/pull/6481) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`1531a67`](https://github.com/tobymao/sqlglot/commit/1531a67ac7806f3b4582f6cf1ea02342a517de74) - **snowflake**: annotate type for VECTOR_INNER_PRODUCT *(PR [#6486](https://github.com/tobymao/sqlglot/pull/6486) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`f6b2b3b`](https://github.com/tobymao/sqlglot/commit/f6b2b3bc6e1c95340149be65d80ef7e177b28d82) - **snowflake**: support padside argument for BIT[OR|AND|XOR] *(PR [#6487](https://github.com/tobymao/sqlglot/pull/6487) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`e891397`](https://github.com/tobymao/sqlglot/commit/e89139714aefd8a6481a90d9753c81910c9f88e9) - **BigQuery**: Add support for the NET.HOST function *(PR [#6480](https://github.com/tobymao/sqlglot/pull/6480) by [@vchan](https://github.com/vchan))*
- [`2cc67cd`](https://github.com/tobymao/sqlglot/commit/2cc67cd7386914043a9cb4eb322fb1fa9af15c8b) - **singlestore**: support dcolonqmark *(PR [#6485](https://github.com/tobymao/sqlglot/pull/6485) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`7d485c7`](https://github.com/tobymao/sqlglot/commit/7d485c7cffe7b6d0113cfcfcf0736de0383bd380) - **duckdb**: Add transpilation support for the negative integer args for BITNOT *(PR [#6490](https://github.com/tobymao/sqlglot/pull/6490) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`ef130f1`](https://github.com/tobymao/sqlglot/commit/ef130f1b944b4be835d4a6831fec9a333a825a34) - **snowflake**: Annotated type for ARRAY_CONSTRUCT_COMPACT [#6496](https://github.com/tobymao/sqlglot/pull/6496) *(commit by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`36cf0bf`](https://github.com/tobymao/sqlglot/commit/36cf0bf6671f622344afee52d7aafe30f19ecf9a) - **snowflake**: annotation support for CURRENT_ROLE. *(PR [#6478](https://github.com/tobymao/sqlglot/pull/6478) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`cbba04c`](https://github.com/tobymao/sqlglot/commit/cbba04cb292fe8b3fd38c87d9ccb624cdcb52843) - **databricks**: support comma-separated syntax for OVERLAY function *(PR [#6497](https://github.com/tobymao/sqlglot/pull/6497) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`dc8f26a`](https://github.com/tobymao/sqlglot/commit/dc8f26a3a5e023a0e54caa345b129fb1b4fe805f) - **optimizer**: bq annotate type for NULL *(PR [#6491](https://github.com/tobymao/sqlglot/pull/6491) by [@geooo109](https://github.com/geooo109))*
- [`c97a81d`](https://github.com/tobymao/sqlglot/commit/c97a81d68a1584fad48475725665a7678fcad9d1) - **optimizer**: annotate TO_HEX(MD5(...)) in BigQuery *(PR [#6500](https://github.com/tobymao/sqlglot/pull/6500) by [@georgesittas](https://github.com/georgesittas))*
- [`a5797a1`](https://github.com/tobymao/sqlglot/commit/a5797a1c867c4ade71ae4ddf93232576993cf5bc) - **duckdb**: handle named arguments and non-integer scale input for ROUND *(PR [#6495](https://github.com/tobymao/sqlglot/pull/6495) by [@toriwei](https://github.com/toriwei))*
- [`8b5298a`](https://github.com/tobymao/sqlglot/commit/8b5298a6578af80fd9676eb222422862d5468859) - **duckdb**: Transpile BQ's WEEK based `DATE_DIFF` *(PR [#6507](https://github.com/tobymao/sqlglot/pull/6507) by [@VaggelisD](https://github.com/VaggelisD))*
- [`2c013a5`](https://github.com/tobymao/sqlglot/commit/2c013a5cc8e37cde8a8f9443e0397191ce82f0f5) - **exasol**: qualify bare stars to facilitate transpilation *(PR [#6431](https://github.com/tobymao/sqlglot/pull/6431) by [@nnamdi16](https://github.com/nnamdi16))*
- [`41b776b`](https://github.com/tobymao/sqlglot/commit/41b776bdc6936f18accd9f7308b55acd383bb596) - **postgres,trino,duckdb**: added support for current_catalog *(PR [#6492](https://github.com/tobymao/sqlglot/pull/6492) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`dd19bea`](https://github.com/tobymao/sqlglot/commit/dd19beae95f077cfd8b6e315eca7ff212817b250) - **snowflake**: annotation support for CURRENT_ACCOUNT *(PR [#6512](https://github.com/tobymao/sqlglot/pull/6512) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`2e8105e`](https://github.com/tobymao/sqlglot/commit/2e8105eebaec25fc8f94f1e68951198660f404e1) - **snowflake**: Annotate type for VAR_POP, VAR_SAMP, DuckDB consistency fix for VAR_SAMP *(PR [#6488](https://github.com/tobymao/sqlglot/pull/6488) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`cfb02c1`](https://github.com/tobymao/sqlglot/commit/cfb02c1aa676e801b2d13a84467b4904cd834ffe) - **snowflake**: annotation support for CURRENT_ACCOUNT_NAME *(PR [#6513](https://github.com/tobymao/sqlglot/pull/6513) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`1004e31`](https://github.com/tobymao/sqlglot/commit/1004e31cce62cce2e2afb7eab85ed8bdecaede3b) - **snowflake**: annotation support for CURRENT_AVAILABLE_ROLES *(PR [#6514](https://github.com/tobymao/sqlglot/pull/6514) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`ff201fe`](https://github.com/tobymao/sqlglot/commit/ff201febd27937a97674dd091928456dde733254) - **snowflake**: annotation support for CURRENT_CLIENT *(PR [#6515](https://github.com/tobymao/sqlglot/pull/6515) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`d777a9c`](https://github.com/tobymao/sqlglot/commit/d777a9c0feef15ac036f7b413112de4d7cc8bea4) - **snowflake**: annotation support for CURRENT_IP_ADDRESS *(PR [#6518](https://github.com/tobymao/sqlglot/pull/6518) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`c296061`](https://github.com/tobymao/sqlglot/commit/c2960615a3bd279b7c5f775d5b93ae12aa27a3b8) - **snowflake**: Transpilation of TO_BINARY from snowflake to duckdb *(PR [#6504](https://github.com/tobymao/sqlglot/pull/6504) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`7a70164`](https://github.com/tobymao/sqlglot/commit/7a70164d8cf361cf4c0a7d5789bb51676f772959) - **duckdb**: transpile Snowflake's `RANDSTR` function *(PR [#6502](https://github.com/tobymao/sqlglot/pull/6502) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`a26d419`](https://github.com/tobymao/sqlglot/commit/a26d4191e5468e39eafdf7a981e7b890d438b2c9) - **snowflake**: annotation support for CURRENT_DATABASE *(PR [#6516](https://github.com/tobymao/sqlglot/pull/6516) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`0acdf7f`](https://github.com/tobymao/sqlglot/commit/0acdf7fc783f2722536ec24dcf8600957febf7ca) - **snowflake**: annotation support for CURRENT_SCHEMAS *(PR [#6519](https://github.com/tobymao/sqlglot/pull/6519) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`43cce89`](https://github.com/tobymao/sqlglot/commit/43cce895da80d21abc89d40de5d7fddd68871bf0) - **snowflake**: annotation support for CURRENT_SECONDARY_ROLES *(PR [#6520](https://github.com/tobymao/sqlglot/pull/6520) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`c21b4b1`](https://github.com/tobymao/sqlglot/commit/c21b4b1134b368ee5144339b59e70ddcc54f3dbc) - **snowflake**: annotation support for CURRENT_SESSION *(PR [#6521](https://github.com/tobymao/sqlglot/pull/6521) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`57a83c0`](https://github.com/tobymao/sqlglot/commit/57a83c018dace690f7bb363c25ee6bde33c3d60f) - **snowflake**: annotation support for CURRENT_STATEMENT *(PR [#6522](https://github.com/tobymao/sqlglot/pull/6522) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`4b240e4`](https://github.com/tobymao/sqlglot/commit/4b240e40a8809a6eea2a279370a884f4a7b03dfa) - **snowflake**: annotation support for CURRENT_VERSION *(PR [#6524](https://github.com/tobymao/sqlglot/pull/6524) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`c1a831f`](https://github.com/tobymao/sqlglot/commit/c1a831f5bf662ab8d8e07dc2bb949f2adcbe7d7c) - **snowflake**: annotation support for CURRENT_TRANSACTION *(PR [#6523](https://github.com/tobymao/sqlglot/pull/6523) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`2e162b0`](https://github.com/tobymao/sqlglot/commit/2e162b0d34066e7aa7edac3156739bcd31a634fc) - **snowflake**: annotation support for CURRENT_WAREHOUSE *(PR [#6525](https://github.com/tobymao/sqlglot/pull/6525) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`18e9814`](https://github.com/tobymao/sqlglot/commit/18e98145906eaa5b769af49cf46b58a1d9448aee) - **snowflake**: support DAYOFWEEK_ISO date part *(PR [#6531](https://github.com/tobymao/sqlglot/pull/6531) by [@toriwei](https://github.com/toriwei))*
- [`ee5e7b9`](https://github.com/tobymao/sqlglot/commit/ee5e7b931ca745a000dc8a720b56aee7b44186b2) - Automatically trigger integration tests scoped to modified dialects *(PR [#6505](https://github.com/tobymao/sqlglot/pull/6505) by [@erindru](https://github.com/erindru))*
- [`e60634f`](https://github.com/tobymao/sqlglot/commit/e60634f0e1c396b54ad357132606286bd21d3e36) - **clickhouse**: Add support for quantilesExactExclusive agg func *(PR [#6535](https://github.com/tobymao/sqlglot/pull/6535) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#6533](https://github.com/tobymao/sqlglot/issues/6533) opened by [@vargasj-ms](https://github.com/vargasj-ms)*
- [`41a9e88`](https://github.com/tobymao/sqlglot/commit/41a9e88bb9800205df0b3e10a1976699dc4fe4f9) - **duckdb**: Add support to transpile binary args for bitwise operators *(PR [#6508](https://github.com/tobymao/sqlglot/pull/6508) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*

### :bug: Bug Fixes
- [`7021d54`](https://github.com/tobymao/sqlglot/commit/7021d54ecf0ceab3c3606642cbfca8e080cc8613) - **tsql**: CEILING generation *(PR [#6477](https://github.com/tobymao/sqlglot/pull/6477) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6472](https://github.com/tobymao/sqlglot/issues/6472) opened by [@ricky-ho](https://github.com/ricky-ho)*
- [`df4c1d3`](https://github.com/tobymao/sqlglot/commit/df4c1d37ff77151a74b5de3d119c7e03f5db85f4) - REGEXP_EXTRACT position arg overflow *(PR [#6458](https://github.com/tobymao/sqlglot/pull/6458) by [@treysp](https://github.com/treysp))*
  - :arrow_lower_right: *fixes issue [#6442](https://github.com/tobymao/sqlglot/issues/6442) opened by [@erindru](https://github.com/erindru)*
- [`5a49c3f`](https://github.com/tobymao/sqlglot/commit/5a49c3f7a7619ad9e711ff2cd9e85b8606969b36) - **optimizer**: support ORDER / LIMIT expressions for BigQuery ARRAY_AGG / STRING_AGG functions *(PR [#6463](https://github.com/tobymao/sqlglot/pull/6463) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`1b6076b`](https://github.com/tobymao/sqlglot/commit/1b6076bd5a64b044f52f5366244ba0746aca75e1) - wrap connectives generated due to transpiling LIKE ANY closes [#6493](https://github.com/tobymao/sqlglot/pull/6493) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`36ad534`](https://github.com/tobymao/sqlglot/commit/36ad534b14eabe9ee197017f5087e8e5190f8526) - **exasol**: qualified select list with "LOCAL" *(PR [#6450](https://github.com/tobymao/sqlglot/pull/6450) by [@nnamdi16](https://github.com/nnamdi16))*
- [`52aceaa`](https://github.com/tobymao/sqlglot/commit/52aceaaa887dddb35f8ede5c2d9577fdeee35c48) - **optimizer**: annotate `HavingMax` by `this` *(PR [#6499](https://github.com/tobymao/sqlglot/pull/6499) by [@georgesittas](https://github.com/georgesittas))*
- [`ce5487e`](https://github.com/tobymao/sqlglot/commit/ce5487ef2ec0a3de8fa79b9febf41236c05c04cc) - sources doesn't store columns, clean up this old code *(commit by [@tobymao](https://github.com/tobymao))*
- [`3224235`](https://github.com/tobymao/sqlglot/commit/3224235c1b7a80511af11f7dbffe608a747a3df0) - make CTE builder produce AST consistent with parser closes [#6503](https://github.com/tobymao/sqlglot/pull/6503) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`9454a18`](https://github.com/tobymao/sqlglot/commit/9454a18cca41a510e61522f6b785d646980e2100) - uppercase join method, side, kind for consistency fixes [#6510](https://github.com/tobymao/sqlglot/pull/6510) *(PR [#6511](https://github.com/tobymao/sqlglot/pull/6511) by [@georgesittas](https://github.com/georgesittas))*
- [`a6ec4b6`](https://github.com/tobymao/sqlglot/commit/a6ec4b688891691b26ab874a3401e370c0b8d574) - reorder join mark check in eliminate_join_marks *(PR [#6528](https://github.com/tobymao/sqlglot/pull/6528) by [@snovik75](https://github.com/snovik75))*
  - :arrow_lower_right: *fixes issue [#6527](https://github.com/tobymao/sqlglot/issues/6527) opened by [@snovik75](https://github.com/snovik75)*
- [`9d06859`](https://github.com/tobymao/sqlglot/commit/9d0685923209c04747fa6fa2b35ee2e516453abc) - **optimizer**: annotate bigquery ARRAY when arg contains set operations *(PR [#6517](https://github.com/tobymao/sqlglot/pull/6517) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`241073d`](https://github.com/tobymao/sqlglot/commit/241073d886e0b4ad7b2252a8c8c394e717ef700a) - on_qualify type *(commit by [@tobymao](https://github.com/tobymao))*
- [`2fd14ed`](https://github.com/tobymao/sqlglot/commit/2fd14ed32b3793444405005fb98342222b4d7956) - **optimizer**: query schema directly when type annotation fails for processing UNNEST source *(PR [#6451](https://github.com/tobymao/sqlglot/pull/6451) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*

### :recycle: Refactors
- [`2d380e7`](https://github.com/tobymao/sqlglot/commit/2d380e72c9e3b842a8fe57c191f494c8872c00ee) - add test to make sure callback doesn't trigger ctes *(commit by [@tobymao](https://github.com/tobymao))*

### :wrench: Chores
- [`4a061e2`](https://github.com/tobymao/sqlglot/commit/4a061e26b638c9acb0c8a77d9347914b35082bb3) - **optimizer**: Include BIGDECIMAL in numeric precedence *(PR [#6456](https://github.com/tobymao/sqlglot/pull/6456) by [@vchan](https://github.com/vchan))*
- [`f305305`](https://github.com/tobymao/sqlglot/commit/f305305e5cf3ef45afba822542aebeb944c00e0b) - **optimizer**: Annotate types for BigQuery's AVG function *(PR [#6459](https://github.com/tobymao/sqlglot/pull/6459) by [@vchan](https://github.com/vchan))*
- [`910349f`](https://github.com/tobymao/sqlglot/commit/910349f3c30af59ce1820e48cae0cbb77539877d) - **optimizer**: Annotate types for BigQuery's SAFE_DIVIDE function *(PR [#6464](https://github.com/tobymao/sqlglot/pull/6464) by [@vchan](https://github.com/vchan))*
- [`5e75621`](https://github.com/tobymao/sqlglot/commit/5e75621e90defd50076383485f6a4689a8c551ac) - **optimizer**: annotate type for snowflake func ARRAY_UNIQUE_AGG *(PR [#6465](https://github.com/tobymao/sqlglot/pull/6465) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`4d77500`](https://github.com/tobymao/sqlglot/commit/4d775007d2ceb997ff33721def768493c95f98a5) - **optimizer**: add tests for snowflake CAST function *(PR [#6471](https://github.com/tobymao/sqlglot/pull/6471) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`88dfd26`](https://github.com/tobymao/sqlglot/commit/88dfd26b832d13e517fe7c18d2c086885bf4954d) - **optimizer**: annotate type for snowflake func TO_BINARY *(PR [#6474](https://github.com/tobymao/sqlglot/pull/6474) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`483318b`](https://github.com/tobymao/sqlglot/commit/483318bc25e4ee4fa2731be1a0aea02858872ab5) - clean up TO_BINARY tests *(commit by [@geooo109](https://github.com/geooo109))*
- [`bff7084`](https://github.com/tobymao/sqlglot/commit/bff70841d0bfbede6ea0fae2e7b37d68735a53d8) - remove duckdb TO_BINARY 2 arg test *(commit by [@geooo109](https://github.com/geooo109))*
- [`80591f9`](https://github.com/tobymao/sqlglot/commit/80591f9513dff9160884e4bbbd48d9c26cf8f253) - starrocks TO_BINARY tests *(commit by [@geooo109](https://github.com/geooo109))*
- [`01e5a05`](https://github.com/tobymao/sqlglot/commit/01e5a050c76f728ef542f0127209e2cd1c5f5558) - **exasol**: implementing the last day function in exasol sql dialect *(PR [#6483](https://github.com/tobymao/sqlglot/pull/6483) by [@nnamdi16](https://github.com/nnamdi16))*
- [`aacc981`](https://github.com/tobymao/sqlglot/commit/aacc98105fb381c17a80ee011f107157279312d7) - **duckdb**: tests for MAX_BY and MIN_BY *(PR [#6489](https://github.com/tobymao/sqlglot/pull/6489) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`06c7ffb`](https://github.com/tobymao/sqlglot/commit/06c7ffbe14985a4da35a97d47322021e79525adf) - cleanup bitwise operator fixes *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v28.1.0] - 2025-12-02
### :boom: BREAKING CHANGES
- due to [`e4d1a4f`](https://github.com/tobymao/sqlglot/commit/e4d1a4fcd6741d679c5444bf023077d2aaa8f980) - map date/timestamp `TRUNC` to `DATE_TRUNC` *(PR [#6328](https://github.com/tobymao/sqlglot/pull/6328) by [@nnamdi16](https://github.com/nnamdi16))*:

  map date/timestamp `TRUNC` to `DATE_TRUNC` (#6328)

- due to [`e1b6558`](https://github.com/tobymao/sqlglot/commit/e1b6558cb1a860bbd695f25b66e52064b57c0a84) - handle all datepart alternatives *(PR [#6324](https://github.com/tobymao/sqlglot/pull/6324) by [@lBilali](https://github.com/lBilali))*:

  handle all datepart alternatives (#6324)

- due to [`06daa47`](https://github.com/tobymao/sqlglot/commit/06daa47dedebac672548e1db230b89f5c9eae84e) - update annotated type of ARRAY_AGG to untyped array *(PR [#6347](https://github.com/tobymao/sqlglot/pull/6347) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  update annotated type of ARRAY_AGG to untyped array (#6347)

- due to [`7484c06`](https://github.com/tobymao/sqlglot/commit/7484c06be4534cd22dee14da542d5e29ff2c13a2) - Support rounding mode argument for ROUND function *(PR [#6350](https://github.com/tobymao/sqlglot/pull/6350) by [@vchan](https://github.com/vchan))*:

  Support rounding mode argument for ROUND function (#6350)

- due to [`c495a40`](https://github.com/tobymao/sqlglot/commit/c495a40ee4c1a69b14892e8455ae1bd2ceb5ea4f) - annotate type for MINHASH *(PR [#6355](https://github.com/tobymao/sqlglot/pull/6355) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for MINHASH (#6355)

- due to [`b1f9a97`](https://github.com/tobymao/sqlglot/commit/b1f9a976be3c0bcd895bef5bcdb95a013eeb28b7) - annotate type for APPROXIMATE_SIMILARITY *(PR [#6360](https://github.com/tobymao/sqlglot/pull/6360) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for APPROXIMATE_SIMILARITY (#6360)

- due to [`3aafca7`](https://github.com/tobymao/sqlglot/commit/3aafca74546b932cea93ed830c021f347ae03ded) - annotate type for MINHASH_COMBINE *(PR [#6362](https://github.com/tobymao/sqlglot/pull/6362) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for MINHASH_COMBINE (#6362)

- due to [`df13a65`](https://github.com/tobymao/sqlglot/commit/df13a655646bd2ef5d8b4613670bb5fe48845b73) - unnest deep stuff *(PR [#6366](https://github.com/tobymao/sqlglot/pull/6366) by [@tobymao](https://github.com/tobymao))*:

  unnest deep stuff (#6366)

- due to [`d4c2256`](https://github.com/tobymao/sqlglot/commit/d4c2256fb493ed2f16c29694ae5c31517123d419) - at time zone precedence *(PR [#6383](https://github.com/tobymao/sqlglot/pull/6383) by [@geooo109](https://github.com/geooo109))*:

  at time zone precedence (#6383)

- due to [`4fb4d08`](https://github.com/tobymao/sqlglot/commit/4fb4d08ef8896bda434d4f89c21c669c6146fd02) - properly support table alias in the `INSERT` DML *(PR [#6374](https://github.com/tobymao/sqlglot/pull/6374) by [@snovik75](https://github.com/snovik75))*:

  properly support table alias in the `INSERT` DML (#6374)

- due to [`bf07abd`](https://github.com/tobymao/sqlglot/commit/bf07abd4ee9eb0f5510cb7d1f232bdcaea88941e) - annotation support for  APPROX_TOP_K_COMBINE  *(PR [#6378](https://github.com/tobymao/sqlglot/pull/6378) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for  APPROX_TOP_K_COMBINE  (#6378)

- due to [`50348ac`](https://github.com/tobymao/sqlglot/commit/50348ac31f784aa97bd09d5d6c6613fbd68402ee) - support order by clause for mysql delete statement *(PR [#6381](https://github.com/tobymao/sqlglot/pull/6381) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  support order by clause for mysql delete statement (#6381)

- due to [`21d3859`](https://github.com/tobymao/sqlglot/commit/21d38590fec6cb55a1a03aeb2621bd9fca677496) - Disable STRING_AGG sep canonicalization *(PR [#6395](https://github.com/tobymao/sqlglot/pull/6395) by [@VaggelisD](https://github.com/VaggelisD))*:

  Disable STRING_AGG sep canonicalization (#6395)

- due to [`95727f6`](https://github.com/tobymao/sqlglot/commit/95727f60d601796b34c850dee9366d79f6e4a24b) - canonicalize table aliases *(PR [#6369](https://github.com/tobymao/sqlglot/pull/6369) by [@georgesittas](https://github.com/georgesittas))*:

  canonicalize table aliases (#6369)

- due to [`c7cb098`](https://github.com/tobymao/sqlglot/commit/c7cb0983a0fa463c43d2c4ee925816e9a1628c79) - Fix underscore separator with scientific notation *(PR [#6401](https://github.com/tobymao/sqlglot/pull/6401) by [@VaggelisD](https://github.com/VaggelisD))*:

  Fix underscore separator with scientific notation (#6401)

- due to [`bb4eda1`](https://github.com/tobymao/sqlglot/commit/bb4eda1beb68b92de9ab014a63c67797a07df2fa) - support transpiling SHA1 from BigQuery to DuckDB *(PR [#6404](https://github.com/tobymao/sqlglot/pull/6404) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpiling SHA1 from BigQuery to DuckDB (#6404)

- due to [`d038ad7`](https://github.com/tobymao/sqlglot/commit/d038ad7f036a140f3eae4bdde15824437d4e44ee) - support named primary keys for mysql *(PR [#6389](https://github.com/tobymao/sqlglot/pull/6389) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  support named primary keys for mysql (#6389)

- due to [`05e83b5`](https://github.com/tobymao/sqlglot/commit/05e83b56f1bf9323cfa819a7f1beb542524c1219) - support transpilation of LEAST from BigQuery to DuckDB *(PR [#6415](https://github.com/tobymao/sqlglot/pull/6415) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation of LEAST from BigQuery to DuckDB (#6415)

- due to [`4f3bb0d`](https://github.com/tobymao/sqlglot/commit/4f3bb0d6714bf89ff72e13e1398d8f01cefafb00) - Correct transpilation of BigQuery's JSON_EXTRACT_SCALAR… *(PR [#6414](https://github.com/tobymao/sqlglot/pull/6414) by [@vchan](https://github.com/vchan))*:

  Correct transpilation of BigQuery's JSON_EXTRACT_SCALAR… (#6414)

- due to [`8c314a8`](https://github.com/tobymao/sqlglot/commit/8c314a8b457a5c3ed470ac8fcff022fec881c248) - support cte pivot for duckdb *(PR [#6413](https://github.com/tobymao/sqlglot/pull/6413) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  support cte pivot for duckdb (#6413)

- due to [`c6b0a63`](https://github.com/tobymao/sqlglot/commit/c6b0a6342a21d79635a26d40001c916d05d47cf7) - change version to be a tuple so that it can be pickled, also simpler *(commit by [@tobymao](https://github.com/tobymao))*:

  change version to be a tuple so that it can be pickled, also simpler

- due to [`07d9958`](https://github.com/tobymao/sqlglot/commit/07d99583b4aebdc682bb7604ccdf45bddb89f9c3) - replace direct comparison with dialect properties *(PR [#6398](https://github.com/tobymao/sqlglot/pull/6398) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  replace direct comparison with dialect properties (#6398)

- due to [`38472ce`](https://github.com/tobymao/sqlglot/commit/38472ce14bce731ba4c309d515223ae99e2575ac) - transpile bigquery's %x format literal *(PR [#6375](https://github.com/tobymao/sqlglot/pull/6375) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  transpile bigquery's %x format literal (#6375)

- due to [`92ee124`](https://github.com/tobymao/sqlglot/commit/92ee1241ea3088d4e63c094404252339c54ad0c1) - postgres qualify GENERATE_SERIES and table projection *(PR [#6373](https://github.com/tobymao/sqlglot/pull/6373) by [@geooo109](https://github.com/geooo109))*:

  postgres qualify GENERATE_SERIES and table projection (#6373)

- due to [`0b9d8ac`](https://github.com/tobymao/sqlglot/commit/0b9d8acbe75457424436e8c0acc047ab66e9fdc0) - Annotate type for snowflake MAX function *(PR [#6422](https://github.com/tobymao/sqlglot/pull/6422) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for snowflake MAX function (#6422)

- due to [`68e9414`](https://github.com/tobymao/sqlglot/commit/68e9414725a60b2842d870fa222d8466057a94f6) - Annotate type for snowflake MIN function *(PR [#6427](https://github.com/tobymao/sqlglot/pull/6427) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  Annotate type for snowflake MIN function (#6427)

- due to [`1318de7`](https://github.com/tobymao/sqlglot/commit/1318de77a8aa514ec7eb9f9b8c03228e3f8eb008) - Annotate type for snowflake NORMAL *(PR [#6434](https://github.com/tobymao/sqlglot/pull/6434) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for snowflake NORMAL (#6434)

- due to [`ffbb5c7`](https://github.com/tobymao/sqlglot/commit/ffbb5c7e40aa064ffcd4827e96ea66cfd045118e) - annotate type for HASH_AGG in Snowflake *(PR [#6438](https://github.com/tobymao/sqlglot/pull/6438) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate type for HASH_AGG in Snowflake (#6438)

- due to [`161255f`](https://github.com/tobymao/sqlglot/commit/161255f6c90b9c3ed2074e734f6d074db1d7a6dd) - Add support for `LOCALTIME` function *(PR [#6443](https://github.com/tobymao/sqlglot/pull/6443) by [@VaggelisD](https://github.com/VaggelisD))*:

  Add support for `LOCALTIME` function (#6443)

- due to [`ca329f0`](https://github.com/tobymao/sqlglot/commit/ca329f037a230c315437d830638b514190764c5a) - support transpilation of SHA256 from bigquery to duckdb *(PR [#6421](https://github.com/tobymao/sqlglot/pull/6421) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  support transpilation of SHA256 from bigquery to duckdb (#6421)

- due to [`e18ae24`](https://github.com/tobymao/sqlglot/commit/e18ae248423dbbca78a24a60ea0193da2ee7f68c) - Annotate type for snowflake REGR_SLOPE function *(PR [#6425](https://github.com/tobymao/sqlglot/pull/6425) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for snowflake REGR_SLOPE function (#6425)

- due to [`1d847f0`](https://github.com/tobymao/sqlglot/commit/1d847f0a1f88fce5df340ab646a72c8abbc12a86) - parse & annotate `CHECK_JSON`, `CHECK_XML` *(PR [#6439](https://github.com/tobymao/sqlglot/pull/6439) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  parse & annotate `CHECK_JSON`, `CHECK_XML` (#6439)

- due to [`cb3080d`](https://github.com/tobymao/sqlglot/commit/cb3080d4bed18b1bfbbd08380ed60deeefd15530) - annotation support for APPROX_TOP_K_ESTIMATE . Return type ARRAY *(PR [#6445](https://github.com/tobymao/sqlglot/pull/6445) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotation support for APPROX_TOP_K_ESTIMATE . Return type ARRAY (#6445)

- due to [`313afe5`](https://github.com/tobymao/sqlglot/commit/313afe540aa2cdc4cc179c4852c6ef37362bcb3e) - annotate type for snowflake func ARRAY_UNION_AGG *(PR [#6446](https://github.com/tobymao/sqlglot/pull/6446) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for snowflake func ARRAY_UNION_AGG (#6446)

- due to [`cd9f037`](https://github.com/tobymao/sqlglot/commit/cd9f037882eef253e86fdb1d51521e0acd7db3f9) - store pk name if provided *(PR [#6424](https://github.com/tobymao/sqlglot/pull/6424) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  store pk name if provided (#6424)

- due to [`65194e4`](https://github.com/tobymao/sqlglot/commit/65194e465489151aa51859a6e3f5672f7d4c5f3b) - Annotate type for snowflake RANDSTR function *(PR [#6436](https://github.com/tobymao/sqlglot/pull/6436) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for snowflake RANDSTR function (#6436)

- due to [`a56262e`](https://github.com/tobymao/sqlglot/commit/a56262e6b4276baae144855478807c173db77ab9) - Annotate type for snowflake MEDIAN *(PR [#6426](https://github.com/tobymao/sqlglot/pull/6426) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  Annotate type for snowflake MEDIAN (#6426)

- due to [`2c56567`](https://github.com/tobymao/sqlglot/commit/2c56567755c8a6571d8b7d410c9de943e54df58b) - Annotate type for snowflake SEARCH_IP  *(PR [#6440](https://github.com/tobymao/sqlglot/pull/6440) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Annotate type for snowflake SEARCH_IP  (#6440)

- due to [`ac86568`](https://github.com/tobymao/sqlglot/commit/ac86568a939f692b99813da100297b61fb54e044) - Added decfloat type *(PR [#6444](https://github.com/tobymao/sqlglot/pull/6444) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*:

  Added decfloat type (#6444)

- due to [`b321ca6`](https://github.com/tobymao/sqlglot/commit/b321ca6191fefc88da1a6de83a465886b5754b7a) - bump sqlglotrs to 0.8.0 *(commit by [@georgesittas](https://github.com/georgesittas))*:

  bump sqlglotrs to 0.8.0


### :sparkles: New Features
- [`ca81217`](https://github.com/tobymao/sqlglot/commit/ca812171ab800e3faa73ea1874dd6814c8d6f701) - **duckdb**: Transpile INITCAP with custom delimiters *(PR [#6302](https://github.com/tobymao/sqlglot/pull/6302) by [@treysp](https://github.com/treysp))*
- [`7484c06`](https://github.com/tobymao/sqlglot/commit/7484c06be4534cd22dee14da542d5e29ff2c13a2) - **DuckDB**: Support rounding mode argument for ROUND function *(PR [#6350](https://github.com/tobymao/sqlglot/pull/6350) by [@vchan](https://github.com/vchan))*
- [`79e314d`](https://github.com/tobymao/sqlglot/commit/79e314df76161319ba8495b95f54603cfef0c08a) - **duckdb**: handle casting BLOB input for TRIM() *(PR [#6353](https://github.com/tobymao/sqlglot/pull/6353) by [@toriwei](https://github.com/toriwei))*
- [`c495a40`](https://github.com/tobymao/sqlglot/commit/c495a40ee4c1a69b14892e8455ae1bd2ceb5ea4f) - **optimizer**: annotate type for MINHASH *(PR [#6355](https://github.com/tobymao/sqlglot/pull/6355) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`f16f8a0`](https://github.com/tobymao/sqlglot/commit/f16f8a08072556fd617b5125300262d9bb8c1e48) - improve validate qualify column message closes [#6348](https://github.com/tobymao/sqlglot/pull/6348) *(PR [#6356](https://github.com/tobymao/sqlglot/pull/6356) by [@tobymao](https://github.com/tobymao))*
- [`17abe23`](https://github.com/tobymao/sqlglot/commit/17abe231bc4d59912952f266ad4df86ece22c8d2) - make simplify more efficient in number of iterations *(PR [#6351](https://github.com/tobymao/sqlglot/pull/6351) by [@tobymao](https://github.com/tobymao))*
- [`b1f9a97`](https://github.com/tobymao/sqlglot/commit/b1f9a976be3c0bcd895bef5bcdb95a013eeb28b7) - **optimizer**: annotate type for APPROXIMATE_SIMILARITY *(PR [#6360](https://github.com/tobymao/sqlglot/pull/6360) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`3aafca7`](https://github.com/tobymao/sqlglot/commit/3aafca74546b932cea93ed830c021f347ae03ded) - **optimizer**: annotate type for MINHASH_COMBINE *(PR [#6362](https://github.com/tobymao/sqlglot/pull/6362) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`09a4bd8`](https://github.com/tobymao/sqlglot/commit/09a4bd8870a075e641c6e3e4cee74d73a39e760a) - Trigger integration tests *(PR [#6339](https://github.com/tobymao/sqlglot/pull/6339) by [@erindru](https://github.com/erindru))*
- [`7769129`](https://github.com/tobymao/sqlglot/commit/7769129eba7ae5f3594e0061bdb1079fedc5aafd) - bignum and time_ns to duckdb closes [#6379](https://github.com/tobymao/sqlglot/pull/6379) *(commit by [@tobymao](https://github.com/tobymao))*
- [`90a3fa9`](https://github.com/tobymao/sqlglot/commit/90a3fa9f6ddf0aa32b41118c59d4facd9fdb3398) - mark IgnoreNulls and RespectNulls as unsupported on postgres and mysql *(PR [#6377](https://github.com/tobymao/sqlglot/pull/6377) by [@NickCrews](https://github.com/NickCrews))*
  - :arrow_lower_right: *addresses issue [#6376](https://github.com/tobymao/sqlglot/issues/6376) opened by [@NickCrews](https://github.com/NickCrews)*
- [`5bb1170`](https://github.com/tobymao/sqlglot/commit/5bb117082caeee719442d783ce6742d027b1492e) - transpile bigquery `greatest` null handling to duckdb *(PR [#6361](https://github.com/tobymao/sqlglot/pull/6361) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`bf07abd`](https://github.com/tobymao/sqlglot/commit/bf07abd4ee9eb0f5510cb7d1f232bdcaea88941e) - **snowflake**: annotation support for  APPROX_TOP_K_COMBINE  *(PR [#6378](https://github.com/tobymao/sqlglot/pull/6378) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`01890eb`](https://github.com/tobymao/sqlglot/commit/01890eb16d6624de4f26b7d8eadf850df6f2a042) - **trino**: support refresh materialized view statement closes [#6387](https://github.com/tobymao/sqlglot/pull/6387) *(PR [#6388](https://github.com/tobymao/sqlglot/pull/6388) by [@georgesittas](https://github.com/georgesittas))*
- [`e4ea6cc`](https://github.com/tobymao/sqlglot/commit/e4ea6ccf08c0ff4063424bf538bc3b22f4b4cfaf) - transpile BQ APPROX_QUANTILES to DuckDB *(PR [#6349](https://github.com/tobymao/sqlglot/pull/6349) by [@treysp](https://github.com/treysp))*
- [`95727f6`](https://github.com/tobymao/sqlglot/commit/95727f60d601796b34c850dee9366d79f6e4a24b) - **optimizer**: canonicalize table aliases *(PR [#6369](https://github.com/tobymao/sqlglot/pull/6369) by [@georgesittas](https://github.com/georgesittas))*
- [`3b6855b`](https://github.com/tobymao/sqlglot/commit/3b6855b9787111f27225108241fbe4f389443e29) - **mysql**: support ZEROFILL column attribute *(PR [#6400](https://github.com/tobymao/sqlglot/pull/6400) by [@nian0114](https://github.com/nian0114))*
  - :arrow_lower_right: *addresses issue [#6399](https://github.com/tobymao/sqlglot/issues/6399) opened by [@nian0114](https://github.com/nian0114)*
- [`bb4eda1`](https://github.com/tobymao/sqlglot/commit/bb4eda1beb68b92de9ab014a63c67797a07df2fa) - **duckdb**: support transpiling SHA1 from BigQuery to DuckDB *(PR [#6404](https://github.com/tobymao/sqlglot/pull/6404) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`05e83b5`](https://github.com/tobymao/sqlglot/commit/05e83b56f1bf9323cfa819a7f1beb542524c1219) - **duckdb**: support transpilation of LEAST from BigQuery to DuckDB *(PR [#6415](https://github.com/tobymao/sqlglot/pull/6415) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`38472ce`](https://github.com/tobymao/sqlglot/commit/38472ce14bce731ba4c309d515223ae99e2575ac) - **duckdb**: transpile bigquery's %x format literal *(PR [#6375](https://github.com/tobymao/sqlglot/pull/6375) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`a6e1581`](https://github.com/tobymao/sqlglot/commit/a6e15811cf5643bcc18e1e227fea20922b05c54a) - **DuckDB**: Cast BIGNUMERIC and BIGDECIMAL types to DECIMAL(38, 5) *(PR [#6419](https://github.com/tobymao/sqlglot/pull/6419) by [@vchan](https://github.com/vchan))*
- [`0b9d8ac`](https://github.com/tobymao/sqlglot/commit/0b9d8acbe75457424436e8c0acc047ab66e9fdc0) - **snowflake**: Annotate type for snowflake MAX function *(PR [#6422](https://github.com/tobymao/sqlglot/pull/6422) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`68e9414`](https://github.com/tobymao/sqlglot/commit/68e9414725a60b2842d870fa222d8466057a94f6) - **snowflake**: Annotate type for snowflake MIN function *(PR [#6427](https://github.com/tobymao/sqlglot/pull/6427) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`1318de7`](https://github.com/tobymao/sqlglot/commit/1318de77a8aa514ec7eb9f9b8c03228e3f8eb008) - **snowflake**: Annotate type for snowflake NORMAL *(PR [#6434](https://github.com/tobymao/sqlglot/pull/6434) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`ffbb5c7`](https://github.com/tobymao/sqlglot/commit/ffbb5c7e40aa064ffcd4827e96ea66cfd045118e) - **snowflake**: annotate type for HASH_AGG in Snowflake *(PR [#6438](https://github.com/tobymao/sqlglot/pull/6438) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`161255f`](https://github.com/tobymao/sqlglot/commit/161255f6c90b9c3ed2074e734f6d074db1d7a6dd) - Add support for `LOCALTIME` function *(PR [#6443](https://github.com/tobymao/sqlglot/pull/6443) by [@VaggelisD](https://github.com/VaggelisD))*
- [`ca329f0`](https://github.com/tobymao/sqlglot/commit/ca329f037a230c315437d830638b514190764c5a) - **duckdb**: support transpilation of SHA256 from bigquery to duckdb *(PR [#6421](https://github.com/tobymao/sqlglot/pull/6421) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`e18ae24`](https://github.com/tobymao/sqlglot/commit/e18ae248423dbbca78a24a60ea0193da2ee7f68c) - **snowflake**: Annotate type for snowflake REGR_SLOPE function *(PR [#6425](https://github.com/tobymao/sqlglot/pull/6425) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`1d847f0`](https://github.com/tobymao/sqlglot/commit/1d847f0a1f88fce5df340ab646a72c8abbc12a86) - **snowflake**: parse & annotate `CHECK_JSON`, `CHECK_XML` *(PR [#6439](https://github.com/tobymao/sqlglot/pull/6439) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`6843812`](https://github.com/tobymao/sqlglot/commit/68438129ceeea70f801e0ae728c51c19291fc7d8) - add correlation id to remote workflow trigger *(PR [#6441](https://github.com/tobymao/sqlglot/pull/6441) by [@erindru](https://github.com/erindru))*
- [`cb3080d`](https://github.com/tobymao/sqlglot/commit/cb3080d4bed18b1bfbbd08380ed60deeefd15530) - **snowflake**: annotation support for APPROX_TOP_K_ESTIMATE . Return type ARRAY *(PR [#6445](https://github.com/tobymao/sqlglot/pull/6445) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`cd9f037`](https://github.com/tobymao/sqlglot/commit/cd9f037882eef253e86fdb1d51521e0acd7db3f9) - **optimizer**: store pk name if provided *(PR [#6424](https://github.com/tobymao/sqlglot/pull/6424) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`65194e4`](https://github.com/tobymao/sqlglot/commit/65194e465489151aa51859a6e3f5672f7d4c5f3b) - **snowflake**: Annotate type for snowflake RANDSTR function *(PR [#6436](https://github.com/tobymao/sqlglot/pull/6436) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`351d783`](https://github.com/tobymao/sqlglot/commit/351d7834915e02a9f4949f9925437e2731f3a8b4) - add support for LOCALTIMESTAMP *(PR [#6448](https://github.com/tobymao/sqlglot/pull/6448) by [@AbhishekASLK](https://github.com/AbhishekASLK))*
- [`a56262e`](https://github.com/tobymao/sqlglot/commit/a56262e6b4276baae144855478807c173db77ab9) - **snowflake**: Annotate type for snowflake MEDIAN *(PR [#6426](https://github.com/tobymao/sqlglot/pull/6426) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`2c56567`](https://github.com/tobymao/sqlglot/commit/2c56567755c8a6571d8b7d410c9de943e54df58b) - **snowflake**: Annotate type for snowflake SEARCH_IP  *(PR [#6440](https://github.com/tobymao/sqlglot/pull/6440) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*
- [`ac86568`](https://github.com/tobymao/sqlglot/commit/ac86568a939f692b99813da100297b61fb54e044) - **snowflake**: Added decfloat type *(PR [#6444](https://github.com/tobymao/sqlglot/pull/6444) by [@fivetran-kwoodbeck](https://github.com/fivetran-kwoodbeck))*

### :bug: Bug Fixes
- [`0f79f2a`](https://github.com/tobymao/sqlglot/commit/0f79f2a55c4ba14d4a5fcfd01a0a727271992b8c) - **snowflake**: MAX_BY and MIN_BY with count should return plain `ARRAY` *(PR [#6343](https://github.com/tobymao/sqlglot/pull/6343) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`e1b6558`](https://github.com/tobymao/sqlglot/commit/e1b6558cb1a860bbd695f25b66e52064b57c0a84) - **tsql**: handle all datepart alternatives *(PR [#6324](https://github.com/tobymao/sqlglot/pull/6324) by [@lBilali](https://github.com/lBilali))*
- [`06daa47`](https://github.com/tobymao/sqlglot/commit/06daa47dedebac672548e1db230b89f5c9eae84e) - **optimizer**: update annotated type of ARRAY_AGG to untyped array *(PR [#6347](https://github.com/tobymao/sqlglot/pull/6347) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`826db4d`](https://github.com/tobymao/sqlglot/commit/826db4d3c413941e3b0b31e1f907fabd017bd461) - **redshift**: properly parse default IAM_ROLE and AVRO/JSON formats in COPY *(PR [#6346](https://github.com/tobymao/sqlglot/pull/6346) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6345](https://github.com/tobymao/sqlglot/issues/6345) opened by [@zachary-povey](https://github.com/zachary-povey)*
- [`c367bac`](https://github.com/tobymao/sqlglot/commit/c367bac878a3c17773009b54b9836e7b9a5b84fe) - **duckdb**: Support update without set in DuckDB merge when matched *(PR [#6357](https://github.com/tobymao/sqlglot/pull/6357) by [@themisvaltinos](https://github.com/themisvaltinos))*
- [`df13a65`](https://github.com/tobymao/sqlglot/commit/df13a655646bd2ef5d8b4613670bb5fe48845b73) - unnest deep stuff *(PR [#6366](https://github.com/tobymao/sqlglot/pull/6366) by [@tobymao](https://github.com/tobymao))*
- [`20e33fd`](https://github.com/tobymao/sqlglot/commit/20e33fd0d1bc1899727d023411e604f1ea9347b8) - **duckdb**: regexp_extract_all closes [#6380](https://github.com/tobymao/sqlglot/pull/6380) *(commit by [@tobymao](https://github.com/tobymao))*
- [`d4c2256`](https://github.com/tobymao/sqlglot/commit/d4c2256fb493ed2f16c29694ae5c31517123d419) - **parser**: at time zone precedence *(PR [#6383](https://github.com/tobymao/sqlglot/pull/6383) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6359](https://github.com/tobymao/sqlglot/issues/6359) opened by [@parth-wisdom](https://github.com/parth-wisdom)*
- [`4fb4d08`](https://github.com/tobymao/sqlglot/commit/4fb4d08ef8896bda434d4f89c21c669c6146fd02) - **oracle**: properly support table alias in the `INSERT` DML *(PR [#6374](https://github.com/tobymao/sqlglot/pull/6374) by [@snovik75](https://github.com/snovik75))*
  - :arrow_lower_right: *fixes issue [#6371](https://github.com/tobymao/sqlglot/issues/6371) opened by [@snovik75](https://github.com/snovik75)*
- [`2169f5b`](https://github.com/tobymao/sqlglot/commit/2169f5b8f30b6c8be1635bb5648a1abf636e49a6) - **parser**: support SET with := *(PR [#6385](https://github.com/tobymao/sqlglot/pull/6385) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6384](https://github.com/tobymao/sqlglot/issues/6384) opened by [@AndyVW77](https://github.com/AndyVW77)*
- [`50348ac`](https://github.com/tobymao/sqlglot/commit/50348ac31f784aa97bd09d5d6c6613fbd68402ee) - **mysql**: support order by clause for mysql delete statement *(PR [#6381](https://github.com/tobymao/sqlglot/pull/6381) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
  - :arrow_lower_right: *fixes issue [#6372](https://github.com/tobymao/sqlglot/issues/6372) opened by [@AhlamHani](https://github.com/AhlamHani)*
- [`21d3859`](https://github.com/tobymao/sqlglot/commit/21d38590fec6cb55a1a03aeb2621bd9fca677496) - **bigquery**: Disable STRING_AGG sep canonicalization *(PR [#6395](https://github.com/tobymao/sqlglot/pull/6395) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6392](https://github.com/tobymao/sqlglot/issues/6392) opened by [@erindru](https://github.com/erindru)*
- [`67f499d`](https://github.com/tobymao/sqlglot/commit/67f499dd497efdf4f3fc49dd75e49a77e036ee63) - **duckdb**: Make exp.DateFromParts more lenient *(PR [#6397](https://github.com/tobymao/sqlglot/pull/6397) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6394](https://github.com/tobymao/sqlglot/issues/6394) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`39f8c37`](https://github.com/tobymao/sqlglot/commit/39f8c37aca755d97e1e41f232042d1c649e58908) - **parser**: support FROM-syntax with joins *(PR [#6402](https://github.com/tobymao/sqlglot/pull/6402) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6396](https://github.com/tobymao/sqlglot/issues/6396) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`9ddae4d`](https://github.com/tobymao/sqlglot/commit/9ddae4d56d1e3a15fc3b4b76ce3b3040683c220f) - **duckdb**: support IN with no paren *(PR [#6409](https://github.com/tobymao/sqlglot/pull/6409) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6407](https://github.com/tobymao/sqlglot/issues/6407) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`c7cb098`](https://github.com/tobymao/sqlglot/commit/c7cb0983a0fa463c43d2c4ee925816e9a1628c79) - **tokenizer**: Fix underscore separator with scientific notation *(PR [#6401](https://github.com/tobymao/sqlglot/pull/6401) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6393](https://github.com/tobymao/sqlglot/issues/6393) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`f5635d2`](https://github.com/tobymao/sqlglot/commit/f5635d2cc2a5612d6403bbf508b545f2a4e8f773) - **duckdb**: splice with col named after type closes [#6411](https://github.com/tobymao/sqlglot/pull/6411) *(commit by [@tobymao](https://github.com/tobymao))*
- [`097d865`](https://github.com/tobymao/sqlglot/commit/097d865554d9ba2e226962fa71778ae0a6c596cb) - **duckdb**: pivot using cast closes [#6410](https://github.com/tobymao/sqlglot/pull/6410) *(commit by [@tobymao](https://github.com/tobymao))*
- [`d038ad7`](https://github.com/tobymao/sqlglot/commit/d038ad7f036a140f3eae4bdde15824437d4e44ee) - **mysql**: support named primary keys for mysql *(PR [#6389](https://github.com/tobymao/sqlglot/pull/6389) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
  - :arrow_lower_right: *fixes issue [#6382](https://github.com/tobymao/sqlglot/issues/6382) opened by [@AndyVW77](https://github.com/AndyVW77)*
- [`4f3bb0d`](https://github.com/tobymao/sqlglot/commit/4f3bb0d6714bf89ff72e13e1398d8f01cefafb00) - **DuckDB**: Correct transpilation of BigQuery's JSON_EXTRACT_SCALAR… *(PR [#6414](https://github.com/tobymao/sqlglot/pull/6414) by [@vchan](https://github.com/vchan))*
- [`e2f306f`](https://github.com/tobymao/sqlglot/commit/e2f306f1893a3f565cbbf7857ffd9795850aba7b) - interval column ops closes [#6416](https://github.com/tobymao/sqlglot/pull/6416) *(commit by [@tobymao](https://github.com/tobymao))*
- [`8c314a8`](https://github.com/tobymao/sqlglot/commit/8c314a8b457a5c3ed470ac8fcff022fec881c248) - **duckdb**: support cte pivot for duckdb *(PR [#6413](https://github.com/tobymao/sqlglot/pull/6413) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
  - :arrow_lower_right: *fixes issue [#6405](https://github.com/tobymao/sqlglot/issues/6405) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`92ee124`](https://github.com/tobymao/sqlglot/commit/92ee1241ea3088d4e63c094404252339c54ad0c1) - **optimizer**: postgres qualify GENERATE_SERIES and table projection *(PR [#6373](https://github.com/tobymao/sqlglot/pull/6373) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6358](https://github.com/tobymao/sqlglot/issues/6358) opened by [@metahexane](https://github.com/metahexane)*

### :recycle: Refactors
- [`e4d1a4f`](https://github.com/tobymao/sqlglot/commit/e4d1a4fcd6741d679c5444bf023077d2aaa8f980) - **exasol**: map date/timestamp `TRUNC` to `DATE_TRUNC` *(PR [#6328](https://github.com/tobymao/sqlglot/pull/6328) by [@nnamdi16](https://github.com/nnamdi16))*
- [`c6b0a63`](https://github.com/tobymao/sqlglot/commit/c6b0a6342a21d79635a26d40001c916d05d47cf7) - change version to be a tuple so that it can be pickled, also simpler *(commit by [@tobymao](https://github.com/tobymao))*
- [`625654a`](https://github.com/tobymao/sqlglot/commit/625654a9623cc5407bfde922c29f32a8ee905a3b) - move resolver to own file *(commit by [@tobymao](https://github.com/tobymao))*

### :wrench: Chores
- [`487d218`](https://github.com/tobymao/sqlglot/commit/487d218a6fcad4e28c65c6df55435ba218826186) - iterative annotate types *(PR [#6342](https://github.com/tobymao/sqlglot/pull/6342) by [@geooo109](https://github.com/geooo109))*
- [`8201062`](https://github.com/tobymao/sqlglot/commit/8201062ac41b85e5a89aa8e1c5973852f105c66e) - clean up derived table traversal in table qualification *(PR [#6363](https://github.com/tobymao/sqlglot/pull/6363) by [@georgesittas](https://github.com/georgesittas))*
- [`6b7084d`](https://github.com/tobymao/sqlglot/commit/6b7084d0c9f4735432afc12509c77c286cc50513) - **optimizer**: refactor costly scope walking loop in qualify tables *(PR [#6364](https://github.com/tobymao/sqlglot/pull/6364) by [@georgesittas](https://github.com/georgesittas))*
- [`0319241`](https://github.com/tobymao/sqlglot/commit/0319241162bbe6d278a626100eac73999b250968) - **mysql,postgres**: tests for unsupported IGNORE/RESPECT NULLS *(PR [#6386](https://github.com/tobymao/sqlglot/pull/6386) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *addresses issue [#6376](https://github.com/tobymao/sqlglot/issues/6376) opened by [@NickCrews](https://github.com/NickCrews)*
- [`11354cc`](https://github.com/tobymao/sqlglot/commit/11354cc85d116cd24c28114a437111965ba828a9) - Make integration test workflow more robust *(PR [#6403](https://github.com/tobymao/sqlglot/pull/6403) by [@erindru](https://github.com/erindru))*
- [`f758cea`](https://github.com/tobymao/sqlglot/commit/f758cea0e9fca5850895a730c554c17b488d29ca) - **exasol**: transformed rank function, ignoring parameters *(PR [#6408](https://github.com/tobymao/sqlglot/pull/6408) by [@nnamdi16](https://github.com/nnamdi16))*
- [`07d9958`](https://github.com/tobymao/sqlglot/commit/07d99583b4aebdc682bb7604ccdf45bddb89f9c3) - **optimizer**: replace direct comparison with dialect properties *(PR [#6398](https://github.com/tobymao/sqlglot/pull/6398) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`137549e`](https://github.com/tobymao/sqlglot/commit/137549e5e803416d46e13e9a8123cef9b53d349a) - **exasol**: transform substring_index using substr and instr *(PR [#6406](https://github.com/tobymao/sqlglot/pull/6406) by [@nnamdi16](https://github.com/nnamdi16))*
- [`78f1824`](https://github.com/tobymao/sqlglot/commit/78f1824c790f523845cbda488ecf4c43a92ac0f0) - **exasol**: transform substring_index using substr and instr *(PR [#6406](https://github.com/tobymao/sqlglot/pull/6406) by [@nnamdi16](https://github.com/nnamdi16))*
- [`39cc555`](https://github.com/tobymao/sqlglot/commit/39cc55586ed76a4a583e6db22a9ee51e09bff92e) - **snowflake**: annotate type for COUNT *(PR [#6437](https://github.com/tobymao/sqlglot/pull/6437) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`61f39ba`](https://github.com/tobymao/sqlglot/commit/61f39bab9a0668c338e8c1b5e0fa953f22c0a886) - **optimizer**: improve error message for ambiguous columns *(PR [#6423](https://github.com/tobymao/sqlglot/pull/6423) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`313afe5`](https://github.com/tobymao/sqlglot/commit/313afe540aa2cdc4cc179c4852c6ef37362bcb3e) - **optimizer**: annotate type for snowflake func ARRAY_UNION_AGG *(PR [#6446](https://github.com/tobymao/sqlglot/pull/6446) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`b321ca6`](https://github.com/tobymao/sqlglot/commit/b321ca6191fefc88da1a6de83a465886b5754b7a) - bump sqlglotrs to 0.8.0 *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v28.0.0] - 2025-11-17
### :boom: BREAKING CHANGES
- due to [`39d8e19`](https://github.com/tobymao/sqlglot/commit/39d8e19419c2adbb80465be414d1cc3bbc6d007b) - include VARIABLE kind in SET transpilation to DuckDB *(PR [#6201](https://github.com/tobymao/sqlglot/pull/6201) by [@toriwei](https://github.com/toriwei))*:

  include VARIABLE kind in SET transpilation to DuckDB (#6201)

- due to [`e7ddad1`](https://github.com/tobymao/sqlglot/commit/e7ddad10b5edf9b801d2151e3e5fca448754df0d) - ensure `NULL` coerces into any type *(PR [#6211](https://github.com/tobymao/sqlglot/pull/6211) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  ensure `NULL` coerces into any type (#6211)

- due to [`0037266`](https://github.com/tobymao/sqlglot/commit/00372664bf6acf2b0fff9ad4b206b597ef5378f7) - annotate types for GETBIT *(PR [#6219](https://github.com/tobymao/sqlglot/pull/6219) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for GETBIT (#6219)

- due to [`a5458ce`](https://github.com/tobymao/sqlglot/commit/a5458ceca3bc239fb611791e38020632dd0824c8) - add type annotation for DECODE function support *(PR [#6199](https://github.com/tobymao/sqlglot/pull/6199) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add type annotation for DECODE function support (#6199)

- due to [`417f1e8`](https://github.com/tobymao/sqlglot/commit/417f1e8ee50fb8f4377fad261660ffbd7444a429) - annotate types for BITNOT *(PR [#6234](https://github.com/tobymao/sqlglot/pull/6234) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for BITNOT (#6234)

- due to [`fe8ab40`](https://github.com/tobymao/sqlglot/commit/fe8ab40e8e0559201e0b1896a6f1a8fb6b5b932d) - 1st-class parsing support for BITAND, BIT_AND, BIT_NOT *(PR [#6243](https://github.com/tobymao/sqlglot/pull/6243) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  1st-class parsing support for BITAND, BIT_AND, BIT_NOT (#6243)

- due to [`5ae3c47`](https://github.com/tobymao/sqlglot/commit/5ae3c47b1c6993b87341472c08714f4a0f738168) - add type annotation for GROUPING() function *(PR [#6244](https://github.com/tobymao/sqlglot/pull/6244) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add type annotation for GROUPING() function (#6244)

- due to [`4133265`](https://github.com/tobymao/sqlglot/commit/413326514507ef06537dcc3d4b80a3fcbcd26f66) - parse `has` function into an `ArrayContains` expression *(PR [#6245](https://github.com/tobymao/sqlglot/pull/6245) by [@joeyutong](https://github.com/joeyutong))*:

  parse `has` function into an `ArrayContains` expression (#6245)

- due to [`cdd45b9`](https://github.com/tobymao/sqlglot/commit/cdd45b949fd1eefb147053424279b56b8effcbcf) - annotate types for GROUPING_ID function. *(PR [#6249](https://github.com/tobymao/sqlglot/pull/6249) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotate types for GROUPING_ID function. (#6249)

- due to [`080ff3b`](https://github.com/tobymao/sqlglot/commit/080ff3bd93b36291d5bb0092d722f8307f0ae082) - annotate types for BITAND_AGG *(PR [#6248](https://github.com/tobymao/sqlglot/pull/6248) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for BITAND_AGG (#6248)

- due to [`87a818a`](https://github.com/tobymao/sqlglot/commit/87a818a899f61a675c22c697f468b3f6f7e2787f) - annotate types for BITOR_AGG  *(PR [#6251](https://github.com/tobymao/sqlglot/pull/6251) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for BITOR_AGG  (#6251)

- due to [`4c4189b`](https://github.com/tobymao/sqlglot/commit/4c4189b4083d272a6e678d83b5c567a2e9c0d672) - Transpile CONCAT function to double pipe operators when source … *(PR [#6241](https://github.com/tobymao/sqlglot/pull/6241) by [@vchan](https://github.com/vchan))*:

  Transpile CONCAT function to double pipe operators when source … (#6241)

- due to [`a1b884d`](https://github.com/tobymao/sqlglot/commit/a1b884dc9ddfd2185de48cc9451a39f152879d39) - annotate types for BITXOR_AGG *(PR [#6253](https://github.com/tobymao/sqlglot/pull/6253) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for BITXOR_AGG (#6253)

- due to [`fc78d20`](https://github.com/tobymao/sqlglot/commit/fc78d2016d8f7d20c094df791f746de323cd3639) - Unwrap subqueries without modifiers *(PR [#6247](https://github.com/tobymao/sqlglot/pull/6247) by [@VaggelisD](https://github.com/VaggelisD))*:

  Unwrap subqueries without modifiers (#6247)

- due to [`ad2ad23`](https://github.com/tobymao/sqlglot/commit/ad2ad234b5a508040dce4f3920439be052742573) - add missing return type mapping for MAX_BY and MAX_BY function *(PR [#6250](https://github.com/tobymao/sqlglot/pull/6250) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add missing return type mapping for MAX_BY and MAX_BY function (#6250)

- due to [`39c1d81`](https://github.com/tobymao/sqlglot/commit/39c1d81174f2390b6b0c9dd14c0e550ad452a1df) - annotate types for BOOLXOR_AGG *(PR [#6261](https://github.com/tobymao/sqlglot/pull/6261) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for BOOLXOR_AGG (#6261)

- due to [`71590d2`](https://github.com/tobymao/sqlglot/commit/71590d22cdb05594e2173a1500f763dc1a32a81d) - add type annotation for SKEW function. *(PR [#6262](https://github.com/tobymao/sqlglot/pull/6262) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add type annotation for SKEW function. (#6262)

- due to [`5fd366d`](https://github.com/tobymao/sqlglot/commit/5fd366d9e6f7b3f1eb7a9cf41975cf13ce890ffe) - annotate types for OBJECT_AGG *(PR [#6265](https://github.com/tobymao/sqlglot/pull/6265) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for OBJECT_AGG (#6265)

- due to [`00abc39`](https://github.com/tobymao/sqlglot/commit/00abc393c9042e839457c5a6582e95cdb74356f3) - handle casting for bytestrings  *(PR [#6252](https://github.com/tobymao/sqlglot/pull/6252) by [@toriwei](https://github.com/toriwei))*:

  handle casting for bytestrings  (#6252)

- due to [`3dae0fb`](https://github.com/tobymao/sqlglot/commit/3dae0fbb528762e5d5fd446350d42e9c841e2959) - Support position and occurrence args for REGEXP_EXTRACT *(PR [#6266](https://github.com/tobymao/sqlglot/pull/6266) by [@vchan](https://github.com/vchan))*:

  Support position and occurrence args for REGEXP_EXTRACT (#6266)

- due to [`ddea61d`](https://github.com/tobymao/sqlglot/commit/ddea61d83f6699c97cc7b25aabe01a138138bdb1) - simplify connector complements only for non-null operands *(PR [#6214](https://github.com/tobymao/sqlglot/pull/6214) by [@geooo109](https://github.com/geooo109))*:

  simplify connector complements only for non-null operands (#6214)

- due to [`771732d`](https://github.com/tobymao/sqlglot/commit/771732d81459cc576f11eccc49794f33e62d14af) - annotate types for REGR_AVGY *(PR [#6271](https://github.com/tobymao/sqlglot/pull/6271) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for REGR_AVGY (#6271)

- due to [`8470be0`](https://github.com/tobymao/sqlglot/commit/8470be00731a4d79518a533a5f7ba884fa2f047e) - add type annotation for BITMAP_COUNT function. *(PR [#6274](https://github.com/tobymao/sqlglot/pull/6274) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add type annotation for BITMAP_COUNT function. (#6274)

- due to [`98f25f9`](https://github.com/tobymao/sqlglot/commit/98f25f92cc1175ac7b2118a5a342db82adade13a) - support splitBy function *(PR [#6278](https://github.com/tobymao/sqlglot/pull/6278) by [@joeyutong](https://github.com/joeyutong))*:

  support splitBy function (#6278)

- due to [`fabbf05`](https://github.com/tobymao/sqlglot/commit/fabbf057aba88f30205767d8c339727de45991c8) - Add support for shorthand struct array literals in duckDB. *(PR [#6233](https://github.com/tobymao/sqlglot/pull/6233) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Add support for shorthand struct array literals in duckDB. (#6233)

- due to [`c02b64c`](https://github.com/tobymao/sqlglot/commit/c02b64c3524dd074c2108baaca668ab2607ac843) - Handle pseudocolumns differently than columns *(PR [#6273](https://github.com/tobymao/sqlglot/pull/6273) by [@VaggelisD](https://github.com/VaggelisD))*:

  Handle pseudocolumns differently than columns (#6273)

- due to [`05c5181`](https://github.com/tobymao/sqlglot/commit/05c5181b36a7ada32b96fc91bdfbf73b38a1a408) - refactor `Connector` simplification to factor in types *(PR [#6152](https://github.com/tobymao/sqlglot/pull/6152) by [@geooo109](https://github.com/geooo109))*:

  refactor `Connector` simplification to factor in types (#6152)

- due to [`9c1a222`](https://github.com/tobymao/sqlglot/commit/9c1a2221b0327ba6848542c7b906e92f25a05bea) - add type annotation for BITMAP_CONSTRUCT_AGG function. *(PR [#6285](https://github.com/tobymao/sqlglot/pull/6285) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add type annotation for BITMAP_CONSTRUCT_AGG function. (#6285)

- due to [`cb0bcff`](https://github.com/tobymao/sqlglot/commit/cb0bcff310e9acdf806fc98e99cb9938b747c771) - cast UUID() output to varchar when source dialect UUID() returns string *(PR [#6284](https://github.com/tobymao/sqlglot/pull/6284) by [@toriwei](https://github.com/toriwei))*:

  cast UUID() output to varchar when source dialect UUID() returns string (#6284)

- due to [`358105d`](https://github.com/tobymao/sqlglot/commit/358105d1296c7425e071ccf3189a31a02c00c923) - type annotation for BITMAP_BIT_POSITION function *(PR [#6301](https://github.com/tobymao/sqlglot/pull/6301) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  type annotation for BITMAP_BIT_POSITION function (#6301)

- due to [`4ee7a50`](https://github.com/tobymao/sqlglot/commit/4ee7a500cc460b6f6a1ed103a12dca72e6d01c18) - type inference for BITMAP_OR_AGG *(PR [#6297](https://github.com/tobymao/sqlglot/pull/6297) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  type inference for BITMAP_OR_AGG (#6297)

- due to [`fcd537d`](https://github.com/tobymao/sqlglot/commit/fcd537de2c993ad0bd18acd84dbae354165f7d3f) - conflict resolution. type annotation for BITMAP_BUCKET_NUMBER function. Tests added all dialects that support BITMAP_BUCKET_NUMBER *(PR [#6299](https://github.com/tobymao/sqlglot/pull/6299) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  conflict resolution. type annotation for BITMAP_BUCKET_NUMBER function. Tests added all dialects that support BITMAP_BUCKET_NUMBER (#6299)

- due to [`3dffd59`](https://github.com/tobymao/sqlglot/commit/3dffd598496a9f2d94caec9d7f3dcb9791c94019) - annotate types for PERCENTILE_DISC and WithinGroup *(PR [#6300](https://github.com/tobymao/sqlglot/pull/6300) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for PERCENTILE_DISC and WithinGroup (#6300)

- due to [`f9287f7`](https://github.com/tobymao/sqlglot/commit/f9287f7d596a6d8a1e1cd2c48978a4dec77a96cb) - robust deduplication of connectors *(PR [#6296](https://github.com/tobymao/sqlglot/pull/6296) by [@geooo109](https://github.com/geooo109))*:

  robust deduplication of connectors (#6296)

- due to [`ea0ea79`](https://github.com/tobymao/sqlglot/commit/ea0ea79c1c611b62c79f82f744fe0c98803598a3) - Parse `LIKE` functions *(PR [#6314](https://github.com/tobymao/sqlglot/pull/6314) by [@VaggelisD](https://github.com/VaggelisD))*:

  Parse `LIKE` functions (#6314)

- due to [`e903883`](https://github.com/tobymao/sqlglot/commit/e90388328fcf5b8061c99e325b87d5beb0046ffc) - type annotation for APPROX_TOP_K_ACCUMULATE functio… *(PR [#6309](https://github.com/tobymao/sqlglot/pull/6309) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  type annotation for APPROX_TOP_K_ACCUMULATE functio… (#6309)

- due to [`d3fefad`](https://github.com/tobymao/sqlglot/commit/d3fefad80d25ff5a6dd02426667ff0ea8478a1b2) - support `DATEDIFF_BIG` *(PR [#6323](https://github.com/tobymao/sqlglot/pull/6323) by [@lBilali](https://github.com/lBilali))*:

  support `DATEDIFF_BIG` (#6323)

- due to [`21d1468`](https://github.com/tobymao/sqlglot/commit/21d1468377b9c8ad48c6cca1ae3b3744a807c29e) - annotate type for APPROX_TOP_K *(PR [#6286](https://github.com/tobymao/sqlglot/pull/6286) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for APPROX_TOP_K (#6286)

- due to [`85ddcc5`](https://github.com/tobymao/sqlglot/commit/85ddcc5eca22ac726582de454f2f12b9d4877634) - Do not normalize JSON fields in dot notation *(PR [#6320](https://github.com/tobymao/sqlglot/pull/6320) by [@VaggelisD](https://github.com/VaggelisD))*:

  Do not normalize JSON fields in dot notation (#6320)

- due to [`933e981`](https://github.com/tobymao/sqlglot/commit/933e98102fb39d24ae0350da13337d981287130a) - more robust NULL reduction *(PR [#6327](https://github.com/tobymao/sqlglot/pull/6327) by [@geooo109](https://github.com/geooo109))*:

  more robust NULL reduction (#6327)


### :sparkles: New Features
- [`39d8e19`](https://github.com/tobymao/sqlglot/commit/39d8e19419c2adbb80465be414d1cc3bbc6d007b) - **snowflake**: include VARIABLE kind in SET transpilation to DuckDB *(PR [#6201](https://github.com/tobymao/sqlglot/pull/6201) by [@toriwei](https://github.com/toriwei))*
  - :arrow_lower_right: *addresses issue [#6177](https://github.com/tobymao/sqlglot/issues/6177) opened by [@baruchoxman](https://github.com/baruchoxman)*
- [`0037266`](https://github.com/tobymao/sqlglot/commit/00372664bf6acf2b0fff9ad4b206b597ef5378f7) - **snowflake**: annotate types for GETBIT *(PR [#6219](https://github.com/tobymao/sqlglot/pull/6219) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`a5458ce`](https://github.com/tobymao/sqlglot/commit/a5458ceca3bc239fb611791e38020632dd0824c8) - **snowflake**: add type annotation for DECODE function support *(PR [#6199](https://github.com/tobymao/sqlglot/pull/6199) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`a9d0f63`](https://github.com/tobymao/sqlglot/commit/a9d0f6333c38ffb0b5afc3c213ac7bf008d98ad6) - **DuckDB**: Transpile unix_millis to epoch_ms *(PR [#6224](https://github.com/tobymao/sqlglot/pull/6224) by [@vchan](https://github.com/vchan))*
- [`238f705`](https://github.com/tobymao/sqlglot/commit/238f705940751f09464ee0f8260186f3f8124374) - **DuckDB**: Transpile unix_seconds to epoch *(PR [#6225](https://github.com/tobymao/sqlglot/pull/6225) by [@vchan](https://github.com/vchan))*
- [`c8b0129`](https://github.com/tobymao/sqlglot/commit/c8b0129380df389be6ff22cafb4251181e919d23) - **exasol**: support bracket-delimited identifiers *(PR [#6231](https://github.com/tobymao/sqlglot/pull/6231) by [@JoepvandenHoven-Bluemine](https://github.com/JoepvandenHoven-Bluemine))*
- [`417f1e8`](https://github.com/tobymao/sqlglot/commit/417f1e8ee50fb8f4377fad261660ffbd7444a429) - **snowflake**: annotate types for BITNOT *(PR [#6234](https://github.com/tobymao/sqlglot/pull/6234) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`fe8ab40`](https://github.com/tobymao/sqlglot/commit/fe8ab40e8e0559201e0b1896a6f1a8fb6b5b932d) - **snowflake**: 1st-class parsing support for BITAND, BIT_AND, BIT_NOT *(PR [#6243](https://github.com/tobymao/sqlglot/pull/6243) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`5ae3c47`](https://github.com/tobymao/sqlglot/commit/5ae3c47b1c6993b87341472c08714f4a0f738168) - **snowflake**: add type annotation for GROUPING() function *(PR [#6244](https://github.com/tobymao/sqlglot/pull/6244) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`4133265`](https://github.com/tobymao/sqlglot/commit/413326514507ef06537dcc3d4b80a3fcbcd26f66) - **clickhouse**: parse `has` function into an `ArrayContains` expression *(PR [#6245](https://github.com/tobymao/sqlglot/pull/6245) by [@joeyutong](https://github.com/joeyutong))*
- [`b722aa2`](https://github.com/tobymao/sqlglot/commit/b722aa2d4b65c698921066426838f080a31bdc35) - **duckdb**: cast LOWER() result to BLOB if input is bytes *(PR [#6218](https://github.com/tobymao/sqlglot/pull/6218) by [@toriwei](https://github.com/toriwei))*
- [`cdd45b9`](https://github.com/tobymao/sqlglot/commit/cdd45b949fd1eefb147053424279b56b8effcbcf) - **optimizer**: annotate types for GROUPING_ID function. *(PR [#6249](https://github.com/tobymao/sqlglot/pull/6249) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`080ff3b`](https://github.com/tobymao/sqlglot/commit/080ff3bd93b36291d5bb0092d722f8307f0ae082) - **snowflake**: annotate types for BITAND_AGG *(PR [#6248](https://github.com/tobymao/sqlglot/pull/6248) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`87a818a`](https://github.com/tobymao/sqlglot/commit/87a818a899f61a675c22c697f468b3f6f7e2787f) - **snowflake**: annotate types for BITOR_AGG  *(PR [#6251](https://github.com/tobymao/sqlglot/pull/6251) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`a1b884d`](https://github.com/tobymao/sqlglot/commit/a1b884dc9ddfd2185de48cc9451a39f152879d39) - **snowflake**: annotate types for BITXOR_AGG *(PR [#6253](https://github.com/tobymao/sqlglot/pull/6253) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`71d93b1`](https://github.com/tobymao/sqlglot/commit/71d93b181d2aa3a77a022820446d6fec0133291f) - **duckdb**: implement casting to blob for UPPER() and move to helper method *(PR [#6254](https://github.com/tobymao/sqlglot/pull/6254) by [@toriwei](https://github.com/toriwei))*
- [`ad2ad23`](https://github.com/tobymao/sqlglot/commit/ad2ad234b5a508040dce4f3920439be052742573) - **snowflake**: add missing return type mapping for MAX_BY and MAX_BY function *(PR [#6250](https://github.com/tobymao/sqlglot/pull/6250) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`39c1d81`](https://github.com/tobymao/sqlglot/commit/39c1d81174f2390b6b0c9dd14c0e550ad452a1df) - **snowflake**: annotate types for BOOLXOR_AGG *(PR [#6261](https://github.com/tobymao/sqlglot/pull/6261) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`71590d2`](https://github.com/tobymao/sqlglot/commit/71590d22cdb05594e2173a1500f763dc1a32a81d) - **snowflake**: add type annotation for SKEW function. *(PR [#6262](https://github.com/tobymao/sqlglot/pull/6262) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`5fd366d`](https://github.com/tobymao/sqlglot/commit/5fd366d9e6f7b3f1eb7a9cf41975cf13ce890ffe) - **snowflake**: annotate types for OBJECT_AGG *(PR [#6265](https://github.com/tobymao/sqlglot/pull/6265) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`3dae0fb`](https://github.com/tobymao/sqlglot/commit/3dae0fbb528762e5d5fd446350d42e9c841e2959) - **duckdb**: Support position and occurrence args for REGEXP_EXTRACT *(PR [#6266](https://github.com/tobymao/sqlglot/pull/6266) by [@vchan](https://github.com/vchan))*
- [`dba0414`](https://github.com/tobymao/sqlglot/commit/dba04145c4bcda8c55890b4d7173dd6c0a64c37e) - **clickhouse**: Parse toStartOfxxx into exp.TimestampTrunc *(PR [#6268](https://github.com/tobymao/sqlglot/pull/6268) by [@joeyutong](https://github.com/joeyutong))*
- [`d959ad0`](https://github.com/tobymao/sqlglot/commit/d959ad02140d692483a63b67d69d2a5d49954ea3) - transpile DuckDB exclusive end RANGE to SEQUENCE *(PR [#6270](https://github.com/tobymao/sqlglot/pull/6270) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#6267](https://github.com/tobymao/sqlglot/issues/6267) opened by [@joeyutong](https://github.com/joeyutong)*
- [`771732d`](https://github.com/tobymao/sqlglot/commit/771732d81459cc576f11eccc49794f33e62d14af) - **snowflake**: annotate types for REGR_AVGY *(PR [#6271](https://github.com/tobymao/sqlglot/pull/6271) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`8470be0`](https://github.com/tobymao/sqlglot/commit/8470be00731a4d79518a533a5f7ba884fa2f047e) - **snowflake**: add type annotation for BITMAP_COUNT function. *(PR [#6274](https://github.com/tobymao/sqlglot/pull/6274) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`98f25f9`](https://github.com/tobymao/sqlglot/commit/98f25f92cc1175ac7b2118a5a342db82adade13a) - **clickhouse**: support splitBy function *(PR [#6278](https://github.com/tobymao/sqlglot/pull/6278) by [@joeyutong](https://github.com/joeyutong))*
- [`fabbf05`](https://github.com/tobymao/sqlglot/commit/fabbf057aba88f30205767d8c339727de45991c8) - **duckDB**: Add support for shorthand struct array literals in duckDB. *(PR [#6233](https://github.com/tobymao/sqlglot/pull/6233) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`a909fde`](https://github.com/tobymao/sqlglot/commit/a909fde068919823dc4cccc2655af48e4290137a) - **duckdb**: Add support for CREATE MACRO *(PR [#6292](https://github.com/tobymao/sqlglot/pull/6292) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#6290](https://github.com/tobymao/sqlglot/issues/6290) opened by [@francescomucio](https://github.com/francescomucio)*
- [`11989be`](https://github.com/tobymao/sqlglot/commit/11989be34153ccdedeab3ab18ccf735f86e8b822) - add more expressions with positional meta *(PR [#6289](https://github.com/tobymao/sqlglot/pull/6289) by [@tobymao](https://github.com/tobymao))*
- [`87651a6`](https://github.com/tobymao/sqlglot/commit/87651a671db2fe6162f06e2dcdef0b98e229bea5) - semantic facts closes [#6287](https://github.com/tobymao/sqlglot/pull/6287) *(PR [#6288](https://github.com/tobymao/sqlglot/pull/6288) by [@tobymao](https://github.com/tobymao))*
- [`9c1a222`](https://github.com/tobymao/sqlglot/commit/9c1a2221b0327ba6848542c7b906e92f25a05bea) - **snowflake**: add type annotation for BITMAP_CONSTRUCT_AGG function. *(PR [#6285](https://github.com/tobymao/sqlglot/pull/6285) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`358105d`](https://github.com/tobymao/sqlglot/commit/358105d1296c7425e071ccf3189a31a02c00c923) - **snowflake**: type annotation for BITMAP_BIT_POSITION function *(PR [#6301](https://github.com/tobymao/sqlglot/pull/6301) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`4ee7a50`](https://github.com/tobymao/sqlglot/commit/4ee7a500cc460b6f6a1ed103a12dca72e6d01c18) - **snowflake**: type inference for BITMAP_OR_AGG *(PR [#6297](https://github.com/tobymao/sqlglot/pull/6297) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`fcd537d`](https://github.com/tobymao/sqlglot/commit/fcd537de2c993ad0bd18acd84dbae354165f7d3f) - **snowflake**: conflict resolution. type annotation for BITMAP_BUCKET_NUMBER function. Tests added all dialects that support BITMAP_BUCKET_NUMBER *(PR [#6299](https://github.com/tobymao/sqlglot/pull/6299) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`3dffd59`](https://github.com/tobymao/sqlglot/commit/3dffd598496a9f2d94caec9d7f3dcb9791c94019) - **snowflake**: annotate types for PERCENTILE_DISC and WithinGroup *(PR [#6300](https://github.com/tobymao/sqlglot/pull/6300) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`6ce3cd7`](https://github.com/tobymao/sqlglot/commit/6ce3cd7de958d9f3773579ab22ae6cbbcb56ceb0) - **sqlite**: support binary `MATCH` operator closes [#6305](https://github.com/tobymao/sqlglot/pull/6305) *(PR [#6306](https://github.com/tobymao/sqlglot/pull/6306) by [@georgesittas](https://github.com/georgesittas))*
- [`e903883`](https://github.com/tobymao/sqlglot/commit/e90388328fcf5b8061c99e325b87d5beb0046ffc) - **snowflake**: type annotation for APPROX_TOP_K_ACCUMULATE functio… *(PR [#6309](https://github.com/tobymao/sqlglot/pull/6309) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`afc0242`](https://github.com/tobymao/sqlglot/commit/afc0242c564f8de53e11865c2fba43fb36df0694) - **duckDB**: Cast inputs (BLOB → VARCHAR) for duckDB STARTS_WITH *(PR [#6240](https://github.com/tobymao/sqlglot/pull/6240) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`d170bbd`](https://github.com/tobymao/sqlglot/commit/d170bbde800a0308aaf8c81e59152c65be312155) - **duckdb**: transpile bigquery's `BYTES` variant of `REPLACE` *(PR [#6312](https://github.com/tobymao/sqlglot/pull/6312) by [@toriwei](https://github.com/toriwei))*
- [`d3fefad`](https://github.com/tobymao/sqlglot/commit/d3fefad80d25ff5a6dd02426667ff0ea8478a1b2) - **tsql**: support `DATEDIFF_BIG` *(PR [#6323](https://github.com/tobymao/sqlglot/pull/6323) by [@lBilali](https://github.com/lBilali))*
- [`21d1468`](https://github.com/tobymao/sqlglot/commit/21d1468377b9c8ad48c6cca1ae3b3744a807c29e) - **optimizer**: annotate type for APPROX_TOP_K *(PR [#6286](https://github.com/tobymao/sqlglot/pull/6286) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`93b4039`](https://github.com/tobymao/sqlglot/commit/93b4039f957f3eefbaaed2cb147bfa8c8c2a304e) - **duckdb**: preserve time zone and timestamp in DATE_TRUNC() *(PR [#6318](https://github.com/tobymao/sqlglot/pull/6318) by [@toriwei](https://github.com/toriwei))*
- [`b71990f`](https://github.com/tobymao/sqlglot/commit/b71990f528d55c845f5771bfc4c5f6098eb97ad7) - **duckdb**: Add transpilation support for ANY_VALUE function with HAVING MAX and MIN clauses *(PR [#6325](https://github.com/tobymao/sqlglot/pull/6325) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`64c0d55`](https://github.com/tobymao/sqlglot/commit/64c0d554207ad40bcd6a93c20d15020752a5929d) - **sqlite**: support indexed table clause closes [#6331](https://github.com/tobymao/sqlglot/pull/6331) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`6725217`](https://github.com/tobymao/sqlglot/commit/6725217d4058b5202006576bdf6ff4ec7230a9b9) - **sqlite**: support `NOT NULL` operator closes [#6334](https://github.com/tobymao/sqlglot/pull/6334) closes [#6335](https://github.com/tobymao/sqlglot/pull/6335) *(commit by [@georgesittas](https://github.com/georgesittas))*

### :bug: Bug Fixes
- [`e7ddad1`](https://github.com/tobymao/sqlglot/commit/e7ddad10b5edf9b801d2151e3e5fca448754df0d) - **optimizer**: ensure `NULL` coerces into any type *(PR [#6211](https://github.com/tobymao/sqlglot/pull/6211) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`4c4189b`](https://github.com/tobymao/sqlglot/commit/4c4189b4083d272a6e678d83b5c567a2e9c0d672) - Transpile CONCAT function to double pipe operators when source … *(PR [#6241](https://github.com/tobymao/sqlglot/pull/6241) by [@vchan](https://github.com/vchan))*
- [`fc78d20`](https://github.com/tobymao/sqlglot/commit/fc78d2016d8f7d20c094df791f746de323cd3639) - **parser**: Unwrap subqueries without modifiers *(PR [#6247](https://github.com/tobymao/sqlglot/pull/6247) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6237](https://github.com/tobymao/sqlglot/issues/6237) opened by [@preet-sheth](https://github.com/preet-sheth)*
- [`7ad4c17`](https://github.com/tobymao/sqlglot/commit/7ad4c177fbf8dda78aa8de1ca112f606b2fd5456) - **databricks**: Support table names in FROM STREAM *(PR [#6259](https://github.com/tobymao/sqlglot/pull/6259) by [@roveo](https://github.com/roveo))*
- [`00abc39`](https://github.com/tobymao/sqlglot/commit/00abc393c9042e839457c5a6582e95cdb74356f3) - **generator**: handle casting for bytestrings  *(PR [#6252](https://github.com/tobymao/sqlglot/pull/6252) by [@toriwei](https://github.com/toriwei))*
- [`bcf2eac`](https://github.com/tobymao/sqlglot/commit/bcf2eace0baf1d85047841f36cb5c0082c61b29c) - **duckdb**: map int8 to bigint instead of tinyint fixes [#6269](https://github.com/tobymao/sqlglot/pull/6269) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`ddea61d`](https://github.com/tobymao/sqlglot/commit/ddea61d83f6699c97cc7b25aabe01a138138bdb1) - **optimizer**: simplify connector complements only for non-null operands *(PR [#6214](https://github.com/tobymao/sqlglot/pull/6214) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6213](https://github.com/tobymao/sqlglot/issues/6213) opened by [@geooo109](https://github.com/geooo109)*
- [`e17320e`](https://github.com/tobymao/sqlglot/commit/e17320ee3bdd0ef541d616c447b4973d12780dae) - Handle edge cases in  for DuckDB RANGE to Spark SEQUENCE transpilation *(PR [#6276](https://github.com/tobymao/sqlglot/pull/6276) by [@joeyutong](https://github.com/joeyutong))*
- [`33b6218`](https://github.com/tobymao/sqlglot/commit/33b62183a15cdedf0b1ebd96fcb856afbe8879a0) - sqlsecurityproperty parseerror *(PR [#6280](https://github.com/tobymao/sqlglot/pull/6280) by [@ds-cbo](https://github.com/ds-cbo))*
  - :arrow_lower_right: *fixes issue [#6279](https://github.com/tobymao/sqlglot/issues/6279) opened by [@ds-cbo](https://github.com/ds-cbo)*
- [`c02b64c`](https://github.com/tobymao/sqlglot/commit/c02b64c3524dd074c2108baaca668ab2607ac843) - **optimizer**: Handle pseudocolumns differently than columns *(PR [#6273](https://github.com/tobymao/sqlglot/pull/6273) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6256](https://github.com/tobymao/sqlglot/issues/6256) opened by [@azilya](https://github.com/azilya)*
- [`05c5181`](https://github.com/tobymao/sqlglot/commit/05c5181b36a7ada32b96fc91bdfbf73b38a1a408) - **optimizer**: refactor `Connector` simplification to factor in types *(PR [#6152](https://github.com/tobymao/sqlglot/pull/6152) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6137](https://github.com/tobymao/sqlglot/issues/6137) opened by [@dllggyx](https://github.com/dllggyx)*
- [`cb0bcff`](https://github.com/tobymao/sqlglot/commit/cb0bcff310e9acdf806fc98e99cb9938b747c771) - **duckdb**: cast UUID() output to varchar when source dialect UUID() returns string *(PR [#6284](https://github.com/tobymao/sqlglot/pull/6284) by [@toriwei](https://github.com/toriwei))*
- [`f9287f7`](https://github.com/tobymao/sqlglot/commit/f9287f7d596a6d8a1e1cd2c48978a4dec77a96cb) - **optimizer**: robust deduplication of connectors *(PR [#6296](https://github.com/tobymao/sqlglot/pull/6296) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6182](https://github.com/tobymao/sqlglot/issues/6182) opened by [@dllggyx](https://github.com/dllggyx)*
- [`ea0ea79`](https://github.com/tobymao/sqlglot/commit/ea0ea79c1c611b62c79f82f744fe0c98803598a3) - **clickhouse**: Parse `LIKE` functions *(PR [#6314](https://github.com/tobymao/sqlglot/pull/6314) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6313](https://github.com/tobymao/sqlglot/issues/6313) opened by [@CainYang](https://github.com/CainYang)*
- [`bbd4c90`](https://github.com/tobymao/sqlglot/commit/bbd4c901a9550beb363758e6be1e1877d4e56f2c) - **sqlite**: support IS with identifier as RHS *(PR [#6316](https://github.com/tobymao/sqlglot/pull/6316) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6315](https://github.com/tobymao/sqlglot/issues/6315) opened by [@VLDB2026](https://github.com/VLDB2026)*
- [`65d213a`](https://github.com/tobymao/sqlglot/commit/65d213a7662962d4226368590508fbf61675c055) - **dialect**: fix typo from millenium to millennium [#6321](https://github.com/tobymao/sqlglot/pull/6321) *(commit by [@lBilali](https://github.com/lBilali))*
- [`c9d1615`](https://github.com/tobymao/sqlglot/commit/c9d16150a408a41daf704d2d0b0ebfce57425b81) - **tsql**: map iso_week with the correct python directive from strftime *(PR [#6322](https://github.com/tobymao/sqlglot/pull/6322) by [@lBilali](https://github.com/lBilali))*
- [`85ddcc5`](https://github.com/tobymao/sqlglot/commit/85ddcc5eca22ac726582de454f2f12b9d4877634) - **bigquery**: Do not normalize JSON fields in dot notation *(PR [#6320](https://github.com/tobymao/sqlglot/pull/6320) by [@VaggelisD](https://github.com/VaggelisD))*
- [`933e981`](https://github.com/tobymao/sqlglot/commit/933e98102fb39d24ae0350da13337d981287130a) - **optimizer**: more robust NULL reduction *(PR [#6327](https://github.com/tobymao/sqlglot/pull/6327) by [@geooo109](https://github.com/geooo109))*
- [`e1c6d57`](https://github.com/tobymao/sqlglot/commit/e1c6d5716f80eb24b6d0a9c93e187a8c9f05e555) - **parser**: improve between .. preceding .. following parser fixes [#6332](https://github.com/tobymao/sqlglot/pull/6332) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`65706e8`](https://github.com/tobymao/sqlglot/commit/65706e8c7edeb7de674d427718eac181df206dc9) - avoid full traversal for pushdown_cte_alias_columns *(commit by [@tobymao](https://github.com/tobymao))*
- [`c81258e`](https://github.com/tobymao/sqlglot/commit/c81258e9c26f637f6f8520051c159685c8b1cb7e) - **parser**: allow using OVER token as unquoted identifier *(PR [#6338](https://github.com/tobymao/sqlglot/pull/6338) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6337](https://github.com/tobymao/sqlglot/issues/6337) opened by [@VLDB2026](https://github.com/VLDB2026)*
- [`73abfac`](https://github.com/tobymao/sqlglot/commit/73abfac4cec27350754c942be71175fa7bdfd1d0) - **redshift**: do not inherit postgres `ROUND` generator closes [#6340](https://github.com/tobymao/sqlglot/pull/6340) *(commit by [@georgesittas](https://github.com/georgesittas))*

### :recycle: Refactors
- [`9c98fc2`](https://github.com/tobymao/sqlglot/commit/9c98fc2b39fef2bd052b60ba4e15a4b93fd66c00) - **optimizer**: avoid extra copy in simplify *(commit by [@geooo109](https://github.com/geooo109))*
- [`43985fb`](https://github.com/tobymao/sqlglot/commit/43985fbcb9edea088119951c5c245a9606cf92ae) - **snowflake**: remove redundant tests for ANY_VALUE *(commit by [@geooo109](https://github.com/geooo109))*
- [`bf7b032`](https://github.com/tobymao/sqlglot/commit/bf7b032baae0c0fd112054a7bed6fa2f56f32890) - clean up struct name inheritance *(PR [#6295](https://github.com/tobymao/sqlglot/pull/6295) by [@georgesittas](https://github.com/georgesittas))*
- [`49e0f43`](https://github.com/tobymao/sqlglot/commit/49e0f43ba19739575987f2e9c52c2061a6f59717) - extra test for spark approx_top_k_accumulate *(commit by [@geooo109](https://github.com/geooo109))*

### :wrench: Chores
- [`d7be4a5`](https://github.com/tobymao/sqlglot/commit/d7be4a5da3dca6bcc44230b2a176c8b17b81c46e) - **optimizer**: add annotation test for COALESCE *(PR [#6210](https://github.com/tobymao/sqlglot/pull/6210) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`8aa7356`](https://github.com/tobymao/sqlglot/commit/8aa7356ab8adee26193086754ca1a1805957d944) - **optimizer**: add annotation tests for IFF *(PR [#6215](https://github.com/tobymao/sqlglot/pull/6215) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`160a1b9`](https://github.com/tobymao/sqlglot/commit/160a1b90f4ce39a2fce6f7f0e9e854d974fed053) - **optimizer**: mixed type annotation test for sf IFNULL *(commit by [@geooo109](https://github.com/geooo109))*
- [`893ad2a`](https://github.com/tobymao/sqlglot/commit/893ad2a5b1a28339ccc65c85ac813506e6ad56f1) - **optimizer**: add annotation tests for NULLIF *(PR [#6221](https://github.com/tobymao/sqlglot/pull/6221) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`78d7733`](https://github.com/tobymao/sqlglot/commit/78d77335819d1796fa3989ef072d3f8fd4b83559) - remove redundant or term for unknown in annotate_types *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`b202f3a`](https://github.com/tobymao/sqlglot/commit/b202f3ad64e88a47e52c45e32c9e4faae6c8ac45) - **optimizer**: add test for BITXOR *(PR [#6223](https://github.com/tobymao/sqlglot/pull/6223) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`b20f2e8`](https://github.com/tobymao/sqlglot/commit/b20f2e88d86038f1a98f4b97b5a2ae0b86652e33) - **optimizer**: add test for BITSHIFTLEFT *(PR [#6227](https://github.com/tobymao/sqlglot/pull/6227) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`7f93e85`](https://github.com/tobymao/sqlglot/commit/7f93e8551b00cc32014236a07c8794bd7a3a2b91) - **optimizer**: add annotation tests for BITSHIFTRIGHT *(PR [#6228](https://github.com/tobymao/sqlglot/pull/6228) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`fcf017c`](https://github.com/tobymao/sqlglot/commit/fcf017cfb95923fea8ae5669340713a326f4f306) - rename `EXPRESSION_SPEC` to `EXPRESSION_METADATA` *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`55bc9e4`](https://github.com/tobymao/sqlglot/commit/55bc9e4019f8ef8d7e571256d7b0e07b30d9240c) - remove predicate/connector/not from typing metadata *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`349ab29`](https://github.com/tobymao/sqlglot/commit/349ab29aa84fb087388b6a1494fea70273a4a560) - **optimizer**: add annotation test for BOOLAND_OR *(PR [#6260](https://github.com/tobymao/sqlglot/pull/6260) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`75ec424`](https://github.com/tobymao/sqlglot/commit/75ec424667b95462bb1750a251a5096da0d5161b) - **optimizer**: add annotation test for BOOLAND_AGG *(PR [#6257](https://github.com/tobymao/sqlglot/pull/6257) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`bb574aa`](https://github.com/tobymao/sqlglot/commit/bb574aa0cf0a8c0b92f9af7ef3dfddb7de725a8b) - **optimizer**: add annotation test for ARRAY_AGG *(PR [#6264](https://github.com/tobymao/sqlglot/pull/6264) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`a95c5cc`](https://github.com/tobymao/sqlglot/commit/a95c5ccf411dc4d28ef9c19fb03bd8a3615d7c4b) - **optimizer**: add nonnull clickhouse column test case *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`6d6c689`](https://github.com/tobymao/sqlglot/commit/6d6c68915ca699da7cb707675aece963df97f80b) - **optimizer**: add annotation tests for ANY_VALUE *(PR [#6275](https://github.com/tobymao/sqlglot/pull/6275) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`2459f88`](https://github.com/tobymao/sqlglot/commit/2459f8832ae398aa1381025724a4286f7f5e3e9d) - Follow up of 6280 *(PR [#6281](https://github.com/tobymao/sqlglot/pull/6281) by [@VaggelisD](https://github.com/VaggelisD))*
- [`a7d33d0`](https://github.com/tobymao/sqlglot/commit/a7d33d0e190fc5c9f23a1ab43082ac017d20fd18) - **optimizer**: add annotation tests for APPROX_PERCENTILE *(PR [#6283](https://github.com/tobymao/sqlglot/pull/6283) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`1b2d139`](https://github.com/tobymao/sqlglot/commit/1b2d139d3338c7053dee333914323236a2d15d97) - **optimizer**: add type annotation tests with window for sf APPROX_PERCENTILE *(commit by [@geooo109](https://github.com/geooo109))*
- [`d059648`](https://github.com/tobymao/sqlglot/commit/d05964851c99553ba06e318bbbda39f9851120db) - **optimizer**: add annotation tests for APPROX_COUNT_DISTINCT *(PR [#6282](https://github.com/tobymao/sqlglot/pull/6282) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`6bd59ac`](https://github.com/tobymao/sqlglot/commit/6bd59acf2288da5bfe6151c5adf6f2a63792dc1e) - Follow up of PR 6288 *(PR [#6293](https://github.com/tobymao/sqlglot/pull/6293) by [@VaggelisD](https://github.com/VaggelisD))*
- [`546fd2a`](https://github.com/tobymao/sqlglot/commit/546fd2a2588f7b385bdbb9e39490bd6a422283ca) - Remove dead line in qualify_columns *(PR [#6304](https://github.com/tobymao/sqlglot/pull/6304) by [@VaggelisD](https://github.com/VaggelisD))*
- [`ac7ac19`](https://github.com/tobymao/sqlglot/commit/ac7ac198a3b915e63ba8a055e9a0193c3dd3e26a) - **exasol**: Implement ODBC date time literals in Exasol Sqlglot *(PR [#6311](https://github.com/tobymao/sqlglot/pull/6311) by [@nnamdi16](https://github.com/nnamdi16))*
- [`8d1d25c`](https://github.com/tobymao/sqlglot/commit/8d1d25c6de7ad03c50e3efe892d16d16329d8ee9) - **exasol**: Implement local qualifier for-aliases, in GROUP BY, WHERE AND HAVING clause in exasol dialect *(PR [#6277](https://github.com/tobymao/sqlglot/pull/6277) by [@nnamdi16](https://github.com/nnamdi16))*
- [`509b0aa`](https://github.com/tobymao/sqlglot/commit/509b0aaada0e27542864771ba14777d398b6cee0) - **exasol**: Implement day_of_week function *(PR [#6319](https://github.com/tobymao/sqlglot/pull/6319) by [@nnamdi16](https://github.com/nnamdi16))*


## [v27.29.0] - 2025-10-29
### :boom: BREAKING CHANGES
- due to [`5242cdd`](https://github.com/tobymao/sqlglot/commit/5242cddf487e367e7f543ca19d9bccae858f36ac) - annotate type for bq LENGTH *(commit by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq LENGTH

- due to [`0fc6dbf`](https://github.com/tobymao/sqlglot/commit/0fc6dbf2e7b611fa0977e3c3e61be1cc84bcf4a9) - add GREATEST_IGNORE_NULLS function support *(PR [#6161](https://github.com/tobymao/sqlglot/pull/6161) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  add GREATEST_IGNORE_NULLS function support (#6161)

- due to [`d382a31`](https://github.com/tobymao/sqlglot/commit/d382a3106d5ce2e9b75527aacd4a37d1f8e16d18) - simplify double negation only if the inner expr is BOOLEAN *(PR [#6151](https://github.com/tobymao/sqlglot/pull/6151) by [@geooo109](https://github.com/geooo109))*:

  simplify double negation only if the inner expr is BOOLEAN (#6151)

- due to [`bcf6c89`](https://github.com/tobymao/sqlglot/commit/bcf6c89a47abd3c2c4383d1c908f892b6619b6fa) - add type annotation tests for snowflake BOOLAND *(PR [#6153](https://github.com/tobymao/sqlglot/pull/6153) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  add type annotation tests for snowflake BOOLAND (#6153)

- due to [`52d1eec`](https://github.com/tobymao/sqlglot/commit/52d1eecaad505703e8b22dcfe8954652f57985b6) - Annotate type for snowflake TIMESTAMP_FROM_PARTS function *(PR [#6139](https://github.com/tobymao/sqlglot/pull/6139) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TIMESTAMP_FROM_PARTS function (#6139)

- due to [`8651fe6`](https://github.com/tobymao/sqlglot/commit/8651fe6526dea865c0d54d6d53086359a7835d32) - annotate types for BOOLOR *(PR [#6159](https://github.com/tobymao/sqlglot/pull/6159) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for BOOLOR (#6159)

- due to [`812ba9a`](https://github.com/tobymao/sqlglot/commit/812ba9abad8247df81c8f8b514336c8766292112) - Annotate type for snowflake date parts functions *(PR [#6158](https://github.com/tobymao/sqlglot/pull/6158) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  Annotate type for snowflake date parts functions (#6158)

- due to [`9f8c123`](https://github.com/tobymao/sqlglot/commit/9f8c123ae44249e274334d0aa551ac33814f2b32) - make qualify table callback more generic *(PR [#6171](https://github.com/tobymao/sqlglot/pull/6171) by [@tobymao](https://github.com/tobymao))*:

  make qualify table callback more generic (#6171)

- due to [`74b4e7c`](https://github.com/tobymao/sqlglot/commit/74b4e7c311e9d4ff39ce2e4d91940eced96aa32f) - fix type annotation for Snowflake BOOLOR and BOOLAND *(PR [#6169](https://github.com/tobymao/sqlglot/pull/6169) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  fix type annotation for Snowflake BOOLOR and BOOLAND (#6169)

- due to [`ef87520`](https://github.com/tobymao/sqlglot/commit/ef875204596b8529f3358025c7a61d757a999bdc) - Transpile `REGEXP_REPLACE` with 'g' option *(PR [#6174](https://github.com/tobymao/sqlglot/pull/6174) by [@VaggelisD](https://github.com/VaggelisD))*:

  Transpile `REGEXP_REPLACE` with 'g' option (#6174)

- due to [`93071e2`](https://github.com/tobymao/sqlglot/commit/93071e255406f62ea83dd89a3be4871b7edfb3fe) - Fix simplify_parens from removing negated *(PR [#6194](https://github.com/tobymao/sqlglot/pull/6194) by [@VaggelisD](https://github.com/VaggelisD))*:

  Fix simplify_parens from removing negated (#6194)

- due to [`e90168a`](https://github.com/tobymao/sqlglot/commit/e90168a6829b85534edcecec7d0df2a8b1b56fc4) - annotate type for Snowflake's `IS_NULL_VALUE` function *(PR [#6186](https://github.com/tobymao/sqlglot/pull/6186) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotate type for Snowflake's `IS_NULL_VALUE` function (#6186)

- due to [`c93b535`](https://github.com/tobymao/sqlglot/commit/c93b5354827282c806899c36b11e7a7598e96e38) - annotate type for LEAST_IGNORE_NULLS *(PR [#6196](https://github.com/tobymao/sqlglot/pull/6196) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  annotate type for LEAST_IGNORE_NULLS (#6196)

- due to [`f60c71f`](https://github.com/tobymao/sqlglot/commit/f60c71fb03db91bfe90430d032ac16f4945d5dff) - annotate types for REGR_VALX *(PR [#6198](https://github.com/tobymao/sqlglot/pull/6198) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for REGR_VALX (#6198)

- due to [`b82c571`](https://github.com/tobymao/sqlglot/commit/b82c57131707297abe174539023b9cb62b7cd6c7) - annotate types for REGR_VALY *(PR [#6206](https://github.com/tobymao/sqlglot/pull/6206) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate types for REGR_VALY (#6206)


### :sparkles: New Features
- [`5242cdd`](https://github.com/tobymao/sqlglot/commit/5242cddf487e367e7f543ca19d9bccae858f36ac) - **optimizer**: annotate type for bq LENGTH *(commit by [@geooo109](https://github.com/geooo109))*
- [`0fc6dbf`](https://github.com/tobymao/sqlglot/commit/0fc6dbf2e7b611fa0977e3c3e61be1cc84bcf4a9) - **snowflake**: add GREATEST_IGNORE_NULLS function support *(PR [#6161](https://github.com/tobymao/sqlglot/pull/6161) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`54ecadc`](https://github.com/tobymao/sqlglot/commit/54ecadc57b8f1e87fd2a2ba35a5366d75231ea85) - **duckdb**: support `KV_METADATA` in `COPY` statement closes [#6165](https://github.com/tobymao/sqlglot/pull/6165) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`e241964`](https://github.com/tobymao/sqlglot/commit/e2419642a4966a4da194147aa488793eae152af4) - **duckdb**: support `USING` condition for `MERGE` closes [#6162](https://github.com/tobymao/sqlglot/pull/6162) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`bcf6c89`](https://github.com/tobymao/sqlglot/commit/bcf6c89a47abd3c2c4383d1c908f892b6619b6fa) - **optimizer**: add type annotation tests for snowflake BOOLAND *(PR [#6153](https://github.com/tobymao/sqlglot/pull/6153) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`52d1eec`](https://github.com/tobymao/sqlglot/commit/52d1eecaad505703e8b22dcfe8954652f57985b6) - **optimizer**: Annotate type for snowflake TIMESTAMP_FROM_PARTS function *(PR [#6139](https://github.com/tobymao/sqlglot/pull/6139) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`8651fe6`](https://github.com/tobymao/sqlglot/commit/8651fe6526dea865c0d54d6d53086359a7835d32) - **optimizer**: annotate types for BOOLOR *(PR [#6159](https://github.com/tobymao/sqlglot/pull/6159) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`812ba9a`](https://github.com/tobymao/sqlglot/commit/812ba9abad8247df81c8f8b514336c8766292112) - **optimizer**: Annotate type for snowflake date parts functions *(PR [#6158](https://github.com/tobymao/sqlglot/pull/6158) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`9f8c123`](https://github.com/tobymao/sqlglot/commit/9f8c123ae44249e274334d0aa551ac33814f2b32) - make qualify table callback more generic *(PR [#6171](https://github.com/tobymao/sqlglot/pull/6171) by [@tobymao](https://github.com/tobymao))*
- [`74b4e7c`](https://github.com/tobymao/sqlglot/commit/74b4e7c311e9d4ff39ce2e4d91940eced96aa32f) - **optimizer**: fix type annotation for Snowflake BOOLOR and BOOLAND *(PR [#6169](https://github.com/tobymao/sqlglot/pull/6169) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`e90168a`](https://github.com/tobymao/sqlglot/commit/e90168a6829b85534edcecec7d0df2a8b1b56fc4) - **optimizer**: annotate type for Snowflake's `IS_NULL_VALUE` function *(PR [#6186](https://github.com/tobymao/sqlglot/pull/6186) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`cea2595`](https://github.com/tobymao/sqlglot/commit/cea25952c98e70f2a4c35e675fe7ee4df0af02cd) - **duckdb**: Transpile DATE function from BQ->DuckDB *(PR [#6178](https://github.com/tobymao/sqlglot/pull/6178) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`00aaa47`](https://github.com/tobymao/sqlglot/commit/00aaa47feff1cf9e69320074c35d9adfc8538026) - **duckDB**: Transpile BigQuery's CURRENT_DATE (Conversion) function to DuckDB *(PR [#6189](https://github.com/tobymao/sqlglot/pull/6189) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`c93b535`](https://github.com/tobymao/sqlglot/commit/c93b5354827282c806899c36b11e7a7598e96e38) - **snowflake**: annotate type for LEAST_IGNORE_NULLS *(PR [#6196](https://github.com/tobymao/sqlglot/pull/6196) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`d2162fb`](https://github.com/tobymao/sqlglot/commit/d2162fbece0747b8ee42fa1f78e26baa0c944d41) - check same ref on Expression.__eq__ *(PR [#6200](https://github.com/tobymao/sqlglot/pull/6200) by [@georgesittas](https://github.com/georgesittas))*
- [`f60c71f`](https://github.com/tobymao/sqlglot/commit/f60c71fb03db91bfe90430d032ac16f4945d5dff) - **optimizer**: annotate types for REGR_VALX *(PR [#6198](https://github.com/tobymao/sqlglot/pull/6198) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`42e0ae4`](https://github.com/tobymao/sqlglot/commit/42e0ae43b3531bf6c593bcac2ece2ab1d969e5e1) - **duckdb**: transpile BigQuery function TIMESTAMP_SUB to DuckDB *(PR [#6202](https://github.com/tobymao/sqlglot/pull/6202) by [@toriwei](https://github.com/toriwei))*
- [`b82c571`](https://github.com/tobymao/sqlglot/commit/b82c57131707297abe174539023b9cb62b7cd6c7) - **snowflake**: annotate types for REGR_VALY *(PR [#6206](https://github.com/tobymao/sqlglot/pull/6206) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*

### :bug: Bug Fixes
- [`3acf796`](https://github.com/tobymao/sqlglot/commit/3acf7965105a098fea6336df0c304d94acbd05ec) - **duckdb**: Allow ESCAPE NULL *(PR [#6164](https://github.com/tobymao/sqlglot/pull/6164) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6160](https://github.com/tobymao/sqlglot/issues/6160) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`f7f1fca`](https://github.com/tobymao/sqlglot/commit/f7f1fca39a75df16ebb93f038e6277a25b8be6b9) - **duckdb**: Support positional index in list comprehension *(PR [#6163](https://github.com/tobymao/sqlglot/pull/6163) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6156](https://github.com/tobymao/sqlglot/issues/6156) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`d382a31`](https://github.com/tobymao/sqlglot/commit/d382a3106d5ce2e9b75527aacd4a37d1f8e16d18) - **optimizer**: simplify double negation only if the inner expr is BOOLEAN *(PR [#6151](https://github.com/tobymao/sqlglot/pull/6151) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6129](https://github.com/tobymao/sqlglot/issues/6129) opened by [@dllggyx](https://github.com/dllggyx)*
- [`dfe6b3c`](https://github.com/tobymao/sqlglot/commit/dfe6b3c8e6db40e22e626e2d56e9a7008dd75c32) - **optimizer**: Disambiguate JOIN ON columns during qualify *(PR [#6155](https://github.com/tobymao/sqlglot/pull/6155) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6132](https://github.com/tobymao/sqlglot/issues/6132) opened by [@Fosly](https://github.com/Fosly)*
- [`f267ece`](https://github.com/tobymao/sqlglot/commit/f267ecea92b0751f6b35a4ad0c70fe6754e49038) - normalize before qualifying tables *(PR [#6176](https://github.com/tobymao/sqlglot/pull/6176) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6167](https://github.com/tobymao/sqlglot/issues/6167) opened by [@schelip](https://github.com/schelip)*
- [`ef87520`](https://github.com/tobymao/sqlglot/commit/ef875204596b8529f3358025c7a61d757a999bdc) - **postgres, duckdb**: Transpile `REGEXP_REPLACE` with 'g' option *(PR [#6174](https://github.com/tobymao/sqlglot/pull/6174) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6170](https://github.com/tobymao/sqlglot/issues/6170) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`51a8d70`](https://github.com/tobymao/sqlglot/commit/51a8d700a9602278d1e98425af0fa87d02c739fe) - **parser**: allow LIMIT % OFFSET *(PR [#6184](https://github.com/tobymao/sqlglot/pull/6184) by [@toriwei](https://github.com/toriwei))*
  - :arrow_lower_right: *fixes issue [#6166](https://github.com/tobymao/sqlglot/issues/6166) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`8bf0a9f`](https://github.com/tobymao/sqlglot/commit/8bf0a9fe8e167984dc2e7b43d52d3850e063da3f) - **duckdb**: Cast literal arg to timestamp for epoch_us function *(PR [#6190](https://github.com/tobymao/sqlglot/pull/6190) by [@vchan](https://github.com/vchan))*
- [`93071e2`](https://github.com/tobymao/sqlglot/commit/93071e255406f62ea83dd89a3be4871b7edfb3fe) - **optimizer**: Fix simplify_parens from removing negated *(PR [#6194](https://github.com/tobymao/sqlglot/pull/6194) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6179](https://github.com/tobymao/sqlglot/issues/6179) opened by [@dllggyx](https://github.com/dllggyx)*
- [`2ac3a03`](https://github.com/tobymao/sqlglot/commit/2ac3a03409d9239d0cf7fb265843d7837a0a3fcd) - **lineage**: correct star detection and add join star tests *(PR [#6185](https://github.com/tobymao/sqlglot/pull/6185) by [@lancewl](https://github.com/lancewl))*
- [`c9ae2eb`](https://github.com/tobymao/sqlglot/commit/c9ae2ebdb86abdb767f2fcb00da0b6277b4aea45) - **duckdb**: transpile BigQuery TIMESTAMP_ADD to duckdb *(PR [#6188](https://github.com/tobymao/sqlglot/pull/6188) by [@toriwei](https://github.com/toriwei))*
- [`ba0e17a`](https://github.com/tobymao/sqlglot/commit/ba0e17a25af417e24162bfab49c3074454a5c1a8) - **snowflake**: Transpile `ARRAY_CONCAT_AGG` to `ARRAY_FLATTEN(ARRAY_AGG(...))` *(PR [#6192](https://github.com/tobymao/sqlglot/pull/6192) by [@ozadari](https://github.com/ozadari))*
- [`730e4cc`](https://github.com/tobymao/sqlglot/commit/730e4cc5b77bff9135667193cc0a65c24cdfb6b5) - **trino**: Allow 2nd arg for FIRST/LAST functions *(PR [#6205](https://github.com/tobymao/sqlglot/pull/6205) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6204](https://github.com/tobymao/sqlglot/issues/6204) opened by [@Harmuth94](https://github.com/Harmuth94)*

### :recycle: Refactors
- [`6d775fd`](https://github.com/tobymao/sqlglot/commit/6d775fdb6091cb866c27c0f1141514b23d689284) - snowflake GREATEST type checks *(commit by [@geooo109](https://github.com/geooo109))*
- [`e797fb1`](https://github.com/tobymao/sqlglot/commit/e797fb105f7fa4e7bd42698eda71037cae9fd155) - update `LIKE` operator when using functional syntax with spark dialect *(PR [#6173](https://github.com/tobymao/sqlglot/pull/6173) by [@themattmorris](https://github.com/themattmorris))*
  - :arrow_lower_right: *addresses issue [#6172](https://github.com/tobymao/sqlglot/issues/6172) opened by [@themattmorris](https://github.com/themattmorris)*

### :wrench: Chores
- [`aca106c`](https://github.com/tobymao/sqlglot/commit/aca106c660b8aaf229065ec5c5a4a80d10e8daf6) - **optimizer**: add type annotation tests for snowflake GREATEST *(PR [#6157](https://github.com/tobymao/sqlglot/pull/6157) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`f763604`](https://github.com/tobymao/sqlglot/commit/f7636041d7b796545ed923ffd4803521f05fa7ea) - add `IS [NOT]` tests *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`1ab5854`](https://github.com/tobymao/sqlglot/commit/1ab5854216da591e6036ac103239ac0280e09c3d) - **optimizer**: add snowflake test for [NOT] IN *(PR [#6180](https://github.com/tobymao/sqlglot/pull/6180) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`64939ce`](https://github.com/tobymao/sqlglot/commit/64939ce9926f4740387a151311e918e807bfa681) - **optimizer**: add annotation tests for ZEROIFNULL *(PR [#6187](https://github.com/tobymao/sqlglot/pull/6187) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`4b6bcdd`](https://github.com/tobymao/sqlglot/commit/4b6bcdd4dc297bd42ad000ffda98d14110565dc9) - **optimizer**: Add tests for snowflake's `NULLIFZERO` *(PR [#6197](https://github.com/tobymao/sqlglot/pull/6197) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`ef68075`](https://github.com/tobymao/sqlglot/commit/ef680756c33da180ed2f21fb6113a0123db341c9) - **optimizer**: add annotation tests for NVL2 *(PR [#6208](https://github.com/tobymao/sqlglot/pull/6208) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`7f550f2`](https://github.com/tobymao/sqlglot/commit/7f550f22da40d8c1cfc8afb183d6e4dbd50241ea) - **optimizer**: add annotation tests for NVL *(PR [#6207](https://github.com/tobymao/sqlglot/pull/6207) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*


## [v27.28.0] - 2025-10-21
### :boom: BREAKING CHANGES
- due to [`2238ac2`](https://github.com/tobymao/sqlglot/commit/2238ac27478bd272ba39928bbec1075c4191ee1b) - transpile timestamp literals in datediff fixes [#6083](https://github.com/tobymao/sqlglot/pull/6083) *(PR [#6086](https://github.com/tobymao/sqlglot/pull/6086) by [@georgesittas](https://github.com/georgesittas))*:

  transpile timestamp literals in datediff fixes #6083 (#6086)

- due to [`c49ba0e`](https://github.com/tobymao/sqlglot/commit/c49ba0eee21f7776703d2a26c6641b4a32a1cff7) - Annotate type for snowflake WIDTH_BUCKET function *(PR [#6078](https://github.com/tobymao/sqlglot/pull/6078) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake WIDTH_BUCKET function (#6078)

- due to [`fbc1f13`](https://github.com/tobymao/sqlglot/commit/fbc1f1335eecaaaab4fc93ddbb74611a4df0aea7) - annotate type for Snowflake CONVERT_TIMEZONE function *(PR [#6076](https://github.com/tobymao/sqlglot/pull/6076) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake CONVERT_TIMEZONE function (#6076)

- due to [`70e977c`](https://github.com/tobymao/sqlglot/commit/70e977c5edfb495529d38a9096cb40762a9b5d7b) - annotate type for Snowflake DATE_TRUNC function *(PR [#6080](https://github.com/tobymao/sqlglot/pull/6080) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake DATE_TRUNC function (#6080)

- due to [`e9cf146`](https://github.com/tobymao/sqlglot/commit/e9cf146a4a6cd78f6a59c195e7ec12240b836e5e) - annotate type for Snowflake DATE_PART function *(PR [#6079](https://github.com/tobymao/sqlglot/pull/6079) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake DATE_PART function (#6079)

- due to [`5109890`](https://github.com/tobymao/sqlglot/commit/510989043d18baa17502a971262462814a2eb5be) - VALUES with ORDER BY/LIMIT/OFFSET *(PR [#6094](https://github.com/tobymao/sqlglot/pull/6094) by [@geooo109](https://github.com/geooo109))*:

  VALUES with ORDER BY/LIMIT/OFFSET (#6094)

- due to [`6fe5824`](https://github.com/tobymao/sqlglot/commit/6fe58247888c326093618657fb027e482d82d107) - Annotate type for hour, minute, second functions *(PR [#6100](https://github.com/tobymao/sqlglot/pull/6100) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for hour, minute, second functions (#6100)

- due to [`a4d07a0`](https://github.com/tobymao/sqlglot/commit/a4d07a07eefbdaf88d30df2310a9533afdc75a82) - Annotate type for snowflake EXTRACT function *(PR [#6099](https://github.com/tobymao/sqlglot/pull/6099) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake EXTRACT function (#6099)

- due to [`483770b`](https://github.com/tobymao/sqlglot/commit/483770b816fab14b7eb7222974ed2c99045302a7) - Annotate type for snowflake TIME_SLICE function *(PR [#6098](https://github.com/tobymao/sqlglot/pull/6098) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TIME_SLICE function (#6098)

- due to [`06f40f9`](https://github.com/tobymao/sqlglot/commit/06f40f900ce693ba4203514e422cba8cda0dbb07) - don't simplify x XOR x due to NULL semantics *(PR [#6115](https://github.com/tobymao/sqlglot/pull/6115) by [@geooo109](https://github.com/geooo109))*:

  don't simplify x XOR x due to NULL semantics (#6115)

- due to [`c286cee`](https://github.com/tobymao/sqlglot/commit/c286cee54ab93e1fd0b3be658f7e767e3e00afe9) - Annotate type for snowflake MONTHNAME function *(PR [#6116](https://github.com/tobymao/sqlglot/pull/6116) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake MONTHNAME function (#6116)

- due to [`1a34788`](https://github.com/tobymao/sqlglot/commit/1a34788025bdd8a018c4bb9214f72152e68bdd14) - Annotate type for snowflake PREVIOUS_DAY function *(PR [#6117](https://github.com/tobymao/sqlglot/pull/6117) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake PREVIOUS_DAY function (#6117)

- due to [`533faf8`](https://github.com/tobymao/sqlglot/commit/533faf87b6df351070b565dd1fe9ce4e13b6c46e) - transpile duckdb `READ_PARQUET` to `parquet.<path>` closes [#6122](https://github.com/tobymao/sqlglot/pull/6122) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  transpile duckdb `READ_PARQUET` to `parquet.<path>` closes #6122

- due to [`cd4e557`](https://github.com/tobymao/sqlglot/commit/cd4e557658b1384f36c9a1ef9da5a09b893229b1) - Annotate type for snowflake RANDOM function *(PR [#6124](https://github.com/tobymao/sqlglot/pull/6124) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  Annotate type for snowflake RANDOM function (#6124)

- due to [`fe63d84`](https://github.com/tobymao/sqlglot/commit/fe63d84f1bd365b22221f348d79c0546aa3118b0) - annotate type for Snowflake MONTHS_BETWEEN function *(PR [#6120](https://github.com/tobymao/sqlglot/pull/6120) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*:

  annotate type for Snowflake MONTHS_BETWEEN function (#6120)

- due to [`598d09b`](https://github.com/tobymao/sqlglot/commit/598d09b036d938c90a44955d67175ea868090ba2) - annotate type for Snowflake DATEADD function *(PR [#6089](https://github.com/tobymao/sqlglot/pull/6089) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake DATEADD function (#6089)

- due to [`b98bcee`](https://github.com/tobymao/sqlglot/commit/b98bcee148ba426816e166dbfa9ba8e0979aae21) - Annotate type for snowflake next_day function *(PR [#6125](https://github.com/tobymao/sqlglot/pull/6125) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*:

  Annotate type for snowflake next_day function (#6125)

- due to [`e2129c6`](https://github.com/tobymao/sqlglot/commit/e2129c6766ca1f10ff6663bec98be984abb33c91) - Do not consider BIT_COUNT an aggregate function *(PR [#6135](https://github.com/tobymao/sqlglot/pull/6135) by [@VaggelisD](https://github.com/VaggelisD))*:

  Do not consider BIT_COUNT an aggregate function (#6135)

- due to [`d136414`](https://github.com/tobymao/sqlglot/commit/d136414e520270ac9ab2fd8e9df4691d269b3af0) - avoid simplifying AND with NULL *(PR [#6148](https://github.com/tobymao/sqlglot/pull/6148) by [@geooo109](https://github.com/geooo109))*:

  avoid simplifying AND with NULL (#6148)

- due to [`3a334f3`](https://github.com/tobymao/sqlglot/commit/3a334f376b9766b6b99fdf195ae763bb44976ec4) - annotate type for boolnot snowflake function *(PR [#6141](https://github.com/tobymao/sqlglot/pull/6141) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*:

  annotate type for boolnot snowflake function (#6141)

- due to [`99949cc`](https://github.com/tobymao/sqlglot/commit/99949ccd3ff81b524edeae437d874b86250dbb5b) - avoid needlessly copying in lineage *(PR [#6150](https://github.com/tobymao/sqlglot/pull/6150) by [@georgesittas](https://github.com/georgesittas))*:

  avoid needlessly copying in lineage (#6150)

- due to [`4e36f9d`](https://github.com/tobymao/sqlglot/commit/4e36f9dd6a854b378c9bbf6b2e9811045affc63d) - Annotate type for snowflake TIMEADD function *(PR [#6134](https://github.com/tobymao/sqlglot/pull/6134) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TIMEADD function (#6134)


### :sparkles: New Features
- [`c49ba0e`](https://github.com/tobymao/sqlglot/commit/c49ba0eee21f7776703d2a26c6641b4a32a1cff7) - **optimizer**: Annotate type for snowflake WIDTH_BUCKET function *(PR [#6078](https://github.com/tobymao/sqlglot/pull/6078) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`fbc1f13`](https://github.com/tobymao/sqlglot/commit/fbc1f1335eecaaaab4fc93ddbb74611a4df0aea7) - **optimizer**: annotate type for Snowflake CONVERT_TIMEZONE function *(PR [#6076](https://github.com/tobymao/sqlglot/pull/6076) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`70e977c`](https://github.com/tobymao/sqlglot/commit/70e977c5edfb495529d38a9096cb40762a9b5d7b) - **optimizer**: annotate type for Snowflake DATE_TRUNC function *(PR [#6080](https://github.com/tobymao/sqlglot/pull/6080) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`e9cf146`](https://github.com/tobymao/sqlglot/commit/e9cf146a4a6cd78f6a59c195e7ec12240b836e5e) - **optimizer**: annotate type for Snowflake DATE_PART function *(PR [#6079](https://github.com/tobymao/sqlglot/pull/6079) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`cdf3b1b`](https://github.com/tobymao/sqlglot/commit/cdf3b1b34dc044064d0a5ba7ff22723b8ae33e5d) - **optimizer**: Annotate type for snowflake add_months function *(PR [#6097](https://github.com/tobymao/sqlglot/pull/6097) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`6fe5824`](https://github.com/tobymao/sqlglot/commit/6fe58247888c326093618657fb027e482d82d107) - **optimizer**: Annotate type for hour, minute, second functions *(PR [#6100](https://github.com/tobymao/sqlglot/pull/6100) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`483770b`](https://github.com/tobymao/sqlglot/commit/483770b816fab14b7eb7222974ed2c99045302a7) - **optimizer**: Annotate type for snowflake TIME_SLICE function *(PR [#6098](https://github.com/tobymao/sqlglot/pull/6098) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`071a995`](https://github.com/tobymao/sqlglot/commit/071a9954aad220c1e13ba7a6714a083058a8e03f) - **tsql**: add support for iso_week on DATEPART *(PR [#6111](https://github.com/tobymao/sqlglot/pull/6111) by [@lBilali](https://github.com/lBilali))*
  - :arrow_lower_right: *addresses issue [#6110](https://github.com/tobymao/sqlglot/issues/6110) opened by [@lBilali](https://github.com/lBilali)*
- [`c286cee`](https://github.com/tobymao/sqlglot/commit/c286cee54ab93e1fd0b3be658f7e767e3e00afe9) - **optimizer**: Annotate type for snowflake MONTHNAME function *(PR [#6116](https://github.com/tobymao/sqlglot/pull/6116) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`1a34788`](https://github.com/tobymao/sqlglot/commit/1a34788025bdd8a018c4bb9214f72152e68bdd14) - **optimizer**: Annotate type for snowflake PREVIOUS_DAY function *(PR [#6117](https://github.com/tobymao/sqlglot/pull/6117) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`533faf8`](https://github.com/tobymao/sqlglot/commit/533faf87b6df351070b565dd1fe9ce4e13b6c46e) - **spark**: transpile duckdb `READ_PARQUET` to `parquet.<path>` closes [#6122](https://github.com/tobymao/sqlglot/pull/6122) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`cd4e557`](https://github.com/tobymao/sqlglot/commit/cd4e557658b1384f36c9a1ef9da5a09b893229b1) - **optimizer**: Annotate type for snowflake RANDOM function *(PR [#6124](https://github.com/tobymao/sqlglot/pull/6124) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`fe63d84`](https://github.com/tobymao/sqlglot/commit/fe63d84f1bd365b22221f348d79c0546aa3118b0) - **optimizer**: annotate type for Snowflake MONTHS_BETWEEN function *(PR [#6120](https://github.com/tobymao/sqlglot/pull/6120) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`7cb7598`](https://github.com/tobymao/sqlglot/commit/7cb7598e13260aa45c851dc620b4994ddfa089fe) - **optimizer**: Annotate type for snowflake TIME_FROM_PARTS function *(PR [#6119](https://github.com/tobymao/sqlglot/pull/6119) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`598d09b`](https://github.com/tobymao/sqlglot/commit/598d09b036d938c90a44955d67175ea868090ba2) - **optimizer**: annotate type for Snowflake DATEADD function *(PR [#6089](https://github.com/tobymao/sqlglot/pull/6089) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`b98bcee`](https://github.com/tobymao/sqlglot/commit/b98bcee148ba426816e166dbfa9ba8e0979aae21) - **optimizer**: Annotate type for snowflake next_day function *(PR [#6125](https://github.com/tobymao/sqlglot/pull/6125) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*
- [`fe1927f`](https://github.com/tobymao/sqlglot/commit/fe1927f28600e2d8863a4e7f06e6a21bf6ff7f9c) - **duckdb**: Transpile unix_micros to epoch_us *(PR [#6127](https://github.com/tobymao/sqlglot/pull/6127) by [@vchan](https://github.com/vchan))*
- [`a531f10`](https://github.com/tobymao/sqlglot/commit/a531f107235c29ac6a7e627a323f00b8ecf7023d) - **duckdb**: transpile TimeSub *(PR [#6142](https://github.com/tobymao/sqlglot/pull/6142) by [@toriwei](https://github.com/toriwei))*
- [`b1a9dff`](https://github.com/tobymao/sqlglot/commit/b1a9dfff52a0ffbb0b7c8bfedb0a90e245b97851) - make qualify faster by owly resetting scope when needed *(PR [#6081](https://github.com/tobymao/sqlglot/pull/6081) by [@tobymao](https://github.com/tobymao))*
- [`3a334f3`](https://github.com/tobymao/sqlglot/commit/3a334f376b9766b6b99fdf195ae763bb44976ec4) - **optimizer**: annotate type for boolnot snowflake function *(PR [#6141](https://github.com/tobymao/sqlglot/pull/6141) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`4e36f9d`](https://github.com/tobymao/sqlglot/commit/4e36f9dd6a854b378c9bbf6b2e9811045affc63d) - **optimizer**: Annotate type for snowflake TIMEADD function *(PR [#6134](https://github.com/tobymao/sqlglot/pull/6134) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*

### :bug: Bug Fixes
- [`2238ac2`](https://github.com/tobymao/sqlglot/commit/2238ac27478bd272ba39928bbec1075c4191ee1b) - **duckdb**: transpile timestamp literals in datediff fixes [#6083](https://github.com/tobymao/sqlglot/pull/6083) *(PR [#6086](https://github.com/tobymao/sqlglot/pull/6086) by [@georgesittas](https://github.com/georgesittas))*
- [`bef541c`](https://github.com/tobymao/sqlglot/commit/bef541cec36f8c4295f815c3f5cd22491738901b) - **parser**: query mods and set ops in FROM-first syntax *(PR [#6092](https://github.com/tobymao/sqlglot/pull/6092) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6088](https://github.com/tobymao/sqlglot/issues/6088) opened by [@denis-komarov](https://github.com/denis-komarov)*
  - :arrow_lower_right: *fixes issue [#6091](https://github.com/tobymao/sqlglot/issues/6091) opened by [@denis-komarov](https://github.com/denis-komarov)*
  - :arrow_lower_right: *fixes issue [#6093](https://github.com/tobymao/sqlglot/issues/6093) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`5109890`](https://github.com/tobymao/sqlglot/commit/510989043d18baa17502a971262462814a2eb5be) - **parser**: VALUES with ORDER BY/LIMIT/OFFSET *(PR [#6094](https://github.com/tobymao/sqlglot/pull/6094) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6087](https://github.com/tobymao/sqlglot/issues/6087) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`4b062c8`](https://github.com/tobymao/sqlglot/commit/4b062c850bd9867be0d622f3f526762fa2b72302) - consume more syntax for cubes/rollups fixes [#6101](https://github.com/tobymao/sqlglot/pull/6101) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`f00866a`](https://github.com/tobymao/sqlglot/commit/f00866aeb8b7f51e27173c688225fe16d777eb1a) - **duckdb**: 1 arg FORMAT func *(PR [#6109](https://github.com/tobymao/sqlglot/pull/6109) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6108](https://github.com/tobymao/sqlglot/issues/6108) opened by [@erindru](https://github.com/erindru)*
- [`77dfd5a`](https://github.com/tobymao/sqlglot/commit/77dfd5a41bb9ce5450e0f6b7a78c953c8ade14d5) - lineage does not modify sql input if expression *(PR [#6113](https://github.com/tobymao/sqlglot/pull/6113) by [@snovik75](https://github.com/snovik75))*
  - :arrow_lower_right: *fixes issue [#6112](https://github.com/tobymao/sqlglot/issues/6112) opened by [@snovik75](https://github.com/snovik75)*
- [`06f40f9`](https://github.com/tobymao/sqlglot/commit/06f40f900ce693ba4203514e422cba8cda0dbb07) - **optimizer**: don't simplify x XOR x due to NULL semantics *(PR [#6115](https://github.com/tobymao/sqlglot/pull/6115) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6104](https://github.com/tobymao/sqlglot/issues/6104) opened by [@dllggyx](https://github.com/dllggyx)*
- [`03e2dff`](https://github.com/tobymao/sqlglot/commit/03e2dff9b074dc228cf3854ff1f4357e091aa9b3) - allow parsing `analyze` as an identifier fixes [#6123](https://github.com/tobymao/sqlglot/pull/6123) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`8744431`](https://github.com/tobymao/sqlglot/commit/874443148c8ec2a773dfaca5da10d3587a49de3e) - transpile bigquery DATETIME_DIFF to duckdb *(PR [#6126](https://github.com/tobymao/sqlglot/pull/6126) by [@toriwei](https://github.com/toriwei))*
  - :arrow_lower_right: *fixes issue [#6107](https://github.com/tobymao/sqlglot/issues/6107) opened by [@izeigerman](https://github.com/izeigerman)*
- [`b94e81b`](https://github.com/tobymao/sqlglot/commit/b94e81b42b89c75625b2da779c0f53777d9b6b48) - **optimizer**: avoid removing string literals from WHERE clause *(PR [#6131](https://github.com/tobymao/sqlglot/pull/6131) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6128](https://github.com/tobymao/sqlglot/issues/6128) opened by [@dllggyx](https://github.com/dllggyx)*
- [`e2129c6`](https://github.com/tobymao/sqlglot/commit/e2129c6766ca1f10ff6663bec98be984abb33c91) - **optimizer**: Do not consider BIT_COUNT an aggregate function *(PR [#6135](https://github.com/tobymao/sqlglot/pull/6135) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6130](https://github.com/tobymao/sqlglot/issues/6130) opened by [@dllggyx](https://github.com/dllggyx)*
- [`03bfeed`](https://github.com/tobymao/sqlglot/commit/03bfeed56c5c2f143ce2e1be38d519f902d19961) - **starrocks**: disable IS TRUE/FALSE syntax support *(PR [#6145](https://github.com/tobymao/sqlglot/pull/6145) by [@petrikoro](https://github.com/petrikoro))*
  - :arrow_lower_right: *fixes issue [#6144](https://github.com/tobymao/sqlglot/issues/6144) opened by [@petrikoro](https://github.com/petrikoro)*
- [`d136414`](https://github.com/tobymao/sqlglot/commit/d136414e520270ac9ab2fd8e9df4691d269b3af0) - **optimizer**: avoid simplifying AND with NULL *(PR [#6148](https://github.com/tobymao/sqlglot/pull/6148) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6136](https://github.com/tobymao/sqlglot/issues/6136) opened by [@dllggyx](https://github.com/dllggyx)*
- [`1fd9991`](https://github.com/tobymao/sqlglot/commit/1fd99911a60f0543fbc79221a8c6a6f232ed0a2a) - **clickhouse**: NOT + IN precedence *(PR [#6149](https://github.com/tobymao/sqlglot/pull/6149) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6143](https://github.com/tobymao/sqlglot/issues/6143) opened by [@mlipiev](https://github.com/mlipiev)*

### :recycle: Refactors
- [`58dbce3`](https://github.com/tobymao/sqlglot/commit/58dbce30da5ab94af82247ab8a7eb85200d9b8af) - bq static type annotators *(PR [#6103](https://github.com/tobymao/sqlglot/pull/6103) by [@geooo109](https://github.com/geooo109))*
- [`c970235`](https://github.com/tobymao/sqlglot/commit/c97023549623fe5974d6bff57e64339eff74187e) - clean up MONTHNAME test *(commit by [@geooo109](https://github.com/geooo109))*

### :wrench: Chores
- [`d36ba87`](https://github.com/tobymao/sqlglot/commit/d36ba8774a2a4b53c122e3b78086ce0f09e77244) - **optimizer**: add tests for Snowflake DATE_FROM_PARTS function *(PR [#6077](https://github.com/tobymao/sqlglot/pull/6077) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`2bc05cf`](https://github.com/tobymao/sqlglot/commit/2bc05cf3bd53b874a1505c747e38f8a6a1dbf8c7) - **optimizer**: add tests for Snowflake DATEDIFF function *(PR [#6090](https://github.com/tobymao/sqlglot/pull/6090) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`a4d07a0`](https://github.com/tobymao/sqlglot/commit/a4d07a07eefbdaf88d30df2310a9533afdc75a82) - **optimizer**: Annotate type for snowflake EXTRACT function *(PR [#6099](https://github.com/tobymao/sqlglot/pull/6099) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`ab1da2e`](https://github.com/tobymao/sqlglot/commit/ab1da2e54a83e29d708047d4b3f8abcc1094229d) - **optimizer**: add type annotation tests for snowflake LAST_DAY function *(PR [#6105](https://github.com/tobymao/sqlglot/pull/6105) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`4e24c0a`](https://github.com/tobymao/sqlglot/commit/4e24c0ad92e7071a1f1537886173e29999b46f72) - **optimizer**: add type annotation tests for snowflake TIMESTAMPDIFF function *(PR [#6138](https://github.com/tobymao/sqlglot/pull/6138) by [@fivetran-MichaelLee](https://github.com/fivetran-MichaelLee))*
- [`ae8571f`](https://github.com/tobymao/sqlglot/commit/ae8571fdec71587188e45fe087e1967f5ba641bc) - **optimizer**: add type annotation tests for snowflake TIMEDIFF *(PR [#6140](https://github.com/tobymao/sqlglot/pull/6140) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`3059320`](https://github.com/tobymao/sqlglot/commit/30593202b30001933f05747937975013754b75fa) - copy by default in `lineage` *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`99949cc`](https://github.com/tobymao/sqlglot/commit/99949ccd3ff81b524edeae437d874b86250dbb5b) - avoid needlessly copying in lineage *(PR [#6150](https://github.com/tobymao/sqlglot/pull/6150) by [@georgesittas](https://github.com/georgesittas))*
- [`e7756d8`](https://github.com/tobymao/sqlglot/commit/e7756d8e9f347bfba3f861463890bf57e532cc54) - **optimizer**: add annotation tests for snowflake's BOOLXOR *(PR [#6154](https://github.com/tobymao/sqlglot/pull/6154) by [@fivetran-felixhuang](https://github.com/fivetran-felixhuang))*
- [`72e43e3`](https://github.com/tobymao/sqlglot/commit/72e43e3ea08f9dce5a32654060a56f2ee31bea8f) - **optimizer**: add type annotation tests for snowflake's TIMESTAMPADD function *(PR [#6146](https://github.com/tobymao/sqlglot/pull/6146) by [@fivetran-ashashankar](https://github.com/fivetran-ashashankar))*


## [v27.27.0] - 2025-10-13
### :boom: BREAKING CHANGES
- due to [`c67276d`](https://github.com/tobymao/sqlglot/commit/c67276d5be970252e14d1817d8498fc9985222d9) - Annotate type for snowflake RADIANS function. *(PR [#6064](https://github.com/tobymao/sqlglot/pull/6064) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake RADIANS function. (#6064)


### :sparkles: New Features
- [`c67276d`](https://github.com/tobymao/sqlglot/commit/c67276d5be970252e14d1817d8498fc9985222d9) - **optimizer**: Annotate type for snowflake RADIANS function. *(PR [#6064](https://github.com/tobymao/sqlglot/pull/6064) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*

### :wrench: Chores
- [`dab2a3f`](https://github.com/tobymao/sqlglot/commit/dab2a3fbdb8a523f05319eb34a1fd34534272206) - bump sqlglotrs version to 0.7.3 *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.26.0] - 2025-10-10
### :boom: BREAKING CHANGES
- due to [`9060f60`](https://github.com/tobymao/sqlglot/commit/9060f603818db863b7570a2c3c50c3eb88155e76) - Annotate type for snowflake ATAN2 function. *(PR [#6060](https://github.com/tobymao/sqlglot/pull/6060) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake ATAN2 function. (#6060)

- due to [`b3eb2e4`](https://github.com/tobymao/sqlglot/commit/b3eb2e4ca6177ee61b27675e8ec8b4815587df31) - annotate type for Snowflake SINH function *(PR [#6052](https://github.com/tobymao/sqlglot/pull/6052) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake SINH function (#6052)

- due to [`157d2fa`](https://github.com/tobymao/sqlglot/commit/157d2fa06ab110ebc760aa7567d7fda801a5ced9) - annotate type for Snowflake CEIL function *(PR [#6051](https://github.com/tobymao/sqlglot/pull/6051) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake CEIL function (#6051)

- due to [`e7833de`](https://github.com/tobymao/sqlglot/commit/e7833de9744a4aa69d244285e7f6f7281af178ba) - support DELETE with USING and multiple VALUES *(PR [#6072](https://github.com/tobymao/sqlglot/pull/6072) by [@geooo109](https://github.com/geooo109))*:

  support DELETE with USING and multiple VALUES (#6072)

- due to [`354140d`](https://github.com/tobymao/sqlglot/commit/354140d0a279f317439bdb247e1ab9578f9a035d) - Annotate type for snowflake TANH and ATAN functions *(PR [#6069](https://github.com/tobymao/sqlglot/pull/6069) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TANH and ATAN functions (#6069)


### :sparkles: New Features
- [`9060f60`](https://github.com/tobymao/sqlglot/commit/9060f603818db863b7570a2c3c50c3eb88155e76) - **optimizer**: Annotate type for snowflake ATAN2 function. *(PR [#6060](https://github.com/tobymao/sqlglot/pull/6060) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`b3eb2e4`](https://github.com/tobymao/sqlglot/commit/b3eb2e4ca6177ee61b27675e8ec8b4815587df31) - **optimizer**: annotate type for Snowflake SINH function *(PR [#6052](https://github.com/tobymao/sqlglot/pull/6052) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`440b960`](https://github.com/tobymao/sqlglot/commit/440b960529801674fa23708212485fda95749699) - **duckdb**: support `USING KEY (...)` in recursive DuckDB CTEs *(PR [#6068](https://github.com/tobymao/sqlglot/pull/6068) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#6066](https://github.com/tobymao/sqlglot/issues/6066) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`157d2fa`](https://github.com/tobymao/sqlglot/commit/157d2fa06ab110ebc760aa7567d7fda801a5ced9) - **optimizer**: annotate type for Snowflake CEIL function *(PR [#6051](https://github.com/tobymao/sqlglot/pull/6051) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`eb6d6e7`](https://github.com/tobymao/sqlglot/commit/eb6d6e7ccde37456ab56ad976e7d95cea23c14e3) - **duckdb**: support `DEFAULT VALUES` clause in `INSERT` DML *(PR [#6067](https://github.com/tobymao/sqlglot/pull/6067) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#6065](https://github.com/tobymao/sqlglot/issues/6065) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`354140d`](https://github.com/tobymao/sqlglot/commit/354140d0a279f317439bdb247e1ab9578f9a035d) - **optimizer**: Annotate type for snowflake TANH and ATAN functions *(PR [#6069](https://github.com/tobymao/sqlglot/pull/6069) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`c94e3e0`](https://github.com/tobymao/sqlglot/commit/c94e3e0e4e20bd76d4cf630123d2c05a0e3044c3) - add ColumnDef expression parser *(PR [#6075](https://github.com/tobymao/sqlglot/pull/6075) by [@geooo109](https://github.com/geooo109))*

### :bug: Bug Fixes
- [`2c7cc29`](https://github.com/tobymao/sqlglot/commit/2c7cc29a329dcbaaa90a6f857d2383d2967ea6cc) - **duckdb**: Transform exp.HexString to BLOB in hex notation *(PR [#6045](https://github.com/tobymao/sqlglot/pull/6045) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6035](https://github.com/tobymao/sqlglot/issues/6035) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`e7833de`](https://github.com/tobymao/sqlglot/commit/e7833de9744a4aa69d244285e7f6f7281af178ba) - **parser**: support DELETE with USING and multiple VALUES *(PR [#6072](https://github.com/tobymao/sqlglot/pull/6072) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6070](https://github.com/tobymao/sqlglot/issues/6070) opened by [@denis-komarov](https://github.com/denis-komarov)*

### :recycle: Refactors
- [`2c9d15c`](https://github.com/tobymao/sqlglot/commit/2c9d15c92da25c8456b2463c69aa56c8ec47c453) - replace direct arg manipulation *(PR [#6073](https://github.com/tobymao/sqlglot/pull/6073) by [@geooo109](https://github.com/geooo109))*

### :wrench: Chores
- [`75b8d16`](https://github.com/tobymao/sqlglot/commit/75b8d16e41b677ea7e150c89d713795073aae6e3) - remove docs from main branch *(PR [#6057](https://github.com/tobymao/sqlglot/pull/6057) by [@georgesittas](https://github.com/georgesittas))*
- [`cfa2493`](https://github.com/tobymao/sqlglot/commit/cfa249328eef31ab0e0688dcc03521da3343ce47) - **optimizer**: Annotate type for snowflake SQUARE function *(PR [#6059](https://github.com/tobymao/sqlglot/pull/6059) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`e26c394`](https://github.com/tobymao/sqlglot/commit/e26c3949beb7f73020fcd099237dbe31a4db8d84) - **optimizer**: Annotate type for snowflake POW function *(PR [#6058](https://github.com/tobymao/sqlglot/pull/6058) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`7d303ad`](https://github.com/tobymao/sqlglot/commit/7d303adc5efe9d51eb62aeab80bfa4f844e1911d) - include Python 3.14 in the testing matrix *(PR [#6074](https://github.com/tobymao/sqlglot/pull/6074) by [@georgesittas](https://github.com/georgesittas))*


## [v27.25.0] - 2025-10-09
### :boom: BREAKING CHANGES
- due to [`6f31b86`](https://github.com/tobymao/sqlglot/commit/6f31b86599258afe156aa3d9ccc42389cac37021) - Annotate type for snowflake FLOOR function *(PR [#6030](https://github.com/tobymao/sqlglot/pull/6030) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake FLOOR function (#6030)

- due to [`cecab2f`](https://github.com/tobymao/sqlglot/commit/cecab2fd66d578ddc765b5fd0e7b155971280a0c) - annotate type for Snowflake ATANH function *(PR [#6054](https://github.com/tobymao/sqlglot/pull/6054) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake ATANH function (#6054)

- due to [`08339a9`](https://github.com/tobymao/sqlglot/commit/08339a902138211f67cfb009d2576b22ea8d8e42) - annotate type for Snowflake FACTORIAL function *(PR [#6053](https://github.com/tobymao/sqlglot/pull/6053) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake FACTORIAL function (#6053)


### :sparkles: New Features
- [`6f31b86`](https://github.com/tobymao/sqlglot/commit/6f31b86599258afe156aa3d9ccc42389cac37021) - **optimizer**: Annotate type for snowflake FLOOR function *(PR [#6030](https://github.com/tobymao/sqlglot/pull/6030) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`b7463d5`](https://github.com/tobymao/sqlglot/commit/b7463d5b0a1e286498d7ccfd9a07ef7edfa80bb2) - **optimizer**: Annotate type for snowflake ASIN function. *(PR [#6049](https://github.com/tobymao/sqlglot/pull/6049) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`fe959a5`](https://github.com/tobymao/sqlglot/commit/fe959a5598508526ed5910a4c62372116b5d3c30) - **optimizer**: Annotate type for snowflake CBRT function *(PR [#6050](https://github.com/tobymao/sqlglot/pull/6050) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`cecab2f`](https://github.com/tobymao/sqlglot/commit/cecab2fd66d578ddc765b5fd0e7b155971280a0c) - **optimizer**: annotate type for Snowflake ATANH function *(PR [#6054](https://github.com/tobymao/sqlglot/pull/6054) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`08339a9`](https://github.com/tobymao/sqlglot/commit/08339a902138211f67cfb009d2576b22ea8d8e42) - **optimizer**: annotate type for Snowflake FACTORIAL function *(PR [#6053](https://github.com/tobymao/sqlglot/pull/6053) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*

### :bug: Bug Fixes
- [`3bb6bb3`](https://github.com/tobymao/sqlglot/commit/3bb6bb3e5193ed53c803c3786a1791f15cd2f89a) - **parser**: support :: cast operator after IS NULL/IS NOT NULL *(PR [#6056](https://github.com/tobymao/sqlglot/pull/6056) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6055](https://github.com/tobymao/sqlglot/issues/6055) opened by [@vchan](https://github.com/vchan)*

### :wrench: Chores
- [`15030a3`](https://github.com/tobymao/sqlglot/commit/15030a3996d005d79f27408a68d17f94c98aec68) - **optimizer**: Add tests for snowflake LN and LOG functions *(PR [#6048](https://github.com/tobymao/sqlglot/pull/6048) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`2ae8dbd`](https://github.com/tobymao/sqlglot/commit/2ae8dbd4d1b43bb27647144c32b2a781ff3edbeb) - push docs to `api-docs` branch instead of main *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.22.2] - 2025-10-08
### :wrench: Chores
- [`9ab3a96`](https://github.com/tobymao/sqlglot/commit/9ab3a96a853639224c80a9daff4674187a1a84ef) - bump sqlglotrs to 0.7.2 *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.22.1] - 2025-10-08
### :boom: BREAKING CHANGES
- due to [`7ac01c2`](https://github.com/tobymao/sqlglot/commit/7ac01c2ae9bc4375efb63c60e3221e85088fdd1f) - bump sqlglotrs to 0.7.1 *(commit by [@georgesittas](https://github.com/georgesittas))*:

  bump sqlglotrs to 0.7.1


### :wrench: Chores
- [`7ac01c2`](https://github.com/tobymao/sqlglot/commit/7ac01c2ae9bc4375efb63c60e3221e85088fdd1f) - bump sqlglotrs to 0.7.1 *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.22.0] - 2025-10-08
### :boom: BREAKING CHANGES
- due to [`6beb917`](https://github.com/tobymao/sqlglot/commit/6beb9172dffd0aaea46b75477485060737e774b9) - Annotate type for snowflake ROUND function *(PR [#6032](https://github.com/tobymao/sqlglot/pull/6032) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake ROUND function (#6032)

- due to [`0939d69`](https://github.com/tobymao/sqlglot/commit/0939d69223a860581b1c30cc2f762294946b93f3) - move odbc date literal handling in t-sql closes [#6037](https://github.com/tobymao/sqlglot/pull/6037) *(PR [#6044](https://github.com/tobymao/sqlglot/pull/6044) by [@georgesittas](https://github.com/georgesittas))*:

  move odbc date literal handling in t-sql closes #6037 (#6044)

- due to [`56c8b3b`](https://github.com/tobymao/sqlglot/commit/56c8b3bbff7451b9049e1a168716bb41222a86ed) - Support CHANGE COLUMN statements in Hive and CHANGE/ALTER COLUMN statements in Spark *(PR [#6004](https://github.com/tobymao/sqlglot/pull/6004) by [@tsamaras](https://github.com/tsamaras))*:

  Support CHANGE COLUMN statements in Hive and CHANGE/ALTER COLUMN statements in Spark (#6004)


### :sparkles: New Features
- [`6beb917`](https://github.com/tobymao/sqlglot/commit/6beb9172dffd0aaea46b75477485060737e774b9) - **optimizer**: Annotate type for snowflake ROUND function *(PR [#6032](https://github.com/tobymao/sqlglot/pull/6032) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`8e03ad9`](https://github.com/tobymao/sqlglot/commit/8e03ad9dd087ebc72bf58cb6383607c0ce2e8f8f) - **optimizer**: Annotate type for snowflake MOD function *(PR [#6031](https://github.com/tobymao/sqlglot/pull/6031) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`15b3fac`](https://github.com/tobymao/sqlglot/commit/15b3fac3dd5efd4c347ac40055f07a9be5906802) - **mysql**: support `FOR ORDINALITY` clause in `COLUMN` expression *(PR [#6046](https://github.com/tobymao/sqlglot/pull/6046) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#6039](https://github.com/tobymao/sqlglot/issues/6039) opened by [@jdddog](https://github.com/jdddog)*
- [`56c8b3b`](https://github.com/tobymao/sqlglot/commit/56c8b3bbff7451b9049e1a168716bb41222a86ed) - **hive,spark**: Support CHANGE COLUMN statements in Hive and CHANGE/ALTER COLUMN statements in Spark *(PR [#6004](https://github.com/tobymao/sqlglot/pull/6004) by [@tsamaras](https://github.com/tsamaras))*

### :bug: Bug Fixes
- [`6a6ca92`](https://github.com/tobymao/sqlglot/commit/6a6ca927c4e6e06f5cb38ad1153a8b556999ef90) - **parser**: Allow nested GROUPING SETS *(PR [#6041](https://github.com/tobymao/sqlglot/pull/6041) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6038](https://github.com/tobymao/sqlglot/issues/6038) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`41baeaa`](https://github.com/tobymao/sqlglot/commit/41baeaa1530c5419c945409133e3b7caa5250ec7) - **optimizer**: more robust CROSS JOIN substitution and JOIN reordering *(PR [#6021](https://github.com/tobymao/sqlglot/pull/6021) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6009](https://github.com/tobymao/sqlglot/issues/6009) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`e2f299f`](https://github.com/tobymao/sqlglot/commit/e2f299f5ad18d75a394e55bd1ee59ed243d77e54) - allow subqueries to have modifiers closes [#6014](https://github.com/tobymao/sqlglot/pull/6014) *(PR [#6034](https://github.com/tobymao/sqlglot/pull/6034) by [@tobymao](https://github.com/tobymao))*
- [`0d65266`](https://github.com/tobymao/sqlglot/commit/0d6526693f8e7dda9b7c180d31c364bde91afc72) - parse lambda for arg_min/max arguments closes [#6036](https://github.com/tobymao/sqlglot/pull/6036) *(PR [#6042](https://github.com/tobymao/sqlglot/pull/6042) by [@georgesittas](https://github.com/georgesittas))*
- [`0939d69`](https://github.com/tobymao/sqlglot/commit/0939d69223a860581b1c30cc2f762294946b93f3) - move odbc date literal handling in t-sql closes [#6037](https://github.com/tobymao/sqlglot/pull/6037) *(PR [#6044](https://github.com/tobymao/sqlglot/pull/6044) by [@georgesittas](https://github.com/georgesittas))*
- [`65848e5`](https://github.com/tobymao/sqlglot/commit/65848e5a3e4c1cb26e6ca4deb7819a282838c3c2) - **tsql**: UPDATE with OPTIONS *(PR [#6043](https://github.com/tobymao/sqlglot/pull/6043) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6033](https://github.com/tobymao/sqlglot/issues/6033) opened by [@ligfx](https://github.com/ligfx)*

### :recycle: Refactors
- [`8f00c80`](https://github.com/tobymao/sqlglot/commit/8f00c804a67209a5eca1fcb28aeb95941c58e583) - _parse_in expr len check *(commit by [@geooo109](https://github.com/geooo109))*


## [v27.21.0] - 2025-10-07
### :boom: BREAKING CHANGES
- due to [`3c7b5c0`](https://github.com/tobymao/sqlglot/commit/3c7b5c0e2dc071b7b9f6da308ba58a3a43da93dc) - Annotate type for snowflake SOUNDEX_P123 function *(PR [#5987](https://github.com/tobymao/sqlglot/pull/5987) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake SOUNDEX_P123 function (#5987)

- due to [`f25e42e`](https://github.com/tobymao/sqlglot/commit/f25e42e3f5b3b7b671bd724ba7b09a9b07d13995) - annotate type for Snowflake REGEXP_INSTR function *(PR [#5978](https://github.com/tobymao/sqlglot/pull/5978) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake REGEXP_INSTR function (#5978)

- due to [`13cb26e`](https://github.com/tobymao/sqlglot/commit/13cb26e2f29373538d60a8124ddebf95fd22a8d8) - annotate type for Snowflake REGEXP_SUBSTR_ALL function *(PR [#5979](https://github.com/tobymao/sqlglot/pull/5979) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake REGEXP_SUBSTR_ALL function (#5979)

- due to [`4ce683e`](https://github.com/tobymao/sqlglot/commit/4ce683eb8ac5716a334cbd7625438b9f89623c7a) - Annotate type for snowflake UNICODE function *(PR [#5993](https://github.com/tobymao/sqlglot/pull/5993) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake UNICODE function (#5993)

- due to [`c7657fb`](https://github.com/tobymao/sqlglot/commit/c7657fbd27a4350c424ef65947471ab9ec086831) - remove `unalias_group_by` transformation since it is unsafe *(PR [#5997](https://github.com/tobymao/sqlglot/pull/5997) by [@georgesittas](https://github.com/georgesittas))*:

  remove `unalias_group_by` transformation since it is unsafe (#5997)

- due to [`587196c`](https://github.com/tobymao/sqlglot/commit/587196c9c2d122f73f9deb7e87c2831f27f6ed02) - Annotate type for snowflake STRTOK_TO_ARRAY function *(PR [#5994](https://github.com/tobymao/sqlglot/pull/5994) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake STRTOK_TO_ARRAY function (#5994)

- due to [`bced710`](https://github.com/tobymao/sqlglot/commit/bced71084ffb3a8f7a11db843777f05b68f367da) - Annotate type for snowflake STRTOK function. *(PR [#5991](https://github.com/tobymao/sqlglot/pull/5991) by [@georgesittas](https://github.com/georgesittas))*:

  Annotate type for snowflake STRTOK function. (#5991)

- due to [`be1cdc8`](https://github.com/tobymao/sqlglot/commit/be1cdc81b511d462b710b50941d5c2770d901e91) - Fix roundtrip of ~ operator *(PR [#6017](https://github.com/tobymao/sqlglot/pull/6017) by [@VaggelisD](https://github.com/VaggelisD))*:

  Fix roundtrip of ~ operator (#6017)

- due to [`74a13f2`](https://github.com/tobymao/sqlglot/commit/74a13f2a548b9cd41061e835cb3cd9dd2a5a9fb3) - Annotate type for snowflake DIV0 and DIVNULL functions *(PR [#6008](https://github.com/tobymao/sqlglot/pull/6008) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake DIV0 and DIVNULL functions (#6008)

- due to [`fec2b31`](https://github.com/tobymao/sqlglot/commit/fec2b31956f2debdad7c53744a577894cd8d747c) - Annotate type for snowflake SEARCH function *(PR [#5985](https://github.com/tobymao/sqlglot/pull/5985) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake SEARCH function (#5985)

- due to [`27a76cd`](https://github.com/tobymao/sqlglot/commit/27a76cdfe4212f16f945521eb3997580eacf1d61) - Annotate type for snowflake COT, SIN and TAN functions *(PR [#6022](https://github.com/tobymao/sqlglot/pull/6022) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake COT, SIN and TAN functions (#6022)

- due to [`0911276`](https://github.com/tobymao/sqlglot/commit/091127663ab4cb94b02be5aa40c6a46dd7f89243) - annotate type for Snowflake EXP function *(PR [#6007](https://github.com/tobymao/sqlglot/pull/6007) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake EXP function (#6007)

- due to [`a96d50e`](https://github.com/tobymao/sqlglot/commit/a96d50e14bed5e87ff2dce9c545e0c48897b64d6) - annotate type for Snowflake COSH function *(PR [#6006](https://github.com/tobymao/sqlglot/pull/6006) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake COSH function (#6006)

- due to [`4df58e0`](https://github.com/tobymao/sqlglot/commit/4df58e0f0b8985590fb29a8ab6ba0ced987ac5b9) - annotate type for Snowflake DEGREES function *(PR [#6027](https://github.com/tobymao/sqlglot/pull/6027) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake DEGREES function (#6027)

- due to [`db71a20`](https://github.com/tobymao/sqlglot/commit/db71a2023aaeca2ffda782ae7b91fdee356c402e) - annotate type for Snowflake COS function *(PR [#6028](https://github.com/tobymao/sqlglot/pull/6028) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake COS function (#6028)

- due to [`5dd2ed3`](https://github.com/tobymao/sqlglot/commit/5dd2ed3c69cf9e8c3e327297e0cc932f0954e108) - bump sqlglotrs to 0.7.0 *(commit by [@georgesittas](https://github.com/georgesittas))*:

  bump sqlglotrs to 0.7.0


### :sparkles: New Features
- [`3c7b5c0`](https://github.com/tobymao/sqlglot/commit/3c7b5c0e2dc071b7b9f6da308ba58a3a43da93dc) - **optimizer**: Annotate type for snowflake SOUNDEX_P123 function *(PR [#5987](https://github.com/tobymao/sqlglot/pull/5987) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`475c09b`](https://github.com/tobymao/sqlglot/commit/475c09bd27179db4d186638645698dd4ad6553cd) - **optimizer**: Annotate type for snowflake TRANSLATE function *(PR [#5992](https://github.com/tobymao/sqlglot/pull/5992) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`f25e42e`](https://github.com/tobymao/sqlglot/commit/f25e42e3f5b3b7b671bd724ba7b09a9b07d13995) - **optimizer**: annotate type for Snowflake REGEXP_INSTR function *(PR [#5978](https://github.com/tobymao/sqlglot/pull/5978) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`13cb26e`](https://github.com/tobymao/sqlglot/commit/13cb26e2f29373538d60a8124ddebf95fd22a8d8) - **optimizer**: annotate type for Snowflake REGEXP_SUBSTR_ALL function *(PR [#5979](https://github.com/tobymao/sqlglot/pull/5979) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`4ce683e`](https://github.com/tobymao/sqlglot/commit/4ce683eb8ac5716a334cbd7625438b9f89623c7a) - **optimizer**: Annotate type for snowflake UNICODE function *(PR [#5993](https://github.com/tobymao/sqlglot/pull/5993) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`587196c`](https://github.com/tobymao/sqlglot/commit/587196c9c2d122f73f9deb7e87c2831f27f6ed02) - **optimizer**: Annotate type for snowflake STRTOK_TO_ARRAY function *(PR [#5994](https://github.com/tobymao/sqlglot/pull/5994) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`bced710`](https://github.com/tobymao/sqlglot/commit/bced71084ffb3a8f7a11db843777f05b68f367da) - **optimizer**: Annotate type for snowflake STRTOK function. *(PR [#5991](https://github.com/tobymao/sqlglot/pull/5991) by [@georgesittas](https://github.com/georgesittas))*
- [`74a13f2`](https://github.com/tobymao/sqlglot/commit/74a13f2a548b9cd41061e835cb3cd9dd2a5a9fb3) - **optimizer**: Annotate type for snowflake DIV0 and DIVNULL functions *(PR [#6008](https://github.com/tobymao/sqlglot/pull/6008) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`fec2b31`](https://github.com/tobymao/sqlglot/commit/fec2b31956f2debdad7c53744a577894cd8d747c) - **optimizer**: Annotate type for snowflake SEARCH function *(PR [#5985](https://github.com/tobymao/sqlglot/pull/5985) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`27a76cd`](https://github.com/tobymao/sqlglot/commit/27a76cdfe4212f16f945521eb3997580eacf1d61) - **optimizer**: Annotate type for snowflake COT, SIN and TAN functions *(PR [#6022](https://github.com/tobymao/sqlglot/pull/6022) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`8b48f7b`](https://github.com/tobymao/sqlglot/commit/8b48f7b985342cfcc45bc2b94540a1a2bf5995c4) - **optimizer**: Annotate type for snowflake SIGN and ABS functions *(PR [#6025](https://github.com/tobymao/sqlglot/pull/6025) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`0911276`](https://github.com/tobymao/sqlglot/commit/091127663ab4cb94b02be5aa40c6a46dd7f89243) - **optimizer**: annotate type for Snowflake EXP function *(PR [#6007](https://github.com/tobymao/sqlglot/pull/6007) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`a96d50e`](https://github.com/tobymao/sqlglot/commit/a96d50e14bed5e87ff2dce9c545e0c48897b64d6) - **optimizer**: annotate type for Snowflake COSH function *(PR [#6006](https://github.com/tobymao/sqlglot/pull/6006) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`4df58e0`](https://github.com/tobymao/sqlglot/commit/4df58e0f0b8985590fb29a8ab6ba0ced987ac5b9) - **optimizer**: annotate type for Snowflake DEGREES function *(PR [#6027](https://github.com/tobymao/sqlglot/pull/6027) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`db71a20`](https://github.com/tobymao/sqlglot/commit/db71a2023aaeca2ffda782ae7b91fdee356c402e) - **optimizer**: annotate type for Snowflake COS function *(PR [#6028](https://github.com/tobymao/sqlglot/pull/6028) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*

### :bug: Bug Fixes
- [`51b1bb1`](https://github.com/tobymao/sqlglot/commit/51b1bb178fa952edc13b2cbc6f624d30b0bde798) - move `WATERMARK` logic to risingwave fixes [#5989](https://github.com/tobymao/sqlglot/pull/5989) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`033ddf0`](https://github.com/tobymao/sqlglot/commit/033ddf04da895f1f5d38aff5361b2ae0793fefea) - **optimizer**: convert INNER JOINs to LEFT JOINs when merging LEFT JOIN subqueries *(PR [#5980](https://github.com/tobymao/sqlglot/pull/5980) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5969](https://github.com/tobymao/sqlglot/issues/5969) opened by [@karta0807913](https://github.com/karta0807913)*
- [`c7657fb`](https://github.com/tobymao/sqlglot/commit/c7657fbd27a4350c424ef65947471ab9ec086831) - remove `unalias_group_by` transformation since it is unsafe *(PR [#5997](https://github.com/tobymao/sqlglot/pull/5997) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5995](https://github.com/tobymao/sqlglot/issues/5995) opened by [@capricornsky0119](https://github.com/capricornsky0119)*
- [`b6f9694`](https://github.com/tobymao/sqlglot/commit/b6f9694c535cdd1403a63036cc246fda4e6d4d22) - **optimizer**: avoid merging subquery with JOIN when outer query uses JOIN *(PR [#5999](https://github.com/tobymao/sqlglot/pull/5999) by [@geooo109](https://github.com/geooo109))*
- [`23fd7b9`](https://github.com/tobymao/sqlglot/commit/23fd7b9116541b96e5d89389e862c6004e92d109) - respect multi-part Column units instead of converting to Var *(PR [#6005](https://github.com/tobymao/sqlglot/pull/6005) by [@georgesittas](https://github.com/georgesittas))*
- [`be1cdc8`](https://github.com/tobymao/sqlglot/commit/be1cdc81b511d462b710b50941d5c2770d901e91) - **duckdb**: Fix roundtrip of ~ operator *(PR [#6017](https://github.com/tobymao/sqlglot/pull/6017) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6016](https://github.com/tobymao/sqlglot/issues/6016) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`27c278f`](https://github.com/tobymao/sqlglot/commit/27c278f562f5ce98a1a4d31f8e66f148a1f42236) - **parser**: Allow LIMIT with % percentage *(PR [#6019](https://github.com/tobymao/sqlglot/pull/6019) by [@VaggelisD](https://github.com/VaggelisD))*
- [`39bf3f8`](https://github.com/tobymao/sqlglot/commit/39bf3f893389663796cdd799ef0f1e684f315a01) - **parser**: Allow CUBE & ROLLUP inside GROUPING SETS *(PR [#6018](https://github.com/tobymao/sqlglot/pull/6018) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6015](https://github.com/tobymao/sqlglot/issues/6015) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`ba7ad34`](https://github.com/tobymao/sqlglot/commit/ba7ad341d5ee1298b8fe54be11ca6252c1a44c99) - **duckdb**: Parse ROW type as STRUCT *(PR [#6020](https://github.com/tobymao/sqlglot/pull/6020) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#6012](https://github.com/tobymao/sqlglot/issues/6012) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`718d6bb`](https://github.com/tobymao/sqlglot/commit/718d6bbf7f40e5b3e99563e2f1ac9eadeff57c3d) - handle unicode heredoc tags & Rust grapheme clusters properly *(PR [#6024](https://github.com/tobymao/sqlglot/pull/6024) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#6010](https://github.com/tobymao/sqlglot/issues/6010) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`c8cfb9d`](https://github.com/tobymao/sqlglot/commit/c8cfb9db2e789be2dc7f8a154082a9210b736502) - **snowflake**: transpile ARRAY_CONTAINS with VARIANT CAST *(PR [#6029](https://github.com/tobymao/sqlglot/pull/6029) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#6026](https://github.com/tobymao/sqlglot/issues/6026) opened by [@Birkman](https://github.com/Birkman)*

### :wrench: Chores
- [`1b1c6f8`](https://github.com/tobymao/sqlglot/commit/1b1c6f8d418371d49f0d3511baf3c5e35dd3ef42) - coerce type for EXTRACT canonicalization *(PR [#5998](https://github.com/tobymao/sqlglot/pull/5998) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *addresses issue [#5996](https://github.com/tobymao/sqlglot/issues/5996) opened by [@snovik75](https://github.com/snovik75)*
- [`f00ae73`](https://github.com/tobymao/sqlglot/commit/f00ae735c8f185b4c6c132373c9fa9bbe58e37b7) - **optimizer**: Annotate type for sqrt function *(PR [#6003](https://github.com/tobymao/sqlglot/pull/6003) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`ac97f14`](https://github.com/tobymao/sqlglot/commit/ac97f14ee1a576a276018f6c9ae1237ecf9ceda7) - simplify `SEARCH` Snowflake instantiation *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`5dd2ed3`](https://github.com/tobymao/sqlglot/commit/5dd2ed3c69cf9e8c3e327297e0cc932f0954e108) - bump sqlglotrs to 0.7.0 *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.20.0] - 2025-09-30
### :boom: BREAKING CHANGES
- due to [`13a30df`](https://github.com/tobymao/sqlglot/commit/13a30dfa37096df5bfc2c31538325c40a49f7917) - Annotate type for snowflake TRY_BASE64_DECODE_BINARY function *(PR [#5972](https://github.com/tobymao/sqlglot/pull/5972) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TRY_BASE64_DECODE_BINARY function (#5972)

- due to [`1f5fdd7`](https://github.com/tobymao/sqlglot/commit/1f5fdd799c047de167a4572f7ac26b7ad92167f2) - Annotate type for snowflake TRY_BASE64_DECODE_STRING function *(PR [#5974](https://github.com/tobymao/sqlglot/pull/5974) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TRY_BASE64_DECODE_STRING function (#5974)

- due to [`324e82f`](https://github.com/tobymao/sqlglot/commit/324e82fe1fb11722f91341010602a743b151e055) - Annotate type for snowflake TRY_HEX_DECODE_BINARY function *(PR [#5975](https://github.com/tobymao/sqlglot/pull/5975) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TRY_HEX_DECODE_BINARY function (#5975)

- due to [`6caf99d`](https://github.com/tobymao/sqlglot/commit/6caf99d556a3357ffaa6c294a9babcd30dd5fac5) - Annotate type for snowflake TRY_HEX_DECODE_STRING function *(PR [#5976](https://github.com/tobymao/sqlglot/pull/5976) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake TRY_HEX_DECODE_STRING function (#5976)

- due to [`73186a8`](https://github.com/tobymao/sqlglot/commit/73186a812ce422c108ee81b3de11da6ee9a9e902) - annotate type for Snowflake REGEXP_COUNT function *(PR [#5963](https://github.com/tobymao/sqlglot/pull/5963) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake REGEXP_COUNT function (#5963)

- due to [`c3bdb3c`](https://github.com/tobymao/sqlglot/commit/c3bdb3cd1af1809ed82be0ae40744d9fffc8ce18) - array start index is 1, support array_flatten, fixes [#5983](https://github.com/tobymao/sqlglot/pull/5983) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  array start index is 1, support array_flatten, fixes #5983

- due to [`244fb48`](https://github.com/tobymao/sqlglot/commit/244fb48fc9c4776f427c08b825d139b1c172fd26) - annotate type for Snowflake SPLIT_PART function *(PR [#5988](https://github.com/tobymao/sqlglot/pull/5988) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake SPLIT_PART function (#5988)

- due to [`0d772e0`](https://github.com/tobymao/sqlglot/commit/0d772e0b9d687b24d49203c05d7a90cc1dce02d5) - add ast node for `DIRECTORY` source *(PR [#5990](https://github.com/tobymao/sqlglot/pull/5990) by [@georgesittas](https://github.com/georgesittas))*:

  add ast node for `DIRECTORY` source (#5990)


### :sparkles: New Features
- [`13a30df`](https://github.com/tobymao/sqlglot/commit/13a30dfa37096df5bfc2c31538325c40a49f7917) - **optimizer**: Annotate type for snowflake TRY_BASE64_DECODE_BINARY function *(PR [#5972](https://github.com/tobymao/sqlglot/pull/5972) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`1f5fdd7`](https://github.com/tobymao/sqlglot/commit/1f5fdd799c047de167a4572f7ac26b7ad92167f2) - **optimizer**: Annotate type for snowflake TRY_BASE64_DECODE_STRING function *(PR [#5974](https://github.com/tobymao/sqlglot/pull/5974) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`324e82f`](https://github.com/tobymao/sqlglot/commit/324e82fe1fb11722f91341010602a743b151e055) - **optimizer**: Annotate type for snowflake TRY_HEX_DECODE_BINARY function *(PR [#5975](https://github.com/tobymao/sqlglot/pull/5975) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`6caf99d`](https://github.com/tobymao/sqlglot/commit/6caf99d556a3357ffaa6c294a9babcd30dd5fac5) - **optimizer**: Annotate type for snowflake TRY_HEX_DECODE_STRING function *(PR [#5976](https://github.com/tobymao/sqlglot/pull/5976) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`73186a8`](https://github.com/tobymao/sqlglot/commit/73186a812ce422c108ee81b3de11da6ee9a9e902) - **optimizer**: annotate type for Snowflake REGEXP_COUNT function *(PR [#5963](https://github.com/tobymao/sqlglot/pull/5963) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`6124de7`](https://github.com/tobymao/sqlglot/commit/6124de76fa6d6725e844cd37e09ebfe99469b0ec) - **optimizer**: Annotate type for snowflake SOUNDEX function *(PR [#5986](https://github.com/tobymao/sqlglot/pull/5986) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`244fb48`](https://github.com/tobymao/sqlglot/commit/244fb48fc9c4776f427c08b825d139b1c172fd26) - **optimizer**: annotate type for Snowflake SPLIT_PART function *(PR [#5988](https://github.com/tobymao/sqlglot/pull/5988) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`0d772e0`](https://github.com/tobymao/sqlglot/commit/0d772e0b9d687b24d49203c05d7a90cc1dce02d5) - **snowflake**: add ast node for `DIRECTORY` source *(PR [#5990](https://github.com/tobymao/sqlglot/pull/5990) by [@georgesittas](https://github.com/georgesittas))*

### :bug: Bug Fixes
- [`7a3744f`](https://github.com/tobymao/sqlglot/commit/7a3744f203b93211e5dd97e6730b6bf59d6d96e0) - **sqlite**: support `RANGE CURRENT ROW` in window spec *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`c3bdb3c`](https://github.com/tobymao/sqlglot/commit/c3bdb3cd1af1809ed82be0ae40744d9fffc8ce18) - **starrocks**: array start index is 1, support array_flatten, fixes [#5983](https://github.com/tobymao/sqlglot/pull/5983) *(commit by [@georgesittas](https://github.com/georgesittas))*

### :recycle: Refactors
- [`d425ba2`](https://github.com/tobymao/sqlglot/commit/d425ba26b96b368801f8f486fa375cd75105993d) - make hash and eq non recursive *(PR [#5966](https://github.com/tobymao/sqlglot/pull/5966) by [@tobymao](https://github.com/tobymao))*

### :wrench: Chores
- [`345c6a1`](https://github.com/tobymao/sqlglot/commit/345c6a153481a22d6df1b12ef1863e2133688fdf) - add uv support to Makefile *(PR [#5973](https://github.com/tobymao/sqlglot/pull/5973) by [@eakmanrq](https://github.com/eakmanrq))*


## [v27.19.0] - 2025-09-26
### :boom: BREAKING CHANGES
- due to [`68473ac`](https://github.com/tobymao/sqlglot/commit/68473ac3ec8dc76512dc76819892a1b0324c7ddc) - Annotate type for snowflake PARSE_URL function *(PR [#5962](https://github.com/tobymao/sqlglot/pull/5962) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake PARSE_URL function (#5962)

- due to [`b015a9d`](https://github.com/tobymao/sqlglot/commit/b015a9d944d0a87069a7750ad74953c399d7da34) - annotate type for Snowflake REGEXP_INSTR function *(commit by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake REGEXP_INSTR function

- due to [`1f29ba7`](https://github.com/tobymao/sqlglot/commit/1f29ba710f4213beb1a2f993244d7d824f3536ce) - annotate type for Snowflake PARSE_IP function *(PR [#5961](https://github.com/tobymao/sqlglot/pull/5961) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake PARSE_IP function (#5961)

- due to [`bf45d5d`](https://github.com/tobymao/sqlglot/commit/bf45d5d3cb0c0f380824019eb32ec29049268a61) - annotate types for Snowflake RTRIMMED_LENGTH function *(PR [#5968](https://github.com/tobymao/sqlglot/pull/5968) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake RTRIMMED_LENGTH function (#5968)

- due to [`13caa69`](https://github.com/tobymao/sqlglot/commit/13caa6991f003ad7abb590073451e591b6fd888c) - Annotate type for snowflake POSITION function *(PR [#5964](https://github.com/tobymao/sqlglot/pull/5964) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake POSITION function (#5964)


### :sparkles: New Features
- [`88e4e4c`](https://github.com/tobymao/sqlglot/commit/88e4e4c55f3a113127eb3c82c0be46c29bcf15ab) - **optimizer**: Annotate type for OCTET_LENGTH function *(PR [#5960](https://github.com/tobymao/sqlglot/pull/5960) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`68473ac`](https://github.com/tobymao/sqlglot/commit/68473ac3ec8dc76512dc76819892a1b0324c7ddc) - **optimizer**: Annotate type for snowflake PARSE_URL function *(PR [#5962](https://github.com/tobymao/sqlglot/pull/5962) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`b015a9d`](https://github.com/tobymao/sqlglot/commit/b015a9d944d0a87069a7750ad74953c399d7da34) - **optimizer**: annotate type for Snowflake REGEXP_INSTR function *(commit by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`1f29ba7`](https://github.com/tobymao/sqlglot/commit/1f29ba710f4213beb1a2f993244d7d824f3536ce) - **optimizer**: annotate type for Snowflake PARSE_IP function *(PR [#5961](https://github.com/tobymao/sqlglot/pull/5961) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`bf45d5d`](https://github.com/tobymao/sqlglot/commit/bf45d5d3cb0c0f380824019eb32ec29049268a61) - **optimizer**: annotate types for Snowflake RTRIMMED_LENGTH function *(PR [#5968](https://github.com/tobymao/sqlglot/pull/5968) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`13caa69`](https://github.com/tobymao/sqlglot/commit/13caa6991f003ad7abb590073451e591b6fd888c) - **optimizer**: Annotate type for snowflake POSITION function *(PR [#5964](https://github.com/tobymao/sqlglot/pull/5964) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`1471306`](https://github.com/tobymao/sqlglot/commit/1471306ed317830c294e3654075f55424d14bf5a) - support parse into grant principal and privilege *(PR [#5971](https://github.com/tobymao/sqlglot/pull/5971) by [@eakmanrq](https://github.com/eakmanrq))*

### :bug: Bug Fixes
- [`5432976`](https://github.com/tobymao/sqlglot/commit/543297680755344185e0f306843bc4909f4f75ed) - **bigquery**: allow GRANT as an id var *(PR [#5965](https://github.com/tobymao/sqlglot/pull/5965) by [@treysp](https://github.com/treysp))*

### :wrench: Chores
- [`1514bc6`](https://github.com/tobymao/sqlglot/commit/1514bc640ec129a96aedd9e89bfd5d61e832d6b1) - **optimizer**: add type inference tests for Snowflake RPAD function *(PR [#5967](https://github.com/tobymao/sqlglot/pull/5967) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`050b89d`](https://github.com/tobymao/sqlglot/commit/050b89deb9be842f2ddd07c78ea201ec4eae4779) - **optimizer**: Annotate type for snowflake regexp function *(PR [#5970](https://github.com/tobymao/sqlglot/pull/5970) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*


## [v27.18.0] - 2025-09-25
### :boom: BREAKING CHANGES
- due to [`7f13eaf`](https://github.com/tobymao/sqlglot/commit/7f13eaf7769a3381a56c9209af590835be2f95cd) - Annotate type for snowflake DECOMPRESS_BINARY function *(PR [#5945](https://github.com/tobymao/sqlglot/pull/5945) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake DECOMPRESS_BINARY function (#5945)

- due to [`be12b29`](https://github.com/tobymao/sqlglot/commit/be12b29b5a7bd6d6e09dbd8c17086bd77c19abc0) - Annotate type for snowflake DECOMPRESS_STRING function *(PR [#5947](https://github.com/tobymao/sqlglot/pull/5947) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake DECOMPRESS_STRING function (#5947)

- due to [`1573fef`](https://github.com/tobymao/sqlglot/commit/1573fefac27b5b1215e3d458f8ccf1b9dadbb772) - annotate types for Snowflake JAROWINKLER_SIMILARITY function *(PR [#5950](https://github.com/tobymao/sqlglot/pull/5950) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake JAROWINKLER_SIMILARITY function (#5950)

- due to [`883c6ab`](https://github.com/tobymao/sqlglot/commit/883c6abe589865f478d95604e8d670e57afd04af) - annotate type for Snowflake COLLATION function *(PR [#5939](https://github.com/tobymao/sqlglot/pull/5939) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake COLLATION function (#5939)


### :sparkles: New Features
- [`7f13eaf`](https://github.com/tobymao/sqlglot/commit/7f13eaf7769a3381a56c9209af590835be2f95cd) - **optimizer**: Annotate type for snowflake DECOMPRESS_BINARY function *(PR [#5945](https://github.com/tobymao/sqlglot/pull/5945) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`be12b29`](https://github.com/tobymao/sqlglot/commit/be12b29b5a7bd6d6e09dbd8c17086bd77c19abc0) - **optimizer**: Annotate type for snowflake DECOMPRESS_STRING function *(PR [#5947](https://github.com/tobymao/sqlglot/pull/5947) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`a55fce5`](https://github.com/tobymao/sqlglot/commit/a55fce5310a50af132c5d06bb299fe3f025442c4) - **optimizer**: Annotate type for snowflake LPAD function *(PR [#5948](https://github.com/tobymao/sqlglot/pull/5948) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`05e07aa`](https://github.com/tobymao/sqlglot/commit/05e07aa740d7977a6b42ec15ae4fa9c2168a15f5) - **optimizer**: annotate type for Snowflake INSERT function *(PR [#5942](https://github.com/tobymao/sqlglot/pull/5942) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`6268e10`](https://github.com/tobymao/sqlglot/commit/6268e107a947badaa00508544f5389412806ecd0) - **solr**: initial dialect implementation *(PR [#5946](https://github.com/tobymao/sqlglot/pull/5946) by [@aadel](https://github.com/aadel))*
- [`1573fef`](https://github.com/tobymao/sqlglot/commit/1573fefac27b5b1215e3d458f8ccf1b9dadbb772) - **optimizer**: annotate types for Snowflake JAROWINKLER_SIMILARITY function *(PR [#5950](https://github.com/tobymao/sqlglot/pull/5950) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`883c6ab`](https://github.com/tobymao/sqlglot/commit/883c6abe589865f478d95604e8d670e57afd04af) - **optimizer**: annotate type for Snowflake COLLATION function *(PR [#5939](https://github.com/tobymao/sqlglot/pull/5939) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`627c18d`](https://github.com/tobymao/sqlglot/commit/627c18d7da6bf644bc14c0f17963dea0be20604a) - **mysql**: add valid INTERVAL units *(PR [#5951](https://github.com/tobymao/sqlglot/pull/5951) by [@geooo109](https://github.com/geooo109))*

### :bug: Bug Fixes
- [`3846d4d`](https://github.com/tobymao/sqlglot/commit/3846d4dcdf8cbf8e90b2661083a567ab0547ad3c) - **solr**: properly support OR alternative operator *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`df428d5`](https://github.com/tobymao/sqlglot/commit/df428d516113a47ae50d04cd50a250830589c072) - **parser**: interval identifier followed by END *(PR [#5944](https://github.com/tobymao/sqlglot/pull/5944) by [@geooo109](https://github.com/geooo109))*
- [`e178d16`](https://github.com/tobymao/sqlglot/commit/e178d1674a71e6f35a6acfa8f4a317f0fe2e4516) - **duckdb**: UNNEST as table *(PR [#5953](https://github.com/tobymao/sqlglot/pull/5953) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5952](https://github.com/tobymao/sqlglot/issues/5952) opened by [@denis-komarov](https://github.com/denis-komarov)*
- [`24feb8e`](https://github.com/tobymao/sqlglot/commit/24feb8ee0bc43f3f14fd768c9a0d986355becea2) - **parser**: parse `UPDATE` clauses in any order *(PR [#5958](https://github.com/tobymao/sqlglot/pull/5958) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5956](https://github.com/tobymao/sqlglot/issues/5956) opened by [@sfc-gh-clathrope](https://github.com/sfc-gh-clathrope)*
- [`980f99a`](https://github.com/tobymao/sqlglot/commit/980f99a4cc0613012a189ee5636af37ec736040c) - **snowflake**: properly generate inferred `STRUCT` data types *(PR [#5954](https://github.com/tobymao/sqlglot/pull/5954) by [@georgesittas](https://github.com/georgesittas))*

### :wrench: Chores
- [`c18aaf8`](https://github.com/tobymao/sqlglot/commit/c18aaf80fd7375e89dfc8863da619d84f3257353) - cleanup *(commit by [@tobymao](https://github.com/tobymao))*


## [v27.17.0] - 2025-09-23
### :boom: BREAKING CHANGES
- due to [`f4ad258`](https://github.com/tobymao/sqlglot/commit/f4ad25882951de4e4442dfd5189a56d5a1c5e630) - Annotate types for Snowflake BASE64_DECODE_BINARY function *(PR [#5917](https://github.com/tobymao/sqlglot/pull/5917) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate types for Snowflake BASE64_DECODE_BINARY function (#5917)

- due to [`6d0e3f8`](https://github.com/tobymao/sqlglot/commit/6d0e3f8dcae7ed1a7659ece69b1f94cec5e7300e) - Add parser support to ilike like function versions. *(PR [#5915](https://github.com/tobymao/sqlglot/pull/5915) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Add parser support to ilike like function versions. (#5915)

- due to [`22c7ed7`](https://github.com/tobymao/sqlglot/commit/22c7ed7734b41ca544bb67bcc1ca4151f6d5f05f) - parse tuple *(PR [#5920](https://github.com/tobymao/sqlglot/pull/5920) by [@geooo109](https://github.com/geooo109))*:

  parse tuple (#5920)

- due to [`fc5624e`](https://github.com/tobymao/sqlglot/commit/fc5624eca43d2855ac350c92d85b184a6893d5ca) - annotate types for Snowflake ASCII function *(PR [#5926](https://github.com/tobymao/sqlglot/pull/5926) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake ASCII function (#5926)

- due to [`4e81690`](https://github.com/tobymao/sqlglot/commit/4e8169045edcaa28ae43abeb07370df63846fbfd) - annotate type for Snowflake COLLATE function *(PR [#5931](https://github.com/tobymao/sqlglot/pull/5931) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake COLLATE function (#5931)

- due to [`f07d35d`](https://github.com/tobymao/sqlglot/commit/f07d35d29104c6203efaab738118d1903614b83c) - annotate type for Snowflake CHR function *(PR [#5929](https://github.com/tobymao/sqlglot/pull/5929) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake CHR function (#5929)

- due to [`f8c0ee4`](https://github.com/tobymao/sqlglot/commit/f8c0ee4d3c1a4d4a92b897d1cc85f9904c8e566b) - Add function and annotate snowflake hex decode string and binary functions *(PR [#5928](https://github.com/tobymao/sqlglot/pull/5928) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Add function and annotate snowflake hex decode string and binary functions (#5928)

- due to [`66f9501`](https://github.com/tobymao/sqlglot/commit/66f9501d76d087798bad93e578273ab2a45e2575) - annotate types for Snowflake BIT_LENGTH function *(PR [#5927](https://github.com/tobymao/sqlglot/pull/5927) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake BIT_LENGTH function (#5927)

- due to [`7878437`](https://github.com/tobymao/sqlglot/commit/78784370712df65a2e1e79a1c2b441131ed7222a) - annotate snowflake's `BASE64_DECODE_STRING`, `BASE64_ENCODE` *(PR [#5922](https://github.com/tobymao/sqlglot/pull/5922) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  annotate snowflake's `BASE64_DECODE_STRING`, `BASE64_ENCODE` (#5922)

- due to [`9bcad04`](https://github.com/tobymao/sqlglot/commit/9bcad040bd51dd03821c68eea1a73534fc7a81b7) - Annotate type for HEX ENCODE function. *(PR [#5936](https://github.com/tobymao/sqlglot/pull/5936) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for HEX ENCODE function. (#5936)

- due to [`590928f`](https://github.com/tobymao/sqlglot/commit/590928f4637306e8cf3f1302d5dd5d5dbc76e7e0) - annotate type for Snowflake INITCAP function *(PR [#5941](https://github.com/tobymao/sqlglot/pull/5941) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake INITCAP function (#5941)

- due to [`ac04de1`](https://github.com/tobymao/sqlglot/commit/ac04de1944c7a976406581b489b3cf9b11dafb77) - annotate type for Snowflake EDITDISTANCE function *(PR [#5940](https://github.com/tobymao/sqlglot/pull/5940) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for Snowflake EDITDISTANCE function (#5940)

- due to [`9e28af8`](https://github.com/tobymao/sqlglot/commit/9e28af8a52ced951ecf7f4e85a6305e20a13de1f) - Annotate type for snowflake COMPRESS function *(PR [#5938](https://github.com/tobymao/sqlglot/pull/5938) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate type for snowflake COMPRESS function (#5938)


### :sparkles: New Features
- [`f4ad258`](https://github.com/tobymao/sqlglot/commit/f4ad25882951de4e4442dfd5189a56d5a1c5e630) - **optimizer**: Annotate types for Snowflake BASE64_DECODE_BINARY function *(PR [#5917](https://github.com/tobymao/sqlglot/pull/5917) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`6d0e3f8`](https://github.com/tobymao/sqlglot/commit/6d0e3f8dcae7ed1a7659ece69b1f94cec5e7300e) - **optimizer**: Add parser support to ilike like function versions. *(PR [#5915](https://github.com/tobymao/sqlglot/pull/5915) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`fc5624e`](https://github.com/tobymao/sqlglot/commit/fc5624eca43d2855ac350c92d85b184a6893d5ca) - **optimizer**: annotate types for Snowflake ASCII function *(PR [#5926](https://github.com/tobymao/sqlglot/pull/5926) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`4e81690`](https://github.com/tobymao/sqlglot/commit/4e8169045edcaa28ae43abeb07370df63846fbfd) - **optimizer**: annotate type for Snowflake COLLATE function *(PR [#5931](https://github.com/tobymao/sqlglot/pull/5931) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`f07d35d`](https://github.com/tobymao/sqlglot/commit/f07d35d29104c6203efaab738118d1903614b83c) - **optimizer**: annotate type for Snowflake CHR function *(PR [#5929](https://github.com/tobymao/sqlglot/pull/5929) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`f8c0ee4`](https://github.com/tobymao/sqlglot/commit/f8c0ee4d3c1a4d4a92b897d1cc85f9904c8e566b) - **optimizer**: Add function and annotate snowflake hex decode string and binary functions *(PR [#5928](https://github.com/tobymao/sqlglot/pull/5928) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`66f9501`](https://github.com/tobymao/sqlglot/commit/66f9501d76d087798bad93e578273ab2a45e2575) - **optimizer**: annotate types for Snowflake BIT_LENGTH function *(PR [#5927](https://github.com/tobymao/sqlglot/pull/5927) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`f4c810e`](https://github.com/tobymao/sqlglot/commit/f4c810e043d9379e94efb185e368e27ad9c15715) - transpile Trino `FORMAT` to DuckDB and Snowflake, closes [#5933](https://github.com/tobymao/sqlglot/pull/5933) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`7878437`](https://github.com/tobymao/sqlglot/commit/78784370712df65a2e1e79a1c2b441131ed7222a) - **optimizer**: annotate snowflake's `BASE64_DECODE_STRING`, `BASE64_ENCODE` *(PR [#5922](https://github.com/tobymao/sqlglot/pull/5922) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`9bcad04`](https://github.com/tobymao/sqlglot/commit/9bcad040bd51dd03821c68eea1a73534fc7a81b7) - **optimizer**: Annotate type for HEX ENCODE function. *(PR [#5936](https://github.com/tobymao/sqlglot/pull/5936) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`590928f`](https://github.com/tobymao/sqlglot/commit/590928f4637306e8cf3f1302d5dd5d5dbc76e7e0) - **optimizer**: annotate type for Snowflake INITCAP function *(PR [#5941](https://github.com/tobymao/sqlglot/pull/5941) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`ac04de1`](https://github.com/tobymao/sqlglot/commit/ac04de1944c7a976406581b489b3cf9b11dafb77) - **optimizer**: annotate type for Snowflake EDITDISTANCE function *(PR [#5940](https://github.com/tobymao/sqlglot/pull/5940) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`a385990`](https://github.com/tobymao/sqlglot/commit/a38599080932a8b54a169df8b7a69650cb47b6bc) - **parser**: support wrapped aggregate functions *(PR [#5943](https://github.com/tobymao/sqlglot/pull/5943) by [@geooo109](https://github.com/geooo109))*
- [`9e28af8`](https://github.com/tobymao/sqlglot/commit/9e28af8a52ced951ecf7f4e85a6305e20a13de1f) - **optimizer**: Annotate type for snowflake COMPRESS function *(PR [#5938](https://github.com/tobymao/sqlglot/pull/5938) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*

### :bug: Bug Fixes
- [`6807a32`](https://github.com/tobymao/sqlglot/commit/6807a32cccf984dc13a30b815750b2c41374b845) - escape byte string delimiters *(PR [#5916](https://github.com/tobymao/sqlglot/pull/5916) by [@georgesittas](https://github.com/georgesittas))*
- [`22c7ed7`](https://github.com/tobymao/sqlglot/commit/22c7ed7734b41ca544bb67bcc1ca4151f6d5f05f) - **clickhouse**: parse tuple *(PR [#5920](https://github.com/tobymao/sqlglot/pull/5920) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5913](https://github.com/tobymao/sqlglot/issues/5913) opened by [@tiagoskaneta](https://github.com/tiagoskaneta)*
- [`223160b`](https://github.com/tobymao/sqlglot/commit/223160bd7914d51e9ec1abb8d0f1053e13a65c98) - **parser**: NULLABLE as an identifier *(PR [#5921](https://github.com/tobymao/sqlglot/pull/5921) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5919](https://github.com/tobymao/sqlglot/issues/5919) opened by [@baruchoxman](https://github.com/baruchoxman)*
- [`42cfc79`](https://github.com/tobymao/sqlglot/commit/42cfc79ce120dee83084e2bb6b8bbd19f45bf06f) - **snowflake**: parse DAYOFWEEKISO *(PR [#5925](https://github.com/tobymao/sqlglot/pull/5925) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5924](https://github.com/tobymao/sqlglot/issues/5924) opened by [@baruchoxman](https://github.com/baruchoxman)*
- [`0be2cb4`](https://github.com/tobymao/sqlglot/commit/0be2cb448ee1a5ac020ac47e9944875c30e42632) - **postgres**: support `DISTINCT` qualifier in `JSON_AGG` fixes [#5935](https://github.com/tobymao/sqlglot/pull/5935) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`e34b2e1`](https://github.com/tobymao/sqlglot/commit/e34b2e14d1f87d095955765173a5e17fc9985220) - allow grouping set parser to consume more syntax fixes [#5937](https://github.com/tobymao/sqlglot/pull/5937) *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.16.3] - 2025-09-18
### :bug: Bug Fixes
- [`d127051`](https://github.com/tobymao/sqlglot/commit/d1270517c3e124ca59caf29e4506eb3848f7452e) - precedence issue with column operator parsing *(PR [#5914](https://github.com/tobymao/sqlglot/pull/5914) by [@georgesittas](https://github.com/georgesittas))*


## [v27.16.2] - 2025-09-18
### :wrench: Chores
- [`837890c`](https://github.com/tobymao/sqlglot/commit/837890c7e8bcc3695541bbe32fd8088eee70fea3) - handle badly formed binary expressions gracefully in type inference *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.16.1] - 2025-09-18
### :bug: Bug Fixes
- [`0e256b3`](https://github.com/tobymao/sqlglot/commit/0e256b3f864bc2d026817bd08e89ee89f44ad256) - edge case with parsing `interval` as identifier *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.16.0] - 2025-09-18
### :boom: BREAKING CHANGES
- due to [`5a973e9`](https://github.com/tobymao/sqlglot/commit/5a973e9a88fa7f522a9bf91dc60fb0f6effef53d) - annotate types for Snowflake AI_CLASSIFY function *(PR [#5909](https://github.com/tobymao/sqlglot/pull/5909) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake AI_CLASSIFY function (#5909)

- due to [`2d0d908`](https://github.com/tobymao/sqlglot/commit/2d0d908b5bbc32ff3bc92eb1ae9fc6e5ac3409bc) - produce TableAlias instead of Alias for USING in merge builder *(PR [#5911](https://github.com/tobymao/sqlglot/pull/5911) by [@georgesittas](https://github.com/georgesittas))*:

  produce TableAlias instead of Alias for USING in merge builder (#5911)


### :sparkles: New Features
- [`5a973e9`](https://github.com/tobymao/sqlglot/commit/5a973e9a88fa7f522a9bf91dc60fb0f6effef53d) - **optimizer**: annotate types for Snowflake AI_CLASSIFY function *(PR [#5909](https://github.com/tobymao/sqlglot/pull/5909) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*

### :bug: Bug Fixes
- [`2d0d908`](https://github.com/tobymao/sqlglot/commit/2d0d908b5bbc32ff3bc92eb1ae9fc6e5ac3409bc) - produce TableAlias instead of Alias for USING in merge builder *(PR [#5911](https://github.com/tobymao/sqlglot/pull/5911) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5910](https://github.com/tobymao/sqlglot/issues/5910) opened by [@deepyaman](https://github.com/deepyaman)*

### :wrench: Chores
- [`e8974e7`](https://github.com/tobymao/sqlglot/commit/e8974e70d9956ce7a5cb119ba465660f5f172a17) - **optimizer**: Add tests for snowflake likeall, likeany and ilikeany functions *(PR [#5908](https://github.com/tobymao/sqlglot/pull/5908) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*


## [v27.15.3] - 2025-09-17
### :bug: Bug Fixes
- [`bd3e965`](https://github.com/tobymao/sqlglot/commit/bd3e9655aa72ffef8a9e0221205fa2c3915ef58b) - allow `lock` to be used as an identifier *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.15.2] - 2025-09-17
### :sparkles: New Features
- [`d5cf114`](https://github.com/tobymao/sqlglot/commit/d5cf1149932850a91cb5f1ebecda2652616729ef) - **duckdb**: support INSTALL *(PR [#5904](https://github.com/tobymao/sqlglot/pull/5904) by [@geooo109](https://github.com/geooo109))*
- [`73e05bb`](https://github.com/tobymao/sqlglot/commit/73e05bb15bb86e4a07cc09bf02028a6cf7fa1e6f) - **snowflake**: properly generate `BITNOT` *(PR [#5906](https://github.com/tobymao/sqlglot/pull/5906) by [@YuvalOmerRep](https://github.com/YuvalOmerRep))*
- [`16f317c`](https://github.com/tobymao/sqlglot/commit/16f317c04f7c0a398c38b461e05f4d4c30baf98b) - **snowflake**: add support for `<model>!<attribute>` syntax *(PR [#5907](https://github.com/tobymao/sqlglot/pull/5907) by [@georgesittas](https://github.com/georgesittas))*

### :recycle: Refactors
- [`095b2ac`](https://github.com/tobymao/sqlglot/commit/095b2ac3af230eff86d9bc1b0fd3a0a2095f151c) - clean up duckdb INSTALL tests *(commit by [@geooo109](https://github.com/geooo109))*


## [v27.15.1] - 2025-09-17
### :sparkles: New Features
- [`1ee026d`](https://github.com/tobymao/sqlglot/commit/1ee026d22d4f6c3613c1809a6738cdea846c48a9) - **postgres**: support `SUBSTRING(value FOR length FROM start)` variant *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.15.0] - 2025-09-17
### :boom: BREAKING CHANGES
- due to [`96ae7a3`](https://github.com/tobymao/sqlglot/commit/96ae7a3bcbf9de1932150baa0bd704d4ce05c9f7) - Annotate and add tests for snowflake REPEAT and SPLIT functions *(PR [#5875](https://github.com/tobymao/sqlglot/pull/5875) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate and add tests for snowflake REPEAT and SPLIT functions (#5875)

- due to [`f2d3bf7`](https://github.com/tobymao/sqlglot/commit/f2d3bf74e804e5a5e2ac6ca94210ba04df07e7f3) - annotate types for Snowflake UUID_STRING function *(PR [#5881](https://github.com/tobymao/sqlglot/pull/5881) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake UUID_STRING function (#5881)

- due to [`ec80ff3`](https://github.com/tobymao/sqlglot/commit/ec80ff34957c3e3f80c44175383b06cf72988a68) - make dump a list instead of a nested dict to avoid all recursion errors *(PR [#5885](https://github.com/tobymao/sqlglot/pull/5885) by [@tobymao](https://github.com/tobymao))*:

  make dump a list instead of a nested dict to avoid all recursion errors (#5885)

- due to [`2fdaccd`](https://github.com/tobymao/sqlglot/commit/2fdaccd1a9045bda3d529025a4706c397b8a836f) - annotate types for Snowflake SHA1, SHA2 functions *(PR [#5884](https://github.com/tobymao/sqlglot/pull/5884) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake SHA1, SHA2 functions (#5884)

- due to [`faba309`](https://github.com/tobymao/sqlglot/commit/faba30905390e5efaf0ba9a05aab9ac2724b1b85) - annotate types for Snowflake AI_AGG function *(PR [#5894](https://github.com/tobymao/sqlglot/pull/5894) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake AI_AGG function (#5894)

- due to [`304bec5`](https://github.com/tobymao/sqlglot/commit/304bec5f7342501ad28ea4cd0a4b9aa092f2192f) - Annotate snowflake MD5 functions *(PR [#5883](https://github.com/tobymao/sqlglot/pull/5883) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate snowflake MD5 functions (#5883)

- due to [`c0180ec`](https://github.com/tobymao/sqlglot/commit/c0180ec163a43836fed754efcb6f26ad37cdae50) - annotate types for Snowflake AI_SUMMARIZE_AGG function *(PR [#5902](https://github.com/tobymao/sqlglot/pull/5902) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake AI_SUMMARIZE_AGG function (#5902)

- due to [`f5409df`](https://github.com/tobymao/sqlglot/commit/f5409df64ed6069880669878db687e4b98c3e280) - use column name in struct type annotation *(PR [#5903](https://github.com/tobymao/sqlglot/pull/5903) by [@georgesittas](https://github.com/georgesittas))*:

  use column name in struct type annotation (#5903)


### :sparkles: New Features
- [`cd818ba`](https://github.com/tobymao/sqlglot/commit/cd818bad51e93ec349b97675e4c1f5bd7c4c1522) - **singlestore**: Fixed generation/parsing of computed collumns *(PR [#5878](https://github.com/tobymao/sqlglot/pull/5878) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`5d1f241`](https://github.com/tobymao/sqlglot/commit/5d1f241209197419111e9eda37fb6f2a5ec2bc4b) - **tsql**: support JSON_ARRAYAGG *(PR [#5879](https://github.com/tobymao/sqlglot/pull/5879) by [@geooo109](https://github.com/geooo109))*
- [`96ae7a3`](https://github.com/tobymao/sqlglot/commit/96ae7a3bcbf9de1932150baa0bd704d4ce05c9f7) - **optimizer**: Annotate and add tests for snowflake REPEAT and SPLIT functions *(PR [#5875](https://github.com/tobymao/sqlglot/pull/5875) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`0fe6a25`](https://github.com/tobymao/sqlglot/commit/0fe6a25e366dcbc5a4a0878b285d147a6aa00412) - **postgres**: support JSON_AGG *(PR [#5880](https://github.com/tobymao/sqlglot/pull/5880) by [@geooo109](https://github.com/geooo109))*
- [`854eeeb`](https://github.com/tobymao/sqlglot/commit/854eeeb5b25954cc26b91135d58eb8370271f1de) - **optimizer**: annotate types for Snowflake REGEXP_LIKE, REGEXP_REPLACE, REGEXP_SUBSTR functions *(PR [#5876](https://github.com/tobymao/sqlglot/pull/5876) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`f2d3bf7`](https://github.com/tobymao/sqlglot/commit/f2d3bf74e804e5a5e2ac6ca94210ba04df07e7f3) - **optimizer**: annotate types for Snowflake UUID_STRING function *(PR [#5881](https://github.com/tobymao/sqlglot/pull/5881) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`5b9463a`](https://github.com/tobymao/sqlglot/commit/5b9463ad11a49c821585985c35394ebb30e827dd) - **mysql**: add support for binary `MOD` operator fixes [#5887](https://github.com/tobymao/sqlglot/pull/5887) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`d24eabc`](https://github.com/tobymao/sqlglot/commit/d24eabcbe30dc0f7c2dbae346e429efef58b5680) - **bigquery**: Add support for ML.GENERATE_TEXT_EMBEDDING(...) *(PR [#5891](https://github.com/tobymao/sqlglot/pull/5891) by [@VaggelisD](https://github.com/VaggelisD))*
- [`950a3fa`](https://github.com/tobymao/sqlglot/commit/950a3fa6d6307f7713f40117655da2f9710ebfa9) - **mysql**: SOUNDS LIKE, SUBSTR *(PR [#5886](https://github.com/tobymao/sqlglot/pull/5886) by [@vuvova](https://github.com/vuvova))*
- [`688afc5`](https://github.com/tobymao/sqlglot/commit/688afc55ab08588636eba92893c603ca68e43e6e) - **singlestore**: Fixed generation of exp.National *(PR [#5890](https://github.com/tobymao/sqlglot/pull/5890) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`c77147e`](https://github.com/tobymao/sqlglot/commit/c77147ebaafa6942f80af75dd6c2d7a62a7e6fe2) - **parser**: Extend support for `IS UNKOWN` across all dialects *(PR [#5888](https://github.com/tobymao/sqlglot/pull/5888) by [@VaggelisD](https://github.com/VaggelisD))*
- [`ec80ff3`](https://github.com/tobymao/sqlglot/commit/ec80ff34957c3e3f80c44175383b06cf72988a68) - make dump a list instead of a nested dict to avoid all recursion errors *(PR [#5885](https://github.com/tobymao/sqlglot/pull/5885) by [@tobymao](https://github.com/tobymao))*
- [`2fdaccd`](https://github.com/tobymao/sqlglot/commit/2fdaccd1a9045bda3d529025a4706c397b8a836f) - **optimizer**: annotate types for Snowflake SHA1, SHA2 functions *(PR [#5884](https://github.com/tobymao/sqlglot/pull/5884) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`faba309`](https://github.com/tobymao/sqlglot/commit/faba30905390e5efaf0ba9a05aab9ac2724b1b85) - **optimizer**: annotate types for Snowflake AI_AGG function *(PR [#5894](https://github.com/tobymao/sqlglot/pull/5894) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`dd27844`](https://github.com/tobymao/sqlglot/commit/dd2784435c7bdd2ceaaaaa359fcd112ad1f8190c) - **snowflake**: transpile `BYTE_LENGTH` *(PR [#5899](https://github.com/tobymao/sqlglot/pull/5899) by [@ozadari](https://github.com/ozadari))*
- [`304bec5`](https://github.com/tobymao/sqlglot/commit/304bec5f7342501ad28ea4cd0a4b9aa092f2192f) - **optimizer**: Annotate snowflake MD5 functions *(PR [#5883](https://github.com/tobymao/sqlglot/pull/5883) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`ec3006d`](https://github.com/tobymao/sqlglot/commit/ec3006d815951fdc1a80d6722ce6f1176417d595) - **optimizer**: Add tests for snowflake NOT ILIKE and NOT LIKE *(PR [#5901](https://github.com/tobymao/sqlglot/pull/5901) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`c0180ec`](https://github.com/tobymao/sqlglot/commit/c0180ec163a43836fed754efcb6f26ad37cdae50) - **optimizer**: annotate types for Snowflake AI_SUMMARIZE_AGG function *(PR [#5902](https://github.com/tobymao/sqlglot/pull/5902) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*

### :bug: Bug Fixes
- [`1d9e357`](https://github.com/tobymao/sqlglot/commit/1d9e357fb7549635ca25c6c42299880d7864e074) - **optimizer**: expand columns on the LHS of recursive CTEs *(PR [#5872](https://github.com/tobymao/sqlglot/pull/5872) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5814](https://github.com/tobymao/sqlglot/issues/5814) opened by [@suresh-summation](https://github.com/suresh-summation)*
- [`7fcc52a`](https://github.com/tobymao/sqlglot/commit/7fcc52a22241c480c22b3e6f843e7a210c75a0ec) - **parser**: Require an explicit alias in EXCLUDE/RENAME/REPLACE star ops *(PR [#5892](https://github.com/tobymao/sqlglot/pull/5892) by [@VaggelisD](https://github.com/VaggelisD))*
- [`5fdcc65`](https://github.com/tobymao/sqlglot/commit/5fdcc651277ba4e86e11d0c5952a56e40299a998) - **snowflake**: parse OCTET_LENGTH *(PR [#5900](https://github.com/tobymao/sqlglot/pull/5900) by [@geooo109](https://github.com/geooo109))*
- [`f5409df`](https://github.com/tobymao/sqlglot/commit/f5409df64ed6069880669878db687e4b98c3e280) - **optimizer**: use column name in struct type annotation *(PR [#5903](https://github.com/tobymao/sqlglot/pull/5903) by [@georgesittas](https://github.com/georgesittas))*
- [`74886d8`](https://github.com/tobymao/sqlglot/commit/74886d82f70c9317af51c77b322e67a6aa260a5e) - **snowflake**: transpile BQ UNNEST with alias *(PR [#5897](https://github.com/tobymao/sqlglot/pull/5897) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5895](https://github.com/tobymao/sqlglot/issues/5895) opened by [@YuvalOmerRep](https://github.com/YuvalOmerRep)*


## [v27.14.0] - 2025-09-11
### :boom: BREAKING CHANGES
- due to [`9c8a600`](https://github.com/tobymao/sqlglot/commit/9c8a6001f41816035f391d046eb9692d6f13cefc) - correct parsing of TO_VARCHAR *(PR [#5840](https://github.com/tobymao/sqlglot/pull/5840) by [@geooo109](https://github.com/geooo109))*:

  correct parsing of TO_VARCHAR (#5840)

- due to [`1e9aef1`](https://github.com/tobymao/sqlglot/commit/1e9aef1bb20f4dc5e9c03d59cb3165c235c11ce1) - convert NULL annotations to UNKNOWN *(PR [#5842](https://github.com/tobymao/sqlglot/pull/5842) by [@georgesittas](https://github.com/georgesittas))*:

  convert NULL annotations to UNKNOWN (#5842)

- due to [`44c9e70`](https://github.com/tobymao/sqlglot/commit/44c9e70bd8c9421035eb0e87e4286061ec5d2fa8) - add tests for snowflake STARTSWITH function *(PR [#5847](https://github.com/tobymao/sqlglot/pull/5847) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  add tests for snowflake STARTSWITH function (#5847)

- due to [`0779c2d`](https://github.com/tobymao/sqlglot/commit/0779c2d4e8ce0228592de6882763940783fa5e87) - support BIT_X aggregates again for duckdb, postgres *(PR [#5851](https://github.com/tobymao/sqlglot/pull/5851) by [@georgesittas](https://github.com/georgesittas))*:

  support BIT_X aggregates again for duckdb, postgres (#5851)

- due to [`c50d6e3`](https://github.com/tobymao/sqlglot/commit/c50d6e3c7b96f00d27c34a02c8e0dced21e6c373) - annotate type for snowflake LEFT, RIGHT and SUBSTRING functions *(PR [#5849](https://github.com/tobymao/sqlglot/pull/5849) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  annotate type for snowflake LEFT, RIGHT and SUBSTRING functions (#5849)

- due to [`e441e16`](https://github.com/tobymao/sqlglot/commit/e441e16991626c2da2d38bc9c3a2b408e3f773bd) - make dump/pickling non-recursive to avoid hitting stack limits *(PR [#5850](https://github.com/tobymao/sqlglot/pull/5850) by [@tobymao](https://github.com/tobymao))*:

  make dump/pickling non-recursive to avoid hitting stack limits (#5850)

- due to [`b128339`](https://github.com/tobymao/sqlglot/commit/b12833977e2a395712481cf11e293fdbd70fd4ce) - annotate and add tests for snowflake LENGTH and LOWER functions *(PR [#5856](https://github.com/tobymao/sqlglot/pull/5856) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  annotate and add tests for snowflake LENGTH and LOWER functions (#5856)

- due to [`134957a`](https://github.com/tobymao/sqlglot/commit/134957af11c55a4ab16f58d0725d6bb8ab23eb28) - annotate types for Snowflake TRIM function *(PR [#5811](https://github.com/tobymao/sqlglot/pull/5811) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate types for Snowflake TRIM function (#5811)

- due to [`d3cd6bf`](https://github.com/tobymao/sqlglot/commit/d3cd6bf6e5fbaa490868ee3cd2cc99dd5e40a396) - Annotate and add tests for snowflake REPLACE and SPACE functions *(PR [#5871](https://github.com/tobymao/sqlglot/pull/5871) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  Annotate and add tests for snowflake REPLACE and SPACE functions (#5871)


### :sparkles: New Features
- [`a398fb4`](https://github.com/tobymao/sqlglot/commit/a398fb4df28c868f4cfc34530044b9d7b78e2e90) - **singlestore**: Splitted truncation of multiple tables into several queries *(PR [#5839](https://github.com/tobymao/sqlglot/pull/5839) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`cd27c96`](https://github.com/tobymao/sqlglot/commit/cd27c96fe85aba5f54116f38649edd8db064a5e6) - **snowflake**: transpile `TO_HEX` from bigquery *(PR [#5838](https://github.com/tobymao/sqlglot/pull/5838) by [@YuvalOmerRep](https://github.com/YuvalOmerRep))*
- [`d2e4ab7`](https://github.com/tobymao/sqlglot/commit/d2e4ab7df41ae3601e9b66e1338db3d851729339) - **snowflake**: add tests for endswith function *(PR [#5846](https://github.com/tobymao/sqlglot/pull/5846) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`c50d6e3`](https://github.com/tobymao/sqlglot/commit/c50d6e3c7b96f00d27c34a02c8e0dced21e6c373) - **optimizer**: annotate type for snowflake LEFT, RIGHT and SUBSTRING functions *(PR [#5849](https://github.com/tobymao/sqlglot/pull/5849) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`ca6c8f7`](https://github.com/tobymao/sqlglot/commit/ca6c8f753ba8458544439e20671f0981c98d168d) - **singlestore**: Improved parsting/generation of exp.Show *(PR [#5853](https://github.com/tobymao/sqlglot/pull/5853) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`722eceb`](https://github.com/tobymao/sqlglot/commit/722ecebfa43aa5948031edd1828b6482a241d9ef) - **snowflake**: MD5Digest transpiling to MD5_BINARY *(PR [#5855](https://github.com/tobymao/sqlglot/pull/5855) by [@YuvalOmerRep](https://github.com/YuvalOmerRep))*
- [`b128339`](https://github.com/tobymao/sqlglot/commit/b12833977e2a395712481cf11e293fdbd70fd4ce) - **optimizer**: annotate and add tests for snowflake LENGTH and LOWER functions *(PR [#5856](https://github.com/tobymao/sqlglot/pull/5856) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`134957a`](https://github.com/tobymao/sqlglot/commit/134957af11c55a4ab16f58d0725d6bb8ab23eb28) - **optimizer**: annotate types for Snowflake TRIM function *(PR [#5811](https://github.com/tobymao/sqlglot/pull/5811) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`0475dae`](https://github.com/tobymao/sqlglot/commit/0475dae21231b85407bf778fd9f1abaecdeb68de) - **singlestore**: Marked several exp.Describe args as unsupported *(PR [#5861](https://github.com/tobymao/sqlglot/pull/5861) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`7a07b41`](https://github.com/tobymao/sqlglot/commit/7a07b41b2357149adc6afb50bb98e37e6a3175f1) - **optimizer**: Add tests for snowflake LTRIM and RTRIM functions *(PR [#5857](https://github.com/tobymao/sqlglot/pull/5857) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`fb90666`](https://github.com/tobymao/sqlglot/commit/fb90666ff3e710d70815a68defde3dc85aeef7b3) - **singlestore**: Added collate handling to exp.AlterColumn *(PR [#5864](https://github.com/tobymao/sqlglot/pull/5864) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`2f27692`](https://github.com/tobymao/sqlglot/commit/2f276929d6b6f788eb5b3ee0b1a8a8c108833474) - **snowflake**: JSONFormat transpiling to TO_JSON  *(PR [#5860](https://github.com/tobymao/sqlglot/pull/5860) by [@YuvalOmerRep](https://github.com/YuvalOmerRep))*
- [`487c811`](https://github.com/tobymao/sqlglot/commit/487c8119cbfaf2783f5f17ec90c8e69e4432a4fa) - **singlestore**: Fixed parsing/generation of exp.RenameColumn *(PR [#5865](https://github.com/tobymao/sqlglot/pull/5865) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`76cf4d8`](https://github.com/tobymao/sqlglot/commit/76cf4d892a6d011a2e0020fb1ea82518d4f49e71) - **bigquery**: add support for ML.TRANSLATE func *(PR [#5859](https://github.com/tobymao/sqlglot/pull/5859) by [@geooo109](https://github.com/geooo109))*
- [`a899eb1`](https://github.com/tobymao/sqlglot/commit/a899eb188d5e354d3ed56d1e7c32861eecf3e906) - **singlestore**: Fixed parsing and generation of VECTOR type *(PR [#5854](https://github.com/tobymao/sqlglot/pull/5854) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`0acf076`](https://github.com/tobymao/sqlglot/commit/0acf0769773061fca3ec03125a5d43a4aa9c8e4b) - **postgres**: Support `?|` JSONB operator *(PR [#5866](https://github.com/tobymao/sqlglot/pull/5866) by [@VaggelisD](https://github.com/VaggelisD))*
- [`bd4b278`](https://github.com/tobymao/sqlglot/commit/bd4b2780c32ee52d25b6539d7b4479b6a7f80d18) - **optimizer**: annotate types for Snowflake UPPER function *(PR [#5812](https://github.com/tobymao/sqlglot/pull/5812) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`edab189`](https://github.com/tobymao/sqlglot/commit/edab1890e2c790b737be4995a31667448eff148e) - **postgres**: Support ?& JSONB operator *(PR [#5867](https://github.com/tobymao/sqlglot/pull/5867) by [@VaggelisD](https://github.com/VaggelisD))*
- [`960ec06`](https://github.com/tobymao/sqlglot/commit/960ec069eb275b7b8cc6705dbbb1143159f06237) - **postgres**: Support #- JSONB operator *(PR [#5868](https://github.com/tobymao/sqlglot/pull/5868) by [@VaggelisD](https://github.com/VaggelisD))*
- [`d3cd6bf`](https://github.com/tobymao/sqlglot/commit/d3cd6bf6e5fbaa490868ee3cd2cc99dd5e40a396) - **optimizer**: Annotate and add tests for snowflake REPLACE and SPACE functions *(PR [#5871](https://github.com/tobymao/sqlglot/pull/5871) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`ba22531`](https://github.com/tobymao/sqlglot/commit/ba2253113ea5a7c76c8df7ec9b6faf37da698fa4) - **bigquery**: Add support for ML.FORECAST(...) *(PR [#5873](https://github.com/tobymao/sqlglot/pull/5873) by [@VaggelisD](https://github.com/VaggelisD))*

### :bug: Bug Fixes
- [`9c8a600`](https://github.com/tobymao/sqlglot/commit/9c8a6001f41816035f391d046eb9692d6f13cefc) - **snowflake**: correct parsing of TO_VARCHAR *(PR [#5840](https://github.com/tobymao/sqlglot/pull/5840) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5837](https://github.com/tobymao/sqlglot/issues/5837) opened by [@ultrabear](https://github.com/ultrabear)*
- [`f3d07fd`](https://github.com/tobymao/sqlglot/commit/f3d07fd8a106b034f64bb100291671c0fe39a106) - **snowflake**: Enable parsing of COPY INTO without files list *(PR [#5841](https://github.com/tobymao/sqlglot/pull/5841) by [@whummer](https://github.com/whummer))*
- [`0ffb1fa`](https://github.com/tobymao/sqlglot/commit/0ffb1faac3b32aad845306eed0e000ff0d055554) - **duckdb**: transpile joins without ON/USING to CROSS JOIN *(PR [#5804](https://github.com/tobymao/sqlglot/pull/5804) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5795](https://github.com/tobymao/sqlglot/issues/5795) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`1e9aef1`](https://github.com/tobymao/sqlglot/commit/1e9aef1bb20f4dc5e9c03d59cb3165c235c11ce1) - **optimizer**: convert NULL annotations to UNKNOWN *(PR [#5842](https://github.com/tobymao/sqlglot/pull/5842) by [@georgesittas](https://github.com/georgesittas))*
- [`bbcf0d4`](https://github.com/tobymao/sqlglot/commit/bbcf0d4404ea014f08319c44313719b4377adcdb) - **duckdb**: support trailing commas before `FOR` in pivot, fixes [#5843](https://github.com/tobymao/sqlglot/pull/5843) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`ad8a408`](https://github.com/tobymao/sqlglot/commit/ad8a408a4e3e26e32472fc55c67b44687992ae47) - **parser**: more robust nested pipe syntax *(PR [#5845](https://github.com/tobymao/sqlglot/pull/5845) by [@geooo109](https://github.com/geooo109))*
- [`44c9e70`](https://github.com/tobymao/sqlglot/commit/44c9e70bd8c9421035eb0e87e4286061ec5d2fa8) - **optimizer**: add tests for snowflake STARTSWITH function *(PR [#5847](https://github.com/tobymao/sqlglot/pull/5847) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`0779c2d`](https://github.com/tobymao/sqlglot/commit/0779c2d4e8ce0228592de6882763940783fa5e87) - support BIT_X aggregates again for duckdb, postgres *(PR [#5851](https://github.com/tobymao/sqlglot/pull/5851) by [@georgesittas](https://github.com/georgesittas))*
- [`d131aab`](https://github.com/tobymao/sqlglot/commit/d131aab6815bf77d444a763d9bb4028d8f0e742d) - **redshift**: convert FETCH clauses to LIMIT for Redshift dialect *(PR [#5848](https://github.com/tobymao/sqlglot/pull/5848) by [@tomasmontielp](https://github.com/tomasmontielp))*
- [`b22c4ec`](https://github.com/tobymao/sqlglot/commit/b22c4ecf4c032d89ca737f01d614102aa9c2b1ed) - **fabric**: UUID to UNIQUEIDENTIFIER *(PR [#5863](https://github.com/tobymao/sqlglot/pull/5863) by [@fresioAS](https://github.com/fresioAS))*
- [`03d4f49`](https://github.com/tobymao/sqlglot/commit/03d4f49d92cd034d37074359b8c2cf96c5c3f5cf) - **clickhouse**: arrays are 1-indexed *(PR [#5862](https://github.com/tobymao/sqlglot/pull/5862) by [@joeyutong](https://github.com/joeyutong))*

### :recycle: Refactors
- [`e441e16`](https://github.com/tobymao/sqlglot/commit/e441e16991626c2da2d38bc9c3a2b408e3f773bd) - make dump/pickling non-recursive to avoid hitting stack limits *(PR [#5850](https://github.com/tobymao/sqlglot/pull/5850) by [@tobymao](https://github.com/tobymao))*

### :wrench: Chores
- [`b244f30`](https://github.com/tobymao/sqlglot/commit/b244f30524846bd08d03a73410ae9b4674254ecd) - move `exp.Contains` to `BOOLEAN` entry in `TYPE_TO_EXPRESSIONS` *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.13.2] - 2025-09-08
### :bug: Bug Fixes
- [`5e7979f`](https://github.com/tobymao/sqlglot/commit/5e7979f3cf5f7996e198ddd81069d49a4a3b9391) - select session *(PR [#5836](https://github.com/tobymao/sqlglot/pull/5836) by [@tobymao](https://github.com/tobymao))*


## [v27.13.1] - 2025-09-08
### :bug: Bug Fixes
- [`f3d55c0`](https://github.com/tobymao/sqlglot/commit/f3d55c05c8411c9871f8ca4d23f726f976c9236b) - remove always token *(PR [#5832](https://github.com/tobymao/sqlglot/pull/5832) by [@tobymao](https://github.com/tobymao))*
- [`1724775`](https://github.com/tobymao/sqlglot/commit/1724775429f66c2768864c8f96ace861eaa435fd) - suppert types() with no args *(PR [#5833](https://github.com/tobymao/sqlglot/pull/5833) by [@tobymao](https://github.com/tobymao))*
- [`31c82c6`](https://github.com/tobymao/sqlglot/commit/31c82c6d6cd402e59cb59a94daafd22410eae0f6) - support `case.*` *(PR [#5835](https://github.com/tobymao/sqlglot/pull/5835) by [@georgesittas](https://github.com/georgesittas))*
- [`c00f73b`](https://github.com/tobymao/sqlglot/commit/c00f73bac2530a62c25093c60bf02d0a4231bb0b) - window spec no and only exclude *(PR [#5834](https://github.com/tobymao/sqlglot/pull/5834) by [@tobymao](https://github.com/tobymao))*


## [v27.13.0] - 2025-09-08
### :boom: BREAKING CHANGES
- due to [`3726b33`](https://github.com/tobymao/sqlglot/commit/3726b33bb6b4ab286617f510e96e1fbd27c429f3) - support nulls_first arg for array_sort *(PR [#5802](https://github.com/tobymao/sqlglot/pull/5802) by [@treysp](https://github.com/treysp))*:

  support nulls_first arg for array_sort (#5802)

- due to [`cf1d1e3`](https://github.com/tobymao/sqlglot/commit/cf1d1e3e0ef9e6cd1b1c6128c63ddf06c30f1339) - annotate type for snowflake's REVERSE function *(PR [#5803](https://github.com/tobymao/sqlglot/pull/5803) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*:

  annotate type for snowflake's REVERSE function (#5803)

- due to [`ad0b407`](https://github.com/tobymao/sqlglot/commit/ad0b407098e1611d4fc0e1f0916511337b9aefdb) - Mark 'BEGIN' as TokenType.BEGIN for transactions *(PR [#5826](https://github.com/tobymao/sqlglot/pull/5826) by [@VaggelisD](https://github.com/VaggelisD))*:

  Mark 'BEGIN' as TokenType.BEGIN for transactions (#5826)

- due to [`0198282`](https://github.com/tobymao/sqlglot/commit/0198282a82bbf3e81476e164718d63fd1210acdc) - : Update tests for concat string function *(PR [#5809](https://github.com/tobymao/sqlglot/pull/5809) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  : Update tests for concat string function (#5809)

- due to [`db2c430`](https://github.com/tobymao/sqlglot/commit/db2c4303237a1244070c359245c398a724df6de2) - annoate the "contains" function *(PR [#5829](https://github.com/tobymao/sqlglot/pull/5829) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*:

  annoate the "contains" function (#5829)


### :sparkles: New Features
- [`cf1d1e3`](https://github.com/tobymao/sqlglot/commit/cf1d1e3e0ef9e6cd1b1c6128c63ddf06c30f1339) - **optimizer**: annotate type for snowflake's REVERSE function *(PR [#5803](https://github.com/tobymao/sqlglot/pull/5803) by [@fivetran-BradfordPaskewitz](https://github.com/fivetran-BradfordPaskewitz))*
- [`1d07c52`](https://github.com/tobymao/sqlglot/commit/1d07c52badb2e392e6895cbb275d2224789366c9) - **SingleStore**: Implemented generation of CURRENT_DATETIME *(PR [#5816](https://github.com/tobymao/sqlglot/pull/5816) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`cad4fd0`](https://github.com/tobymao/sqlglot/commit/cad4fd0c5b0ec90e693fa6883af0ab287b921019) - **singlestore**: Added handling of exp.JSONObject *(PR [#5817](https://github.com/tobymao/sqlglot/pull/5817) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e3cb076`](https://github.com/tobymao/sqlglot/commit/e3cb0766bd5c3ccb31ea52cfc76201f548798dc1) - **singlestore**: Implemented generation of exp.StandardHash *(PR [#5823](https://github.com/tobymao/sqlglot/pull/5823) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`0198282`](https://github.com/tobymao/sqlglot/commit/0198282a82bbf3e81476e164718d63fd1210acdc) - **optimizer**: : Update tests for concat string function *(PR [#5809](https://github.com/tobymao/sqlglot/pull/5809) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*
- [`4e8a436`](https://github.com/tobymao/sqlglot/commit/4e8a436c16f487a72bd1ac2432bcb1c46599d901) - **singlestore**: Added generation of exp.JSONExists *(PR [#5820](https://github.com/tobymao/sqlglot/pull/5820) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`82bea49`](https://github.com/tobymao/sqlglot/commit/82bea49978ae459492b5127a2a52049826e2fd06) - **singlestore**: Refactored parsing of JSON_BUILD_OBJECT *(PR [#5828](https://github.com/tobymao/sqlglot/pull/5828) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`f7d38c3`](https://github.com/tobymao/sqlglot/commit/f7d38c3a10c505346f04e39a2712d60b4c96370f) - **singlestore**: Implemented generation of exp.Stuff *(PR [#5825](https://github.com/tobymao/sqlglot/pull/5825) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`030a5b5`](https://github.com/tobymao/sqlglot/commit/030a5b5ea03ecee869b07cfd27f4ea044732822e) - **singlestore**: Added generation of exp.JSONBExists *(PR [#5821](https://github.com/tobymao/sqlglot/pull/5821) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e58fef1`](https://github.com/tobymao/sqlglot/commit/e58fef1d6dc654a3b36461bcbea21c99cdc96477) - **singlestore**: Implemented parsing and generation of exp.MatchAgainst *(PR [#5822](https://github.com/tobymao/sqlglot/pull/5822) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e94f530`](https://github.com/tobymao/sqlglot/commit/e94f530af0e0cdad995b4c8dc5ed86953490d37f) - **singlestore**: Added handling of exp.JSONArray *(PR [#5818](https://github.com/tobymao/sqlglot/pull/5818) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`1c42ef4`](https://github.com/tobymao/sqlglot/commit/1c42ef4374aeab8a1ee9848892d7f8c4511c7f04) - **singlestore**: Fixed parsing/generation of exp.JSONArrayAgg *(PR [#5819](https://github.com/tobymao/sqlglot/pull/5819) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`67219f0`](https://github.com/tobymao/sqlglot/commit/67219f0606231514f430e146e2fdb99e796f718b) - **singlestore**: Added support of UTC_TIMESTAMP and CURRENT_TIMESTAMP *(PR [#5808](https://github.com/tobymao/sqlglot/pull/5808) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`db2c430`](https://github.com/tobymao/sqlglot/commit/db2c4303237a1244070c359245c398a724df6de2) - **optimizer**: annoate the "contains" function *(PR [#5829](https://github.com/tobymao/sqlglot/pull/5829) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*

### :bug: Bug Fixes
- [`3726b33`](https://github.com/tobymao/sqlglot/commit/3726b33bb6b4ab286617f510e96e1fbd27c429f3) - **snowflake**: support nulls_first arg for array_sort *(PR [#5802](https://github.com/tobymao/sqlglot/pull/5802) by [@treysp](https://github.com/treysp))*
- [`3408de0`](https://github.com/tobymao/sqlglot/commit/3408de09e50d2510c1a6f511dc2dec357059044f) - parsing quoted built-in data types *(PR [#5810](https://github.com/tobymao/sqlglot/pull/5810) by [@treysp](https://github.com/treysp))*
- [`ad0b407`](https://github.com/tobymao/sqlglot/commit/ad0b407098e1611d4fc0e1f0916511337b9aefdb) - **postgres**: Mark 'BEGIN' as TokenType.BEGIN for transactions *(PR [#5826](https://github.com/tobymao/sqlglot/pull/5826) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5815](https://github.com/tobymao/sqlglot/issues/5815) opened by [@karakanb](https://github.com/karakanb)*
- [`e1a1b5b`](https://github.com/tobymao/sqlglot/commit/e1a1b5befefb0ca30ac1310cecb82a44f6089034) - **snowflake**: transpile BigQuery's `&` to `BITAND` *(PR [#5827](https://github.com/tobymao/sqlglot/pull/5827) by [@YuvalOmerRep](https://github.com/YuvalOmerRep))*
- [`32d0278`](https://github.com/tobymao/sqlglot/commit/32d027827eaa7aa0cd9faf2ac1f84739f914050f) - parse and generation of BITWISE AGG funcs across dialects *(PR [#5831](https://github.com/tobymao/sqlglot/pull/5831) by [@geooo109](https://github.com/geooo109))*
- [`5f39a83`](https://github.com/tobymao/sqlglot/commit/5f39a83f1ff957aca57eb4745f83c296436acaac) - **bigquery**: properly generate `LIMIT` for `STRING_AGG` *(PR [#5830](https://github.com/tobymao/sqlglot/pull/5830) by [@georgesittas](https://github.com/georgesittas))*

### :wrench: Chores
- [`164fec1`](https://github.com/tobymao/sqlglot/commit/164fec1b36e3c7df41e2e5a5ad6b226fc5f76305) - **optimizer**: test type annotation for snowflake CHARINDEX function *(PR [#5805](https://github.com/tobymao/sqlglot/pull/5805) by [@fivetran-amrutabhimsenayachit](https://github.com/fivetran-amrutabhimsenayachit))*


## [v27.12.0] - 2025-09-04
### :boom: BREAKING CHANGES
- due to [`1c551d5`](https://github.com/tobymao/sqlglot/commit/1c551d5ed3315e314013c1f063deabd9d8613e5d) - parse and annotate type for bq TO_JSON *(PR [#5768](https://github.com/tobymao/sqlglot/pull/5768) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq TO_JSON (#5768)

- due to [`1707f2d`](https://github.com/tobymao/sqlglot/commit/1707f2d7f9d3b58e8c216db638f8e572f9fe6f13) - annotate type for ABS *(PR [#5770](https://github.com/tobymao/sqlglot/pull/5770) by [@geooo109](https://github.com/geooo109))*:

  annotate type for ABS (#5770)

- due to [`69acc51`](https://github.com/tobymao/sqlglot/commit/69acc5142b2d4f0b30832c350aa49f16d1adabef) - annotate type for bq IS_INF, IS_NAN *(PR [#5771](https://github.com/tobymao/sqlglot/pull/5771) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq IS_INF, IS_NAN (#5771)

- due to [`0da2076`](https://github.com/tobymao/sqlglot/commit/0da207652331920416b29e2cc67bdc3c3f964466) - annotate type for bq CBRT *(PR [#5772](https://github.com/tobymao/sqlglot/pull/5772) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq CBRT (#5772)

- due to [`a4968cb`](https://github.com/tobymao/sqlglot/commit/a4968cb5693670c1a2e9cd2c86404dd90fd76160) - annotate type for bq RAND *(PR [#5774](https://github.com/tobymao/sqlglot/pull/5774) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq RAND (#5774)

- due to [`3e63350`](https://github.com/tobymao/sqlglot/commit/3e63350bd1d58b510cecd1a573d27be3fd2565ce) - parse and annotate type for bq ACOS *(PR [#5776](https://github.com/tobymao/sqlglot/pull/5776) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq ACOS (#5776)

- due to [`2be9d01`](https://github.com/tobymao/sqlglot/commit/2be9d01830c778186dc274c94c6db0dd6c4116d1) - parse and annotate type for bq ACOSH *(PR [#5779](https://github.com/tobymao/sqlglot/pull/5779) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq ACOSH (#5779)

- due to [`b77d3da`](https://github.com/tobymao/sqlglot/commit/b77d3da8f2548858d2b9d8590fcde83e1ec62b8a) - remove `"EXCLUDE" -> TokenType.EXCEPT` in DuckDB, Snowflake *(PR [#5766](https://github.com/tobymao/sqlglot/pull/5766) by [@treysp](https://github.com/treysp))*:

  remove `"EXCLUDE" -> TokenType.EXCEPT` in DuckDB, Snowflake (#5766)

- due to [`7da2f31`](https://github.com/tobymao/sqlglot/commit/7da2f31d6613f16585e98c3fa1f592c617ae40c9) - parse and annotate type for bq ASIN/H *(PR [#5783](https://github.com/tobymao/sqlglot/pull/5783) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq ASIN/H (#5783)

- due to [`341ea83`](https://github.com/tobymao/sqlglot/commit/341ea83a07c707fdbf565b8d9ef4b9b6341ed1d5) - parse and annotate type for bq ATAN/H/2 *(PR [#5784](https://github.com/tobymao/sqlglot/pull/5784) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq ATAN/H/2 (#5784)

- due to [`aa360cb`](https://github.com/tobymao/sqlglot/commit/aa360cb0e204aa056557ff8b15aa2d4f678430e6) - use regexp_like as it exists *(PR [#5781](https://github.com/tobymao/sqlglot/pull/5781) by [@jasonthomassql](https://github.com/jasonthomassql))*:

  use regexp_like as it exists (#5781)

- due to [`c2a1ad4`](https://github.com/tobymao/sqlglot/commit/c2a1ad4050771401a5b26bcadd90060e4527fbff) - parse and annotate type for bq COT/H *(PR [#5786](https://github.com/tobymao/sqlglot/pull/5786) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq COT/H (#5786)

- due to [`316ae91`](https://github.com/tobymao/sqlglot/commit/316ae913d8b1a63f3071ebb1b826328108d74cef) - Added handling of UTC_DATE and exp.CurrentDate *(PR [#5785](https://github.com/tobymao/sqlglot/pull/5785) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*:

  Added handling of UTC_DATE and exp.CurrentDate (#5785)

- due to [`2c6d237`](https://github.com/tobymao/sqlglot/commit/2c6d23742ea9fcc2b9c784315d3d5364e360fea5) - parse and annotate type for bq CSC/H *(PR [#5787](https://github.com/tobymao/sqlglot/pull/5787) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq CSC/H (#5787)

- due to [`8a35076`](https://github.com/tobymao/sqlglot/commit/8a350763c2337f6910a5f0e19af387ba488fcb70) - parse and annotate type for bq SEC/H *(PR [#5788](https://github.com/tobymao/sqlglot/pull/5788) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq SEC/H (#5788)

- due to [`79901cb`](https://github.com/tobymao/sqlglot/commit/79901cb506737ae1932fa44a705858d2597ee587) - parse and annotate type for bq SIN\H *(PR [#5790](https://github.com/tobymao/sqlglot/pull/5790) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq SIN\H (#5790)

- due to [`74fb547`](https://github.com/tobymao/sqlglot/commit/74fb5476def1b389da425885db56bd6592fd7f78) - parse and annotate type for bq RANGE_BUCKET *(PR [#5793](https://github.com/tobymao/sqlglot/pull/5793) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq RANGE_BUCKET (#5793)

- due to [`eca65e8`](https://github.com/tobymao/sqlglot/commit/eca65e8b79f65850b014a4cb7913ba4a5861dbe9) - parse and annotate type for bq COSINE/EUCLIDEAN_DISTANCE *(PR [#5792](https://github.com/tobymao/sqlglot/pull/5792) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq COSINE/EUCLIDEAN_DISTANCE (#5792)

- due to [`a180d3f`](https://github.com/tobymao/sqlglot/commit/a180d3f2f9f3938611027269028c03274aa1889c) - parse and annotate type for bq SAFE math funcs *(PR [#5797](https://github.com/tobymao/sqlglot/pull/5797) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq SAFE math funcs (#5797)

- due to [`fc7ad7a`](https://github.com/tobymao/sqlglot/commit/fc7ad7a4d953424b56542eacfe1835f5789921c7) - parse ALTER SESSION  *(PR [#5734](https://github.com/tobymao/sqlglot/pull/5734) by [@tekumara](https://github.com/tekumara))*:

  parse ALTER SESSION  (#5734)

- due to [`8ec1a6c`](https://github.com/tobymao/sqlglot/commit/8ec1a6cf5a8edc2d834c713ce0fd8d87237f11ed) - annotate type for bq STRING_AGG *(PR [#5798](https://github.com/tobymao/sqlglot/pull/5798) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq STRING_AGG (#5798)

- due to [`dd97bfa`](https://github.com/tobymao/sqlglot/commit/dd97bfa1dc2f86b727c55b06b3c54b18c02e360d) - annotate type for bq DATETIME_TRUNC *(PR [#5799](https://github.com/tobymao/sqlglot/pull/5799) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq DATETIME_TRUNC (#5799)

- due to [`d3e9dda`](https://github.com/tobymao/sqlglot/commit/d3e9dda183695dd1e4a9832a6671bccc6db561a0) - annotate type for bq GENERATE_UUID *(commit by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq GENERATE_UUID


### :sparkles: New Features
- [`1c551d5`](https://github.com/tobymao/sqlglot/commit/1c551d5ed3315e314013c1f063deabd9d8613e5d) - **optimizer**: parse and annotate type for bq TO_JSON *(PR [#5768](https://github.com/tobymao/sqlglot/pull/5768) by [@geooo109](https://github.com/geooo109))*
- [`a024d48`](https://github.com/tobymao/sqlglot/commit/a024d48fedd049796329050a1f51822dd1388695) - **singlestore**: Added generation of exp.TsOrDsDiff *(PR [#5769](https://github.com/tobymao/sqlglot/pull/5769) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`1707f2d`](https://github.com/tobymao/sqlglot/commit/1707f2d7f9d3b58e8c216db638f8e572f9fe6f13) - **optimizer**: annotate type for ABS *(PR [#5770](https://github.com/tobymao/sqlglot/pull/5770) by [@geooo109](https://github.com/geooo109))*
- [`69acc51`](https://github.com/tobymao/sqlglot/commit/69acc5142b2d4f0b30832c350aa49f16d1adabef) - **optimizer**: annotate type for bq IS_INF, IS_NAN *(PR [#5771](https://github.com/tobymao/sqlglot/pull/5771) by [@geooo109](https://github.com/geooo109))*
- [`0da2076`](https://github.com/tobymao/sqlglot/commit/0da207652331920416b29e2cc67bdc3c3f964466) - **optimizer**: annotate type for bq CBRT *(PR [#5772](https://github.com/tobymao/sqlglot/pull/5772) by [@geooo109](https://github.com/geooo109))*
- [`a4968cb`](https://github.com/tobymao/sqlglot/commit/a4968cb5693670c1a2e9cd2c86404dd90fd76160) - **optimizer**: annotate type for bq RAND *(PR [#5774](https://github.com/tobymao/sqlglot/pull/5774) by [@geooo109](https://github.com/geooo109))*
- [`dd7781a`](https://github.com/tobymao/sqlglot/commit/dd7781a15b842a5826714958ed7af9024903cd1e) - **singlestore**: Fixed generation of exp.Collate *(PR [#5775](https://github.com/tobymao/sqlglot/pull/5775) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`fb684cb`](https://github.com/tobymao/sqlglot/commit/fb684cbdb6178ddc441f598cc1a6e914291cd00e) - **singelstore**: Fixed generation of exp.RegexpILike *(PR [#5777](https://github.com/tobymao/sqlglot/pull/5777) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`3e63350`](https://github.com/tobymao/sqlglot/commit/3e63350bd1d58b510cecd1a573d27be3fd2565ce) - **optimizer**: parse and annotate type for bq ACOS *(PR [#5776](https://github.com/tobymao/sqlglot/pull/5776) by [@geooo109](https://github.com/geooo109))*
- [`8705a78`](https://github.com/tobymao/sqlglot/commit/8705a787df034b4cecb4ba95e9599772c5561ba9) - **singlestore**: Fixed generation of exp.CastToStrType *(PR [#5778](https://github.com/tobymao/sqlglot/pull/5778) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e3c35ad`](https://github.com/tobymao/sqlglot/commit/e3c35ade797f46549cc803e1acd8816041713a10) - **singlestore**: Fixed generation of exp.UnicodeString *(PR [#5773](https://github.com/tobymao/sqlglot/pull/5773) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`2be9d01`](https://github.com/tobymao/sqlglot/commit/2be9d01830c778186dc274c94c6db0dd6c4116d1) - **optimizer**: parse and annotate type for bq ACOSH *(PR [#5779](https://github.com/tobymao/sqlglot/pull/5779) by [@geooo109](https://github.com/geooo109))*
- [`7da2f31`](https://github.com/tobymao/sqlglot/commit/7da2f31d6613f16585e98c3fa1f592c617ae40c9) - **optimizer**: parse and annotate type for bq ASIN/H *(PR [#5783](https://github.com/tobymao/sqlglot/pull/5783) by [@geooo109](https://github.com/geooo109))*
- [`341ea83`](https://github.com/tobymao/sqlglot/commit/341ea83a07c707fdbf565b8d9ef4b9b6341ed1d5) - **optimizer**: parse and annotate type for bq ATAN/H/2 *(PR [#5784](https://github.com/tobymao/sqlglot/pull/5784) by [@geooo109](https://github.com/geooo109))*
- [`be54a45`](https://github.com/tobymao/sqlglot/commit/be54a458413ce3be6c321e5f4feb3e5df5ee6d08) - **singlestore**: Implemented generation of exp.Cbrt *(PR [#5782](https://github.com/tobymao/sqlglot/pull/5782) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`aa360cb`](https://github.com/tobymao/sqlglot/commit/aa360cb0e204aa056557ff8b15aa2d4f678430e6) - **databricks**: use regexp_like as it exists *(PR [#5781](https://github.com/tobymao/sqlglot/pull/5781) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`c2a1ad4`](https://github.com/tobymao/sqlglot/commit/c2a1ad4050771401a5b26bcadd90060e4527fbff) - **optimizer**: parse and annotate type for bq COT/H *(PR [#5786](https://github.com/tobymao/sqlglot/pull/5786) by [@geooo109](https://github.com/geooo109))*
- [`316ae91`](https://github.com/tobymao/sqlglot/commit/316ae913d8b1a63f3071ebb1b826328108d74cef) - **singlestore**: Added handling of UTC_DATE and exp.CurrentDate *(PR [#5785](https://github.com/tobymao/sqlglot/pull/5785) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`2c6d237`](https://github.com/tobymao/sqlglot/commit/2c6d23742ea9fcc2b9c784315d3d5364e360fea5) - **optimizer**: parse and annotate type for bq CSC/H *(PR [#5787](https://github.com/tobymao/sqlglot/pull/5787) by [@geooo109](https://github.com/geooo109))*
- [`8a35076`](https://github.com/tobymao/sqlglot/commit/8a350763c2337f6910a5f0e19af387ba488fcb70) - **optimizer**: parse and annotate type for bq SEC/H *(PR [#5788](https://github.com/tobymao/sqlglot/pull/5788) by [@geooo109](https://github.com/geooo109))*
- [`566bfb2`](https://github.com/tobymao/sqlglot/commit/566bfb2a64a64b74da63b3a89d68caf702ab6522) - **singlestore**: Added support of UTC_TIME and CURRENT_TIME *(PR [#5789](https://github.com/tobymao/sqlglot/pull/5789) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`79901cb`](https://github.com/tobymao/sqlglot/commit/79901cb506737ae1932fa44a705858d2597ee587) - **optimizer**: parse and annotate type for bq SIN\H *(PR [#5790](https://github.com/tobymao/sqlglot/pull/5790) by [@geooo109](https://github.com/geooo109))*
- [`74fb547`](https://github.com/tobymao/sqlglot/commit/74fb5476def1b389da425885db56bd6592fd7f78) - **optimizer**: parse and annotate type for bq RANGE_BUCKET *(PR [#5793](https://github.com/tobymao/sqlglot/pull/5793) by [@geooo109](https://github.com/geooo109))*
- [`eca65e8`](https://github.com/tobymao/sqlglot/commit/eca65e8b79f65850b014a4cb7913ba4a5861dbe9) - **optimizer**: parse and annotate type for bq COSINE/EUCLIDEAN_DISTANCE *(PR [#5792](https://github.com/tobymao/sqlglot/pull/5792) by [@geooo109](https://github.com/geooo109))*
- [`a180d3f`](https://github.com/tobymao/sqlglot/commit/a180d3f2f9f3938611027269028c03274aa1889c) - **optimizer**: parse and annotate type for bq SAFE math funcs *(PR [#5797](https://github.com/tobymao/sqlglot/pull/5797) by [@geooo109](https://github.com/geooo109))*
- [`fc7ad7a`](https://github.com/tobymao/sqlglot/commit/fc7ad7a4d953424b56542eacfe1835f5789921c7) - **snowflake**: parse ALTER SESSION  *(PR [#5734](https://github.com/tobymao/sqlglot/pull/5734) by [@tekumara](https://github.com/tekumara))*
- [`8ec1a6c`](https://github.com/tobymao/sqlglot/commit/8ec1a6cf5a8edc2d834c713ce0fd8d87237f11ed) - **optimizer**: annotate type for bq STRING_AGG *(PR [#5798](https://github.com/tobymao/sqlglot/pull/5798) by [@geooo109](https://github.com/geooo109))*
- [`dd97bfa`](https://github.com/tobymao/sqlglot/commit/dd97bfa1dc2f86b727c55b06b3c54b18c02e360d) - **optimizer**: annotate type for bq DATETIME_TRUNC *(PR [#5799](https://github.com/tobymao/sqlglot/pull/5799) by [@geooo109](https://github.com/geooo109))*
- [`d3e9dda`](https://github.com/tobymao/sqlglot/commit/d3e9dda183695dd1e4a9832a6671bccc6db561a0) - **optimizer**: annotate type for bq GENERATE_UUID *(commit by [@geooo109](https://github.com/geooo109))*

### :bug: Bug Fixes
- [`d8f6a37`](https://github.com/tobymao/sqlglot/commit/d8f6a376ba1fcca48e4a65923dd7a319ce6cfb91) - **optimizer**: allow aliased negative integer literal as group by column *(PR [#5791](https://github.com/tobymao/sqlglot/pull/5791) by [@treysp](https://github.com/treysp))*
- [`1259576`](https://github.com/tobymao/sqlglot/commit/1259576283f1d45abb70ec40c60e500214a27b6f) - **hive**: DATE_SUB to DATE_ADD use parens if needed *(PR [#5796](https://github.com/tobymao/sqlglot/pull/5796) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5794](https://github.com/tobymao/sqlglot/issues/5794) opened by [@mingelchan](https://github.com/mingelchan)*
- [`b0516b4`](https://github.com/tobymao/sqlglot/commit/b0516b4bc9cf2bba2cb57e6bb79ff09b5e2244e3) - **optimizer**: Do not qualify columns if a projection coflicts with a source *(PR [#5780](https://github.com/tobymao/sqlglot/pull/5780) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5262](https://github.com/TobikoData/sqlmesh/issues/5262) opened by [@mChlopek](https://github.com/mChlopek)*
- [`8af0d40`](https://github.com/tobymao/sqlglot/commit/8af0d40055450f71b7e36e576f4a9a1104bc02b2) - **parser**: address edge case where `values` is used as an identifier *(PR [#5801](https://github.com/tobymao/sqlglot/pull/5801) by [@georgesittas](https://github.com/georgesittas))*

### :wrench: Chores
- [`b77d3da`](https://github.com/tobymao/sqlglot/commit/b77d3da8f2548858d2b9d8590fcde83e1ec62b8a) - remove `"EXCLUDE" -> TokenType.EXCEPT` in DuckDB, Snowflake *(PR [#5766](https://github.com/tobymao/sqlglot/pull/5766) by [@treysp](https://github.com/treysp))*
- [`005564a`](https://github.com/tobymao/sqlglot/commit/005564ab28cb14be469f09e89b01275d6e25874e) - **snowflake**: refactor logic related to ALTER SESSION *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.11.0] - 2025-09-03
### :boom: BREAKING CHANGES
- due to [`baffd2c`](https://github.com/tobymao/sqlglot/commit/baffd2c0be9657683781f3f8831c47e32dbf68bb) - parse and annotate type for bq REGEXP_INSTR *(PR [#5710](https://github.com/tobymao/sqlglot/pull/5710) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq REGEXP_INSTR (#5710)

- due to [`b79eb19`](https://github.com/tobymao/sqlglot/commit/b79eb198cc21203efa82128b357d435338e9133d) - annotate type for bq ROW_NUMBER *(PR [#5716](https://github.com/tobymao/sqlglot/pull/5716) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq ROW_NUMBER (#5716)

- due to [`f709bef`](https://github.com/tobymao/sqlglot/commit/f709bef3af7cd0daa25fe3d58b1753c3e65720ef) - annotate type for bq FIRST_VALUE *(PR [#5718](https://github.com/tobymao/sqlglot/pull/5718) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq FIRST_VALUE (#5718)

- due to [`15a9061`](https://github.com/tobymao/sqlglot/commit/15a906170e5d5cdaa207ec7607edfdd7d4a8b774) - annotate type for bq PERCENTILE_DISC *(PR [#5722](https://github.com/tobymao/sqlglot/pull/5722) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq PERCENTILE_DISC (#5722)

- due to [`7d49609`](https://github.com/tobymao/sqlglot/commit/7d4960963f0ef70b96f5b969bb008d2742e833ea) - annotate type for bq NTH_VALUE *(PR [#5720](https://github.com/tobymao/sqlglot/pull/5720) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq NTH_VALUE (#5720)

- due to [`d41acf1`](https://github.com/tobymao/sqlglot/commit/d41acf11221bee30a5ae089cbac9b158ed3dd515) - annotate type for bq LEAD *(PR [#5719](https://github.com/tobymao/sqlglot/pull/5719) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq LEAD (#5719)

- due to [`ff12130`](https://github.com/tobymao/sqlglot/commit/ff12130c23a215917f20fda7d50322f1cb7de599) - annotate type for bq PERNCENTILE_CONT *(PR [#5729](https://github.com/tobymao/sqlglot/pull/5729) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq PERNCENTILE_CONT (#5729)

- due to [`fdb8a0a`](https://github.com/tobymao/sqlglot/commit/fdb8a0a6d0d74194255f313bd934db7fc1ce0d3f) - parse and annotate type for bq FORMAT *(PR [#5715](https://github.com/tobymao/sqlglot/pull/5715) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq FORMAT (#5715)

- due to [`012bdd3`](https://github.com/tobymao/sqlglot/commit/012bdd3c8aeff180f85354ffd403fc1aa5815dcf) - parse and annotate type for bq CUME_DIST *(PR [#5735](https://github.com/tobymao/sqlglot/pull/5735) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq CUME_DIST (#5735)

- due to [`b99eaeb`](https://github.com/tobymao/sqlglot/commit/b99eaeb0c6eb3dc613e76d205e02632bd6af353b) - parse and annotate type for bq DENSE_RANK *(PR [#5736](https://github.com/tobymao/sqlglot/pull/5736) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq DENSE_RANK (#5736)

- due to [`bb95c73`](https://github.com/tobymao/sqlglot/commit/bb95c7312c942ef987955f01e060604d60e32e83) - parse and annotate type for bq RANK *(PR [#5738](https://github.com/tobymao/sqlglot/pull/5738) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq RANK (#5738)

- due to [`8713c08`](https://github.com/tobymao/sqlglot/commit/8713c082b0aa8454a5773fc2a85e08a132dc6ce3) - parse and annotate type for bq PERCENT_RANK *(PR [#5739](https://github.com/tobymao/sqlglot/pull/5739) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq PERCENT_RANK (#5739)

- due to [`9ce4e31`](https://github.com/tobymao/sqlglot/commit/9ce4e31aecbde6ea1f227a7166c0f3dc9e302a66) - annotate type for bq JSON_OBJECT *(PR [#5740](https://github.com/tobymao/sqlglot/pull/5740) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq JSON_OBJECT (#5740)

- due to [`d35ec6e`](https://github.com/tobymao/sqlglot/commit/d35ec6e37e21cf3cec848ed55bd73128c4633cd2) - annotate type for bq JSON_QUERY/JSON_QUERY_ARRAY *(PR [#5741](https://github.com/tobymao/sqlglot/pull/5741) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq JSON_QUERY/JSON_QUERY_ARRAY (#5741)

- due to [`4753642`](https://github.com/tobymao/sqlglot/commit/4753642cfcfb1f192ec4d21a492737b27affef09) - annotate type for bq JSON_EXTRACT_SCALAR *(commit by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq JSON_EXTRACT_SCALAR

- due to [`113a530`](https://github.com/tobymao/sqlglot/commit/113a5308d050fd5ceacab4c6188e5eea5dd740b1) - parse and annotate type for bq JSON_ARRAY_APPEND *(PR [#5747](https://github.com/tobymao/sqlglot/pull/5747) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_ARRAY_APPEND (#5747)

- due to [`268e2c6`](https://github.com/tobymao/sqlglot/commit/268e2c694d1eb99f1fe64477bc38ed4946bf1c32) - parse and annotate type for bq JSON_ARRAY_INSERT *(PR [#5748](https://github.com/tobymao/sqlglot/pull/5748) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_ARRAY_INSERT (#5748)

- due to [`455ec1f`](https://github.com/tobymao/sqlglot/commit/455ec1f4f8aecb5435fa4cb2912bfc21db8dd44d) - parse and annotate type for bq JSON_KEYS *(PR [#5749](https://github.com/tobymao/sqlglot/pull/5749) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_KEYS (#5749)

- due to [`59895fa`](https://github.com/tobymao/sqlglot/commit/59895faa23ebe1b27938c37a7b39df87de609844) - parse and annotate type for bq JSON_REMOVE *(PR [#5750](https://github.com/tobymao/sqlglot/pull/5750) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_REMOVE (#5750)

- due to [`06d7df7`](https://github.com/tobymao/sqlglot/commit/06d7df7a05f2824cabf48e8d1e8a4ebca8fda496) - parse and annotate type for bq JSON_SET *(PR [#5751](https://github.com/tobymao/sqlglot/pull/5751) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_SET (#5751)

- due to [`e72b341`](https://github.com/tobymao/sqlglot/commit/e72b3419c8a367caa0e5e80030979cd94e87a40d) - parse and annotate type for bq JSON_STRIP_NULLS *(PR [#5753](https://github.com/tobymao/sqlglot/pull/5753) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_STRIP_NULLS (#5753)

- due to [`5de61a7`](https://github.com/tobymao/sqlglot/commit/5de61a7ab850d4e68fde4d76ee396d30d7bdef33) - parse and annotate type for bq JSON_EXTRACT_STRING_ARRAY *(PR [#5758](https://github.com/tobymao/sqlglot/pull/5758) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON_EXTRACT_STRING_ARRAY (#5758)

- due to [`36c9393`](https://github.com/tobymao/sqlglot/commit/36c93939575a19bd611269719c39d3d216be8cde) - parse and annotate type for bq JSON LAX funcs *(PR [#5760](https://github.com/tobymao/sqlglot/pull/5760) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq JSON LAX funcs (#5760)

- due to [`88862b5`](https://github.com/tobymao/sqlglot/commit/88862b56bc29c8a600b4d0e4693d5846d3a577ff) - annotate type for bq TO_JSON_STRING *(PR [#5762](https://github.com/tobymao/sqlglot/pull/5762) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq TO_JSON_STRING (#5762)


### :sparkles: New Features
- [`baffd2c`](https://github.com/tobymao/sqlglot/commit/baffd2c0be9657683781f3f8831c47e32dbf68bb) - **optimizer**: parse and annotate type for bq REGEXP_INSTR *(PR [#5710](https://github.com/tobymao/sqlglot/pull/5710) by [@geooo109](https://github.com/geooo109))*
- [`b79eb19`](https://github.com/tobymao/sqlglot/commit/b79eb198cc21203efa82128b357d435338e9133d) - **optimizer**: annotate type for bq ROW_NUMBER *(PR [#5716](https://github.com/tobymao/sqlglot/pull/5716) by [@geooo109](https://github.com/geooo109))*
- [`f709bef`](https://github.com/tobymao/sqlglot/commit/f709bef3af7cd0daa25fe3d58b1753c3e65720ef) - **optimizer**: annotate type for bq FIRST_VALUE *(PR [#5718](https://github.com/tobymao/sqlglot/pull/5718) by [@geooo109](https://github.com/geooo109))*
- [`b9ae9e5`](https://github.com/tobymao/sqlglot/commit/b9ae9e534dee1e32fccbf22cab9bc17fbd920629) - **singlestore**: Implemeted generation of exp.TsOrDiToDi *(PR [#5724](https://github.com/tobymao/sqlglot/pull/5724) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`9b14fff`](https://github.com/tobymao/sqlglot/commit/9b14fffd2c9404f76a3faced2ec9d6eaac8feb01) - **singlestore**: Implemented generation of exp.DateToDi *(PR [#5717](https://github.com/tobymao/sqlglot/pull/5717) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`07d8c23`](https://github.com/tobymao/sqlglot/commit/07d8c2347baba6523310c4d31cddfb0e5c0eddc1) - **singlestore**: Implemented generation of exp.DiToDate *(PR [#5721](https://github.com/tobymao/sqlglot/pull/5721) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`ad34a85`](https://github.com/tobymao/sqlglot/commit/ad34a855a433bc0f51a707cbcb66f8dce667a562) - **singlestore**: Implemented generation of exp.FromTimeZone *(PR [#5723](https://github.com/tobymao/sqlglot/pull/5723) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`29d5e4f`](https://github.com/tobymao/sqlglot/commit/29d5e4f62a799f35c0904a23cedacc6efa95a63b) - **singlestore**: Implemented generation of exp.DatetimeAdd *(PR [#5728](https://github.com/tobymao/sqlglot/pull/5728) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`15a9061`](https://github.com/tobymao/sqlglot/commit/15a906170e5d5cdaa207ec7607edfdd7d4a8b774) - **optimizer**: annotate type for bq PERCENTILE_DISC *(PR [#5722](https://github.com/tobymao/sqlglot/pull/5722) by [@geooo109](https://github.com/geooo109))*
- [`7d49609`](https://github.com/tobymao/sqlglot/commit/7d4960963f0ef70b96f5b969bb008d2742e833ea) - **optimizer**: annotate type for bq NTH_VALUE *(PR [#5720](https://github.com/tobymao/sqlglot/pull/5720) by [@geooo109](https://github.com/geooo109))*
- [`d41acf1`](https://github.com/tobymao/sqlglot/commit/d41acf11221bee30a5ae089cbac9b158ed3dd515) - **optimizer**: annotate type for bq LEAD *(PR [#5719](https://github.com/tobymao/sqlglot/pull/5719) by [@geooo109](https://github.com/geooo109))*
- [`113809a`](https://github.com/tobymao/sqlglot/commit/113809a07efee0f12758bd2571c8515885568466) - **singlestore**: Implemented exp.TimeStrToDate generation *(PR [#5725](https://github.com/tobymao/sqlglot/pull/5725) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`cf63d0d`](https://github.com/tobymao/sqlglot/commit/cf63d0df4c2f58b2cf0c87e2a3a6f63f836a50a1) - **dremio**: add regexp_like and alias regexp_matches *(PR [#5731](https://github.com/tobymao/sqlglot/pull/5731) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`e42160f`](https://github.com/tobymao/sqlglot/commit/e42160f27fa68828898969073f2f4a0014f5e3e9) - **dremio**: support alias repeatstr *(PR [#5730](https://github.com/tobymao/sqlglot/pull/5730) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`ff12130`](https://github.com/tobymao/sqlglot/commit/ff12130c23a215917f20fda7d50322f1cb7de599) - **optimizer**: annotate type for bq PERNCENTILE_CONT *(PR [#5729](https://github.com/tobymao/sqlglot/pull/5729) by [@geooo109](https://github.com/geooo109))*
- [`fdb8a0a`](https://github.com/tobymao/sqlglot/commit/fdb8a0a6d0d74194255f313bd934db7fc1ce0d3f) - **optimizer**: parse and annotate type for bq FORMAT *(PR [#5715](https://github.com/tobymao/sqlglot/pull/5715) by [@geooo109](https://github.com/geooo109))*
- [`e272292`](https://github.com/tobymao/sqlglot/commit/e272292197f2bb81ccfad1de06a95f321f0b565f) - **singlestore**: Implemented generation of exp.Time *(PR [#5727](https://github.com/tobymao/sqlglot/pull/5727) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`012bdd3`](https://github.com/tobymao/sqlglot/commit/012bdd3c8aeff180f85354ffd403fc1aa5815dcf) - **optimizer**: parse and annotate type for bq CUME_DIST *(PR [#5735](https://github.com/tobymao/sqlglot/pull/5735) by [@geooo109](https://github.com/geooo109))*
- [`b99eaeb`](https://github.com/tobymao/sqlglot/commit/b99eaeb0c6eb3dc613e76d205e02632bd6af353b) - **optimizer**: parse and annotate type for bq DENSE_RANK *(PR [#5736](https://github.com/tobymao/sqlglot/pull/5736) by [@geooo109](https://github.com/geooo109))*
- [`8cf6ef9`](https://github.com/tobymao/sqlglot/commit/8cf6ef92a0f43943efb0fe380f41dc09f43aca85) - **optimizer**: parse and annotate_type for bq NTILE *(PR [#5737](https://github.com/tobymao/sqlglot/pull/5737) by [@geooo109](https://github.com/geooo109))*
- [`bb95c73`](https://github.com/tobymao/sqlglot/commit/bb95c7312c942ef987955f01e060604d60e32e83) - **optimizer**: parse and annotate type for bq RANK *(PR [#5738](https://github.com/tobymao/sqlglot/pull/5738) by [@geooo109](https://github.com/geooo109))*
- [`8713c08`](https://github.com/tobymao/sqlglot/commit/8713c082b0aa8454a5773fc2a85e08a132dc6ce3) - **optimizer**: parse and annotate type for bq PERCENT_RANK *(PR [#5739](https://github.com/tobymao/sqlglot/pull/5739) by [@geooo109](https://github.com/geooo109))*
- [`9ce4e31`](https://github.com/tobymao/sqlglot/commit/9ce4e31aecbde6ea1f227a7166c0f3dc9e302a66) - **optimizer**: annotate type for bq JSON_OBJECT *(PR [#5740](https://github.com/tobymao/sqlglot/pull/5740) by [@geooo109](https://github.com/geooo109))*
- [`d35ec6e`](https://github.com/tobymao/sqlglot/commit/d35ec6e37e21cf3cec848ed55bd73128c4633cd2) - **optimizer**: annotate type for bq JSON_QUERY/JSON_QUERY_ARRAY *(PR [#5741](https://github.com/tobymao/sqlglot/pull/5741) by [@geooo109](https://github.com/geooo109))*
- [`4753642`](https://github.com/tobymao/sqlglot/commit/4753642cfcfb1f192ec4d21a492737b27affef09) - **optimizer**: annotate type for bq JSON_EXTRACT_SCALAR *(commit by [@geooo109](https://github.com/geooo109))*
- [`6249dbe`](https://github.com/tobymao/sqlglot/commit/6249dbe4173ad5278adf84452dcf7253a2395b91) - **singlestore**: Added generation of exp.DatetimeDiff *(PR [#5743](https://github.com/tobymao/sqlglot/pull/5743) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`113a530`](https://github.com/tobymao/sqlglot/commit/113a5308d050fd5ceacab4c6188e5eea5dd740b1) - **optimizer**: parse and annotate type for bq JSON_ARRAY_APPEND *(PR [#5747](https://github.com/tobymao/sqlglot/pull/5747) by [@geooo109](https://github.com/geooo109))*
- [`8603705`](https://github.com/tobymao/sqlglot/commit/8603705a8e5513699adc2499389c67412eee70cb) - **singlestore**: feat(singlestore): Implemented generation of exp.DatetimeSub *(PR [#5744](https://github.com/tobymao/sqlglot/pull/5744) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`7d71c0b`](https://github.com/tobymao/sqlglot/commit/7d71c0bb576f9de3447b4780ab64a3f4d92c6432) - **singlestore**: Fixed generation of exp.DatetimeTrunc and exp.DateTrunc *(PR [#5745](https://github.com/tobymao/sqlglot/pull/5745) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`268e2c6`](https://github.com/tobymao/sqlglot/commit/268e2c694d1eb99f1fe64477bc38ed4946bf1c32) - **optimizer**: parse and annotate type for bq JSON_ARRAY_INSERT *(PR [#5748](https://github.com/tobymao/sqlglot/pull/5748) by [@geooo109](https://github.com/geooo109))*
- [`455ec1f`](https://github.com/tobymao/sqlglot/commit/455ec1f4f8aecb5435fa4cb2912bfc21db8dd44d) - **optimizer**: parse and annotate type for bq JSON_KEYS *(PR [#5749](https://github.com/tobymao/sqlglot/pull/5749) by [@geooo109](https://github.com/geooo109))*
- [`59895fa`](https://github.com/tobymao/sqlglot/commit/59895faa23ebe1b27938c37a7b39df87de609844) - **optimizer**: parse and annotate type for bq JSON_REMOVE *(PR [#5750](https://github.com/tobymao/sqlglot/pull/5750) by [@geooo109](https://github.com/geooo109))*
- [`06d7df7`](https://github.com/tobymao/sqlglot/commit/06d7df7a05f2824cabf48e8d1e8a4ebca8fda496) - **optimizer**: parse and annotate type for bq JSON_SET *(PR [#5751](https://github.com/tobymao/sqlglot/pull/5751) by [@geooo109](https://github.com/geooo109))*
- [`7f5079a`](https://github.com/tobymao/sqlglot/commit/7f5079a1b71c4dd28e98b77b5b749e074fce862c) - **singlestore**: Improved geneation of exp.DataType *(PR [#5746](https://github.com/tobymao/sqlglot/pull/5746) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`ad9405c`](https://github.com/tobymao/sqlglot/commit/ad9405cd43108ff80d16711f8b33ff57430ed686) - **singlestore**: fixed generation of exp.TimestampTrunc *(PR [#5754](https://github.com/tobymao/sqlglot/pull/5754) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`a1852f9`](https://github.com/tobymao/sqlglot/commit/a1852f93fdfe926072c12954c95796d038e15140) - **dremio**: parse date_part *(PR [#5756](https://github.com/tobymao/sqlglot/pull/5756) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`0db1df6`](https://github.com/tobymao/sqlglot/commit/0db1df617ec4f05b1ee6cf1d606272f6e799a9b9) - **singlestore**: Fixed generation of exp.DateDiff *(PR [#5752](https://github.com/tobymao/sqlglot/pull/5752) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e72b341`](https://github.com/tobymao/sqlglot/commit/e72b3419c8a367caa0e5e80030979cd94e87a40d) - **optimizer**: parse and annotate type for bq JSON_STRIP_NULLS *(PR [#5753](https://github.com/tobymao/sqlglot/pull/5753) by [@geooo109](https://github.com/geooo109))*
- [`5de61a7`](https://github.com/tobymao/sqlglot/commit/5de61a7ab850d4e68fde4d76ee396d30d7bdef33) - **optimizer**: parse and annotate type for bq JSON_EXTRACT_STRING_ARRAY *(PR [#5758](https://github.com/tobymao/sqlglot/pull/5758) by [@geooo109](https://github.com/geooo109))*
- [`36c9393`](https://github.com/tobymao/sqlglot/commit/36c93939575a19bd611269719c39d3d216be8cde) - **optimizer**: parse and annotate type for bq JSON LAX funcs *(PR [#5760](https://github.com/tobymao/sqlglot/pull/5760) by [@geooo109](https://github.com/geooo109))*
- [`c443d5c`](https://github.com/tobymao/sqlglot/commit/c443d5caf2d9695856103eebfff21cb215777112) - **dremio**: parse datetype *(PR [#5759](https://github.com/tobymao/sqlglot/pull/5759) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`5172a99`](https://github.com/tobymao/sqlglot/commit/5172a99fc4d5e21a1dbe4509d6d7ab1ccfe8bff7) - **singlestore**: Fixed parsing of columns with table name *(PR [#5767](https://github.com/tobymao/sqlglot/pull/5767) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`88862b5`](https://github.com/tobymao/sqlglot/commit/88862b56bc29c8a600b4d0e4693d5846d3a577ff) - **optimizer**: annotate type for bq TO_JSON_STRING *(PR [#5762](https://github.com/tobymao/sqlglot/pull/5762) by [@geooo109](https://github.com/geooo109))*

### :bug: Bug Fixes
- [`ec93497`](https://github.com/tobymao/sqlglot/commit/ec93497bac82090b88c6e749ec2adc99bbc23a61) - **bigquery**: support commands inside for loops *(PR [#5732](https://github.com/tobymao/sqlglot/pull/5732) by [@treysp](https://github.com/treysp))*
- [`85845bb`](https://github.com/tobymao/sqlglot/commit/85845bb941ac9a4ee090a89cd3d3dab4ab5835a7) - **snowflake**: allow exclude as id var *(PR [#5764](https://github.com/tobymao/sqlglot/pull/5764) by [@treysp](https://github.com/treysp))*
- [`db2d9cc`](https://github.com/tobymao/sqlglot/commit/db2d9cca9718fb196066dbf60840124917d1f8ac) - **tokenizer**: handle empty hex strings *(PR [#5763](https://github.com/tobymao/sqlglot/pull/5763) by [@paulolieuthier](https://github.com/paulolieuthier))*
  - :arrow_lower_right: *fixes issue [#5761](https://github.com/tobymao/sqlglot/issues/5761) opened by [@paulolieuthier](https://github.com/paulolieuthier)*
- [`982257b`](https://github.com/tobymao/sqlglot/commit/982257b40973cdfc20a8d6dd9a1674cda7eb75c4) - **bigquery**: Crash when ARRAY_CONCAT is called with no expressions *(PR [#5755](https://github.com/tobymao/sqlglot/pull/5755) by [@ozadari](https://github.com/ozadari))*
- [`24ca504`](https://github.com/tobymao/sqlglot/commit/24ca504360779c8a20a58accf506eb9600ac9bf8) - **bigquery**: Crash when ARRAY_CONCAT is called with no expressions *(PR [#5755](https://github.com/tobymao/sqlglot/pull/5755) by [@ozadari](https://github.com/ozadari))*

### :wrench: Chores
- [`41521e3`](https://github.com/tobymao/sqlglot/commit/41521e31b465acd51ab02b1ac4e5512b98175b7e) - bump sqlglotrs to 0.6.2 *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.10.0] - 2025-08-28
### :boom: BREAKING CHANGES
- due to [`de2fe15`](https://github.com/tobymao/sqlglot/commit/de2fe1503b5bb003431d1f0c7b9ae87932a6cc1c) - annotate type for bq CONTAINS_SUBSTR *(PR [#5705](https://github.com/tobymao/sqlglot/pull/5705) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq CONTAINS_SUBSTR (#5705)

- due to [`770888f`](https://github.com/tobymao/sqlglot/commit/770888f4e9a9061329e3c416f968f7dd9639fb81) - annotate type for bq NORMALIZE *(PR [#5711](https://github.com/tobymao/sqlglot/pull/5711) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bq NORMALIZE (#5711)

- due to [`506033f`](https://github.com/tobymao/sqlglot/commit/506033f299f7a4c28f6efd8bf715be5dcf73e929) - parse and annotate type for bq NORMALIZE_AND_CASEFOLD *(PR [#5712](https://github.com/tobymao/sqlglot/pull/5712) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq NORMALIZE_AND_CASEFOLD (#5712)

- due to [`848aea1`](https://github.com/tobymao/sqlglot/commit/848aea1dbaaeb580b633796dcca06c28314b9c3e) - parse and annotate type for bq OCTET_LENGTH *(PR [#5713](https://github.com/tobymao/sqlglot/pull/5713) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq OCTET_LENGTH (#5713)

- due to [`727bf83`](https://github.com/tobymao/sqlglot/commit/727bf8378f232188d35834d980b035552999ea3b) - add support for REVOKE DDL *(PR [#5703](https://github.com/tobymao/sqlglot/pull/5703) by [@newtonapple](https://github.com/newtonapple))*:

  add support for REVOKE DDL (#5703)


### :sparkles: New Features
- [`f6f8f56`](https://github.com/tobymao/sqlglot/commit/f6f8f56a59d550dfc7dfcab0c3b9a6885c7e758a) - **singlestore**: Fixed parsing/generation of exp.JSONFormat *(PR [#5706](https://github.com/tobymao/sqlglot/pull/5706) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`de2fe15`](https://github.com/tobymao/sqlglot/commit/de2fe1503b5bb003431d1f0c7b9ae87932a6cc1c) - **optimizer**: annotate type for bq CONTAINS_SUBSTR *(PR [#5705](https://github.com/tobymao/sqlglot/pull/5705) by [@geooo109](https://github.com/geooo109))*
- [`a78146e`](https://github.com/tobymao/sqlglot/commit/a78146e37bfc972050b4467c39769407061e9bc3) - **singlestore**: Fixed parsing/generation of exp.DateBin *(PR [#5709](https://github.com/tobymao/sqlglot/pull/5709) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`ab0c985`](https://github.com/tobymao/sqlglot/commit/ab0c985424ae9d9340eafd15ecdc9b31bdd8837c) - **singlestore**: Marked exp.Reduce finish argument as unsupported *(PR [#5707](https://github.com/tobymao/sqlglot/pull/5707) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`770888f`](https://github.com/tobymao/sqlglot/commit/770888f4e9a9061329e3c416f968f7dd9639fb81) - **optimizer**: annotate type for bq NORMALIZE *(PR [#5711](https://github.com/tobymao/sqlglot/pull/5711) by [@geooo109](https://github.com/geooo109))*
- [`506033f`](https://github.com/tobymao/sqlglot/commit/506033f299f7a4c28f6efd8bf715be5dcf73e929) - **optimizer**: parse and annotate type for bq NORMALIZE_AND_CASEFOLD *(PR [#5712](https://github.com/tobymao/sqlglot/pull/5712) by [@geooo109](https://github.com/geooo109))*
- [`848aea1`](https://github.com/tobymao/sqlglot/commit/848aea1dbaaeb580b633796dcca06c28314b9c3e) - **optimizer**: parse and annotate type for bq OCTET_LENGTH *(PR [#5713](https://github.com/tobymao/sqlglot/pull/5713) by [@geooo109](https://github.com/geooo109))*
- [`727bf83`](https://github.com/tobymao/sqlglot/commit/727bf8378f232188d35834d980b035552999ea3b) - add support for REVOKE DDL *(PR [#5703](https://github.com/tobymao/sqlglot/pull/5703) by [@newtonapple](https://github.com/newtonapple))*

### :bug: Bug Fixes
- [`0427c7b`](https://github.com/tobymao/sqlglot/commit/0427c7b7aa9f8161324085a98c5f531fa35c8b0c) - **optimizer**: qualify columns for AggFunc with DISTINCT *(PR [#5708](https://github.com/tobymao/sqlglot/pull/5708) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5698](https://github.com/tobymao/sqlglot/issues/5698) opened by [@georgesittas](https://github.com/georgesittas)*


## [v27.9.0] - 2025-08-27
### :boom: BREAKING CHANGES
- due to [`7b180bd`](https://github.com/tobymao/sqlglot/commit/7b180bdc3da9e39946c22970bd2523f7d8beaf29) - raise if query modifier is specified multiple times *(PR [#5608](https://github.com/tobymao/sqlglot/pull/5608) by [@georgesittas](https://github.com/georgesittas))*:

  raise if query modifier is specified multiple times (#5608)

- due to [`36602a2`](https://github.com/tobymao/sqlglot/commit/36602a2ecc9ffca98e89044d23e40f33c6ed71e4) - parse LIST_FILTER into ArrayFilter closes [#5633](https://github.com/tobymao/sqlglot/pull/5633) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  parse LIST_FILTER into ArrayFilter closes #5633

- due to [`0188d21`](https://github.com/tobymao/sqlglot/commit/0188d21d443c991a528eb9d220459890b7dca477) - parse LIST_TRANSFORM into Transform closes [#5634](https://github.com/tobymao/sqlglot/pull/5634) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  parse LIST_TRANSFORM into Transform closes #5634

- due to [`3ab1d44`](https://github.com/tobymao/sqlglot/commit/3ab1d4487279cab3be2d3764e51516c6db21629d) - Wrap CONCAT items with COALESCE less aggressively *(PR [#5641](https://github.com/tobymao/sqlglot/pull/5641) by [@VaggelisD](https://github.com/VaggelisD))*:

  Wrap CONCAT items with COALESCE less aggressively (#5641)

- due to [`af0b299`](https://github.com/tobymao/sqlglot/commit/af0b299561914953b30ab36004e53dcb92d39e1c) - Qualify columns generated by exp.Aliases *(PR [#5647](https://github.com/tobymao/sqlglot/pull/5647) by [@VaggelisD](https://github.com/VaggelisD))*:

  Qualify columns generated by exp.Aliases (#5647)

- due to [`53aa8fe`](https://github.com/tobymao/sqlglot/commit/53aa8fe7f188012f765066f32c4179035fff036d) - support alter table with check closes [#5649](https://github.com/tobymao/sqlglot/pull/5649) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  support alter table with check closes #5649

- due to [`1a60a5a`](https://github.com/tobymao/sqlglot/commit/1a60a5a845c7431d7d3d7ccb71119699316f4b41) - Added parsing/generation of JSON_ARRAY_CONTAINS function *(PR [#5661](https://github.com/tobymao/sqlglot/pull/5661) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*:

  Added parsing/generation of JSON_ARRAY_CONTAINS function (#5661)

- due to [`e0db0a9`](https://github.com/tobymao/sqlglot/commit/e0db0a95d3cb7614242dbd1b439d408e7e7bd475) - add parse and annotate type for bigquery FARM_FINGERPRINT *(PR [#5667](https://github.com/tobymao/sqlglot/pull/5667) by [@geooo109](https://github.com/geooo109))*:

  add parse and annotate type for bigquery FARM_FINGERPRINT (#5667)

- due to [`56588c7`](https://github.com/tobymao/sqlglot/commit/56588c7e22b4db4f0e44696a460483ca1e549163) - Add support for vector_search function. Move predict to BigQuery dialect. *(PR [#5660](https://github.com/tobymao/sqlglot/pull/5660) by [@rloredo](https://github.com/rloredo))*:

  Add support for vector_search function. Move predict to BigQuery dialect. (#5660)

- due to [`a688a0f`](https://github.com/tobymao/sqlglot/commit/a688a0f0d70f87139e531d1419b338b695bec384) - parse and annotate type for bigquery APPROX_TOP_COUNT *(PR [#5670](https://github.com/tobymao/sqlglot/pull/5670) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery APPROX_TOP_COUNT (#5670)

- due to [`3c93fcc`](https://github.com/tobymao/sqlglot/commit/3c93fcce96ec82e78753f6c9dd5fb0e730a82058) - parse and annotate type for bigquery APPROX_TOP_SUM *(PR [#5675](https://github.com/tobymao/sqlglot/pull/5675) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery APPROX_TOP_SUM (#5675)

- due to [`741d45a`](https://github.com/tobymao/sqlglot/commit/741d45a0ca7c1bad67da4393cd10cc9cfa49ea68) - parse and annotate type for bigquery FROM/TO_BASE32 *(PR [#5676](https://github.com/tobymao/sqlglot/pull/5676) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery FROM/TO_BASE32 (#5676)

- due to [`9ae045c`](https://github.com/tobymao/sqlglot/commit/9ae045c0405e43b148e3b9261825288ebf09100c) - parse and annotate type for bigquery FROM_HEX *(PR [#5679](https://github.com/tobymao/sqlglot/pull/5679) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery FROM_HEX (#5679)

- due to [`5a22a25`](https://github.com/tobymao/sqlglot/commit/5a22a254143978989027f6e7f6163019a34f112a) - annotate type for bigquery TO_HEX *(PR [#5680](https://github.com/tobymao/sqlglot/pull/5680) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery TO_HEX (#5680)

- due to [`5c1eb2d`](https://github.com/tobymao/sqlglot/commit/5c1eb2df5dd3dcc6ed2c8204cec56b5c3d276f87) - parse and annotate type for bq PARSE_BIG/NUMERIC *(PR [#5690](https://github.com/tobymao/sqlglot/pull/5690) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq PARSE_BIG/NUMERIC (#5690)

- due to [`311373d`](https://github.com/tobymao/sqlglot/commit/311373d22134de906d1c1cef019541e85e2f7c9f) - parse and annotate type for bq CODE_POINTS_TO_BYTES *(PR [#5686](https://github.com/tobymao/sqlglot/pull/5686) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq CODE_POINTS_TO_BYTES (#5686)

- due to [`79d9de1`](https://github.com/tobymao/sqlglot/commit/79d9de1745598f8f3ae2c82c1389dd455c946a09) - parse and annotate type for bq TO_CODE_POINTS *(PR [#5685](https://github.com/tobymao/sqlglot/pull/5685) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq TO_CODE_POINTS (#5685)

- due to [`5df3ea9`](https://github.com/tobymao/sqlglot/commit/5df3ea92f59125955124ea1883b777b489db3042) - parse and annotate type for bq SAFE_CONVERT_BYTES_TO_STRING *(PR [#5681](https://github.com/tobymao/sqlglot/pull/5681) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq SAFE_CONVERT_BYTES_TO_STRING (#5681)

- due to [`c832746`](https://github.com/tobymao/sqlglot/commit/c832746018fbc2c531d5b2a7c7f8cd5d78e511ff) - parse and annotate type for bigquery APPROX_QUANTILES *(PR [#5678](https://github.com/tobymao/sqlglot/pull/5678) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery APPROX_QUANTILES (#5678)

- due to [`99e169e`](https://github.com/tobymao/sqlglot/commit/99e169ea13d5be3712a47f6b55b98a4764a3c24d) - parse and annotate type for bq BOOL *(PR [#5697](https://github.com/tobymao/sqlglot/pull/5697) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq BOOL (#5697)

- due to [`3f31770`](https://github.com/tobymao/sqlglot/commit/3f31770c793f464fcac1ce2b8dfa03d4b7f0231c) - parse and annotate type for bq FLOAT64 *(PR [#5700](https://github.com/tobymao/sqlglot/pull/5700) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bq FLOAT64 (#5700)


### :sparkles: New Features
- [`02e60e7`](https://github.com/tobymao/sqlglot/commit/02e60e73fc0c2dae815aa225be247a17ccdf4b82) - **singlestore**: desugarize DAYNAME into DATE_FORMAT *(PR [#5610](https://github.com/tobymao/sqlglot/pull/5610) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`7b180bd`](https://github.com/tobymao/sqlglot/commit/7b180bdc3da9e39946c22970bd2523f7d8beaf29) - **parser**: raise if query modifier is specified multiple times *(PR [#5608](https://github.com/tobymao/sqlglot/pull/5608) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#5604](https://github.com/tobymao/sqlglot/issues/5604) opened by [@bricct](https://github.com/bricct)*
- [`442eafc`](https://github.com/tobymao/sqlglot/commit/442eafcb00a2650930bd6023aa9a5febfebbe796) - **singlestore**: Added parsing of HOUR function *(PR [#5612](https://github.com/tobymao/sqlglot/pull/5612) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`5320359`](https://github.com/tobymao/sqlglot/commit/532035978605efd1d43de75aafca750e2894c0b9) - **singlestore**: Added parsing of MICROSECOND function *(PR [#5619](https://github.com/tobymao/sqlglot/pull/5619) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`db1db97`](https://github.com/tobymao/sqlglot/commit/db1db9732352187629df853ad937ebaf4abfe487) - **doris**: update exp.UniqueKeyProperty SQL generation logic *(PR [#5613](https://github.com/tobymao/sqlglot/pull/5613) by [@xinge-ji](https://github.com/xinge-ji))*
- [`54623a6`](https://github.com/tobymao/sqlglot/commit/54623a6b85432272703f12a197b05ced78529f90) - **singlestore**: Added parsing of MINUTE function *(PR [#5620](https://github.com/tobymao/sqlglot/pull/5620) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`565c9f8`](https://github.com/tobymao/sqlglot/commit/565c9f8c55cfbef5d3a9e1470551f1dc4416825e) - **singlestore**: Added generation of DAYOFWEEK_ISO function *(PR [#5627](https://github.com/tobymao/sqlglot/pull/5627) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`8db916e`](https://github.com/tobymao/sqlglot/commit/8db916e2f2ce241bdff130d626f98df182b48f3e) - **singlestore**: Added parsing of WEEKDAY function *(PR [#5624](https://github.com/tobymao/sqlglot/pull/5624) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`aa6274a`](https://github.com/tobymao/sqlglot/commit/aa6274a0ea647df1251563945635260a6ddd4972) - **singlestore**: Fixed generation of DAY_OF_MONTH function *(PR [#5629](https://github.com/tobymao/sqlglot/pull/5629) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`dee44b8`](https://github.com/tobymao/sqlglot/commit/dee44b8c1d70ca6079867896fb68cad256909dad) - **singlestore**: Added parsing of MONTHNAME function *(PR [#5623](https://github.com/tobymao/sqlglot/pull/5623) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`deebf0c`](https://github.com/tobymao/sqlglot/commit/deebf0c3cc379e28c4ab66b6bb7a9c84c14e88c6) - **singlestore**: Added parsing of SECOND function *(PR [#5621](https://github.com/tobymao/sqlglot/pull/5621) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`12a60b9`](https://github.com/tobymao/sqlglot/commit/12a60b99b6b2b0673b57218c691794deb67aa3a5) - **singlestore**: Removed redundant deletions from TRANSFORMS *(PR [#5632](https://github.com/tobymao/sqlglot/pull/5632) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`36602a2`](https://github.com/tobymao/sqlglot/commit/36602a2ecc9ffca98e89044d23e40f33c6ed71e4) - **duckdb**: parse LIST_FILTER into ArrayFilter closes [#5633](https://github.com/tobymao/sqlglot/pull/5633) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`0188d21`](https://github.com/tobymao/sqlglot/commit/0188d21d443c991a528eb9d220459890b7dca477) - **duckdb**: parse LIST_TRANSFORM into Transform closes [#5634](https://github.com/tobymao/sqlglot/pull/5634) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`b117d59`](https://github.com/tobymao/sqlglot/commit/b117d59f3c43f6f44cd0ccdf22717f7bcd990889) - **dremio**: add dremio date_add and date_sub parsing *(PR [#5617](https://github.com/tobymao/sqlglot/pull/5617) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`999b9e7`](https://github.com/tobymao/sqlglot/commit/999b9e793c0819a4d2af6400fc924946d26b3e6f) - **singlestore**: Changed generation of exp.TsOrDsToDate to handle case when format is not provided *(PR [#5639](https://github.com/tobymao/sqlglot/pull/5639) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`b556e97`](https://github.com/tobymao/sqlglot/commit/b556e97f8cfbde21c0a921ac1c01c9e4f2ec2535) - **singlestore**: Marked exp.All as unsupported *(PR [#5640](https://github.com/tobymao/sqlglot/pull/5640) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`c076694`](https://github.com/tobymao/sqlglot/commit/c0766946e6799fb61c38e855fd18812d08a5c251) - **clickhouse**: support custom partition key expressions *(PR [#5645](https://github.com/tobymao/sqlglot/pull/5645) by [@GaliFFun](https://github.com/GaliFFun))*
- [`cab62b0`](https://github.com/tobymao/sqlglot/commit/cab62b06ce926e3116a6a45a9c57e4901cd8a281) - **doris**: add support for BUILD and REFRESH properties in materialized view *(PR [#5614](https://github.com/tobymao/sqlglot/pull/5614) by [@xinge-ji](https://github.com/xinge-ji))*
- [`af0b299`](https://github.com/tobymao/sqlglot/commit/af0b299561914953b30ab36004e53dcb92d39e1c) - **optimizer**: Qualify columns generated by exp.Aliases *(PR [#5647](https://github.com/tobymao/sqlglot/pull/5647) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5638](https://github.com/tobymao/sqlglot/issues/5638) opened by [@catlynkong](https://github.com/catlynkong)*
- [`981e0e7`](https://github.com/tobymao/sqlglot/commit/981e0e70a304665e746158c859bcc81f99384685) - **doris**: add support for PARTITION BY LIST *(PR [#5615](https://github.com/tobymao/sqlglot/pull/5615) by [@xinge-ji](https://github.com/xinge-ji))*
- [`53aa8fe`](https://github.com/tobymao/sqlglot/commit/53aa8fe7f188012f765066f32c4179035fff036d) - **tsql**: support alter table with check closes [#5649](https://github.com/tobymao/sqlglot/pull/5649) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`23cac6c`](https://github.com/tobymao/sqlglot/commit/23cac6c58099a9ac818ac5d3970a427ca3579cca) - **exasol**: Add support for GROUP_CONCAT and LISTAGG functions *(PR [#5646](https://github.com/tobymao/sqlglot/pull/5646) by [@nnamdi16](https://github.com/nnamdi16))*
- [`d087ac8`](https://github.com/tobymao/sqlglot/commit/d087ac89376df5ab16de99c8b67f99060f0a6170) - **bigquery**: Add support for ml.generate_embedding function *(PR [#5652](https://github.com/tobymao/sqlglot/pull/5652) by [@rloredo](https://github.com/rloredo))*
- [`e71bcb5`](https://github.com/tobymao/sqlglot/commit/e71bcb51181de63c8ad13004216506529fcf9644) - **dremio**: support array_generate_range *(PR [#5653](https://github.com/tobymao/sqlglot/pull/5653) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`edbd04b`](https://github.com/tobymao/sqlglot/commit/edbd04b6a91b1a6f76e4fa938098ba5ed581ba72) - **singlestore**: Fixed generation of exp.RegexpLike *(PR [#5663](https://github.com/tobymao/sqlglot/pull/5663) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`4992edb`](https://github.com/tobymao/sqlglot/commit/4992edbb79f4922917cc5ce5aa687e6f7da7798c) - **singlestore**: Fixed exp.Xor generation *(PR [#5662](https://github.com/tobymao/sqlglot/pull/5662) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`20de3d3`](https://github.com/tobymao/sqlglot/commit/20de3d37cdae0705c67f80fbacbe024a62f34657) - **singlestore**: Fixed parsing/generation of exp.Hll *(PR [#5664](https://github.com/tobymao/sqlglot/pull/5664) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`1a60a5a`](https://github.com/tobymao/sqlglot/commit/1a60a5a845c7431d7d3d7ccb71119699316f4b41) - **singlestore**: Added parsing/generation of JSON_ARRAY_CONTAINS function *(PR [#5661](https://github.com/tobymao/sqlglot/pull/5661) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`f662dc0`](https://github.com/tobymao/sqlglot/commit/f662dc0b47fd14d00899c14a899756a5ba1fe9da) - **singlestore**: Fixed generation of exp.ApproxDistinct *(PR [#5666](https://github.com/tobymao/sqlglot/pull/5666) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e0db0a9`](https://github.com/tobymao/sqlglot/commit/e0db0a95d3cb7614242dbd1b439d408e7e7bd475) - **optimizer**: add parse and annotate type for bigquery FARM_FINGERPRINT *(PR [#5667](https://github.com/tobymao/sqlglot/pull/5667) by [@geooo109](https://github.com/geooo109))*
- [`dcd4ef7`](https://github.com/tobymao/sqlglot/commit/dcd4ef769727ed1227911f2d9a85244d61173003) - **singlestore**: Fixed exp.CountIf generation *(PR [#5668](https://github.com/tobymao/sqlglot/pull/5668) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`e431e85`](https://github.com/tobymao/sqlglot/commit/e431e851c2c5d20f049adbc38e370a64d39c346f) - **singlestore**: Fixed generation of exp.LogicalOr *(PR [#5669](https://github.com/tobymao/sqlglot/pull/5669) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`56588c7`](https://github.com/tobymao/sqlglot/commit/56588c7e22b4db4f0e44696a460483ca1e549163) - **bigquery**: Add support for vector_search function. Move predict to BigQuery dialect. *(PR [#5660](https://github.com/tobymao/sqlglot/pull/5660) by [@rloredo](https://github.com/rloredo))*
- [`f0d2cc2`](https://github.com/tobymao/sqlglot/commit/f0d2cc2b0f72340172ecd154f632aa6a24c15512) - **singlestore**: Fixed generation of exp.LogicalAnd *(PR [#5671](https://github.com/tobymao/sqlglot/pull/5671) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`a688a0f`](https://github.com/tobymao/sqlglot/commit/a688a0f0d70f87139e531d1419b338b695bec384) - **optimizer**: parse and annotate type for bigquery APPROX_TOP_COUNT *(PR [#5670](https://github.com/tobymao/sqlglot/pull/5670) by [@geooo109](https://github.com/geooo109))*
- [`fa8d571`](https://github.com/tobymao/sqlglot/commit/fa8d57132b1d21d92eb5de3ba88b41f880e14889) - **singlestore**: Fixed generation/parsing of exp.ApproxQuantile *(PR [#5672](https://github.com/tobymao/sqlglot/pull/5672) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`9955ebe`](https://github.com/tobymao/sqlglot/commit/9955ebe90d3421815738ecb643806add755c5df3) - **singlestore**: Fixed parsing/generation of exp.Variance *(PR [#5673](https://github.com/tobymao/sqlglot/pull/5673) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`3c93fcc`](https://github.com/tobymao/sqlglot/commit/3c93fcce96ec82e78753f6c9dd5fb0e730a82058) - **optimizer**: parse and annotate type for bigquery APPROX_TOP_SUM *(PR [#5675](https://github.com/tobymao/sqlglot/pull/5675) by [@geooo109](https://github.com/geooo109))*
- [`60cbb9d`](https://github.com/tobymao/sqlglot/commit/60cbb9d0e3c9b5a36c1368c9b5bb05def8ce8658) - **dremio**: add CURRENT_DATE_UTC *(PR [#5674](https://github.com/tobymao/sqlglot/pull/5674) by [@jasonthomassql](https://github.com/jasonthomassql))*
  - :arrow_lower_right: *addresses issue [#5655](https://github.com/tobymao/sqlglot/issues/5655) opened by [@jasonthomassql](https://github.com/jasonthomassql)*
- [`741d45a`](https://github.com/tobymao/sqlglot/commit/741d45a0ca7c1bad67da4393cd10cc9cfa49ea68) - **optimizer**: parse and annotate type for bigquery FROM/TO_BASE32 *(PR [#5676](https://github.com/tobymao/sqlglot/pull/5676) by [@geooo109](https://github.com/geooo109))*
- [`9ae045c`](https://github.com/tobymao/sqlglot/commit/9ae045c0405e43b148e3b9261825288ebf09100c) - **optimizer**: parse and annotate type for bigquery FROM_HEX *(PR [#5679](https://github.com/tobymao/sqlglot/pull/5679) by [@geooo109](https://github.com/geooo109))*
- [`5a22a25`](https://github.com/tobymao/sqlglot/commit/5a22a254143978989027f6e7f6163019a34f112a) - **optimizer**: annotate type for bigquery TO_HEX *(PR [#5680](https://github.com/tobymao/sqlglot/pull/5680) by [@geooo109](https://github.com/geooo109))*
- [`d920ac3`](https://github.com/tobymao/sqlglot/commit/d920ac3886ce006d76616bc31884ee2f5c4162bc) - **singlestore**: Fixed parsing/generation of exp.RegexpExtractAll *(PR [#5692](https://github.com/tobymao/sqlglot/pull/5692) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`260c72b`](https://github.com/tobymao/sqlglot/commit/260c72befc0510ebe1d007284c0eef9343de20d7) - **singlestore**: Fixed parsing/generation of exp.Contains *(PR [#5684](https://github.com/tobymao/sqlglot/pull/5684) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`081dc67`](https://github.com/tobymao/sqlglot/commit/081dc673b89d3d8d0709b29e359142297ff64536) - **singlestore**: Fixed generaion/parsing of exp.VariancePop *(PR [#5682](https://github.com/tobymao/sqlglot/pull/5682) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`eb538bf`](https://github.com/tobymao/sqlglot/commit/eb538bf225645d0a54d614733e447c13cf91a37a) - **singlestore**: Fixed generation of exp.Chr *(PR [#5683](https://github.com/tobymao/sqlglot/pull/5683) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`32d9dd1`](https://github.com/tobymao/sqlglot/commit/32d9dd1309ce0876114f57993596c4456aa1d50f) - **singlestore**: Fixed exp.MD5Digest generation *(PR [#5688](https://github.com/tobymao/sqlglot/pull/5688) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`5c1eb2d`](https://github.com/tobymao/sqlglot/commit/5c1eb2df5dd3dcc6ed2c8204cec56b5c3d276f87) - **optimizer**: parse and annotate type for bq PARSE_BIG/NUMERIC *(PR [#5690](https://github.com/tobymao/sqlglot/pull/5690) by [@geooo109](https://github.com/geooo109))*
- [`6f88500`](https://github.com/tobymao/sqlglot/commit/6f885007a075339cf20034459571a6ae821c61c0) - **singlestore**: Fixed exp.IsAscii generation *(PR [#5687](https://github.com/tobymao/sqlglot/pull/5687) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`311373d`](https://github.com/tobymao/sqlglot/commit/311373d22134de906d1c1cef019541e85e2f7c9f) - **optimizer**: parse and annotate type for bq CODE_POINTS_TO_BYTES *(PR [#5686](https://github.com/tobymao/sqlglot/pull/5686) by [@geooo109](https://github.com/geooo109))*
- [`79d9de1`](https://github.com/tobymao/sqlglot/commit/79d9de1745598f8f3ae2c82c1389dd455c946a09) - **optimizer**: parse and annotate type for bq TO_CODE_POINTS *(PR [#5685](https://github.com/tobymao/sqlglot/pull/5685) by [@geooo109](https://github.com/geooo109))*
- [`5df3ea9`](https://github.com/tobymao/sqlglot/commit/5df3ea92f59125955124ea1883b777b489db3042) - **optimizer**: parse and annotate type for bq SAFE_CONVERT_BYTES_TO_STRING *(PR [#5681](https://github.com/tobymao/sqlglot/pull/5681) by [@geooo109](https://github.com/geooo109))*
- [`c832746`](https://github.com/tobymao/sqlglot/commit/c832746018fbc2c531d5b2a7c7f8cd5d78e511ff) - **optimizer**: parse and annotate type for bigquery APPROX_QUANTILES *(PR [#5678](https://github.com/tobymao/sqlglot/pull/5678) by [@geooo109](https://github.com/geooo109))*
- [`8fa5ae8`](https://github.com/tobymao/sqlglot/commit/8fa5ae8a61c698abaea265b4950390ea3ddfa7e9) - **singlestore**: Fixed generation/parsing of exp.RegexpExtract *(PR [#5691](https://github.com/tobymao/sqlglot/pull/5691) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`d6d409a`](https://github.com/tobymao/sqlglot/commit/d6d409a548042063f80d02dfaf5b61a0096d1d50) - **singlestore**: Fixed generaion of exp.Repeat *(PR [#5693](https://github.com/tobymao/sqlglot/pull/5693) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`b7db08b`](https://github.com/tobymao/sqlglot/commit/b7db08b96c7d7d02ec54f26b8749b3d57f021d8b) - **singlestore**: Fixed generation of exp.StartsWith *(PR [#5694](https://github.com/tobymao/sqlglot/pull/5694) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`87b04ef`](https://github.com/tobymao/sqlglot/commit/87b04ef0fc2df5064be9e6b75b264cff0639face) - **singlestore**: Fixed generation of exp.FromBase *(PR [#5695](https://github.com/tobymao/sqlglot/pull/5695) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`9c1d0fd`](https://github.com/tobymao/sqlglot/commit/9c1d0fdac9acd3fb3109ca3d3cae9c9ffaed1a7d) - **duckdb**: transpile array unique aggregation closes [#5689](https://github.com/tobymao/sqlglot/pull/5689) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`99e169e`](https://github.com/tobymao/sqlglot/commit/99e169ea13d5be3712a47f6b55b98a4764a3c24d) - **optimizer**: parse and annotate type for bq BOOL *(PR [#5697](https://github.com/tobymao/sqlglot/pull/5697) by [@geooo109](https://github.com/geooo109))*
- [`3f31770`](https://github.com/tobymao/sqlglot/commit/3f31770c793f464fcac1ce2b8dfa03d4b7f0231c) - **optimizer**: parse and annotate type for bq FLOAT64 *(PR [#5700](https://github.com/tobymao/sqlglot/pull/5700) by [@geooo109](https://github.com/geooo109))*

### :bug: Bug Fixes
- [`f1269f5`](https://github.com/tobymao/sqlglot/commit/f1269f5ecfccfee4cdeeda5bfd10eb1c47994fad) - **tsql**: do not attach limit modifier to set operation *(PR [#5609](https://github.com/tobymao/sqlglot/pull/5609) by [@georgesittas](https://github.com/georgesittas))*
- [`a6edf8e`](https://github.com/tobymao/sqlglot/commit/a6edf8ee3273a7736ed801ef8dea302613b119da) - **tsql**: Remove ORDER from set op modifiers too *(PR [#5626](https://github.com/tobymao/sqlglot/pull/5626) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5618](https://github.com/tobymao/sqlglot/issues/5618) opened by [@MQMMMQM](https://github.com/MQMMMQM)*
- [`ce5840e`](https://github.com/tobymao/sqlglot/commit/ce5840ed615e162a93cd911ab6207160878fcc64) - **exasol**: update several dialect properties to correctly reflect semantics *(PR [#5642](https://github.com/tobymao/sqlglot/pull/5642) by [@nnamdi16](https://github.com/nnamdi16))*
- [`3ab1d44`](https://github.com/tobymao/sqlglot/commit/3ab1d4487279cab3be2d3764e51516c6db21629d) - **generator**: Wrap CONCAT items with COALESCE less aggressively *(PR [#5641](https://github.com/tobymao/sqlglot/pull/5641) by [@VaggelisD](https://github.com/VaggelisD))*
- [`045d2f0`](https://github.com/tobymao/sqlglot/commit/045d2f02649b0e6dc178c079e4e0db201ed9bf08) - **duckdb**: Transpile Spark's FIRST(col, TRUE) *(PR [#5644](https://github.com/tobymao/sqlglot/pull/5644) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5643](https://github.com/tobymao/sqlglot/issues/5643) opened by [@michal-clutch](https://github.com/michal-clutch)*

### :wrench: Chores
- [`4c04c0c`](https://github.com/tobymao/sqlglot/commit/4c04c0ce859ab8314ed36fb8779f14c0fc2f1094) - use a valid SPDX identifier as license classifier *(PR [#5606](https://github.com/tobymao/sqlglot/pull/5606) by [@ecederstrand](https://github.com/ecederstrand))*
- [`249f638`](https://github.com/tobymao/sqlglot/commit/249f638877ddd2a1732d1e6bc859793f3bc0622d) - add table to document dialect support level *(PR [#5628](https://github.com/tobymao/sqlglot/pull/5628) by [@georgesittas](https://github.com/georgesittas))*
- [`3357125`](https://github.com/tobymao/sqlglot/commit/33571250d172d64a3e0450738b3ad330e5c0a795) - **doris**: refactor unique key prop generation *(PR [#5625](https://github.com/tobymao/sqlglot/pull/5625) by [@georgesittas](https://github.com/georgesittas))*
- [`545f1ac`](https://github.com/tobymao/sqlglot/commit/545f1acd76bdc4e537209266984137f6c69ce622) - Clean up of PR5614 *(PR [#5648](https://github.com/tobymao/sqlglot/pull/5648) by [@VaggelisD](https://github.com/VaggelisD))*


## [v27.8.0] - 2025-08-19
### :boom: BREAKING CHANGES
- due to [`2a33339`](https://github.com/tobymao/sqlglot/commit/2a333395cde71936df911488afcff92cae735e11) - annotate type for bigquery REPLACE *(PR [#5572](https://github.com/tobymao/sqlglot/pull/5572) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery REPLACE (#5572)

- due to [`1e6f813`](https://github.com/tobymao/sqlglot/commit/1e6f81343de641e588f1a05ce7dc01bed72bd849) - annotate type for bigquery REGEXP_EXTRACT_ALL *(PR [#5573](https://github.com/tobymao/sqlglot/pull/5573) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery REGEXP_EXTRACT_ALL (#5573)

- due to [`d0d62ed`](https://github.com/tobymao/sqlglot/commit/d0d62ede6320b3fd0eee04b7073f5708676dc58c) - support `TO_CHAR` with numeric inputs *(PR [#5570](https://github.com/tobymao/sqlglot/pull/5570) by [@jasonthomassql](https://github.com/jasonthomassql))*:

  support `TO_CHAR` with numeric inputs (#5570)

- due to [`7928985`](https://github.com/tobymao/sqlglot/commit/7928985a655c3d0244bc9175a37f502b19a5c5f0) - allow dashes in JSONPath keys *(PR [#5574](https://github.com/tobymao/sqlglot/pull/5574) by [@georgesittas](https://github.com/georgesittas))*:

  allow dashes in JSONPath keys (#5574)

- due to [`eb09e6e`](https://github.com/tobymao/sqlglot/commit/eb09e6e32491a05846488de7b72b1dca0e0a2669) - parse and annotate type for bigquery TRANSLATE *(PR [#5575](https://github.com/tobymao/sqlglot/pull/5575) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery TRANSLATE (#5575)

- due to [`f9a522b`](https://github.com/tobymao/sqlglot/commit/f9a522b26cd5d643b8b18fa64d70f2a3f0ff2d2c) - parse and annotate type for bigquery SOUNDEX *(PR [#5576](https://github.com/tobymao/sqlglot/pull/5576) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery SOUNDEX (#5576)

- due to [`51da41b`](https://github.com/tobymao/sqlglot/commit/51da41b90ce421b154e45add28353ac044640a1c) - annotate type for bigquery MD5 *(PR [#5577](https://github.com/tobymao/sqlglot/pull/5577) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery MD5 (#5577)

- due to [`bcf302f`](https://github.com/tobymao/sqlglot/commit/bcf302ff6ad2d0adfc29f708a8b53b5c0e547619) - annotate type for bigquery MIN/MAX BY *(PR [#5579](https://github.com/tobymao/sqlglot/pull/5579) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery MIN/MAX BY (#5579)

- due to [`c501d9e`](https://github.com/tobymao/sqlglot/commit/c501d9e6f58e4880e4d23f21f53f72dcb5fdaa8c) - parse and annotate type for bigquery GROUPING *(PR [#5581](https://github.com/tobymao/sqlglot/pull/5581) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery GROUPING (#5581)


### :sparkles: New Features
- [`2a33339`](https://github.com/tobymao/sqlglot/commit/2a333395cde71936df911488afcff92cae735e11) - **optimizer**: annotate type for bigquery REPLACE *(PR [#5572](https://github.com/tobymao/sqlglot/pull/5572) by [@geooo109](https://github.com/geooo109))*
- [`1e6f813`](https://github.com/tobymao/sqlglot/commit/1e6f81343de641e588f1a05ce7dc01bed72bd849) - **optimizer**: annotate type for bigquery REGEXP_EXTRACT_ALL *(PR [#5573](https://github.com/tobymao/sqlglot/pull/5573) by [@geooo109](https://github.com/geooo109))*
- [`eb09e6e`](https://github.com/tobymao/sqlglot/commit/eb09e6e32491a05846488de7b72b1dca0e0a2669) - **optimizer**: parse and annotate type for bigquery TRANSLATE *(PR [#5575](https://github.com/tobymao/sqlglot/pull/5575) by [@geooo109](https://github.com/geooo109))*
- [`f9a522b`](https://github.com/tobymao/sqlglot/commit/f9a522b26cd5d643b8b18fa64d70f2a3f0ff2d2c) - **optimizer**: parse and annotate type for bigquery SOUNDEX *(PR [#5576](https://github.com/tobymao/sqlglot/pull/5576) by [@geooo109](https://github.com/geooo109))*
- [`51da41b`](https://github.com/tobymao/sqlglot/commit/51da41b90ce421b154e45add28353ac044640a1c) - **optimizer**: annotate type for bigquery MD5 *(PR [#5577](https://github.com/tobymao/sqlglot/pull/5577) by [@geooo109](https://github.com/geooo109))*
- [`bcf302f`](https://github.com/tobymao/sqlglot/commit/bcf302ff6ad2d0adfc29f708a8b53b5c0e547619) - **optimizer**: annotate type for bigquery MIN/MAX BY *(PR [#5579](https://github.com/tobymao/sqlglot/pull/5579) by [@geooo109](https://github.com/geooo109))*
- [`c501d9e`](https://github.com/tobymao/sqlglot/commit/c501d9e6f58e4880e4d23f21f53f72dcb5fdaa8c) - **optimizer**: parse and annotate type for bigquery GROUPING *(PR [#5581](https://github.com/tobymao/sqlglot/pull/5581) by [@geooo109](https://github.com/geooo109))*
- [`8612825`](https://github.com/tobymao/sqlglot/commit/86128253f911b733d45b073356e3b8ddf261c22b) - **spark**: generate date/time ops as interval binary ops *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`8fda774`](https://github.com/tobymao/sqlglot/commit/8fda774b7a9b0c66948349dfe030d3c122ff6eee) - **singlestore**: Added parsing and generation of JSON_EXTRACT *(PR [#5555](https://github.com/tobymao/sqlglot/pull/5555) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`82cc954`](https://github.com/tobymao/sqlglot/commit/82cc9549a875211a400e5c4e818b05ca48a0a9f4) - **exasol**: map div function to IntDiv in exasol dialect *(PR [#5593](https://github.com/tobymao/sqlglot/pull/5593) by [@nnamdi16](https://github.com/nnamdi16))*
- [`eb0fe68`](https://github.com/tobymao/sqlglot/commit/eb0fe68d6b5977053c871badf2f5c1895b3e1c66) - **trino**: add JSON_VALUE function support with RETURNING clause *(PR [#5590](https://github.com/tobymao/sqlglot/pull/5590) by [@rev-rwasilewski](https://github.com/rev-rwasilewski))*
- [`9e95c11`](https://github.com/tobymao/sqlglot/commit/9e95c115ea0304d9ccb4cb0be8389f5ff5f2a952) - **exasol**: mapped weekofyear to week in Exasol dialect *(PR [#5594](https://github.com/tobymao/sqlglot/pull/5594) by [@nnamdi16](https://github.com/nnamdi16))*
- [`8f013c3`](https://github.com/tobymao/sqlglot/commit/8f013c37a412ca5978889c1e47b0c6f7add0715d) - **singlestore**: Fixed parsing of DATE function *(PR [#5601](https://github.com/tobymao/sqlglot/pull/5601) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`a4a299a`](https://github.com/tobymao/sqlglot/commit/a4a299acbaf4461f0c2b470bc4e9e9590515eda7) - transpile `TO_CHAR` from Dremio to Databricks *(PR [#5598](https://github.com/tobymao/sqlglot/pull/5598) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`093f35c`](https://github.com/tobymao/sqlglot/commit/093f35c201c3c22c3a14c6f8de26c06246bdf19c) - **dremio**: handle `DATE_FORMAT`, `TO_DATE`, and `TO_TIMESTAMP` *(PR [#5597](https://github.com/tobymao/sqlglot/pull/5597) by [@jasonthomassql](https://github.com/jasonthomassql))*

### :bug: Bug Fixes
- [`d0d62ed`](https://github.com/tobymao/sqlglot/commit/d0d62ede6320b3fd0eee04b7073f5708676dc58c) - **dremio**: support `TO_CHAR` with numeric inputs *(PR [#5570](https://github.com/tobymao/sqlglot/pull/5570) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`7928985`](https://github.com/tobymao/sqlglot/commit/7928985a655c3d0244bc9175a37f502b19a5c5f0) - **bigquery**: allow dashes in JSONPath keys *(PR [#5574](https://github.com/tobymao/sqlglot/pull/5574) by [@georgesittas](https://github.com/georgesittas))*
- [`866042d`](https://github.com/tobymao/sqlglot/commit/866042d0268da0cebce042c0868878c0fb39c3d1) - Remove TokenType.APPLY from table alias tokens *(PR [#5592](https://github.com/tobymao/sqlglot/pull/5592) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5591](https://github.com/tobymao/sqlglot/issues/5591) opened by [@saadbelgi](https://github.com/saadbelgi)*
- [`b485f66`](https://github.com/tobymao/sqlglot/commit/b485f6666fa8625b7da45ef832b5d666fbb707ea) - **dremio**: improve `TO_CHAR` transpilability *(PR [#5580](https://github.com/tobymao/sqlglot/pull/5580) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`81874e9`](https://github.com/tobymao/sqlglot/commit/81874e9c3aafcc2cf8fb443f65146c5b3598b9b3) - handle unknown types in `unit_to_str` *(commit by [@georgesittas](https://github.com/georgesittas))*

### :wrench: Chores
- [`173e442`](https://github.com/tobymao/sqlglot/commit/173e4425b692728abffa8542324690823f984303) - refactor JSON_VALUE handling for MySQL and Trino *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.7.0] - 2025-08-13
### :boom: BREAKING CHANGES
- due to [`938f4b6`](https://github.com/tobymao/sqlglot/commit/938f4b6ebc1c0d26bd3c1400883978c79a435189) - annotate type for LAST_DAY *(PR [#5528](https://github.com/tobymao/sqlglot/pull/5528) by [@geooo109](https://github.com/geooo109))*:

  annotate type for LAST_DAY (#5528)

- due to [`7d12dac`](https://github.com/tobymao/sqlglot/commit/7d12dac613ba5119334408f2c52cb270067156d9) - annotate type for bigquery GENERATE_TIMESTAMP_ARRAY *(PR [#5529](https://github.com/tobymao/sqlglot/pull/5529) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery GENERATE_TIMESTAMP_ARRAY (#5529)

- due to [`d50ebe2`](https://github.com/tobymao/sqlglot/commit/d50ebe286dd8e2836b9eb2a3406f15976db3aa05) - annotate type for bigquery TIME_TRUNC *(PR [#5530](https://github.com/tobymao/sqlglot/pull/5530) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery TIME_TRUNC (#5530)

- due to [`29748be`](https://github.com/tobymao/sqlglot/commit/29748be7dfc10edc9f29665c98327883dd25c13d) - annotate type for bigquery TIME *(PR [#5531](https://github.com/tobymao/sqlglot/pull/5531) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery TIME (#5531)

- due to [`7003b3f`](https://github.com/tobymao/sqlglot/commit/7003b3fa39cd455e3643066364696708d1ac4f38) - parse and annotate type for bigquery DATE_FROM_UNIX_DATE *(PR [#5532](https://github.com/tobymao/sqlglot/pull/5532) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery DATE_FROM_UNIX_DATE (#5532)

- due to [`a276ca6`](https://github.com/tobymao/sqlglot/commit/a276ca6fd5f9d47fa8c90fcfa19f9864e7a28f8f) - parse and annotate type for bigquery JUSTIFY funcs *(PR [#5534](https://github.com/tobymao/sqlglot/pull/5534) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery JUSTIFY funcs (#5534)

- due to [`374178e`](https://github.com/tobymao/sqlglot/commit/374178e22fe8d2d2275b65fe08e27ef66c611220) - parse and annotate type for bigquery UNIX_MICROS and UNIX_MILLIS *(PR [#5535](https://github.com/tobymao/sqlglot/pull/5535) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery UNIX_MICROS and UNIX_MILLIS (#5535)

- due to [`1d8d1ab`](https://github.com/tobymao/sqlglot/commit/1d8d1abe459053a135a46525d0a13bb861220927) - annotate type for bigquery DATE_TRUNC *(PR [#5540](https://github.com/tobymao/sqlglot/pull/5540) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery DATE_TRUNC (#5540)

- due to [`306ba65`](https://github.com/tobymao/sqlglot/commit/306ba6531839ea2823f5165de7bde01d17560845) - annotate type for bigquery TIMESTAMP_TRUNC *(PR [#5541](https://github.com/tobymao/sqlglot/pull/5541) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery TIMESTAMP_TRUNC (#5541)

- due to [`d799c5a`](https://github.com/tobymao/sqlglot/commit/d799c5af23010a67c29edb6d45a40fb24903e1a3) - preserve projection names when merging subqueries *(commit by [@snovik75](https://github.com/snovik75))*:

  preserve projection names when merging subqueries

- due to [`8130bd4`](https://github.com/tobymao/sqlglot/commit/8130bd40815803a6781ee8f20fccd30987516192) - WEEKDAY of WEEK as VAR *(PR [#5552](https://github.com/tobymao/sqlglot/pull/5552) by [@geooo109](https://github.com/geooo109))*:

  WEEKDAY of WEEK as VAR (#5552)

- due to [`f3ffe19`](https://github.com/tobymao/sqlglot/commit/f3ffe19ec01533c5f27b9d3a7b6704b83c005118) - annotate type for bigquery format_time *(PR [#5559](https://github.com/tobymao/sqlglot/pull/5559) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery format_time (#5559)

- due to [`6872b43`](https://github.com/tobymao/sqlglot/commit/6872b43ba17a39137172fd2fa9f0d059ce595ef9) - use dialect in DataType.build fixes [#5560](https://github.com/tobymao/sqlglot/pull/5560) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  use dialect in DataType.build fixes #5560

- due to [`3ab3690`](https://github.com/tobymao/sqlglot/commit/3ab369096313b418699b7942b1c513c0c66a5331) - parse and annotate type for bigquery PARSE_DATETIME *(PR [#5558](https://github.com/tobymao/sqlglot/pull/5558) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery PARSE_DATETIME (#5558)

- due to [`e5da951`](https://github.com/tobymao/sqlglot/commit/e5da951542eb55691bc43fbbfbec4a30100de038) - parse and annotate type for bigquery PARSE_TIME *(PR [#5561](https://github.com/tobymao/sqlglot/pull/5561) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery PARSE_TIME (#5561)

- due to [`798e213`](https://github.com/tobymao/sqlglot/commit/798e213fd10c3b61afbd8cef621546de65fa6f26) - improve transpilability of ANY_VALUE closes [#5563](https://github.com/tobymao/sqlglot/pull/5563) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  improve transpilability of ANY_VALUE closes #5563

- due to [`8c0cb76`](https://github.com/tobymao/sqlglot/commit/8c0cb764fd825062fb7334032b8eeffbc39627d5) - more robust CREATE SEQUENCE *(PR [#5566](https://github.com/tobymao/sqlglot/pull/5566) by [@geooo109](https://github.com/geooo109))*:

  more robust CREATE SEQUENCE (#5566)

- due to [`c7041c7`](https://github.com/tobymao/sqlglot/commit/c7041c71250b17192c2f25fb8f33407324d332c2) - parse and annotate type for bigquery BYTE_LENGHT *(PR [#5568](https://github.com/tobymao/sqlglot/pull/5568) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery BYTE_LENGHT (#5568)

- due to [`a6c61c3`](https://github.com/tobymao/sqlglot/commit/a6c61c34f1e168c97dd5c2b8ec071372ba593992) - parse and annotate type for bigquery CODE_POINTS_TO_STRING *(PR [#5569](https://github.com/tobymao/sqlglot/pull/5569) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery CODE_POINTS_TO_STRING (#5569)

- due to [`51e0335`](https://github.com/tobymao/sqlglot/commit/51e0335377fe2bc2e2a94a623475791e9dd19fb9) - parse and annotate type for bigquery REVERSE *(PR [#5571](https://github.com/tobymao/sqlglot/pull/5571) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for bigquery REVERSE (#5571)


### :sparkles: New Features
- [`1fb90db`](https://github.com/tobymao/sqlglot/commit/1fb90db52b59e6e3a40597c6f611d0476b72025b) - **teradata**: Add support for Teradata set query band expression *(PR [#5519](https://github.com/tobymao/sqlglot/pull/5519) by [@treff7es](https://github.com/treff7es))*
- [`a49baaf`](https://github.com/tobymao/sqlglot/commit/a49baaf717cb41abb25ca51ae5adddc8473baa8b) - **doris**: Override table_sql to avoid AS keyword in UPDATE and DELETE statements *(PR [#5517](https://github.com/tobymao/sqlglot/pull/5517) by [@peterylh](https://github.com/peterylh))*
- [`75fd6d2`](https://github.com/tobymao/sqlglot/commit/75fd6d21fb7bc8399432e73d10b4837ae62d2ab5) - **exasol**: Add support for date difference functions in Exasol dialect *(PR [#5510](https://github.com/tobymao/sqlglot/pull/5510) by [@nnamdi16](https://github.com/nnamdi16))*
- [`2a91bb4`](https://github.com/tobymao/sqlglot/commit/2a91bb4f17c7569a5b409cc07e970e5d68235149) - **teradata**: Add support for Teradata locking select *(PR [#5524](https://github.com/tobymao/sqlglot/pull/5524) by [@treff7es](https://github.com/treff7es))*
- [`938f4b6`](https://github.com/tobymao/sqlglot/commit/938f4b6ebc1c0d26bd3c1400883978c79a435189) - **optimizer**: annotate type for LAST_DAY *(PR [#5528](https://github.com/tobymao/sqlglot/pull/5528) by [@geooo109](https://github.com/geooo109))*
- [`7d12dac`](https://github.com/tobymao/sqlglot/commit/7d12dac613ba5119334408f2c52cb270067156d9) - **optimizer**: annotate type for bigquery GENERATE_TIMESTAMP_ARRAY *(PR [#5529](https://github.com/tobymao/sqlglot/pull/5529) by [@geooo109](https://github.com/geooo109))*
- [`d50ebe2`](https://github.com/tobymao/sqlglot/commit/d50ebe286dd8e2836b9eb2a3406f15976db3aa05) - **optimizer**: annotate type for bigquery TIME_TRUNC *(PR [#5530](https://github.com/tobymao/sqlglot/pull/5530) by [@geooo109](https://github.com/geooo109))*
- [`29748be`](https://github.com/tobymao/sqlglot/commit/29748be7dfc10edc9f29665c98327883dd25c13d) - **optimizer**: annotate type for bigquery TIME *(PR [#5531](https://github.com/tobymao/sqlglot/pull/5531) by [@geooo109](https://github.com/geooo109))*
- [`7003b3f`](https://github.com/tobymao/sqlglot/commit/7003b3fa39cd455e3643066364696708d1ac4f38) - **optimizer**: parse and annotate type for bigquery DATE_FROM_UNIX_DATE *(PR [#5532](https://github.com/tobymao/sqlglot/pull/5532) by [@geooo109](https://github.com/geooo109))*
- [`a276ca6`](https://github.com/tobymao/sqlglot/commit/a276ca6fd5f9d47fa8c90fcfa19f9864e7a28f8f) - **optimizer**: parse and annotate type for bigquery JUSTIFY funcs *(PR [#5534](https://github.com/tobymao/sqlglot/pull/5534) by [@geooo109](https://github.com/geooo109))*
- [`374178e`](https://github.com/tobymao/sqlglot/commit/374178e22fe8d2d2275b65fe08e27ef66c611220) - **optimizer**: parse and annotate type for bigquery UNIX_MICROS and UNIX_MILLIS *(PR [#5535](https://github.com/tobymao/sqlglot/pull/5535) by [@geooo109](https://github.com/geooo109))*
- [`1d8d1ab`](https://github.com/tobymao/sqlglot/commit/1d8d1abe459053a135a46525d0a13bb861220927) - **optimizer**: annotate type for bigquery DATE_TRUNC *(PR [#5540](https://github.com/tobymao/sqlglot/pull/5540) by [@geooo109](https://github.com/geooo109))*
- [`306ba65`](https://github.com/tobymao/sqlglot/commit/306ba6531839ea2823f5165de7bde01d17560845) - **optimizer**: annotate type for bigquery TIMESTAMP_TRUNC *(PR [#5541](https://github.com/tobymao/sqlglot/pull/5541) by [@geooo109](https://github.com/geooo109))*
- [`6a68cca`](https://github.com/tobymao/sqlglot/commit/6a68cca97ad4bdd75c544ada0a5af0fa92ec4664) - **dremio**: support lowercase `TIME_MAPPING` formats *(PR [#5556](https://github.com/tobymao/sqlglot/pull/5556) by [@jasonthomassql](https://github.com/jasonthomassql))*
- [`f3ffe19`](https://github.com/tobymao/sqlglot/commit/f3ffe19ec01533c5f27b9d3a7b6704b83c005118) - **optimizer**: annotate type for bigquery format_time *(PR [#5559](https://github.com/tobymao/sqlglot/pull/5559) by [@geooo109](https://github.com/geooo109))*
- [`3ab3690`](https://github.com/tobymao/sqlglot/commit/3ab369096313b418699b7942b1c513c0c66a5331) - **optimizer**: parse and annotate type for bigquery PARSE_DATETIME *(PR [#5558](https://github.com/tobymao/sqlglot/pull/5558) by [@geooo109](https://github.com/geooo109))*
- [`e5da951`](https://github.com/tobymao/sqlglot/commit/e5da951542eb55691bc43fbbfbec4a30100de038) - **optimizer**: parse and annotate type for bigquery PARSE_TIME *(PR [#5561](https://github.com/tobymao/sqlglot/pull/5561) by [@geooo109](https://github.com/geooo109))*
- [`902a0cd`](https://github.com/tobymao/sqlglot/commit/902a0cdfe46f693aa55612d45a2de2def21f0b8c) - **singlestore**: Added parsing/generation of UNIXTIME functions *(PR [#5562](https://github.com/tobymao/sqlglot/pull/5562) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`798e213`](https://github.com/tobymao/sqlglot/commit/798e213fd10c3b61afbd8cef621546de65fa6f26) - **duckdb**: improve transpilability of ANY_VALUE closes [#5563](https://github.com/tobymao/sqlglot/pull/5563) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`c7041c7`](https://github.com/tobymao/sqlglot/commit/c7041c71250b17192c2f25fb8f33407324d332c2) - **optimizer**: parse and annotate type for bigquery BYTE_LENGHT *(PR [#5568](https://github.com/tobymao/sqlglot/pull/5568) by [@geooo109](https://github.com/geooo109))*
- [`a6c61c3`](https://github.com/tobymao/sqlglot/commit/a6c61c34f1e168c97dd5c2b8ec071372ba593992) - **optimizer**: parse and annotate type for bigquery CODE_POINTS_TO_STRING *(PR [#5569](https://github.com/tobymao/sqlglot/pull/5569) by [@geooo109](https://github.com/geooo109))*

### :bug: Bug Fixes
- [`9020684`](https://github.com/tobymao/sqlglot/commit/9020684a7e984a10fa4775339596ac5a0d6a6d93) - nested natural join performance closes [#5514](https://github.com/tobymao/sqlglot/pull/5514) *(PR [#5515](https://github.com/tobymao/sqlglot/pull/5515) by [@tobymao](https://github.com/tobymao))*
- [`394870a`](https://github.com/tobymao/sqlglot/commit/394870a7ee9bb3bc814b7c3847193687f06b432b) - **duckdb**: transpile ADD_MONTHS *(PR [#5523](https://github.com/tobymao/sqlglot/pull/5523) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5505](https://github.com/tobymao/sqlglot/issues/5505) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`249692c`](https://github.com/tobymao/sqlglot/commit/249692c67450a1fe3775e1f35b6f62fdb0a62e1a) - **duckdb**: put guard in AddMonths generator before annotating it *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`d799c5a`](https://github.com/tobymao/sqlglot/commit/d799c5af23010a67c29edb6d45a40fb24903e1a3) - **optimizer**: preserve projection names when merging subqueries *(commit by [@snovik75](https://github.com/snovik75))*
- [`8130bd4`](https://github.com/tobymao/sqlglot/commit/8130bd40815803a6781ee8f20fccd30987516192) - **parser**: WEEKDAY of WEEK as VAR *(PR [#5552](https://github.com/tobymao/sqlglot/pull/5552) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5547](https://github.com/tobymao/sqlglot/issues/5547) opened by [@rloredo](https://github.com/rloredo)*
- [`4e1373f`](https://github.com/tobymao/sqlglot/commit/4e1373f301cbea3cb5762fc1430b65deae3f9d04) - **doris**: Rename Table *(PR [#5549](https://github.com/tobymao/sqlglot/pull/5549) by [@xinge-ji](https://github.com/xinge-ji))*
- [`16f544d`](https://github.com/tobymao/sqlglot/commit/16f544dc25d5d61277d32f02e4be18c10d16cf9f) - **doris**: fix DATE_TRUNC and partition by *(PR [#5553](https://github.com/tobymao/sqlglot/pull/5553) by [@xinge-ji](https://github.com/xinge-ji))*
- [`6295414`](https://github.com/tobymao/sqlglot/commit/6295414fb41401f92993e661b880a0727e74c087) - convert unit to Var instead of choosing default in `unit_to_var` *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`6872b43`](https://github.com/tobymao/sqlglot/commit/6872b43ba17a39137172fd2fa9f0d059ce595ef9) - **parser**: use dialect in DataType.build fixes [#5560](https://github.com/tobymao/sqlglot/pull/5560) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`6f354d9`](https://github.com/tobymao/sqlglot/commit/6f354d958fb9ca9242b7fc1d2da86af74d57fedc) - **clickhouse**: add ROWS keyword in OFFSET followed by FETCH fixes [#5564](https://github.com/tobymao/sqlglot/pull/5564) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`8c0cb76`](https://github.com/tobymao/sqlglot/commit/8c0cb764fd825062fb7334032b8eeffbc39627d5) - **parser**: more robust CREATE SEQUENCE *(PR [#5566](https://github.com/tobymao/sqlglot/pull/5566) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5537](https://github.com/tobymao/sqlglot/issues/5537) opened by [@tekumara](https://github.com/tekumara)*
- [`7e9df88`](https://github.com/tobymao/sqlglot/commit/7e9df880bc118d0dbb2dbd6344f805f79af2fe5e) - **doris**: CURRENT_DATE *(PR [#5567](https://github.com/tobymao/sqlglot/pull/5567) by [@xinge-ji](https://github.com/xinge-ji))*
- [`51e0335`](https://github.com/tobymao/sqlglot/commit/51e0335377fe2bc2e2a94a623475791e9dd19fb9) - **optimizer**: parse and annotate type for bigquery REVERSE *(PR [#5571](https://github.com/tobymao/sqlglot/pull/5571) by [@geooo109](https://github.com/geooo109))*

### :wrench: Chores
- [`720f634`](https://github.com/tobymao/sqlglot/commit/720f6343f6144e8986ec6b7e50419c3d7a331f0a) - Fix style on main, refactor exasol tests *(PR [#5527](https://github.com/tobymao/sqlglot/pull/5527) by [@VaggelisD](https://github.com/VaggelisD))*
- [`5653501`](https://github.com/tobymao/sqlglot/commit/5653501606f041282b6315c3efa33b9a3baf8d98) - Refactor PR 5517 *(PR [#5526](https://github.com/tobymao/sqlglot/pull/5526) by [@VaggelisD](https://github.com/VaggelisD))*
- [`d15dfe3`](https://github.com/tobymao/sqlglot/commit/d15dfe3f0f4444e4999ad65051b2474e62f422b3) - build type using dialect for bigquery *(PR [#5539](https://github.com/tobymao/sqlglot/pull/5539) by [@geooo109](https://github.com/geooo109))*


## [v27.6.0] - 2025-08-01
### :boom: BREAKING CHANGES
- due to [`6b691b3`](https://github.com/tobymao/sqlglot/commit/6b691b33c3528c0377bd8822a3df90de869c6cb1) - Parse and transpile GET(...) extract function *(PR [#5500](https://github.com/tobymao/sqlglot/pull/5500) by [@VaggelisD](https://github.com/VaggelisD))*:

  Parse and transpile GET(...) extract function (#5500)

- due to [`964a275`](https://github.com/tobymao/sqlglot/commit/964a275b42314380de3b301ada9f9756602729f7) - Make `UNION` column qualification recursive *(PR [#5508](https://github.com/tobymao/sqlglot/pull/5508) by [@VaggelisD](https://github.com/VaggelisD))*:

  Make `UNION` column qualification recursive (#5508)


### :sparkles: New Features
- [`6b691b3`](https://github.com/tobymao/sqlglot/commit/6b691b33c3528c0377bd8822a3df90de869c6cb1) - **snowflake**: Parse and transpile GET(...) extract function *(PR [#5500](https://github.com/tobymao/sqlglot/pull/5500) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5495](https://github.com/tobymao/sqlglot/issues/5495) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`a2a2f0f`](https://github.com/tobymao/sqlglot/commit/a2a2f0fe910228651c5c39beebcc02172a0b7e94) - **exasol**: Add support for IF, NULLIFZERO, and ZEROIFNULL functions *(PR [#5502](https://github.com/tobymao/sqlglot/pull/5502) by [@nnamdi16](https://github.com/nnamdi16))*
- [`2d8ce58`](https://github.com/tobymao/sqlglot/commit/2d8ce587c75f21b188ec4c201936eedac3b051e8) - **singlestore**: Added cast operator *(PR [#5504](https://github.com/tobymao/sqlglot/pull/5504) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`6256348`](https://github.com/tobymao/sqlglot/commit/6256348a28b72ae9052d4244736846af209410b0) - **exasol**: add support for ADD_DAYS function in exasol dialect *(PR [#5507](https://github.com/tobymao/sqlglot/pull/5507) by [@nnamdi16](https://github.com/nnamdi16))*
- [`2f40fc5`](https://github.com/tobymao/sqlglot/commit/2f40fc578a840c9276a4c3b91351fb8d95c837fc) - add more pseudocols to bq which are not expanded by star *(PR [#5509](https://github.com/tobymao/sqlglot/pull/5509) by [@z3z1ma](https://github.com/z3z1ma))*

### :bug: Bug Fixes
- [`3b52061`](https://github.com/tobymao/sqlglot/commit/3b520611c5a894ddea935d13aadd27c791a8a755) - **exasol**: fix TokenType.TEXT mapping in exasol dialect *(PR [#5506](https://github.com/tobymao/sqlglot/pull/5506) by [@nnamdi16](https://github.com/nnamdi16))*
- [`964a275`](https://github.com/tobymao/sqlglot/commit/964a275b42314380de3b301ada9f9756602729f7) - Make `UNION` column qualification recursive *(PR [#5508](https://github.com/tobymao/sqlglot/pull/5508) by [@VaggelisD](https://github.com/VaggelisD))*


## [v27.5.1] - 2025-07-30
### :bug: Bug Fixes
- [`caf71d6`](https://github.com/tobymao/sqlglot/commit/caf71d687c0048d2346fddaee58b519e4f2e7945) - `between` builder should not set `symmetric` by default *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.5.0] - 2025-07-30
### :boom: BREAKING CHANGES
- due to [`002286e`](https://github.com/tobymao/sqlglot/commit/002286ee05a608e303a2238a9a74ab963709b5da) - remove AM/PM entries from postgres, oracle `TIME_MAPPING` *(PR [#5491](https://github.com/tobymao/sqlglot/pull/5491) by [@georgesittas](https://github.com/georgesittas))*:

  remove AM/PM entries from postgres, oracle `TIME_MAPPING` (#5491)

- due to [`ad78db6`](https://github.com/tobymao/sqlglot/commit/ad78db6c9002a5bf9188d66f0080dfefd070f77b) - Refactor `LIKE ANY` and support  `ALL | SOME` quantifiers *(PR [#5493](https://github.com/tobymao/sqlglot/pull/5493) by [@VaggelisD](https://github.com/VaggelisD))*:

  Refactor `LIKE ANY` and support  `ALL | SOME` quantifiers (#5493)


### :sparkles: New Features
- [`8cdd9e8`](https://github.com/tobymao/sqlglot/commit/8cdd9e8715b4cf67c200c723940743ed69bbfd80) - **mysql**: Parse UNIQUE INDEX constraint similar to UNIQUE KEY *(PR [#5489](https://github.com/tobymao/sqlglot/pull/5489) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5479](https://github.com/tobymao/sqlglot/issues/5479) opened by [@nathanchapman](https://github.com/nathanchapman)*
- [`787d167`](https://github.com/tobymao/sqlglot/commit/787d167d694b557d6e43ed391f59847a888fa572) - **exasol**: add support for REGEXP_SUBSTR  in exasol dialect *(PR [#5487](https://github.com/tobymao/sqlglot/pull/5487) by [@nnamdi16](https://github.com/nnamdi16))*
- [`0963f60`](https://github.com/tobymao/sqlglot/commit/0963f60987c267c64f2fcfbde469b8b28911a14b) - **singlestore**: Fixed time formatting *(PR [#5476](https://github.com/tobymao/sqlglot/pull/5476) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`488d2e4`](https://github.com/tobymao/sqlglot/commit/488d2e4bf9d4eb148356d1fd6c2360bbf77f283c) - **singlestore**: Added RESERVED_KEYWORDS *(PR [#5497](https://github.com/tobymao/sqlglot/pull/5497) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*
- [`fad9992`](https://github.com/tobymao/sqlglot/commit/fad9992a00478a964552f72802b95ca3918c4377) - **exasol**: Add support for TRUNC, TRUNCATE and DATE_TRUNC function… *(PR [#5490](https://github.com/tobymao/sqlglot/pull/5490) by [@nnamdi16](https://github.com/nnamdi16))*
- [`ad78db6`](https://github.com/tobymao/sqlglot/commit/ad78db6c9002a5bf9188d66f0080dfefd070f77b) - Refactor `LIKE ANY` and support  `ALL | SOME` quantifiers *(PR [#5493](https://github.com/tobymao/sqlglot/pull/5493) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5484](https://github.com/tobymao/sqlglot/issues/5484) opened by [@mazum21](https://github.com/mazum21)*
- [`a7a6f16`](https://github.com/tobymao/sqlglot/commit/a7a6f167d30ac19383ad15931c26751c66a61976) - **singlestore**: Added Tokenizer *(PR [#5492](https://github.com/tobymao/sqlglot/pull/5492) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*

### :bug: Bug Fixes
- [`3982653`](https://github.com/tobymao/sqlglot/commit/3982653e62a42ca1be2bdd8722119e27bd1ba680) - Do not consume BUCKET/TRUNCATE as partitioning keywords *(PR [#5488](https://github.com/tobymao/sqlglot/pull/5488) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5485](https://github.com/tobymao/sqlglot/issues/5485) opened by [@chenkovsky](https://github.com/chenkovsky)*
- [`002286e`](https://github.com/tobymao/sqlglot/commit/002286ee05a608e303a2238a9a74ab963709b5da) - remove AM/PM entries from postgres, oracle `TIME_MAPPING` *(PR [#5491](https://github.com/tobymao/sqlglot/pull/5491) by [@georgesittas](https://github.com/georgesittas))*
- [`74f278a`](https://github.com/tobymao/sqlglot/commit/74f278a226058e196270042e2a9664b9acded28a) - **optimizer**: Fix SEMI/ANTI join handling in optimizer rules *(PR [#5498](https://github.com/tobymao/sqlglot/pull/5498) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5481](https://github.com/tobymao/sqlglot/issues/5481) opened by [@themattmorris](https://github.com/themattmorris)*
- [`42633fb`](https://github.com/tobymao/sqlglot/commit/42633fb49b3c04eeea42e061e33ee08e61960cb4) - dont print (A)SYMMETRIC keyword in BETWEEN for postgres subclasses *(PR [#5503](https://github.com/tobymao/sqlglot/pull/5503) by [@georgesittas](https://github.com/georgesittas))*

### :wrench: Chores
- [`18b7d0f`](https://github.com/tobymao/sqlglot/commit/18b7d0fe19708d88b224770d844a8f6a74fe2aa7) - fix deprecated 'license' specification format *(PR [#5494](https://github.com/tobymao/sqlglot/pull/5494) by [@loonies](https://github.com/loonies))*


## [v27.4.1] - 2025-07-27
### :bug: Bug Fixes
- [`ba2b3e2`](https://github.com/tobymao/sqlglot/commit/ba2b3e21ca5454402808b68697ea4eb62963d341) - **bigquery**: make exp.Array type inference more robust *(PR [#5483](https://github.com/tobymao/sqlglot/pull/5483) by [@georgesittas](https://github.com/georgesittas))*


## [v27.4.0] - 2025-07-25
### :boom: BREAKING CHANGES
- due to [`4f348bd`](https://github.com/tobymao/sqlglot/commit/4f348bddda21b18841fd2d728fe486e95cdaa549) - store Query schemas in meta dict instead of type attr *(PR [#5480](https://github.com/tobymao/sqlglot/pull/5480) by [@georgesittas](https://github.com/georgesittas))*:

  store Query schemas in meta dict instead of type attr (#5480)


### :sparkles: New Features
- [`7961ece`](https://github.com/tobymao/sqlglot/commit/7961ece058f3771364aad5beedba9484e3a2e27c) - **exasol**: Add support for HASH_SHA1 function *(PR [#5468](https://github.com/tobymao/sqlglot/pull/5468) by [@nnamdi16](https://github.com/nnamdi16))*
- [`406815d`](https://github.com/tobymao/sqlglot/commit/406815de21f0fdc9874ff46155d4ee0274aa6337) - **exasol**: support HASH_SHA1 *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`e6f4fc9`](https://github.com/tobymao/sqlglot/commit/e6f4fc9c6d59d96777b2a2ec5dcc360e53639f8d) - **sqlite**: support ATTACH/DETACH DATABASE *(PR [#5469](https://github.com/tobymao/sqlglot/pull/5469) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *addresses issue [#5459](https://github.com/tobymao/sqlglot/issues/5459) opened by [@mariofox](https://github.com/mariofox)*
- [`8aa3498`](https://github.com/tobymao/sqlglot/commit/8aa349890673dccdd4daa0aea6ca5fcb9fdaf46f) - **hive, spark**: Add support for LOCATION in ADD PARTITION *(PR [#5472](https://github.com/tobymao/sqlglot/pull/5472) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5457](https://github.com/tobymao/sqlglot/issues/5457) opened by [@tsamaras](https://github.com/tsamaras)*
- [`44adfc0`](https://github.com/tobymao/sqlglot/commit/44adfc0e74da9d1b05a5a8a67b81fb7c67634c70) - **exasol**: add HASH_MD5 functionality to exasol dialect *(PR [#5473](https://github.com/tobymao/sqlglot/pull/5473) by [@nnamdi16](https://github.com/nnamdi16))*
- [`05e1c4d`](https://github.com/tobymao/sqlglot/commit/05e1c4dbf795915448173a894a89a33b289a3b5b) - **snowflake**: Transpile BQ's `STRUCT` dot access *(PR [#5471](https://github.com/tobymao/sqlglot/pull/5471) by [@VaggelisD](https://github.com/VaggelisD))*
- [`3c5ecdf`](https://github.com/tobymao/sqlglot/commit/3c5ecdf7f27629c01f0f3402e64a9dedf0583851) - **exasol**: Add HASHTYPE_MD5 functions to Exasol dialect *(PR [#5474](https://github.com/tobymao/sqlglot/pull/5474) by [@nnamdi16](https://github.com/nnamdi16))*
- [`1d640d2`](https://github.com/tobymao/sqlglot/commit/1d640d2278288b9a39a65b2532a13bc17e06c4e8) - **exasol**: add support for HASH_SHA256 and HASH_SHA512 hashing *(PR [#5475](https://github.com/tobymao/sqlglot/pull/5475) by [@nnamdi16](https://github.com/nnamdi16))*

### :bug: Bug Fixes
- [`e1819d6`](https://github.com/tobymao/sqlglot/commit/e1819d6451fec0eb3a1f77c90fd8d5c5b0d89889) - only strip kind from joins when it is inner|outer *(PR [#5477](https://github.com/tobymao/sqlglot/pull/5477) by [@themattmorris](https://github.com/themattmorris))*
  - :arrow_lower_right: *fixes issue [#5470](https://github.com/tobymao/sqlglot/issues/5470) opened by [@themattmorris](https://github.com/themattmorris)*
- [`4f348bd`](https://github.com/tobymao/sqlglot/commit/4f348bddda21b18841fd2d728fe486e95cdaa549) - **bigquery**: store Query schemas in meta dict instead of type attr *(PR [#5480](https://github.com/tobymao/sqlglot/pull/5480) by [@georgesittas](https://github.com/georgesittas))*


## [v27.3.1] - 2025-07-24
### :boom: BREAKING CHANGES
- due to [`48703c4`](https://github.com/tobymao/sqlglot/commit/48703c4fadd9f24de151a63d1bfa74f4b8e71133) - temporarily move VARCHAR length inference logic to Fabric *(commit by [@georgesittas](https://github.com/georgesittas))*:

  temporarily move VARCHAR length inference logic to Fabric


### :sparkles: New Features
- [`4cc321c`](https://github.com/tobymao/sqlglot/commit/4cc321cc1995d538ab0c48a7a0a473c31e76ddff) - **singlestore**: Added initial implementation of SingleStore dialect *(PR [#5447](https://github.com/tobymao/sqlglot/pull/5447) by [@AdalbertMemSQL](https://github.com/AdalbertMemSQL))*

### :wrench: Chores
- [`48703c4`](https://github.com/tobymao/sqlglot/commit/48703c4fadd9f24de151a63d1bfa74f4b8e71133) - **tsql**: temporarily move VARCHAR length inference logic to Fabric *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.3.0] - 2025-07-24
### :boom: BREAKING CHANGES
- due to [`d7ccb48`](https://github.com/tobymao/sqlglot/commit/d7ccb48e542c49258e31cc4df45f49beebc2e238) - week/quarter support *(PR [#5374](https://github.com/tobymao/sqlglot/pull/5374) by [@eakmanrq](https://github.com/eakmanrq))*:

  week/quarter support (#5374)

- due to [`b368fba`](https://github.com/tobymao/sqlglot/commit/b368fba59b606e038d445b2ca2d8436e115af3d6) - parse and annotate type for ASCII *(PR [#5377](https://github.com/tobymao/sqlglot/pull/5377) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for ASCII (#5377)

- due to [`7f19b31`](https://github.com/tobymao/sqlglot/commit/7f19b31ebd7981e53a8f8ba343b4f3222fe160c7) - annotate type for UNICODE *(PR [#5381](https://github.com/tobymao/sqlglot/pull/5381) by [@geooo109](https://github.com/geooo109))*:

  annotate type for UNICODE (#5381)

- due to [`9e8d3ab`](https://github.com/tobymao/sqlglot/commit/9e8d3abedcffb1c267ed0e6a8332af3b52105d41) - Preserve struct-column parentheses for RisingWave dialect *(PR [#5376](https://github.com/tobymao/sqlglot/pull/5376) by [@MisterWheatley](https://github.com/MisterWheatley))*:

  Added dialect as argument to `simplify_parens` function  
  * style: Ran formatter and tests. Fixed type annotation for simplify_parens  
  * Fix: Make dialect in `simplify_parens` optional.  
  Co-authored-by: Jo <46752250+georgesittas@users.noreply.github.com>  
  * Fix(optimizer): Tweaks to make simple non-nested star expand pass unit test for RW  
  * Fix(optimizer): Added test for deep nested unpacking for BigQuery and RisingWave  
  * style: Ran formatting check  
  * fix: Remove unuses function from RisingWave dialect test  
  * docs: updated docstring of new _expand_struct_stars_risingwave internal function  
  * fix: apply suggestions from code review 2  
  Co-authored-by: Jo <46752250+georgesittas@users.noreply.github.com>  
  * fix(optimizer,risingwave): Ensure that struct star-expansion to the correct level for RisingWave  
  Updated logic for expanding (struct_col).* expressions in RisingWave to correctly handle the level of nesting.  
  Moved struct expansion tests to tests/fixtures/qualify_columns.sql on behest of maintainers.  
  ---------

- due to [`3223e63`](https://github.com/tobymao/sqlglot/commit/3223e6394fdd3f8e48c68bbb940b661ff8e76fd8) - cast datetimeoffset to datetime2 *(PR [#5385](https://github.com/tobymao/sqlglot/pull/5385) by [@mattiasthalen](https://github.com/mattiasthalen))*:

  cast datetimeoffset to datetime2 (#5385)

- due to [`06cea31`](https://github.com/tobymao/sqlglot/commit/06cea310bd9fd3a9a9fa0ba008596e878a430df8) - support KEY related locks *(PR [#5397](https://github.com/tobymao/sqlglot/pull/5397) by [@geooo109](https://github.com/geooo109))*:

  support KEY related locks (#5397)

- due to [`1014a67`](https://github.com/tobymao/sqlglot/commit/1014a6759b0917ef1bf5af0dbbdcca72214a8dea) - remove redundant todate in dayofweek closes [#5398](https://github.com/tobymao/sqlglot/pull/5398) *(PR [#5399](https://github.com/tobymao/sqlglot/pull/5399) by [@tobymao](https://github.com/tobymao))*:

  remove redundant todate in dayofweek closes #5398 (#5399)

- due to [`b2631ae`](https://github.com/tobymao/sqlglot/commit/b2631aec8d1bdb08decb201b6bd2ba5d927bb121) - annotate type for bigquery BIT_AND, BIT_OR, BIT_XOR, BIT_COUNT *(PR [#5405](https://github.com/tobymao/sqlglot/pull/5405) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery BIT_AND, BIT_OR, BIT_XOR, BIT_COUNT (#5405)

- due to [`5835b8d`](https://github.com/tobymao/sqlglot/commit/5835b8d6c7fe77d9645691bb88021af137ed0bac) - make bracket parsing aware of duckdb MAP func *(PR [#5423](https://github.com/tobymao/sqlglot/pull/5423) by [@geooo109](https://github.com/geooo109))*:

  make bracket parsing aware of duckdb MAP func (#5423)

- due to [`489dc5c`](https://github.com/tobymao/sqlglot/commit/489dc5c2f7506e0fe4de549384dd0f816e9fd12f) - parse and annotate type support for JSON_ARRAY *(PR [#5424](https://github.com/tobymao/sqlglot/pull/5424) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type support for JSON_ARRAY (#5424)

- due to [`0ed518c`](https://github.com/tobymao/sqlglot/commit/0ed518c67042002ee0af91bee0b9e7093c85f926) - annotate type for bigquery JSON_VALUE *(PR [#5427](https://github.com/tobymao/sqlglot/pull/5427) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery JSON_VALUE (#5427)

- due to [`6091617`](https://github.com/tobymao/sqlglot/commit/6091617067c263e3e834e579b37aa1c601b1ddc7) - annotate type for bigquery JSON_VALUE_ARRAY *(PR [#5428](https://github.com/tobymao/sqlglot/pull/5428) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery JSON_VALUE_ARRAY (#5428)

- due to [`631c851`](https://github.com/tobymao/sqlglot/commit/631c851cbbfbf55cb66a79c2549aeeb443fcab83) - parse and annotate type support for bigquery JSON_TYPE *(PR [#5430](https://github.com/tobymao/sqlglot/pull/5430) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type support for bigquery JSON_TYPE (#5430)

- due to [`6268f6f`](https://github.com/tobymao/sqlglot/commit/6268f6f39dda1ca5cf2ad0403e219b49c5c9593a) - add default precision to CHAR/VARCHAR create expressions *(PR [#5434](https://github.com/tobymao/sqlglot/pull/5434) by [@mattiasthalen](https://github.com/mattiasthalen))*:

  add default precision to CHAR/VARCHAR create expressions (#5434)

- due to [`8467bad`](https://github.com/tobymao/sqlglot/commit/8467bad405e27c842c989e71588adc39cf2383fc) - add parsing/generating for BigQuery `DECLARE` *(PR [#5442](https://github.com/tobymao/sqlglot/pull/5442) by [@plaflamme](https://github.com/plaflamme))*:

  add parsing/generating for BigQuery `DECLARE` (#5442)

- due to [`79c5c30`](https://github.com/tobymao/sqlglot/commit/79c5c30f3802c6959376b3b0f3c4d055a30b6b43) - transpile STRING_AGG *(PR [#5449](https://github.com/tobymao/sqlglot/pull/5449) by [@geooo109](https://github.com/geooo109))*:

  transpile STRING_AGG (#5449)

- due to [`190f8ab`](https://github.com/tobymao/sqlglot/commit/190f8abe3d3bbda09e2f945287398d2aa9d6a863) - improve BigQuery `UNNEST` transpilation *(PR [#5451](https://github.com/tobymao/sqlglot/pull/5451) by [@georgesittas](https://github.com/georgesittas))*:

  improve BigQuery `UNNEST` transpilation (#5451)

- due to [`3590e75`](https://github.com/tobymao/sqlglot/commit/3590e75c1df2d572e2fea664893dba5565a17e05) - support ? placeholder *(PR [#5455](https://github.com/tobymao/sqlglot/pull/5455) by [@geooo109](https://github.com/geooo109))*:

  support ? placeholder (#5455)

- due to [`cdbf595`](https://github.com/tobymao/sqlglot/commit/cdbf5953171c8d4c8e4a24262f278c6f7d74e057) - Wrap GET_PATH value with PARSE_JSON preemptively *(PR [#5458](https://github.com/tobymao/sqlglot/pull/5458) by [@VaggelisD](https://github.com/VaggelisD))*:

  Wrap GET_PATH value with PARSE_JSON preemptively (#5458)

- due to [`bee82f3`](https://github.com/tobymao/sqlglot/commit/bee82f37ac537780495ff408738d88871208517a) - Remove `UNKNOWN` type from `TRY_CAST` *(PR [#5466](https://github.com/tobymao/sqlglot/pull/5466) by [@VaggelisD](https://github.com/VaggelisD))*:

  Remove `UNKNOWN` type from `TRY_CAST` (#5466)


### :sparkles: New Features
- [`b368fba`](https://github.com/tobymao/sqlglot/commit/b368fba59b606e038d445b2ca2d8436e115af3d6) - **optimizer**: parse and annotate type for ASCII *(PR [#5377](https://github.com/tobymao/sqlglot/pull/5377) by [@geooo109](https://github.com/geooo109))*
- [`7f19b31`](https://github.com/tobymao/sqlglot/commit/7f19b31ebd7981e53a8f8ba343b4f3222fe160c7) - **optimizer**: annotate type for UNICODE *(PR [#5381](https://github.com/tobymao/sqlglot/pull/5381) by [@geooo109](https://github.com/geooo109))*
- [`f035bf0`](https://github.com/tobymao/sqlglot/commit/f035bf0eb582aa07d4ad79e0ed1958ce0d091ad9) - **dremio**: Add TIME_MAPPING for Dremio dialect *(PR [#5378](https://github.com/tobymao/sqlglot/pull/5378) by [@mateuszpoleski](https://github.com/mateuszpoleski))*
- [`31cfd0f`](https://github.com/tobymao/sqlglot/commit/31cfd0fc3309bc1080b7a2ba8d40b2aba5c098a3) - **exasol**: add to_date and refactored to_char functions with respect to time mapping *(PR [#5379](https://github.com/tobymao/sqlglot/pull/5379) by [@nnamdi16](https://github.com/nnamdi16))*
- [`bd3776e`](https://github.com/tobymao/sqlglot/commit/bd3776eaa26d40b44c4cebc2f3838b4055653548) - **doris**: add PROPERTIES_LOCATION mapping for Doris dialect *(PR [#5391](https://github.com/tobymao/sqlglot/pull/5391) by [@xinge-ji](https://github.com/xinge-ji))*
- [`7eaa67a`](https://github.com/tobymao/sqlglot/commit/7eaa67acb216501046c739f56839418b84f244c0) - **doris**: properly supported PROPERTIES and UNIQUE KEY table prop *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`1e78163`](https://github.com/tobymao/sqlglot/commit/1e78163b829e910e7960c79e7ab118c07d1ecdc3) - **duckdb**: support column access via index *(PR [#5395](https://github.com/tobymao/sqlglot/pull/5395) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *addresses issue [#5392](https://github.com/tobymao/sqlglot/issues/5392) opened by [@tekumara](https://github.com/tekumara)*
- [`1014a67`](https://github.com/tobymao/sqlglot/commit/1014a6759b0917ef1bf5af0dbbdcca72214a8dea) - remove redundant todate in dayofweek closes [#5398](https://github.com/tobymao/sqlglot/pull/5398) *(PR [#5399](https://github.com/tobymao/sqlglot/pull/5399) by [@tobymao](https://github.com/tobymao))*
- [`be52f78`](https://github.com/tobymao/sqlglot/commit/be52f7866b03e436d103d9201d1a44c6632c643a) - **exasol**: add support for CONVERT_TZ function *(PR [#5401](https://github.com/tobymao/sqlglot/pull/5401) by [@nnamdi16](https://github.com/nnamdi16))*
- [`d637161`](https://github.com/tobymao/sqlglot/commit/d637161406faf623418f112162268bedb422213b) - **exasol**: add mapping to TIME_TO_STR in exasol dialect *(PR [#5403](https://github.com/tobymao/sqlglot/pull/5403) by [@nnamdi16](https://github.com/nnamdi16))*
- [`b2631ae`](https://github.com/tobymao/sqlglot/commit/b2631aec8d1bdb08decb201b6bd2ba5d927bb121) - **optimizer**: annotate type for bigquery BIT_AND, BIT_OR, BIT_XOR, BIT_COUNT *(PR [#5405](https://github.com/tobymao/sqlglot/pull/5405) by [@geooo109](https://github.com/geooo109))*
- [`b81ae62`](https://github.com/tobymao/sqlglot/commit/b81ae629bfb27760ddd832402a86dabe4e65072f) - **exasol**: map STR_TO_TIME to TO_DATE and *(PR [#5407](https://github.com/tobymao/sqlglot/pull/5407) by [@nnamdi16](https://github.com/nnamdi16))*
- [`c2fb9ab`](https://github.com/tobymao/sqlglot/commit/c2fb9abeb2f077f00278e46efd9573a3806cd218) - add `DateStrToTime` *(PR [#5409](https://github.com/tobymao/sqlglot/pull/5409) by [@betodealmeida](https://github.com/betodealmeida))*
- [`a95993a`](https://github.com/tobymao/sqlglot/commit/a95993ae4e8aa99969db059a534819a4f0b62b96) - **snowflake**: improve transpilation of queries with UNNEST sources *(PR [#5408](https://github.com/tobymao/sqlglot/pull/5408) by [@georgesittas](https://github.com/georgesittas))*
- [`7b69f54`](https://github.com/tobymao/sqlglot/commit/7b69f545bbcfeb1e1f2f3b7e0b9757cfd675e4a5) - **snowflake**: Support SEMANTIC_VIEW *(PR [#5414](https://github.com/tobymao/sqlglot/pull/5414) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5406](https://github.com/tobymao/sqlglot/issues/5406) opened by [@jkillian](https://github.com/jkillian)*
- [`7dba6f6`](https://github.com/tobymao/sqlglot/commit/7dba6f64d9a7945bbdef1b6e014d802014567a1e) - **exasol**: map AT TIME ZONE to CONVERT_TZ *(PR [#5416](https://github.com/tobymao/sqlglot/pull/5416) by [@nnamdi16](https://github.com/nnamdi16))*
- [`25f2c1b`](https://github.com/tobymao/sqlglot/commit/25f2c1bb18f9d073b128150566cb27c0c2da0865) - **postgres**: query placeholders *(PR [#5415](https://github.com/tobymao/sqlglot/pull/5415) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *addresses issue [#5412](https://github.com/tobymao/sqlglot/issues/5412) opened by [@aersam](https://github.com/aersam)*
- [`c309c87`](https://github.com/tobymao/sqlglot/commit/c309c8763a90bf0bce02e21f4088b38d85556cce) - **doris**: support range partitioning *(PR [#5402](https://github.com/tobymao/sqlglot/pull/5402) by [@xinge-ji](https://github.com/xinge-ji))*
- [`394d3a8`](https://github.com/tobymao/sqlglot/commit/394d3a81ef41d3052c0b0d6e48180c344b7db143) - **dremio**: Add support for DATE_ADD and DATE_SUB *(PR [#5411](https://github.com/tobymao/sqlglot/pull/5411) by [@mateuszpoleski](https://github.com/mateuszpoleski))*
- [`9cfac4f`](https://github.com/tobymao/sqlglot/commit/9cfac4fb04ce1fd038c3e8cbdb755cc24c052497) - **doris**: enhance partitioning support *(PR [#5421](https://github.com/tobymao/sqlglot/pull/5421) by [@xinge-ji](https://github.com/xinge-ji))*
- [`a018bea`](https://github.com/tobymao/sqlglot/commit/a018bea159261a3ad4ac082f29e30fe1153995b3) - **exasol**: mapped exp.CurrentUser to exasol CURRENT_USER *(PR [#5422](https://github.com/tobymao/sqlglot/pull/5422) by [@nnamdi16](https://github.com/nnamdi16))*
- [`489dc5c`](https://github.com/tobymao/sqlglot/commit/489dc5c2f7506e0fe4de549384dd0f816e9fd12f) - **optimizer**: parse and annotate type support for JSON_ARRAY *(PR [#5424](https://github.com/tobymao/sqlglot/pull/5424) by [@geooo109](https://github.com/geooo109))*
- [`0ed518c`](https://github.com/tobymao/sqlglot/commit/0ed518c67042002ee0af91bee0b9e7093c85f926) - **optimizer**: annotate type for bigquery JSON_VALUE *(PR [#5427](https://github.com/tobymao/sqlglot/pull/5427) by [@geooo109](https://github.com/geooo109))*
- [`6091617`](https://github.com/tobymao/sqlglot/commit/6091617067c263e3e834e579b37aa1c601b1ddc7) - **optimizer**: annotate type for bigquery JSON_VALUE_ARRAY *(PR [#5428](https://github.com/tobymao/sqlglot/pull/5428) by [@geooo109](https://github.com/geooo109))*
- [`631c851`](https://github.com/tobymao/sqlglot/commit/631c851cbbfbf55cb66a79c2549aeeb443fcab83) - **optimizer**: parse and annotate type support for bigquery JSON_TYPE *(PR [#5430](https://github.com/tobymao/sqlglot/pull/5430) by [@geooo109](https://github.com/geooo109))*
- [`732548f`](https://github.com/tobymao/sqlglot/commit/732548ff7a6792cfa38dba8b3b8a73a302532ae7) - **postgresql**: add support for table creation DDL that contains a primary key alongside the INCLUDE keyword *(PR [#5425](https://github.com/tobymao/sqlglot/pull/5425) by [@amosbiras](https://github.com/amosbiras))*
- [`9f887f1`](https://github.com/tobymao/sqlglot/commit/9f887f14d20cd493b4a0a4489649fc5b9f2ae7fd) - Add support for BETWEEN flags *(PR [#5435](https://github.com/tobymao/sqlglot/pull/5435) by [@mateuszpoleski](https://github.com/mateuszpoleski))*
- [`edef00a`](https://github.com/tobymao/sqlglot/commit/edef00af9b703ace76871b989d9b94d9c30dcafd) - **duckdb**: Add reset command for duckdb *(PR [#5448](https://github.com/tobymao/sqlglot/pull/5448) by [@themisvaltinos](https://github.com/themisvaltinos))*
- [`6268f6f`](https://github.com/tobymao/sqlglot/commit/6268f6f39dda1ca5cf2ad0403e219b49c5c9593a) - **tsql**: add default precision to CHAR/VARCHAR create expressions *(PR [#5434](https://github.com/tobymao/sqlglot/pull/5434) by [@mattiasthalen](https://github.com/mattiasthalen))*
- [`bbf26e9`](https://github.com/tobymao/sqlglot/commit/bbf26e9610bee341d4e6df12a031b05ff6b57861) - **mysql**: Add support for SELECT DISTINCTROW *(PR [#5446](https://github.com/tobymao/sqlglot/pull/5446) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5445](https://github.com/tobymao/sqlglot/issues/5445) opened by [@chenweida123](https://github.com/chenweida123)*
- [`8467bad`](https://github.com/tobymao/sqlglot/commit/8467bad405e27c842c989e71588adc39cf2383fc) - add parsing/generating for BigQuery `DECLARE` *(PR [#5442](https://github.com/tobymao/sqlglot/pull/5442) by [@plaflamme](https://github.com/plaflamme))*
- [`190f8ab`](https://github.com/tobymao/sqlglot/commit/190f8abe3d3bbda09e2f945287398d2aa9d6a863) - improve BigQuery `UNNEST` transpilation *(PR [#5451](https://github.com/tobymao/sqlglot/pull/5451) by [@georgesittas](https://github.com/georgesittas))*
- [`dbef44d`](https://github.com/tobymao/sqlglot/commit/dbef44db64d8c80e5000c55c981e0de89054e6eb) - **exasol**: mapped STRPOS to INSTR in exasol dialect *(PR [#5454](https://github.com/tobymao/sqlglot/pull/5454) by [@nnamdi16](https://github.com/nnamdi16))*
- [`010c34c`](https://github.com/tobymao/sqlglot/commit/010c34c1803df0223cf65263f2fb03b404e5141c) - support `DESC SEMANTIC VIEW` *(PR [#5452](https://github.com/tobymao/sqlglot/pull/5452) by [@betodealmeida](https://github.com/betodealmeida))*
- [`9795021`](https://github.com/tobymao/sqlglot/commit/9795021ff35bae17ff5a9ba7c5cdb46a75aab63b) - **exasol**: transformed column comments *(PR [#5464](https://github.com/tobymao/sqlglot/pull/5464) by [@nnamdi16](https://github.com/nnamdi16))*
- [`4c5b687`](https://github.com/tobymao/sqlglot/commit/4c5b68746dcede62ca9d1217bd428f50a1731e2c) - **snowflake**: transpile IS <boolean> (IS can only be used with NULL) *(PR [#5467](https://github.com/tobymao/sqlglot/pull/5467) by [@georgesittas](https://github.com/georgesittas))*

### :bug: Bug Fixes
- [`d7ccb48`](https://github.com/tobymao/sqlglot/commit/d7ccb48e542c49258e31cc4df45f49beebc2e238) - **duckdb**: week/quarter support *(PR [#5374](https://github.com/tobymao/sqlglot/pull/5374) by [@eakmanrq](https://github.com/eakmanrq))*
- [`252469d`](https://github.com/tobymao/sqlglot/commit/252469d2d0ed221dbb2fde86043506ad15dbe7e5) - **snowflake**: transpile bigquery CURRENT_DATE with timezone *(PR [#5387](https://github.com/tobymao/sqlglot/pull/5387) by [@geooo109](https://github.com/geooo109))*
- [`7511853`](https://github.com/tobymao/sqlglot/commit/751185325caf838107ecb4e8f35ad77bf3cc9bf2) - **postgres**: add XML type *(PR [#5396](https://github.com/tobymao/sqlglot/pull/5396) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5393](https://github.com/tobymao/sqlglot/issues/5393) opened by [@aersam](https://github.com/aersam)*
- [`9e8d3ab`](https://github.com/tobymao/sqlglot/commit/9e8d3abedcffb1c267ed0e6a8332af3b52105d41) - **optimizer**: Preserve struct-column parentheses for RisingWave dialect *(PR [#5376](https://github.com/tobymao/sqlglot/pull/5376) by [@MisterWheatley](https://github.com/MisterWheatley))*
- [`3223e63`](https://github.com/tobymao/sqlglot/commit/3223e6394fdd3f8e48c68bbb940b661ff8e76fd8) - **fabric**: cast datetimeoffset to datetime2 *(PR [#5385](https://github.com/tobymao/sqlglot/pull/5385) by [@mattiasthalen](https://github.com/mattiasthalen))*
- [`12b49dd`](https://github.com/tobymao/sqlglot/commit/12b49dd800951a48ea8bc0f01d7c35340236f559) - remove equal sign from CREATE TABLE comment (doris, starrocks) *(PR [#5390](https://github.com/tobymao/sqlglot/pull/5390) by [@xinge-ji](https://github.com/xinge-ji))*
- [`06cea31`](https://github.com/tobymao/sqlglot/commit/06cea310bd9fd3a9a9fa0ba008596e878a430df8) - **postgres**: support KEY related locks *(PR [#5397](https://github.com/tobymao/sqlglot/pull/5397) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5394](https://github.com/tobymao/sqlglot/issues/5394) opened by [@aurimasandriusaitis](https://github.com/aurimasandriusaitis)*
- [`92d93a6`](https://github.com/tobymao/sqlglot/commit/92d93a624b41df8bb4628c1f2d0cbb8c7844c927) - **parser**: do not consume modifier prefixes in group parser, fixes [#5400](https://github.com/tobymao/sqlglot/pull/5400) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`ba0c801`](https://github.com/tobymao/sqlglot/commit/ba0c801e3dab8e08d4b5f7f73247ec6cfdc667e5) - **tsql**: change READ_ONLY to READONLY *(PR [#5410](https://github.com/tobymao/sqlglot/pull/5410) by [@CrispinStichartFNSB](https://github.com/CrispinStichartFNSB))*
- [`63da895`](https://github.com/tobymao/sqlglot/commit/63da89563fddc13ee7aec06ee36d8a0f74227ee1) - **risingwave**: Fix RisingWave dialect SQL for MAP datatype declaration *(PR [#5418](https://github.com/tobymao/sqlglot/pull/5418) by [@MisterWheatley](https://github.com/MisterWheatley))*
- [`edacae1`](https://github.com/tobymao/sqlglot/commit/edacae183fe26ea25bffe1bccd335bf57ed34ecb) - **snowflake**: transpile bigquery GENERATE_DATE_ARRAY with column access *(PR [#5388](https://github.com/tobymao/sqlglot/pull/5388) by [@geooo109](https://github.com/geooo109))*
- [`5835b8d`](https://github.com/tobymao/sqlglot/commit/5835b8d6c7fe77d9645691bb88021af137ed0bac) - **duckdb**: make bracket parsing aware of duckdb MAP func *(PR [#5423](https://github.com/tobymao/sqlglot/pull/5423) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5417](https://github.com/tobymao/sqlglot/issues/5417) opened by [@MisterWheatley](https://github.com/MisterWheatley)*
- [`5c59816`](https://github.com/tobymao/sqlglot/commit/5c59816f5572f8adb1de9c97f0007d19091910ec) - **snowflake**: ALTER TABLE ADD with multiple columns *(PR [#5431](https://github.com/tobymao/sqlglot/pull/5431) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5426](https://github.com/tobymao/sqlglot/issues/5426) opened by [@ca0904](https://github.com/ca0904)*
- [`9f860a0`](https://github.com/tobymao/sqlglot/commit/9f860a0ce47f74930efa1afcd86fe7668a40c239) - **snowflake**: ALTER TABLE ADD with IF NOT EXISTS *(PR [#5438](https://github.com/tobymao/sqlglot/pull/5438) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5432](https://github.com/tobymao/sqlglot/issues/5432) opened by [@ca0904](https://github.com/ca0904)*
- [`d7b3a26`](https://github.com/tobymao/sqlglot/commit/d7b3a261647e4ce675c84bbf72a33d320099fc01) - **postgres**: transpile duckdb LIST_HAS_ANY and LIST_CONTAINS *(PR [#5440](https://github.com/tobymao/sqlglot/pull/5440) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5437](https://github.com/tobymao/sqlglot/issues/5437) opened by [@aersam](https://github.com/aersam)*
- [`79c5c30`](https://github.com/tobymao/sqlglot/commit/79c5c30f3802c6959376b3b0f3c4d055a30b6b43) - **spark**: transpile STRING_AGG *(PR [#5449](https://github.com/tobymao/sqlglot/pull/5449) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5441](https://github.com/tobymao/sqlglot/issues/5441) opened by [@dxaen](https://github.com/dxaen)*
- [`3590e75`](https://github.com/tobymao/sqlglot/commit/3590e75c1df2d572e2fea664893dba5565a17e05) - **postgres**: support ? placeholder *(PR [#5455](https://github.com/tobymao/sqlglot/pull/5455) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5453](https://github.com/tobymao/sqlglot/issues/5453) opened by [@jkillian](https://github.com/jkillian)*
- [`cdbf595`](https://github.com/tobymao/sqlglot/commit/cdbf5953171c8d4c8e4a24262f278c6f7d74e057) - **snowflake**: Wrap GET_PATH value with PARSE_JSON preemptively *(PR [#5458](https://github.com/tobymao/sqlglot/pull/5458) by [@VaggelisD](https://github.com/VaggelisD))*
- [`8f16f52`](https://github.com/tobymao/sqlglot/commit/8f16f52859b66e3f8b30fff82f0c1679c7e37a25) - restore default `sql_names` for `DecodeCase` *(PR [#5465](https://github.com/tobymao/sqlglot/pull/5465) by [@georgesittas](https://github.com/georgesittas))*
- [`bee82f3`](https://github.com/tobymao/sqlglot/commit/bee82f37ac537780495ff408738d88871208517a) - **snowflake**: Remove `UNKNOWN` type from `TRY_CAST` *(PR [#5466](https://github.com/tobymao/sqlglot/pull/5466) by [@VaggelisD](https://github.com/VaggelisD))*

### :wrench: Chores
- [`71b1349`](https://github.com/tobymao/sqlglot/commit/71b1349a26d2b9839899900ef8fdfb1ebc3d68fd) - **postgres, hive**: use ASCII node instead of UNICODE node *(PR [#5380](https://github.com/tobymao/sqlglot/pull/5380) by [@geooo109](https://github.com/geooo109))*
- [`a5c2245`](https://github.com/tobymao/sqlglot/commit/a5c2245c3e30f5bc3f410edacf3a077ce99f4a80) - improve error msg for PIVOT with missing aggregation *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`59fd875`](https://github.com/tobymao/sqlglot/commit/59fd875cd4ee1c44f9ca20f701215ae64d669d60) - Refactor PRIMARY KEY ... INCLUDE handling *(PR [#5433](https://github.com/tobymao/sqlglot/pull/5433) by [@VaggelisD](https://github.com/VaggelisD))*
- [`e9bb3e8`](https://github.com/tobymao/sqlglot/commit/e9bb3e8ccb52c76ed77fc5e7d04cf75230b737fa) - Refactor DECLARE statement *(PR [#5450](https://github.com/tobymao/sqlglot/pull/5450) by [@VaggelisD](https://github.com/VaggelisD))*


## [v27.2.0] - 2025-07-22
### :boom: BREAKING CHANGES
- due to [`6268f6f`](https://github.com/tobymao/sqlglot/commit/6268f6f39dda1ca5cf2ad0403e219b49c5c9593a) - add default precision to CHAR/VARCHAR create expressions *(PR [#5434](https://github.com/tobymao/sqlglot/pull/5434) by [@mattiasthalen](https://github.com/mattiasthalen))*:

  add default precision to CHAR/VARCHAR create expressions (#5434)

- due to [`8467bad`](https://github.com/tobymao/sqlglot/commit/8467bad405e27c842c989e71588adc39cf2383fc) - add parsing/generating for BigQuery `DECLARE` *(PR [#5442](https://github.com/tobymao/sqlglot/pull/5442) by [@plaflamme](https://github.com/plaflamme))*:

  add parsing/generating for BigQuery `DECLARE` (#5442)

- due to [`79c5c30`](https://github.com/tobymao/sqlglot/commit/79c5c30f3802c6959376b3b0f3c4d055a30b6b43) - transpile STRING_AGG *(PR [#5449](https://github.com/tobymao/sqlglot/pull/5449) by [@geooo109](https://github.com/geooo109))*:

  transpile STRING_AGG (#5449)

- due to [`190f8ab`](https://github.com/tobymao/sqlglot/commit/190f8abe3d3bbda09e2f945287398d2aa9d6a863) - improve BigQuery `UNNEST` transpilation *(PR [#5451](https://github.com/tobymao/sqlglot/pull/5451) by [@georgesittas](https://github.com/georgesittas))*:

  improve BigQuery `UNNEST` transpilation (#5451)


### :sparkles: New Features
- [`732548f`](https://github.com/tobymao/sqlglot/commit/732548ff7a6792cfa38dba8b3b8a73a302532ae7) - **postgresql**: add support for table creation DDL that contains a primary key alongside the INCLUDE keyword *(PR [#5425](https://github.com/tobymao/sqlglot/pull/5425) by [@amosbiras](https://github.com/amosbiras))*
- [`9f887f1`](https://github.com/tobymao/sqlglot/commit/9f887f14d20cd493b4a0a4489649fc5b9f2ae7fd) - Add support for BETWEEN flags *(PR [#5435](https://github.com/tobymao/sqlglot/pull/5435) by [@mateuszpoleski](https://github.com/mateuszpoleski))*
- [`edef00a`](https://github.com/tobymao/sqlglot/commit/edef00af9b703ace76871b989d9b94d9c30dcafd) - **duckdb**: Add reset command for duckdb *(PR [#5448](https://github.com/tobymao/sqlglot/pull/5448) by [@themisvaltinos](https://github.com/themisvaltinos))*
- [`6268f6f`](https://github.com/tobymao/sqlglot/commit/6268f6f39dda1ca5cf2ad0403e219b49c5c9593a) - **tsql**: add default precision to CHAR/VARCHAR create expressions *(PR [#5434](https://github.com/tobymao/sqlglot/pull/5434) by [@mattiasthalen](https://github.com/mattiasthalen))*
- [`bbf26e9`](https://github.com/tobymao/sqlglot/commit/bbf26e9610bee341d4e6df12a031b05ff6b57861) - **mysql**: Add support for SELECT DISTINCTROW *(PR [#5446](https://github.com/tobymao/sqlglot/pull/5446) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5445](https://github.com/tobymao/sqlglot/issues/5445) opened by [@chenweida123](https://github.com/chenweida123)*
- [`8467bad`](https://github.com/tobymao/sqlglot/commit/8467bad405e27c842c989e71588adc39cf2383fc) - add parsing/generating for BigQuery `DECLARE` *(PR [#5442](https://github.com/tobymao/sqlglot/pull/5442) by [@plaflamme](https://github.com/plaflamme))*
- [`190f8ab`](https://github.com/tobymao/sqlglot/commit/190f8abe3d3bbda09e2f945287398d2aa9d6a863) - improve BigQuery `UNNEST` transpilation *(PR [#5451](https://github.com/tobymao/sqlglot/pull/5451) by [@georgesittas](https://github.com/georgesittas))*

### :bug: Bug Fixes
- [`9f860a0`](https://github.com/tobymao/sqlglot/commit/9f860a0ce47f74930efa1afcd86fe7668a40c239) - **snowflake**: ALTER TABLE ADD with IF NOT EXISTS *(PR [#5438](https://github.com/tobymao/sqlglot/pull/5438) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5432](https://github.com/tobymao/sqlglot/issues/5432) opened by [@ca0904](https://github.com/ca0904)*
- [`d7b3a26`](https://github.com/tobymao/sqlglot/commit/d7b3a261647e4ce675c84bbf72a33d320099fc01) - **postgres**: transpile duckdb LIST_HAS_ANY and LIST_CONTAINS *(PR [#5440](https://github.com/tobymao/sqlglot/pull/5440) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5437](https://github.com/tobymao/sqlglot/issues/5437) opened by [@aersam](https://github.com/aersam)*
- [`79c5c30`](https://github.com/tobymao/sqlglot/commit/79c5c30f3802c6959376b3b0f3c4d055a30b6b43) - **spark**: transpile STRING_AGG *(PR [#5449](https://github.com/tobymao/sqlglot/pull/5449) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5441](https://github.com/tobymao/sqlglot/issues/5441) opened by [@dxaen](https://github.com/dxaen)*

### :wrench: Chores
- [`59fd875`](https://github.com/tobymao/sqlglot/commit/59fd875cd4ee1c44f9ca20f701215ae64d669d60) - Refactor PRIMARY KEY ... INCLUDE handling *(PR [#5433](https://github.com/tobymao/sqlglot/pull/5433) by [@VaggelisD](https://github.com/VaggelisD))*
- [`e9bb3e8`](https://github.com/tobymao/sqlglot/commit/e9bb3e8ccb52c76ed77fc5e7d04cf75230b737fa) - Refactor DECLARE statement *(PR [#5450](https://github.com/tobymao/sqlglot/pull/5450) by [@VaggelisD](https://github.com/VaggelisD))*


## [v27.1.0] - 2025-07-18
### :boom: BREAKING CHANGES
- due to [`5724538`](https://github.com/tobymao/sqlglot/commit/5724538f278b2178114b88850251afd7c3db0dda) - ARRAY_CONCAT type annotation *(PR [#5293](https://github.com/tobymao/sqlglot/pull/5293) by [@geooo109](https://github.com/geooo109))*:

  ARRAY_CONCAT type annotation (#5293)

- due to [`c103b23`](https://github.com/tobymao/sqlglot/commit/c103b2304dca552ac8cf6733156db8b59d3614f3) - add support for `SUBSTRING_INDEX` *(PR [#5296](https://github.com/tobymao/sqlglot/pull/5296) by [@ankur334](https://github.com/ankur334))*:

  add support for `SUBSTRING_INDEX` (#5296)

- due to [`a7bd823`](https://github.com/tobymao/sqlglot/commit/a7bd8234e0dd02abfe6fa56287e7bda14a549e5a) - annotate type of ARRAY_TO_STRING *(PR [#5301](https://github.com/tobymao/sqlglot/pull/5301) by [@geooo109](https://github.com/geooo109))*:

  annotate type of ARRAY_TO_STRING (#5301)

- due to [`6b42353`](https://github.com/tobymao/sqlglot/commit/6b4235340a2e432015c27b2aeadbdcb930bfa6b0) - annotate type of ARRAY_FIRST, ARRAY_LAST *(PR [#5303](https://github.com/tobymao/sqlglot/pull/5303) by [@geooo109](https://github.com/geooo109))*:

  annotate type of ARRAY_FIRST, ARRAY_LAST (#5303)

- due to [`db9b61e`](https://github.com/tobymao/sqlglot/commit/db9b61e4ecaa0600418eb90f637fb8b06b08c399) - parse, annotate type for ARRAY_REVERSE *(PR [#5306](https://github.com/tobymao/sqlglot/pull/5306) by [@geooo109](https://github.com/geooo109))*:

  parse, annotate type for ARRAY_REVERSE (#5306)

- due to [`5612a6d`](https://github.com/tobymao/sqlglot/commit/5612a6da6dee3545f3600db1e5b87c9450952eba) - add support for SPACE *(PR [#5308](https://github.com/tobymao/sqlglot/pull/5308) by [@ankur334](https://github.com/ankur334))*:

  add support for SPACE (#5308)

- due to [`8a2f65d`](https://github.com/tobymao/sqlglot/commit/8a2f65d6b2b68ad5ba45a5aed5e56c4dc0fea6fc) - parse and annotate type for ARRAY_SLICE *(PR [#5312](https://github.com/tobymao/sqlglot/pull/5312) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for ARRAY_SLICE (#5312)

- due to [`8d118ea`](https://github.com/tobymao/sqlglot/commit/8d118ead9c15e7b2b4b51b7cf93cab94e61c2625) - route statements to hive/trino depending on their type *(PR [#5314](https://github.com/tobymao/sqlglot/pull/5314) by [@georgesittas](https://github.com/georgesittas))*:

  route statements to hive/trino depending on their type (#5314)

- due to [`d2f7c41`](https://github.com/tobymao/sqlglot/commit/d2f7c41f9f30f4cf0c74782be9be0cc6e75565f3) - add TypeOf / toTypeName support *(PR [#5315](https://github.com/tobymao/sqlglot/pull/5315) by [@ankur334](https://github.com/ankur334))*:

  add TypeOf / toTypeName support (#5315)

- due to [`5a0f589`](https://github.com/tobymao/sqlglot/commit/5a0f589a0fdb6743c3be2f98b74a34780f51332b) - distinguish STORED AS from USING *(PR [#5320](https://github.com/tobymao/sqlglot/pull/5320) by [@geooo109](https://github.com/geooo109))*:

  distinguish STORED AS from USING (#5320)

- due to [`c4ca182`](https://github.com/tobymao/sqlglot/commit/c4ca182ad637b7a22b55d0ecf320c5a09ec5d56c) - annotate type for FROM_BASE64 *(PR [#5329](https://github.com/tobymao/sqlglot/pull/5329) by [@geooo109](https://github.com/geooo109))*:

  annotate type for FROM_BASE64 (#5329)

- due to [`7b72bbe`](https://github.com/tobymao/sqlglot/commit/7b72bbed3a0930e11ce4a0fdd9082de715326ac9) - annotate type for ANY_VALUE *(PR [#5331](https://github.com/tobymao/sqlglot/pull/5331) by [@geooo109](https://github.com/geooo109))*:

  annotate type for ANY_VALUE (#5331)

- due to [`c0d57e7`](https://github.com/tobymao/sqlglot/commit/c0d57e747bf5d2bed7ba2007ac2092d5797ee038) - annotate type for CHR *(PR [#5332](https://github.com/tobymao/sqlglot/pull/5332) by [@geooo109](https://github.com/geooo109))*:

  annotate type for CHR (#5332)

- due to [`d65b5c2`](https://github.com/tobymao/sqlglot/commit/d65b5c22c29416007cca0154fd35f1d4b5efc929) - annotate type for COUNTIF *(PR [#5334](https://github.com/tobymao/sqlglot/pull/5334) by [@geooo109](https://github.com/geooo109))*:

  annotate type for COUNTIF (#5334)

- due to [`521b705`](https://github.com/tobymao/sqlglot/commit/521b7053213df8577f609409af2552c2ff4fd8c9) - annotate type for GENERATE_ARRAY *(PR [#5335](https://github.com/tobymao/sqlglot/pull/5335) by [@geooo109](https://github.com/geooo109))*:

  annotate type for GENERATE_ARRAY (#5335)

- due to [`5fb26c5`](https://github.com/tobymao/sqlglot/commit/5fb26c58026018360f36a732394b612a3baac38b) - annotate type for INT64 *(PR [#5339](https://github.com/tobymao/sqlglot/pull/5339) by [@geooo109](https://github.com/geooo109))*:

  annotate type for INT64 (#5339)

- due to [`cff9b55`](https://github.com/tobymao/sqlglot/commit/cff9b55d70a3b85057e6385c93c0814eaa50f40b) - annotate type for LOGICAL_AND and LOGICAL_OR *(PR [#5340](https://github.com/tobymao/sqlglot/pull/5340) by [@geooo109](https://github.com/geooo109))*:

  annotate type for LOGICAL_AND and LOGICAL_OR (#5340)

- due to [`b94a6f9`](https://github.com/tobymao/sqlglot/commit/b94a6f9228aa730296c3152179bfbf3503521063) - annotate type for MAKE_INTERVAL *(PR [#5341](https://github.com/tobymao/sqlglot/pull/5341) by [@geooo109](https://github.com/geooo109))*:

  annotate type for MAKE_INTERVAL (#5341)

- due to [`2c9a7c6`](https://github.com/tobymao/sqlglot/commit/2c9a7c6f0b097a9e8514fc5e2af21c52f145920c) - annotate type for LAST_VALUE *(PR [#5336](https://github.com/tobymao/sqlglot/pull/5336) by [@geooo109](https://github.com/geooo109))*:

  annotate type for LAST_VALUE (#5336)

- due to [`d862a28`](https://github.com/tobymao/sqlglot/commit/d862a28b0a30f0c5774351f38a61f195120ad904) - annoate type for TO_BASE64 *(PR [#5342](https://github.com/tobymao/sqlglot/pull/5342) by [@geooo109](https://github.com/geooo109))*:

  annoate type for TO_BASE64 (#5342)

- due to [`85888c1`](https://github.com/tobymao/sqlglot/commit/85888c1b7cbbd0eee179d902a54fbd2a899cc16b) - annotate type for UNIX_DATE *(PR [#5343](https://github.com/tobymao/sqlglot/pull/5343) by [@geooo109](https://github.com/geooo109))*:

  annotate type for UNIX_DATE (#5343)

- due to [`8a214e0`](https://github.com/tobymao/sqlglot/commit/8a214e0859dfb715fcef0dd6b2d6392012b1f3fb) - annotate type for UNIX_SECONDS *(PR [#5344](https://github.com/tobymao/sqlglot/pull/5344) by [@geooo109](https://github.com/geooo109))*:

  annotate type for UNIX_SECONDS (#5344)

- due to [`625cb74`](https://github.com/tobymao/sqlglot/commit/625cb74b69e99ea1a707549366ea960d759848c9) - annotate type for STARTS_WITH *(PR [#5345](https://github.com/tobymao/sqlglot/pull/5345) by [@geooo109](https://github.com/geooo109))*:

  annotate type for STARTS_WITH (#5345)

- due to [`0337c4d`](https://github.com/tobymao/sqlglot/commit/0337c4d46e9e85d951fc9565a47e338106543711) - annotate type for SHA and SHA2 *(PR [#5346](https://github.com/tobymao/sqlglot/pull/5346) by [@geooo109](https://github.com/geooo109))*:

  annotate type for SHA and SHA2 (#5346)

- due to [`cc389fa`](https://github.com/tobymao/sqlglot/commit/cc389facb33f94a0d1f696f2ef9e92f298711894) - annotate type SHA1, SHA256, SHA512 for BigQuery *(PR [#5347](https://github.com/tobymao/sqlglot/pull/5347) by [@geooo109](https://github.com/geooo109))*:

  annotate type SHA1, SHA256, SHA512 for BigQuery (#5347)

- due to [`509b741`](https://github.com/tobymao/sqlglot/commit/509b74173f678842e7550c75c4d8d906c879fb12) - preserve multi-arg DECODE function instead of converting to CASE *(PR [#5352](https://github.com/tobymao/sqlglot/pull/5352) by [@georgesittas](https://github.com/georgesittas))*:

  preserve multi-arg DECODE function instead of converting to CASE (#5352)

- due to [`c1d3d61`](https://github.com/tobymao/sqlglot/commit/c1d3d61d00f00d2030107689d8704f7a488a80a7) - annotate type for CORR *(PR [#5364](https://github.com/tobymao/sqlglot/pull/5364) by [@geooo109](https://github.com/geooo109))*:

  annotate type for CORR (#5364)

- due to [`c1e8677`](https://github.com/tobymao/sqlglot/commit/c1e867767a006e774a2c200c10eb85b3fbd8a372) - annotate type for COVAR_POP *(PR [#5365](https://github.com/tobymao/sqlglot/pull/5365) by [@geooo109](https://github.com/geooo109))*:

  annotate type for COVAR_POP (#5365)

- due to [`e110ef4`](https://github.com/tobymao/sqlglot/commit/e110ef4f774e6ab8de6d4c86e5d306ab53fe895b) - annotate type for COVAR_SAMP *(PR [#5367](https://github.com/tobymao/sqlglot/pull/5367) by [@geooo109](https://github.com/geooo109))*:

  annotate type for COVAR_SAMP (#5367)

- due to [`5b59c16`](https://github.com/tobymao/sqlglot/commit/5b59c16528fb1904c64bef0ca6307bb6a95e5a2c) - annotate type for DATETIME *(PR [#5369](https://github.com/tobymao/sqlglot/pull/5369) by [@geooo109](https://github.com/geooo109))*:

  annotate type for DATETIME (#5369)

- due to [`47176ce`](https://github.com/tobymao/sqlglot/commit/47176ce6b9a4c1722f285034b08a6ae782129894) - annotate type for ENDS_WITH *(PR [#5370](https://github.com/tobymao/sqlglot/pull/5370) by [@geooo109](https://github.com/geooo109))*:

  annotate type for ENDS_WITH (#5370)

- due to [`2cce53d`](https://github.com/tobymao/sqlglot/commit/2cce53d59968f0a4bb3e9599ade93b0e6a140c68) - annotate type for LAG *(PR [#5371](https://github.com/tobymao/sqlglot/pull/5371) by [@geooo109](https://github.com/geooo109))*:

  annotate type for LAG (#5371)

- due to [`a3227de`](https://github.com/tobymao/sqlglot/commit/a3227de3fc57d559eb899dec08af01f85b470ce4) - improve transpilation of `ROUND(x, y)` to Postgres *(PR [#5368](https://github.com/tobymao/sqlglot/pull/5368) by [@blecourt-private](https://github.com/blecourt-private))*:

  improve transpilation of `ROUND(x, y)` to Postgres (#5368)

- due to [`d7ccb48`](https://github.com/tobymao/sqlglot/commit/d7ccb48e542c49258e31cc4df45f49beebc2e238) - week/quarter support *(PR [#5374](https://github.com/tobymao/sqlglot/pull/5374) by [@eakmanrq](https://github.com/eakmanrq))*:

  week/quarter support (#5374)

- due to [`b368fba`](https://github.com/tobymao/sqlglot/commit/b368fba59b606e038d445b2ca2d8436e115af3d6) - parse and annotate type for ASCII *(PR [#5377](https://github.com/tobymao/sqlglot/pull/5377) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for ASCII (#5377)

- due to [`7f19b31`](https://github.com/tobymao/sqlglot/commit/7f19b31ebd7981e53a8f8ba343b4f3222fe160c7) - annotate type for UNICODE *(PR [#5381](https://github.com/tobymao/sqlglot/pull/5381) by [@geooo109](https://github.com/geooo109))*:

  annotate type for UNICODE (#5381)

- due to [`9e8d3ab`](https://github.com/tobymao/sqlglot/commit/9e8d3abedcffb1c267ed0e6a8332af3b52105d41) - Preserve struct-column parentheses for RisingWave dialect *(PR [#5376](https://github.com/tobymao/sqlglot/pull/5376) by [@MisterWheatley](https://github.com/MisterWheatley))*:

  Added dialect as argument to `simplify_parens` function  
  * style: Ran formatter and tests. Fixed type annotation for simplify_parens  
  * Fix: Make dialect in `simplify_parens` optional.  
  Co-authored-by: Jo <46752250+georgesittas@users.noreply.github.com>  
  * Fix(optimizer): Tweaks to make simple non-nested star expand pass unit test for RW  
  * Fix(optimizer): Added test for deep nested unpacking for BigQuery and RisingWave  
  * style: Ran formatting check  
  * fix: Remove unuses function from RisingWave dialect test  
  * docs: updated docstring of new _expand_struct_stars_risingwave internal function  
  * fix: apply suggestions from code review 2  
  Co-authored-by: Jo <46752250+georgesittas@users.noreply.github.com>  
  * fix(optimizer,risingwave): Ensure that struct star-expansion to the correct level for RisingWave  
  Updated logic for expanding (struct_col).* expressions in RisingWave to correctly handle the level of nesting.  
  Moved struct expansion tests to tests/fixtures/qualify_columns.sql on behest of maintainers.  
  ---------

- due to [`3223e63`](https://github.com/tobymao/sqlglot/commit/3223e6394fdd3f8e48c68bbb940b661ff8e76fd8) - cast datetimeoffset to datetime2 *(PR [#5385](https://github.com/tobymao/sqlglot/pull/5385) by [@mattiasthalen](https://github.com/mattiasthalen))*:

  cast datetimeoffset to datetime2 (#5385)

- due to [`06cea31`](https://github.com/tobymao/sqlglot/commit/06cea310bd9fd3a9a9fa0ba008596e878a430df8) - support KEY related locks *(PR [#5397](https://github.com/tobymao/sqlglot/pull/5397) by [@geooo109](https://github.com/geooo109))*:

  support KEY related locks (#5397)

- due to [`1014a67`](https://github.com/tobymao/sqlglot/commit/1014a6759b0917ef1bf5af0dbbdcca72214a8dea) - remove redundant todate in dayofweek closes [#5398](https://github.com/tobymao/sqlglot/pull/5398) *(PR [#5399](https://github.com/tobymao/sqlglot/pull/5399) by [@tobymao](https://github.com/tobymao))*:

  remove redundant todate in dayofweek closes #5398 (#5399)

- due to [`b2631ae`](https://github.com/tobymao/sqlglot/commit/b2631aec8d1bdb08decb201b6bd2ba5d927bb121) - annotate type for bigquery BIT_AND, BIT_OR, BIT_XOR, BIT_COUNT *(PR [#5405](https://github.com/tobymao/sqlglot/pull/5405) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery BIT_AND, BIT_OR, BIT_XOR, BIT_COUNT (#5405)

- due to [`5835b8d`](https://github.com/tobymao/sqlglot/commit/5835b8d6c7fe77d9645691bb88021af137ed0bac) - make bracket parsing aware of duckdb MAP func *(PR [#5423](https://github.com/tobymao/sqlglot/pull/5423) by [@geooo109](https://github.com/geooo109))*:

  make bracket parsing aware of duckdb MAP func (#5423)

- due to [`489dc5c`](https://github.com/tobymao/sqlglot/commit/489dc5c2f7506e0fe4de549384dd0f816e9fd12f) - parse and annotate type support for JSON_ARRAY *(PR [#5424](https://github.com/tobymao/sqlglot/pull/5424) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type support for JSON_ARRAY (#5424)

- due to [`0ed518c`](https://github.com/tobymao/sqlglot/commit/0ed518c67042002ee0af91bee0b9e7093c85f926) - annotate type for bigquery JSON_VALUE *(PR [#5427](https://github.com/tobymao/sqlglot/pull/5427) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery JSON_VALUE (#5427)

- due to [`6091617`](https://github.com/tobymao/sqlglot/commit/6091617067c263e3e834e579b37aa1c601b1ddc7) - annotate type for bigquery JSON_VALUE_ARRAY *(PR [#5428](https://github.com/tobymao/sqlglot/pull/5428) by [@geooo109](https://github.com/geooo109))*:

  annotate type for bigquery JSON_VALUE_ARRAY (#5428)

- due to [`631c851`](https://github.com/tobymao/sqlglot/commit/631c851cbbfbf55cb66a79c2549aeeb443fcab83) - parse and annotate type support for bigquery JSON_TYPE *(PR [#5430](https://github.com/tobymao/sqlglot/pull/5430) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type support for bigquery JSON_TYPE (#5430)


### :sparkles: New Features
- [`ba7bf39`](https://github.com/tobymao/sqlglot/commit/ba7bf39966b519e11cde02a3c1f720598469e616) - **exasol**: implemented BIT_AND function with test *(PR [#5294](https://github.com/tobymao/sqlglot/pull/5294) by [@nnamdi16](https://github.com/nnamdi16))*
- [`fb4122e`](https://github.com/tobymao/sqlglot/commit/fb4122e80d1995bb87401e9ebe3749078c026a06) - **exasol**: add bitwiseOr function to exasol dialect *(PR [#5297](https://github.com/tobymao/sqlglot/pull/5297) by [@nnamdi16](https://github.com/nnamdi16))*
- [`c103b23`](https://github.com/tobymao/sqlglot/commit/c103b2304dca552ac8cf6733156db8b59d3614f3) - add support for `SUBSTRING_INDEX` *(PR [#5296](https://github.com/tobymao/sqlglot/pull/5296) by [@ankur334](https://github.com/ankur334))*
- [`4752f3a`](https://github.com/tobymao/sqlglot/commit/4752f3a6b715d8b6968c8f1f05f6ccdfb7351071) - **exasol**: added bit_xor built in exasol function to exasol dialect in sqlglot *(PR [#5298](https://github.com/tobymao/sqlglot/pull/5298) by [@nnamdi16](https://github.com/nnamdi16))*
- [`09bd610`](https://github.com/tobymao/sqlglot/commit/09bd6101de21ed86c9fd6df0f63e8bca2666dd81) - **parser**: annotate type of ARRAY_CONCAT_AGG *(PR [#5299](https://github.com/tobymao/sqlglot/pull/5299) by [@geooo109](https://github.com/geooo109))*
- [`ad0311a`](https://github.com/tobymao/sqlglot/commit/ad0311a7f8b0b3c5746c29d816b58578a892dd33) - **exasol**: added bit_not exasol built in function. *(PR [#5300](https://github.com/tobymao/sqlglot/pull/5300) by [@nnamdi16](https://github.com/nnamdi16))*
- [`a7bd823`](https://github.com/tobymao/sqlglot/commit/a7bd8234e0dd02abfe6fa56287e7bda14a549e5a) - **parser**: annotate type of ARRAY_TO_STRING *(PR [#5301](https://github.com/tobymao/sqlglot/pull/5301) by [@geooo109](https://github.com/geooo109))*
- [`2aa2182`](https://github.com/tobymao/sqlglot/commit/2aa21820f7d3a26cc4f47c1c757a9b7c97dd0382) - **exasol**: added BIT_LSHIFT built in function to exasol dialect *(PR [#5302](https://github.com/tobymao/sqlglot/pull/5302) by [@nnamdi16](https://github.com/nnamdi16))*
- [`c3d9ef2`](https://github.com/tobymao/sqlglot/commit/c3d9ef2cb2d004b57c64af4f3f1bac41f1890737) - **exasol**: added the bit_rshift built in exasol function *(PR [#5304](https://github.com/tobymao/sqlglot/pull/5304) by [@nnamdi16](https://github.com/nnamdi16))*
- [`6b42353`](https://github.com/tobymao/sqlglot/commit/6b4235340a2e432015c27b2aeadbdcb930bfa6b0) - **parser**: annotate type of ARRAY_FIRST, ARRAY_LAST *(PR [#5303](https://github.com/tobymao/sqlglot/pull/5303) by [@geooo109](https://github.com/geooo109))*
- [`f5b7cc6`](https://github.com/tobymao/sqlglot/commit/f5b7cc6d2f8d73bff4e42e242d3ad3db41d899cc) - **exasol**: added `EVERY` built in function *(PR [#5305](https://github.com/tobymao/sqlglot/pull/5305) by [@nnamdi16](https://github.com/nnamdi16))*
- [`d3f04d6`](https://github.com/tobymao/sqlglot/commit/d3f04d6766281ecb7ced9a5e812ab765d7b699be) - add Dremio dialect *(PR [#5277](https://github.com/tobymao/sqlglot/pull/5277) by [@mateuszpoleski](https://github.com/mateuszpoleski))*
- [`3d8e478`](https://github.com/tobymao/sqlglot/commit/3d8e478eac3df6a94c87cd610f96c5f19697a9bf) - **exasol**: added edit_distance built in function to exasol dialect *(PR [#5310](https://github.com/tobymao/sqlglot/pull/5310) by [@nnamdi16](https://github.com/nnamdi16))*
- [`db9b61e`](https://github.com/tobymao/sqlglot/commit/db9b61e4ecaa0600418eb90f637fb8b06b08c399) - **parser**: parse, annotate type for ARRAY_REVERSE *(PR [#5306](https://github.com/tobymao/sqlglot/pull/5306) by [@geooo109](https://github.com/geooo109))*
- [`5612a6d`](https://github.com/tobymao/sqlglot/commit/5612a6da6dee3545f3600db1e5b87c9450952eba) - add support for SPACE *(PR [#5308](https://github.com/tobymao/sqlglot/pull/5308) by [@ankur334](https://github.com/ankur334))*
- [`f148c9e`](https://github.com/tobymao/sqlglot/commit/f148c9e64ae0d4df96323271729fa6a6ca68a671) - **duckdb**: Transpile Spark's `exp.PosExplode` *(PR [#5311](https://github.com/tobymao/sqlglot/pull/5311) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5309](https://github.com/tobymao/sqlglot/issues/5309) opened by [@nimrodolev](https://github.com/nimrodolev)*
- [`179a278`](https://github.com/tobymao/sqlglot/commit/179a278c7fdbc29105e37f132e6f03e18627f769) - **exasol**: added the regexp_replace function *(PR [#5313](https://github.com/tobymao/sqlglot/pull/5313) by [@nnamdi16](https://github.com/nnamdi16))*
- [`8a2f65d`](https://github.com/tobymao/sqlglot/commit/8a2f65d6b2b68ad5ba45a5aed5e56c4dc0fea6fc) - **parser**: parse and annotate type for ARRAY_SLICE *(PR [#5312](https://github.com/tobymao/sqlglot/pull/5312) by [@geooo109](https://github.com/geooo109))*
- [`d2f7c41`](https://github.com/tobymao/sqlglot/commit/d2f7c41f9f30f4cf0c74782be9be0cc6e75565f3) - add TypeOf / toTypeName support *(PR [#5315](https://github.com/tobymao/sqlglot/pull/5315) by [@ankur334](https://github.com/ankur334))*
- [`950c15d`](https://github.com/tobymao/sqlglot/commit/950c15db5ff64b6f11036f8003db3e5b1fb3afc3) - **exasol**: add var_pop built in function to exasol dialect *(PR [#5328](https://github.com/tobymao/sqlglot/pull/5328) by [@nnamdi16](https://github.com/nnamdi16))*
- [`c4ca182`](https://github.com/tobymao/sqlglot/commit/c4ca182ad637b7a22b55d0ecf320c5a09ec5d56c) - **optimizer**: annotate type for FROM_BASE64 *(PR [#5329](https://github.com/tobymao/sqlglot/pull/5329) by [@geooo109](https://github.com/geooo109))*
- [`0992e99`](https://github.com/tobymao/sqlglot/commit/0992e99f99aeb4ecc97e6918a23b8fd524311ed9) - **exasol**: Add support  APPROXIMATE_COUNT_DISTINCT functions in exasol dialect *(PR [#5330](https://github.com/tobymao/sqlglot/pull/5330) by [@nnamdi16](https://github.com/nnamdi16))*
- [`7b72bbe`](https://github.com/tobymao/sqlglot/commit/7b72bbed3a0930e11ce4a0fdd9082de715326ac9) - **optimizer**: annotate type for ANY_VALUE *(PR [#5331](https://github.com/tobymao/sqlglot/pull/5331) by [@geooo109](https://github.com/geooo109))*
- [`c0d57e7`](https://github.com/tobymao/sqlglot/commit/c0d57e747bf5d2bed7ba2007ac2092d5797ee038) - **optimizer**: annotate type for CHR *(PR [#5332](https://github.com/tobymao/sqlglot/pull/5332) by [@geooo109](https://github.com/geooo109))*
- [`d65b5c2`](https://github.com/tobymao/sqlglot/commit/d65b5c22c29416007cca0154fd35f1d4b5efc929) - **optimizer**: annotate type for COUNTIF *(PR [#5334](https://github.com/tobymao/sqlglot/pull/5334) by [@geooo109](https://github.com/geooo109))*
- [`521b705`](https://github.com/tobymao/sqlglot/commit/521b7053213df8577f609409af2552c2ff4fd8c9) - **optimizer**: annotate type for GENERATE_ARRAY *(PR [#5335](https://github.com/tobymao/sqlglot/pull/5335) by [@geooo109](https://github.com/geooo109))*
- [`5fb26c5`](https://github.com/tobymao/sqlglot/commit/5fb26c58026018360f36a732394b612a3baac38b) - **optimizer**: annotate type for INT64 *(PR [#5339](https://github.com/tobymao/sqlglot/pull/5339) by [@geooo109](https://github.com/geooo109))*
- [`cff9b55`](https://github.com/tobymao/sqlglot/commit/cff9b55d70a3b85057e6385c93c0814eaa50f40b) - **optimizer**: annotate type for LOGICAL_AND and LOGICAL_OR *(PR [#5340](https://github.com/tobymao/sqlglot/pull/5340) by [@geooo109](https://github.com/geooo109))*
- [`b94a6f9`](https://github.com/tobymao/sqlglot/commit/b94a6f9228aa730296c3152179bfbf3503521063) - **optimizer**: annotate type for MAKE_INTERVAL *(PR [#5341](https://github.com/tobymao/sqlglot/pull/5341) by [@geooo109](https://github.com/geooo109))*
- [`2c9a7c6`](https://github.com/tobymao/sqlglot/commit/2c9a7c6f0b097a9e8514fc5e2af21c52f145920c) - **optimizer**: annotate type for LAST_VALUE *(PR [#5336](https://github.com/tobymao/sqlglot/pull/5336) by [@geooo109](https://github.com/geooo109))*
- [`d862a28`](https://github.com/tobymao/sqlglot/commit/d862a28b0a30f0c5774351f38a61f195120ad904) - **optimizer**: annoate type for TO_BASE64 *(PR [#5342](https://github.com/tobymao/sqlglot/pull/5342) by [@geooo109](https://github.com/geooo109))*
- [`85888c1`](https://github.com/tobymao/sqlglot/commit/85888c1b7cbbd0eee179d902a54fbd2a899cc16b) - **optimizer**: annotate type for UNIX_DATE *(PR [#5343](https://github.com/tobymao/sqlglot/pull/5343) by [@geooo109](https://github.com/geooo109))*
- [`8a214e0`](https://github.com/tobymao/sqlglot/commit/8a214e0859dfb715fcef0dd6b2d6392012b1f3fb) - **optimizer**: annotate type for UNIX_SECONDS *(PR [#5344](https://github.com/tobymao/sqlglot/pull/5344) by [@geooo109](https://github.com/geooo109))*
- [`625cb74`](https://github.com/tobymao/sqlglot/commit/625cb74b69e99ea1a707549366ea960d759848c9) - **optimizer**: annotate type for STARTS_WITH *(PR [#5345](https://github.com/tobymao/sqlglot/pull/5345) by [@geooo109](https://github.com/geooo109))*
- [`0337c4d`](https://github.com/tobymao/sqlglot/commit/0337c4d46e9e85d951fc9565a47e338106543711) - **optimizer**: annotate type for SHA and SHA2 *(PR [#5346](https://github.com/tobymao/sqlglot/pull/5346) by [@geooo109](https://github.com/geooo109))*
- [`835d9e6`](https://github.com/tobymao/sqlglot/commit/835d9e6c9ffc05de642113b566a1a4eb9cc38470) - add case-insensitive uppercase normalization strategy *(PR [#5349](https://github.com/tobymao/sqlglot/pull/5349) by [@georgesittas](https://github.com/georgesittas))*
- [`f80493e`](https://github.com/tobymao/sqlglot/commit/f80493efb168f600dc92da439d84e820f303e5aa) - **exasol**: Add TO_CHAR function support in exasol dialect *(PR [#5350](https://github.com/tobymao/sqlglot/pull/5350) by [@nnamdi16](https://github.com/nnamdi16))*
- [`cea6a24`](https://github.com/tobymao/sqlglot/commit/cea6a240292d6e31bc73179d433835483e65747a) - **teradata**: add FORMAT phrase parsing *(PR [#5348](https://github.com/tobymao/sqlglot/pull/5348) by [@readjfb](https://github.com/readjfb))*
- [`eae64e1`](https://github.com/tobymao/sqlglot/commit/eae64e1629a276bf3885749991869b6c6dea8a8b) - **duckdb**: support new lambda syntax *(PR [#5359](https://github.com/tobymao/sqlglot/pull/5359) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#5357](https://github.com/tobymao/sqlglot/issues/5357) opened by [@aersam](https://github.com/aersam)*
- [`e77991d`](https://github.com/tobymao/sqlglot/commit/e77991d92fad56014ba2778c71e5e446d4dd090e) - **duckdb**: Add support for SET VARIABLE *(PR [#5360](https://github.com/tobymao/sqlglot/pull/5360) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5356](https://github.com/tobymao/sqlglot/issues/5356) opened by [@aersam](https://github.com/aersam)*
- [`c1d3d61`](https://github.com/tobymao/sqlglot/commit/c1d3d61d00f00d2030107689d8704f7a488a80a7) - **optimizer**: annotate type for CORR *(PR [#5364](https://github.com/tobymao/sqlglot/pull/5364) by [@geooo109](https://github.com/geooo109))*
- [`c1e8677`](https://github.com/tobymao/sqlglot/commit/c1e867767a006e774a2c200c10eb85b3fbd8a372) - **optimizer**: annotate type for COVAR_POP *(PR [#5365](https://github.com/tobymao/sqlglot/pull/5365) by [@geooo109](https://github.com/geooo109))*
- [`e110ef4`](https://github.com/tobymao/sqlglot/commit/e110ef4f774e6ab8de6d4c86e5d306ab53fe895b) - **optimizer**: annotate type for COVAR_SAMP *(PR [#5367](https://github.com/tobymao/sqlglot/pull/5367) by [@geooo109](https://github.com/geooo109))*
- [`5b59c16`](https://github.com/tobymao/sqlglot/commit/5b59c16528fb1904c64bef0ca6307bb6a95e5a2c) - **optimizer**: annotate type for DATETIME *(PR [#5369](https://github.com/tobymao/sqlglot/pull/5369) by [@geooo109](https://github.com/geooo109))*
- [`47176ce`](https://github.com/tobymao/sqlglot/commit/47176ce6b9a4c1722f285034b08a6ae782129894) - **optimizer**: annotate type for ENDS_WITH *(PR [#5370](https://github.com/tobymao/sqlglot/pull/5370) by [@geooo109](https://github.com/geooo109))*
- [`1fd757e`](https://github.com/tobymao/sqlglot/commit/1fd757e6279315f00e719974613313a6e43dfe55) - **fabric**: Ensure TIMESTAMPTZ is used with AT TIME ZONE *(PR [#5362](https://github.com/tobymao/sqlglot/pull/5362) by [@mattiasthalen](https://github.com/mattiasthalen))*
- [`2cce53d`](https://github.com/tobymao/sqlglot/commit/2cce53d59968f0a4bb3e9599ade93b0e6a140c68) - **optimizer**: annotate type for LAG *(PR [#5371](https://github.com/tobymao/sqlglot/pull/5371) by [@geooo109](https://github.com/geooo109))*
- [`a3227de`](https://github.com/tobymao/sqlglot/commit/a3227de3fc57d559eb899dec08af01f85b470ce4) - improve transpilation of `ROUND(x, y)` to Postgres *(PR [#5368](https://github.com/tobymao/sqlglot/pull/5368) by [@blecourt-private](https://github.com/blecourt-private))*
  - :arrow_lower_right: *addresses issue [#5366](https://github.com/tobymao/sqlglot/issues/5366) opened by [@blecourt-private](https://github.com/blecourt-private)*
- [`b368fba`](https://github.com/tobymao/sqlglot/commit/b368fba59b606e038d445b2ca2d8436e115af3d6) - **optimizer**: parse and annotate type for ASCII *(PR [#5377](https://github.com/tobymao/sqlglot/pull/5377) by [@geooo109](https://github.com/geooo109))*
- [`7f19b31`](https://github.com/tobymao/sqlglot/commit/7f19b31ebd7981e53a8f8ba343b4f3222fe160c7) - **optimizer**: annotate type for UNICODE *(PR [#5381](https://github.com/tobymao/sqlglot/pull/5381) by [@geooo109](https://github.com/geooo109))*
- [`f035bf0`](https://github.com/tobymao/sqlglot/commit/f035bf0eb582aa07d4ad79e0ed1958ce0d091ad9) - **dremio**: Add TIME_MAPPING for Dremio dialect *(PR [#5378](https://github.com/tobymao/sqlglot/pull/5378) by [@mateuszpoleski](https://github.com/mateuszpoleski))*
- [`31cfd0f`](https://github.com/tobymao/sqlglot/commit/31cfd0fc3309bc1080b7a2ba8d40b2aba5c098a3) - **exasol**: add to_date and refactored to_char functions with respect to time mapping *(PR [#5379](https://github.com/tobymao/sqlglot/pull/5379) by [@nnamdi16](https://github.com/nnamdi16))*
- [`bd3776e`](https://github.com/tobymao/sqlglot/commit/bd3776eaa26d40b44c4cebc2f3838b4055653548) - **doris**: add PROPERTIES_LOCATION mapping for Doris dialect *(PR [#5391](https://github.com/tobymao/sqlglot/pull/5391) by [@xinge-ji](https://github.com/xinge-ji))*
- [`7eaa67a`](https://github.com/tobymao/sqlglot/commit/7eaa67acb216501046c739f56839418b84f244c0) - **doris**: properly supported PROPERTIES and UNIQUE KEY table prop *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`1e78163`](https://github.com/tobymao/sqlglot/commit/1e78163b829e910e7960c79e7ab118c07d1ecdc3) - **duckdb**: support column access via index *(PR [#5395](https://github.com/tobymao/sqlglot/pull/5395) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *addresses issue [#5392](https://github.com/tobymao/sqlglot/issues/5392) opened by [@tekumara](https://github.com/tekumara)*
- [`1014a67`](https://github.com/tobymao/sqlglot/commit/1014a6759b0917ef1bf5af0dbbdcca72214a8dea) - remove redundant todate in dayofweek closes [#5398](https://github.com/tobymao/sqlglot/pull/5398) *(PR [#5399](https://github.com/tobymao/sqlglot/pull/5399) by [@tobymao](https://github.com/tobymao))*
- [`be52f78`](https://github.com/tobymao/sqlglot/commit/be52f7866b03e436d103d9201d1a44c6632c643a) - **exasol**: add support for CONVERT_TZ function *(PR [#5401](https://github.com/tobymao/sqlglot/pull/5401) by [@nnamdi16](https://github.com/nnamdi16))*
- [`d637161`](https://github.com/tobymao/sqlglot/commit/d637161406faf623418f112162268bedb422213b) - **exasol**: add mapping to TIME_TO_STR in exasol dialect *(PR [#5403](https://github.com/tobymao/sqlglot/pull/5403) by [@nnamdi16](https://github.com/nnamdi16))*
- [`b2631ae`](https://github.com/tobymao/sqlglot/commit/b2631aec8d1bdb08decb201b6bd2ba5d927bb121) - **optimizer**: annotate type for bigquery BIT_AND, BIT_OR, BIT_XOR, BIT_COUNT *(PR [#5405](https://github.com/tobymao/sqlglot/pull/5405) by [@geooo109](https://github.com/geooo109))*
- [`b81ae62`](https://github.com/tobymao/sqlglot/commit/b81ae629bfb27760ddd832402a86dabe4e65072f) - **exasol**: map STR_TO_TIME to TO_DATE and *(PR [#5407](https://github.com/tobymao/sqlglot/pull/5407) by [@nnamdi16](https://github.com/nnamdi16))*
- [`c2fb9ab`](https://github.com/tobymao/sqlglot/commit/c2fb9abeb2f077f00278e46efd9573a3806cd218) - add `DateStrToTime` *(PR [#5409](https://github.com/tobymao/sqlglot/pull/5409) by [@betodealmeida](https://github.com/betodealmeida))*
- [`a95993a`](https://github.com/tobymao/sqlglot/commit/a95993ae4e8aa99969db059a534819a4f0b62b96) - **snowflake**: improve transpilation of queries with UNNEST sources *(PR [#5408](https://github.com/tobymao/sqlglot/pull/5408) by [@georgesittas](https://github.com/georgesittas))*
- [`7b69f54`](https://github.com/tobymao/sqlglot/commit/7b69f545bbcfeb1e1f2f3b7e0b9757cfd675e4a5) - **snowflake**: Support SEMANTIC_VIEW *(PR [#5414](https://github.com/tobymao/sqlglot/pull/5414) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5406](https://github.com/tobymao/sqlglot/issues/5406) opened by [@jkillian](https://github.com/jkillian)*
- [`7dba6f6`](https://github.com/tobymao/sqlglot/commit/7dba6f64d9a7945bbdef1b6e014d802014567a1e) - **exasol**: map AT TIME ZONE to CONVERT_TZ *(PR [#5416](https://github.com/tobymao/sqlglot/pull/5416) by [@nnamdi16](https://github.com/nnamdi16))*
- [`25f2c1b`](https://github.com/tobymao/sqlglot/commit/25f2c1bb18f9d073b128150566cb27c0c2da0865) - **postgres**: query placeholders *(PR [#5415](https://github.com/tobymao/sqlglot/pull/5415) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *addresses issue [#5412](https://github.com/tobymao/sqlglot/issues/5412) opened by [@aersam](https://github.com/aersam)*
- [`c309c87`](https://github.com/tobymao/sqlglot/commit/c309c8763a90bf0bce02e21f4088b38d85556cce) - **doris**: support range partitioning *(PR [#5402](https://github.com/tobymao/sqlglot/pull/5402) by [@xinge-ji](https://github.com/xinge-ji))*
- [`394d3a8`](https://github.com/tobymao/sqlglot/commit/394d3a81ef41d3052c0b0d6e48180c344b7db143) - **dremio**: Add support for DATE_ADD and DATE_SUB *(PR [#5411](https://github.com/tobymao/sqlglot/pull/5411) by [@mateuszpoleski](https://github.com/mateuszpoleski))*
- [`9cfac4f`](https://github.com/tobymao/sqlglot/commit/9cfac4fb04ce1fd038c3e8cbdb755cc24c052497) - **doris**: enhance partitioning support *(PR [#5421](https://github.com/tobymao/sqlglot/pull/5421) by [@xinge-ji](https://github.com/xinge-ji))*
- [`a018bea`](https://github.com/tobymao/sqlglot/commit/a018bea159261a3ad4ac082f29e30fe1153995b3) - **exasol**: mapped exp.CurrentUser to exasol CURRENT_USER *(PR [#5422](https://github.com/tobymao/sqlglot/pull/5422) by [@nnamdi16](https://github.com/nnamdi16))*
- [`489dc5c`](https://github.com/tobymao/sqlglot/commit/489dc5c2f7506e0fe4de549384dd0f816e9fd12f) - **optimizer**: parse and annotate type support for JSON_ARRAY *(PR [#5424](https://github.com/tobymao/sqlglot/pull/5424) by [@geooo109](https://github.com/geooo109))*
- [`0ed518c`](https://github.com/tobymao/sqlglot/commit/0ed518c67042002ee0af91bee0b9e7093c85f926) - **optimizer**: annotate type for bigquery JSON_VALUE *(PR [#5427](https://github.com/tobymao/sqlglot/pull/5427) by [@geooo109](https://github.com/geooo109))*
- [`6091617`](https://github.com/tobymao/sqlglot/commit/6091617067c263e3e834e579b37aa1c601b1ddc7) - **optimizer**: annotate type for bigquery JSON_VALUE_ARRAY *(PR [#5428](https://github.com/tobymao/sqlglot/pull/5428) by [@geooo109](https://github.com/geooo109))*
- [`631c851`](https://github.com/tobymao/sqlglot/commit/631c851cbbfbf55cb66a79c2549aeeb443fcab83) - **optimizer**: parse and annotate type support for bigquery JSON_TYPE *(PR [#5430](https://github.com/tobymao/sqlglot/pull/5430) by [@geooo109](https://github.com/geooo109))*

### :bug: Bug Fixes
- [`5724538`](https://github.com/tobymao/sqlglot/commit/5724538f278b2178114b88850251afd7c3db0dda) - **bigquery**: ARRAY_CONCAT type annotation *(PR [#5293](https://github.com/tobymao/sqlglot/pull/5293) by [@geooo109](https://github.com/geooo109))*
- [`0a6afcd`](https://github.com/tobymao/sqlglot/commit/0a6afcd90c663aaef9b385fc12ccd19dbf6388cc) - use re-entrant lock in dialects/__init__ to avoid deadlocks *(PR [#5322](https://github.com/tobymao/sqlglot/pull/5322) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5321](https://github.com/tobymao/sqlglot/issues/5321) opened by [@jc-5s](https://github.com/jc-5s)*
- [`599ca81`](https://github.com/tobymao/sqlglot/commit/599ca8101f48805098cbdf808ac2923a8246066b) - **parser**: avoid CTE values ALIAS gen, when ALIAS exists *(PR [#5323](https://github.com/tobymao/sqlglot/pull/5323) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5318](https://github.com/tobymao/sqlglot/issues/5318) opened by [@ankur334](https://github.com/ankur334)*
- [`5a0f589`](https://github.com/tobymao/sqlglot/commit/5a0f589a0fdb6743c3be2f98b74a34780f51332b) - **spark**: distinguish STORED AS from USING *(PR [#5320](https://github.com/tobymao/sqlglot/pull/5320) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5317](https://github.com/tobymao/sqlglot/issues/5317) opened by [@cosinequanon](https://github.com/cosinequanon)*
- [`cbc79c2`](https://github.com/tobymao/sqlglot/commit/cbc79c2a47c46370de0378b8bae61f4f3c17ca82) - preserve ORDER BY comments fixes [#5326](https://github.com/tobymao/sqlglot/pull/5326) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`fa69583`](https://github.com/tobymao/sqlglot/commit/fa69583d8b4f5801d05c21a92b43dea272a3ef49) - **optimizer**: avoid qualifying CTE *(PR [#5327](https://github.com/tobymao/sqlglot/pull/5327) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5319](https://github.com/tobymao/sqlglot/issues/5319) opened by [@naamamaoz](https://github.com/naamamaoz)*
- [`29cce43`](https://github.com/tobymao/sqlglot/commit/29cce43e72451feeb8788ac2660658075bf59093) - comment lost before GROUP, JOIN and HAVING *(PR [#5338](https://github.com/tobymao/sqlglot/pull/5338) by [@chiiips](https://github.com/chiiips))*
- [`509b741`](https://github.com/tobymao/sqlglot/commit/509b74173f678842e7550c75c4d8d906c879fb12) - preserve multi-arg DECODE function instead of converting to CASE *(PR [#5352](https://github.com/tobymao/sqlglot/pull/5352) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5351](https://github.com/tobymao/sqlglot/issues/5351) opened by [@kentmaxwell](https://github.com/kentmaxwell)*
- [`188d446`](https://github.com/tobymao/sqlglot/commit/188d446ca65125c63bbfff96d15d91078deb6b4a) - **optimizer**: downstream column for PIVOT *(PR [#5363](https://github.com/tobymao/sqlglot/pull/5363) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5354](https://github.com/tobymao/sqlglot/issues/5354) opened by [@suresh-summation](https://github.com/suresh-summation)*
- [`d7ccb48`](https://github.com/tobymao/sqlglot/commit/d7ccb48e542c49258e31cc4df45f49beebc2e238) - **duckdb**: week/quarter support *(PR [#5374](https://github.com/tobymao/sqlglot/pull/5374) by [@eakmanrq](https://github.com/eakmanrq))*
- [`252469d`](https://github.com/tobymao/sqlglot/commit/252469d2d0ed221dbb2fde86043506ad15dbe7e5) - **snowflake**: transpile bigquery CURRENT_DATE with timezone *(PR [#5387](https://github.com/tobymao/sqlglot/pull/5387) by [@geooo109](https://github.com/geooo109))*
- [`7511853`](https://github.com/tobymao/sqlglot/commit/751185325caf838107ecb4e8f35ad77bf3cc9bf2) - **postgres**: add XML type *(PR [#5396](https://github.com/tobymao/sqlglot/pull/5396) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5393](https://github.com/tobymao/sqlglot/issues/5393) opened by [@aersam](https://github.com/aersam)*
- [`9e8d3ab`](https://github.com/tobymao/sqlglot/commit/9e8d3abedcffb1c267ed0e6a8332af3b52105d41) - **optimizer**: Preserve struct-column parentheses for RisingWave dialect *(PR [#5376](https://github.com/tobymao/sqlglot/pull/5376) by [@MisterWheatley](https://github.com/MisterWheatley))*
- [`3223e63`](https://github.com/tobymao/sqlglot/commit/3223e6394fdd3f8e48c68bbb940b661ff8e76fd8) - **fabric**: cast datetimeoffset to datetime2 *(PR [#5385](https://github.com/tobymao/sqlglot/pull/5385) by [@mattiasthalen](https://github.com/mattiasthalen))*
- [`12b49dd`](https://github.com/tobymao/sqlglot/commit/12b49dd800951a48ea8bc0f01d7c35340236f559) - remove equal sign from CREATE TABLE comment (doris, starrocks) *(PR [#5390](https://github.com/tobymao/sqlglot/pull/5390) by [@xinge-ji](https://github.com/xinge-ji))*
- [`06cea31`](https://github.com/tobymao/sqlglot/commit/06cea310bd9fd3a9a9fa0ba008596e878a430df8) - **postgres**: support KEY related locks *(PR [#5397](https://github.com/tobymao/sqlglot/pull/5397) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5394](https://github.com/tobymao/sqlglot/issues/5394) opened by [@aurimasandriusaitis](https://github.com/aurimasandriusaitis)*
- [`92d93a6`](https://github.com/tobymao/sqlglot/commit/92d93a624b41df8bb4628c1f2d0cbb8c7844c927) - **parser**: do not consume modifier prefixes in group parser, fixes [#5400](https://github.com/tobymao/sqlglot/pull/5400) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`ba0c801`](https://github.com/tobymao/sqlglot/commit/ba0c801e3dab8e08d4b5f7f73247ec6cfdc667e5) - **tsql**: change READ_ONLY to READONLY *(PR [#5410](https://github.com/tobymao/sqlglot/pull/5410) by [@CrispinStichartFNSB](https://github.com/CrispinStichartFNSB))*
- [`63da895`](https://github.com/tobymao/sqlglot/commit/63da89563fddc13ee7aec06ee36d8a0f74227ee1) - **risingwave**: Fix RisingWave dialect SQL for MAP datatype declaration *(PR [#5418](https://github.com/tobymao/sqlglot/pull/5418) by [@MisterWheatley](https://github.com/MisterWheatley))*
- [`edacae1`](https://github.com/tobymao/sqlglot/commit/edacae183fe26ea25bffe1bccd335bf57ed34ecb) - **snowflake**: transpile bigquery GENERATE_DATE_ARRAY with column access *(PR [#5388](https://github.com/tobymao/sqlglot/pull/5388) by [@geooo109](https://github.com/geooo109))*
- [`5835b8d`](https://github.com/tobymao/sqlglot/commit/5835b8d6c7fe77d9645691bb88021af137ed0bac) - **duckdb**: make bracket parsing aware of duckdb MAP func *(PR [#5423](https://github.com/tobymao/sqlglot/pull/5423) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5417](https://github.com/tobymao/sqlglot/issues/5417) opened by [@MisterWheatley](https://github.com/MisterWheatley)*
- [`5c59816`](https://github.com/tobymao/sqlglot/commit/5c59816f5572f8adb1de9c97f0007d19091910ec) - **snowflake**: ALTER TABLE ADD with multiple columns *(PR [#5431](https://github.com/tobymao/sqlglot/pull/5431) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5426](https://github.com/tobymao/sqlglot/issues/5426) opened by [@ca0904](https://github.com/ca0904)*

### :recycle: Refactors
- [`8d118ea`](https://github.com/tobymao/sqlglot/commit/8d118ead9c15e7b2b4b51b7cf93cab94e61c2625) - **athena**: route statements to hive/trino depending on their type *(PR [#5314](https://github.com/tobymao/sqlglot/pull/5314) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#5267](https://github.com/tobymao/sqlglot/issues/5267) opened by [@cpcloud](https://github.com/cpcloud)*

### :wrench: Chores
- [`cc389fa`](https://github.com/tobymao/sqlglot/commit/cc389facb33f94a0d1f696f2ef9e92f298711894) - **optimizer**: annotate type SHA1, SHA256, SHA512 for BigQuery *(PR [#5347](https://github.com/tobymao/sqlglot/pull/5347) by [@geooo109](https://github.com/geooo109))*
- [`194850a`](https://github.com/tobymao/sqlglot/commit/194850a52497300a8f1d47f2306b67cdd11ffab6) - **exasol**: clean up TO_CHAR *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`1abd461`](https://github.com/tobymao/sqlglot/commit/1abd461295830807c52f24d25ac6938095f54831) - bump min. supported version to python 3.9 *(PR [#5353](https://github.com/tobymao/sqlglot/pull/5353) by [@georgesittas](https://github.com/georgesittas))*
- [`71b1349`](https://github.com/tobymao/sqlglot/commit/71b1349a26d2b9839899900ef8fdfb1ebc3d68fd) - **postgres, hive**: use ASCII node instead of UNICODE node *(PR [#5380](https://github.com/tobymao/sqlglot/pull/5380) by [@geooo109](https://github.com/geooo109))*
- [`a5c2245`](https://github.com/tobymao/sqlglot/commit/a5c2245c3e30f5bc3f410edacf3a077ce99f4a80) - improve error msg for PIVOT with missing aggregation *(commit by [@georgesittas](https://github.com/georgesittas))*


## [v27.0.0] - 2025-07-07
### :boom: BREAKING CHANGES
- due to [`f2bf000`](https://github.com/tobymao/sqlglot/commit/f2bf000a410fb18531bb90ef1d767baf0e8bce7a) - avoid creating new alias for qualifying unpivot *(PR [#5121](https://github.com/tobymao/sqlglot/pull/5121) by [@geooo109](https://github.com/geooo109))*:

  avoid creating new alias for qualifying unpivot (#5121)

- due to [`a126ce8`](https://github.com/tobymao/sqlglot/commit/a126ce8a25287cf3531d815035fa3d567dc772fb) - make coalesce simplification optional, skip by default *(PR [#5123](https://github.com/tobymao/sqlglot/pull/5123) by [@barakalon](https://github.com/barakalon))*:

  make coalesce simplification optional, skip by default (#5123)

- due to [`6910744`](https://github.com/tobymao/sqlglot/commit/6910744e6260793b3f9190782cf60fbbd9adcd38) - update py03 version *(PR [#5136](https://github.com/tobymao/sqlglot/pull/5136) by [@benfdking](https://github.com/benfdking))*:

  update py03 version (#5136)

- due to [`a56deab`](https://github.com/tobymao/sqlglot/commit/a56deabc2b9543209fb5e41f19c3bef89177a577) - bump sqlglotrs to 0.5.0 *(commit by [@georgesittas](https://github.com/georgesittas))*:

  bump sqlglotrs to 0.5.0

- due to [`c484ca3`](https://github.com/tobymao/sqlglot/commit/c484ca39bad750a96b62e2edae85612cac66ba30) - recognize ARRAY_CONCAT_AGG as an aggregate function *(PR [#5141](https://github.com/tobymao/sqlglot/pull/5141) by [@georgesittas](https://github.com/georgesittas))*:

  recognize ARRAY_CONCAT_AGG as an aggregate function (#5141)

- due to [`72ce404`](https://github.com/tobymao/sqlglot/commit/72ce40405625239a0d6763d502e5af8b12abfe9b) - Refactor ALTER TABLE ADD parsing *(PR [#5144](https://github.com/tobymao/sqlglot/pull/5144) by [@VaggelisD](https://github.com/VaggelisD))*:

  Refactor ALTER TABLE ADD parsing (#5144)

- due to [`e73ddb7`](https://github.com/tobymao/sqlglot/commit/e73ddb733b7f120ae74054e6d4dc7d458f59ac50) - preserve TIMESTAMP on roundtrip *(PR [#5145](https://github.com/tobymao/sqlglot/pull/5145) by [@georgesittas](https://github.com/georgesittas))*:

  preserve TIMESTAMP on roundtrip (#5145)

- due to [`f6124c6`](https://github.com/tobymao/sqlglot/commit/f6124c6343f67563fc19f617891ecfc145a642db) - return token vector in `tokenize` even on failure *(PR [#5155](https://github.com/tobymao/sqlglot/pull/5155) by [@georgesittas](https://github.com/georgesittas))*:

  return token vector in `tokenize` even on failure (#5155)

- due to [`64c37f1`](https://github.com/tobymao/sqlglot/commit/64c37f147366fe87ae187996ecb3c9a5afa7c264) - bump sqlglotrs to 0.6.0 *(commit by [@georgesittas](https://github.com/georgesittas))*:

  bump sqlglotrs to 0.6.0

- due to [`434c45b`](https://github.com/tobymao/sqlglot/commit/434c45b547c3a5ea155dc8d7da2baab326eb6d4f) - improve support for ENDSWITH closes [#5170](https://github.com/tobymao/sqlglot/pull/5170) *(commit by [@georgesittas](https://github.com/georgesittas))*:

  improve support for ENDSWITH closes #5170

- due to [`bc001ce`](https://github.com/tobymao/sqlglot/commit/bc001cef4c907d8fa421d3190b4fa91865d9ff6c) - Add support for ANY_VALUE for versions 16+ *(PR [#5179](https://github.com/tobymao/sqlglot/pull/5179) by [@VaggelisD](https://github.com/VaggelisD))*:

  Add support for ANY_VALUE for versions 16+ (#5179)

- due to [`6a2cb39`](https://github.com/tobymao/sqlglot/commit/6a2cb39d0ceec091dc4fc228f26d4f457729a3cf) - virtual column with AS(expr) as ComputedColumnConstraint *(PR [#5180](https://github.com/tobymao/sqlglot/pull/5180) by [@geooo109](https://github.com/geooo109))*:

  virtual column with AS(expr) as ComputedColumnConstraint (#5180)

- due to [`29e2f1d`](https://github.com/tobymao/sqlglot/commit/29e2f1d89c095c9fab0944a6962c99bd745c2c91) - Array_intersection transpilation support *(PR [#5186](https://github.com/tobymao/sqlglot/pull/5186) by [@HarishRavi96](https://github.com/HarishRavi96))*:

  Array_intersection transpilation support (#5186)

- due to [`ac6555b`](https://github.com/tobymao/sqlglot/commit/ac6555b4d6c162ef7b14b63307d01fd560138ea0) - preserve DIV binary operator, fixes [#5198](https://github.com/tobymao/sqlglot/pull/5198) *(PR [#5199](https://github.com/tobymao/sqlglot/pull/5199) by [@georgesittas](https://github.com/georgesittas))*:

  preserve DIV binary operator, fixes #5198 (#5199)

- due to [`dfdd84b`](https://github.com/tobymao/sqlglot/commit/dfdd84bbc50da70f40a17b39935f8171d961f7d2) - CTEs instead of subqueries for pipe syntax *(PR [#5205](https://github.com/tobymao/sqlglot/pull/5205) by [@geooo109](https://github.com/geooo109))*:

  CTEs instead of subqueries for pipe syntax (#5205)

- due to [`5f95299`](https://github.com/tobymao/sqlglot/commit/5f9529940d83e89704f7d25eda63cd73fdb503ae) - support multi-part (>3) dotted functions *(PR [#5211](https://github.com/tobymao/sqlglot/pull/5211) by [@georgesittas](https://github.com/georgesittas))*:

  support multi-part (>3) dotted functions (#5211)

- due to [`02afa2a`](https://github.com/tobymao/sqlglot/commit/02afa2a1941fc67086d50dffac2857262f1c3c4f) - Preserve quoting for UDT *(PR [#5216](https://github.com/tobymao/sqlglot/pull/5216) by [@VaggelisD](https://github.com/VaggelisD))*:

  Preserve quoting for UDT (#5216)

- due to [`44297f1`](https://github.com/tobymao/sqlglot/commit/44297f1c5c8c2cb16fe77c318312f417b4281708) - JOIN pipe syntax, Set Operators as CTEs *(PR [#5215](https://github.com/tobymao/sqlglot/pull/5215) by [@geooo109](https://github.com/geooo109))*:

  JOIN pipe syntax, Set Operators as CTEs (#5215)

- due to [`4f42d95`](https://github.com/tobymao/sqlglot/commit/4f42d951363f8c43a4c414dc21d0505d9c8e48bf) - Normalize date parts in `exp.Extract` generation *(PR [#5229](https://github.com/tobymao/sqlglot/pull/5229) by [@VaggelisD](https://github.com/VaggelisD))*:

  Normalize date parts in `exp.Extract` generation (#5229)

- due to [`e7e38fe`](https://github.com/tobymao/sqlglot/commit/e7e38fe0e09f9affbff4ffa7023d0161e3a1ee49) - resolve table "columns" in bigquery that produce structs *(PR [#5230](https://github.com/tobymao/sqlglot/pull/5230) by [@georgesittas](https://github.com/georgesittas))*:

  resolve table "columns" in bigquery that produce structs (#5230)

- due to [`d3dc761`](https://github.com/tobymao/sqlglot/commit/d3dc761393146357a5d20c4d7992fd2a1ae5e6e2) - change comma to cross join when precedence is the same for all join types *(PR [#5240](https://github.com/tobymao/sqlglot/pull/5240) by [@georgesittas](https://github.com/georgesittas))*:

  change comma to cross join when precedence is the same for all join types (#5240)

- due to [`e7c217e`](https://github.com/tobymao/sqlglot/commit/e7c217ef08e5811e7dad2b3d26dbaa9f02114e38) - transpile from/to dbms_random.value *(PR [#5242](https://github.com/tobymao/sqlglot/pull/5242) by [@georgesittas](https://github.com/georgesittas))*:

  transpile from/to dbms_random.value (#5242)

- due to [`31814cd`](https://github.com/tobymao/sqlglot/commit/31814cddb0cf65caf29fbc45a31a9c865b7991c7) - cast constructed timestamp literal to zone-aware type if needed *(PR [#5253](https://github.com/tobymao/sqlglot/pull/5253) by [@georgesittas](https://github.com/georgesittas))*:

  cast constructed timestamp literal to zone-aware type if needed (#5253)

- due to [`db4e0ec`](https://github.com/tobymao/sqlglot/commit/db4e0ece950a6a1f543d8ecad48a7d4b1d6872be) - convert information schema keywords to uppercase for consistency *(PR [#5263](https://github.com/tobymao/sqlglot/pull/5263) by [@mattiasthalen](https://github.com/mattiasthalen))*:

  convert information schema keywords to uppercase for consistency (#5263)

- due to [`eea1570`](https://github.com/tobymao/sqlglot/commit/eea1570ba530517a95699092ccd9ce6a856f5e84) - add support for SYSDATETIMEOFFSET closes [#5272](https://github.com/tobymao/sqlglot/pull/5272) *(PR [#5273](https://github.com/tobymao/sqlglot/pull/5273) by [@georgesittas](https://github.com/georgesittas))*:

  add support for SYSDATETIMEOFFSET closes #5272 (#5273)

- due to [`3d3ccc5`](https://github.com/tobymao/sqlglot/commit/3d3ccc52a40536b9ac4e974f1592dffe5a7568f9) - Transpile exp.PosExplode pos column alias *(PR [#5274](https://github.com/tobymao/sqlglot/pull/5274) by [@VaggelisD](https://github.com/VaggelisD))*:

  Transpile exp.PosExplode pos column alias (#5274)

- due to [`9a95af1`](https://github.com/tobymao/sqlglot/commit/9a95af1c725cd70ffa8206f1d88452a7faab93b2) - only cast strings to timestamp for TO_CHAR (TimeToStr) *(PR [#5283](https://github.com/tobymao/sqlglot/pull/5283) by [@georgesittas](https://github.com/georgesittas))*:

  only cast strings to timestamp for TO_CHAR (TimeToStr) (#5283)

- due to [`8af4790`](https://github.com/tobymao/sqlglot/commit/8af479017ccde16049c897ae5d322d4a69843b65) - Fix parsing of ADD CONSTRAINT *(PR [#5288](https://github.com/tobymao/sqlglot/pull/5288) by [@VaggelisD](https://github.com/VaggelisD))*:

  Fix parsing of ADD CONSTRAINT (#5288)

- due to [`18aea08`](https://github.com/tobymao/sqlglot/commit/18aea08f7dcaa887bcf29886cd3b3bc2850a3679) - include bigquery unnest aliases in selected sources *(PR [#5285](https://github.com/tobymao/sqlglot/pull/5285) by [@georgesittas](https://github.com/georgesittas))*:

  include bigquery unnest aliases in selected sources (#5285)

- due to [`0ff95c5`](https://github.com/tobymao/sqlglot/commit/0ff95c5903907c9ab30b7850bb3b962bc6da2bab) - add parsing/transpilation support for the REPLACE function *(PR [#5289](https://github.com/tobymao/sqlglot/pull/5289) by [@rahulj51](https://github.com/rahulj51))*:

  add parsing/transpilation support for the REPLACE function (#5289)

- due to [`dc03649`](https://github.com/tobymao/sqlglot/commit/dc03649bca0b7a090254976182a03c21dd2269ba) - only coerce time var -like units into strings for DATE_TRUNC *(PR [#5291](https://github.com/tobymao/sqlglot/pull/5291) by [@georgesittas](https://github.com/georgesittas))*:

  only coerce time var -like units into strings for DATE_TRUNC (#5291)

- due to [`5724538`](https://github.com/tobymao/sqlglot/commit/5724538f278b2178114b88850251afd7c3db0dda) - ARRAY_CONCAT type annotation *(PR [#5293](https://github.com/tobymao/sqlglot/pull/5293) by [@geooo109](https://github.com/geooo109))*:

  ARRAY_CONCAT type annotation (#5293)

- due to [`c103b23`](https://github.com/tobymao/sqlglot/commit/c103b2304dca552ac8cf6733156db8b59d3614f3) - add support for `SUBSTRING_INDEX` *(PR [#5296](https://github.com/tobymao/sqlglot/pull/5296) by [@ankur334](https://github.com/ankur334))*:

  add support for `SUBSTRING_INDEX` (#5296)

- due to [`a7bd823`](https://github.com/tobymao/sqlglot/commit/a7bd8234e0dd02abfe6fa56287e7bda14a549e5a) - annotate type of ARRAY_TO_STRING *(PR [#5301](https://github.com/tobymao/sqlglot/pull/5301) by [@geooo109](https://github.com/geooo109))*:

  annotate type of ARRAY_TO_STRING (#5301)

- due to [`6b42353`](https://github.com/tobymao/sqlglot/commit/6b4235340a2e432015c27b2aeadbdcb930bfa6b0) - annotate type of ARRAY_FIRST, ARRAY_LAST *(PR [#5303](https://github.com/tobymao/sqlglot/pull/5303) by [@geooo109](https://github.com/geooo109))*:

  annotate type of ARRAY_FIRST, ARRAY_LAST (#5303)

- due to [`db9b61e`](https://github.com/tobymao/sqlglot/commit/db9b61e4ecaa0600418eb90f637fb8b06b08c399) - parse, annotate type for ARRAY_REVERSE *(PR [#5306](https://github.com/tobymao/sqlglot/pull/5306) by [@geooo109](https://github.com/geooo109))*:

  parse, annotate type for ARRAY_REVERSE (#5306)

- due to [`5612a6d`](https://github.com/tobymao/sqlglot/commit/5612a6da6dee3545f3600db1e5b87c9450952eba) - add support for SPACE *(PR [#5308](https://github.com/tobymao/sqlglot/pull/5308) by [@ankur334](https://github.com/ankur334))*:

  add support for SPACE (#5308)

- due to [`8a2f65d`](https://github.com/tobymao/sqlglot/commit/8a2f65d6b2b68ad5ba45a5aed5e56c4dc0fea6fc) - parse and annotate type for ARRAY_SLICE *(PR [#5312](https://github.com/tobymao/sqlglot/pull/5312) by [@geooo109](https://github.com/geooo109))*:

  parse and annotate type for ARRAY_SLICE (#5312)

- due to [`8d118ea`](https://github.com/tobymao/sqlglot/commit/8d118ead9c15e7b2b4b51b7cf93cab94e61c2625) - route statements to hive/trino depending on their type *(PR [#5314](https://github.com/tobymao/sqlglot/pull/5314) by [@georgesittas](https://github.com/georgesittas))*:

  route statements to hive/trino depending on their type (#5314)

- due to [`d2f7c41`](https://github.com/tobymao/sqlglot/commit/d2f7c41f9f30f4cf0c74782be9be0cc6e75565f3) - add TypeOf / toTypeName support *(PR [#5315](https://github.com/tobymao/sqlglot/pull/5315) by [@ankur334](https://github.com/ankur334))*:

  add TypeOf / toTypeName support (#5315)

- due to [`5a0f589`](https://github.com/tobymao/sqlglot/commit/5a0f589a0fdb6743c3be2f98b74a34780f51332b) - distinguish STORED AS from USING *(PR [#5320](https://github.com/tobymao/sqlglot/pull/5320) by [@geooo109](https://github.com/geooo109))*:

  distinguish STORED AS from USING (#5320)

- due to [`c4ca182`](https://github.com/tobymao/sqlglot/commit/c4ca182ad637b7a22b55d0ecf320c5a09ec5d56c) - annotate type for FROM_BASE64 *(PR [#5329](https://github.com/tobymao/sqlglot/pull/5329) by [@geooo109](https://github.com/geooo109))*:

  annotate type for FROM_BASE64 (#5329)

- due to [`7b72bbe`](https://github.com/tobymao/sqlglot/commit/7b72bbed3a0930e11ce4a0fdd9082de715326ac9) - annotate type for ANY_VALUE *(PR [#5331](https://github.com/tobymao/sqlglot/pull/5331) by [@geooo109](https://github.com/geooo109))*:

  annotate type for ANY_VALUE (#5331)

- due to [`c0d57e7`](https://github.com/tobymao/sqlglot/commit/c0d57e747bf5d2bed7ba2007ac2092d5797ee038) - annotate type for CHR *(PR [#5332](https://github.com/tobymao/sqlglot/pull/5332) by [@geooo109](https://github.com/geooo109))*:

  annotate type for CHR (#5332)

- due to [`d65b5c2`](https://github.com/tobymao/sqlglot/commit/d65b5c22c29416007cca0154fd35f1d4b5efc929) - annotate type for COUNTIF *(PR [#5334](https://github.com/tobymao/sqlglot/pull/5334) by [@geooo109](https://github.com/geooo109))*:

  annotate type for COUNTIF (#5334)

- due to [`521b705`](https://github.com/tobymao/sqlglot/commit/521b7053213df8577f609409af2552c2ff4fd8c9) - annotate type for GENERATE_ARRAY *(PR [#5335](https://github.com/tobymao/sqlglot/pull/5335) by [@geooo109](https://github.com/geooo109))*:

  annotate type for GENERATE_ARRAY (#5335)

- due to [`5fb26c5`](https://github.com/tobymao/sqlglot/commit/5fb26c58026018360f36a732394b612a3baac38b) - annotate type for INT64 *(PR [#5339](https://github.com/tobymao/sqlglot/pull/5339) by [@geooo109](https://github.com/geooo109))*:

  annotate type for INT64 (#5339)

- due to [`cff9b55`](https://github.com/tobymao/sqlglot/commit/cff9b55d70a3b85057e6385c93c0814eaa50f40b) - annotate type for LOGICAL_AND and LOGICAL_OR *(PR [#5340](https://github.com/tobymao/sqlglot/pull/5340) by [@geooo109](https://github.com/geooo109))*:

  annotate type for LOGICAL_AND and LOGICAL_OR (#5340)

- due to [`b94a6f9`](https://github.com/tobymao/sqlglot/commit/b94a6f9228aa730296c3152179bfbf3503521063) - annotate type for MAKE_INTERVAL *(PR [#5341](https://github.com/tobymao/sqlglot/pull/5341) by [@geooo109](https://github.com/geooo109))*:

  annotate type for MAKE_INTERVAL (#5341)

- due to [`2c9a7c6`](https://github.com/tobymao/sqlglot/commit/2c9a7c6f0b097a9e8514fc5e2af21c52f145920c) - annotate type for LAST_VALUE *(PR [#5336](https://github.com/tobymao/sqlglot/pull/5336) by [@geooo109](https://github.com/geooo109))*:

  annotate type for LAST_VALUE (#5336)

- due to [`d862a28`](https://github.com/tobymao/sqlglot/commit/d862a28b0a30f0c5774351f38a61f195120ad904) - annoate type for TO_BASE64 *(PR [#5342](https://github.com/tobymao/sqlglot/pull/5342) by [@geooo109](https://github.com/geooo109))*:

  annoate type for TO_BASE64 (#5342)

- due to [`85888c1`](https://github.com/tobymao/sqlglot/commit/85888c1b7cbbd0eee179d902a54fbd2a899cc16b) - annotate type for UNIX_DATE *(PR [#5343](https://github.com/tobymao/sqlglot/pull/5343) by [@geooo109](https://github.com/geooo109))*:

  annotate type for UNIX_DATE (#5343)

- due to [`8a214e0`](https://github.com/tobymao/sqlglot/commit/8a214e0859dfb715fcef0dd6b2d6392012b1f3fb) - annotate type for UNIX_SECONDS *(PR [#5344](https://github.com/tobymao/sqlglot/pull/5344) by [@geooo109](https://github.com/geooo109))*:

  annotate type for UNIX_SECONDS (#5344)

- due to [`625cb74`](https://github.com/tobymao/sqlglot/commit/625cb74b69e99ea1a707549366ea960d759848c9) - annotate type for STARTS_WITH *(PR [#5345](https://github.com/tobymao/sqlglot/pull/5345) by [@geooo109](https://github.com/geooo109))*:

  annotate type for STARTS_WITH (#5345)

- due to [`0337c4d`](https://github.com/tobymao/sqlglot/commit/0337c4d46e9e85d951fc9565a47e338106543711) - annotate type for SHA and SHA2 *(PR [#5346](https://github.com/tobymao/sqlglot/pull/5346) by [@geooo109](https://github.com/geooo109))*:

  annotate type for SHA and SHA2 (#5346)

- due to [`cc389fa`](https://github.com/tobymao/sqlglot/commit/cc389facb33f94a0d1f696f2ef9e92f298711894) - annotate type SHA1, SHA256, SHA512 for BigQuery *(PR [#5347](https://github.com/tobymao/sqlglot/pull/5347) by [@geooo109](https://github.com/geooo109))*:

  annotate type SHA1, SHA256, SHA512 for BigQuery (#5347)

- due to [`509b741`](https://github.com/tobymao/sqlglot/commit/509b74173f678842e7550c75c4d8d906c879fb12) - preserve multi-arg DECODE function instead of converting to CASE *(PR [#5352](https://github.com/tobymao/sqlglot/pull/5352) by [@georgesittas](https://github.com/georgesittas))*:

  preserve multi-arg DECODE function instead of converting to CASE (#5352)

- due to [`c1d3d61`](https://github.com/tobymao/sqlglot/commit/c1d3d61d00f00d2030107689d8704f7a488a80a7) - annotate type for CORR *(PR [#5364](https://github.com/tobymao/sqlglot/pull/5364) by [@geooo109](https://github.com/geooo109))*:

  annotate type for CORR (#5364)

- due to [`c1e8677`](https://github.com/tobymao/sqlglot/commit/c1e867767a006e774a2c200c10eb85b3fbd8a372) - annotate type for COVAR_POP *(PR [#5365](https://github.com/tobymao/sqlglot/pull/5365) by [@geooo109](https://github.com/geooo109))*:

  annotate type for COVAR_POP (#5365)

- due to [`e110ef4`](https://github.com/tobymao/sqlglot/commit/e110ef4f774e6ab8de6d4c86e5d306ab53fe895b) - annotate type for COVAR_SAMP *(PR [#5367](https://github.com/tobymao/sqlglot/pull/5367) by [@geooo109](https://github.com/geooo109))*:

  annotate type for COVAR_SAMP (#5367)

- due to [`5b59c16`](https://github.com/tobymao/sqlglot/commit/5b59c16528fb1904c64bef0ca6307bb6a95e5a2c) - annotate type for DATETIME *(PR [#5369](https://github.com/tobymao/sqlglot/pull/5369) by [@geooo109](https://github.com/geooo109))*:

  annotate type for DATETIME (#5369)

- due to [`47176ce`](https://github.com/tobymao/sqlglot/commit/47176ce6b9a4c1722f285034b08a6ae782129894) - annotate type for ENDS_WITH *(PR [#5370](https://github.com/tobymao/sqlglot/pull/5370) by [@geooo109](https://github.com/geooo109))*:

  annotate type for ENDS_WITH (#5370)

- due to [`2cce53d`](https://github.com/tobymao/sqlglot/commit/2cce53d59968f0a4bb3e9599ade93b0e6a140c68) - annotate type for LAG *(PR [#5371](https://github.com/tobymao/sqlglot/pull/5371) by [@geooo109](https://github.com/geooo109))*:

  annotate type for LAG (#5371)

- due to [`a3227de`](https://github.com/tobymao/sqlglot/commit/a3227de3fc57d559eb899dec08af01f85b470ce4) - improve transpilation of `ROUND(x, y)` to Postgres *(PR [#5368](https://github.com/tobymao/sqlglot/pull/5368) by [@blecourt-private](https://github.com/blecourt-private))*:

  improve transpilation of `ROUND(x, y)` to Postgres (#5368)


### :sparkles: New Features
- [`82c50ce`](https://github.com/tobymao/sqlglot/commit/82c50ce68d9a1ad25095086ae3645f5c4996c18b) - **duckdb**: extend time travel parsing to take VERSION into account *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`bb4f428`](https://github.com/tobymao/sqlglot/commit/bb4f4283b53bc060a8c7e0f12c1e7ef5b521c4e6) - bubble up comments nested under a Bracket, fixes [#5131](https://github.com/tobymao/sqlglot/pull/5131) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`9f318eb`](https://github.com/tobymao/sqlglot/commit/9f318ebe4502bb484a34873252cf4a40c7e440e4) - **snowflake**: Transpile BQ's `ARRAY(SELECT AS STRUCT ...)` *(PR [#5140](https://github.com/tobymao/sqlglot/pull/5140) by [@VaggelisD](https://github.com/VaggelisD))*
- [`93b402a`](https://github.com/tobymao/sqlglot/commit/93b402abc74e642ed312db585b33315674a450cd) - **parser**: support SELECT, FROM, WHERE with pipe syntax *(PR [#5128](https://github.com/tobymao/sqlglot/pull/5128) by [@geooo109](https://github.com/geooo109))*
- [`1a8e78b`](https://github.com/tobymao/sqlglot/commit/1a8e78bd84e006023d5d3ea561504587dfbb55a9) - **parser**: ORDER BY with pipe syntax *(PR [#5153](https://github.com/tobymao/sqlglot/pull/5153) by [@geooo109](https://github.com/geooo109))*
- [`966ad95`](https://github.com/tobymao/sqlglot/commit/966ad95432d5f8e29ade36d8271a5c489c207324) - **tsql**: add convert style 126 *(PR [#5157](https://github.com/tobymao/sqlglot/pull/5157) by [@pa1ch](https://github.com/pa1ch))*
- [`b7ac6ff`](https://github.com/tobymao/sqlglot/commit/b7ac6ff4680ff619be4b0ddb01f61f916ed09d58) - **parser**: LIMIT/OFFSET pipe syntax *(PR [#5159](https://github.com/tobymao/sqlglot/pull/5159) by [@geooo109](https://github.com/geooo109))*
- [`cfc158d`](https://github.com/tobymao/sqlglot/commit/cfc158d753d4f43d12c3b502633d29e43dcc5569) - **snowflake**: transpile STRTOK_TO_ARRAY to duckdb *(PR [#5165](https://github.com/tobymao/sqlglot/pull/5165) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *addresses issue [#5160](https://github.com/tobymao/sqlglot/issues/5160) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`ff0f30b`](https://github.com/tobymao/sqlglot/commit/ff0f30bcf7d0d74b26a703eaa632e1be15b3c001) - support ARRAY_REMOVE *(PR [#5163](https://github.com/tobymao/sqlglot/pull/5163) by [@geooo109](https://github.com/geooo109))*
- [`9cac01f`](https://github.com/tobymao/sqlglot/commit/9cac01f6b4a5c93b55f5b68f21cb104932880a0e) - **tsql**: support FOR XML syntax *(PR [#5167](https://github.com/tobymao/sqlglot/pull/5167) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *addresses issue [#5161](https://github.com/tobymao/sqlglot/issues/5161) opened by [@codykonior](https://github.com/codykonior)*
- [`8b5129f`](https://github.com/tobymao/sqlglot/commit/8b5129f288880032f0bf9d649984d82314039af1) - **postgres**: improve pretty-formatting of ARRAY[...] *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`964b4a1`](https://github.com/tobymao/sqlglot/commit/964b4a1e367e00e243b80edf677cd48d453ed31e) - add line/col position for Star *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`434c45b`](https://github.com/tobymao/sqlglot/commit/434c45b547c3a5ea155dc8d7da2baab326eb6d4f) - improve support for ENDSWITH closes [#5170](https://github.com/tobymao/sqlglot/pull/5170) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`63f9cb4`](https://github.com/tobymao/sqlglot/commit/63f9cb4b158b88574136b32241ee60254352c9e6) - **sqlglotrs**: match the Python implementation of __repr__ for tokens *(PR [#5172](https://github.com/tobymao/sqlglot/pull/5172) by [@georgesittas](https://github.com/georgesittas))*
- [`c007afa`](https://github.com/tobymao/sqlglot/commit/c007afa23831e9bd86f401d85260e15edf00328f) - support Star instance as first arg of exp.column helper *(PR [#5177](https://github.com/tobymao/sqlglot/pull/5177) by [@georgesittas](https://github.com/georgesittas))*
- [`bc001ce`](https://github.com/tobymao/sqlglot/commit/bc001cef4c907d8fa421d3190b4fa91865d9ff6c) - **postgres**: Add support for ANY_VALUE for versions 16+ *(PR [#5179](https://github.com/tobymao/sqlglot/pull/5179) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#4674](https://github.com/TobikoData/sqlmesh/issues/4674) opened by [@petrikoro](https://github.com/petrikoro)*
- [`ba05ff6`](https://github.com/tobymao/sqlglot/commit/ba05ff67127e056d567fc2c1d3bcc8e3dcce7b7e) - **parser**: AGGREGATE with GROUP AND ORDER BY pipe syntax *(PR [#5171](https://github.com/tobymao/sqlglot/pull/5171) by [@geooo109](https://github.com/geooo109))*
- [`26077a4`](https://github.com/tobymao/sqlglot/commit/26077a47d9db750f44ab1baf9a434596b5bb613b) - make to_table more lenient *(PR [#5183](https://github.com/tobymao/sqlglot/pull/5183) by [@georgesittas](https://github.com/georgesittas))*
- [`29e2f1d`](https://github.com/tobymao/sqlglot/commit/29e2f1d89c095c9fab0944a6962c99bd745c2c91) - Array_intersection transpilation support *(PR [#5186](https://github.com/tobymao/sqlglot/pull/5186) by [@HarishRavi96](https://github.com/HarishRavi96))*
- [`d86a114`](https://github.com/tobymao/sqlglot/commit/d86a1147aeb866ed0ab2c342914ecf8cbfadac8a) - **sqlite**: implement RESPECT/IGNORE NULLS in first_value() *(PR [#5185](https://github.com/tobymao/sqlglot/pull/5185) by [@NickCrews](https://github.com/NickCrews))*
- [`1d50fca`](https://github.com/tobymao/sqlglot/commit/1d50fca8ffc34e4acbc1b791c4cdf5f184a748db) - improve transpilation of st_point and st_distance *(PR [#5194](https://github.com/tobymao/sqlglot/pull/5194) by [@georgesittas](https://github.com/georgesittas))*
- [`756ec3b`](https://github.com/tobymao/sqlglot/commit/756ec3b65db1eb2572d017a3ac12ece6bb44c726) - **parser**: SET OPERATORS with pipe syntax *(PR [#5184](https://github.com/tobymao/sqlglot/pull/5184) by [@geooo109](https://github.com/geooo109))*
- [`c20f85e`](https://github.com/tobymao/sqlglot/commit/c20f85e3e171e502fc51f74894d3313f0ad61535) - **spark**: support ALTER ADD PARTITION *(PR [#5208](https://github.com/tobymao/sqlglot/pull/5208) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#5204](https://github.com/tobymao/sqlglot/issues/5204) opened by [@cosinequanon](https://github.com/cosinequanon)*
- [`44297f1`](https://github.com/tobymao/sqlglot/commit/44297f1c5c8c2cb16fe77c318312f417b4281708) - **parser**: JOIN pipe syntax, Set Operators as CTEs *(PR [#5215](https://github.com/tobymao/sqlglot/pull/5215) by [@geooo109](https://github.com/geooo109))*
- [`21cd3eb`](https://github.com/tobymao/sqlglot/commit/21cd3ebf5d0b57f5b102c5aadc3b24a598ebe918) - **parser**: PIVOT/UNPIVOT pipe syntax *(PR [#5222](https://github.com/tobymao/sqlglot/pull/5222) by [@geooo109](https://github.com/geooo109))*
- [`97f5822`](https://github.com/tobymao/sqlglot/commit/97f58226fc8815b23787b7b8699ea71f58268560) - **parser**: AS pipe syntax *(PR [#5224](https://github.com/tobymao/sqlglot/pull/5224) by [@geooo109](https://github.com/geooo109))*
- [`a7e7fee`](https://github.com/tobymao/sqlglot/commit/a7e7feef02a77fe8606f3f482bad91230fa637f4) - **parser**: EXTEND pipe syntax *(PR [#5225](https://github.com/tobymao/sqlglot/pull/5225) by [@geooo109](https://github.com/geooo109))*
- [`c1cb9f8`](https://github.com/tobymao/sqlglot/commit/c1cb9f8f682080f7a06c387219d79c6d068b6dbe) - **snowflake**: add autoincrement order clause support *(PR [#5223](https://github.com/tobymao/sqlglot/pull/5223) by [@dmaresma](https://github.com/dmaresma))*
- [`91afe4c`](https://github.com/tobymao/sqlglot/commit/91afe4cfd7b3f427e4c0b298075e867b8a1bbe55) - **parser**: TABLESAMPLE pipe syntax *(PR [#5231](https://github.com/tobymao/sqlglot/pull/5231) by [@geooo109](https://github.com/geooo109))*
- [`62da84a`](https://github.com/tobymao/sqlglot/commit/62da84acce7f44802dca26a9357a16115e21fabf) - **snowflake**: improve transpilation of unnested object lookup *(PR [#5234](https://github.com/tobymao/sqlglot/pull/5234) by [@georgesittas](https://github.com/georgesittas))*
- [`2c60453`](https://github.com/tobymao/sqlglot/commit/2c604537ba83dee74e9ced7e216673ecc70fe487) - **parser**: DROP pipe syntax *(PR [#5226](https://github.com/tobymao/sqlglot/pull/5226) by [@geooo109](https://github.com/geooo109))*
- [`9885729`](https://github.com/tobymao/sqlglot/commit/988572954135c68dc021b992c815024ce3debaff) - **parser**: SET pipe syntax *(PR [#5236](https://github.com/tobymao/sqlglot/pull/5236) by [@geooo109](https://github.com/geooo109))*
- [`e7c217e`](https://github.com/tobymao/sqlglot/commit/e7c217ef08e5811e7dad2b3d26dbaa9f02114e38) - **oracle**: transpile from/to dbms_random.value *(PR [#5242](https://github.com/tobymao/sqlglot/pull/5242) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#5241](https://github.com/tobymao/sqlglot/issues/5241) opened by [@Akshat-2512](https://github.com/Akshat-2512)*
- [`0d19544`](https://github.com/tobymao/sqlglot/commit/0d19544317c1056b17fb089d4be9b5bddfe6feb3) - add Microsoft Fabric dialect, a case sensitive version of TSQL *(PR [#5247](https://github.com/tobymao/sqlglot/pull/5247) by [@mattiasthalen](https://github.com/mattiasthalen))*
- [`249dbc9`](https://github.com/tobymao/sqlglot/commit/249dbc906adc6b20932dc8efe83f6f4d23ef8c1e) - **parser**: start with SELECT and nested pipe syntax *(PR [#5248](https://github.com/tobymao/sqlglot/pull/5248) by [@geooo109](https://github.com/geooo109))*
- [`f5b5b93`](https://github.com/tobymao/sqlglot/commit/f5b5b9338eb92b7aa2c9b4c92c6138c2c05e1c40) - **fabric**: implement type mappings for unsupported Fabric types *(PR [#5249](https://github.com/tobymao/sqlglot/pull/5249) by [@mattiasthalen](https://github.com/mattiasthalen))*
- [`78fcea1`](https://github.com/tobymao/sqlglot/commit/78fcea13b5eb1734a15a254875bc80ad8063b0b0) - **spark, databricks**: parse brackets as placeholder *(PR [#5256](https://github.com/tobymao/sqlglot/pull/5256) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *addresses issue [#5251](https://github.com/tobymao/sqlglot/issues/5251) opened by [@aersam](https://github.com/aersam)*
- [`7d71387`](https://github.com/tobymao/sqlglot/commit/7d7138780db82e7a75949d29282b944e739ad99d) - **fabric**: Add precision cap to temporal data types *(PR [#5250](https://github.com/tobymao/sqlglot/pull/5250) by [@mattiasthalen](https://github.com/mattiasthalen))*
- [`e8cf793`](https://github.com/tobymao/sqlglot/commit/e8cf79305d398f25640ef3c07dd8b32997cb0167) - **duckdb**: Transpile Snowflake's TO_CHAR if format is in Snowflake.TIME_MAPPING *(PR [#5257](https://github.com/tobymao/sqlglot/pull/5257) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5255](https://github.com/tobymao/sqlglot/issues/5255) opened by [@kyle-cheung](https://github.com/kyle-cheung)*
- [`0cdfe64`](https://github.com/tobymao/sqlglot/commit/0cdfe642e3cb996c5ac48cc055af2862340dcf56) - add Exasol dialect (pass 1: string type mapping) *(PR [#5264](https://github.com/tobymao/sqlglot/pull/5264) by [@nnamdi16](https://github.com/nnamdi16))*
- [`eea1570`](https://github.com/tobymao/sqlglot/commit/eea1570ba530517a95699092ccd9ce6a856f5e84) - **tsql**: add support for SYSDATETIMEOFFSET closes [#5272](https://github.com/tobymao/sqlglot/pull/5272) *(PR [#5273](https://github.com/tobymao/sqlglot/pull/5273) by [@georgesittas](https://github.com/georgesittas))*
- [`3d3ccc5`](https://github.com/tobymao/sqlglot/commit/3d3ccc52a40536b9ac4e974f1592dffe5a7568f9) - **hive**: Transpile exp.PosExplode pos column alias *(PR [#5274](https://github.com/tobymao/sqlglot/pull/5274) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5271](https://github.com/tobymao/sqlglot/issues/5271) opened by [@charlie-liner](https://github.com/charlie-liner)*
- [`1c48c09`](https://github.com/tobymao/sqlglot/commit/1c48c09fd836db40bba6c46d0e9969937ce96587) - **exasol**: added datatype mappings and test for exasol dialect. *(PR [#5270](https://github.com/tobymao/sqlglot/pull/5270) by [@nnamdi16](https://github.com/nnamdi16))*
- [`883fcb1`](https://github.com/tobymao/sqlglot/commit/883fcb137583f6d36f3a70a1343780bb40bf6f81) - **databricks**: GROUP_CONCAT to LISTAGG *(PR [#5284](https://github.com/tobymao/sqlglot/pull/5284) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *addresses issue [#5281](https://github.com/tobymao/sqlglot/issues/5281) opened by [@wKollendorf](https://github.com/wKollendorf)*
- [`21ef897`](https://github.com/tobymao/sqlglot/commit/21ef8974426d9f3562ade0bd2c8448bb440bee27) - **fabric**: implement UnixToTime transformation to DATEADD syntax *(PR [#5269](https://github.com/tobymao/sqlglot/pull/5269) by [@mattiasthalen](https://github.com/mattiasthalen))*
- [`0ff95c5`](https://github.com/tobymao/sqlglot/commit/0ff95c5903907c9ab30b7850bb3b962bc6da2bab) - add parsing/transpilation support for the REPLACE function *(PR [#5289](https://github.com/tobymao/sqlglot/pull/5289) by [@rahulj51](https://github.com/rahulj51))*
- [`1b0631c`](https://github.com/tobymao/sqlglot/commit/1b0631c2b4516a9ceb81af6173790dd09269b635) - **exasol**: implemented the Mod function *(PR [#5292](https://github.com/tobymao/sqlglot/pull/5292) by [@nnamdi16](https://github.com/nnamdi16))*
- [`ba7bf39`](https://github.com/tobymao/sqlglot/commit/ba7bf39966b519e11cde02a3c1f720598469e616) - **exasol**: implemented BIT_AND function with test *(PR [#5294](https://github.com/tobymao/sqlglot/pull/5294) by [@nnamdi16](https://github.com/nnamdi16))*
- [`fb4122e`](https://github.com/tobymao/sqlglot/commit/fb4122e80d1995bb87401e9ebe3749078c026a06) - **exasol**: add bitwiseOr function to exasol dialect *(PR [#5297](https://github.com/tobymao/sqlglot/pull/5297) by [@nnamdi16](https://github.com/nnamdi16))*
- [`c103b23`](https://github.com/tobymao/sqlglot/commit/c103b2304dca552ac8cf6733156db8b59d3614f3) - add support for `SUBSTRING_INDEX` *(PR [#5296](https://github.com/tobymao/sqlglot/pull/5296) by [@ankur334](https://github.com/ankur334))*
- [`4752f3a`](https://github.com/tobymao/sqlglot/commit/4752f3a6b715d8b6968c8f1f05f6ccdfb7351071) - **exasol**: added bit_xor built in exasol function to exasol dialect in sqlglot *(PR [#5298](https://github.com/tobymao/sqlglot/pull/5298) by [@nnamdi16](https://github.com/nnamdi16))*
- [`09bd610`](https://github.com/tobymao/sqlglot/commit/09bd6101de21ed86c9fd6df0f63e8bca2666dd81) - **parser**: annotate type of ARRAY_CONCAT_AGG *(PR [#5299](https://github.com/tobymao/sqlglot/pull/5299) by [@geooo109](https://github.com/geooo109))*
- [`ad0311a`](https://github.com/tobymao/sqlglot/commit/ad0311a7f8b0b3c5746c29d816b58578a892dd33) - **exasol**: added bit_not exasol built in function. *(PR [#5300](https://github.com/tobymao/sqlglot/pull/5300) by [@nnamdi16](https://github.com/nnamdi16))*
- [`a7bd823`](https://github.com/tobymao/sqlglot/commit/a7bd8234e0dd02abfe6fa56287e7bda14a549e5a) - **parser**: annotate type of ARRAY_TO_STRING *(PR [#5301](https://github.com/tobymao/sqlglot/pull/5301) by [@geooo109](https://github.com/geooo109))*
- [`2aa2182`](https://github.com/tobymao/sqlglot/commit/2aa21820f7d3a26cc4f47c1c757a9b7c97dd0382) - **exasol**: added BIT_LSHIFT built in function to exasol dialect *(PR [#5302](https://github.com/tobymao/sqlglot/pull/5302) by [@nnamdi16](https://github.com/nnamdi16))*
- [`c3d9ef2`](https://github.com/tobymao/sqlglot/commit/c3d9ef2cb2d004b57c64af4f3f1bac41f1890737) - **exasol**: added the bit_rshift built in exasol function *(PR [#5304](https://github.com/tobymao/sqlglot/pull/5304) by [@nnamdi16](https://github.com/nnamdi16))*
- [`6b42353`](https://github.com/tobymao/sqlglot/commit/6b4235340a2e432015c27b2aeadbdcb930bfa6b0) - **parser**: annotate type of ARRAY_FIRST, ARRAY_LAST *(PR [#5303](https://github.com/tobymao/sqlglot/pull/5303) by [@geooo109](https://github.com/geooo109))*
- [`f5b7cc6`](https://github.com/tobymao/sqlglot/commit/f5b7cc6d2f8d73bff4e42e242d3ad3db41d899cc) - **exasol**: added `EVERY` built in function *(PR [#5305](https://github.com/tobymao/sqlglot/pull/5305) by [@nnamdi16](https://github.com/nnamdi16))*
- [`d3f04d6`](https://github.com/tobymao/sqlglot/commit/d3f04d6766281ecb7ced9a5e812ab765d7b699be) - add Dremio dialect *(PR [#5277](https://github.com/tobymao/sqlglot/pull/5277) by [@mateuszpoleski](https://github.com/mateuszpoleski))*
- [`3d8e478`](https://github.com/tobymao/sqlglot/commit/3d8e478eac3df6a94c87cd610f96c5f19697a9bf) - **exasol**: added edit_distance built in function to exasol dialect *(PR [#5310](https://github.com/tobymao/sqlglot/pull/5310) by [@nnamdi16](https://github.com/nnamdi16))*
- [`db9b61e`](https://github.com/tobymao/sqlglot/commit/db9b61e4ecaa0600418eb90f637fb8b06b08c399) - **parser**: parse, annotate type for ARRAY_REVERSE *(PR [#5306](https://github.com/tobymao/sqlglot/pull/5306) by [@geooo109](https://github.com/geooo109))*
- [`5612a6d`](https://github.com/tobymao/sqlglot/commit/5612a6da6dee3545f3600db1e5b87c9450952eba) - add support for SPACE *(PR [#5308](https://github.com/tobymao/sqlglot/pull/5308) by [@ankur334](https://github.com/ankur334))*
- [`f148c9e`](https://github.com/tobymao/sqlglot/commit/f148c9e64ae0d4df96323271729fa6a6ca68a671) - **duckdb**: Transpile Spark's `exp.PosExplode` *(PR [#5311](https://github.com/tobymao/sqlglot/pull/5311) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5309](https://github.com/tobymao/sqlglot/issues/5309) opened by [@nimrodolev](https://github.com/nimrodolev)*
- [`179a278`](https://github.com/tobymao/sqlglot/commit/179a278c7fdbc29105e37f132e6f03e18627f769) - **exasol**: added the regexp_replace function *(PR [#5313](https://github.com/tobymao/sqlglot/pull/5313) by [@nnamdi16](https://github.com/nnamdi16))*
- [`8a2f65d`](https://github.com/tobymao/sqlglot/commit/8a2f65d6b2b68ad5ba45a5aed5e56c4dc0fea6fc) - **parser**: parse and annotate type for ARRAY_SLICE *(PR [#5312](https://github.com/tobymao/sqlglot/pull/5312) by [@geooo109](https://github.com/geooo109))*
- [`d2f7c41`](https://github.com/tobymao/sqlglot/commit/d2f7c41f9f30f4cf0c74782be9be0cc6e75565f3) - add TypeOf / toTypeName support *(PR [#5315](https://github.com/tobymao/sqlglot/pull/5315) by [@ankur334](https://github.com/ankur334))*
- [`950c15d`](https://github.com/tobymao/sqlglot/commit/950c15db5ff64b6f11036f8003db3e5b1fb3afc3) - **exasol**: add var_pop built in function to exasol dialect *(PR [#5328](https://github.com/tobymao/sqlglot/pull/5328) by [@nnamdi16](https://github.com/nnamdi16))*
- [`c4ca182`](https://github.com/tobymao/sqlglot/commit/c4ca182ad637b7a22b55d0ecf320c5a09ec5d56c) - **optimizer**: annotate type for FROM_BASE64 *(PR [#5329](https://github.com/tobymao/sqlglot/pull/5329) by [@geooo109](https://github.com/geooo109))*
- [`0992e99`](https://github.com/tobymao/sqlglot/commit/0992e99f99aeb4ecc97e6918a23b8fd524311ed9) - **exasol**: Add support  APPROXIMATE_COUNT_DISTINCT functions in exasol dialect *(PR [#5330](https://github.com/tobymao/sqlglot/pull/5330) by [@nnamdi16](https://github.com/nnamdi16))*
- [`7b72bbe`](https://github.com/tobymao/sqlglot/commit/7b72bbed3a0930e11ce4a0fdd9082de715326ac9) - **optimizer**: annotate type for ANY_VALUE *(PR [#5331](https://github.com/tobymao/sqlglot/pull/5331) by [@geooo109](https://github.com/geooo109))*
- [`c0d57e7`](https://github.com/tobymao/sqlglot/commit/c0d57e747bf5d2bed7ba2007ac2092d5797ee038) - **optimizer**: annotate type for CHR *(PR [#5332](https://github.com/tobymao/sqlglot/pull/5332) by [@geooo109](https://github.com/geooo109))*
- [`d65b5c2`](https://github.com/tobymao/sqlglot/commit/d65b5c22c29416007cca0154fd35f1d4b5efc929) - **optimizer**: annotate type for COUNTIF *(PR [#5334](https://github.com/tobymao/sqlglot/pull/5334) by [@geooo109](https://github.com/geooo109))*
- [`521b705`](https://github.com/tobymao/sqlglot/commit/521b7053213df8577f609409af2552c2ff4fd8c9) - **optimizer**: annotate type for GENERATE_ARRAY *(PR [#5335](https://github.com/tobymao/sqlglot/pull/5335) by [@geooo109](https://github.com/geooo109))*
- [`5fb26c5`](https://github.com/tobymao/sqlglot/commit/5fb26c58026018360f36a732394b612a3baac38b) - **optimizer**: annotate type for INT64 *(PR [#5339](https://github.com/tobymao/sqlglot/pull/5339) by [@geooo109](https://github.com/geooo109))*
- [`cff9b55`](https://github.com/tobymao/sqlglot/commit/cff9b55d70a3b85057e6385c93c0814eaa50f40b) - **optimizer**: annotate type for LOGICAL_AND and LOGICAL_OR *(PR [#5340](https://github.com/tobymao/sqlglot/pull/5340) by [@geooo109](https://github.com/geooo109))*
- [`b94a6f9`](https://github.com/tobymao/sqlglot/commit/b94a6f9228aa730296c3152179bfbf3503521063) - **optimizer**: annotate type for MAKE_INTERVAL *(PR [#5341](https://github.com/tobymao/sqlglot/pull/5341) by [@geooo109](https://github.com/geooo109))*
- [`2c9a7c6`](https://github.com/tobymao/sqlglot/commit/2c9a7c6f0b097a9e8514fc5e2af21c52f145920c) - **optimizer**: annotate type for LAST_VALUE *(PR [#5336](https://github.com/tobymao/sqlglot/pull/5336) by [@geooo109](https://github.com/geooo109))*
- [`d862a28`](https://github.com/tobymao/sqlglot/commit/d862a28b0a30f0c5774351f38a61f195120ad904) - **optimizer**: annoate type for TO_BASE64 *(PR [#5342](https://github.com/tobymao/sqlglot/pull/5342) by [@geooo109](https://github.com/geooo109))*
- [`85888c1`](https://github.com/tobymao/sqlglot/commit/85888c1b7cbbd0eee179d902a54fbd2a899cc16b) - **optimizer**: annotate type for UNIX_DATE *(PR [#5343](https://github.com/tobymao/sqlglot/pull/5343) by [@geooo109](https://github.com/geooo109))*
- [`8a214e0`](https://github.com/tobymao/sqlglot/commit/8a214e0859dfb715fcef0dd6b2d6392012b1f3fb) - **optimizer**: annotate type for UNIX_SECONDS *(PR [#5344](https://github.com/tobymao/sqlglot/pull/5344) by [@geooo109](https://github.com/geooo109))*
- [`625cb74`](https://github.com/tobymao/sqlglot/commit/625cb74b69e99ea1a707549366ea960d759848c9) - **optimizer**: annotate type for STARTS_WITH *(PR [#5345](https://github.com/tobymao/sqlglot/pull/5345) by [@geooo109](https://github.com/geooo109))*
- [`0337c4d`](https://github.com/tobymao/sqlglot/commit/0337c4d46e9e85d951fc9565a47e338106543711) - **optimizer**: annotate type for SHA and SHA2 *(PR [#5346](https://github.com/tobymao/sqlglot/pull/5346) by [@geooo109](https://github.com/geooo109))*
- [`835d9e6`](https://github.com/tobymao/sqlglot/commit/835d9e6c9ffc05de642113b566a1a4eb9cc38470) - add case-insensitive uppercase normalization strategy *(PR [#5349](https://github.com/tobymao/sqlglot/pull/5349) by [@georgesittas](https://github.com/georgesittas))*
- [`f80493e`](https://github.com/tobymao/sqlglot/commit/f80493efb168f600dc92da439d84e820f303e5aa) - **exasol**: Add TO_CHAR function support in exasol dialect *(PR [#5350](https://github.com/tobymao/sqlglot/pull/5350) by [@nnamdi16](https://github.com/nnamdi16))*
- [`cea6a24`](https://github.com/tobymao/sqlglot/commit/cea6a240292d6e31bc73179d433835483e65747a) - **teradata**: add FORMAT phrase parsing *(PR [#5348](https://github.com/tobymao/sqlglot/pull/5348) by [@readjfb](https://github.com/readjfb))*
- [`eae64e1`](https://github.com/tobymao/sqlglot/commit/eae64e1629a276bf3885749991869b6c6dea8a8b) - **duckdb**: support new lambda syntax *(PR [#5359](https://github.com/tobymao/sqlglot/pull/5359) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#5357](https://github.com/tobymao/sqlglot/issues/5357) opened by [@aersam](https://github.com/aersam)*
- [`e77991d`](https://github.com/tobymao/sqlglot/commit/e77991d92fad56014ba2778c71e5e446d4dd090e) - **duckdb**: Add support for SET VARIABLE *(PR [#5360](https://github.com/tobymao/sqlglot/pull/5360) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *addresses issue [#5356](https://github.com/tobymao/sqlglot/issues/5356) opened by [@aersam](https://github.com/aersam)*
- [`c1d3d61`](https://github.com/tobymao/sqlglot/commit/c1d3d61d00f00d2030107689d8704f7a488a80a7) - **optimizer**: annotate type for CORR *(PR [#5364](https://github.com/tobymao/sqlglot/pull/5364) by [@geooo109](https://github.com/geooo109))*
- [`c1e8677`](https://github.com/tobymao/sqlglot/commit/c1e867767a006e774a2c200c10eb85b3fbd8a372) - **optimizer**: annotate type for COVAR_POP *(PR [#5365](https://github.com/tobymao/sqlglot/pull/5365) by [@geooo109](https://github.com/geooo109))*
- [`e110ef4`](https://github.com/tobymao/sqlglot/commit/e110ef4f774e6ab8de6d4c86e5d306ab53fe895b) - **optimizer**: annotate type for COVAR_SAMP *(PR [#5367](https://github.com/tobymao/sqlglot/pull/5367) by [@geooo109](https://github.com/geooo109))*
- [`5b59c16`](https://github.com/tobymao/sqlglot/commit/5b59c16528fb1904c64bef0ca6307bb6a95e5a2c) - **optimizer**: annotate type for DATETIME *(PR [#5369](https://github.com/tobymao/sqlglot/pull/5369) by [@geooo109](https://github.com/geooo109))*
- [`47176ce`](https://github.com/tobymao/sqlglot/commit/47176ce6b9a4c1722f285034b08a6ae782129894) - **optimizer**: annotate type for ENDS_WITH *(PR [#5370](https://github.com/tobymao/sqlglot/pull/5370) by [@geooo109](https://github.com/geooo109))*
- [`1fd757e`](https://github.com/tobymao/sqlglot/commit/1fd757e6279315f00e719974613313a6e43dfe55) - **fabric**: Ensure TIMESTAMPTZ is used with AT TIME ZONE *(PR [#5362](https://github.com/tobymao/sqlglot/pull/5362) by [@mattiasthalen](https://github.com/mattiasthalen))*
- [`2cce53d`](https://github.com/tobymao/sqlglot/commit/2cce53d59968f0a4bb3e9599ade93b0e6a140c68) - **optimizer**: annotate type for LAG *(PR [#5371](https://github.com/tobymao/sqlglot/pull/5371) by [@geooo109](https://github.com/geooo109))*
- [`a3227de`](https://github.com/tobymao/sqlglot/commit/a3227de3fc57d559eb899dec08af01f85b470ce4) - improve transpilation of `ROUND(x, y)` to Postgres *(PR [#5368](https://github.com/tobymao/sqlglot/pull/5368) by [@blecourt-private](https://github.com/blecourt-private))*
  - :arrow_lower_right: *addresses issue [#5366](https://github.com/tobymao/sqlglot/issues/5366) opened by [@blecourt-private](https://github.com/blecourt-private)*

### :bug: Bug Fixes
- [`f2bf000`](https://github.com/tobymao/sqlglot/commit/f2bf000a410fb18531bb90ef1d767baf0e8bce7a) - **optimizer**: avoid creating new alias for qualifying unpivot *(PR [#5121](https://github.com/tobymao/sqlglot/pull/5121) by [@geooo109](https://github.com/geooo109))*
- [`a126ce8`](https://github.com/tobymao/sqlglot/commit/a126ce8a25287cf3531d815035fa3d567dc772fb) - **optimizer**: make coalesce simplification optional, skip by default *(PR [#5123](https://github.com/tobymao/sqlglot/pull/5123) by [@barakalon](https://github.com/barakalon))*
- [`f7401fd`](https://github.com/tobymao/sqlglot/commit/f7401fdc29a35738eb23f424ceba03463a4d8af9) - **bigquery**: avoid getting stuck in infinite loop when parsing tables *(PR [#5130](https://github.com/tobymao/sqlglot/pull/5130) by [@georgesittas](https://github.com/georgesittas))*
- [`e9b3156`](https://github.com/tobymao/sqlglot/commit/e9b3156aa1ed95fdee4c6b419134d8ca746964b6) - **athena**: Handle transpilation of FileFormatProperty from dialects that treat it as a variable and not a string literal *(PR [#5133](https://github.com/tobymao/sqlglot/pull/5133) by [@erindru](https://github.com/erindru))*
- [`a3fccd9`](https://github.com/tobymao/sqlglot/commit/a3fccd9be294499b53477da931f8b097cdbe09fc) - **snowflake**: generate SELECT for UNNEST without JOIN or FROM *(PR [#5138](https://github.com/tobymao/sqlglot/pull/5138) by [@geooo109](https://github.com/geooo109))*
- [`993919d`](https://github.com/tobymao/sqlglot/commit/993919d05d5d3c814471607b56831bb65d349eb4) - **snowflake**: Properly transpile ARRAY_AGG, IGNORE/RESPECT NULLS *(PR [#5137](https://github.com/tobymao/sqlglot/pull/5137) by [@VaggelisD](https://github.com/VaggelisD))*
- [`6e57619`](https://github.com/tobymao/sqlglot/commit/6e57619f85375e789bb39a6478aa01cd7c7758f0) - **snowflake**: Transpile ISOWEEK to WEEKISO *(PR [#5139](https://github.com/tobymao/sqlglot/pull/5139) by [@VaggelisD](https://github.com/VaggelisD))*
- [`c484ca3`](https://github.com/tobymao/sqlglot/commit/c484ca39bad750a96b62e2edae85612cac66ba30) - **bigquery**: recognize ARRAY_CONCAT_AGG as an aggregate function *(PR [#5141](https://github.com/tobymao/sqlglot/pull/5141) by [@georgesittas](https://github.com/georgesittas))*
- [`f3aeb37`](https://github.com/tobymao/sqlglot/commit/f3aeb374351a0b1b3c75945718d8ea42f8926b62) - **tsql**: properly parse and generate ALTER SET *(PR [#5143](https://github.com/tobymao/sqlglot/pull/5143) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5135](https://github.com/tobymao/sqlglot/issues/5135) opened by [@codykonior](https://github.com/codykonior)*
- [`72ce404`](https://github.com/tobymao/sqlglot/commit/72ce40405625239a0d6763d502e5af8b12abfe9b) - Refactor ALTER TABLE ADD parsing *(PR [#5144](https://github.com/tobymao/sqlglot/pull/5144) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5129](https://github.com/tobymao/sqlglot/issues/5129) opened by [@Mevrael](https://github.com/Mevrael)*
- [`e73ddb7`](https://github.com/tobymao/sqlglot/commit/e73ddb733b7f120ae74054e6d4dc7d458f59ac50) - **mysql**: preserve TIMESTAMP on roundtrip *(PR [#5145](https://github.com/tobymao/sqlglot/pull/5145) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5127](https://github.com/tobymao/sqlglot/issues/5127) opened by [@AhlamHani](https://github.com/AhlamHani)*
- [`4f8c73d`](https://github.com/tobymao/sqlglot/commit/4f8c73d60eecebc601c60ee8c7819458435e34b8) - **hive**: STRUCT column names and data type should be separated by ':' in hive *(PR [#5147](https://github.com/tobymao/sqlglot/pull/5147) by [@tsamaras](https://github.com/tsamaras))*
- [`e2a488f`](https://github.com/tobymao/sqlglot/commit/e2a488f48f3e036566462463bbc58cc6a1c7492e) - Error on columns mismatch in pushdown_projections ignores dialect *(PR [#5151](https://github.com/tobymao/sqlglot/pull/5151) by [@snovik75](https://github.com/snovik75))*
- [`1a35365`](https://github.com/tobymao/sqlglot/commit/1a35365a3bb1ef56e8da0023271cbe3108e0ccb1) - avoid generating nested comments when not supported *(PR [#5158](https://github.com/tobymao/sqlglot/pull/5158) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5132](https://github.com/tobymao/sqlglot/issues/5132) opened by [@patricksurry](https://github.com/patricksurry)*
- [`f6124c6`](https://github.com/tobymao/sqlglot/commit/f6124c6343f67563fc19f617891ecfc145a642db) - **rust-tokenizer**: return token vector in `tokenize` even on failure *(PR [#5155](https://github.com/tobymao/sqlglot/pull/5155) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5148](https://github.com/tobymao/sqlglot/issues/5148) opened by [@kamoser](https://github.com/kamoser)*
- [`760a606`](https://github.com/tobymao/sqlglot/commit/760a6062d5f259488e471af9c1d33e200066e9dc) - **postgres**: support decimal values in INTERVAL expressions fixes [#5168](https://github.com/tobymao/sqlglot/pull/5168) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`6a2cb39`](https://github.com/tobymao/sqlglot/commit/6a2cb39d0ceec091dc4fc228f26d4f457729a3cf) - **parser**: virtual column with AS(expr) as ComputedColumnConstraint *(PR [#5180](https://github.com/tobymao/sqlglot/pull/5180) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5173](https://github.com/tobymao/sqlglot/issues/5173) opened by [@suyah](https://github.com/suyah)*
- [`c87ae02`](https://github.com/tobymao/sqlglot/commit/c87ae02aa263be8463ca7283ebd090385a4bfd59) - **sqlite**: Add REPLACE to command tokens *(PR [#5192](https://github.com/tobymao/sqlglot/pull/5192) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5187](https://github.com/tobymao/sqlglot/issues/5187) opened by [@stefanmalanik](https://github.com/stefanmalanik)*
- [`4b89afd`](https://github.com/tobymao/sqlglot/commit/4b89afdcc0063e70cbc64165c7f1f5102afaa87c) - **starrocks**: array_agg_transpilation_fix *(PR [#5190](https://github.com/tobymao/sqlglot/pull/5190) by [@Swathiraj23](https://github.com/Swathiraj23))*
- [`461b054`](https://github.com/tobymao/sqlglot/commit/461b0548832ab8d916c3a6638f27a49f681109fe) - **postgres**: support use_spheroid argument in ST_DISTANCE *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`99bbae3`](https://github.com/tobymao/sqlglot/commit/99bbae370329c5f5cd132b711c714359cf96ba58) - **sqlite**: allow ALTER RENAME without COLUMN keyword fixes [#5195](https://github.com/tobymao/sqlglot/pull/5195) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`ac6555b`](https://github.com/tobymao/sqlglot/commit/ac6555b4d6c162ef7b14b63307d01fd560138ea0) - **hive**: preserve DIV binary operator, fixes [#5198](https://github.com/tobymao/sqlglot/pull/5198) *(PR [#5199](https://github.com/tobymao/sqlglot/pull/5199) by [@georgesittas](https://github.com/georgesittas))*
- [`d0eeb26`](https://github.com/tobymao/sqlglot/commit/d0eeb2639e771e8f8b6feabd41c65f16ed5a9829) - eliminate_join_marks has multiple issues fixes [#5188](https://github.com/tobymao/sqlglot/pull/5188) *(PR [#5189](https://github.com/tobymao/sqlglot/pull/5189) by [@snovik75](https://github.com/snovik75))*
  - :arrow_lower_right: *fixes issue [#5188](https://github.com/tobymao/sqlglot/issues/5188) opened by [@snovik75](https://github.com/snovik75)*
- [`dfdd84b`](https://github.com/tobymao/sqlglot/commit/dfdd84bbc50da70f40a17b39935f8171d961f7d2) - **parser**: CTEs instead of subqueries for pipe syntax *(PR [#5205](https://github.com/tobymao/sqlglot/pull/5205) by [@geooo109](https://github.com/geooo109))*
- [`77e9d9a`](https://github.com/tobymao/sqlglot/commit/77e9d9a0269e2013379967cf2f46fbd79c036277) - **mysql**: properly parse STORED/VIRTUAL computed columns *(PR [#5210](https://github.com/tobymao/sqlglot/pull/5210) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5203](https://github.com/tobymao/sqlglot/issues/5203) opened by [@mdebski](https://github.com/mdebski)*
- [`5f95299`](https://github.com/tobymao/sqlglot/commit/5f9529940d83e89704f7d25eda63cd73fdb503ae) - **parser**: support multi-part (>3) dotted functions *(PR [#5211](https://github.com/tobymao/sqlglot/pull/5211) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5200](https://github.com/tobymao/sqlglot/issues/5200) opened by [@mateuszpoleski](https://github.com/mateuszpoleski)*
- [`02afa2a`](https://github.com/tobymao/sqlglot/commit/02afa2a1941fc67086d50dffac2857262f1c3c4f) - **postgres**: Preserve quoting for UDT *(PR [#5216](https://github.com/tobymao/sqlglot/pull/5216) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5212](https://github.com/tobymao/sqlglot/issues/5212) opened by [@NickCrews](https://github.com/NickCrews)*
- [`f37c0b1`](https://github.com/tobymao/sqlglot/commit/f37c0b1197321dd610648ce652a171ab063deeeb) - **snowflake**: ensure a standalone GET() expression can be parsed *(PR [#5219](https://github.com/tobymao/sqlglot/pull/5219) by [@georgesittas](https://github.com/georgesittas))*
- [`28fed58`](https://github.com/tobymao/sqlglot/commit/28fed586a39df83aade4792217743a1a859fd039) - **optimizer**: UnboundLocalError in scope module *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`809e05a`](https://github.com/tobymao/sqlglot/commit/809e05a743d5a2904a1d6f6813f24ca7549ac7ef) - **snowflake**: preserve STRTOK_TO_ARRAY roundtrip *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`df73a79`](https://github.com/tobymao/sqlglot/commit/df73a79a2ca3ba859b8aba5e3d0f6ed269874a63) - **tsql**: Retain limit clause in subquery expression. *(PR [#5227](https://github.com/tobymao/sqlglot/pull/5227) by [@MarcusRisanger](https://github.com/MarcusRisanger))*
- [`4f42d95`](https://github.com/tobymao/sqlglot/commit/4f42d951363f8c43a4c414dc21d0505d9c8e48bf) - **duckdb**: Normalize date parts in `exp.Extract` generation *(PR [#5229](https://github.com/tobymao/sqlglot/pull/5229) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#5228](https://github.com/tobymao/sqlglot/issues/5228) opened by [@greybeam-bot](https://github.com/greybeam-bot)*
- [`1b4c083`](https://github.com/tobymao/sqlglot/commit/1b4c083fff8d7c44bf1dbba28c1225fa1e28c4d2) - **athena**: include Hive string escapes in the tokenizer *(PR [#5233](https://github.com/tobymao/sqlglot/pull/5233) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5232](https://github.com/tobymao/sqlglot/issues/5232) opened by [@ligfx](https://github.com/ligfx)*
- [`e7e38fe`](https://github.com/tobymao/sqlglot/commit/e7e38fe0e09f9affbff4ffa7023d0161e3a1ee49) - **optimizer**: resolve table "columns" in bigquery that produce structs *(PR [#5230](https://github.com/tobymao/sqlglot/pull/5230) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5207](https://github.com/tobymao/sqlglot/issues/5207) opened by [@Bladieblah](https://github.com/Bladieblah)*
- [`781539d`](https://github.com/tobymao/sqlglot/commit/781539d5cbe58142ed6688f1522fc4ed31da0a56) - **duckdb**: Generate correct DETACH syntax if IF EXISTS is set *(PR [#5235](https://github.com/tobymao/sqlglot/pull/5235) by [@erindru](https://github.com/erindru))*
- [`d3dc761`](https://github.com/tobymao/sqlglot/commit/d3dc761393146357a5d20c4d7992fd2a1ae5e6e2) - change comma to cross join when precedence is the same for all join types *(PR [#5240](https://github.com/tobymao/sqlglot/pull/5240) by [@georgesittas](https://github.com/georgesittas))*
- [`31814cd`](https://github.com/tobymao/sqlglot/commit/31814cddb0cf65caf29fbc45a31a9c865b7991c7) - **presto**: cast constructed timestamp literal to zone-aware type if needed *(PR [#5253](https://github.com/tobymao/sqlglot/pull/5253) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5252](https://github.com/tobymao/sqlglot/issues/5252) opened by [@agni-sairent](https://github.com/agni-sairent)*
- [`847248d`](https://github.com/tobymao/sqlglot/commit/847248dd1b66e3a8f60c23a4488be85dfdef4113) - format ADD CONSTRAINT clause properly fixes [#5260](https://github.com/tobymao/sqlglot/pull/5260) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`db4e0ec`](https://github.com/tobymao/sqlglot/commit/db4e0ece950a6a1f543d8ecad48a7d4b1d6872be) - **tsql**: convert information schema keywords to uppercase for consistency *(PR [#5263](https://github.com/tobymao/sqlglot/pull/5263) by [@mattiasthalen](https://github.com/mattiasthalen))*
- [`8de87e3`](https://github.com/tobymao/sqlglot/commit/8de87e3f755a40b600aa94ee2c30cf697ef7c43c) - **redshift**: handle scale parameter in to_timestamp *(PR [#5266](https://github.com/tobymao/sqlglot/pull/5266) by [@MatiasCasaliSplit](https://github.com/MatiasCasaliSplit))*
- [`e32f709`](https://github.com/tobymao/sqlglot/commit/e32f70992b5058efb93f5d2b6106fb00b810f576) - **hive**: Fix exp.PosExplode alias order *(PR [#5279](https://github.com/tobymao/sqlglot/pull/5279) by [@VaggelisD](https://github.com/VaggelisD))*
- [`3dd9f8e`](https://github.com/tobymao/sqlglot/commit/3dd9f8e78ecbfde0dd7fc6fefcc09c8cb99bcd7b) - **fabric**: Type mismatches and precision error *(PR [#5280](https://github.com/tobymao/sqlglot/pull/5280) by [@mattiasthalen](https://github.com/mattiasthalen))*
- [`9a95af1`](https://github.com/tobymao/sqlglot/commit/9a95af1c725cd70ffa8206f1d88452a7faab93b2) - **snowflake**: only cast strings to timestamp for TO_CHAR (TimeToStr) *(PR [#5283](https://github.com/tobymao/sqlglot/pull/5283) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5282](https://github.com/tobymao/sqlglot/issues/5282) opened by [@wedotech-ashley](https://github.com/wedotech-ashley)*
- [`8af4790`](https://github.com/tobymao/sqlglot/commit/8af479017ccde16049c897ae5d322d4a69843b65) - **tsql**: Fix parsing of ADD CONSTRAINT *(PR [#5288](https://github.com/tobymao/sqlglot/pull/5288) by [@VaggelisD](https://github.com/VaggelisD))*
  - :arrow_lower_right: *fixes issue [#4813](https://github.com/TobikoData/sqlmesh/issues/4813) opened by [@bnstewrt](https://github.com/bnstewrt)*
- [`18aea08`](https://github.com/tobymao/sqlglot/commit/18aea08f7dcaa887bcf29886cd3b3bc2850a3679) - **scope**: include bigquery unnest aliases in selected sources *(PR [#5285](https://github.com/tobymao/sqlglot/pull/5285) by [@georgesittas](https://github.com/georgesittas))*
- [`ba4a234`](https://github.com/tobymao/sqlglot/commit/ba4a234bfabdd8161b96a29436a50e0eb04c2dc2) - **fabric**: ignore Date cap *(PR [#5290](https://github.com/tobymao/sqlglot/pull/5290) by [@fresioAS](https://github.com/fresioAS))*
- [`dc03649`](https://github.com/tobymao/sqlglot/commit/dc03649bca0b7a090254976182a03c21dd2269ba) - **bigquery**: only coerce time var -like units into strings for DATE_TRUNC *(PR [#5291](https://github.com/tobymao/sqlglot/pull/5291) by [@georgesittas](https://github.com/georgesittas))*
- [`5724538`](https://github.com/tobymao/sqlglot/commit/5724538f278b2178114b88850251afd7c3db0dda) - **bigquery**: ARRAY_CONCAT type annotation *(PR [#5293](https://github.com/tobymao/sqlglot/pull/5293) by [@geooo109](https://github.com/geooo109))*
- [`0a6afcd`](https://github.com/tobymao/sqlglot/commit/0a6afcd90c663aaef9b385fc12ccd19dbf6388cc) - use re-entrant lock in dialects/__init__ to avoid deadlocks *(PR [#5322](https://github.com/tobymao/sqlglot/pull/5322) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5321](https://github.com/tobymao/sqlglot/issues/5321) opened by [@jc-5s](https://github.com/jc-5s)*
- [`599ca81`](https://github.com/tobymao/sqlglot/commit/599ca8101f48805098cbdf808ac2923a8246066b) - **parser**: avoid CTE values ALIAS gen, when ALIAS exists *(PR [#5323](https://github.com/tobymao/sqlglot/pull/5323) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5318](https://github.com/tobymao/sqlglot/issues/5318) opened by [@ankur334](https://github.com/ankur334)*
- [`5a0f589`](https://github.com/tobymao/sqlglot/commit/5a0f589a0fdb6743c3be2f98b74a34780f51332b) - **spark**: distinguish STORED AS from USING *(PR [#5320](https://github.com/tobymao/sqlglot/pull/5320) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5317](https://github.com/tobymao/sqlglot/issues/5317) opened by [@cosinequanon](https://github.com/cosinequanon)*
- [`cbc79c2`](https://github.com/tobymao/sqlglot/commit/cbc79c2a47c46370de0378b8bae61f4f3c17ca82) - preserve ORDER BY comments fixes [#5326](https://github.com/tobymao/sqlglot/pull/5326) *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`fa69583`](https://github.com/tobymao/sqlglot/commit/fa69583d8b4f5801d05c21a92b43dea272a3ef49) - **optimizer**: avoid qualifying CTE *(PR [#5327](https://github.com/tobymao/sqlglot/pull/5327) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5319](https://github.com/tobymao/sqlglot/issues/5319) opened by [@naamamaoz](https://github.com/naamamaoz)*
- [`29cce43`](https://github.com/tobymao/sqlglot/commit/29cce43e72451feeb8788ac2660658075bf59093) - comment lost before GROUP, JOIN and HAVING *(PR [#5338](https://github.com/tobymao/sqlglot/pull/5338) by [@chiiips](https://github.com/chiiips))*
- [`509b741`](https://github.com/tobymao/sqlglot/commit/509b74173f678842e7550c75c4d8d906c879fb12) - preserve multi-arg DECODE function instead of converting to CASE *(PR [#5352](https://github.com/tobymao/sqlglot/pull/5352) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5351](https://github.com/tobymao/sqlglot/issues/5351) opened by [@kentmaxwell](https://github.com/kentmaxwell)*
- [`188d446`](https://github.com/tobymao/sqlglot/commit/188d446ca65125c63bbfff96d15d91078deb6b4a) - **optimizer**: downstream column for PIVOT *(PR [#5363](https://github.com/tobymao/sqlglot/pull/5363) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5354](https://github.com/tobymao/sqlglot/issues/5354) opened by [@suresh-summation](https://github.com/suresh-summation)*

### :recycle: Refactors
- [`86c6b90`](https://github.com/tobymao/sqlglot/commit/86c6b90d21b204b4376639affa142e8cee509065) - **tsql**: XML_OPTIONS *(commit by [@geooo109](https://github.com/geooo109))*
- [`aac70aa`](https://github.com/tobymao/sqlglot/commit/aac70aaaa8d840c267129e2307ccb65058cef0c9) - **parser**: simpler _parse_pipe_syntax_select *(commit by [@geooo109](https://github.com/geooo109))*
- [`8d118ea`](https://github.com/tobymao/sqlglot/commit/8d118ead9c15e7b2b4b51b7cf93cab94e61c2625) - **athena**: route statements to hive/trino depending on their type *(PR [#5314](https://github.com/tobymao/sqlglot/pull/5314) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *addresses issue [#5267](https://github.com/tobymao/sqlglot/issues/5267) opened by [@cpcloud](https://github.com/cpcloud)*

### :wrench: Chores
- [`6910744`](https://github.com/tobymao/sqlglot/commit/6910744e6260793b3f9190782cf60fbbd9adcd38) - update py03 version *(PR [#5136](https://github.com/tobymao/sqlglot/pull/5136) by [@benfdking](https://github.com/benfdking))*
  - :arrow_lower_right: *addresses issue [#5134](https://github.com/tobymao/sqlglot/issues/5134) opened by [@mgorny](https://github.com/mgorny)*
- [`a56deab`](https://github.com/tobymao/sqlglot/commit/a56deabc2b9543209fb5e41f19c3bef89177a577) - bump sqlglotrs to 0.5.0 *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`5752a87`](https://github.com/tobymao/sqlglot/commit/5752a87406b736317e4dc5cce9ae05cbc5c19547) - udpate benchmarking framework *(PR [#5146](https://github.com/tobymao/sqlglot/pull/5146) by [@benfdking](https://github.com/benfdking))*
- [`0ae297a`](https://github.com/tobymao/sqlglot/commit/0ae297a01262cf323e225fe578bdeab2230c6fd5) - compare performance on main vs pr branch *(PR [#5149](https://github.com/tobymao/sqlglot/pull/5149) by [@georgesittas](https://github.com/georgesittas))*
- [`180963b`](https://github.com/tobymao/sqlglot/commit/180963b8cf25d9ff83d2347859b7f46398af5000) - handle pipe syntax unsupported operators more gracefully *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`6c8d61a`](https://github.com/tobymao/sqlglot/commit/6c8d61ae1ef5b645835ccd683063845dd801e8d2) - include optimization benchmarks *(PR [#5152](https://github.com/tobymao/sqlglot/pull/5152) by [@georgesittas](https://github.com/georgesittas))*
- [`bc5c66c`](https://github.com/tobymao/sqlglot/commit/bc5c66c9210a472147d98a94c34b4bb582ade8b1) - Run benchmark job if /benchmark comment *(PR [#5164](https://github.com/tobymao/sqlglot/pull/5164) by [@VaggelisD](https://github.com/VaggelisD))*
- [`742b2b7`](https://github.com/tobymao/sqlglot/commit/742b2b770b88a2e901d2f84af00db821da441e4c) - Fix benchmark CI to include issue number *(PR [#5166](https://github.com/tobymao/sqlglot/pull/5166) by [@VaggelisD](https://github.com/VaggelisD))*
- [`64c37f1`](https://github.com/tobymao/sqlglot/commit/64c37f147366fe87ae187996ecb3c9a5afa7c264) - bump sqlglotrs to 0.6.0 *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`440590b`](https://github.com/tobymao/sqlglot/commit/440590bf92ab1281f50b96a1400cbca695d40f0c) - bump sqlglotrs to 0.6.1 *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`83de4e1`](https://github.com/tobymao/sqlglot/commit/83de4e11bc1547aa22b275b20c0326dfbe43b2b8) - improve benchmark result displaying *(PR [#5176](https://github.com/tobymao/sqlglot/pull/5176) by [@georgesittas](https://github.com/georgesittas))*
- [`5d5dc2f`](https://github.com/tobymao/sqlglot/commit/5d5dc2fa471bd53730e03ac8039804221949f843) - Clean up exp.ArrayIntersect PR *(PR [#5193](https://github.com/tobymao/sqlglot/pull/5193) by [@VaggelisD](https://github.com/VaggelisD))*
- [`ad8a4e7`](https://github.com/tobymao/sqlglot/commit/ad8a4e73e1a9e4234f0b711163fb49630acf736c) - refactor join mark elimination to use is_correlated_subquery *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`7dfb578`](https://github.com/tobymao/sqlglot/commit/7dfb5780fb242c82744dc1538077776ac624081e) - Refactor DETACH generation *(PR [#5237](https://github.com/tobymao/sqlglot/pull/5237) by [@VaggelisD](https://github.com/VaggelisD))*
- [`cc389fa`](https://github.com/tobymao/sqlglot/commit/cc389facb33f94a0d1f696f2ef9e92f298711894) - **optimizer**: annotate type SHA1, SHA256, SHA512 for BigQuery *(PR [#5347](https://github.com/tobymao/sqlglot/pull/5347) by [@geooo109](https://github.com/geooo109))*
- [`194850a`](https://github.com/tobymao/sqlglot/commit/194850a52497300a8f1d47f2306b67cdd11ffab6) - **exasol**: clean up TO_CHAR *(commit by [@georgesittas](https://github.com/georgesittas))*
- [`1abd461`](https://github.com/tobymao/sqlglot/commit/1abd461295830807c52f24d25ac6938095f54831) - bump min. supported version to python 3.9 *(PR [#5353](https://github.com/tobymao/sqlglot/pull/5353) by [@georgesittas](https://github.com/georgesittas))*


## [v26.33.0] - 2025-07-01
### :boom: BREAKING CHANGES
- due to [`d2f7c41`](https://github.com/tobymao/sqlglot/commit/d2f7c41f9f30f4cf0c74782be9be0cc6e75565f3) - add TypeOf / toTypeName support *(PR [#5315](https://github.com/tobymao/sqlglot/pull/5315) by [@ankur334](https://github.com/ankur334))*:

  add TypeOf / toTypeName support (#5315)


### :sparkles: New Features
- [`d2f7c41`](https://github.com/tobymao/sqlglot/commit/d2f7c41f9f30f4cf0c74782be9be0cc6e75565f3) - add TypeOf / toTypeName support *(PR [#5315](https://github.com/tobymao/sqlglot/pull/5315) by [@ankur334](https://github.com/ankur334))*

### :bug: Bug Fixes
- [`0a6afcd`](https://github.com/tobymao/sqlglot/commit/0a6afcd90c663aaef9b385fc12ccd19dbf6388cc) - use re-entrant lock in dialects/__init__ to avoid deadlocks *(PR [#5322](https://github.com/tobymao/sqlglot/pull/5322) by [@georgesittas](https://github.com/georgesittas))*
  - :arrow_lower_right: *fixes issue [#5321](https://github.com/tobymao/sqlglot/issues/5321) opened by [@jc-5s](https://github.com/jc-5s)*
- [`599ca81`](https://github.com/tobymao/sqlglot/commit/599ca8101f48805098cbdf808ac2923a8246066b) - **parser**: avoid CTE values ALIAS gen, when ALIAS exists *(PR [#5323](https://github.com/tobymao/sqlglot/pull/5323) by [@geooo109](https://github.com/geooo109))*
  - :arrow_lower_right: *fixes issue [#5318](https://github.com/tobymao/sqlglot/issues/5318) opened by [@ankur334](https://github.com/ankur334)*


## [v26.31.0] - 2025-06-26
### :boom: BREAKING CHANGES
- due to [`f2bf000`](https://github.com/tobymao/sqlglot/commit/f2bf000a410fb18531bb90ef1d767baf0e8bce7a) - avoid creating new alias for qualifying unpivot *(PR [#5121](https://github.com/tobymao/sqlglot/pull/5121) by [@geooo109](https://github.com/geooo109))*:

  avoid creating new alias for qualifying unpivot (#5121)

- due to [`a126ce8`](https://github.com/tobymao/sqlglot/commit/a126ce8a25287cf3531d815035fa3d567dc772fb) - make coalesce simplification optional, skip by default *(PR [#5123](https://github.com/tobymao/sqlglot/pull/5123) by [@barakalon](https://github.com/barakalon))*:

  make coalesce simplification optional, skip by default (#5123)

- due to [`6910744`](https://github.com/tobymao/sqlglot/commit/6910744e6260793b3f9190782cf60fbbd9adcd38) - update py03 version *(PR [#5136](https://github.com/tobymao/sqlglot/pull/5136) by [@benfdking](https://github.com/benfdking))*:

  update py03 version (#5136)

- due to [`a56deab`](https://github.com/tobymao/sqlglot/commit/a56deabc2b9543209fb5e41f19c3bef89177a577) - bump sqlglotrs to 0.5.0 *(commit by [@georgesittas](https://github.com/georgesittas))*:

  bump sqlglotrs to 0.5.0

- due to [`c484ca3`](https://github.com/tobymao/sqlglot/commit/c484ca39bad750a96b62e2edae85612cac66ba30) - recognize ARRAY_CONCAT_AGG as an aggregate function *(PR [#5141](https://github.com/tobymao/sqlglot/pull/5141) by [@georgesittas](https://github.com/