/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.internal.filesystem.local.LocalFileNativesManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class LocalFileSystem
extends FileSystem {
    static final boolean MACOSX = Platform.OS.isMac();
    private static final boolean CASE_SENSITIVE = !MACOSX && new File("a").compareTo(new File("A")) != 0;
    private int attributes = -1;
    private static final IFileSystem INSTANCE = EFS.getLocalFileSystem();

    public static IFileSystem getInstance() {
        return INSTANCE;
    }

    @Override
    public int attributes() {
        if (this.attributes != -1) {
            return this.attributes;
        }
        this.attributes = 0;
        int nativeAttributes = LocalFileNativesManager.getSupportedAttributes();
        if (nativeAttributes >= 0) {
            this.attributes = nativeAttributes;
            return this.attributes;
        }
        this.attributes |= 2;
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            this.attributes |= 0x18;
        } else if ("linux".equals(os) || "solaris".equals(os) && "sparc".equals(Platform.getOSArch())) {
            this.attributes |= 0x64;
        } else if ("macosx".equals(os) || "hpux".equals(os) || "qnx".equals(os)) {
            this.attributes |= 4;
        }
        return this.attributes;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public IFileStore fromLocalFile(File file) {
        return new LocalFile(file);
    }

    @Override
    public IFileStore getStore(IPath path) {
        return new LocalFile(path.toFile());
    }

    @Override
    public IFileStore getStore(URI uri) {
        return new LocalFile(new File(uri.getSchemeSpecificPart()));
    }

    @Override
    public boolean isCaseSensitive() {
        return CASE_SENSITIVE;
    }
}

