/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.python;

import com.intellij.ml.inline.completion.impl.kit.MLCompletionMultilineSupporter;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010&\u001a\u00020\n*\u00020\fH\u0002R\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006'"}, d2={"Lcom/intellij/ml/inline/completion/python/PythonMultilineSupporter;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultilineSupporter;", "<init>", "()V", "candidates", "", "Ljava/lang/Class;", "Lcom/jetbrains/python/psi/PyElement;", "[Ljava/lang/Class;", "isMultilineSuitable", "", "element", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "checkParameterList", "parameterList", "Lcom/jetbrains/python/psi/PyParameterList;", "checkArgumentList", "argumentList", "Lcom/jetbrains/python/psi/PyArgumentList;", "checkStatementList", "statementList", "Lcom/jetbrains/python/psi/PyStatementList;", "checkIfStatement", "ifStatement", "Lcom/jetbrains/python/psi/PyIfStatement;", "checkClassOrFunction", "funcOrClass", "Lcom/jetbrains/python/psi/PyStatementListContainer;", "checkWhileStatement", "whileStatement", "Lcom/jetbrains/python/psi/PyWhileStatement;", "checkForStatement", "forStatement", "Lcom/jetbrains/python/psi/PyForStatement;", "isOnTopLevel", "intellij.ml.inline.completion.python"})
public final class PythonMultilineSupporter
implements MLCompletionMultilineSupporter {
    @NotNull
    private final Class<? extends PyElement>[] candidates;

    public PythonMultilineSupporter() {
        Class[] classArray = new Class[]{PyStatementList.class, PyParameterList.class, PyArgumentList.class, PyCallExpression.class, PyWhileStatement.class, PyForStatement.class, PyClass.class, PyFunction.class, PyStatementListContainer.class, PyIfStatement.class, PyFile.class};
        this.candidates = classArray;
    }

    @Override
    public boolean isMultilineSuitable(@NotNull PsiElement element, @NotNull Document document, int offset) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        PsiElement prevSibling = PyPsiUtils.getPrevNonCommentSibling((PsiElement)element, (boolean)true);
        PyElement pyElement = this.candidates;
        PyElement parent = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)prevSibling, (boolean)false, (Class[])Arrays.copyOf(pyElement, ((Class<? extends PyElement>[])pyElement).length));
        if (this.isOnTopLevel(element) || parent instanceof PyFile) {
            PsiElement nextSibling = PyPsiUtils.getNextNonCommentSibling((PsiElement)element, (boolean)true);
            return nextSibling instanceof PyClass || nextSibling instanceof PyFunction || nextSibling == null;
        }
        pyElement = parent;
        if (pyElement instanceof PyParameterList) {
            bl = this.checkParameterList((PyParameterList)parent, offset);
        } else if (pyElement instanceof PyArgumentList) {
            bl = this.checkArgumentList((PyArgumentList)parent, offset);
        } else if (pyElement instanceof PyStatementList) {
            bl = this.checkStatementList((PyStatementList)parent, offset);
        } else if (pyElement instanceof PyWhileStatement) {
            bl = this.checkWhileStatement((PyWhileStatement)parent, offset);
        } else if (pyElement instanceof PyForStatement) {
            bl = this.checkForStatement((PyForStatement)parent, offset);
        } else if (pyElement instanceof PyIfStatement) {
            bl = this.checkIfStatement((PyIfStatement)parent, offset);
        } else if (pyElement instanceof PyClass || pyElement instanceof PyFunction) {
            PyElement pyElement2 = parent;
            Intrinsics.checkNotNull((Object)pyElement2, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyStatementListContainer");
            bl = this.checkClassOrFunction((PyStatementListContainer)pyElement2, element, offset);
        } else if (pyElement instanceof PyStatementListContainer) {
            PyStatementList pyStatementList = ((PyStatementListContainer)parent).getStatementList();
            Intrinsics.checkNotNullExpressionValue((Object)pyStatementList, (String)"getStatementList(...)");
            bl = this.checkStatementList(pyStatementList, offset);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkParameterList(PyParameterList parameterList, int offset) {
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)parameterList), PyFunction.class);
        if (function == null) return false;
        PyStatement[] pyStatementArray = function.getStatementList().getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)pyStatementArray, (String)"getStatements(...)");
        if (((Object[])pyStatementArray).length != 0) return false;
        boolean bl = true;
        if (!bl) {
            return false;
        }
        Object[] objectArray = parameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getParameters(...)");
        Object[] parameters = objectArray;
        if (parameters.length == 0) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        Object object = ArraysKt.last((Object[])parameters);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
        if (offset < PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)object))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkArgumentList(PyArgumentList argumentList, int offset) {
        Object[] objectArray = argumentList.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getArguments(...)");
        Object[] arguments = objectArray;
        if (arguments.length == 0) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        Object object = ArraysKt.last((Object[])arguments);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
        if (offset < PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)object))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkStatementList(PyStatementList statementList, int offset) {
        Object[] statements = statementList.getStatements();
        if (statementList.getParent() instanceof PyClass) {
            return true;
        }
        Intrinsics.checkNotNull((Object)statements);
        if (statements.length == 0) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        Object object = ArraysKt.last((Object[])statements);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
        if (offset < PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)object))) return false;
        return true;
    }

    private final boolean checkIfStatement(PyIfStatement ifStatement, int offset) {
        PyIfPart pyIfPart = ifStatement.getIfPart();
        Intrinsics.checkNotNullExpressionValue((Object)pyIfPart, (String)"getIfPart(...)");
        PyIfPart ifPart = pyIfPart;
        PyElsePart elsePart = (PyElsePart)ifStatement.getElsePart();
        if (elsePart != null) {
            return offset >= elsePart.getTextOffset() || offset >= ifPart.getTextOffset() && offset <= elsePart.getTextOffset();
        }
        return offset >= ifPart.getTextOffset();
    }

    private final boolean checkClassOrFunction(PyStatementListContainer funcOrClass, PsiElement element, int offset) {
        Object[] statements;
        block3: {
            block2: {
                statements = funcOrClass.getStatementList().getStatements();
                boolean isOnSameLine = Intrinsics.areEqual((Object)PyPsiUtils.getPrevNonWhitespaceSiblingOnSameLine((PsiElement)element), (Object)funcOrClass);
                if (isOnSameLine || funcOrClass.getName() == null) break block2;
                Intrinsics.checkNotNull((Object)statements);
                if (!(statements.length == 0)) break block3;
            }
            return true;
        }
        Object object = ArraysKt.last((Object[])statements);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
        return offset >= PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)object));
    }

    private final boolean checkWhileStatement(PyWhileStatement whileStatement, int offset) {
        return offset >= PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)whileStatement));
    }

    private final boolean checkForStatement(PyForStatement forStatement, int offset) {
        return offset >= PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)forStatement));
    }

    private final boolean isOnTopLevel(PsiElement $this$isOnTopLevel) {
        return PyPsiUtils.getElementIndentation((PsiElement)$this$isOnTopLevel) == 0 && PyPsiUtils.getPrevNonWhitespaceSiblingOnSameLine((PsiElement)$this$isOnTopLevel) == null;
    }
}

