/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.python.formatters;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiFilter;
import com.jetbrains.python.psi.PyImportStatementBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.language.CodeFormatter;
import org.jetbrains.completion.full.line.language.ElementFormatter;
import org.jetbrains.completion.full.line.language.formatters.CodeFormatterBase;
import org.jetbrains.completion.full.line.language.formatters.PlainTextFormatter;
import org.jetbrains.completion.full.line.language.formatters.SkippedElementsFormatter;
import org.jetbrains.completion.full.line.language.formatters.TextFormatter;
import org.jetbrains.completion.full.line.python.formatters.WhitespaceFormatter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/completion/full/line/python/formatters/PythonCodeFormatter;", "Lorg/jetbrains/completion/full/line/language/formatters/CodeFormatterBase;", "textFormatter", "Lorg/jetbrains/completion/full/line/language/formatters/TextFormatter;", "<init>", "(Lorg/jetbrains/completion/full/line/language/formatters/TextFormatter;)V", "getTextFormatter", "()Lorg/jetbrains/completion/full/line/language/formatters/TextFormatter;", "elementFormatters", "", "Lorg/jetbrains/completion/full/line/language/ElementFormatter;", "getElementFormatters", "()Ljava/util/List;", "format", "", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "importElements", "Lorg/jetbrains/completion/full/line/language/CodeFormatter$ImportElement;", "file", "Lcom/intellij/psi/PsiFile;", "endOfLineMarkers", "getEndOfLineMarkers", "intellij.fullLine.python"})
public final class PythonCodeFormatter
extends CodeFormatterBase {
    @NotNull
    private final TextFormatter textFormatter;
    @NotNull
    private final List<ElementFormatter> elementFormatters;
    @NotNull
    private final List<String> endOfLineMarkers;

    public PythonCodeFormatter(@NotNull TextFormatter textFormatter) {
        Intrinsics.checkNotNullParameter((Object)textFormatter, (String)"textFormatter");
        this.textFormatter = textFormatter;
        Object[] objectArray = new ElementFormatter[3];
        objectArray[0] = new WhitespaceFormatter();
        Class[] classArray = new Class[]{PsiComment.class, OuterLanguageElement.class};
        objectArray[1] = new SkippedElementsFormatter(classArray);
        objectArray[2] = new PlainTextFormatter();
        this.elementFormatters = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"\u21e5", "\u21e4", "\u00c6"};
        this.endOfLineMarkers = CollectionsKt.plus((Collection)super.getEndOfLineMarkers(), (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final TextFormatter getTextFormatter() {
        return this.textFormatter;
    }

    @NotNull
    public List<ElementFormatter> getElementFormatters() {
        return this.elementFormatters;
    }

    @NotNull
    public String format(@NotNull PsiElement element, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        String formatted = ((Object)StringsKt.trimStart((CharSequence)super.format(element, range))).toString();
        return this.textFormatter.format(formatted);
    }

    @NotNull
    public List<CodeFormatter.ImportElement> importElements(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List list = new ArrayList();
        new PsiFilter(PyImportStatementBase.class).createVisitor(list).visitFile(file);
        return this.asImportElements(list);
    }

    @NotNull
    public List<String> getEndOfLineMarkers() {
        return this.endOfLineMarkers;
    }
}

