/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes.internal;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.attributes.internal.AttributesOptions;
import com.vladsch.flexmark.ext.attributes.internal.NodeAttributeRepository;
import com.vladsch.flexmark.html.AttributeProvider;
import com.vladsch.flexmark.html.IndependentAttributeProviderFactory;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.CoreNodeRenderer;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.html.MutableAttributes;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class AttributesAttributeProvider
implements AttributeProvider {
    private final NodeAttributeRepository nodeAttributeRepository;
    private final AttributesOptions attributeOptions;

    public AttributesAttributeProvider(LinkResolverContext context) {
        DataHolder options = context.getOptions();
        this.attributeOptions = new AttributesOptions(options);
        this.nodeAttributeRepository = AttributesExtension.NODE_ATTRIBUTES.get(options);
    }

    @Override
    public void setAttributes(@NotNull Node node, @NotNull AttributablePart part, @NotNull MutableAttributes attributes) {
        Object nodeAttributesList;
        if ((part == CoreNodeRenderer.CODE_CONTENT ? this.attributeOptions.fencedCodeAddAttributes.addToCode : this.attributeOptions.fencedCodeAddAttributes.addToPre) && (nodeAttributesList = this.nodeAttributeRepository.get(node)) != null) {
            Iterator iterator2 = ((ArrayList)nodeAttributesList).iterator();
            while (iterator2.hasNext()) {
                AttributesNode nodeAttributes = (AttributesNode)iterator2.next();
                for (Node attribute : nodeAttributes.getChildren()) {
                    if (!(attribute instanceof AttributeNode)) continue;
                    AttributeNode attributeNode = (AttributeNode)attribute;
                    if (!attributeNode.isImplicitName()) {
                        BasedSequence attributeNodeName = attributeNode.getName();
                        if (!attributeNodeName.isNotNull() || attributeNodeName.isBlank()) continue;
                        if (!attributeNodeName.equals("class")) {
                            attributes.remove(attributeNodeName);
                        }
                        attributes.addValue(attributeNodeName, attributeNode.getValue());
                        continue;
                    }
                    if (attributeNode.isClass()) {
                        attributes.addValue("class", attributeNode.getValue());
                        continue;
                    }
                    if (attributeNode.isId()) {
                        if (node instanceof AnchorRefTarget) continue;
                        attributes.remove("id");
                        attributes.addValue("id", attributeNode.getValue());
                        continue;
                    }
                    throw new IllegalStateException("Implicit attribute yet not class or id");
                }
            }
        }
    }

    public static class Factory
    extends IndependentAttributeProviderFactory {
        @Override
        @NotNull
        public AttributeProvider apply(@NotNull LinkResolverContext context) {
            return new AttributesAttributeProvider(context);
        }
    }
}

