/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout.fontstore;

import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.extend.FSCacheEx;
import com.openhtmltopdf.extend.FSCacheValue;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.FontFaceFontSupplier;
import com.openhtmltopdf.outputdevice.helper.FontFamily;
import com.openhtmltopdf.outputdevice.helper.FontResolverHelper;
import com.openhtmltopdf.pdfboxout.PDFontSupplier;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.fontstore.AbstractFontStore;
import com.openhtmltopdf.pdfboxout.fontstore.FontUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;

public class MainFontStore
extends AbstractFontStore
implements Closeable {
    private final Map<String, FontFamily<PdfBoxFontResolver.FontDescription>> _fontFamilies = new HashMap<String, FontFamily<PdfBoxFontResolver.FontDescription>>();
    private final FSCacheEx<String, FSCacheValue> _fontMetricsCache;
    private final PDDocument _doc;
    private final SharedContext _sharedContext;
    private final List<TrueTypeCollection> _collectionsToClose = new ArrayList<TrueTypeCollection>();

    public MainFontStore(SharedContext sharedContext, PDDocument doc, FSCacheEx<String, FSCacheValue> pdfMetricsCache) {
        this._sharedContext = sharedContext;
        this._doc = doc;
        this._fontMetricsCache = pdfMetricsCache;
    }

    @Override
    public void close() throws IOException {
        for (TrueTypeCollection collection : this._collectionsToClose) {
            FontUtil.tryClose(collection);
        }
        this._collectionsToClose.clear();
    }

    void addFont(TrueTypeFont trueTypeFont, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) throws IOException {
        PDType0Font font = PDType0Font.load(this._doc, trueTypeFont, subset);
        this.addFontLazy(new PDFontSupplier(font), fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
    }

    public void addFontLazy(FSSupplier<PDFont> font, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) {
        FontFamily<PdfBoxFontResolver.FontDescription> fontFamily = this.getFontFamily(fontFamilyNameOverride);
        PdfBoxFontResolver.FontDescription descr = new PdfBoxFontResolver.FontDescription(this._doc, font, FontUtil.normalizeFontStyle(fontStyleOverride), FontUtil.normalizeFontWeight(fontWeightOverride), fontFamilyNameOverride, false, subset, this._fontMetricsCache);
        this.addFontToFamily(subset, fontFamily, descr);
    }

    public void addFontCollection(TrueTypeCollection collection, final String fontFamilyNameOverride, final Integer fontWeightOverride, final IdentValue fontStyleOverride, final boolean subset) throws IOException {
        collection.processAllFonts(new TrueTypeCollection.TrueTypeFontProcessor(){

            @Override
            public void process(TrueTypeFont ttf) throws IOException {
                MainFontStore.this.addFont(ttf, fontFamilyNameOverride, fontWeightOverride, fontStyleOverride, subset);
            }
        });
        this._collectionsToClose.add(collection);
    }

    public void addFontFaceFont(String fontFamilyName, IdentValue fontWeight, IdentValue fontStyle, String uri, boolean subset) {
        FontFaceFontSupplier fontSupplier = new FontFaceFontSupplier(this._sharedContext, uri);
        FontFamily<PdfBoxFontResolver.FontDescription> fontFamily = this.getFontFamily(fontFamilyName);
        PdfBoxFontResolver.FontDescription description2 = new PdfBoxFontResolver.FontDescription(this._doc, fontSupplier, FontUtil.normalizeFontWeight(fontWeight), FontUtil.normalizeFontStyle(fontStyle), fontFamilyName, true, subset, this._fontMetricsCache);
        this.addFontToFamily(subset, fontFamily, description2);
    }

    public void addFont(FSSupplier<InputStream> supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) {
        FontFamily<PdfBoxFontResolver.FontDescription> fontFamily = this.getFontFamily(fontFamilyNameOverride);
        PdfBoxFontResolver.FontDescription descr = new PdfBoxFontResolver.FontDescription(this._doc, supplier, FontUtil.normalizeFontWeight(fontWeightOverride), FontUtil.normalizeFontStyle(fontStyleOverride), fontFamilyNameOverride, false, subset, this._fontMetricsCache);
        this.addFontToFamily(subset, fontFamily, descr);
    }

    public void addFont(PDFontSupplier supplier, String fontFamilyNameOverride, Integer fontWeightOverride, IdentValue fontStyleOverride, boolean subset) {
        FontFamily<PdfBoxFontResolver.FontDescription> fontFamily = this.getFontFamily(fontFamilyNameOverride);
        PdfBoxFontResolver.FontDescription descr = new PdfBoxFontResolver.FontDescription(this._doc, supplier, FontUtil.normalizeFontStyle(fontStyleOverride), FontUtil.normalizeFontWeight(fontWeightOverride), fontFamilyNameOverride, false, subset, this._fontMetricsCache);
        this.addFontToFamily(subset, fontFamily, descr);
    }

    @Override
    public PdfBoxFontResolver.FontDescription resolveFont(SharedContext ctx2, String fontFamily, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        String normalizedFontFamily = FontUtil.normalizeFontFamily(fontFamily);
        FontFamily<PdfBoxFontResolver.FontDescription> family = this._fontFamilies.get(normalizedFontFamily);
        if (family != null) {
            return family.match(FontResolverHelper.convertWeightToInt(weight), style);
        }
        return null;
    }

    private void addFontToFamily(boolean subset, FontFamily<PdfBoxFontResolver.FontDescription> fontFamily, PdfBoxFontResolver.FontDescription descr) {
        if (!subset) {
            if (descr.realizeFont()) {
                fontFamily.addFontDescription(descr);
            }
        } else {
            fontFamily.addFontDescription(descr);
        }
    }

    private FontFamily<PdfBoxFontResolver.FontDescription> getFontFamily(String fontFamilyName) {
        return this._fontFamilies.computeIfAbsent(fontFamilyName, name -> new FontFamily(fontFamilyName));
    }
}

