/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif.model.streaming;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class GeneratingIterator<T>
implements Iterator<T> {
    private T next = null;
    private State state = State.INITIAL_UNINITIALIZED;

    protected abstract T makeInitial();

    protected abstract T makeNext(T var1);

    @Override
    public boolean hasNext() {
        if (this.state == State.DONE) {
            return false;
        }
        if (this.state == State.INITIAL_UNINITIALIZED) {
            this.next = this.makeInitial();
            this.state = State.NEXT_KNOWN;
        } else if (this.state == State.NEXT_UNKNOWN) {
            this.next = this.makeNext(this.next);
            this.state = State.NEXT_KNOWN;
        }
        if (this.next == null) {
            this.state = State.DONE;
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NEXT_UNKNOWN;
        return this.next;
    }

    private static enum State {
        INITIAL_UNINITIALIZED,
        NEXT_UNKNOWN,
        NEXT_KNOWN,
        DONE;

    }
}

