/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.tokenizer;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.tokenizer.Tokenizer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0016\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\t0\n2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie;", "", "tokenizer", "Lorg/jetbrains/completion/full/line/tokenizer/Tokenizer;", "<init>", "(Lorg/jetbrains/completion/full/line/tokenizer/Tokenizer;)V", "getTokenizer", "()Lorg/jetbrains/completion/full/line/tokenizer/Tokenizer;", "sortedVocabEntries", "", "Lkotlin/Pair;", "", "", "root", "Lorg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie$TrieNode;", "getValuesWithCompletionAwarePrefix", "", "prefix", "getValuesWithPrefix", "strict", "", "getInternalValuesWithPrefix", "findTrie", "word", "TrieNode", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nTokenizerTrie.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenizerTrie.kt\norg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1053#2:122\n1567#2:123\n1598#2,4:124\n1557#2:128\n1628#2,3:129\n774#2:132\n865#2,2:133\n1557#2:135\n1628#2,3:136\n1557#2:139\n1628#2,3:140\n1611#2,9:143\n1863#2:152\n1864#2:154\n1620#2:155\n1#3:153\n1#3:156\n*S KotlinDebug\n*F\n+ 1 TokenizerTrie.kt\norg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie\n*L\n9#1:122\n14#1:123\n14#1:124,4\n22#1:128\n22#1:129,3\n23#1:132\n23#1:133,2\n34#1:135\n34#1:136,3\n38#1:139\n38#1:140,3\n44#1:143,9\n44#1:152\n44#1:154\n44#1:155\n44#1:153\n*E\n"})
public final class TokenizerTrie {
    @NotNull
    private final Tokenizer tokenizer;
    @NotNull
    private final List<Pair<String, Integer>> sortedVocabEntries;
    @NotNull
    private final TrieNode root;

    /*
     * WARNING - void declaration
     */
    public TokenizerTrie(@NotNull Tokenizer tokenizer) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.tokenizer = tokenizer;
        Iterable $this$sortedBy$iv = MapsKt.toList(this.tokenizer.getVocab());
        boolean $i$f$sortedBy = false;
        this.sortedVocabEntries = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
            }
        });
        this.root = new TrieNode();
        Iterable $this$mapIndexed$iv = this.sortedVocabEntries;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void pair2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair3 = (Pair)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.root.addWord$intellij_fullLine_local((String)pair2.getFirst(), (int)index);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.root.trimSubtree$intellij_fullLine_local();
    }

    @NotNull
    public final Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] getValuesWithCompletionAwarePrefix(@NotNull String prefix) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        List<Integer> answer = this.getInternalValuesWithPrefix(prefix, false);
        Iterable $this$map$iv = answer;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)this.sortedVocabEntries.get((int)it).getFirst());
        }
        List answerStrings = (List)destination$iv$iv;
        Iterable $this$filter$iv = answerStrings;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            int subPrefixLen = it.length();
            if (prefix.length() > subPrefixLen) {
                String toComplete;
                Intrinsics.checkNotNullExpressionValue((Object)prefix.substring(subPrefixLen), (String)"substring(...)");
                bl = !((Collection)this.getInternalValuesWithPrefix(toComplete, true)).isEmpty();
            } else {
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List completableAnswerStrings = (List)destination$iv$iv2;
        Iterable $this$map$iv2 = completableAnswerStrings;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(((Number)MapsKt.getValue(this.tokenizer.getVocab(), (Object)it)).intValue());
        }
        return CollectionsKt.toIntArray((Collection)((List)destination$iv$iv2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] getValuesWithPrefix(@NotNull String prefix, boolean strict) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Iterable $this$map$iv = this.getInternalValuesWithPrefix(prefix, strict);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)this.sortedVocabEntries.get((int)it).getSecond()).intValue());
        }
        return CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getInternalValuesWithPrefix(String prefix, boolean strict) {
        Object answer;
        Pair<TrieNode, List<TrieNode>> pair2 = this.findTrie(prefix);
        TrieNode foundTrie = (TrieNode)pair2.component1();
        List path2 = (List)pair2.component2();
        Object object = foundTrie;
        if (object == null || (object = ((TrieNode)object).getSubtrieValues$intellij_fullLine_local()) == null) {
            object = answer = CollectionsKt.emptyList();
        }
        if (!strict) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = path2;
            Collection collection = (Collection)answer;
            boolean $i$f$mapNotNull = false;
            void var9_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                TrieNode it = (TrieNode)element$iv$iv;
                boolean bl2 = false;
                if (it.getValueOrNull() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            answer = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        }
        return answer;
    }

    private final Pair<TrieNode, List<TrieNode>> findTrie(String word) {
        if (((CharSequence)word).length() == 0) {
            return new Pair(null, (Object)CollectionsKt.emptyList());
        }
        TrieNode curNode = null;
        curNode = this.root;
        TrieNode newNode = null;
        List path2 = new ArrayList();
        int n = word.length();
        for (int i = 0; i < n; ++i) {
            char c = word.charAt(i);
            path2.add(curNode);
            newNode = TrieNode.moveByChar$intellij_fullLine_local$default(curNode, c, false, 2, null);
            if (newNode == null) break;
            boolean bl = false;
            curNode = newNode;
        }
        return new Pair(newNode, (Object)path2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0018J!\u0010\u0019\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lorg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie$TrieNode;", "", "<init>", "()V", "value", "", "start", "end", "moves", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "getValueOrNull", "()Ljava/lang/Integer;", "getStartOrNull", "getEndOrNull", "subtrieValues", "", "getSubtrieValues$intellij_fullLine_local", "()Ljava/util/List;", "addWord", "", "word", "", "addWord$intellij_fullLine_local", "trimSubtree", "trimSubtree$intellij_fullLine_local", "moveByChar", "char", "", "createNew", "", "moveByChar$intellij_fullLine_local", "updateSubtrie", "intellij.fullLine.local"})
    @SourceDebugExtension(value={"SMAP\nTokenizerTrie.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenizerTrie.kt\norg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie$TrieNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,121:1\n1#2:122\n216#3,2:123\n*S KotlinDebug\n*F\n+ 1 TokenizerTrie.kt\norg/jetbrains/completion/full/line/local/tokenizer/TokenizerTrie$TrieNode\n*L\n100#1:123,2\n*E\n"})
    public static final class TrieNode {
        private int value = -1;
        private int start = -1;
        private int end = -1;
        @NotNull
        private final Int2ObjectOpenHashMap<TrieNode> moves = new Int2ObjectOpenHashMap();

        @Nullable
        public final Integer getValueOrNull() {
            Integer n = this.value;
            int it = ((Number)n).intValue();
            boolean bl = false;
            return it >= 0 ? n : null;
        }

        private final Integer getStartOrNull() {
            Integer n = this.start;
            int it = ((Number)n).intValue();
            boolean bl = false;
            return it >= 0 ? n : null;
        }

        private final Integer getEndOrNull() {
            Integer n = this.end;
            int it = ((Number)n).intValue();
            boolean bl = false;
            return it >= 0 ? n : null;
        }

        @NotNull
        public final List<Integer> getSubtrieValues$intellij_fullLine_local() {
            Integer n = this.getStartOrNull();
            if (n == null) {
                return CollectionsKt.emptyList();
            }
            Integer n2 = this.getEndOrNull();
            if (n2 == null) {
                return CollectionsKt.emptyList();
            }
            return CollectionsKt.toList((Iterable)((Iterable)new IntRange(n.intValue(), n2.intValue())));
        }

        public final void addWord$intellij_fullLine_local(@NotNull String word, int value) {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            if (!(value >= 0)) {
                boolean bl = false;
                String string = "Value must be >= 0. We use -1 instead of null for RAM optimization";
                throw new IllegalArgumentException(string.toString());
            }
            TrieNode curNode = this;
            curNode.updateSubtrie(value);
            int n = word.length();
            for (int i = 0; i < n; ++i) {
                char c = word.charAt(i);
                Intrinsics.checkNotNull((Object)curNode.moveByChar$intellij_fullLine_local(c, true));
                curNode.updateSubtrie(value);
            }
            curNode.value = value;
        }

        public final void trimSubtree$intellij_fullLine_local() {
            this.moves.trim();
            Map $this$forEach$iv = (Map)this.moves;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                TrieNode u = (TrieNode)entry.getValue();
                u.trimSubtree$intellij_fullLine_local();
            }
        }

        @Nullable
        public final TrieNode moveByChar$intellij_fullLine_local(char c, boolean createNew) {
            char charCode = c;
            if (!this.moves.containsKey((int)charCode)) {
                if (createNew) {
                    Integer n = charCode;
                    ((Map)this.moves).put(n, new TrieNode());
                } else {
                    return null;
                }
            }
            return (TrieNode)MapsKt.getValue((Map)((Map)this.moves), (Object)charCode);
        }

        public static /* synthetic */ TrieNode moveByChar$intellij_fullLine_local$default(TrieNode trieNode, char c, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return trieNode.moveByChar$intellij_fullLine_local(c, bl);
        }

        private final void updateSubtrie(int value) {
            int n;
            int n2;
            int n3;
            int it;
            TrieNode trieNode;
            if (!(value >= 0)) {
                boolean bl = false;
                String string = "Value must be >= 0. We use -1 instead of null for RAM optimization";
                throw new IllegalArgumentException(string.toString());
            }
            TrieNode trieNode2 = this;
            Integer n4 = this.getStartOrNull();
            if (n4 != null) {
                int n5 = ((Number)n4).intValue();
                trieNode = trieNode2;
                boolean bl = false;
                n3 = Math.min(it, value);
                trieNode2 = trieNode;
                n2 = n3;
            } else {
                n2 = value;
            }
            trieNode2.start = n2;
            TrieNode trieNode3 = this;
            Integer n6 = this.getEndOrNull();
            if (n6 != null) {
                it = ((Number)n6).intValue();
                trieNode = trieNode3;
                boolean bl = false;
                n3 = Math.max(it, value);
                trieNode3 = trieNode;
                n = n3;
            } else {
                n = value;
            }
            trieNode3.end = n;
        }
    }
}

