/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentCategorizer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.settingsSync.core.SettingsSyncSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a8\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00062\u0006\u0010\b\u001a\u00020\u00032\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b0\nH\u0002\u001a\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0003\u001a \u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b0\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\"*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"isSyncCategoryEnabled", "", "fileSpec", "", "removeOsPrefix", "getRoamableCategory", "Lkotlin/Pair;", "Lcom/intellij/openapi/components/SettingsCategory;", "fileName", "componentClasses", "", "Ljava/lang/Class;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "", "roamambleCategoryCache", "Ljava/util/concurrent/ConcurrentHashMap;", "getSchemeCategory", "getSubCategory", "findComponentClasses", "intellij.settingsSync.core"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncFiltering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncFiltering.kt\ncom/intellij/settingsSync/core/SettingsSyncFilteringKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,115:1\n1863#2:116\n1864#2:118\n1#3:117\n12574#4,2:119\n*S KotlinDebug\n*F\n+ 1 SettingsSyncFiltering.kt\ncom/intellij/settingsSync/core/SettingsSyncFilteringKt\n*L\n37#1:116\n37#1:118\n108#1:119,2\n*E\n"})
public final class SettingsSyncFilteringKt {
    @NotNull
    private static final ConcurrentHashMap<String, Pair<SettingsCategory, String>> roamambleCategoryCache = new ConcurrentHashMap();

    public static final boolean isSyncCategoryEnabled(@NotNull String fileSpec) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        String rawFileSpec = SettingsSyncFilteringKt.removeOsPrefix(fileSpec);
        if (Intrinsics.areEqual((Object)rawFileSpec, (Object)"settingsSync.xml")) {
            return true;
        }
        Pair<SettingsCategory, String> pair = SettingsSyncFilteringKt.getSchemeCategory(rawFileSpec);
        if (pair == null && (pair = SettingsSyncFilteringKt.getRoamableCategory(rawFileSpec)) == null) {
            return false;
        }
        Pair<SettingsCategory, String> pair2 = pair;
        SettingsCategory category = (SettingsCategory)pair2.component1();
        String subCategory = (String)pair2.component2();
        if (category != SettingsCategory.OTHER && SettingsSyncSettings.Companion.getInstance().isCategoryEnabled(category)) {
            if (subCategory != null) {
                return SettingsSyncSettings.Companion.getInstance().isSubcategoryEnabled(category, subCategory);
            }
            return true;
        }
        return false;
    }

    private static final String removeOsPrefix(String fileSpec) {
        String string;
        String osPrefix = StoreUtilKt.getPerOsSettingsStorageFolderName() + "/";
        if (StringsKt.startsWith$default((String)fileSpec, (String)osPrefix, (boolean)false, (int)2, null)) {
            String string2 = StringUtil.trimStart((String)fileSpec, (String)osPrefix);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trimStart(...)");
        } else {
            string = fileSpec;
        }
        return string;
    }

    private static final Pair<SettingsCategory, String> getRoamableCategory(String fileName, List<Class<PersistentStateComponent<Object>>> componentClasses) {
        Iterable $this$forEach$iv = componentClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Storage storage;
            Storage storage2;
            SettingsCategory category;
            block2: {
                Class it = (Class)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)ComponentCategorizer.getCategory((Class)it), (String)"getCategory(...)");
                if (category == SettingsCategory.OTHER) continue;
                State state = it.getAnnotation(State.class);
                Storage[] storageArray = state.storages();
                int n = storageArray.length;
                for (int i = 0; i < n; ++i) {
                    Storage storage3;
                    Storage it2 = storage3 = storageArray[i];
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.value(), (Object)fileName)) continue;
                    storage2 = storage3;
                    break block2;
                }
                storage2 = null;
            }
            if ((storage = storage2) == null || !storage.roamingType().isRoamable()) continue;
            return TuplesKt.to((Object)category, (Object)SettingsSyncFilteringKt.getSubCategory(fileName));
        }
        return TuplesKt.to((Object)SettingsCategory.OTHER, null);
    }

    @Nullable
    public static final Pair<SettingsCategory, String> getRoamableCategory(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Pair<SettingsCategory, String> pair = roamambleCategoryCache.get(fileName);
        if (pair != null) {
            Pair<SettingsCategory, String> cachedCategory = pair;
            boolean bl = false;
            return cachedCategory;
        }
        List<Class<PersistentStateComponent<Object>>> componentClasses = SettingsSyncFilteringKt.findComponentClasses(fileName);
        if (componentClasses.isEmpty()) {
            return null;
        }
        Pair<SettingsCategory, String> pair2 = SettingsSyncFilteringKt.getSchemeCategory(fileName);
        if (pair2 == null) {
            pair2 = SettingsSyncFilteringKt.getRoamableCategory(fileName, componentClasses);
        }
        Pair<SettingsCategory, String> category = pair2;
        ((Map)roamambleCategoryCache).put(fileName, category);
        return category;
    }

    private static final Pair<SettingsCategory, String> getSchemeCategory(String fileSpec) {
        String string;
        int separatorIndex = StringsKt.indexOf$default((CharSequence)fileSpec, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (separatorIndex >= 0) {
            String string2 = fileSpec.substring(0, separatorIndex);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = fileSpec;
        }
        String directoryName = string;
        Ref.ObjectRef settingsCategory = new Ref.ObjectRef();
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        Intrinsics.checkNotNull((Object)schemeManagerFactory, (String)"null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase");
        ((SchemeManagerFactoryBase)schemeManagerFactory).process(arg_0 -> SettingsSyncFilteringKt.getSchemeCategory$lambda$3(directoryName, settingsCategory, arg_0));
        if (settingsCategory.element == null) {
            return null;
        }
        Object object = settingsCategory.element;
        Intrinsics.checkNotNull((Object)object);
        return TuplesKt.to((Object)object, null);
    }

    private static final String getSubCategory(String fileSpec) {
        if (Intrinsics.areEqual((Object)fileSpec, (Object)"editor-font.xml")) {
            return "editorFont";
        }
        return null;
    }

    private static final List<Class<PersistentStateComponent<Object>>> findComponentClasses(String fileSpec) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
        ComponentManagerImpl componentManager = (ComponentManagerImpl)application;
        ArrayList componentClasses = new ArrayList();
        componentManager.processAllImplementationClasses((arg_0, arg_1) -> SettingsSyncFilteringKt.findComponentClasses$lambda$5(fileSpec, componentClasses, arg_0, arg_1));
        return componentClasses;
    }

    private static final Unit getSchemeCategory$lambda$3(String $directoryName, Ref.ObjectRef $settingsCategory, SchemeManagerImpl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)it.getFileSpec(), (Object)$directoryName)) {
            $settingsCategory.element = it.getSettingsCategory();
        }
        return Unit.INSTANCE;
    }

    private static final Unit findComponentClasses$lambda$5(String $fileSpec, ArrayList $componentClasses, Class aClass, PluginDescriptor pluginDescriptor) {
        block6: {
            block7: {
                boolean bl;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
                    if (!PersistentStateComponent.class.isAssignableFrom(aClass)) break block6;
                    State state = aClass.getAnnotation(State.class);
                    if (state == null) {
                        return Unit.INSTANCE;
                    }
                    State state2 = state;
                    if (((CharSequence)state2.additionalExportDirectory()).length() > 0 && (Intrinsics.areEqual((Object)$fileSpec, (Object)state2.additionalExportDirectory()) || StringsKt.startsWith$default((String)$fileSpec, (String)(state2.additionalExportDirectory() + "/"), (boolean)false, (int)2, null))) break block7;
                    Storage[] $this$any$iv = state2.storages();
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Storage element$iv;
                        Storage storage = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!(!storage.deprecated() && Intrinsics.areEqual((Object)storage.value(), (Object)$fileSpec))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                if (!bl) break block6;
            }
            $componentClasses.add(aClass);
        }
        return Unit.INSTANCE;
    }
}

