/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.stubs.PyNamedTupleStubType;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.stubs.PyNamedTupleStub;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyNamedTupleStubImpl
implements PyNamedTupleStub {
    @Nullable
    private final QualifiedName myCalleeName;
    @NotNull
    private final String myName;
    @NotNull
    private final LinkedHashMap<String, Optional<String>> myFields;

    private PyNamedTupleStubImpl(@Nullable QualifiedName calleeName, @NotNull String name2, @NotNull LinkedHashMap<String, Optional<String>> fields) {
        if (name2 == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(0);
        }
        if (fields == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(1);
        }
        this.myCalleeName = calleeName;
        this.myName = name2;
        this.myFields = fields;
    }

    @Nullable
    public static PyNamedTupleStub create(@NotNull PyTargetExpression expression) {
        PyExpression assignedValue;
        if (expression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(2);
        }
        if ((assignedValue = expression.findAssignedValue()) instanceof PyCallExpression) {
            return PyNamedTupleStubImpl.create((PyCallExpression)assignedValue);
        }
        return null;
    }

    @Nullable
    public static PyNamedTupleStub create(@NotNull PyCallExpression expression) {
        PyReferenceExpression calleeReference;
        if (expression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(3);
        }
        if ((calleeReference = PyUtil.as(expression.getCallee(), PyReferenceExpression.class)) == null) {
            return null;
        }
        Pair<QualifiedName, NamedTupleModule> calleeNameAndModule = PyNamedTupleStubImpl.getCalleeNameAndNTModule(calleeReference);
        if (calleeNameAndModule != null) {
            String name2 = PyResolveUtil.resolveStrArgument(expression, 0, "typename");
            if (name2 == null) {
                return null;
            }
            LinkedHashMap<String, Optional<String>> fields = PyNamedTupleStubImpl.resolveTupleFields(expression, (NamedTupleModule)((Object)calleeNameAndModule.getSecond()));
            if (fields == null) {
                return null;
            }
            return new PyNamedTupleStubImpl((QualifiedName)calleeNameAndModule.getFirst(), name2, fields);
        }
        return null;
    }

    @Nullable
    public static PyNamedTupleStub deserialize(@NotNull StubInputStream stream) throws IOException {
        if (stream == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(4);
        }
        String calleeName = stream.readNameString();
        String name2 = stream.readNameString();
        LinkedHashMap<String, Optional<String>> fields = PyNamedTupleStubImpl.deserializeFields(stream, stream.readVarInt());
        if (calleeName == null || name2 == null) {
            return null;
        }
        return new PyNamedTupleStubImpl(QualifiedName.fromDottedString((String)calleeName), name2, fields);
    }

    @NotNull
    public Class<PyNamedTupleStubType> getTypeClass() {
        return PyNamedTupleStubType.class;
    }

    @Override
    public void serialize(@NotNull StubOutputStream stream) throws IOException {
        if (stream == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(5);
        }
        stream.writeName(this.myCalleeName == null ? null : this.myCalleeName.toString());
        stream.writeName(this.myName);
        stream.writeVarInt(this.myFields.size());
        for (Map.Entry<String, Optional<String>> entry : this.myFields.entrySet()) {
            stream.writeName(entry.getKey());
            stream.writeName((String)entry.getValue().orElse(null));
        }
    }

    @Override
    @Nullable
    public QualifiedName getCalleeName() {
        return this.myCalleeName;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public Map<String, Optional<String>> getFields() {
        LinkedHashMap<String, Optional<String>> linkedHashMap = this.myFields;
        if (linkedHashMap == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(7);
        }
        return linkedHashMap;
    }

    @Nullable
    private static Pair<QualifiedName, NamedTupleModule> getCalleeNameAndNTModule(@NotNull PyReferenceExpression referenceExpression) {
        QualifiedName calleeName;
        if (referenceExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(8);
        }
        if ((calleeName = PyPsiUtils.asQualifiedName(referenceExpression)) == null) {
            return null;
        }
        for (String name2 : ContainerUtil.map(PyResolveUtil.resolveImportedElementQNameLocally(referenceExpression), QualifiedName::toString)) {
            if (name2.equals("collections.namedtuple")) {
                return Pair.createNonNull((Object)calleeName, (Object)((Object)NamedTupleModule.COLLECTIONS));
            }
            if (!name2.equals("typing.NamedTuple")) continue;
            return Pair.createNonNull((Object)calleeName, (Object)((Object)NamedTupleModule.TYPING));
        }
        return null;
    }

    @Nullable
    private static LinkedHashMap<String, Optional<String>> resolveTupleFields(@NotNull PyCallExpression callExpression, @NotNull NamedTupleModule module) {
        if (callExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(9);
        }
        if (module == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(10);
        }
        return switch (module) {
            default -> throw new IncompatibleClassChangeError();
            case NamedTupleModule.TYPING -> PyNamedTupleStubImpl.resolveTypingNTFields(callExpression);
            case NamedTupleModule.COLLECTIONS -> PyNamedTupleStubImpl.resolveCollectionsNTFields(callExpression);
        };
    }

    @NotNull
    private static LinkedHashMap<String, Optional<String>> deserializeFields(@NotNull StubInputStream stream, int fieldsSize) throws IOException {
        if (stream == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(11);
        }
        LinkedHashMap<String, Optional<String>> fields = new LinkedHashMap<String, Optional<String>>(fieldsSize);
        for (int i = 0; i < fieldsSize; ++i) {
            String name2 = stream.readNameString();
            String type2 = stream.readNameString();
            if (name2 == null) continue;
            fields.put(name2, Optional.ofNullable(type2));
        }
        LinkedHashMap<String, Optional<String>> linkedHashMap = fields;
        if (linkedHashMap == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(12);
        }
        return linkedHashMap;
    }

    @Nullable
    private static LinkedHashMap<String, Optional<String>> resolveCollectionsNTFields(@NotNull PyCallExpression callExpression) {
        PyExpression fields;
        if (callExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(13);
        }
        PyExpression resolvedFields = (fields = PyNamedTupleStubImpl.getFieldsArgumentValue(callExpression, "field_names")) instanceof PyReferenceExpression ? PyResolveUtil.fullResolveLocally((PyReferenceExpression)fields) : fields;
        Collector<String, ?, LinkedHashMap> toFieldsOfUnknownType = Collectors.toMap(Function.identity(), key -> Optional.empty(), (v1, v2) -> v2, LinkedHashMap::new);
        List<String> listValue = PyUtil.strListValue(resolvedFields);
        if (listValue != null) {
            return listValue.contains(null) ? null : (LinkedHashMap)StreamEx.of(listValue).collect(toFieldsOfUnknownType);
        }
        String resolvedFieldsValue = PyPsiUtils.strValue(resolvedFields);
        if (resolvedFieldsValue == null) {
            return null;
        }
        return (LinkedHashMap)StreamEx.of(StringUtil.tokenize((String)resolvedFieldsValue, (String)", ").iterator()).collect(toFieldsOfUnknownType);
    }

    @Nullable
    private static LinkedHashMap<String, Optional<String>> resolveTypingNTFields(@NotNull PyCallExpression callExpression) {
        PyExpression resolvedFields;
        PyExpression fields;
        if (callExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(14);
        }
        if ((fields = PyNamedTupleStubImpl.getFieldsArgumentValue(callExpression, "fields")) instanceof PyKeywordArgument) {
            PyExpression[] arguments = callExpression.getArguments();
            return PyNamedTupleStubImpl.getTypingNTFieldsFromKwArguments(Arrays.asList(arguments).subList(1, arguments.length));
        }
        PyExpression pyExpression = resolvedFields = fields instanceof PyReferenceExpression ? PyResolveUtil.fullResolveLocally((PyReferenceExpression)fields) : fields;
        if (!(resolvedFields instanceof PySequenceExpression)) {
            return null;
        }
        return PyNamedTupleStubImpl.getTypingNTFieldsFromIterable((PySequenceExpression)resolvedFields);
    }

    @Nullable
    private static PyExpression getFieldsArgumentValue(@NotNull PyCallExpression callExpression, @NotNull String possibleKeyword) {
        if (callExpression == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(15);
        }
        if (possibleKeyword == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(16);
        }
        return PyPsiUtils.flattenParens((PyExpression)callExpression.getArgument(1, possibleKeyword, PyExpression.class));
    }

    @Nullable
    private static LinkedHashMap<String, Optional<String>> getTypingNTFieldsFromKwArguments(@NotNull List<PyExpression> arguments) {
        if (arguments == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(17);
        }
        LinkedHashMap<String, Optional<String>> result2 = new LinkedHashMap<String, Optional<String>>();
        for (PyExpression argument : arguments) {
            if (!(argument instanceof PyKeywordArgument)) {
                return null;
            }
            PyKeywordArgument keywordArgument = (PyKeywordArgument)argument;
            String keyword = keywordArgument.getKeyword();
            if (keyword == null) {
                return null;
            }
            result2.put(keyword, Optional.ofNullable(PyNamedTupleStubImpl.textIfPresent((PsiElement)keywordArgument.getValueExpression())));
        }
        return result2;
    }

    @Nullable
    private static LinkedHashMap<String, Optional<String>> getTypingNTFieldsFromIterable(@NotNull PySequenceExpression fields) {
        if (fields == null) {
            PyNamedTupleStubImpl.$$$reportNull$$$0(18);
        }
        LinkedHashMap<String, Optional<String>> result2 = new LinkedHashMap<String, Optional<String>>();
        for (PyExpression element : fields.getElements()) {
            if (!(element instanceof PyParenthesizedExpression)) {
                return null;
            }
            PyExpression contained = ((PyParenthesizedExpression)element).getContainedExpression();
            if (!(contained instanceof PyTupleExpression)) {
                return null;
            }
            Object[] nameAndType = ((PyTupleExpression)contained).getElements();
            PyExpression name2 = (PyExpression)ArrayUtil.getFirstElement((Object[])nameAndType);
            if (nameAndType.length != 2 || !(name2 instanceof PyStringLiteralExpression)) {
                return null;
            }
            result2.put(((PyStringLiteralExpression)name2).getStringValue(), Optional.ofNullable(PyNamedTupleStubImpl.textIfPresent((PsiElement)nameAndType[1])));
        }
        return result2;
    }

    @Nullable
    private static String textIfPresent(@Nullable PsiElement element) {
        return element == null ? null : element.getText();
    }

    public String toString() {
        return "PyNamedTupleStub(calleeName=" + this.myCalleeName + ", name=" + this.myName + ", fields=" + this.myFields + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/stubs/PyNamedTupleStubImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleKeyword";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/stubs/PyNamedTupleStubImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCalleeNameAndNTModule";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveTupleFields";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deserializeFields";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveCollectionsNTFields";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypingNTFields";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsArgumentValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypingNTFieldsFromKwArguments";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypingNTFieldsFromIterable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 12 -> new IllegalStateException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum NamedTupleModule {
        COLLECTIONS{

            @Override
            public String getModuleName() {
                return "collections";
            }
        }
        ,
        TYPING{

            @Override
            public String getModuleName() {
                return "typing";
            }
        };


        public abstract String getModuleName();
    }
}

