/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.util.LocalCommitCompareInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.branch.GitBranchWorker;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.util.GitFileUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitLocalCommitCompareInfo
extends LocalCommitCompareInfo {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myBranchName;

    public GitLocalCommitCompareInfo(@NotNull Project project, @NotNull String branchName) {
        if (project == null) {
            GitLocalCommitCompareInfo.$$$reportNull$$$0(0);
        }
        if (branchName == null) {
            GitLocalCommitCompareInfo.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myBranchName = branchName;
    }

    private void reloadTotalDiff() throws VcsException {
        HashMap<Repository, Collection<Change>> newDiff = new HashMap<Repository, Collection<Change>>();
        for (Repository repository : this.getRepositories()) {
            newDiff.put(repository, GitBranchWorker.loadTotalDiff(repository, this.myBranchName));
        }
        this.updateTotalDiff(newDiff);
    }

    public void copyChangesFromBranch(@NotNull List<? extends Change> changes, boolean swapSides) throws VcsException {
        Collection rootPaths;
        VirtualFile root;
        if (changes == null) {
            GitLocalCommitCompareInfo.$$$reportNull$$$0(2);
        }
        MultiMap toCheckout = MultiMap.createSet();
        MultiMap toDelete = MultiMap.createSet();
        for (Change change : changes) {
            FilePath branchPath;
            FilePath currentPath = swapSides ? ChangesUtil.getAfterPath((Change)change) : ChangesUtil.getBeforePath((Change)change);
            FilePath filePath = branchPath = !swapSides ? ChangesUtil.getAfterPath((Change)change) : ChangesUtil.getBeforePath((Change)change);
            assert (currentPath != null || branchPath != null);
            VirtualFile root2 = GitUtil.getRootForFile(this.myProject, (FilePath)ObjectUtils.chooseNotNull((Object)currentPath, (Object)branchPath));
            if (currentPath != null && branchPath != null) {
                if (!Comparing.equal((Object)currentPath, (Object)branchPath)) {
                    toDelete.putValue((Object)root2, (Object)currentPath);
                }
                toCheckout.putValue((Object)root2, (Object)branchPath);
                continue;
            }
            if (currentPath != null) {
                toDelete.putValue((Object)root2, (Object)currentPath);
                continue;
            }
            toCheckout.putValue((Object)root2, (Object)branchPath);
        }
        for (Map.Entry entry : toDelete.entrySet()) {
            root = (VirtualFile)entry.getKey();
            rootPaths = (Collection)entry.getValue();
            GitFileUtils.deletePaths(this.myProject, root, rootPaths, new String[0]);
        }
        for (Map.Entry entry : toCheckout.entrySet()) {
            root = (VirtualFile)entry.getKey();
            rootPaths = (Collection)entry.getValue();
            for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, (Collection)rootPaths)) {
                GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.CHECKOUT);
                handler.addParameters(this.myBranchName);
                handler.endOptions();
                handler.addParameters(paths);
                GitCommandResult result2 = Git.getInstance().runCommand(handler);
                result2.throwOnError(new int[0]);
            }
            GitFileUtils.addPaths(this.myProject, root, rootPaths);
        }
        RefreshVFsSynchronously.updateChanges(changes);
        VcsDirtyScopeManager.getInstance((Project)this.myProject).filePathsDirty((Collection)ChangesUtil.getPaths(changes), null);
        this.reloadTotalDiff();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        objectArray2[1] = "git4idea/util/GitLocalCommitCompareInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "copyChangesFromBranch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

