/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea.extensions;

import com.intellij.testFramework.SkipSlowTestLocally;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class SkipSlowExecutionCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"Enabled locally");
    private static final ConditionEvaluationResult DISABLED = ConditionEvaluationResult.disabled((String)"Slow tests are disabled locally");
    private static final boolean SKIP_SLOW_TESTS = System.getProperty("skip.slow.tests.locally") != null;

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context2) {
        if (!SKIP_SLOW_TESTS) {
            return ENABLED;
        }
        return AnnotationSupport.findAnnotation((Optional)context2.getTestClass(), SkipSlowTestLocally.class).isPresent() ? DISABLED : ENABLED;
    }
}

