/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.util.WaitForProgressToShow;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelveChangesCommitExecutor
extends LocalCommitExecutor {
    private static final Logger LOG = Logger.getInstance(ShelveChangesCommitExecutor.class);
    private final Project myProject;

    public ShelveChangesCommitExecutor(Project project) {
        this.myProject = project;
    }

    @NotNull
    @Nls
    public String getActionText() {
        String string = VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0]);
        if (string == null) {
            ShelveChangesCommitExecutor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public CommitSession createCommitSession(@NotNull CommitContext commitContext) {
        if (commitContext == null) {
            ShelveChangesCommitExecutor.$$$reportNull$$$0(1);
        }
        return new ShelveChangesCommitSession();
    }

    public String getHelpId() {
        return "reference.dialogs.vcs.shelve";
    }

    public boolean supportsPartialCommit() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesCommitExecutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesCommitExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCommitSession";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private class ShelveChangesCommitSession
    implements CommitSession {
        private ShelveChangesCommitSession() {
        }

        public void execute(@NotNull Collection<? extends Change> changes, @Nullable String commitMessage) {
            if (changes == null) {
                ShelveChangesCommitSession.$$$reportNull$$$0(0);
            }
            if (changes.size() > 0 && !ChangesUtil.hasFileChanges(changes)) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)ShelveChangesCommitExecutor.this.myProject, (String)VcsBundle.message((String)"shelve.changes.only.directories", (Object[])new Object[0]), (String)VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0])), null, (Project)ShelveChangesCommitExecutor.this.myProject);
                return;
            }
            try {
                ShelvedChangeList list = ShelveChangesManager.getInstance(ShelveChangesCommitExecutor.this.myProject).shelveChanges(changes, commitMessage, true, false, true);
                ShelvedChangesViewManager.getInstance(ShelveChangesCommitExecutor.this.myProject).activateView(list);
                Change[] changesArray = changes.toArray(Change.EMPTY_CHANGE_ARRAY);
                LocalChangeList changeList = ChangesUtil.getChangeListIfOnlyOne((Project)ShelveChangesCommitExecutor.this.myProject, (Change[])changesArray);
                if (changeList != null) {
                    ChangeListManager.getInstance((Project)ShelveChangesCommitExecutor.this.myProject).scheduleAutomaticEmptyChangeListDeletion(changeList, true);
                }
            }
            catch (Exception ex) {
                LOG.info((Throwable)ex);
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)ShelveChangesCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{ex.getMessage()}), (String)CommonBundle.getErrorTitle()), (ModalityState)ModalityState.nonModal(), (Project)ShelveChangesCommitExecutor.this.myProject);
            }
        }

        public String getHelpId() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesCommitExecutor$ShelveChangesCommitSession", "execute"));
        }
    }
}

