/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.format.l10n;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;

public class MultiPropertyResourceBundle
extends ResourceBundle {
    private String resourcePath = null;
    private final Map<String, Object> resources = new HashMap<String, Object>();
    private final StringBuilder mergedBundlePaths = new StringBuilder();

    public String getResourcePath() {
        return this.resourcePath;
    }

    public StringBuilder getMergedBundlePaths() {
        return this.mergedBundlePaths;
    }

    public MultiPropertyResourceBundle(InputStream stream, String resourcePath) throws IOException {
        PropertyResourceBundle resourceBundle = new PropertyResourceBundle(stream);
        this.resourcePath = resourcePath;
        this.merge(resourceBundle, resourcePath);
    }

    public MultiPropertyResourceBundle(ResourceBundle baseBundle, String resourcePath) {
        this.resourcePath = resourcePath;
        this.merge(baseBundle, resourcePath);
    }

    public void merge(ResourceBundle resourceBundle, String resourcePath) {
        if (resourceBundle != null) {
            Enumeration<String> keys = resourceBundle.getKeys();
            while (keys.hasMoreElements()) {
                String key2 = keys.nextElement();
                this.resources.put(key2, resourceBundle.getObject(key2));
            }
        }
        this.mergedBundlePaths.append(resourcePath);
        this.mergedBundlePaths.append(":");
    }

    @Override
    public Object handleGetObject(String key2) {
        if (key2 == null) {
            throw new NullPointerException();
        }
        return this.resources.get(key2);
    }

    @Override
    public Enumeration<String> getKeys() {
        Vector<String> keys = new Vector<String>(this.resources.keySet());
        return keys.elements();
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.resources.keySet();
    }

    @Override
    public boolean containsKey(String key2) {
        return this.resources.containsKey(key2);
    }

    @Override
    public Set<String> keySet() {
        return this.resources.keySet();
    }
}

