/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.dialog.DialogUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012*\u0010\u0007\u001a&\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u000b0\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010&\u001a\u00020'H\u0014J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001f0)H\u0014J\n\u0010*\u001a\u0004\u0018\u00010\u001fH\u0002J\n\u0010+\u001a\u0004\u0018\u00010\u001fH\u0002J\n\u0010,\u001a\u0004\u0018\u00010\u001fH\u0002J\b\u0010-\u001a\u00020\u0006H\u0014J\b\u0010.\u001a\u00020\u0006H\u0014J\b\u0010/\u001a\u00020\u0014H\u0016J\b\u00100\u001a\u00020\u0006H\u0007J\b\u00101\u001a\u00020\u0006H\u0007J\u0006\u00102\u001a\u00020\fJ\b\u00103\u001a\u00020\u0006H\u0007J\b\u00104\u001a\u0004\u0018\u00010\tJ\u0010\u00105\u001a\u00020$2\u0006\u00106\u001a\u00020\u0006H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\t0\t0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/plugins/github/ui/GithubShareDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "existingRemotes", "", "", "accountInformationSupplier", "Lkotlin/Function2;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "Ljava/awt/Component;", "Lkotlin/Pair;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Lkotlin/jvm/functions/Function2;)V", "GITHUB_REPO_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "repositoryTextField", "Lcom/intellij/ui/components/JBTextField;", "privateCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "remoteName", "remoteTextField", "descriptionTextArea", "Lcom/intellij/ui/components/JBTextArea;", "existingRepoValidator", "Lorg/jetbrains/plugins/github/ui/util/DialogValidationUtils$RecordUniqueValidator;", "existingRemoteValidator", "accountInformationLoadingError", "Lcom/intellij/openapi/ui/ValidationInfo;", "accounts", "accountsModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "switchAccount", "", "account", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "doValidateAll", "", "validateRepository", "validateRepositoryName", "validateRemote", "getHelpId", "getDimensionServiceKey", "getPreferredFocusedComponent", "getRepositoryName", "getRemoteName", "isPrivate", "getDescription", "getAccount", "testSetRepositoryName", "name", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGithubShareDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubShareDialog.kt\norg/jetbrains/plugins/github/ui/GithubShareDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
public final class GithubShareDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final Function2<GithubAccount, Component, Pair<Boolean, Set<String>>> accountInformationSupplier;
    private final Pattern GITHUB_REPO_PATTERN;
    @NotNull
    private final JBTextField repositoryTextField;
    @NotNull
    private final JBCheckBox privateCheckBox;
    @NlsSafe
    @NotNull
    private final String remoteName;
    @NotNull
    private final JBTextField remoteTextField;
    @NotNull
    private final JBTextArea descriptionTextArea;
    @NotNull
    private final DialogValidationUtils.RecordUniqueValidator existingRepoValidator;
    @NotNull
    private final DialogValidationUtils.RecordUniqueValidator existingRemoteValidator;
    @Nullable
    private ValidationInfo accountInformationLoadingError;
    @NotNull
    private final Set<GithubAccount> accounts;
    @NotNull
    private final CollectionComboBoxModel<GithubAccount> accountsModel;

    /*
     * WARNING - void declaration
     */
    public GithubShareDialog(@NotNull Project project, @NotNull Set<String> existingRemotes, @NotNull Function2<? super GithubAccount, ? super Component, ? extends Pair<Boolean, ? extends Set<String>>> accountInformationSupplier) {
        void $this$existingRemoteValidator_u24lambda_u241;
        Object $this$descriptionTextArea_u24lambda_u240;
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(existingRemotes, (String)"existingRemotes");
        Intrinsics.checkNotNullParameter(accountInformationSupplier, (String)"accountInformationSupplier");
        super(project);
        this.project = project;
        this.accountInformationSupplier = accountInformationSupplier;
        this.GITHUB_REPO_PATTERN = Pattern.compile("[a-zA-Z0-9_.-]+");
        this.repositoryTextField = new JBTextField(this.project.getName());
        this.privateCheckBox = new JBCheckBox(GithubBundle.message("share.dialog.private", new Object[0]), true);
        this.remoteName = existingRemotes.isEmpty() ? "origin" : "github";
        this.remoteTextField = new JBTextField(this.remoteName);
        JBTextArea jBTextArea = object = new JBTextArea();
        GithubShareDialog githubShareDialog = this;
        boolean bl = false;
        $this$descriptionTextArea_u24lambda_u240.setLineWrap(true);
        githubShareDialog.descriptionTextArea = object;
        JTextField jTextField = (JTextField)this.repositoryTextField;
        String string = GithubBundle.message("share.error.repo.with.selected.name.exists", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.existingRepoValidator = new DialogValidationUtils.RecordUniqueValidator(jTextField, string);
        JTextField jTextField2 = (JTextField)this.remoteTextField;
        String string2 = GithubBundle.message("share.error.remote.with.selected.name.exists", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$descriptionTextArea_u24lambda_u240 = object = new DialogValidationUtils.RecordUniqueValidator(jTextField2, string2);
        githubShareDialog = this;
        boolean bl2 = false;
        $this$existingRemoteValidator_u24lambda_u241.setRecords(existingRemotes);
        githubShareDialog.existingRemoteValidator = object;
        this.accounts = GHAccountsUtil.getAccounts();
        List list = CollectionsKt.toMutableList((Collection)this.accounts);
        GithubAccount githubAccount = GHAccountsUtil.getDefaultAccount(this.project);
        if (githubAccount == null) {
            githubAccount = (GithubAccount)((Object)CollectionsKt.firstOrNull((Iterable)this.accounts));
        }
        this.accountsModel = new CollectionComboBoxModel(list, (Object)githubAccount);
        this.setTitle(GithubBundle.message("share.on.github", new Object[0]));
        this.setOKButtonText(GithubBundle.message("share.button", new Object[0]));
        this.init();
        DialogUtils.invokeLaterAfterDialogShown((DialogWrapper)this, () -> GithubShareDialog._init_$lambda$2(this));
    }

    private final void switchAccount(GithubAccount account) {
        if (account == null) {
            return;
        }
        try {
            this.accountInformationLoadingError = null;
            Window window = this.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
            Pair it = (Pair)this.accountInformationSupplier.invoke((Object)account, (Object)window);
            boolean bl = false;
            this.privateCheckBox.setEnabled(((Boolean)it.getFirst()).booleanValue());
            if (!((Boolean)it.getFirst()).booleanValue()) {
                this.privateCheckBox.setToolTipText(GithubBundle.message("share.error.private.repos.not.supported", new Object[0]));
            } else {
                this.privateCheckBox.setToolTipText(null);
            }
            this.existingRepoValidator.setRecords((Set)it.getSecond());
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{account};
            String errorText = GithubBundle.message("share.dialog.account.info.load.error.prefix", objectArray) + (e instanceof ProcessCanceledException ? GithubBundle.message("share.dialog.account.info.load.process.canceled", new Object[0]) : e.getMessage());
            this.accountInformationLoadingError = new ValidationInfo(errorText);
            this.privateCheckBox.setEnabled(false);
            this.privateCheckBox.setToolTipText(null);
            this.existingRepoValidator.setRecords(SetsKt.emptySet());
            this.startTrackingValidation();
        }
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel $this$createCenterPanel_u24lambda_u2414 = dialogPanel = BuilderKt.panel(arg_0 -> GithubShareDialog.createCenterPanel$lambda$13(this, arg_0));
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u2414.setPreferredSize((Dimension)JBUI.size((int)500, (int)250));
        return dialogPanel;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        List list = super.doValidateAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"doValidateAll(...)");
        List uiErrors = list;
        ValidationInfo loadingError2 = this.accountInformationLoadingError;
        return loadingError2 != null ? CollectionsKt.plus((Collection)uiErrors, (Object)loadingError2) : uiErrors;
    }

    private final ValidationInfo validateRepository() {
        JTextField jTextField = (JTextField)this.repositoryTextField;
        String string = GithubBundle.message("share.validation.no.repo.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ValidationInfo validationInfo = DialogValidationUtils.INSTANCE.notBlank(jTextField, string);
        if (validationInfo == null && (validationInfo = this.validateRepositoryName()) == null) {
            validationInfo = this.existingRepoValidator.invoke();
        }
        return validationInfo;
    }

    private final ValidationInfo validateRepositoryName() {
        return this.GITHUB_REPO_PATTERN.matcher(this.repositoryTextField.getText()).matches() ? null : new ValidationInfo(GithubBundle.message("share.validation.invalid.repo.name", new Object[0]), (JComponent)this.repositoryTextField);
    }

    private final ValidationInfo validateRemote() {
        JTextField jTextField = (JTextField)this.remoteTextField;
        String string = GithubBundle.message("share.validation.no.remote.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ValidationInfo validationInfo = DialogValidationUtils.INSTANCE.notBlank(jTextField, string);
        if (validationInfo == null) {
            validationInfo = this.existingRemoteValidator.invoke();
        }
        return validationInfo;
    }

    @NotNull
    protected String getHelpId() {
        return "github.share";
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Github.ShareDialog";
    }

    @NotNull
    public JBTextField getPreferredFocusedComponent() {
        return this.repositoryTextField;
    }

    @NlsSafe
    @NotNull
    public final String getRepositoryName() {
        String string = this.repositoryTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NlsSafe
    @NotNull
    public final String getRemoteName() {
        String string = this.remoteTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public final boolean isPrivate() {
        return this.privateCheckBox.isSelected();
    }

    @NlsSafe
    @NotNull
    public final String getDescription() {
        String string = this.descriptionTextArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Nullable
    public final GithubAccount getAccount() {
        return (GithubAccount)((Object)this.accountsModel.getSelected());
    }

    @TestOnly
    public final void testSetRepositoryName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.repositoryTextField.setText(name);
    }

    private static final void _init_$lambda$2(GithubShareDialog this$0) {
        this$0.switchAccount(this$0.getAccount());
    }

    private static final ValidationInfo createCenterPanel$lambda$13$lambda$5$lambda$4(GithubShareDialog this$0, ValidationInfoBuilder $this$validationOnApply, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateRepository();
    }

    private static final Unit createCenterPanel$lambda$13$lambda$5(GithubShareDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.repositoryTextField).align((Align)AlignX.FILL.INSTANCE).validationOnApply((arg_0, arg_1) -> GithubShareDialog.createCenterPanel$lambda$13$lambda$5$lambda$4(this$0, arg_0, arg_1)).resizableColumn();
        $this$row.cell((JComponent)this$0.privateCheckBox);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$13$lambda$7$lambda$6(GithubShareDialog this$0, ValidationInfoBuilder $this$validationOnApply, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateRemote();
    }

    private static final Unit createCenterPanel$lambda$13$lambda$7(GithubShareDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.remoteTextField).align((Align)AlignX.FILL.INSTANCE).validationOnApply((arg_0, arg_1) -> GithubShareDialog.createCenterPanel$lambda$13$lambda$7$lambda$6(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$8(GithubShareDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GithubBundle.message("share.dialog.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).align((Align)AlignY.TOP.INSTANCE);
        $this$row.scrollCell((JComponent)this$0.descriptionTextArea).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$13$lambda$12$lambda$9(GithubShareDialog this$0, ValidationInfoBuilder $this$validationOnApply, ComboBox it) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.accountsModel.getSelected() == null) {
            String string = GithubBundle.message("dialog.message.account.cannot.be.empty", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            validationInfo = $this$validationOnApply.error(string);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final void createCenterPanel$lambda$13$lambda$12$lambda$11$lambda$10(GithubShareDialog this$0, ActionEvent it) {
        this$0.switchAccount(this$0.getAccount());
    }

    private static final Unit createCenterPanel$lambda$13$lambda$12$lambda$11(GithubShareDialog this$0, ComboBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener(arg_0 -> GithubShareDialog.createCenterPanel$lambda$13$lambda$12$lambda$11$lambda$10(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$12(GithubShareDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)this$0.accountsModel), null, (int)2, null).align((Align)AlignX.FILL.INSTANCE).validationOnApply((arg_0, arg_1) -> GithubShareDialog.createCenterPanel$lambda$13$lambda$12$lambda$9(this$0, arg_0, arg_1)).applyToComponent(arg_0 -> GithubShareDialog.createCenterPanel$lambda$13$lambda$12$lambda$11(this$0, arg_0)).resizableColumn();
        if (this$0.accountsModel.getSize() == 0) {
            $this$row.cell((JComponent)GHAccountsUtil.INSTANCE.createAddAccountLink(this$0.project, this$0.accountsModel));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13(GithubShareDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = GithubBundle.message("share.dialog.repo.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> GithubShareDialog.createCenterPanel$lambda$13$lambda$5(this$0, arg_0));
        String string2 = GithubBundle.message("share.dialog.remote", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> GithubShareDialog.createCenterPanel$lambda$13$lambda$7(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GithubShareDialog.createCenterPanel$lambda$13$lambda$8(this$0, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED).resizableRow();
        if (this$0.accountsModel.getSize() != 1) {
            String string3 = GithubBundle.message("share.dialog.share.by", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            $this$panel.row(string3, arg_0 -> GithubShareDialog.createCenterPanel$lambda$13$lambda$12(this$0, arg_0));
        }
        return Unit.INSTANCE;
    }
}

