/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment;

import com.intellij.markdown.utils.CodeFenceSyntaxHighlighterGeneratingProvider;
import com.intellij.markdown.utils.MarkdownToHtmlConverter;
import com.intellij.markdown.utils.lang.CodeBlockHtmlSyntaxHighlighter;
import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import java.net.URI;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.comment.GHSuggestionHtmlSyntaxHighlighter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0003\u0010\u0011\u0012B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u000b\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\bJ2\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u000b\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u000b\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\f2\u000b\u0010\r\u001a\u00070\u0007\u00a2\u0006\u0002\b\fJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHMarkdownToHtmlConverter;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "convertMarkdown", "", "Lcom/intellij/openapi/util/NlsSafe;", "markdownText", "convertMarkdownWithSuggestedChange", "filePath", "Lorg/jetbrains/annotations/NonNls;", "reviewContent", "preprocessPullRequestIds", "markdownSource", "Companion", "GithubFlavourDescriptor", "GHLinkGeneratingProvider", "intellij.vcs.github"})
public final class GHMarkdownToHtmlConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    public static final String OPEN_PR_LINK_PREFIX = "ghpullrequest:";
    @NotNull
    private static final Regex CAPTURE_PR_ID_REGEX = new Regex("(#\\d+)");

    public GHMarkdownToHtmlConverter(@Nullable Project project) {
        this.project = project;
    }

    @NotNull
    public final String convertMarkdown(@NotNull String markdownText) {
        Intrinsics.checkNotNullParameter((Object)markdownText, (String)"markdownText");
        String text = this.preprocessPullRequestIds(StringsKt.replace$default((String)markdownText, (String)"\r", (String)"", (boolean)false, (int)4, null));
        GithubFlavourDescriptor flavourDescriptor = new GithubFlavourDescriptor((HtmlSyntaxHighlighter)new CodeBlockHtmlSyntaxHighlighter(this.project));
        return new MarkdownToHtmlConverter((MarkdownFlavourDescriptor)flavourDescriptor).convertMarkdownToHtml(text, null);
    }

    @NotNull
    public final String convertMarkdownWithSuggestedChange(@NotNull String markdownText, @NotNull String filePath, @NotNull String reviewContent) {
        Intrinsics.checkNotNullParameter((Object)markdownText, (String)"markdownText");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)reviewContent, (String)"reviewContent");
        String text = this.preprocessPullRequestIds(StringsKt.replace$default((String)markdownText, (String)"\r", (String)"", (boolean)false, (int)4, null));
        GHSuggestionHtmlSyntaxHighlighter htmlSyntaxHighlighter = new GHSuggestionHtmlSyntaxHighlighter(this.project, filePath, reviewContent);
        GithubFlavourDescriptor flavourDescriptor = new GithubFlavourDescriptor(htmlSyntaxHighlighter);
        return new MarkdownToHtmlConverter((MarkdownFlavourDescriptor)flavourDescriptor).convertMarkdownToHtml(text, null);
    }

    private final String preprocessPullRequestIds(String markdownSource) {
        CharSequence charSequence = markdownSource;
        Regex regex = CAPTURE_PR_ID_REGEX;
        String string = "[$1]($1)";
        return regex.replace(charSequence, string);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHMarkdownToHtmlConverter$Companion;", "", "<init>", "()V", "OPEN_PR_LINK_PREFIX", "", "CAPTURE_PR_ID_REGEX", "Lkotlin/text/Regex;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHMarkdownToHtmlConverter$GHLinkGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "fallback", "<init>", "(Lorg/intellij/markdown/html/GeneratingProvider;)V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "intellij.vcs.github"})
    private static final class GHLinkGeneratingProvider
    implements GeneratingProvider {
        @Nullable
        private final GeneratingProvider fallback;

        public GHLinkGeneratingProvider(@Nullable GeneratingProvider fallback) {
            this.fallback = fallback;
        }

        public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            CharSequence linkDestination;
            ASTNode aSTNode;
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ASTNode aSTNode2 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.LINK_TEXT);
            CharSequence linkText = aSTNode2 != null && (aSTNode = ASTUtilKt.findChildOfType((ASTNode)aSTNode2, (IElementType)MarkdownTokenTypes.TEXT)) != null ? ASTUtilKt.getTextInNode((ASTNode)aSTNode, (CharSequence)text) : null;
            ASTNode aSTNode3 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.LINK_DESTINATION);
            CharSequence charSequence = linkDestination = aSTNode3 != null ? ASTUtilKt.getTextInNode((ASTNode)aSTNode3, (CharSequence)text) : null;
            if (linkText == null || linkDestination == null) {
                GeneratingProvider generatingProvider = this.fallback;
                if (generatingProvider != null) {
                    generatingProvider.processNode(visitor, text, node);
                }
                return;
            }
            String cfr_ignored_0 = (String)linkText;
            String cfr_ignored_1 = (String)linkDestination;
            if (StringsKt.startsWith$default((CharSequence)linkDestination, (char)'#', (boolean)false, (int)2, null)) {
                String string = ((String)linkDestination).substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String prId = string;
                String mrUrl = GHMarkdownToHtmlConverter.OPEN_PR_LINK_PREFIX + prId;
                String string2 = HtmlChunk.link((String)mrUrl, (String)("#" + prId)).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                visitor.consumeHtml((CharSequence)string2);
                return;
            }
            String string = HtmlChunk.link((String)((String)linkDestination), (String)((String)linkText)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            visitor.consumeHtml((CharSequence)string);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHMarkdownToHtmlConverter$GithubFlavourDescriptor;", "Lorg/intellij/markdown/flavours/gfm/GFMFlavourDescriptor;", "htmlSyntaxHighlighter", "Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;", "<init>", "(Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;)V", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "intellij.vcs.github"})
    private static final class GithubFlavourDescriptor
    extends GFMFlavourDescriptor {
        @NotNull
        private final HtmlSyntaxHighlighter htmlSyntaxHighlighter;

        public GithubFlavourDescriptor(@NotNull HtmlSyntaxHighlighter htmlSyntaxHighlighter) {
            Intrinsics.checkNotNullParameter((Object)htmlSyntaxHighlighter, (String)"htmlSyntaxHighlighter");
            super(false, false, false, 7, null);
            this.htmlSyntaxHighlighter = htmlSyntaxHighlighter;
        }

        @NotNull
        public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
            Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
            Map map2 = super.createHtmlGeneratingProviders(linkMap, baseURI);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MarkdownElementTypes.CODE_FENCE, (Object)new CodeFenceSyntaxHighlighterGeneratingProvider(this.htmlSyntaxHighlighter)), TuplesKt.to((Object)MarkdownElementTypes.INLINE_LINK, (Object)new GHLinkGeneratingProvider((GeneratingProvider)map2.get(MarkdownElementTypes.INLINE_LINK)))};
            return MapsKt.plus((Map)map2, (Map)MapsKt.mapOf((Pair[])pairArray));
        }
    }
}

