/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0086\u0002J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ\u0019\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\rH\u0086\u0002J\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Landroidx/compose/runtime/BitVector;", "", "()V", "first", "", "others", "", "second", "size", "", "getSize", "()I", "get", "", "index", "nextClear", "nextSet", "set", "", "value", "setRange", "start", "end", "toString", "", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/BitVector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,4179:1\n1#2:4180\n*E\n"})
public final class BitVector {
    private long first;
    private long second;
    @Nullable
    private long[] others;
    public static final int $stable = 8;

    public final int getSize() {
        long[] it = this.others;
        boolean bl = false;
        return it != null ? (it.length + 2) * 64 : 128;
    }

    public final boolean get(int index2) {
        if (index2 < 0 || index2 >= this.getSize()) {
            throw new IllegalStateException(("Index " + index2 + " out of bound").toString());
        }
        if (index2 < 64) {
            return (this.first & 1L << index2) != 0L;
        }
        if (index2 < 128) {
            return (this.second & 1L << index2 - 64) != 0L;
        }
        if (this.others == null) {
            return false;
        }
        int address = index2 / 64 - 2;
        long[] others = this.others;
        if (address >= others.length) {
            return false;
        }
        int bit = index2 % 64;
        return (others[address] & 1L << bit) != 0L;
    }

    public final void set(int index2, boolean value) {
        long[] others;
        if (index2 < 64) {
            long mask = 1L << index2;
            this.first = value ? this.first | mask : this.first & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        if (index2 < 128) {
            long mask = 1L << index2 - 64;
            this.second = value ? this.second | mask : this.second & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        int address = index2 / 64 - 2;
        long mask = 1L << index2 % 64;
        long[] lArray = this.others;
        if (this.others == null) {
            BitVector $this$set_u24lambda_u241 = this;
            boolean bl = false;
            long[] others2 = new long[address + 1];
            $this$set_u24lambda_u241.others = others2;
            lArray = others2;
        }
        if (address >= (others = lArray).length) {
            long[] lArray2 = Arrays.copyOf(others, address + 1);
            Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"copyOf(...)");
            this.others = others = lArray2;
        }
        long bits = others[address];
        others[address] = value ? bits | mask : bits & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final int nextSet(int index2) {
        int size2 = this.getSize();
        for (int bit = index2; bit < size2; ++bit) {
            if (!this.get(bit)) continue;
            return bit;
        }
        return Integer.MAX_VALUE;
    }

    public final int nextClear(int index2) {
        int size2 = this.getSize();
        for (int bit = index2; bit < size2; ++bit) {
            if (this.get(bit)) continue;
            return bit;
        }
        return Integer.MAX_VALUE;
    }

    public final void setRange(int start, int end2) {
        for (int bit = start; bit < end2; ++bit) {
            this.set(bit, true);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean first = true;
        $this$toString_u24lambda_u242.append("BitVector [");
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            if (!this.get(i)) continue;
            if (!first) {
                $this$toString_u24lambda_u242.append(", ");
            }
            first = false;
            $this$toString_u24lambda_u242.append(i);
        }
        $this$toString_u24lambda_u242.append(']');
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }
}

