/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffMixin;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.DiffProviderEx;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LatestExistentSearcher;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.info.InfoConsumer;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public class SvnDiffProvider
extends DiffProviderEx
implements DiffProvider,
DiffMixin {
    private static final Logger LOG = Logger.getInstance(SvnDiffProvider.class);
    public static final String COMMIT_MESSAGE = "svn:log";
    private static final int BATCH_INFO_SIZE = 20;
    @NotNull
    private final SvnVcs myVcs;

    public SvnDiffProvider(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnDiffProvider.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision(@NotNull VirtualFile file) {
        if (file == null) {
            SvnDiffProvider.$$$reportNull$$$0(1);
        }
        Info svnInfo = this.myVcs.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        return SvnDiffProvider.getRevision(svnInfo);
    }

    @Nullable
    private static VcsRevisionNumber getRevision(@Nullable Info info) {
        SvnRevisionNumber result = null;
        if (info != null) {
            Revision revision = !info.getCommitInfo().getRevision().isValid() && info.getCopyFromRevision().isValid() ? info.getCopyFromRevision() : info.getRevision();
            result = new SvnRevisionNumber(revision);
        }
        return result;
    }

    @NotNull
    public Map<VirtualFile, VcsRevisionNumber> getCurrentRevisions(@NotNull Iterable<? extends VirtualFile> files) {
        if (files == null) {
            SvnDiffProvider.$$$reportNull$$$0(2);
        }
        HashMap<VirtualFile, VcsRevisionNumber> result = new HashMap<VirtualFile, VcsRevisionNumber>();
        HashMap<String, VirtualFile> items = new HashMap<String, VirtualFile>();
        ArrayList<File> ioFiles = new ArrayList<File>();
        for (VirtualFile virtualFile : files) {
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            ioFiles.add(ioFile);
            items.put(ioFile.getAbsolutePath(), virtualFile);
            if (items.size() != 20) continue;
            this.collectRevisionsInBatch(result, items, ioFiles);
            items.clear();
            ioFiles.clear();
        }
        this.collectRevisionsInBatch(result, items, ioFiles);
        HashMap<VirtualFile, VcsRevisionNumber> hashMap = result;
        if (hashMap == null) {
            SvnDiffProvider.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    private void collectRevisionsInBatch(@NotNull Map<VirtualFile, VcsRevisionNumber> revisionMap, @NotNull Map<String, VirtualFile> fileMap, @NotNull List<File> ioFiles) {
        if (revisionMap == null) {
            SvnDiffProvider.$$$reportNull$$$0(4);
        }
        if (fileMap == null) {
            SvnDiffProvider.$$$reportNull$$$0(5);
        }
        if (ioFiles == null) {
            SvnDiffProvider.$$$reportNull$$$0(6);
        }
        this.myVcs.collectInfo(ioFiles, SvnDiffProvider.createInfoHandler(revisionMap, fileMap));
    }

    @NotNull
    private static InfoConsumer createInfoHandler(@NotNull Map<VirtualFile, VcsRevisionNumber> revisionMap, @NotNull Map<String, VirtualFile> fileMap) {
        if (revisionMap == null) {
            SvnDiffProvider.$$$reportNull$$$0(7);
        }
        if (fileMap == null) {
            SvnDiffProvider.$$$reportNull$$$0(8);
        }
        InfoConsumer infoConsumer = info -> {
            if (info != null) {
                VirtualFile file = (VirtualFile)fileMap.get(info.getFile().getAbsolutePath());
                if (file != null) {
                    revisionMap.put(file, SvnDiffProvider.getRevision(info));
                } else {
                    LOG.info("Could not find virtual file for path " + info.getFile().getAbsolutePath());
                }
            }
        };
        if (infoConsumer == null) {
            SvnDiffProvider.$$$reportNull$$$0(9);
        }
        return infoConsumer;
    }

    @Nullable
    public VcsRevisionDescription getCurrentRevisionDescription(@NotNull VirtualFile file) {
        if (file == null) {
            SvnDiffProvider.$$$reportNull$$$0(10);
        }
        return this.getCurrentRevisionDescription(VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    @Nullable
    private VcsRevisionDescription getCurrentRevisionDescription(@NotNull File path) {
        File localPath;
        Info svnInfo;
        if (path == null) {
            SvnDiffProvider.$$$reportNull$$$0(11);
        }
        if ((svnInfo = this.myVcs.getInfo(path)) == null) {
            return null;
        }
        if (!svnInfo.getCommitInfo().getRevision().isValid() && svnInfo.getCopyFromRevision().isValid() && svnInfo.getCopyFromUrl() != null && (localPath = this.myVcs.getSvnFileUrlMapping().getLocalPath(svnInfo.getCopyFromUrl())) != null) {
            return this.getCurrentRevisionDescription(localPath);
        }
        return new VcsRevisionDescriptionImpl((VcsRevisionNumber)new SvnRevisionNumber(svnInfo.getCommitInfo().getRevision()), svnInfo.getCommitInfo().getDate(), svnInfo.getCommitInfo().getAuthor(), this.getCommitMessage(path, svnInfo));
    }

    @Nullable
    private String getCommitMessage(@NotNull File path, @NotNull Info info) {
        String result;
        if (path == null) {
            SvnDiffProvider.$$$reportNull$$$0(12);
        }
        if (info == null) {
            SvnDiffProvider.$$$reportNull$$$0(13);
        }
        try {
            PropertyValue property = this.myVcs.getFactory(path).createPropertyClient().getProperty(Target.on(path), COMMIT_MESSAGE, true, info.getCommitInfo().getRevision());
            result = PropertyValue.toString(property);
        }
        catch (VcsException e) {
            LOG.info("Failed to get commit message for file " + path + ", " + info.getCommitInfo().getRevision() + ", " + info.getRevision(), (Throwable)e);
            result = "";
        }
        return result;
    }

    @NotNull
    private static ItemLatestState defaultResult() {
        return SvnDiffProvider.createResult(Revision.HEAD, true, true);
    }

    @NotNull
    private static ItemLatestState createResult(@NotNull Revision revision, boolean exists, boolean defaultHead) {
        if (revision == null) {
            SvnDiffProvider.$$$reportNull$$$0(14);
        }
        return new ItemLatestState((VcsRevisionNumber)new SvnRevisionNumber(revision), exists, defaultHead);
    }

    @NotNull
    public ItemLatestState getLastRevision(@NotNull VirtualFile file) {
        if (file == null) {
            SvnDiffProvider.$$$reportNull$$$0(15);
        }
        return this.getLastRevision(VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    @NotNull
    public ContentRevision createFileContent(@NotNull VcsRevisionNumber revisionNumber, @NotNull VirtualFile selectedFile) {
        if (revisionNumber == null) {
            SvnDiffProvider.$$$reportNull$$$0(16);
        }
        if (selectedFile == null) {
            SvnDiffProvider.$$$reportNull$$$0(17);
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)selectedFile);
        Revision revision = ((SvnRevisionNumber)revisionNumber).getRevision();
        if (!Revision.HEAD.equals(revision) && revisionNumber.equals(this.getCurrentRevision(selectedFile))) {
            SvnContentRevision svnContentRevision = SvnContentRevision.createBaseRevision(this.myVcs, filePath, revision);
            if (svnContentRevision == null) {
                SvnDiffProvider.$$$reportNull$$$0(18);
            }
            return svnContentRevision;
        }
        Status svnStatus = this.getFileStatus(VfsUtilCore.virtualToIoFile((VirtualFile)selectedFile), false);
        SvnContentRevision svnContentRevision = svnStatus != null && revision.equals(svnStatus.getRevision()) ? SvnContentRevision.createBaseRevision(this.myVcs, filePath, revision) : SvnContentRevision.createRemote(this.myVcs, filePath, revision);
        if (svnContentRevision == null) {
            SvnDiffProvider.$$$reportNull$$$0(19);
        }
        return svnContentRevision;
    }

    @Nullable
    private Status getFileStatus(@NotNull File file, boolean remote) {
        if (file == null) {
            SvnDiffProvider.$$$reportNull$$$0(20);
        }
        Status result = null;
        try {
            result = this.myVcs.getFactory(file).createStatusClient().doStatus(file, remote);
        }
        catch (SvnBindException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return result;
    }

    @NotNull
    public ItemLatestState getLastRevision(@NotNull FilePath filePath) {
        if (filePath == null) {
            SvnDiffProvider.$$$reportNull$$$0(21);
        }
        return this.getLastRevision(filePath.getIOFile());
    }

    @Nullable
    public VcsRevisionNumber getLatestCommittedRevision(@NotNull VirtualFile vcsRoot) {
        Info info;
        if (vcsRoot == null) {
            SvnDiffProvider.$$$reportNull$$$0(22);
        }
        return (info = this.myVcs.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)vcsRoot), Revision.HEAD)) != null ? new SvnRevisionNumber(info.getCommitInfo().getRevision()) : null;
    }

    @NotNull
    private ItemLatestState getLastRevision(@NotNull File file) {
        Status svnStatus;
        if (file == null) {
            SvnDiffProvider.$$$reportNull$$$0(23);
        }
        if ((svnStatus = this.getFileStatus(file, true)) == null || SvnDiffProvider.itemExists(svnStatus)) {
            Info info = this.myVcs.getInfo(file, Revision.HEAD);
            if (info == null || info.getUrl() == null) {
                LOG.info("No SVN status returned for " + file.getPath());
                return SvnDiffProvider.defaultResult();
            }
            return SvnDiffProvider.createResult(info.getCommitInfo().getRevision(), true, false);
        }
        return SvnDiffProvider.createResult(this.getLastExistingRevision(file, svnStatus), false, false);
    }

    @NotNull
    private Revision getLastExistingRevision(@NotNull File file, @NotNull Status svnStatus) {
        if (file == null) {
            SvnDiffProvider.$$$reportNull$$$0(24);
        }
        if (svnStatus == null) {
            SvnDiffProvider.$$$reportNull$$$0(25);
        }
        WorkingCopyFormat format = this.myVcs.getWorkingCopyFormat(file);
        long revision = -1L;
        if (format.less(WorkingCopyFormat.ONE_DOT_EIGHT)) {
            if (svnStatus.getRepositoryRootUrl() != null) {
                revision = new LatestExistentSearcher(this.myVcs, svnStatus.getUrl(), svnStatus.getRepositoryRootUrl()).getDeletionRevision();
            } else {
                LOG.info("Could not find repository url for file " + file);
            }
        }
        Revision revision2 = Revision.of(revision);
        if (revision2 == null) {
            SvnDiffProvider.$$$reportNull$$$0(26);
        }
        return revision2;
    }

    private static boolean itemExists(@NotNull Status svnStatus) {
        if (svnStatus == null) {
            SvnDiffProvider.$$$reportNull$$$0(27);
        }
        return !StatusType.STATUS_DELETED.equals((Object)svnStatus.getRemoteItemStatus());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 18, 19, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 10: 
            case 15: 
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 9: 
            case 18: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnDiffProvider";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionMap";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svnStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnDiffProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentRevisions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfoHandler";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileContent";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastExistingRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevision";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevisions";
                break;
            }
            case 3: 
            case 9: 
            case 18: 
            case 19: 
            case 26: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectRevisionsInBatch";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInfoHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevisionDescription";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCommitMessage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createResult";
                break;
            }
            case 15: 
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLastRevision";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createFileContent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFileStatus";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLatestCommittedRevision";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLastExistingRevision";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "itemExists";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9, 18, 19, 26 -> new IllegalStateException(string);
        };
    }
}

