/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.references;

import com.intellij.openapi.util.Key;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlNamedElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ResolvingVisitor
extends XmlElementVisitor
implements PsiElementProcessor {
    static final Key<Set<XmlFile>> VISITED_KEY = Key.create((String)"visited");
    private final XmlAttributeValuePattern myPattern;
    private final ProcessingContext myProcessingContext;
    private XmlNamedElementPattern myIncludePattern;

    ResolvingVisitor(XmlAttributeValuePattern pattern, ProcessingContext context) {
        this.myPattern = pattern;
        this.myProcessingContext = context;
        this.myProcessingContext.put(VISITED_KEY, new HashSet());
    }

    public void visitXmlDocument(@NotNull XmlDocument document) {
        XmlTag rootTag;
        if (document == null) {
            ResolvingVisitor.$$$reportNull$$$0(0);
        }
        if ((rootTag = document.getRootTag()) != null) {
            this.visitXmlTag(rootTag);
        }
    }

    public void setIncludePattern(XmlNamedElementPattern includePattern) {
        this.myIncludePattern = includePattern;
    }

    public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            ResolvingVisitor.$$$reportNull$$$0(1);
        }
        if (this.myIncludePattern != null && this.myIncludePattern.accepts((Object)attribute, this.myProcessingContext)) {
            String value = attribute.getValue();
            if (value == null) {
                return;
            }
            XmlFile xmlFile = XmlUtil.findXmlFile(attribute.getContainingFile(), value);
            if (xmlFile != null) {
                this.processInclude(xmlFile, attribute);
            }
        } else {
            this.processAttribute(attribute);
        }
    }

    private void processAttribute(XmlAttribute attribute) {
        this.myPattern.accepts((Object)attribute.getValueElement(), this.myProcessingContext);
    }

    public void visitXmlTag(@NotNull XmlTag tag) {
        if (tag == null) {
            ResolvingVisitor.$$$reportNull$$$0(2);
        }
        this.visitAttributes(tag);
    }

    protected void visitAttributes(XmlTag tag) {
        XmlAttribute[] xmlAttributes;
        for (XmlAttribute attribute : xmlAttributes = tag.getAttributes()) {
            attribute.accept((PsiElementVisitor)this);
        }
    }

    protected void visitSubTags(XmlTag tag) {
        XmlTag[] tags;
        for (XmlTag subTag : tags = tag.getSubTags()) {
            if (!this.shouldContinue()) continue;
            subTag.accept((PsiElementVisitor)this);
        }
    }

    private void processInclude(XmlFile xmlFile, XmlAttribute attribute) {
        Set set = (Set)this.myProcessingContext.get(VISITED_KEY);
        if (set.contains(xmlFile)) {
            return;
        }
        set.add(xmlFile);
        XmlDocument document = xmlFile.getDocument();
        if (document == null) {
            return;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return;
        }
        rootTag.processElements((PsiElementProcessor)this, (PsiElement)attribute);
    }

    public boolean execute(@NotNull PsiElement element) {
        if (element == null) {
            ResolvingVisitor.$$$reportNull$$$0(3);
        }
        element.accept((PsiElementVisitor)this);
        return this.shouldContinue();
    }

    protected boolean shouldContinue() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/relaxNG/references/ResolvingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlDocument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlAttribute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlTag";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

