/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.query.impl;

import com.intellij.model.Pointer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.webSymbols.WebSymbolQualifiedKind;
import com.intellij.webSymbols.WebSymbolQualifiedName;
import com.intellij.webSymbols.framework.WebSymbolsFramework;
import com.intellij.webSymbols.query.WebSymbolNameConversionRules;
import com.intellij.webSymbols.query.WebSymbolNameConverter;
import com.intellij.webSymbols.query.WebSymbolNamesProvider;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u000e\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\u00020\u00012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J \u0010'\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003H\u0016R\u0016\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006*"}, d2={"Lcom/intellij/webSymbols/query/impl/WebSymbolNamesProviderImpl;", "Lcom/intellij/webSymbols/query/WebSymbolNamesProvider;", "framework", "", "Lcom/intellij/webSymbols/FrameworkId;", "configuration", "", "Lcom/intellij/webSymbols/query/WebSymbolNameConversionRules;", "modificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/openapi/util/ModificationTracker;)V", "canonicalNamesProviders", "", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "Lcom/intellij/webSymbols/query/WebSymbolNameConverter;", "matchNamesProviders", "completionVariantsProviders", "webSymbolsFramework", "Lcom/intellij/webSymbols/framework/WebSymbolsFramework;", "getWebSymbolsFramework", "()Lcom/intellij/webSymbols/framework/WebSymbolsFramework;", "createPointer", "Lcom/intellij/model/Pointer;", "hashCode", "", "equals", "", "other", "", "getModificationCount", "", "withRules", "rules", "getNames", "qualifiedName", "Lcom/intellij/webSymbols/WebSymbolQualifiedName;", "target", "Lcom/intellij/webSymbols/query/WebSymbolNamesProvider$Target;", "adjustRename", "newName", "occurence", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nWebSymbolNamesProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolNamesProviderImpl.kt\ncom/intellij/webSymbols/query/impl/WebSymbolNamesProviderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1863#2:98\n1864#2:105\n216#3,2:99\n216#3,2:101\n216#3,2:103\n1#4:106\n*S KotlinDebug\n*F\n+ 1 WebSymbolNamesProviderImpl.kt\ncom/intellij/webSymbols/query/impl/WebSymbolNamesProviderImpl\n*L\n35#1:98\n35#1:105\n36#1:99,2\n37#1:101,2\n38#1:103,2\n*E\n"})
public final class WebSymbolNamesProviderImpl
implements WebSymbolNamesProvider {
    @Nullable
    private final String framework;
    @NotNull
    private final List<WebSymbolNameConversionRules> configuration;
    @NotNull
    private final ModificationTracker modificationTracker;
    @NotNull
    private final Map<WebSymbolQualifiedKind, WebSymbolNameConverter> canonicalNamesProviders;
    @NotNull
    private final Map<WebSymbolQualifiedKind, WebSymbolNameConverter> matchNamesProviders;
    @NotNull
    private final Map<WebSymbolQualifiedKind, WebSymbolNameConverter> completionVariantsProviders;

    public WebSymbolNamesProviderImpl(@Nullable String framework, @NotNull List<? extends WebSymbolNameConversionRules> configuration, @NotNull ModificationTracker modificationTracker) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)modificationTracker, (String)"modificationTracker");
        this.framework = framework;
        this.configuration = configuration;
        this.modificationTracker = modificationTracker;
        Map canonicalNamesProviders = new LinkedHashMap();
        Map matchNamesProviders = new LinkedHashMap();
        Map completionVariantsProviders = new LinkedHashMap();
        Iterable $this$forEach$iv = this.configuration;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry<WebSymbolQualifiedKind, WebSymbolNameConverter> it;
            Map.Entry<WebSymbolQualifiedKind, WebSymbolNameConverter> element$iv2;
            WebSymbolNameConversionRules config = (WebSymbolNameConversionRules)element$iv;
            boolean bl = false;
            Map<WebSymbolQualifiedKind, WebSymbolNameConverter> $this$forEach$iv2 = config.getCanonicalNames();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<WebSymbolQualifiedKind, WebSymbolNameConverter>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv2 = iterator.next();
                boolean bl2 = false;
                canonicalNamesProviders.putIfAbsent(it.getKey(), it.getValue());
            }
            $this$forEach$iv2 = config.getMatchNames();
            $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv2 = iterator.next();
                boolean bl3 = false;
                matchNamesProviders.putIfAbsent(it.getKey(), it.getValue());
            }
            $this$forEach$iv2 = config.getCompletionVariants();
            $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                it = element$iv2 = iterator.next();
                boolean bl4 = false;
                completionVariantsProviders.putIfAbsent(it.getKey(), it.getValue());
            }
        }
        this.canonicalNamesProviders = canonicalNamesProviders;
        this.matchNamesProviders = matchNamesProviders;
        this.completionVariantsProviders = completionVariantsProviders;
    }

    private final WebSymbolsFramework getWebSymbolsFramework() {
        WebSymbolsFramework webSymbolsFramework;
        String string = this.framework;
        if (string != null) {
            String it = string;
            boolean bl = false;
            webSymbolsFramework = WebSymbolsFramework.Companion.get(it);
        } else {
            webSymbolsFramework = null;
        }
        return webSymbolsFramework;
    }

    @Override
    @NotNull
    public Pointer<WebSymbolNamesProvider> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
        return pointer;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.framework, this.configuration};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof WebSymbolNamesProviderImpl && Intrinsics.areEqual((Object)((WebSymbolNamesProviderImpl)other).framework, (Object)this.framework) && Intrinsics.areEqual(((WebSymbolNamesProviderImpl)other).configuration, this.configuration);
    }

    public long getModificationCount() {
        return this.modificationTracker.getModificationCount();
    }

    @Override
    @NotNull
    public WebSymbolNamesProvider withRules(@NotNull List<? extends WebSymbolNameConversionRules> rules) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        return new WebSymbolNamesProviderImpl(this.framework, CollectionsKt.plus((Collection)rules, (Iterable)this.configuration), this.modificationTracker);
    }

    @Override
    @NotNull
    public List<String> getNames(@NotNull WebSymbolQualifiedName qualifiedName, @NotNull WebSymbolNamesProvider.Target target) {
        List list2;
        List list3;
        WebSymbolNameConverter webSymbolNameConverter;
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
        switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 1: {
                webSymbolNameConverter = this.completionVariantsProviders.get(qualifiedName.getQualifiedKind());
                break;
            }
            case 2: {
                webSymbolNameConverter = this.canonicalNamesProviders.get(qualifiedName.getQualifiedKind());
                break;
            }
            case 3: {
                webSymbolNameConverter = this.matchNamesProviders.get(qualifiedName.getQualifiedKind());
                if (webSymbolNameConverter != null) break;
                webSymbolNameConverter = this.canonicalNamesProviders.get(qualifiedName.getQualifiedKind());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        WebSymbolNameConverter webSymbolNameConverter2 = webSymbolNameConverter;
        if (webSymbolNameConverter2 != null && (list3 = webSymbolNameConverter2.getNames(qualifiedName.getName())) != null) {
            list2 = list3;
        } else {
            List list4;
            List list5;
            Object object = this.getWebSymbolsFramework();
            if (object != null && (list5 = ((WebSymbolsFramework)object).getNames(qualifiedName, target)) != null) {
                List list6;
                List it = list6 = list5;
                boolean bl = false;
                list4 = !((Collection)it).isEmpty() ? list6 : null;
            } else {
                list4 = list2 = null;
            }
            if (list4 == null) {
                if (target != WebSymbolNamesProvider.Target.CODE_COMPLETION_VARIANTS && (Intrinsics.areEqual((Object)qualifiedName.getNamespace(), (Object)"css") || Intrinsics.areEqual((Object)qualifiedName.getNamespace(), (Object)"html"))) {
                    object = qualifiedName.getName();
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    String string = ((String)object).toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    list2 = CollectionsKt.listOf((Object)string);
                } else {
                    list2 = CollectionsKt.listOf((Object)qualifiedName.getName());
                }
            }
        }
        return list2;
    }

    @Override
    @NotNull
    public String adjustRename(@NotNull WebSymbolQualifiedName qualifiedName, @NotNull String newName, @NotNull String occurence) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)occurence, (String)"occurence");
        if (Intrinsics.areEqual((Object)qualifiedName.getName(), (Object)occurence)) {
            return newName;
        }
        List<String> oldVariants = this.getNames(qualifiedName, WebSymbolNamesProvider.Target.NAMES_QUERY);
        int index = oldVariants.indexOf(occurence);
        if (index < 0) {
            return newName;
        }
        List<String> newVariants = this.getNames(WebSymbolQualifiedName.copy$default(qualifiedName, null, null, newName, 3, null), WebSymbolNamesProvider.Target.NAMES_QUERY);
        if (oldVariants.size() == newVariants.size()) {
            return newVariants.get(index);
        }
        return newName;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WebSymbolNamesProvider.Target.values().length];
            try {
                nArray[WebSymbolNamesProvider.Target.CODE_COMPLETION_VARIANTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebSymbolNamesProvider.Target.NAMES_MAP_STORAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebSymbolNamesProvider.Target.NAMES_QUERY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

