/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.AbstractSyntheticBlock;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.ReadOnlyBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyntheticBlock
extends AbstractSyntheticBlock
implements Block {
    private final List<Block> mySubBlocks;
    private final Indent myChildIndent;

    public SyntheticBlock(@NotNull @NotNull List<@NotNull Block> subBlocks, @NotNull Block parent, @Nullable Indent indent, @NotNull XmlFormattingPolicy policy, @Nullable Indent childIndent) {
        if (subBlocks == null) {
            SyntheticBlock.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            SyntheticBlock.$$$reportNull$$$0(1);
        }
        if (policy == null) {
            SyntheticBlock.$$$reportNull$$$0(2);
        }
        super(subBlocks, parent, policy, indent);
        this.mySubBlocks = subBlocks;
        this.myChildIndent = childIndent;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = SyntheticBlock.calculateTextRange(this.mySubBlocks);
        if (textRange == null) {
            SyntheticBlock.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list2 = this.mySubBlocks;
        if (list2 == null) {
            SyntheticBlock.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        boolean saveSpacesBetweenTagAndText;
        Spacing spacing;
        ASTNode prev;
        if (child2 == null) {
            SyntheticBlock.$$$reportNull$$$0(5);
        }
        if (child1 instanceof ReadOnlyBlock || child2 instanceof ReadOnlyBlock) {
            return Spacing.getReadOnlySpacing();
        }
        if (!(child1 instanceof AbstractXmlBlock) || !(child2 instanceof AbstractXmlBlock)) {
            return null;
        }
        ASTNode node1 = ((AbstractBlock)child1).getNode();
        ASTNode node2 = ((AbstractBlock)child2).getNode();
        IElementType type1 = node1.getElementType();
        IElementType type2 = node2.getElementType();
        if (type2 == XmlElementType.XML_COMMENT) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (type1 == XmlElementType.XML_COMMENT && (prev = node1.getTreePrev()) != null) {
            node1 = prev;
            type1 = prev.getElementType();
        }
        boolean firstIsText = this.isTextFragment(node1);
        boolean secondIsText = this.isTextFragment(node2);
        if (((AbstractXmlBlock)child1).isPreserveSpace() && ((AbstractXmlBlock)child2).isPreserveSpace()) {
            boolean inText;
            ASTNode parent = node1.getTreeParent();
            boolean bl = inText = parent != null && parent.getTreePrev().getElementType() == XmlTokenType.XML_TAG_END;
            if (inText) {
                return Spacing.getReadOnlySpacing();
            }
        }
        if (type1 == XmlTokenType.XML_CDATA_START || type2 == XmlTokenType.XML_CDATA_END) {
            if (this.myXmlFormattingPolicy.getKeepWhiteSpacesInsideCDATA()) {
                return Spacing.getReadOnlySpacing();
            }
            if (type1 == XmlTokenType.XML_CDATA_START && type2 == XmlTokenType.XML_CDATA_END) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            if (type1 == XmlTokenType.XML_CDATA_START && child2 instanceof AnotherLanguageBlockWrapper || type2 == XmlTokenType.XML_CDATA_END && child1 instanceof AnotherLanguageBlockWrapper) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)0);
            }
        }
        boolean firstIsTag = node1.getPsi() instanceof XmlTag && !firstIsText;
        boolean secondIsTag = node2.getPsi() instanceof XmlTag && !secondIsText;
        boolean firstIsEntityRef = SyntheticBlock.isEntityRef(node1);
        boolean secondIsEntityRef = SyntheticBlock.isEntityRef(node2);
        if ((secondIsText && this.isInlineTag(node1) || firstIsText && this.isInlineTag(node2)) && this.myXmlFormattingPolicy.isKeepSpacesAroundInlineTags()) {
            return Spacing.getReadOnlySpacing();
        }
        if (SyntheticBlock.isSpaceInText(firstIsTag, secondIsTag, firstIsText, secondIsText) && this.keepWhiteSpaces()) {
            return Spacing.getReadOnlySpacing();
        }
        if (firstIsEntityRef || secondIsEntityRef) {
            return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (this.isAttributeElementType(type1) && (type2 == XmlTokenType.XML_TAG_END || type2 == XmlTokenType.XML_EMPTY_ELEMENT_END) && (spacing = this.myXmlFormattingPolicy.getSpacingAfterLastAttribute((XmlAttribute)node1.getPsi())) != null) {
            return spacing;
        }
        if (type2 == XmlTokenType.XML_EMPTY_ELEMENT_END && this.myXmlFormattingPolicy.addSpaceIntoEmptyTag()) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (this.isXmlTagName(type1, type2)) {
            int spaces = this.shouldAddSpaceAroundTagName(node1, node2) ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (this.isAttributeElementType(type2)) {
            if ((type1 == XmlTokenType.XML_NAME || type1 == XmlTokenType.XML_TAG_NAME) && (spacing = this.myXmlFormattingPolicy.getSpacingBeforeFirstAttribute((XmlAttribute)node2.getPsi())) != null) {
                return spacing;
            }
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (type1 == XmlTokenType.XML_DATA_CHARACTERS && type2 == XmlTokenType.XML_DATA_CHARACTERS) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (((AbstractXmlBlock)child1).isTextElement() && ((AbstractXmlBlock)child2).isTextElement()) {
            return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (firstIsTag && this.insertLineFeedAfter((XmlTag)node1.getPsi())) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if ((firstIsText || firstIsTag) && secondIsTag) {
            if (((AbstractXmlBlock)child2).insertLineBreakBeforeTag()) {
                return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)(((AbstractXmlBlock)child2).getBlankLinesBeforeTag() + 1), (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            if (((AbstractXmlBlock)child2).removeLineBreakBeforeTag()) {
                return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
        }
        boolean bl = saveSpacesBetweenTagAndText = this.myXmlFormattingPolicy.shouldSaveSpacesBetweenTagAndText() && child1.getTextRange().getEndOffset() < child2.getTextRange().getStartOffset();
        if (firstIsTag && secondIsText) {
            if (((AbstractXmlBlock)child1).isTextElement() || saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (firstIsText && secondIsTag) {
            if (((AbstractXmlBlock)child2).isTextElement() || saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (firstIsTag && secondIsTag) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
    }

    private static boolean isEntityRef(ASTNode node) {
        return node.getElementType() == XmlElementType.XML_ENTITY_REF || node.getElementType() == XmlTokenType.XML_CHAR_ENTITY_REF;
    }

    private boolean shouldAddSpaceAroundTagName(ASTNode node1, ASTNode node2) {
        if (node1.getElementType() == XmlTokenType.XML_START_TAG_START && node1.textContains('%')) {
            return true;
        }
        if (node2.getElementType() == XmlTokenType.XML_EMPTY_ELEMENT_END && node2.textContains('%')) {
            return true;
        }
        return this.myXmlFormattingPolicy.getShouldAddSpaceAroundTagName();
    }

    private static boolean isSpaceInText(boolean firstIsTag, boolean secondIsTag, boolean firstIsText, boolean secondIsText) {
        return firstIsText && secondIsText || firstIsTag && secondIsTag || firstIsTag && secondIsText || firstIsText && secondIsTag;
    }

    private boolean keepWhiteSpaces() {
        return this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(this.getTag()) || this.myXmlFormattingPolicy.getShouldKeepWhiteSpaces();
    }

    protected boolean isTextFragment(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        return parent != null && this.isTextNode(parent.getElementType()) || node.getElementType() == XmlTokenType.XML_DATA_CHARACTERS;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Block prevBlock;
        if (this.isOuterLanguageBlock()) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
            if (childAttributes == null) {
                SyntheticBlock.$$$reportNull$$$0(6);
            }
            return childAttributes;
        }
        List<Block> subBlocks = this.getSubBlocks();
        int prevBlockIndex = newChildIndex - 1;
        if (prevBlockIndex >= 0 && prevBlockIndex < subBlocks.size() && this.isAttributeBlock(prevBlock = subBlocks.get(newChildIndex - 1))) {
            return new ChildAttributes(this.myChildIndent, prevBlock.getAlignment());
        }
        return new ChildAttributes(this.myChildIndent, null);
    }

    private boolean isAttributeBlock(Block block) {
        if (block instanceof XmlBlock) {
            return this.isAttributeElementType(((XmlBlock)block).getNode().getElementType());
        }
        return false;
    }

    @Override
    public boolean isIncomplete() {
        return this.getSubBlocks().get(this.getSubBlocks().size() - 1).isIncomplete();
    }

    public boolean endsWithAttribute() {
        return this.isAttributeBlock(this.getSubBlocks().get(this.getSubBlocks().size() - 1));
    }

    @Nullable
    public Indent getChildIndent() {
        return this.myChildIndent;
    }

    private boolean isInlineTag(@NotNull ASTNode astNode) {
        if (astNode == null) {
            SyntheticBlock.$$$reportNull$$$0(7);
        }
        return astNode.getElementType() == XmlElementType.XML_TAG && this.isTextOnlyTag(astNode) && this.isTextNotEndingWithLineBreaks(astNode.getTreePrev()) && this.isTextNotStartingWithLineBreaks(astNode.getTreeNext());
    }

    private boolean isTextNotEndingWithLineBreaks(@Nullable ASTNode astNode) {
        ASTNode lastChild;
        if (astNode != null && this.isTextNode(astNode.getElementType()) && (lastChild = astNode.getLastChildNode()) != null) {
            return !(lastChild.getPsi() instanceof PsiWhiteSpace) || !CharArrayUtil.containLineBreaks((CharSequence)lastChild.getChars());
        }
        return false;
    }

    private boolean isTextNotStartingWithLineBreaks(@Nullable ASTNode astNode) {
        ASTNode firstChild;
        if (astNode != null && this.isTextNode(astNode.getElementType()) && (firstChild = astNode.getFirstChildNode()) != null) {
            return !(firstChild.getPsi() instanceof PsiWhiteSpace) || !CharArrayUtil.containLineBreaks((CharSequence)firstChild.getChars());
        }
        return false;
    }

    private boolean isTextOnlyTag(@NotNull ASTNode tagNode) {
        if (tagNode == null) {
            SyntheticBlock.$$$reportNull$$$0(8);
        }
        boolean checkContent = false;
        for (ASTNode child = tagNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType childType = child.getElementType();
            if (checkContent) {
                if (childType == XmlTokenType.XML_END_TAG_START) {
                    return true;
                }
                if (this.isTextNode(childType)) continue;
                return false;
            }
            if (childType != XmlTokenType.XML_TAG_END) continue;
            checkContent = true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subBlocks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/xml/SyntheticBlock";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/xml/SyntheticBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInlineTag";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTextOnlyTag";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

