/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class VcsLogStructureFilterImpl
implements VcsLogDetailsFilter,
VcsLogStructureFilter {
    @NotNull
    private final Collection<FilePath> myFiles;

    protected VcsLogStructureFilterImpl(@NotNull Collection<FilePath> files) {
        if (files == null) {
            VcsLogStructureFilterImpl.$$$reportNull$$$0(0);
        }
        this.myFiles = files;
    }

    @NotNull
    public Collection<FilePath> getFiles() {
        Collection<FilePath> collection = this.myFiles;
        if (collection == null) {
            VcsLogStructureFilterImpl.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public boolean matches(@NotNull VcsCommitMetadata details) {
        if (details == null) {
            VcsLogStructureFilterImpl.$$$reportNull$$$0(2);
        }
        if (details instanceof VcsFullCommitDetails) {
            for (Change change : ((VcsFullCommitDetails)details).getChanges()) {
                ContentRevision before = change.getBeforeRevision();
                if (before != null && this.matches(before.getFile().getPath())) {
                    return true;
                }
                ContentRevision after = change.getAfterRevision();
                if (after == null || !this.matches(after.getFile().getPath())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(@NotNull String path) {
        if (path == null) {
            VcsLogStructureFilterImpl.$$$reportNull$$$0(3);
        }
        return ContainerUtil.find(this.myFiles, file -> FileUtil.isAncestor((String)file.getPath(), (String)path, (boolean)false)) != null;
    }

    @NonNls
    public String toString() {
        return "files:" + this.myFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsLogStructureFilterImpl filter = (VcsLogStructureFilterImpl)o;
        return Comparing.haveEqualElements(this.getFiles(), filter.getFiles());
    }

    public int hashCode() {
        return Comparing.unorderedHashcode(this.getFiles());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/visible/filters/VcsLogStructureFilterImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/visible/filters/VcsLogStructureFilterImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

