// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Information about a topic guardrail.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GuardrailTopic {
    /// <p>The name for the guardrail.</p>
    pub name: ::std::string::String,
    /// <p>The type behavior that the guardrail should perform when the model detects the topic.</p>
    pub r#type: crate::types::GuardrailTopicType,
    /// <p>The action the guardrail should take when it intervenes on a topic.</p>
    pub action: crate::types::GuardrailTopicPolicyAction,
    /// <p>Indicates whether topic content that breaches the guardrail configuration is detected.</p>
    pub detected: ::std::option::Option<bool>,
}
impl GuardrailTopic {
    /// <p>The name for the guardrail.</p>
    pub fn name(&self) -> &str {
        use std::ops::Deref;
        self.name.deref()
    }
    /// <p>The type behavior that the guardrail should perform when the model detects the topic.</p>
    pub fn r#type(&self) -> &crate::types::GuardrailTopicType {
        &self.r#type
    }
    /// <p>The action the guardrail should take when it intervenes on a topic.</p>
    pub fn action(&self) -> &crate::types::GuardrailTopicPolicyAction {
        &self.action
    }
    /// <p>Indicates whether topic content that breaches the guardrail configuration is detected.</p>
    pub fn detected(&self) -> ::std::option::Option<bool> {
        self.detected
    }
}
impl GuardrailTopic {
    /// Creates a new builder-style object to manufacture [`GuardrailTopic`](crate::types::GuardrailTopic).
    pub fn builder() -> crate::types::builders::GuardrailTopicBuilder {
        crate::types::builders::GuardrailTopicBuilder::default()
    }
}

/// A builder for [`GuardrailTopic`](crate::types::GuardrailTopic).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GuardrailTopicBuilder {
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) r#type: ::std::option::Option<crate::types::GuardrailTopicType>,
    pub(crate) action: ::std::option::Option<crate::types::GuardrailTopicPolicyAction>,
    pub(crate) detected: ::std::option::Option<bool>,
}
impl GuardrailTopicBuilder {
    /// <p>The name for the guardrail.</p>
    /// This field is required.
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name for the guardrail.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name for the guardrail.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>The type behavior that the guardrail should perform when the model detects the topic.</p>
    /// This field is required.
    pub fn r#type(mut self, input: crate::types::GuardrailTopicType) -> Self {
        self.r#type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type behavior that the guardrail should perform when the model detects the topic.</p>
    pub fn set_type(mut self, input: ::std::option::Option<crate::types::GuardrailTopicType>) -> Self {
        self.r#type = input;
        self
    }
    /// <p>The type behavior that the guardrail should perform when the model detects the topic.</p>
    pub fn get_type(&self) -> &::std::option::Option<crate::types::GuardrailTopicType> {
        &self.r#type
    }
    /// <p>The action the guardrail should take when it intervenes on a topic.</p>
    /// This field is required.
    pub fn action(mut self, input: crate::types::GuardrailTopicPolicyAction) -> Self {
        self.action = ::std::option::Option::Some(input);
        self
    }
    /// <p>The action the guardrail should take when it intervenes on a topic.</p>
    pub fn set_action(mut self, input: ::std::option::Option<crate::types::GuardrailTopicPolicyAction>) -> Self {
        self.action = input;
        self
    }
    /// <p>The action the guardrail should take when it intervenes on a topic.</p>
    pub fn get_action(&self) -> &::std::option::Option<crate::types::GuardrailTopicPolicyAction> {
        &self.action
    }
    /// <p>Indicates whether topic content that breaches the guardrail configuration is detected.</p>
    pub fn detected(mut self, input: bool) -> Self {
        self.detected = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether topic content that breaches the guardrail configuration is detected.</p>
    pub fn set_detected(mut self, input: ::std::option::Option<bool>) -> Self {
        self.detected = input;
        self
    }
    /// <p>Indicates whether topic content that breaches the guardrail configuration is detected.</p>
    pub fn get_detected(&self) -> &::std::option::Option<bool> {
        &self.detected
    }
    /// Consumes the builder and constructs a [`GuardrailTopic`](crate::types::GuardrailTopic).
    /// This method will fail if any of the following fields are not set:
    /// - [`name`](crate::types::builders::GuardrailTopicBuilder::name)
    /// - [`r#type`](crate::types::builders::GuardrailTopicBuilder::type)
    /// - [`action`](crate::types::builders::GuardrailTopicBuilder::action)
    pub fn build(self) -> ::std::result::Result<crate::types::GuardrailTopic, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::GuardrailTopic {
            name: self.name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "name",
                    "name was not specified but it is required when building GuardrailTopic",
                )
            })?,
            r#type: self.r#type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "r#type",
                    "r#type was not specified but it is required when building GuardrailTopic",
                )
            })?,
            action: self.action.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "action",
                    "action was not specified but it is required when building GuardrailTopic",
                )
            })?,
            detected: self.detected,
        })
    }
}
