/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.grpc.requests.execution;

import com.intellij.httpClient.grpc.requests.execution.GrpcInterceptedCall;
import com.intellij.httpClient.grpc.restClient.execution.GrpcRequest;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JH\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J0\u0010\u0018\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0014\u001a\u00020\u00112\u0018\u0010\u001a\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u001c\u0012\u0004\u0012\u0002H\u00190\u001bH\u0002J*\u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001c\u0012\u0004\u0012\u00020\u001e0\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0016H\u0002J*\u0010 \u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001c\u0012\u0004\u0012\u00020\u00160\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/httpClient/grpc/requests/execution/GrpcMetadataInterceptor;", "Lio/grpc/ClientInterceptor;", "grpcRequest", "Lcom/intellij/httpClient/grpc/restClient/execution/GrpcRequest;", "<init>", "(Lcom/intellij/httpClient/grpc/restClient/execution/GrpcRequest;)V", "interceptCall", "Lio/grpc/ClientCall;", "DynamicRequest", "DynamicResponse", "method", "Lio/grpc/MethodDescriptor;", "callOptions", "Lio/grpc/CallOptions;", "next", "Lio/grpc/Channel;", "assembleUserDefinedMetadata", "Lio/grpc/Metadata;", "updateMetadataEntry", "", "metadata", "key", "", "value", "updateWith", "T", "keyValue", "Lkotlin/Pair;", "Lio/grpc/Metadata$Key;", "mapBinaryMetadata", "", "base64EncodedValue", "mapStringMetadata", "intellij.httpClient.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcMetadataInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcMetadataInterceptor.kt\ncom/intellij/httpClient/grpc/requests/execution/GrpcMetadataInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1869#2,2:56\n*S KotlinDebug\n*F\n+ 1 GrpcMetadataInterceptor.kt\ncom/intellij/httpClient/grpc/requests/execution/GrpcMetadataInterceptor\n*L\n18#1:56,2\n*E\n"})
public final class GrpcMetadataInterceptor
implements ClientInterceptor {
    @NotNull
    private final GrpcRequest grpcRequest;

    public GrpcMetadataInterceptor(@NotNull GrpcRequest grpcRequest) {
        Intrinsics.checkNotNullParameter((Object)grpcRequest, (String)"grpcRequest");
        this.grpcRequest = grpcRequest;
    }

    @NotNull
    public <DynamicRequest, DynamicResponse> ClientCall<DynamicRequest, DynamicResponse> interceptCall(@Nullable MethodDescriptor<DynamicRequest, DynamicResponse> method, @Nullable CallOptions callOptions, @NotNull Channel next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        ClientCall interceptedCall = next.newCall(method, callOptions);
        io.grpc.Metadata metadata = this.assembleUserDefinedMetadata();
        Intrinsics.checkNotNull((Object)interceptedCall);
        return (ClientCall)new GrpcInterceptedCall(metadata, interceptedCall);
    }

    private final io.grpc.Metadata assembleUserDefinedMetadata() {
        io.grpc.Metadata metadata = new io.grpc.Metadata();
        Iterable $this$forEach$iv = this.grpcRequest.getMetadata().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            this.updateMetadataEntry(metadata, (String)it.getKey(), (String)it.getValue());
        }
        return metadata;
    }

    private final void updateMetadataEntry(io.grpc.Metadata metadata, String key, String value) {
        if (StringsKt.endsWith$default((String)key, (String)"-bin", (boolean)false, (int)2, null)) {
            this.updateWith(metadata, this.mapBinaryMetadata(key, value));
        } else {
            this.updateWith(metadata, this.mapStringMetadata(key, value));
        }
    }

    private final <T> void updateWith(io.grpc.Metadata metadata, Pair<? extends Metadata.Key<T>, ? extends T> keyValue) {
        metadata.put((Metadata.Key)keyValue.getFirst(), keyValue.getSecond());
    }

    private final Pair<Metadata.Key<byte[]>, byte[]> mapBinaryMetadata(String key, String base64EncodedValue) {
        byte[] byArray = Base64.getDecoder().decode(base64EncodedValue);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        byte[] decodedValue = byArray;
        return TuplesKt.to((Object)Metadata.Key.of((String)key, (Metadata.BinaryMarshaller)io.grpc.Metadata.BINARY_BYTE_MARSHALLER), (Object)decodedValue);
    }

    private final Pair<Metadata.Key<String>, String> mapStringMetadata(String key, String value) {
        return TuplesKt.to((Object)Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)io.grpc.Metadata.ASCII_STRING_MARSHALLER), (Object)value);
    }
}

