/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.packages.restFramework.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.django.packages.restFramework.DrfSerializerPsiUtils;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.rename.RenamePyElementProcessor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J0\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/python/django/packages/restFramework/refactoring/rename/RenameSerializerMethodFieldProcessor;", "Lcom/jetbrains/python/refactoring/rename/RenamePyElementProcessor;", "<init>", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "prepareRenaming", "", "newName", "", "allRenames", "", "intellij.python.django"})
@SourceDebugExtension(value={"SMAP\nRenameSerializerMethodFieldProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameSerializerMethodFieldProcessor.kt\ncom/intellij/python/django/packages/restFramework/refactoring/rename/RenameSerializerMethodFieldProcessor\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,66:1\n66#2,2:67\n*S KotlinDebug\n*F\n+ 1 RenameSerializerMethodFieldProcessor.kt\ncom/intellij/python/django/packages/restFramework/refactoring/rename/RenameSerializerMethodFieldProcessor\n*L\n46#1:67,2\n*E\n"})
public final class RenameSerializerMethodFieldProcessor
extends RenamePyElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!DjangoFacet.isPresent((PsiElement)element)) {
            return false;
        }
        if (element instanceof PyPossibleClassMember) {
            boolean bl2;
            TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated((Project)element.getProject(), (PsiFile)element.getContainingFile());
            PyClass pyClass = ((PyPossibleClassMember)element).getContainingClass();
            if (pyClass != null) {
                Intrinsics.checkNotNull((Object)typeEvalContext);
                bl2 = DrfSerializerPsiUtils.INSTANCE.isModelSerializerClass(pyClass, typeEvalContext);
            } else {
                bl2 = false;
            }
            if (!bl2) {
                return false;
            }
            PsiElement psiElement = element;
            if (psiElement instanceof PyTargetExpression) {
                PyTargetExpression pyTargetExpression = (PyTargetExpression)element;
                Intrinsics.checkNotNull((Object)typeEvalContext);
                bl = DrfSerializerPsiUtils.INSTANCE.isSerializerMethodField(pyTargetExpression, typeEvalContext);
            } else {
                bl = psiElement instanceof PyFunction ? DrfSerializerPsiUtils.INSTANCE.isValidSerializerMethod((PyFunction)element) : false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        PsiElement psiElement = element;
        if (psiElement instanceof PyTargetExpression) {
            String string = ((PyTargetExpression)element).getName();
            if (string == null) {
                return;
            }
            String name = string;
            PsiElement $this$parentOfType_u24default$iv = element;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PyClass.class, (boolean)true);
            if (pyClass == null) {
                return;
            }
            PyClass containingClass = pyClass;
            PyFunction pyFunction = containingClass.findMethodByName("get_" + name, false, TypeEvalContext.userInitiated((Project)((PyTargetExpression)element).getProject(), (PsiFile)((PyTargetExpression)element).getContainingFile()));
            if (pyFunction == null) {
                return;
            }
            PyFunction serializerMethod = pyFunction;
            if (!DrfSerializerPsiUtils.INSTANCE.isValidSerializerMethod(serializerMethod)) {
                return;
            }
            allRenames.put((PsiElement)serializerMethod, "get_" + newName);
        } else if (psiElement instanceof PyFunction) {
            TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated((Project)((PyFunction)element).getProject(), (PsiFile)((PyFunction)element).getContainingFile());
            PyClass pyClass = ((PyFunction)element).getContainingClass();
            Intrinsics.checkNotNull((Object)pyClass);
            String string = ((PyFunction)element).getName();
            Intrinsics.checkNotNull((Object)string);
            PyTargetExpression attribute = pyClass.findClassAttribute(StringsKt.removePrefix((String)string, (CharSequence)"get_"), false, typeEvalContext);
            if (attribute != null) {
                Intrinsics.checkNotNull((Object)typeEvalContext);
                if (DrfSerializerPsiUtils.INSTANCE.isSerializerMethodField(attribute, typeEvalContext) && StringsKt.startsWith$default((String)newName, (String)"get_", (boolean)false, (int)2, null)) {
                    allRenames.put((PsiElement)attribute, StringsKt.removePrefix((String)newName, (CharSequence)"get_"));
                }
            }
        }
    }
}

