/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.packages.constance.ref;

import com.intellij.jinja.template.psi.impl.Jinja2MemberNameImpl;
import com.intellij.lang.ASTNode;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.search.SearchRequest;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.python.django.packages.constance.ConstanceUtils;
import com.intellij.python.django.packages.constance.ref.ConstanceSettingReference;
import com.jetbrains.python.ast.PyAstQualifiedExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/django/packages/constance/ref/ConstanceSettingReferenceProvider;", "Lcom/intellij/model/psi/PsiSymbolReferenceProvider;", "<init>", "()V", "getReferences", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "element", "Lcom/intellij/model/psi/PsiExternalReferenceHost;", "hints", "Lcom/intellij/model/psi/PsiSymbolReferenceHints;", "getSearchRequests", "Lcom/intellij/model/search/SearchRequest;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/model/Symbol;", "intellij.python.django"})
public final class ConstanceSettingReferenceProvider
implements PsiSymbolReferenceProvider {
    @NotNull
    public Collection<PsiSymbolReference> getReferences(@NotNull PsiExternalReferenceHost element, @NotNull PsiSymbolReferenceHints hints) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hints, (String)"hints");
        if (!ConstanceUtils.INSTANCE.isConstanceSupportEnabled()) {
            return CollectionsKt.emptyList();
        }
        if (element instanceof PyQualifiedExpression && ConstanceUtils.INSTANCE.isConfigSettingUsage((PyQualifiedExpression)element)) {
            PyQualifiedExpression qualified = (PyQualifiedExpression)element;
            String string = ((NavigationItem)element).getName();
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String name = string;
            ASTNode aSTNode = ((PyAstQualifiedExpression)element).getNameElement();
            if (aSTNode == null || (aSTNode = aSTNode.getTextRange()) == null || (aSTNode = aSTNode.shiftLeft(qualified.getTextRange().getStartOffset())) == null) {
                TextRange textRange = qualified.getTextRangeInParent();
                aSTNode = textRange;
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRangeInParent(...)");
            }
            ASTNode textRange = aSTNode;
            return CollectionsKt.listOf((Object)new ConstanceSettingReference((PsiElement)element, name, (TextRange)textRange));
        }
        if (element instanceof PyKeywordArgument && ConstanceUtils.INSTANCE.isOverrideSettingUsage((PyKeywordArgument)element)) {
            String string = ((PyKeywordArgument)element).getName();
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String name = string;
            ASTNode aSTNode = ((PyKeywordArgument)element).getKeywordNode();
            if (aSTNode == null || (aSTNode = aSTNode.getPsi()) == null || (aSTNode = aSTNode.getTextRangeInParent()) == null) {
                return CollectionsKt.emptyList();
            }
            ASTNode textRange = aSTNode;
            return CollectionsKt.listOf((Object)new ConstanceSettingReference((PsiElement)element, name, (TextRange)textRange));
        }
        if (element instanceof PyStringLiteralExpression && ConstanceUtils.INSTANCE.isFieldsetsSettingUsage((PyStringLiteralExpression)element)) {
            PsiElement psiElement = (PsiElement)element;
            String string = ((PyStringLiteralExpression)element).getStringValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
            TextRange textRange = ((PyStringLiteralExpression)element).getStringValueTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getStringValueTextRange(...)");
            return CollectionsKt.listOf((Object)new ConstanceSettingReference(psiElement, string, textRange));
        }
        if (element instanceof Jinja2MemberNameImpl && ConstanceUtils.INSTANCE.isConfigSettingUsage((Jinja2MemberNameImpl)element)) {
            PsiElement psiElement = (PsiElement)element;
            String string = ((Jinja2MemberNameImpl)element).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return CollectionsKt.listOf((Object)new ConstanceSettingReference(psiElement, string, new TextRange(0, ((Jinja2MemberNameImpl)element).getTextLength())));
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public Collection<SearchRequest> getSearchRequests(@NotNull Project project, @NotNull Symbol target) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return CollectionsKt.emptyList();
    }
}

