/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jinja.template.tags.Jinja2BlockTag;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.python.django.lang.template.inspection.DjangoLocalInspectionTool;
import com.intellij.python.django.lang.template.inspection.DjangoProblemHolderVisitor;
import com.jetbrains.django.ui.DjangoBundle;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class DuplicatedBlockNamesInspection
extends DjangoLocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "DuplicatedBlockNamesInspection";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DuplicatedBlockNamesInspection.$$$reportNull$$$0(0);
        }
        return new Visitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/python/django/lang/template/inspection/DuplicatedBlockNamesInspection", "buildVisitor"));
    }

    private static class Visitor
    extends DjangoProblemHolderVisitor {
        private final Set<String> myNames = new HashSet<String>();

        Visitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitBlockTag(Jinja2BlockTag blockTag) {
            String name = blockTag.getBlockName();
            if (this.myNames.contains(name)) {
                this.registerProblem((PsiElement)blockTag, DjangoBundle.message((String)"INSP.NAME.block.name.is.duplicated", (Object[])new Object[]{name}));
            } else {
                this.myNames.add(name);
            }
        }
    }
}

