/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.util;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.PuppetFileType;
import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.settings.PuppetProjectConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PuppetConfigurationUtil {
    public static void reparsePuppetFiles(final Project project) {
        Task.Backgroundable task = new Task.Backgroundable(project, PuppetBundle.message("settings.puppet.reparse.title", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Collection<VirtualFile> puppetFiles = PuppetConfigurationUtil.getPuppetFiles(project, indicator);
                ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles((Collection)puppetFiles), ModalityState.nonModal());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/puppet/util/PuppetConfigurationUtil$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    public static Collection<VirtualFile> getPuppetFiles(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (project == null) {
            PuppetConfigurationUtil.$$$reportNull$$$0(0);
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null) {
            FileBasedIndex.getInstance().iterateIndexableFiles(file -> {
                if (FileTypeRegistry.getInstance().isFileOfType(file, (FileType)PuppetFileType.INSTANCE)) {
                    result.add(file);
                }
                return true;
            }, project, indicator);
        }
        return result;
    }

    @NotNull
    public static PuppetLanguage.Version getPuppetVersion(@NotNull PsiElement element) {
        if (element == null) {
            PuppetConfigurationUtil.$$$reportNull$$$0(1);
        }
        return PuppetConfigurationUtil.getPuppetVersion(element.getProject());
    }

    @NotNull
    public static PuppetLanguage.Version getPuppetVersion(@NotNull Project project) {
        if (project == null) {
            PuppetConfigurationUtil.$$$reportNull$$$0(2);
        }
        PuppetLanguage.Version version = PuppetProjectConfiguration.getInstance(project).getLanguageVersion();
        if (version == null) {
            PuppetConfigurationUtil.$$$reportNull$$$0(3);
        }
        return version;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/util/PuppetConfigurationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/util/PuppetConfigurationUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPuppetVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPuppetFiles";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPuppetVersion";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

