/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.psi.PsiPuppetVarWrapper;
import com.intellij.lang.puppet.psi.PsiPuppetVisitor;
import com.intellij.lang.puppet.util.PuppetConfigurationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class Puppet4DeprecationsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            Puppet4DeprecationsInspection.$$$reportNull$$$0(0);
        }
        return new PsiPuppetVisitor(this){

            @Override
            public void visitVarWrapper(@NotNull PsiPuppetVarWrapper var) {
                if (var == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PuppetConfigurationUtil.getPuppetVersion(var) != PuppetLanguage.Version.PUPPET_4) {
                    return;
                }
                String variableName = var.getName();
                if (StringUtil.isEmpty((String)variableName)) {
                    return;
                }
                if (StringUtil.isCapitalized((String)variableName)) {
                    holder.registerProblem((PsiElement)var, PuppetBundle.message("inspections.deprecated.in.puppet4.capitalized.variables", new Object[0]), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                } else if (variableName.startsWith("_") && var.isFullQualified()) {
                    holder.registerProblem((PsiElement)var, PuppetBundle.message("inspections.deprecated.in.puppet4.underscore.in.variables", new Object[0]), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/lang/puppet/ide/inspections/Puppet4DeprecationsInspection$1", "visitVarWrapper"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/puppet/ide/inspections/Puppet4DeprecationsInspection", "buildVisitor"));
    }
}

