/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public final class ByteBufferUtil {
    private static final Logger LOG = Logger.getInstance(ByteBufferUtil.class);
    private static final MethodHandle cleanerHandle;
    private static final MethodHandle cleanerCleanHandle;

    public static boolean cleanBuffer(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            ByteBufferUtil.$$$reportNull$$$0(0);
        }
        if (!buffer.isDirect()) {
            return true;
        }
        try {
            Object cleaner = cleanerHandle.invoke(buffer);
            if (cleaner != null) {
                cleanerCleanHandle.invoke(cleaner);
                return true;
            }
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
        return false;
    }

    public static void copyMemory(@NotNull ByteBuffer src, int index, byte[] dst, int dstIndex, int length) {
        if (src == null) {
            ByteBufferUtil.$$$reportNull$$$0(1);
        }
        ByteBuffer buf = src.duplicate();
        buf.position(index);
        buf.get(dst, dstIndex, length);
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> directBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
            Class<?> cleanerClass = directBufferClass.getDeclaredMethod("cleaner", new Class[0]).getReturnType();
            cleanerHandle = lookup.findVirtual(directBufferClass, "cleaner", MethodType.methodType(cleanerClass));
            cleanerCleanHandle = lookup.findVirtual(cleanerClass, "clean", MethodType.methodType(Void.TYPE));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/ByteBufferUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanBuffer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "copyMemory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

