/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vite;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.InstallNodeModuleAddToDevDependenciesQuickFix;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.RunNpmUpdateQuickFix;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.vite.ViteBundle;
import com.intellij.vite.ViteConfigManager;
import com.intellij.vite.VitejsIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\r*\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vite/ViteEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "contextHelp", "", "Lcom/intellij/ui/EditorNotificationPanel;", "text", "", "getFixesForNotInstalledModule", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "moduleElement", "Lcom/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$ModuleElement;", "packageJsonFiles", "", "inPackageJson", "", "intellij.vitejs"})
@SourceDebugExtension(value={"SMAP\nViteEditorNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViteEditorNotificationProvider.kt\ncom/intellij/vite/ViteEditorNotificationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1761#2,3:96\n1869#2,2:99\n*S KotlinDebug\n*F\n+ 1 ViteEditorNotificationProvider.kt\ncom/intellij/vite/ViteEditorNotificationProvider\n*L\n42#1:96,3\n58#1:99,2\n*E\n"})
final class ViteEditorNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        boolean bl;
        Collection packageJsonFiles;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!ArraysKt.contains((Object[])ViteConfigManager.Companion.getVITE_FILENAMES(), (Object)file.getName())) {
                return null;
            }
            NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(project, file);
            if (finder.findInstalledPackage("vite") != null) {
                return null;
            }
            CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
            PackageJsonUtil.processUpPackageJsonFiles((Project)project, (VirtualFile)file, (Processor)((Processor)processor));
            Collection collection = processor.getResults();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResults(...)");
            packageJsonFiles = collection;
            Iterable $this$any$iv = packageJsonFiles;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!PackageJsonData.getOrCreate((VirtualFile)it).isDependencyOfAnyType("vite")) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean isDeclared = bl;
        return arg_0 -> ViteEditorNotificationProvider.collectNotificationData$lambda$1(project, file, this, packageJsonFiles, isDeclared, arg_0);
    }

    private final void contextHelp(EditorNotificationPanel $this$contextHelp, @Nls String text) {
        HyperlinkLabel hyperlinkLabel;
        HyperlinkLabel $this$contextHelp_u24lambda_u241 = hyperlinkLabel = $this$contextHelp.createActionLabel("", ViteEditorNotificationProvider::contextHelp$lambda$0);
        boolean bl = false;
        $this$contextHelp_u24lambda_u241.setIcon(AllIcons.General.ContextHelp);
        $this$contextHelp_u24lambda_u241.setUseIconAsLink(true);
        $this$contextHelp_u24lambda_u241.setToolTipText(text);
    }

    private final List<IntentionAction> getFixesForNotInstalledModule(InstallNodeModuleQuickFix.ModuleElement moduleElement, Collection<? extends VirtualFile> packageJsonFiles, boolean inPackageJson) {
        List fixes = new ArrayList();
        if (inPackageJson) {
            if (!packageJsonFiles.isEmpty()) {
                fixes.add(new RunNpmUpdateQuickFix(moduleElement, packageJsonFiles));
            }
        } else {
            fixes.add(new InstallNodeModuleQuickFix(moduleElement, packageJsonFiles));
            fixes.add(new InstallNodeModuleAddToDevDependenciesQuickFix(moduleElement, packageJsonFiles));
        }
        return fixes;
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$1(Project $project, VirtualFile $file, ViteEditorNotificationProvider this$0, Collection $packageJsonFiles, boolean $isDeclared, FileEditor fileEditor) {
        EditorNotificationPanel editorNotificationPanel;
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        EditorNotificationPanel $this$collectNotificationData_u24lambda_u241_u240 = editorNotificationPanel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
        boolean bl = false;
        Object[] objectArray = new Object[]{ViteBundle.message("vite.editor.notification.missing.package.error", new Object[0])};
        $this$collectNotificationData_u24lambda_u241_u240.text(ViteBundle.message("vite.editor.notification", objectArray));
        $this$collectNotificationData_u24lambda_u241_u240.icon(VitejsIcons.Vite);
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        Editor editor = textEditor != null ? textEditor.getEditor() : null;
        PsiFile psiFile = PsiManager.getInstance((Project)$project).findFile($file);
        if (editor != null && psiFile != null) {
            List<IntentionAction> actions2 = this$0.getFixesForNotInstalledModule(new InstallNodeModuleQuickFix.ModuleElement($project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public String getModuleName() {
                    return "vite";
                }

                public Project getProject() {
                    return this.$project;
                }
            }, $packageJsonFiles, $isDeclared);
            Iterable $this$forEach$iv = actions2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IntentionAction it = (IntentionAction)element$iv;
                boolean bl2 = false;
                $this$collectNotificationData_u24lambda_u241_u240.createActionLabel(it.getText(), () -> ViteEditorNotificationProvider.collectNotificationData$lambda$1$0$0$0(it, $project, editor, psiFile));
            }
        }
        Object[] objectArray2 = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)ApplicationNamesInfo.getInstance().getFullProductName(), (String)"getFullProductName(...)");
        Intrinsics.checkNotNullExpressionValue((Object)NpmManager.getInstance((Project)$project).getNpmInstallPresentableText(), (String)"getNpmInstallPresentableText(...)");
        this$0.contextHelp($this$collectNotificationData_u24lambda_u241_u240, ViteBundle.message("vite.editor.notification.missing.package.error.help", objectArray2));
        return editorNotificationPanel;
    }

    private static final void collectNotificationData$lambda$1$0$0$0(IntentionAction $it, Project $project, Editor $editor, PsiFile $psiFile) {
        $it.invoke($project, $editor, $psiFile);
    }

    private static final void contextHelp$lambda$0() {
        HelpManager.getInstance().invokeHelp("procedure.vite");
    }
}

